(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1808976,      45625]*)
(*NotebookOutlinePosition[   1809618,      45647]*)
(*  CellTagsIndexPosition[   1809574,      45643]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Plot3D[\(-x\)*Sin[Sqrt[Abs[x]]] - y*Sin[Sqrt[Abs[y]]], {x, \(-500\), 
        500}, {y, \(-500\), 500}, PlotPoints\  -> 150, Mesh -> False, 
      ViewPoint -> {3.808, \ \(-3.100\), \ 3.687}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81578 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.009576 1.00958 -0.0675089 1.00958 [
[.00739 .35294 -24 -6.60142 ]
[.00739 .35294 0 2.39858 ]
[.10507 .26996 -24 -6.68453 ]
[.10507 .26996 0 2.31547 ]
[.20779 .18269 -6 -6.77448 ]
[.20779 .18269 0 2.22552 ]
[.31596 .0908 -18 -6.87215 ]
[.31596 .0908 0 2.12785 ]
[.43002 -0.00609 -18 -6.9786 ]
[.43002 -0.00609 0 2.0214 ]
[.4507 -0.00816 0 -8.3183 ]
[.4507 -0.00816 24 .6817 ]
[.59452 .0712 0 -8.11488 ]
[.59452 .0712 24 .88512 ]
[.73224 .14719 0 -7.93204 ]
[.73224 .14719 6 1.06796 ]
[.86422 .22003 0 -7.7668 ]
[.86422 .22003 18 1.2332 ]
[.99083 .28991 0 -7.61675 ]
[.99083 .28991 18 1.38325 ]
[.99496 .33679 0 -7.57065 ]
[.99496 .33679 24 1.42935 ]
[1.00052 .39981 0 -7.50879 ]
[1.00052 .39981 6 1.49121 ]
[1.00621 .46427 0 -7.44568 ]
[1.00621 .46427 18 1.55432 ]
[ 0 0 0 0 ]
[ 1 .81578 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01882 .35828 m
.44107 0 L
s
.01882 .35828 m
.02454 .36095 L
s
[(-500)] .00739 .35294 1 .46698 Mshowa
.11642 .27547 m
.1221 .27823 L
s
[(-250)] .10507 .26996 1 .48545 Mshowa
.21905 .18839 m
.22468 .19123 L
s
[(0)] .20779 .18269 1 .50544 Mshowa
.32712 .09669 m
.3327 .09963 L
s
[(250)] .31596 .0908 1 .52715 Mshowa
.44107 0 m
.4466 .00304 L
s
[(500)] .43002 -0.00609 1 .5508 Mshowa
.125 Mabswid
.03796 .34205 m
.04138 .34366 L
s
.05728 .32565 m
.0607 .32727 L
s
.0768 .30909 m
.08021 .31072 L
s
.09651 .29237 m
.09992 .29401 L
s
.13653 .25841 m
.13993 .26007 L
s
.15685 .24117 m
.16024 .24284 L
s
.17737 .22375 m
.18076 .22544 L
s
.1981 .20616 m
.20149 .20786 L
s
.24022 .17043 m
.24359 .17215 L
s
.2616 .15228 m
.26497 .15401 L
s
.28321 .13394 m
.28658 .13569 L
s
.30505 .11541 m
.30841 .11717 L
s
.34943 .07776 m
.35277 .07954 L
s
.37197 .05863 m
.37531 .06042 L
s
.39476 .0393 m
.39809 .0411 L
s
.41779 .01976 m
.42111 .02157 L
s
.25 Mabswid
.44107 0 m
.98045 .29709 L
s
.44107 0 m
.43626 .00408 L
s
[(-500)] .4507 -0.00816 -1 .84851 Mshowa
.58468 .0791 m
.57977 .08305 L
s
[(-250)] .59452 .0712 -1 .80331 Mshowa
.7222 .15485 m
.71719 .15867 L
s
[(0)] .73224 .14719 -1 .76268 Mshowa
.85401 .22745 m
.84891 .23115 L
s
[(250)] .86422 .22003 -1 .72596 Mshowa
.98045 .29709 m
.97527 .30068 L
s
[(500)] .99083 .28991 -1 .69261 Mshowa
.125 Mabswid
.4703 .0161 m
.4674 .01853 L
s
.49927 .03206 m
.49636 .03447 L
s
.52799 .04788 m
.52507 .05028 L
s
.55646 .06356 m
.55352 .06594 L
s
.61266 .09451 m
.6097 .09687 L
s
.6404 .10979 m
.63743 .11213 L
s
.6679 .12494 m
.66492 .12726 L
s
.69517 .13996 m
.69217 .14227 L
s
.74901 .16961 m
.74599 .17189 L
s
.77559 .18425 m
.77256 .18652 L
s
.80195 .19877 m
.79891 .20102 L
s
.82809 .21317 m
.82504 .21541 L
s
.87972 .24161 m
.87664 .24382 L
s
.90521 .25565 m
.90213 .25784 L
s
.9305 .26958 m
.92741 .27176 L
s
.95558 .28339 m
.95248 .28556 L
s
.25 Mabswid
.98045 .29709 m
1 .52099 L
s
.98454 .3439 m
.97933 .34746 L
s
[(-500)] .99496 .33679 -1 .68237 Mshowa
.99003 .40683 m
.98479 .41034 L
s
[(0)] 1.00052 .39981 -1 .66862 Mshowa
.99565 .47119 m
.99037 .47464 L
s
[(500)] 1.00621 .46427 -1 .65459 Mshowa
.125 Mabswid
.98563 .35637 m
.9825 .3585 L
s
.98672 .3689 m
.98359 .37102 L
s
.98782 .38149 m
.98468 .3836 L
s
.98893 .39413 m
.98578 .39624 L
s
.99115 .41958 m
.988 .42168 L
s
.99227 .4324 m
.98911 .43449 L
s
.99339 .44527 m
.99023 .44735 L
s
.99452 .4582 m
.99136 .46028 L
s
.98346 .33148 m
.98033 .33362 L
s
.98238 .31912 m
.97926 .32126 L
s
.9813 .30681 m
.97819 .30896 L
s
.99679 .48423 m
.99362 .4863 L
s
.99794 .49734 m
.99476 .4994 L
s
.99909 .51051 m
.99591 .51256 L
s
.25 Mabswid
.01882 .35828 m
0 .58035 L
s
0 .58035 m
.54207 .81578 L
s
.54207 .81578 m
.54042 .60186 L
s
.54042 .60186 m
.01882 .35828 L
s
.44107 0 m
.98045 .29709 L
s
.98045 .29709 m
1 .52099 L
s
1 .52099 m
.43869 .23153 L
s
.43869 .23153 m
.44107 0 L
s
.01882 .35828 m
0 .58035 L
s
0 .58035 m
.43869 .23153 L
s
.43869 .23153 m
.44107 0 L
s
.44107 0 m
.01882 .35828 L
s
.54042 .60186 m
.98045 .29709 L
s
.98045 .29709 m
1 .52099 L
s
1 .52099 m
.54207 .81578 L
s
.54207 .81578 m
.54042 .60186 L
s
0 0 m
1 0 L
1 .81578 L
0 .81578 L
closepath
clip
newpath
0 0 .504 r
.53787 .6965 .54123 .7069 .54404 .71402 .54067 .70359 Mtetra
0 0 .488 r
.54067 .70359 .54404 .71402 .54686 .72129 .54348 .71082 Mtetra
0 0 .501 r
.54348 .71082 .54686 .72129 .5497 .72849 .5463 .718 Mtetra
0 0 .54 r
.5463 .718 .5497 .72849 .55254 .73542 .54913 .72489 Mtetra
0 .053 .592 r
.54913 .72489 .55254 .73542 .55539 .74186 .55197 .73131 Mtetra
.065 .148 .641 r
.55197 .73131 .55539 .74186 .55824 .74761 .55481 .73703 Mtetra
.205 .239 .676 r
.55481 .73703 .55824 .74761 .56109 .75249 .55766 .74189 Mtetra
.325 .315 .694 r
.55766 .74189 .56109 .75249 .56394 .75633 .5605 .7457 Mtetra
.42 .374 .701 r
.5605 .7457 .56394 .75633 .56679 .75898 .56334 .74834 Mtetra
.49 .417 .701 r
.56334 .74834 .56679 .75898 .56963 .76033 .56617 .74968 Mtetra
.543 .448 .697 r
.56617 .74968 .56963 .76033 .57245 .76031 .56899 .74965 Mtetra
.582 .471 .692 r
.56899 .74965 .57245 .76031 .57527 .75887 .5718 .7482 Mtetra
.611 .488 .687 r
.5718 .7482 .57527 .75887 .57806 .75602 .57459 .74535 Mtetra
.633 .5 .683 r
.57459 .74535 .57806 .75602 .58084 .75178 .57737 .74111 Mtetra
.65 .51 .679 r
.57737 .74111 .58084 .75178 .58361 .74625 .58013 .73558 Mtetra
.662 .517 .676 r
.58013 .73558 .58361 .74625 .58635 .73953 .58287 .72888 Mtetra
.672 .522 .673 r
.58287 .72888 .58635 .73953 .58908 .73179 .5856 .72115 Mtetra
.679 .526 .671 r
.5856 .72115 .58908 .73179 .59179 .7232 .58831 .71257 Mtetra
.684 .528 .669 r
.58831 .71257 .59179 .7232 .59449 .71399 .59101 .70337 Mtetra
.686 .53 .669 r
.59101 .70337 .59449 .71399 .59718 .70437 .5937 .69377 Mtetra
.688 .531 .668 r
.5937 .69377 .59718 .70437 .59986 .6946 .59638 .68402 Mtetra
.687 .53 .668 r
.59638 .68402 .59986 .6946 .60254 .68493 .59906 .67436 Mtetra
.685 .529 .669 r
.59906 .67436 .60254 .68493 .60522 .67559 .60174 .66504 Mtetra
.681 .527 .67 r
.60174 .66504 .60522 .67559 .60791 .66684 .60443 .6563 Mtetra
.674 .523 .672 r
.60443 .6563 .60791 .66684 .61062 .65888 .60713 .64836 Mtetra
.666 .518 .675 r
.60713 .64836 .61062 .65888 .61334 .65191 .60985 .6414 Mtetra
.654 .512 .678 r
.60985 .6414 .61334 .65191 .61608 .6461 .61259 .63559 Mtetra
.638 .503 .682 r
.61259 .63559 .61608 .6461 .61885 .64156 .61535 .63105 Mtetra
.617 .491 .686 r
.61535 .63105 .61885 .64156 .62164 .63837 .61815 .62787 Mtetra
.59 .476 .691 r
.61815 .62787 .62164 .63837 .62448 .63658 .62097 .62607 Mtetra
.555 .456 .696 r
.62097 .62607 .62448 .63658 .62734 .63615 .62383 .62563 Mtetra
.511 .43 .701 r
.62383 .62563 .62734 .63615 .63024 .63703 .62673 .6265 Mtetra
.457 .398 .703 r
.62673 .6265 .63024 .63703 .63318 .63909 .62965 .62854 Mtetra
.395 .36 .702 r
.62965 .62854 .63318 .63909 .63614 .64216 .63261 .63159 Mtetra
.332 .322 .698 r
.63261 .63159 .63614 .64216 .63914 .64603 .6356 .63544 Mtetra
.281 .29 .691 r
.6356 .63544 .63914 .64603 .64216 .65045 .63861 .63984 Mtetra
.253 .272 .687 r
.63861 .63984 .64216 .65045 .64519 .65514 .64163 .64451 Mtetra
.258 .275 .688 r
.64163 .64451 .64519 .65514 .64823 .6598 .64467 .64915 Mtetra
.294 .298 .693 r
.64467 .64915 .64823 .6598 .65128 .66414 .6477 .65346 Mtetra
.352 .334 .699 r
.6477 .65346 .65128 .66414 .65432 .66785 .65073 .65715 Mtetra
.416 .373 .703 r
.65073 .65715 .65432 .66785 .65734 .67067 .65375 .65995 Mtetra
.478 .41 .702 r
.65375 .65995 .65734 .67067 .66034 .67236 .65674 .66163 Mtetra
.529 .44 .699 r
.65674 .66163 .66034 .67236 .66331 .67276 .65971 .66201 Mtetra
.571 .464 .694 r
.65971 .66201 .66331 .67276 .66625 .67175 .66264 .661 Mtetra
.602 .482 .689 r
.66264 .661 .66625 .67175 .66915 .66931 .66553 .65855 Mtetra
.626 .496 .684 r
.66553 .65855 .66915 .66931 .67201 .66548 .66839 .65473 Mtetra
.643 .505 .68 r
.66839 .65473 .67201 .66548 .67484 .66041 .67121 .64966 Mtetra
.655 .512 .677 r
.67121 .64966 .67484 .66041 .67763 .6543 .674 .64356 Mtetra
.662 .516 .675 r
.674 .64356 .67763 .6543 .68041 .64745 .67677 .63671 Mtetra
.666 .518 .674 r
.67677 .63671 .68041 .64745 .68316 .64019 .67953 .62946 Mtetra
.667 .518 .674 r
.67953 .62946 .68316 .64019 .68592 .63289 .68228 .62218 Mtetra
.663 .517 .675 r
.68228 .62218 .68592 .63289 .68868 .62595 .68504 .61524 Mtetra
.656 .513 .677 r
.68504 .61524 .68868 .62595 .69147 .61971 .68783 .60902 Mtetra
.644 .506 .68 r
.68783 .60902 .69147 .61971 .69429 .61451 .69064 .60381 Mtetra
.627 .497 .684 r
.69064 .60381 .69429 .61451 .69715 .61057 .6935 .59987 Mtetra
.604 .483 .689 r
.6935 .59987 .69715 .61057 .70007 .60803 .69642 .59733 Mtetra
.573 .466 .694 r
.69642 .59733 .70007 .60803 .70304 .60692 .69938 .59621 Mtetra
.536 .445 .699 r
.69938 .59621 .70304 .60692 .70606 .60711 .70239 .5964 Mtetra
.498 .423 .702 r
.70239 .5964 .70606 .60711 .70913 .60836 .70545 .59763 Mtetra
.468 .405 .703 r
.70545 .59763 .70913 .60836 .71222 .61029 .70854 .59955 Mtetra
.458 .399 .704 r
.70854 .59955 .71222 .61029 .71534 .61244 .71165 .60168 Mtetra
.473 .408 .703 r
.71165 .60168 .71534 .61244 .71845 .61428 .71475 .60351 Mtetra
.507 .428 .701 r
.71475 .60351 .71845 .61428 .72154 .61532 .71783 .60453 Mtetra
.547 .451 .697 r
.71783 .60453 .72154 .61532 .72458 .61515 .72087 .60435 Mtetra
.584 .472 .692 r
.72087 .60435 .72458 .61515 .72758 .61353 .72386 .60272 Mtetra
.612 .488 .687 r
.72386 .60272 .72758 .61353 .73052 .61045 .7268 .59965 Mtetra
.63 .498 .683 r
.7268 .59965 .73052 .61045 .73342 .60622 .7297 .59542 Mtetra
.638 .503 .681 r
.7297 .59542 .73342 .60622 .7363 .60139 .73257 .59059 Mtetra
.636 .502 .682 r
.73257 .59059 .7363 .60139 .73918 .59673 .73545 .58593 Mtetra
.623 .494 .685 r
.73545 .58593 .73918 .59673 .7421 .59301 .73837 .58221 Mtetra
.597 .479 .69 r
.73837 .58221 .7421 .59301 .74509 .59078 .74135 .57998 Mtetra
.564 .461 .695 r
.74135 .57998 .74509 .59078 .74815 .58999 .7444 .57918 Mtetra
.552 .454 .697 r
.7444 .57918 .74815 .58999 .75123 .58967 .74748 .57884 Mtetra
.582 .471 .693 r
.74748 .57884 .75123 .58967 .75427 .58811 .7505 .57728 Mtetra
.607 .485 .688 r
.7505 .57728 .75427 .58811 .75725 .5853 .75348 .57447 Mtetra
.582 .471 .693 r
.75348 .57447 .75725 .5853 .76029 .58374 .75651 .5729 Mtetra
.552 .454 .697 r
.75651 .5729 .76029 .58374 .76339 .58341 .75961 .57256 Mtetra
.564 .461 .695 r
.75961 .57256 .76339 .58341 .76648 .58261 .76269 .57175 Mtetra
.597 .479 .69 r
.76269 .57175 .76648 .58261 .7695 .58036 .76571 .5695 Mtetra
.622 .494 .685 r
.76571 .5695 .7695 .58036 .77246 .57661 .76866 .56575 Mtetra
.636 .501 .681 r
.76866 .56575 .77246 .57661 .77537 .5719 .77157 .56105 Mtetra
.638 .502 .681 r
.77157 .56105 .77537 .5719 .77827 .56703 .77447 .55617 Mtetra
.63 .498 .683 r
.77447 .55617 .77827 .56703 .78121 .56275 .7774 .5519 Mtetra
.612 .488 .687 r
.7774 .5519 .78121 .56275 .7842 .55963 .78039 .54877 Mtetra
.585 .473 .692 r
.78039 .54877 .7842 .55963 .78727 .55794 .78346 .54708 Mtetra
.549 .453 .698 r
.78346 .54708 .78727 .55794 .79042 .55771 .7866 .54684 Mtetra
.51 .43 .702 r
.7866 .54684 .79042 .55771 .79364 .5587 .78981 .54782 Mtetra
.478 .412 .704 r
.78981 .54782 .79364 .5587 .79691 .56051 .79306 .5496 Mtetra
.464 .403 .704 r
.79306 .5496 .79691 .56051 .8002 .56262 .79635 .55171 Mtetra
.474 .409 .704 r
.79635 .55171 .8002 .56262 .80349 .56454 .79963 .5536 Mtetra
.502 .425 .702 r
.79963 .5536 .80349 .56454 .80675 .56577 .80288 .55482 Mtetra
.538 .446 .699 r
.80288 .55482 .80675 .56577 .80996 .56592 .80609 .55496 Mtetra
.573 .466 .694 r
.80609 .55496 .80996 .56592 .81311 .56475 .80922 .55378 Mtetra
.603 .483 .689 r
.80922 .55378 .81311 .56475 .81618 .56211 .81229 .55114 Mtetra
.626 .496 .684 r
.81229 .55114 .81618 .56211 .81917 .55803 .81528 .54705 Mtetra
.643 .505 .679 r
.81528 .54705 .81917 .55803 .82209 .55265 .8182 .54168 Mtetra
.655 .511 .676 r
.8182 .54168 .82209 .55265 .82495 .54622 .82106 .53526 Mtetra
.662 .515 .674 r
.82106 .53526 .82495 .54622 .82778 .53907 .82388 .52813 Mtetra
.665 .517 .673 r
.82388 .52813 .82778 .53907 .83058 .53158 .82667 .52065 Mtetra
.82667 .52065 .83058 .53158 .83338 .52413 .82947 .51321 Mtetra
.661 .515 .674 r
.82947 .51321 .83338 .52413 .8362 .5171 .8323 .50618 Mtetra
.654 .511 .676 r
.8323 .50618 .8362 .5171 .83907 .51082 .83516 .49991 Mtetra
.642 .504 .68 r
.83516 .49991 .83907 .51082 .842 .50558 .83809 .49467 Mtetra
.625 .495 .684 r
.83809 .49467 .842 .50558 .845 .50158 .84109 .49068 Mtetra
.602 .483 .689 r
.84109 .49068 .845 .50158 .8481 .49897 .84417 .48806 Mtetra
.573 .466 .695 r
.84417 .48806 .8481 .49897 .85128 .49778 .84735 .48687 Mtetra
.536 .445 .7 r
.84735 .48687 .85128 .49778 .85456 .49801 .85062 .48708 Mtetra
.491 .42 .704 r
.85062 .48708 .85456 .49801 .85793 .49954 .85398 .4886 Mtetra
.44 .39 .706 r
.85398 .4886 .85793 .49954 .86138 .50222 .85742 .49126 Mtetra
.389 .36 .706 r
.85742 .49126 .86138 .50222 .86489 .50582 .86093 .49483 Mtetra
.346 .334 .703 r
.86093 .49483 .86489 .50582 .86846 .51008 .86449 .49907 Mtetra
.319 .318 .701 r
.86449 .49907 .86846 .51008 .87207 .51471 .86808 .50368 Mtetra
.316 .316 .701 r
.86808 .50368 .87207 .51471 .87569 .51941 .8717 .50835 Mtetra
.336 .328 .703 r
.8717 .50835 .87569 .51941 .87931 .52385 .8753 .51277 Mtetra
.374 .351 .705 r
.8753 .51277 .87931 .52385 .88291 .52776 .87889 .51665 Mtetra
.422 .38 .706 r
.87889 .51665 .88291 .52776 .88646 .53085 .88243 .51973 Mtetra
.472 .409 .705 r
.88243 .51973 .88646 .53085 .88995 .5329 .88591 .52176 Mtetra
.518 .435 .702 r
.88591 .52176 .88995 .5329 .89337 .53372 .88932 .52256 Mtetra
.557 .457 .697 r
.88932 .52256 .89337 .53372 .8967 .53317 .89264 .52199 Mtetra
.589 .475 .691 r
.89264 .52199 .8967 .53317 .89993 .53116 .89587 .51999 Mtetra
.615 .489 .686 r
.89587 .51999 .89993 .53116 .90306 .52769 .899 .51651 Mtetra
.635 .5 .681 r
.899 .51651 .90306 .52769 .9061 .52278 .90203 .51161 Mtetra
.651 .509 .676 r
.90203 .51161 .9061 .52278 .90904 .51653 .90497 .50536 Mtetra
.663 .515 .673 r
.90497 .50536 .90904 .51653 .91189 .50907 .90782 .49791 Mtetra
.672 .52 .67 r
.90782 .49791 .91189 .50907 .91467 .50058 .91059 .48943 Mtetra
.679 .523 .668 r
.91059 .48943 .91467 .50058 .91739 .49127 .91331 .48014 Mtetra
.683 .525 .666 r
.91331 .48014 .91739 .49127 .92005 .48138 .91597 .47027 Mtetra
.685 .527 .665 r
.91597 .47027 .92005 .48138 .92269 .47117 .91861 .46008 Mtetra
.686 .527 .665 r
.91861 .46008 .92269 .47117 .92532 .46089 .92124 .44982 Mtetra
.685 .526 .666 r
.92124 .44982 .92532 .46089 .92796 .45079 .92388 .43974 Mtetra
.682 .525 .667 r
.92388 .43974 .92796 .45079 .93062 .44113 .92654 .4301 Mtetra
.677 .522 .668 r
.92654 .4301 .93062 .44113 .93333 .43213 .92926 .42111 Mtetra
.67 .519 .671 r
.92926 .42111 .93333 .43213 .93611 .424 .93203 .41299 Mtetra
.66 .514 .674 r
.93203 .41299 .93611 .424 .93897 .41691 .93488 .40592 Mtetra
.648 .507 .678 r
.93488 .40592 .93897 .41691 .94191 .41102 .93783 .40003 Mtetra
.631 .498 .682 r
.93783 .40003 .94191 .41102 .94496 .40642 .94087 .39543 Mtetra
.611 .487 .687 r
.94087 .39543 .94496 .40642 .94813 .4032 .94403 .39222 Mtetra
.585 .473 .693 r
.94403 .39222 .94813 .4032 .95141 .4014 .9473 .39041 Mtetra
.552 .455 .698 r
.9473 .39041 .95141 .4014 .95481 .40102 .9507 .39002 Mtetra
.512 .433 .703 r
.9507 .39002 .95481 .40102 .95833 .40203 .95421 .39101 Mtetra
.462 .404 .707 r
.95421 .39101 .95833 .40203 .96197 .40435 .95784 .39331 Mtetra
.403 .37 .708 r
.95784 .39331 .96197 .40435 .96572 .40789 .96158 .39683 Mtetra
.336 .33 .705 r
.96158 .39683 .96572 .40789 .96957 .41252 .96542 .40144 Mtetra
.264 .287 .698 r
.96542 .40144 .96957 .41252 .97351 .41809 .96935 .40697 Mtetra
.196 .245 .687 r
.96935 .40697 .97351 .41809 .97753 .42441 .97336 .41326 Mtetra
.138 .21 .676 r
.97336 .41326 .97753 .42441 .98162 .43129 .97743 .42011 Mtetra
.101 .186 .667 r
.97743 .42011 .98162 .43129 .98575 .43853 .98154 .42731 Mtetra
.089 .179 .664 r
.98154 .42731 .98575 .43853 .98991 .44589 .98569 .43464 Mtetra
.104 .188 .668 r
.98569 .43464 .98991 .44589 .99408 .45317 .98984 .44189 Mtetra
0 0 .513 r
.53451 .68599 .53787 .6965 .54067 .70359 .5373 .69305 Mtetra
0 0 .497 r
.5373 .69305 .54067 .70359 .54348 .71082 .5401 .70026 Mtetra
0 0 .51 r
.5401 .70026 .54348 .71082 .5463 .718 .54291 .7074 Mtetra
0 0 .547 r
.54291 .7074 .5463 .718 .54913 .72489 .54573 .71427 Mtetra
0 .062 .596 r
.54573 .71427 .54913 .72489 .55197 .73131 .54856 .72066 Mtetra
.076 .154 .643 r
.54856 .72066 .55197 .73131 .55481 .73703 .5514 .72636 Mtetra
.213 .243 .676 r
.5514 .72636 .55481 .73703 .55766 .74189 .55423 .73119 Mtetra
.329 .317 .694 r
.55423 .73119 .55766 .74189 .5605 .7457 .55707 .73498 Mtetra
.421 .374 .7 r
.55707 .73498 .5605 .7457 .56334 .74834 .5599 .7376 Mtetra
.491 .416 .7 r
.5599 .7376 .56334 .74834 .56617 .74968 .56272 .73893 Mtetra
.543 .447 .696 r
.56272 .73893 .56617 .74968 .56899 .74965 .56554 .73889 Mtetra
.582 .47 .691 r
.56554 .73889 .56899 .74965 .5718 .7482 .56834 .73744 Mtetra
.611 .487 .687 r
.56834 .73744 .5718 .7482 .57459 .74535 .57113 .73458 Mtetra
.633 .499 .682 r
.57113 .73458 .57459 .74535 .57737 .74111 .5739 .73034 Mtetra
.649 .509 .678 r
.5739 .73034 .57737 .74111 .58013 .73558 .57666 .72482 Mtetra
.662 .516 .675 r
.57666 .72482 .58013 .73558 .58287 .72888 .5794 .71812 Mtetra
.671 .521 .673 r
.5794 .71812 .58287 .72888 .5856 .72115 .58212 .7104 Mtetra
.678 .525 .671 r
.58212 .7104 .5856 .72115 .58831 .71257 .58483 .70185 Mtetra
.683 .528 .669 r
.58483 .70185 .58831 .71257 .59101 .70337 .58753 .69266 Mtetra
.686 .529 .668 r
.58753 .69266 .59101 .70337 .5937 .69377 .59022 .68308 Mtetra
.687 .53 .668 r
.59022 .68308 .5937 .69377 .59638 .68402 .5929 .67334 Mtetra
.686 .53 .668 r
.5929 .67334 .59638 .68402 .59906 .67436 .59558 .6637 Mtetra
.684 .528 .669 r
.59558 .6637 .59906 .67436 .60174 .66504 .59826 .6544 Mtetra
.68 .526 .67 r
.59826 .6544 .60174 .66504 .60443 .6563 .60095 .64567 Mtetra
.674 .523 .672 r
.60095 .64567 .60443 .6563 .60713 .64836 .60365 .63774 Mtetra
.665 .518 .675 r
.60365 .63774 .60713 .64836 .60985 .6414 .60636 .63079 Mtetra
.653 .511 .678 r
.60636 .63079 .60985 .6414 .61259 .63559 .6091 .62499 Mtetra
.637 .502 .681 r
.6091 .62499 .61259 .63559 .61535 .63105 .61186 .62045 Mtetra
.617 .491 .686 r
.61186 .62045 .61535 .63105 .61815 .62787 .61465 .61727 Mtetra
.59 .475 .691 r
.61465 .61727 .61815 .62787 .62097 .62607 .61747 .61546 Mtetra
.555 .455 .696 r
.61747 .61546 .62097 .62607 .62383 .62563 .62033 .61502 Mtetra
.512 .429 .7 r
.62033 .61502 .62383 .62563 .62673 .6265 .62321 .61587 Mtetra
.458 .398 .702 r
.62321 .61587 .62673 .6265 .62965 .62854 .62613 .6179 Mtetra
.398 .361 .701 r
.62613 .6179 .62965 .62854 .63261 .63159 .62908 .62093 Mtetra
.336 .323 .697 r
.62908 .62093 .63261 .63159 .6356 .63544 .63206 .62476 Mtetra
.286 .292 .691 r
.63206 .62476 .6356 .63544 .63861 .63984 .63506 .62913 Mtetra
.259 .275 .687 r
.63506 .62913 .63861 .63984 .64163 .64451 .63808 .63378 Mtetra
.263 .278 .688 r
.63808 .63378 .64163 .64451 .64467 .64915 .6411 .6384 Mtetra
.299 .3 .692 r
.6411 .6384 .64467 .64915 .6477 .65346 .64413 .64268 Mtetra
.355 .335 .698 r
.64413 .64268 .6477 .65346 .65073 .65715 .64715 .64635 Mtetra
.418 .373 .701 r
.64715 .64635 .65073 .65715 .65375 .65995 .65016 .64913 Mtetra
.478 .41 .701 r
.65016 .64913 .65375 .65995 .65674 .66163 .65314 .6508 Mtetra
.53 .44 .698 r
.65314 .6508 .65674 .66163 .65971 .66201 .6561 .65117 Mtetra
.57 .464 .693 r
.6561 .65117 .65971 .66201 .66264 .661 .65903 .65015 Mtetra
.601 .482 .688 r
.65903 .65015 .66264 .661 .66553 .65855 .66192 .6477 Mtetra
.625 .495 .684 r
.66192 .6477 .66553 .65855 .66839 .65473 .66477 .64387 Mtetra
.642 .504 .68 r
.66477 .64387 .66839 .65473 .67121 .64966 .66759 .63881 Mtetra
.654 .511 .677 r
.66759 .63881 .67121 .64966 .674 .64356 .67038 .63272 Mtetra
.662 .515 .675 r
.67038 .63272 .674 .64356 .67677 .63671 .67314 .62588 Mtetra
.665 .517 .674 r
.67314 .62588 .67677 .63671 .67953 .62946 .6759 .61864 Mtetra
.666 .518 .673 r
.6759 .61864 .67953 .62946 .68228 .62218 .67865 .61137 Mtetra
.663 .516 .674 r
.67865 .61137 .68228 .62218 .68504 .61524 .68141 .60444 Mtetra
.655 .512 .676 r
.68141 .60444 .68504 .61524 .68783 .60902 .68419 .59822 Mtetra
.644 .505 .679 r
.68419 .59822 .68783 .60902 .69064 .60381 .687 .59302 Mtetra
.627 .496 .683 r
.687 .59302 .69064 .60381 .6935 .59987 .68986 .58909 Mtetra
.603 .483 .688 r
.68986 .58909 .6935 .59987 .69642 .59733 .69277 .58654 Mtetra
.573 .465 .693 r
.69277 .58654 .69642 .59733 .69938 .59621 .69572 .58542 Mtetra
.536 .444 .698 r
.69572 .58542 .69938 .59621 .70239 .5964 .69873 .58559 Mtetra
.499 .422 .701 r
.69873 .58559 .70239 .5964 .70545 .59763 .70178 .58681 Mtetra
.469 .405 .702 r
.70178 .58681 .70545 .59763 .70854 .59955 .70486 .58871 Mtetra
.459 .399 .703 r
.70486 .58871 .70854 .59955 .71165 .60168 .70796 .59082 Mtetra
.474 .408 .702 r
.70796 .59082 .71165 .60168 .71475 .60351 .71106 .59263 Mtetra
.507 .427 .7 r
.71106 .59263 .71475 .60351 .71783 .60453 .71413 .59365 Mtetra
.547 .451 .697 r
.71413 .59365 .71783 .60453 .72087 .60435 .71716 .59345 Mtetra
.584 .472 .691 r
.71716 .59345 .72087 .60435 .72386 .60272 .72015 .59182 Mtetra
.612 .487 .686 r
.72015 .59182 .72386 .60272 .7268 .59965 .72308 .58874 Mtetra
.63 .497 .682 r
.72308 .58874 .7268 .59965 .7297 .59542 .72597 .58451 Mtetra
.638 .502 .681 r
.72597 .58451 .7297 .59542 .73257 .59059 .72884 .57969 Mtetra
.636 .501 .681 r
.72884 .57969 .73257 .59059 .73545 .58593 .73172 .57503 Mtetra
.622 .493 .684 r
.73172 .57503 .73545 .58593 .73837 .58221 .73463 .57131 Mtetra
.596 .479 .689 r
.73463 .57131 .73837 .58221 .74135 .57998 .73761 .56908 Mtetra
.564 .46 .695 r
.73761 .56908 .74135 .57998 .7444 .57918 .74065 .56827 Mtetra
.552 .453 .696 r
.74065 .56827 .7444 .57918 .74748 .57884 .74372 .56793 Mtetra
.582 .471 .692 r
.74372 .56793 .74748 .57884 .7505 .57728 .74674 .56636 Mtetra
.607 .485 .687 r
.74674 .56636 .7505 .57728 .75348 .57447 .74971 .56354 Mtetra
.582 .471 .692 r
.74971 .56354 .75348 .57447 .75651 .5729 .75274 .56197 Mtetra
.552 .453 .696 r
.75274 .56197 .75651 .5729 .75961 .57256 .75583 .56162 Mtetra
.564 .46 .695 r
.75583 .56162 .75961 .57256 .76269 .57175 .7589 .5608 Mtetra
.596 .478 .689 r
.7589 .5608 .76269 .57175 .76571 .5695 .76192 .55854 Mtetra
.622 .493 .684 r
.76192 .55854 .76571 .5695 .76866 .56575 .76486 .55479 Mtetra
.635 .5 .681 r
.76486 .55479 .76866 .56575 .77157 .56105 .76777 .55009 Mtetra
.637 .502 .68 r
.76777 .55009 .77157 .56105 .77447 .55617 .77067 .54522 Mtetra
.629 .497 .682 r
.77067 .54522 .77447 .55617 .7774 .5519 .7736 .54095 Mtetra
.612 .487 .686 r
.7736 .54095 .7774 .5519 .78039 .54877 .77658 .53782 Mtetra
.584 .472 .692 r
.77658 .53782 .78039 .54877 .78346 .54708 .77964 .53613 Mtetra
.549 .452 .697 r
.77964 .53613 .78346 .54708 .7866 .54684 .78277 .53588 Mtetra
.51 .43 .701 r
.78277 .53588 .7866 .54684 .78981 .54782 .78597 .53684 Mtetra
.479 .411 .703 r
.78597 .53684 .78981 .54782 .79306 .5496 .78922 .53861 Mtetra
.465 .403 .703 r
.78922 .53861 .79306 .5496 .79635 .55171 .7925 .54069 Mtetra
.475 .409 .703 r
.7925 .54069 .79635 .55171 .79963 .5536 .79577 .54257 Mtetra
.502 .425 .701 r
.79577 .54257 .79963 .5536 .80288 .55482 .79902 .54377 Mtetra
.538 .445 .698 r
.79902 .54377 .80288 .55482 .80609 .55496 .80221 .54391 Mtetra
.573 .465 .693 r
.80221 .54391 .80609 .55496 .80922 .55378 .80534 .54271 Mtetra
.602 .482 .688 r
.80534 .54271 .80922 .55378 .81229 .55114 .8084 .54007 Mtetra
.625 .495 .683 r
.8084 .54007 .81229 .55114 .81528 .54705 .81139 .53599 Mtetra
.642 .504 .679 r
.81139 .53599 .81528 .54705 .8182 .54168 .8143 .53062 Mtetra
.654 .51 .676 r
.8143 .53062 .8182 .54168 .82106 .53526 .81716 .52421 Mtetra
.661 .514 .674 r
.81716 .52421 .82106 .53526 .82388 .52813 .81998 .51708 Mtetra
.665 .516 .673 r
.81998 .51708 .82388 .52813 .82667 .52065 .82277 .50961 Mtetra
.664 .516 .673 r
.82277 .50961 .82667 .52065 .82947 .51321 .82557 .50218 Mtetra
.66 .514 .674 r
.82557 .50218 .82947 .51321 .8323 .50618 .82839 .49517 Mtetra
.653 .51 .676 r
.82839 .49517 .8323 .50618 .83516 .49991 .83125 .48891 Mtetra
.641 .503 .679 r
.83125 .48891 .83516 .49991 .83809 .49467 .83417 .48367 Mtetra
.624 .494 .683 r
.83417 .48367 .83809 .49467 .84109 .49068 .83717 .47968 Mtetra
.602 .482 .688 r
.83717 .47968 .84109 .49068 .84417 .48806 .84025 .47705 Mtetra
.573 .465 .694 r
.84025 .47705 .84417 .48806 .84735 .48687 .84342 .47585 Mtetra
.536 .445 .699 r
.84342 .47585 .84735 .48687 .85062 .48708 .84669 .47605 Mtetra
.492 .419 .703 r
.84669 .47605 .85062 .48708 .85398 .4886 .85004 .47756 Mtetra
.442 .39 .705 r
.85004 .47756 .85398 .4886 .85742 .49126 .85347 .48019 Mtetra
.392 .361 .705 r
.85347 .48019 .85742 .49126 .86093 .49483 .85696 .48375 Mtetra
.349 .335 .702 r
.85696 .48375 .86093 .49483 .86449 .49907 .86051 .48797 Mtetra
.323 .319 .7 r
.86051 .48797 .86449 .49907 .86808 .50368 .8641 .49255 Mtetra
.32 .317 .7 r
.8641 .49255 .86808 .50368 .8717 .50835 .8677 .49719 Mtetra
.339 .329 .702 r
.8677 .49719 .8717 .50835 .8753 .51277 .8713 .50159 Mtetra
.377 .352 .704 r
.8713 .50159 .8753 .51277 .87889 .51665 .87487 .50545 Mtetra
.424 .38 .705 r
.87487 .50545 .87889 .51665 .88243 .51973 .8784 .5085 Mtetra
.473 .408 .704 r
.8784 .5085 .88243 .51973 .88591 .52176 .88187 .51051 Mtetra
.518 .434 .701 r
.88187 .51051 .88591 .52176 .88932 .52256 .88527 .5113 Mtetra
.557 .456 .696 r
.88527 .5113 .88932 .52256 .89264 .52199 .88858 .51073 Mtetra
.589 .474 .691 r
.88858 .51073 .89264 .52199 .89587 .51999 .89181 .50871 Mtetra
.614 .488 .685 r
.89181 .50871 .89587 .51999 .899 .51651 .89493 .50524 Mtetra
.634 .499 .68 r
.89493 .50524 .899 .51651 .90203 .51161 .89796 .50034 Mtetra
.65 .508 .676 r
.89796 .50034 .90203 .51161 .90497 .50536 .90089 .4941 Mtetra
.662 .514 .673 r
.90089 .4941 .90497 .50536 .90782 .49791 .90374 .48666 Mtetra
.671 .519 .67 r
.90374 .48666 .90782 .49791 .91059 .48943 .90652 .47819 Mtetra
.678 .522 .667 r
.90652 .47819 .91059 .48943 .91331 .48014 .90923 .46892 Mtetra
.682 .525 .666 r
.90923 .46892 .91331 .48014 .91597 .47027 .9119 .45907 Mtetra
.685 .526 .665 r
.9119 .45907 .91597 .47027 .91861 .46008 .91453 .44889 Mtetra
.91453 .44889 .91861 .46008 .92124 .44982 .91716 .43865 Mtetra
.684 .526 .665 r
.91716 .43865 .92124 .44982 .92388 .43974 .9198 .42859 Mtetra
.681 .524 .666 r
.9198 .42859 .92388 .43974 .92654 .4301 .92247 .41897 Mtetra
.676 .521 .668 r
.92247 .41897 .92654 .4301 .92926 .42111 .92518 .41 Mtetra
.669 .518 .67 r
.92518 .41 .92926 .42111 .93203 .41299 .92795 .40189 Mtetra
.659 .513 .673 r
.92795 .40189 .93203 .41299 .93488 .40592 .9308 .39483 Mtetra
.647 .506 .677 r
.9308 .39483 .93488 .40592 .93783 .40003 .93374 .38894 Mtetra
.631 .497 .682 r
.93374 .38894 .93783 .40003 .94087 .39543 .93678 .38435 Mtetra
.61 .486 .687 r
.93678 .38435 .94087 .39543 .94403 .39222 .93993 .38113 Mtetra
.585 .472 .692 r
.93993 .38113 .94403 .39222 .9473 .39041 .9432 .37932 Mtetra
.552 .455 .697 r
.9432 .37932 .9473 .39041 .9507 .39002 .94659 .37892 Mtetra
.512 .432 .702 r
.94659 .37892 .9507 .39002 .95421 .39101 .95009 .37989 Mtetra
.463 .404 .706 r
.95009 .37989 .95421 .39101 .95784 .39331 .95371 .38218 Mtetra
.405 .371 .707 r
.95371 .38218 .95784 .39331 .96158 .39683 .95743 .38567 Mtetra
.339 .332 .704 r
.95743 .38567 .96158 .39683 .96542 .40144 .96126 .39025 Mtetra
.27 .29 .698 r
.96126 .39025 .96542 .40144 .96935 .40697 .96518 .39576 Mtetra
.202 .248 .687 r
.96518 .39576 .96935 .40697 .97336 .41326 .96918 .40202 Mtetra
.147 .214 .676 r
.96918 .40202 .97336 .41326 .97743 .42011 .97323 .40883 Mtetra
.11 .191 .668 r
.97323 .40883 .97743 .42011 .98154 .42731 .97734 .416 Mtetra
.098 .184 .665 r
.97734 .416 .98154 .42731 .98569 .43464 .98147 .4233 Mtetra
.113 .193 .669 r
.98147 .4233 .98569 .43464 .98984 .44189 .98561 .43051 Mtetra
0 0 .506 r
.53116 .6756 .53451 .68599 .5373 .69305 .53394 .68263 Mtetra
0 0 .49 r
.53394 .68263 .5373 .69305 .5401 .70026 .53673 .68981 Mtetra
0 0 .503 r
.53673 .68981 .5401 .70026 .54291 .7074 .53953 .69692 Mtetra
0 0 .541 r
.53953 .69692 .54291 .7074 .54573 .71427 .54234 .70376 Mtetra
0 .055 .593 r
.54234 .70376 .54573 .71427 .54856 .72066 .54516 .71012 Mtetra
.067 .149 .642 r
.54516 .71012 .54856 .72066 .5514 .72636 .54799 .7158 Mtetra
.207 .24 .676 r
.54799 .7158 .5514 .72636 .55423 .73119 .55081 .72061 Mtetra
.326 .316 .694 r
.55081 .72061 .55423 .73119 .55707 .73498 .55364 .72438 Mtetra
.42 .374 .701 r
.55364 .72438 .55707 .73498 .5599 .7376 .55646 .72698 Mtetra
.491 .417 .7 r
.55646 .72698 .5599 .7376 .56272 .73893 .55928 .72829 Mtetra
.543 .448 .697 r
.55928 .72829 .56272 .73893 .56554 .73889 .56209 .72824 Mtetra
.582 .471 .692 r
.56209 .72824 .56554 .73889 .56834 .73744 .56489 .72679 Mtetra
.611 .487 .687 r
.56489 .72679 .56834 .73744 .57113 .73458 .56767 .72392 Mtetra
.633 .5 .683 r
.56767 .72392 .57113 .73458 .5739 .73034 .57044 .71969 Mtetra
.65 .509 .679 r
.57044 .71969 .5739 .73034 .57666 .72482 .57319 .71418 Mtetra
.662 .517 .676 r
.57319 .71418 .57666 .72482 .5794 .71812 .57593 .70749 Mtetra
.672 .522 .673 r
.57593 .70749 .5794 .71812 .58212 .7104 .57865 .69978 Mtetra
.679 .526 .671 r
.57865 .69978 .58212 .7104 .58483 .70185 .58136 .69124 Mtetra
.683 .528 .669 r
.58136 .69124 .58483 .70185 .58753 .69266 .58406 .68207 Mtetra
.686 .53 .669 r
.58406 .68207 .58753 .69266 .59022 .68308 .58675 .6725 Mtetra
.687 .53 .668 r
.58675 .6725 .59022 .68308 .5929 .67334 .58943 .66278 Mtetra
.58943 .66278 .5929 .67334 .59558 .6637 .59211 .65316 Mtetra
.685 .529 .669 r
.59211 .65316 .59558 .6637 .59826 .6544 .59479 .64387 Mtetra
.68 .527 .67 r
.59479 .64387 .59826 .6544 .60095 .64567 .59748 .63516 Mtetra
.674 .523 .672 r
.59748 .63516 .60095 .64567 .60365 .63774 .60017 .62724 Mtetra
.665 .518 .675 r
.60017 .62724 .60365 .63774 .60636 .63079 .60289 .6203 Mtetra
.654 .512 .678 r
.60289 .6203 .60636 .63079 .6091 .62499 .60562 .6145 Mtetra
.638 .503 .682 r
.60562 .6145 .6091 .62499 .61186 .62045 .60838 .60997 Mtetra
.617 .491 .686 r
.60838 .60997 .61186 .62045 .61465 .61727 .61117 .60678 Mtetra
.59 .476 .691 r
.61117 .60678 .61465 .61727 .61747 .61546 .61398 .60497 Mtetra
.555 .456 .696 r
.61398 .60497 .61747 .61546 .62033 .61502 .61683 .60452 Mtetra
.511 .43 .7 r
.61683 .60452 .62033 .61502 .62321 .61587 .61971 .60536 Mtetra
.457 .398 .703 r
.61971 .60536 .62321 .61587 .62613 .6179 .62262 .60737 Mtetra
.396 .36 .702 r
.62262 .60737 .62613 .6179 .62908 .62093 .62556 .61038 Mtetra
.333 .322 .697 r
.62556 .61038 .62908 .62093 .63206 .62476 .62853 .61419 Mtetra
.282 .29 .691 r
.62853 .61419 .63206 .62476 .63506 .62913 .63152 .61855 Mtetra
.254 .273 .687 r
.63152 .61855 .63506 .62913 .63808 .63378 .63453 .62317 Mtetra
.259 .276 .688 r
.63453 .62317 .63808 .63378 .6411 .6384 .63755 .62776 Mtetra
.295 .298 .693 r
.63755 .62776 .6411 .6384 .64413 .64268 .64056 .63203 Mtetra
.352 .334 .699 r
.64056 .63203 .64413 .64268 .64715 .64635 .64358 .63567 Mtetra
.417 .373 .702 r
.64358 .63567 .64715 .64635 .65016 .64913 .64658 .63844 Mtetra
.478 .41 .702 r
.64658 .63844 .65016 .64913 .65314 .6508 .64955 .64009 Mtetra
.529 .44 .699 r
.64955 .64009 .65314 .6508 .6561 .65117 .6525 .64045 Mtetra
.57 .464 .694 r
.6525 .64045 .6561 .65117 .65903 .65015 .65542 .63942 Mtetra
.602 .482 .689 r
.65542 .63942 .65903 .65015 .66192 .6477 .65831 .63697 Mtetra
.625 .496 .684 r
.65831 .63697 .66192 .6477 .66477 .64387 .66116 .63314 Mtetra
.643 .505 .68 r
.66116 .63314 .66477 .64387 .66759 .63881 .66397 .62808 Mtetra
.655 .512 .677 r
.66397 .62808 .66759 .63881 .67038 .63272 .66676 .62199 Mtetra
.662 .516 .675 r
.66676 .62199 .67038 .63272 .67314 .62588 .66953 .61517 Mtetra
.666 .518 .674 r
.66953 .61517 .67314 .62588 .6759 .61864 .67228 .60794 Mtetra
.67228 .60794 .6759 .61864 .67865 .61137 .67503 .60068 Mtetra
.663 .517 .675 r
.67503 .60068 .67865 .61137 .68141 .60444 .67778 .59376 Mtetra
.656 .513 .677 r
.67778 .59376 .68141 .60444 .68419 .59822 .68056 .58755 Mtetra
.644 .506 .68 r
.68056 .58755 .68419 .59822 .687 .59302 .68337 .58235 Mtetra
.627 .497 .684 r
.68337 .58235 .687 .59302 .68986 .58909 .68623 .57841 Mtetra
.604 .483 .689 r
.68623 .57841 .68986 .58909 .69277 .58654 .68913 .57587 Mtetra
.573 .466 .694 r
.68913 .57587 .69277 .58654 .69572 .58542 .69208 .57473 Mtetra
.536 .445 .699 r
.69208 .57473 .69572 .58542 .69873 .58559 .69508 .5749 Mtetra
.498 .423 .702 r
.69508 .5749 .69873 .58559 .70178 .58681 .69812 .5761 Mtetra
.468 .405 .703 r
.69812 .5761 .70178 .58681 .70486 .58871 .7012 .57799 Mtetra
.458 .399 .703 r
.7012 .57799 .70486 .58871 .70796 .59082 .70429 .58008 Mtetra
.473 .408 .703 r
.70429 .58008 .70796 .59082 .71106 .59263 .70737 .58188 Mtetra
.507 .428 .701 r
.70737 .58188 .71106 .59263 .71413 .59365 .71044 .58288 Mtetra
.547 .451 .697 r
.71044 .58288 .71413 .59365 .71716 .59345 .71347 .58267 Mtetra
.584 .472 .692 r
.71347 .58267 .71716 .59345 .72015 .59182 .71645 .58103 Mtetra
.612 .488 .687 r
.71645 .58103 .72015 .59182 .72308 .58874 .71937 .57796 Mtetra
.63 .498 .683 r
.71937 .57796 .72308 .58874 .72597 .58451 .72226 .57373 Mtetra
.638 .503 .681 r
.72226 .57373 .72597 .58451 .72884 .57969 .72512 .56891 Mtetra
.636 .501 .681 r
.72512 .56891 .72884 .57969 .73172 .57503 .728 .56425 Mtetra
.623 .494 .685 r
.728 .56425 .73172 .57503 .73463 .57131 .73091 .56054 Mtetra
.597 .479 .69 r
.73091 .56054 .73463 .57131 .73761 .56908 .73388 .55829 Mtetra
.564 .461 .695 r
.73388 .55829 .73761 .56908 .74065 .56827 .73692 .55747 Mtetra
.552 .454 .697 r
.73692 .55747 .74065 .56827 .74372 .56793 .73998 .55712 Mtetra
.582 .471 .692 r
.73998 .55712 .74372 .56793 .74674 .56636 .74299 .55555 Mtetra
.607 .485 .688 r
.74299 .55555 .74674 .56636 .74971 .56354 .74596 .55273 Mtetra
.582 .471 .692 r
.74596 .55273 .74971 .56354 .75274 .56197 .74898 .55115 Mtetra
.552 .454 .697 r
.74898 .55115 .75274 .56197 .75583 .56162 .75207 .55079 Mtetra
.564 .461 .695 r
.75207 .55079 .75583 .56162 .7589 .5608 .75513 .54996 Mtetra
.596 .479 .69 r
.75513 .54996 .7589 .5608 .76192 .55854 .75814 .5477 Mtetra
.622 .494 .685 r
.75814 .5477 .76192 .55854 .76486 .55479 .76108 .54395 Mtetra
.636 .501 .681 r
.76108 .54395 .76486 .55479 .76777 .55009 .76398 .53926 Mtetra
.638 .502 .681 r
.76398 .53926 .76777 .55009 .77067 .54522 .76688 .53439 Mtetra
.63 .498 .683 r
.76688 .53439 .77067 .54522 .7736 .54095 .7698 .53012 Mtetra
.612 .488 .687 r
.7698 .53012 .7736 .54095 .77658 .53782 .77278 .52699 Mtetra
.585 .473 .692 r
.77278 .52699 .77658 .53782 .77964 .53613 .77583 .52529 Mtetra
.549 .452 .698 r
.77583 .52529 .77964 .53613 .78277 .53588 .77896 .52503 Mtetra
.51 .43 .702 r
.77896 .52503 .78277 .53588 .78597 .53684 .78215 .52597 Mtetra
.478 .412 .704 r
.78215 .52597 .78597 .53684 .78922 .53861 .7854 .52773 Mtetra
.464 .403 .704 r
.7854 .52773 .78922 .53861 .7925 .54069 .78866 .52979 Mtetra
.474 .409 .704 r
.78866 .52979 .7925 .54069 .79577 .54257 .79193 .53166 Mtetra
.502 .425 .702 r
.79193 .53166 .79577 .54257 .79902 .54377 .79516 .53284 Mtetra
.538 .446 .699 r
.79516 .53284 .79902 .54377 .80221 .54391 .79835 .53297 Mtetra
.573 .466 .694 r
.79835 .53297 .80221 .54391 .80534 .54271 .80148 .53177 Mtetra
.603 .483 .689 r
.80148 .53177 .80534 .54271 .8084 .54007 .80453 .52912 Mtetra
.626 .495 .683 r
.80453 .52912 .8084 .54007 .81139 .53599 .80751 .52504 Mtetra
.643 .505 .679 r
.80751 .52504 .81139 .53599 .8143 .53062 .81042 .51967 Mtetra
.655 .511 .676 r
.81042 .51967 .8143 .53062 .81716 .52421 .81328 .51327 Mtetra
.662 .515 .674 r
.81328 .51327 .81716 .52421 .81998 .51708 .81609 .50615 Mtetra
.665 .517 .673 r
.81609 .50615 .81998 .51708 .82277 .50961 .81889 .4987 Mtetra
.81889 .4987 .82277 .50961 .82557 .50218 .82168 .49128 Mtetra
.661 .514 .674 r
.82168 .49128 .82557 .50218 .82839 .49517 .8245 .48427 Mtetra
.653 .51 .676 r
.8245 .48427 .82839 .49517 .83125 .48891 .82736 .47802 Mtetra
.642 .504 .68 r
.82736 .47802 .83125 .48891 .83417 .48367 .83028 .47279 Mtetra
.625 .495 .684 r
.83028 .47279 .83417 .48367 .83717 .47968 .83327 .46879 Mtetra
.602 .482 .689 r
.83327 .46879 .83717 .47968 .84025 .47705 .83635 .46617 Mtetra
.573 .466 .694 r
.83635 .46617 .84025 .47705 .84342 .47585 .83951 .46496 Mtetra
.536 .445 .7 r
.83951 .46496 .84342 .47585 .84669 .47605 .84277 .46515 Mtetra
.491 .42 .704 r
.84277 .46515 .84669 .47605 .85004 .47756 .84611 .46663 Mtetra
.441 .39 .706 r
.84611 .46663 .85004 .47756 .85347 .48019 .84953 .46925 Mtetra
.39 .36 .705 r
.84953 .46925 .85347 .48019 .85696 .48375 .85301 .47279 Mtetra
.346 .334 .703 r
.85301 .47279 .85696 .48375 .86051 .48797 .85655 .47698 Mtetra
.32 .318 .701 r
.85655 .47698 .86051 .48797 .8641 .49255 .86013 .48154 Mtetra
.316 .316 .701 r
.86013 .48154 .8641 .49255 .8677 .49719 .86372 .48615 Mtetra
.336 .328 .703 r
.86372 .48615 .8677 .49719 .8713 .50159 .8673 .49053 Mtetra
.375 .351 .705 r
.8673 .49053 .8713 .50159 .87487 .50545 .87086 .49436 Mtetra
.423 .38 .706 r
.87086 .49436 .87487 .50545 .8784 .5085 .87439 .49739 Mtetra
.472 .409 .705 r
.87439 .49739 .8784 .5085 .88187 .51051 .87785 .49939 Mtetra
.518 .435 .701 r
.87785 .49939 .88187 .51051 .88527 .5113 .88124 .50016 Mtetra
.557 .457 .697 r
.88124 .50016 .88527 .5113 .88858 .51073 .88454 .49958 Mtetra
.589 .475 .691 r
.88454 .49958 .88858 .51073 .89181 .50871 .88776 .49756 Mtetra
.615 .489 .686 r
.88776 .49756 .89181 .50871 .89493 .50524 .89088 .49408 Mtetra
.635 .5 .681 r
.89088 .49408 .89493 .50524 .89796 .50034 .8939 .48919 Mtetra
.651 .508 .676 r
.8939 .48919 .89796 .50034 .90089 .4941 .89683 .48295 Mtetra
.663 .515 .673 r
.89683 .48295 .90089 .4941 .90374 .48666 .89968 .47552 Mtetra
.672 .52 .67 r
.89968 .47552 .90374 .48666 .90652 .47819 .90245 .46708 Mtetra
.678 .523 .668 r
.90245 .46708 .90652 .47819 .90923 .46892 .90517 .45782 Mtetra
.683 .525 .666 r
.90517 .45782 .90923 .46892 .9119 .45907 .90783 .44799 Mtetra
.685 .527 .665 r
.90783 .44799 .9119 .45907 .91453 .44889 .91047 .43783 Mtetra
.686 .527 .665 r
.91047 .43783 .91453 .44889 .91716 .43865 .9131 .42761 Mtetra
.685 .526 .666 r
.9131 .42761 .91716 .43865 .9198 .42859 .91574 .41757 Mtetra
.682 .525 .667 r
.91574 .41757 .9198 .42859 .92247 .41897 .9184 .40796 Mtetra
.677 .522 .668 r
.9184 .40796 .92247 .41897 .92518 .41 .92111 .39901 Mtetra
.67 .518 .671 r
.92111 .39901 .92518 .41 .92795 .40189 .92388 .39091 Mtetra
.66 .513 .674 r
.92388 .39091 .92795 .40189 .9308 .39483 .92673 .38385 Mtetra
.647 .507 .678 r
.92673 .38385 .9308 .39483 .93374 .38894 .92967 .37798 Mtetra
.631 .498 .682 r
.92967 .37798 .93374 .38894 .93678 .38435 .93271 .37339 Mtetra
.611 .487 .687 r
.93271 .37339 .93678 .38435 .93993 .38113 .93585 .37017 Mtetra
.585 .473 .693 r
.93585 .37017 .93993 .38113 .9432 .37932 .93911 .36835 Mtetra
.552 .455 .698 r
.93911 .36835 .9432 .37932 .94659 .37892 .94249 .36794 Mtetra
.512 .433 .703 r
.94249 .36794 .94659 .37892 .95009 .37989 .94599 .3689 Mtetra
.462 .404 .707 r
.94599 .3689 .95009 .37989 .95371 .38218 .94959 .37116 Mtetra
.403 .37 .708 r
.94959 .37116 .95371 .38218 .95743 .38567 .95331 .37464 Mtetra
.336 .331 .705 r
.95331 .37464 .95743 .38567 .96126 .39025 .95713 .37919 Mtetra
.265 .288 .698 r
.95713 .37919 .96126 .39025 .96518 .39576 .96103 .38467 Mtetra
.197 .246 .687 r
.96103 .38467 .96518 .39576 .96918 .40202 .96501 .3909 Mtetra
.14 .211 .676 r
.96501 .3909 .96918 .40202 .97323 .40883 .96906 .39768 Mtetra
.103 .187 .667 r
.96906 .39768 .97323 .40883 .97734 .416 .97315 .40481 Mtetra
.091 .18 .664 r
.97315 .40481 .97734 .416 .98147 .4233 .97726 .41207 Mtetra
.106 .189 .668 r
.97726 .41207 .98147 .4233 .98561 .43051 .98139 .41925 Mtetra
0 0 .481 r
.52782 .66553 .53116 .6756 .53394 .68263 .53058 .67253 Mtetra
0 0 .463 r
.53058 .67253 .53394 .68263 .53673 .68981 .53337 .67968 Mtetra
0 0 .477 r
.53337 .67968 .53673 .68981 .53953 .69692 .53616 .68677 Mtetra
0 0 .521 r
.53616 .68677 .53953 .69692 .54234 .70376 .53896 .69358 Mtetra
0 .03 .58 r
.53896 .69358 .54234 .70376 .54516 .71012 .54177 .69991 Mtetra
.036 .133 .636 r
.54177 .69991 .54516 .71012 .54799 .7158 .54459 .70557 Mtetra
.187 .231 .676 r
.54459 .70557 .54799 .7158 .55081 .72061 .5474 .71035 Mtetra
.315 .312 .697 r
.5474 .71035 .55081 .72061 .55364 .72438 .55022 .71411 Mtetra
.415 .373 .704 r
.55022 .71411 .55364 .72438 .55646 .72698 .55304 .71669 Mtetra
.489 .418 .703 r
.55304 .71669 .55646 .72698 .55928 .72829 .55585 .71799 Mtetra
.543 .45 .699 r
.55585 .71799 .55928 .72829 .56209 .72824 .55865 .71793 Mtetra
.583 .473 .694 r
.55865 .71793 .56209 .72824 .56489 .72679 .56144 .71647 Mtetra
.613 .49 .689 r
.56144 .71647 .56489 .72679 .56767 .72392 .56422 .7136 Mtetra
.635 .502 .684 r
.56422 .7136 .56767 .72392 .57044 .71969 .56699 .70937 Mtetra
.652 .512 .68 r
.56699 .70937 .57044 .71969 .57319 .71418 .56974 .70386 Mtetra
.664 .519 .676 r
.56974 .70386 .57319 .71418 .57593 .70749 .57248 .69718 Mtetra
.674 .524 .674 r
.57248 .69718 .57593 .70749 .57865 .69978 .5752 .68948 Mtetra
.681 .528 .672 r
.5752 .68948 .57865 .69978 .58136 .69124 .57791 .68095 Mtetra
.685 .53 .67 r
.57791 .68095 .58136 .69124 .58406 .68207 .5806 .6718 Mtetra
.688 .532 .669 r
.5806 .6718 .58406 .68207 .58675 .6725 .58329 .66225 Mtetra
.689 .533 .669 r
.58329 .66225 .58675 .6725 .58943 .66278 .58597 .65255 Mtetra
.689 .532 .669 r
.58597 .65255 .58943 .66278 .59211 .65316 .58865 .64294 Mtetra
.687 .531 .67 r
.58865 .64294 .59211 .65316 .59479 .64387 .59133 .63367 Mtetra
.682 .529 .671 r
.59133 .63367 .59479 .64387 .59748 .63516 .59402 .62497 Mtetra
.676 .525 .673 r
.59402 .62497 .59748 .63516 .60017 .62724 .59671 .61706 Mtetra
.667 .521 .676 r
.59671 .61706 .60017 .62724 .60289 .6203 .59943 .61013 Mtetra
.655 .514 .679 r
.59943 .61013 .60289 .6203 .60562 .6145 .60216 .60434 Mtetra
.64 .505 .683 r
.60216 .60434 .60562 .6145 .60838 .60997 .60491 .59981 Mtetra
.619 .494 .688 r
.60491 .59981 .60838 .60997 .61117 .60678 .60769 .59662 Mtetra
.591 .478 .693 r
.60769 .59662 .61117 .60678 .61398 .60497 .6105 .59481 Mtetra
.556 .458 .698 r
.6105 .59481 .61398 .60497 .61683 .60452 .61335 .59435 Mtetra
.51 .431 .703 r
.61335 .59435 .61683 .60452 .61971 .60536 .61622 .59517 Mtetra
.454 .398 .706 r
.61622 .59517 .61971 .60536 .62262 .60737 .61913 .59717 Mtetra
.389 .359 .705 r
.61913 .59717 .62262 .60737 .62556 .61038 .62206 .60016 Mtetra
.323 .319 .7 r
.62206 .60016 .62556 .61038 .62853 .61419 .62502 .60395 Mtetra
.268 .284 .693 r
.62502 .60395 .62853 .61419 .63152 .61855 .628 .60828 Mtetra
.238 .266 .688 r
.628 .60828 .63152 .61855 .63453 .62317 .631 .61288 Mtetra
.243 .269 .689 r
.631 .61288 .63453 .62317 .63755 .62776 .63401 .61745 Mtetra
.282 .293 .695 r
.63401 .61745 .63755 .62776 .64056 .63203 .63701 .6217 Mtetra
.343 .331 .702 r
.63701 .6217 .64056 .63203 .64358 .63567 .64002 .62533 Mtetra
.411 .373 .705 r
.64002 .62533 .64358 .63567 .64658 .63844 .64301 .62807 Mtetra
.475 .411 .705 r
.64301 .62807 .64658 .63844 .64955 .64009 .64598 .62971 Mtetra
.529 .442 .701 r
.64598 .62971 .64955 .64009 .6525 .64045 .64892 .63006 Mtetra
.571 .466 .696 r
.64892 .63006 .6525 .64045 .65542 .63942 .65184 .62902 Mtetra
.603 .485 .691 r
.65184 .62902 .65542 .63942 .65831 .63697 .65472 .62656 Mtetra
.627 .498 .685 r
.65472 .62656 .65831 .63697 .66116 .63314 .65756 .62274 Mtetra
.644 .507 .681 r
.65756 .62274 .66116 .63314 .66397 .62808 .66038 .61768 Mtetra
.656 .514 .678 r
.66038 .61768 .66397 .62808 .66676 .62199 .66316 .6116 Mtetra
.664 .518 .676 r
.66316 .6116 .66676 .62199 .66953 .61517 .66592 .60478 Mtetra
.668 .52 .675 r
.66592 .60478 .66953 .61517 .67228 .60794 .66867 .59757 Mtetra
.668 .521 .675 r
.66867 .59757 .67228 .60794 .67503 .60068 .67142 .59031 Mtetra
.665 .519 .676 r
.67142 .59031 .67503 .60068 .67778 .59376 .67418 .58341 Mtetra
.658 .515 .678 r
.67418 .58341 .67778 .59376 .68056 .58755 .67695 .5772 Mtetra
.646 .508 .681 r
.67695 .5772 .68056 .58755 .68337 .58235 .67976 .57201 Mtetra
.629 .499 .685 r
.67976 .57201 .68337 .58235 .68623 .57841 .68261 .56807 Mtetra
.605 .486 .69 r
.68261 .56807 .68623 .57841 .68913 .57587 .68551 .56552 Mtetra
.574 .468 .696 r
.68551 .56552 .68913 .57587 .69208 .57473 .68845 .56438 Mtetra
.536 .447 .701 r
.68845 .56438 .69208 .57473 .69508 .5749 .69145 .56453 Mtetra
.497 .424 .704 r
.69145 .56453 .69508 .5749 .69812 .5761 .69448 .56573 Mtetra
.466 .406 .706 r
.69448 .56573 .69812 .5761 .7012 .57799 .69755 .5676 Mtetra
.455 .399 .706 r
.69755 .5676 .7012 .57799 .70429 .58008 .70063 .56967 Mtetra
.471 .409 .706 r
.70063 .56967 .70429 .58008 .70737 .58188 .70371 .57145 Mtetra
.506 .429 .704 r
.70371 .57145 .70737 .58188 .71044 .58288 .70677 .57244 Mtetra
.548 .453 .7 r
.70677 .57244 .71044 .58288 .71347 .58267 .70979 .57223 Mtetra
.585 .475 .694 r
.70979 .57223 .71347 .58267 .71645 .58103 .71276 .57058 Mtetra
.614 .49 .688 r
.71276 .57058 .71645 .58103 .71937 .57796 .71569 .5675 Mtetra
.632 .5 .684 r
.71569 .5675 .71937 .57796 .72226 .57373 .71857 .56328 Mtetra
.64 .505 .682 r
.71857 .56328 .72226 .57373 .72512 .56891 .72143 .55846 Mtetra
.638 .504 .683 r
.72143 .55846 .72512 .56891 .728 .56425 .7243 .5538 Mtetra
.624 .496 .686 r
.7243 .5538 .728 .56425 .73091 .56054 .7272 .55009 Mtetra
.598 .482 .692 r
.7272 .55009 .73091 .56054 .73388 .55829 .73017 .54784 Mtetra
.565 .463 .697 r
.73017 .54784 .73388 .55829 .73692 .55747 .7332 .54701 Mtetra
.552 .456 .699 r
.7332 .54701 .73692 .55747 .73998 .55712 .73626 .54665 Mtetra
.583 .474 .694 r
.73626 .54665 .73998 .55712 .74299 .55555 .73927 .54508 Mtetra
.609 .488 .689 r
.73927 .54508 .74299 .55555 .74596 .55273 .74223 .54225 Mtetra
.583 .474 .694 r
.74223 .54225 .74596 .55273 .74898 .55115 .74525 .54067 Mtetra
.552 .456 .699 r
.74525 .54067 .74898 .55115 .75207 .55079 .74832 .5403 Mtetra
.565 .463 .697 r
.74832 .5403 .75207 .55079 .75513 .54996 .75138 .53946 Mtetra
.598 .482 .692 r
.75138 .53946 .75513 .54996 .75814 .5477 .75438 .5372 Mtetra
.624 .496 .686 r
.75438 .5372 .75814 .5477 .76108 .54395 .75732 .53345 Mtetra
.638 .503 .683 r
.75732 .53345 .76108 .54395 .76398 .53926 .76022 .52875 Mtetra
.64 .505 .682 r
.76022 .52875 .76398 .53926 .76688 .53439 .76311 .52389 Mtetra
.632 .5 .684 r
.76311 .52389 .76688 .53439 .7698 .53012 .76603 .51962 Mtetra
.614 .49 .688 r
.76603 .51962 .7698 .53012 .77278 .52699 .76901 .51649 Mtetra
.586 .475 .694 r
.76901 .51649 .77278 .52699 .77583 .52529 .77205 .51478 Mtetra
.549 .454 .7 r
.77205 .51478 .77583 .52529 .77896 .52503 .77517 .51451 Mtetra
.509 .432 .704 r
.77517 .51451 .77896 .52503 .78215 .52597 .77836 .51544 Mtetra
.476 .412 .706 r
.77836 .51544 .78215 .52597 .7854 .52773 .78159 .51718 Mtetra
.461 .404 .707 r
.78159 .51718 .7854 .52773 .78866 .52979 .78485 .51923 Mtetra
.471 .41 .707 r
.78485 .51923 .78866 .52979 .79193 .53166 .7881 .52108 Mtetra
.5 .427 .705 r
.7881 .52108 .79193 .53166 .79516 .53284 .79133 .52225 Mtetra
.538 .448 .701 r
.79133 .52225 .79516 .53284 .79835 .53297 .79452 .52236 Mtetra
.574 .468 .696 r
.79452 .52236 .79835 .53297 .80148 .53177 .79763 .52116 Mtetra
.604 .485 .69 r
.79763 .52116 .80148 .53177 .80453 .52912 .80068 .5185 Mtetra
.628 .498 .685 r
.80068 .5185 .80453 .52912 .80751 .52504 .80366 .51442 Mtetra
.645 .507 .68 r
.80366 .51442 .80751 .52504 .81042 .51967 .80657 .50906 Mtetra
.657 .513 .677 r
.80657 .50906 .81042 .51967 .81328 .51327 .80942 .50267 Mtetra
.664 .517 .675 r
.80942 .50267 .81328 .51327 .81609 .50615 .81223 .49556 Mtetra
.667 .519 .674 r
.81223 .49556 .81609 .50615 .81889 .4987 .81503 .48811 Mtetra
.81503 .48811 .81889 .4987 .82168 .49128 .81782 .48071 Mtetra
.663 .517 .675 r
.81782 .48071 .82168 .49128 .8245 .48427 .82063 .47371 Mtetra
.655 .513 .677 r
.82063 .47371 .8245 .48427 .82736 .47802 .82349 .46746 Mtetra
.643 .506 .681 r
.82349 .46746 .82736 .47802 .83028 .47279 .82641 .46224 Mtetra
.627 .497 .685 r
.82641 .46224 .83028 .47279 .83327 .46879 .82939 .45824 Mtetra
.604 .485 .691 r
.82939 .45824 .83327 .46879 .83635 .46617 .83246 .45561 Mtetra
.574 .468 .696 r
.83246 .45561 .83635 .46617 .83951 .46496 .83562 .4544 Mtetra
.536 .447 .702 r
.83562 .4544 .83951 .46496 .84277 .46515 .83887 .45458 Mtetra
.489 .421 .707 r
.83887 .45458 .84277 .46515 .84611 .46663 .8422 .45605 Mtetra
.437 .39 .709 r
.8422 .45605 .84611 .46663 .84953 .46925 .84561 .45865 Mtetra
.383 .359 .708 r
.84561 .45865 .84953 .46925 .85301 .47279 .84909 .46216 Mtetra
.337 .332 .706 r
.84909 .46216 .85301 .47279 .85655 .47698 .85262 .46633 Mtetra
.309 .315 .703 r
.85262 .46633 .85655 .47698 .86013 .48154 .85618 .47086 Mtetra
.305 .312 .703 r
.85618 .47086 .86013 .48154 .86372 .48615 .85976 .47545 Mtetra
.327 .325 .705 r
.85976 .47545 .86372 .48615 .8673 .49053 .86334 .4798 Mtetra
.367 .35 .708 r
.86334 .4798 .8673 .49053 .87086 .49436 .86689 .48362 Mtetra
.418 .379 .709 r
.86689 .48362 .87086 .49436 .87439 .49739 .8704 .48663 Mtetra
.47 .41 .708 r
.8704 .48663 .87439 .49739 .87785 .49939 .87385 .48861 Mtetra
.517 .437 .704 r
.87385 .48861 .87785 .49939 .88124 .50016 .87724 .48937 Mtetra
.557 .459 .699 r
.87724 .48937 .88124 .50016 .88454 .49958 .88053 .48878 Mtetra
.59 .477 .693 r
.88053 .48878 .88454 .49958 .88776 .49756 .88374 .48675 Mtetra
.616 .491 .687 r
.88374 .48675 .88776 .49756 .89088 .49408 .88686 .48327 Mtetra
.637 .502 .682 r
.88686 .48327 .89088 .49408 .8939 .48919 .88988 .47838 Mtetra
.653 .511 .677 r
.88988 .47838 .8939 .48919 .89683 .48295 .89281 .47215 Mtetra
.665 .517 .674 r
.89281 .47215 .89683 .48295 .89968 .47552 .89565 .46473 Mtetra
.674 .522 .671 r
.89565 .46473 .89968 .47552 .90245 .46708 .89842 .4563 Mtetra
.681 .525 .668 r
.89842 .4563 .90245 .46708 .90517 .45782 .90113 .44705 Mtetra
.685 .527 .667 r
.90113 .44705 .90517 .45782 .90783 .44799 .9038 .43724 Mtetra
.687 .529 .666 r
.9038 .43724 .90783 .44799 .91047 .43783 .90644 .4271 Mtetra
.688 .529 .666 r
.90644 .4271 .91047 .43783 .9131 .42761 .90907 .4169 Mtetra
.687 .528 .666 r
.90907 .4169 .9131 .42761 .91574 .41757 .91171 .40688 Mtetra
.684 .527 .667 r
.91171 .40688 .91574 .41757 .9184 .40796 .91437 .39729 Mtetra
.679 .524 .669 r
.91437 .39729 .9184 .40796 .92111 .39901 .91708 .38835 Mtetra
.672 .521 .672 r
.91708 .38835 .92111 .39901 .92388 .39091 .91985 .38027 Mtetra
.662 .516 .675 r
.91985 .38027 .92388 .39091 .92673 .38385 .9227 .37322 Mtetra
.649 .509 .679 r
.9227 .37322 .92673 .38385 .92967 .37798 .92563 .36734 Mtetra
.633 .501 .683 r
.92563 .36734 .92967 .37798 .93271 .37339 .92867 .36276 Mtetra
.612 .49 .689 r
.92867 .36276 .93271 .37339 .93585 .37017 .93181 .35953 Mtetra
.586 .475 .694 r
.93181 .35953 .93585 .37017 .93911 .36835 .93506 .35771 Mtetra
.553 .457 .7 r
.93506 .35771 .93911 .36835 .94249 .36794 .93843 .35729 Mtetra
.511 .434 .706 r
.93843 .35729 .94249 .36794 .94599 .3689 .94192 .35823 Mtetra
.459 .405 .71 r
.94192 .35823 .94599 .3689 .94959 .37116 .94552 .36048 Mtetra
.398 .369 .711 r
.94552 .36048 .94959 .37116 .95331 .37464 .94922 .36393 Mtetra
.327 .328 .708 r
.94922 .36393 .95331 .37464 .95713 .37919 .95303 .36846 Mtetra
.251 .282 .7 r
.95303 .36846 .95713 .37919 .96103 .38467 .95692 .37391 Mtetra
.178 .238 .688 r
.95692 .37391 .96103 .38467 .96501 .3909 .96089 .38011 Mtetra
.117 .2 .674 r
.96089 .38011 .96501 .3909 .96906 .39768 .96492 .38686 Mtetra
.077 .175 .664 r
.96492 .38686 .96906 .39768 .97315 .40481 .96899 .39396 Mtetra
.064 .166 .661 r
.96899 .39396 .97315 .40481 .97726 .41207 .97309 .40119 Mtetra
.08 .176 .665 r
.97309 .40119 .97726 .41207 .98139 .41925 .9772 .40833 Mtetra
0 0 .429 r
.52448 .65598 .52782 .66553 .53058 .67253 .52724 .66296 Mtetra
0 0 .407 r
.52724 .66296 .53058 .67253 .53337 .67968 .53001 .67008 Mtetra
0 0 .425 r
.53001 .67008 .53337 .67968 .53616 .68677 .5328 .67714 Mtetra
0 0 .478 r
.5328 .67714 .53616 .68677 .53896 .69358 .53559 .68393 Mtetra
0 0 .552 r
.53559 .68393 .53896 .69358 .54177 .69991 .53839 .69023 Mtetra
0 .1 .624 r
.53839 .69023 .54177 .69991 .54459 .70557 .5412 .69586 Mtetra
.148 .213 .674 r
.5412 .69586 .54459 .70557 .5474 .71035 .54401 .70063 Mtetra
.294 .304 .7 r
.54401 .70063 .5474 .71035 .55022 .71411 .54682 .70436 Mtetra
.405 .372 .709 r
.54682 .70436 .55022 .71411 .55304 .71669 .54962 .70693 Mtetra
.485 .42 .708 r
.54962 .70693 .55304 .71669 .55585 .71799 .55243 .70822 Mtetra
.543 .453 .703 r
.55243 .70822 .55585 .71799 .55865 .71793 .55523 .70815 Mtetra
.585 .477 .697 r
.55523 .70815 .55865 .71793 .56144 .71647 .55801 .70668 Mtetra
.616 .494 .691 r
.55801 .70668 .56144 .71647 .56422 .7136 .56079 .70381 Mtetra
.638 .507 .686 r
.56079 .70381 .56422 .7136 .56699 .70937 .56355 .69959 Mtetra
.655 .516 .682 r
.56355 .69959 .56699 .70937 .56974 .70386 .5663 .69408 Mtetra
.668 .523 .678 r
.5663 .69408 .56974 .70386 .57248 .69718 .56903 .68741 Mtetra
.677 .528 .675 r
.56903 .68741 .57248 .69718 .5752 .68948 .57176 .67972 Mtetra
.684 .531 .673 r
.57176 .67972 .5752 .68948 .57791 .68095 .57446 .6712 Mtetra
.689 .534 .671 r
.57446 .6712 .57791 .68095 .5806 .6718 .57716 .66206 Mtetra
.692 .535 .67 r
.57716 .66206 .5806 .6718 .58329 .66225 .57985 .65253 Mtetra
.693 .536 .67 r
.57985 .65253 .58329 .66225 .58597 .65255 .58253 .64284 Mtetra
.692 .536 .67 r
.58253 .64284 .58597 .65255 .58865 .64294 .58521 .63324 Mtetra
.69 .535 .671 r
.58521 .63324 .58865 .64294 .59133 .63367 .58789 .62399 Mtetra
.686 .532 .672 r
.58789 .62399 .59133 .63367 .59402 .62497 .59057 .6153 Mtetra
.68 .529 .674 r
.59057 .6153 .59402 .62497 .59671 .61706 .59327 .6074 Mtetra
.671 .524 .677 r
.59327 .6074 .59671 .61706 .59943 .61013 .59598 .60048 Mtetra
.659 .518 .681 r
.59598 .60048 .59943 .61013 .60216 .60434 .59871 .59469 Mtetra
.643 .509 .685 r
.59871 .59469 .60216 .60434 .60491 .59981 .60146 .59017 Mtetra
.622 .498 .69 r
.60146 .59017 .60491 .59981 .60769 .59662 .60424 .58698 Mtetra
.594 .482 .696 r
.60424 .58698 .60769 .59662 .6105 .59481 .60704 .58516 Mtetra
.556 .462 .702 r
.60704 .58516 .6105 .59481 .61335 .59435 .60988 .58469 Mtetra
.508 .434 .708 r
.60988 .58469 .61335 .59435 .61622 .59517 .61275 .58551 Mtetra
.448 .399 .711 r
.61275 .58551 .61622 .59517 .61913 .59717 .61565 .58749 Mtetra
.377 .357 .71 r
.61565 .58749 .61913 .59717 .62206 .60016 .61857 .59047 Mtetra
.303 .312 .704 r
.61857 .59047 .62206 .60016 .62502 .60395 .62152 .59424 Mtetra
.241 .274 .696 r
.62152 .59424 .62502 .60395 .628 .60828 .6245 .59855 Mtetra
.207 .253 .69 r
.6245 .59855 .628 .60828 .631 .61288 .62749 .60312 Mtetra
.213 .256 .691 r
.62749 .60312 .631 .61288 .63401 .61745 .63048 .60767 Mtetra
.257 .284 .698 r
.63048 .60767 .63401 .61745 .63701 .6217 .63348 .6119 Mtetra
.326 .326 .706 r
.63348 .6119 .63701 .6217 .64002 .62533 .63648 .61551 Mtetra
.401 .371 .711 r
.63648 .61551 .64002 .62533 .64301 .62807 .63946 .61824 Mtetra
.471 .412 .71 r
.63946 .61824 .64301 .62807 .64598 .62971 .64243 .61986 Mtetra
.528 .445 .706 r
.64243 .61986 .64598 .62971 .64892 .63006 .64536 .6202 Mtetra
.573 .47 .7 r
.64536 .6202 .64892 .63006 .65184 .62902 .64827 .61916 Mtetra
.606 .489 .693 r
.64827 .61916 .65184 .62902 .65472 .62656 .65115 .6167 Mtetra
.63 .502 .688 r
.65115 .6167 .65472 .62656 .65756 .62274 .65399 .61287 Mtetra
.648 .512 .683 r
.65399 .61287 .65756 .62274 .66038 .61768 .6568 .60782 Mtetra
.66 .518 .68 r
.6568 .60782 .66038 .61768 .66316 .6116 .65958 .60174 Mtetra
.668 .522 .677 r
.65958 .60174 .66316 .6116 .66592 .60478 .66234 .59493 Mtetra
.672 .524 .676 r
.66234 .59493 .66592 .60478 .66867 .59757 .66509 .58772 Mtetra
.66509 .58772 .66867 .59757 .67142 .59031 .66784 .58048 Mtetra
.669 .523 .677 r
.66784 .58048 .67142 .59031 .67418 .58341 .67059 .57358 Mtetra
.661 .519 .679 r
.67059 .57358 .67418 .58341 .67695 .5772 .67337 .56738 Mtetra
.65 .513 .683 r
.67337 .56738 .67695 .5772 .67976 .57201 .67617 .5622 Mtetra
.632 .503 .688 r
.67617 .5622 .67976 .57201 .68261 .56807 .67902 .55826 Mtetra
.608 .49 .693 r
.67902 .55826 .68261 .56807 .68551 .56552 .68191 .55571 Mtetra
.575 .472 .7 r
.68191 .55571 .68551 .56552 .68845 .56438 .68485 .55456 Mtetra
.536 .45 .705 r
.68485 .55456 .68845 .56438 .69145 .56453 .68784 .5547 Mtetra
.494 .426 .709 r
.68784 .5547 .69145 .56453 .69448 .56573 .69086 .55588 Mtetra
.461 .407 .711 r
.69086 .55588 .69448 .56573 .69755 .5676 .69392 .55773 Mtetra
.449 .4 .712 r
.69392 .55773 .69755 .5676 .70063 .56967 .697 .5598 Mtetra
.466 .41 .711 r
.697 .5598 .70063 .56967 .70371 .57145 .70007 .56156 Mtetra
.504 .432 .709 r
.70007 .56156 .70371 .57145 .70677 .57244 .70312 .56254 Mtetra
.548 .457 .704 r
.70312 .56254 .70677 .57244 .70979 .57223 .70614 .56232 Mtetra
.587 .479 .697 r
.70614 .56232 .70979 .57223 .71276 .57058 .7091 .56066 Mtetra
.617 .495 .691 r
.7091 .56066 .71276 .57058 .71569 .5675 .71202 .55758 Mtetra
.635 .505 .686 r
.71202 .55758 .71569 .5675 .71857 .56328 .7149 .55336 Mtetra
.644 .509 .684 r
.7149 .55336 .71857 .56328 .72143 .55846 .71776 .54854 Mtetra
.641 .508 .685 r
.71776 .54854 .72143 .55846 .7243 .5538 .72062 .54389 Mtetra
.627 .5 .689 r
.72062 .54389 .7243 .5538 .7272 .55009 .72353 .54017 Mtetra
.6 .486 .695 r
.72353 .54017 .7272 .55009 .73017 .54784 .72649 .53793 Mtetra
.566 .467 .701 r
.72649 .53793 .73017 .54784 .7332 .54701 .72952 .53709 Mtetra
.552 .459 .703 r
.72952 .53709 .7332 .54701 .73626 .54665 .73257 .53672 Mtetra
.585 .478 .698 r
.73257 .53672 .73626 .54665 .73927 .54508 .73557 .53514 Mtetra
.611 .492 .692 r
.73557 .53514 .73927 .54508 .74223 .54225 .73853 .53231 Mtetra
.585 .478 .698 r
.73853 .53231 .74223 .54225 .74525 .54067 .74154 .53072 Mtetra
.553 .46 .703 r
.74154 .53072 .74525 .54067 .74832 .5403 .74461 .53034 Mtetra
.566 .467 .701 r
.74461 .53034 .74832 .5403 .75138 .53946 .74766 .5295 Mtetra
.6 .486 .695 r
.74766 .5295 .75138 .53946 .75438 .5372 .75066 .52723 Mtetra
.627 .5 .688 r
.75066 .52723 .75438 .5372 .75732 .53345 .75359 .52348 Mtetra
.641 .508 .685 r
.75359 .52348 .75732 .53345 .76022 .52875 .75649 .51879 Mtetra
.643 .509 .684 r
.75649 .51879 .76022 .52875 .76311 .52389 .75938 .51393 Mtetra
.635 .504 .686 r
.75938 .51393 .76311 .52389 .76603 .51962 .76229 .50965 Mtetra
.617 .495 .691 r
.76229 .50965 .76603 .51962 .76901 .51649 .76526 .50652 Mtetra
.588 .479 .697 r
.76526 .50652 .76901 .51649 .77205 .51478 .7683 .50481 Mtetra
.55 .458 .704 r
.7683 .50481 .77205 .51478 .77517 .51451 .77142 .50453 Mtetra
.507 .434 .709 r
.77142 .50453 .77517 .51451 .77836 .51544 .7746 .50545 Mtetra
.472 .414 .712 r
.7746 .50545 .77836 .51544 .78159 .51718 .77782 .50718 Mtetra
.456 .405 .712 r
.77782 .50718 .78159 .51718 .78485 .51923 .78107 .50921 Mtetra
.467 .411 .712 r
.78107 .50921 .78485 .51923 .7881 .52108 .78432 .51104 Mtetra
.498 .429 .71 r
.78432 .51104 .7881 .52108 .79133 .52225 .78754 .5122 Mtetra
.537 .451 .706 r
.78754 .5122 .79133 .52225 .79452 .52236 .79071 .5123 Mtetra
.575 .472 .7 r
.79071 .5123 .79452 .52236 .79763 .52116 .79383 .51109 Mtetra
.607 .489 .693 r
.79383 .51109 .79763 .52116 .80068 .5185 .79687 .50843 Mtetra
.631 .502 .687 r
.79687 .50843 .80068 .5185 .80366 .51442 .79984 .50435 Mtetra
.648 .511 .682 r
.79984 .50435 .80366 .51442 .80657 .50906 .80275 .499 Mtetra
.66 .518 .679 r
.80275 .499 .80657 .50906 .80942 .50267 .8056 .49261 Mtetra
.668 .521 .676 r
.8056 .49261 .80942 .50267 .81223 .49556 .80841 .48551 Mtetra
.671 .523 .675 r
.80841 .48551 .81223 .49556 .81503 .48811 .8112 .47807 Mtetra
.8112 .47807 .81503 .48811 .81782 .48071 .81399 .47068 Mtetra
.667 .521 .677 r
.81399 .47068 .81782 .48071 .82063 .47371 .81681 .46369 Mtetra
.659 .517 .679 r
.81681 .46369 .82063 .47371 .82349 .46746 .81966 .45745 Mtetra
.647 .511 .683 r
.81966 .45745 .82349 .46746 .82641 .46224 .82257 .45222 Mtetra
.63 .502 .688 r
.82257 .45222 .82641 .46224 .82939 .45824 .82556 .44823 Mtetra
.606 .489 .694 r
.82556 .44823 .82939 .45824 .83246 .45561 .82862 .44559 Mtetra
.575 .472 .7 r
.82862 .44559 .83246 .45561 .83562 .4544 .83177 .44437 Mtetra
.535 .45 .706 r
.83177 .44437 .83562 .4544 .83887 .45458 .83502 .44454 Mtetra
.486 .423 .711 r
.83502 .44454 .83887 .45458 .8422 .45605 .83834 .446 Mtetra
.429 .391 .714 r
.83834 .446 .8422 .45605 .84561 .45865 .84174 .44858 Mtetra
.371 .357 .713 r
.84174 .44858 .84561 .45865 .84909 .46216 .84521 .45208 Mtetra
.32 .327 .71 r
.84521 .45208 .84909 .46216 .85262 .46633 .84873 .45622 Mtetra
.288 .308 .707 r
.84873 .45622 .85262 .46633 .85618 .47086 .85228 .46073 Mtetra
.284 .305 .707 r
.85228 .46073 .85618 .47086 .85976 .47545 .85585 .4653 Mtetra
.308 .319 .709 r
.85585 .4653 .85976 .47545 .86334 .4798 .85941 .46963 Mtetra
.353 .346 .713 r
.85941 .46963 .86334 .4798 .86689 .48362 .86295 .47342 Mtetra
.409 .379 .714 r
.86295 .47342 .86689 .48362 .8704 .48663 .86646 .47641 Mtetra
.465 .411 .713 r
.86646 .47641 .8704 .48663 .87385 .48861 .8699 .47838 Mtetra
.516 .439 .709 r
.8699 .47838 .87385 .48861 .87724 .48937 .87328 .47912 Mtetra
.558 .463 .703 r
.87328 .47912 .87724 .48937 .88053 .48878 .87657 .47852 Mtetra
.592 .481 .696 r
.87657 .47852 .88053 .48878 .88374 .48675 .87977 .47649 Mtetra
.619 .496 .69 r
.87977 .47649 .88374 .48675 .88686 .48327 .88288 .47301 Mtetra
.64 .507 .684 r
.88288 .47301 .88686 .48327 .88988 .47838 .8859 .46812 Mtetra
.656 .515 .679 r
.8859 .46812 .88988 .47838 .89281 .47215 .88882 .4619 Mtetra
.669 .521 .675 r
.88882 .4619 .89281 .47215 .89565 .46473 .89167 .45449 Mtetra
.678 .526 .672 r
.89167 .45449 .89565 .46473 .89842 .4563 .89444 .44607 Mtetra
.684 .529 .67 r
.89444 .44607 .89842 .4563 .90113 .44705 .89715 .43684 Mtetra
.689 .531 .668 r
.89715 .43684 .90113 .44705 .9038 .43724 .89982 .42704 Mtetra
.691 .532 .667 r
.89982 .42704 .9038 .43724 .90644 .4271 .90246 .41692 Mtetra
.692 .533 .667 r
.90246 .41692 .90644 .4271 .90907 .4169 .90508 .40673 Mtetra
.69 .532 .667 r
.90508 .40673 .90907 .4169 .91171 .40688 .90772 .39673 Mtetra
.687 .531 .668 r
.90772 .39673 .91171 .40688 .91437 .39729 .91039 .38715 Mtetra
.682 .528 .67 r
.91039 .38715 .91437 .39729 .91708 .38835 .9131 .37823 Mtetra
.675 .525 .673 r
.9131 .37823 .91708 .38835 .91985 .38027 .91587 .37016 Mtetra
.666 .52 .676 r
.91587 .37016 .91985 .38027 .9227 .37322 .91871 .36312 Mtetra
.653 .513 .681 r
.91871 .36312 .9227 .37322 .92563 .36734 .92164 .35725 Mtetra
.636 .505 .686 r
.92164 .35725 .92563 .36734 .92867 .36276 .92467 .35267 Mtetra
.615 .494 .691 r
.92467 .35267 .92867 .36276 .93181 .35953 .92781 .34944 Mtetra
.588 .48 .698 r
.92781 .34944 .93181 .35953 .93506 .35771 .93106 .34761 Mtetra
.553 .461 .704 r
.93106 .34761 .93506 .35771 .93843 .35729 .93442 .34718 Mtetra
.509 .437 .71 r
.93442 .34718 .93843 .35729 .94192 .35823 .9379 .34811 Mtetra
.454 .406 .715 r
.9379 .34811 .94192 .35823 .94552 .36048 .94149 .35034 Mtetra
.387 .368 .716 r
.94149 .35034 .94552 .36048 .94922 .36393 .94518 .35377 Mtetra
.308 .322 .712 r
.94518 .35377 .94922 .36393 .95303 .36846 .94897 .35828 Mtetra
.224 .272 .702 r
.94897 .35828 .95303 .36846 .95692 .37391 .95285 .3637 Mtetra
.141 .221 .687 r
.95285 .3637 .95692 .37391 .96089 .38011 .95681 .36987 Mtetra
.072 .178 .67 r
.95681 .36987 .96089 .38011 .96492 .38686 .96083 .37659 Mtetra
.027 .15 .657 r
.96083 .37659 .96492 .38686 .96899 .39396 .96489 .38366 Mtetra
.013 .141 .653 r
.96489 .38366 .96899 .39396 .97309 .40119 .96898 .39086 Mtetra
.031 .152 .658 r
.96898 .39086 .97309 .40119 .9772 .40833 .97308 .39797 Mtetra
0 0 .335 r
.52115 .64714 .52448 .65598 .52724 .66296 .52391 .65409 Mtetra
0 0 .308 r
.52391 .65409 .52724 .66296 .53001 .67008 .52667 .66119 Mtetra
0 0 .329 r
.52667 .66119 .53001 .67008 .5328 .67714 .52944 .66822 Mtetra
0 0 .396 r
.52944 .66822 .5328 .67714 .53559 .68393 .53223 .67499 Mtetra
0 0 .495 r
.53223 .67499 .53559 .68393 .53839 .69023 .53502 .68127 Mtetra
0 .042 .596 r
.53502 .68127 .53839 .69023 .5412 .69586 .53782 .68688 Mtetra
.081 .18 .669 r
.53782 .68688 .5412 .69586 .54401 .70063 .54062 .69162 Mtetra
.258 .291 .706 r
.54062 .69162 .54401 .70063 .54682 .70436 .54342 .69534 Mtetra
.388 .37 .717 r
.54342 .69534 .54682 .70436 .54962 .70693 .54622 .69789 Mtetra
.48 .423 .716 r
.54622 .69789 .54962 .70693 .55243 .70822 .54902 .69917 Mtetra
.543 .459 .71 r
.54902 .69917 .55243 .70822 .55523 .70815 .55181 .69909 Mtetra
.588 .483 .703 r
.55181 .69909 .55523 .70815 .55801 .70668 .5546 .69762 Mtetra
.62 .501 .696 r
.5546 .69762 .55801 .70668 .56079 .70381 .55737 .69475 Mtetra
.643 .513 .689 r
.55737 .69475 .56079 .70381 .56355 .69959 .56013 .69053 Mtetra
.66 .522 .684 r
.56013 .69053 .56355 .69959 .5663 .69408 .56287 .68502 Mtetra
.673 .529 .68 r
.56287 .68502 .5663 .69408 .56903 .68741 .56561 .67836 Mtetra
.682 .533 .677 r
.56561 .67836 .56903 .68741 .57176 .67972 .56833 .67068 Mtetra
.689 .537 .675 r
.56833 .67068 .57176 .67972 .57446 .6712 .57103 .66217 Mtetra
.694 .539 .673 r
.57103 .66217 .57446 .6712 .57716 .66206 .57373 .65304 Mtetra
.697 .541 .672 r
.57373 .65304 .57716 .66206 .57985 .65253 .57642 .64352 Mtetra
.698 .541 .671 r
.57642 .64352 .57985 .65253 .58253 .64284 .5791 .63385 Mtetra
.697 .541 .671 r
.5791 .63385 .58253 .64284 .58521 .63324 .58178 .62427 Mtetra
.695 .54 .672 r
.58178 .62427 .58521 .63324 .58789 .62399 .58446 .61502 Mtetra
.691 .538 .674 r
.58446 .61502 .58789 .62399 .59057 .6153 .58714 .60635 Mtetra
.685 .535 .676 r
.58714 .60635 .59057 .6153 .59327 .6074 .58984 .59846 Mtetra
.676 .53 .679 r
.58984 .59846 .59327 .6074 .59598 .60048 .59255 .59154 Mtetra
.664 .524 .683 r
.59255 .59154 .59598 .60048 .59871 .59469 .59528 .58576 Mtetra
.648 .516 .688 r
.59528 .58576 .59871 .59469 .60146 .59017 .59802 .58124 Mtetra
.626 .504 .694 r
.59802 .58124 .60146 .59017 .60424 .58698 .6008 .57805 Mtetra
.597 .489 .701 r
.6008 .57805 .60424 .58698 .60704 .58516 .6036 .57622 Mtetra
.557 .467 .709 r
.6036 .57622 .60704 .58516 .60988 .58469 .60643 .57575 Mtetra
.505 .438 .715 r
.60643 .57575 .60988 .58469 .61275 .58551 .60929 .57655 Mtetra
.438 .4 .719 r
.60929 .57655 .61275 .58551 .61565 .58749 .61219 .57852 Mtetra
.356 .353 .718 r
.61219 .57852 .61565 .58749 .61857 .59047 .6151 .58148 Mtetra
.269 .3 .71 r
.6151 .58148 .61857 .59047 .62152 .59424 .61805 .58523 Mtetra
.195 .255 .698 r
.61805 .58523 .62152 .59424 .6245 .59855 .62101 .58953 Mtetra
.154 .23 .69 r
.62101 .58953 .6245 .59855 .62749 .60312 .62399 .59408 Mtetra
.161 .234 .691 r
.62399 .59408 .62749 .60312 .63048 .60767 .62698 .59862 Mtetra
.214 .267 .702 r
.62698 .59862 .63048 .60767 .63348 .6119 .62998 .60282 Mtetra
.296 .317 .713 r
.62998 .60282 .63348 .6119 .63648 .61551 .63296 .60642 Mtetra
.385 .369 .719 r
.63296 .60642 .63648 .61551 .63946 .61824 .63594 .60913 Mtetra
.464 .415 .718 r
.63594 .60913 .63946 .61824 .64243 .61986 .6389 .61074 Mtetra
.527 .45 .713 r
.6389 .61074 .64243 .61986 .64536 .6202 .64183 .61107 Mtetra
.575 .476 .705 r
.64183 .61107 .64536 .6202 .64827 .61916 .64473 .61002 Mtetra
.61 .495 .698 r
.64473 .61002 .64827 .61916 .65115 .6167 .6476 .60756 Mtetra
.635 .509 .692 r
.6476 .60756 .65115 .6167 .65399 .61287 .65044 .60373 Mtetra
.653 .518 .686 r
.65044 .60373 .65399 .61287 .6568 .60782 .65325 .59868 Mtetra
.665 .524 .682 r
.65325 .59868 .6568 .60782 .65958 .60174 .65603 .59261 Mtetra
.673 .528 .68 r
.65603 .59261 .65958 .60174 .66234 .59493 .65879 .58581 Mtetra
.677 .53 .678 r
.65879 .58581 .66234 .59493 .66509 .58772 .66154 .57861 Mtetra
.66154 .57861 .66509 .58772 .66784 .58048 .66428 .57137 Mtetra
.674 .529 .679 r
.66428 .57137 .66784 .58048 .67059 .57358 .66703 .56448 Mtetra
.667 .525 .682 r
.66703 .56448 .67059 .57358 .67337 .56738 .66981 .55828 Mtetra
.655 .519 .686 r
.66981 .55828 .67337 .56738 .67617 .5622 .67261 .5531 Mtetra
.637 .51 .691 r
.67261 .5531 .67617 .5622 .67902 .55826 .67545 .54916 Mtetra
.611 .496 .698 r
.67545 .54916 .67902 .55826 .68191 .55571 .67834 .54661 Mtetra
.577 .478 .705 r
.67834 .54661 .68191 .55571 .68485 .55456 .68127 .54545 Mtetra
.535 .455 .712 r
.68127 .54545 .68485 .55456 .68784 .5547 .68426 .54559 Mtetra
.489 .43 .717 r
.68426 .54559 .68784 .5547 .69086 .55588 .68728 .54676 Mtetra
.452 .409 .719 r
.68728 .54676 .69086 .55588 .69392 .55773 .69033 .5486 Mtetra
.439 .402 .72 r
.69033 .5486 .69392 .55773 .697 .5598 .6934 .55065 Mtetra
.458 .412 .719 r
.6934 .55065 .697 .5598 .70007 .56156 .69646 .5524 Mtetra
.5 .436 .716 r
.69646 .5524 .70007 .56156 .70312 .56254 .69951 .55336 Mtetra
.548 .462 .71 r
.69951 .55336 .70312 .56254 .70614 .56232 .70252 .55313 Mtetra
.59 .485 .702 r
.70252 .55313 .70614 .56232 .7091 .56066 .70548 .55147 Mtetra
.621 .501 .695 r
.70548 .55147 .7091 .56066 .71202 .55758 .70839 .54839 Mtetra
.64 .511 .69 r
.70839 .54839 .71202 .55758 .7149 .55336 .71127 .54417 Mtetra
.649 .515 .687 r
.71127 .54417 .7149 .55336 .71776 .54854 .71412 .53936 Mtetra
.646 .514 .688 r
.71412 .53936 .71776 .54854 .72062 .54389 .71699 .5347 Mtetra
.632 .507 .692 r
.71699 .5347 .72062 .54389 .72353 .54017 .71989 .53099 Mtetra
.604 .492 .699 r
.71989 .53099 .72353 .54017 .72649 .53793 .72285 .52874 Mtetra
.568 .473 .707 r
.72285 .52874 .72649 .53793 .72952 .53709 .72586 .52789 Mtetra
.553 .465 .709 r
.72586 .52789 .72952 .53709 .73257 .53672 .72891 .52752 Mtetra
.588 .484 .703 r
.72891 .52752 .73257 .53672 .73557 .53514 .73191 .52593 Mtetra
.616 .498 .697 r
.73191 .52593 .73557 .53514 .73853 .53231 .73486 .52309 Mtetra
.588 .484 .703 r
.73486 .52309 .73853 .53231 .74154 .53072 .73787 .5215 Mtetra
.553 .465 .71 r
.73787 .5215 .74154 .53072 .74461 .53034 .74093 .52112 Mtetra
.568 .473 .707 r
.74093 .52112 .74461 .53034 .74766 .5295 .74398 .52026 Mtetra
.604 .492 .699 r
.74398 .52026 .74766 .5295 .75066 .52723 .74697 .51799 Mtetra
.632 .507 .692 r
.74697 .51799 .75066 .52723 .75359 .52348 .7499 .51424 Mtetra
.646 .514 .688 r
.7499 .51424 .75359 .52348 .75649 .51879 .75279 .50955 Mtetra
.648 .515 .687 r
.75279 .50955 .75649 .51879 .75938 .51393 .75568 .50469 Mtetra
.64 .511 .69 r
.75568 .50469 .75938 .51393 .76229 .50965 .75859 .50042 Mtetra
.621 .501 .695 r
.75859 .50042 .76229 .50965 .76526 .50652 .76156 .49729 Mtetra
.591 .485 .702 r
.76156 .49729 .76526 .50652 .7683 .50481 .76459 .49557 Mtetra
.55 .464 .71 r
.76459 .49557 .7683 .50481 .77142 .50453 .7677 .49528 Mtetra
.504 .439 .716 r
.7677 .49528 .77142 .50453 .7746 .50545 .77087 .49619 Mtetra
.465 .417 .72 r
.77087 .49619 .7746 .50545 .77782 .50718 .77409 .4979 Mtetra
.447 .407 .721 r
.77409 .4979 .77782 .50718 .78107 .50921 .77733 .49992 Mtetra
.459 .414 .72 r
.77733 .49992 .78107 .50921 .78432 .51104 .78057 .50174 Mtetra
.494 .433 .717 r
.78057 .50174 .78432 .51104 .78754 .5122 .78379 .50289 Mtetra
.537 .457 .712 r
.78379 .50289 .78754 .5122 .79071 .5123 .78696 .50298 Mtetra
.578 .478 .705 r
.78696 .50298 .79071 .5123 .79383 .51109 .79006 .50176 Mtetra
.611 .496 .698 r
.79006 .50176 .79383 .51109 .79687 .50843 .7931 .4991 Mtetra
.636 .508 .691 r
.7931 .4991 .79687 .50843 .79984 .50435 .79607 .49502 Mtetra
.654 .518 .685 r
.79607 .49502 .79984 .50435 .80275 .499 .79897 .48967 Mtetra
.666 .524 .681 r
.79897 .48967 .80275 .499 .8056 .49261 .80182 .48328 Mtetra
.673 .527 .679 r
.80182 .48328 .8056 .49261 .80841 .48551 .80463 .47619 Mtetra
.676 .529 .677 r
.80463 .47619 .80841 .48551 .8112 .47807 .80742 .46876 Mtetra
.80742 .46876 .8112 .47807 .81399 .47068 .81021 .46137 Mtetra
.672 .527 .679 r
.81021 .46137 .81399 .47068 .81681 .46369 .81302 .4544 Mtetra
.664 .523 .682 r
.81302 .4544 .81681 .46369 .81966 .45745 .81588 .44816 Mtetra
.652 .517 .686 r
.81588 .44816 .81966 .45745 .82257 .45222 .81879 .44294 Mtetra
.634 .508 .691 r
.81879 .44294 .82257 .45222 .82556 .44823 .82177 .43894 Mtetra
.61 .495 .698 r
.82177 .43894 .82556 .44823 .82862 .44559 .82483 .43631 Mtetra
.577 .478 .706 r
.82483 .43631 .82862 .44559 .83177 .44437 .82797 .43508 Mtetra
.535 .456 .713 r
.82797 .43508 .83177 .44437 .83502 .44454 .83121 .43524 Mtetra
.481 .426 .719 r
.83121 .43524 .83502 .44454 .83834 .446 .83453 .43668 Mtetra
.417 .391 .722 r
.83453 .43668 .83834 .446 .84174 .44858 .83792 .43925 Mtetra
.35 .352 .721 r
.83792 .43925 .84174 .44858 .84521 .45208 .84138 .44272 Mtetra
.29 .318 .717 r
.84138 .44272 .84521 .45208 .84873 .45622 .84489 .44685 Mtetra
.253 .296 .713 r
.84489 .44685 .84873 .45622 .85228 .46073 .84843 .45134 Mtetra
.248 .293 .712 r
.84843 .45134 .85228 .46073 .85585 .4653 .85199 .45589 Mtetra
.276 .309 .716 r
.85199 .45589 .85585 .4653 .85941 .46963 .85554 .46019 Mtetra
.329 .34 .72 r
.85554 .46019 .85941 .46963 .86295 .47342 .85907 .46397 Mtetra
.394 .377 .723 r
.85907 .46397 .86295 .47342 .86646 .47641 .86257 .46694 Mtetra
.457 .413 .721 r
.86257 .46694 .86646 .47641 .8699 .47838 .866 .46889 Mtetra
.513 .444 .716 r
.866 .46889 .8699 .47838 .87328 .47912 .86937 .46963 Mtetra
.559 .469 .709 r
.86937 .46963 .87328 .47912 .87657 .47852 .87266 .46902 Mtetra
.596 .488 .701 r
.87266 .46902 .87657 .47852 .87977 .47649 .87586 .46698 Mtetra
.624 .502 .694 r
.87586 .46698 .87977 .47649 .88288 .47301 .87896 .4635 Mtetra
.645 .513 .687 r
.87896 .4635 .88288 .47301 .8859 .46812 .88197 .45861 Mtetra
.662 .521 .682 r
.88197 .45861 .8859 .46812 .88882 .4619 .8849 .4524 Mtetra
.674 .527 .677 r
.8849 .4524 .88882 .4619 .89167 .45449 .88774 .44499 Mtetra
.683 .532 .674 r
.88774 .44499 .89167 .45449 .89444 .44607 .89051 .43658 Mtetra
.69 .535 .671 r
.89051 .43658 .89444 .44607 .89715 .43684 .89322 .42737 Mtetra
.694 .537 .67 r
.89322 .42737 .89715 .43684 .89982 .42704 .89589 .41758 Mtetra
.696 .538 .668 r
.89589 .41758 .89982 .42704 .90246 .41692 .89853 .40748 Mtetra
.697 .538 .668 r
.89853 .40748 .90246 .41692 .90508 .40673 .90116 .3973 Mtetra
.696 .538 .669 r
.90116 .3973 .90508 .40673 .90772 .39673 .9038 .38732 Mtetra
.693 .536 .67 r
.9038 .38732 .90772 .39673 .91039 .38715 .90646 .37775 Mtetra
.688 .534 .672 r
.90646 .37775 .91039 .38715 .9131 .37823 .90917 .36884 Mtetra
.681 .53 .675 r
.90917 .36884 .9131 .37823 .91587 .37016 .91194 .36078 Mtetra
.671 .526 .679 r
.91194 .36078 .91587 .37016 .91871 .36312 .91478 .35375 Mtetra
.658 .519 .683 r
.91478 .35375 .91871 .36312 .92164 .35725 .91771 .34788 Mtetra
.641 .511 .689 r
.91771 .34788 .92164 .35725 .92467 .35267 .92074 .3433 Mtetra
.619 .5 .696 r
.92074 .3433 .92467 .35267 .92781 .34944 .92387 .34007 Mtetra
.591 .486 .703 r
.92387 .34007 .92781 .34944 .93106 .34761 .92711 .33824 Mtetra
.554 .467 .711 r
.92711 .33824 .93106 .34761 .93442 .34718 .93047 .3378 Mtetra
.506 .441 .718 r
.93047 .3378 .93442 .34718 .9379 .34811 .93394 .33872 Mtetra
.445 .408 .723 r
.93394 .33872 .9379 .34811 .94149 .35034 .93752 .34093 Mtetra
.369 .365 .724 r
.93752 .34093 .94149 .35034 .94518 .35377 .9412 .34435 Mtetra
.278 .313 .719 r
.9412 .34435 .94518 .35377 .94897 .35828 .94499 .34883 Mtetra
.178 .253 .704 r
.94499 .34883 .94897 .35828 .95285 .3637 .94886 .35423 Mtetra
.079 .193 .683 r
.94886 .35423 .95285 .3637 .95681 .36987 .9528 .36037 Mtetra
0 .141 .659 r
.9528 .36037 .95681 .36987 .96083 .37659 .95681 .36707 Mtetra
0 .107 .641 r
.95681 .36707 .96083 .37659 .96489 .38366 .96085 .37411 Mtetra
0 .096 .635 r
.96085 .37411 .96489 .38366 .96898 .39086 .96493 .38128 Mtetra
0 .11 .642 r
.96493 .38128 .96898 .39086 .97308 .39797 .96902 .38836 Mtetra
.738 .379 0 r
.51784 .63916 .52115 .64714 .52391 .65409 .52058 .6461 Mtetra
.762 .399 0 r
.52058 .6461 .52391 .65409 .52667 .66119 .52333 .65317 Mtetra
.742 .383 0 r
.52333 .65317 .52667 .66119 .52944 .66822 .5261 .66019 Mtetra
.672 .327 0 r
.5261 .66019 .52944 .66822 .53223 .67499 .52887 .66693 Mtetra
0 0 .38 r
.52887 .66693 .53223 .67499 .53502 .68127 .53166 .6732 Mtetra
0 0 .53 r
.53166 .6732 .53502 .68127 .53782 .68688 .53445 .67878 Mtetra
0 .123 .65 r
.53445 .67878 .53782 .68688 .54062 .69162 .53724 .68351 Mtetra
.196 .268 .711 r
.53724 .68351 .54062 .69162 .54342 .69534 .54004 .68722 Mtetra
.362 .366 .729 r
.54004 .68722 .54342 .69534 .54622 .69789 .54283 .68976 Mtetra
.471 .428 .728 r
.54283 .68976 .54622 .69789 .54902 .69917 .54563 .69102 Mtetra
.543 .467 .719 r
.54563 .69102 .54902 .69917 .55181 .69909 .54841 .69094 Mtetra
.592 .492 .71 r
.54841 .69094 .55181 .69909 .5546 .69762 .55119 .68946 Mtetra
.626 .51 .701 r
.55119 .68946 .5546 .69762 .55737 .69475 .55396 .68659 Mtetra
.65 .522 .694 r
.55396 .68659 .55737 .69475 .56013 .69053 .55672 .68237 Mtetra
.667 .53 .688 r
.55672 .68237 .56013 .69053 .56287 .68502 .55946 .67686 Mtetra
.68 .537 .683 r
.55946 .67686 .56287 .68502 .56561 .67836 .56219 .6702 Mtetra
.689 .541 .68 r
.56219 .6702 .56561 .67836 .56833 .67068 .56491 .66253 Mtetra
.696 .544 .677 r
.56491 .66253 .56833 .67068 .57103 .66217 .56762 .65403 Mtetra
.701 .546 .675 r
.56762 .65403 .57103 .66217 .57373 .65304 .57032 .64492 Mtetra
.703 .548 .674 r
.57032 .64492 .57373 .65304 .57642 .64352 .57301 .63541 Mtetra
.704 .548 .673 r
.57301 .63541 .57642 .64352 .5791 .63385 .57569 .62574 Mtetra
.57569 .62574 .5791 .63385 .58178 .62427 .57837 .61617 Mtetra
.702 .547 .674 r
.57837 .61617 .58178 .62427 .58446 .61502 .58105 .60694 Mtetra
.698 .545 .676 r
.58105 .60694 .58446 .61502 .58714 .60635 .58373 .59827 Mtetra
.692 .542 .679 r
.58373 .59827 .58714 .60635 .58984 .59846 .58643 .59039 Mtetra
.683 .538 .682 r
.58643 .59039 .58984 .59846 .59255 .59154 .58914 .58348 Mtetra
.671 .532 .687 r
.58914 .58348 .59255 .59154 .59528 .58576 .59186 .57771 Mtetra
.655 .524 .693 r
.59186 .57771 .59528 .58576 .59802 .58124 .59461 .57318 Mtetra
.632 .513 .7 r
.59461 .57318 .59802 .58124 .6008 .57805 .59738 .56999 Mtetra
.601 .498 .708 r
.59738 .56999 .6008 .57805 .6036 .57622 .60018 .56816 Mtetra
.559 .476 .718 r
.60018 .56816 .6036 .57622 .60643 .57575 .60301 .56768 Mtetra
.501 .445 .726 r
.60301 .56768 .60643 .57575 .60929 .57655 .60586 .56848 Mtetra
.422 .402 .732 r
.60586 .56848 .60929 .57655 .61219 .57852 .60875 .57043 Mtetra
.323 .345 .729 r
.60875 .57043 .61219 .57852 .6151 .58148 .61166 .57338 Mtetra
.212 .28 .717 r
.61166 .57338 .6151 .58148 .61805 .58523 .6146 .57712 Mtetra
.116 .221 .697 r
.6146 .57712 .61805 .58523 .62101 .58953 .61755 .58139 Mtetra
.063 .188 .684 r
.61755 .58139 .62101 .58953 .62399 .59408 .62053 .58594 Mtetra
.072 .194 .687 r
.62053 .58594 .62399 .59408 .62698 .59862 .62351 .59045 Mtetra
.141 .237 .703 r
.62351 .59045 .62698 .59862 .62998 .60282 .62649 .59464 Mtetra
.247 .301 .722 r
.62649 .59464 .62998 .60282 .63296 .60642 .62947 .59822 Mtetra
.358 .365 .731 r
.62947 .59822 .63296 .60642 .63594 .60913 .63244 .60092 Mtetra
.453 .419 .73 r
.63244 .60092 .63594 .60913 .6389 .61074 .63539 .60252 Mtetra
.525 .458 .723 r
.63539 .60252 .6389 .61074 .64183 .61107 .63832 .60284 Mtetra
.578 .485 .713 r
.63832 .60284 .64183 .61107 .64473 .61002 .64122 .60178 Mtetra
.615 .504 .704 r
.64122 .60178 .64473 .61002 .6476 .60756 .64409 .59932 Mtetra
.642 .518 .697 r
.64409 .59932 .6476 .60756 .65044 .60373 .64692 .59549 Mtetra
.66 .526 .69 r
.64692 .59549 .65044 .60373 .65325 .59868 .64973 .59044 Mtetra
.672 .532 .686 r
.64973 .59044 .65325 .59868 .65603 .59261 .65251 .58438 Mtetra
.68 .536 .683 r
.65251 .58438 .65603 .59261 .65879 .58581 .65526 .57758 Mtetra
.684 .538 .681 r
.65526 .57758 .65879 .58581 .66154 .57861 .65801 .57039 Mtetra
.65801 .57039 .66154 .57861 .66428 .57137 .66075 .56316 Mtetra
.681 .537 .682 r
.66075 .56316 .66428 .57137 .66703 .56448 .66351 .55627 Mtetra
.674 .533 .685 r
.66351 .55627 .66703 .56448 .66981 .55828 .66628 .55008 Mtetra
.662 .527 .69 r
.66628 .55008 .66981 .55828 .67261 .5531 .66908 .5449 Mtetra
.643 .518 .696 r
.66908 .5449 .67261 .5531 .67545 .54916 .67192 .54096 Mtetra
.617 .506 .704 r
.67192 .54096 .67545 .54916 .67834 .54661 .6748 .5384 Mtetra
.581 .487 .713 r
.6748 .5384 .67834 .54661 .68127 .54545 .67773 .53724 Mtetra
.534 .463 .722 r
.67773 .53724 .68127 .54545 .68426 .54559 .68071 .53737 Mtetra
.482 .435 .729 r
.68071 .53737 .68426 .54559 .68728 .54676 .68372 .53853 Mtetra
.439 .412 .732 r
.68372 .53853 .68728 .54676 .69033 .5486 .68677 .54036 Mtetra
.424 .403 .732 r
.68677 .54036 .69033 .5486 .6934 .55065 .68983 .54239 Mtetra
.446 .416 .731 r
.68983 .54239 .6934 .55065 .69646 .5524 .69289 .54414 Mtetra
.495 .442 .727 r
.69289 .54414 .69646 .5524 .69951 .55336 .69593 .54509 Mtetra
.549 .471 .719 r
.69593 .54509 .69951 .55336 .70252 .55313 .69893 .54485 Mtetra
.594 .494 .71 r
.69893 .54485 .70252 .55313 .70548 .55147 .70189 .54319 Mtetra
.627 .51 .701 r
.70189 .54319 .70548 .55147 .70839 .54839 .7048 .5401 Mtetra
.647 .52 .695 r
.7048 .5401 .70839 .54839 .71127 .54417 .70767 .53588 Mtetra
.655 .524 .692 r
.70767 .53588 .71127 .54417 .71412 .53936 .71053 .53107 Mtetra
.653 .523 .693 r
.71053 .53107 .71412 .53936 .71699 .5347 .71339 .52642 Mtetra
.638 .516 .697 r
.71339 .52642 .71699 .5347 .71989 .53099 .71628 .5227 Mtetra
.609 .501 .706 r
.71628 .5227 .71989 .53099 .72285 .52874 .71924 .52045 Mtetra
.57 .482 .715 r
.71924 .52045 .72285 .52874 .72586 .52789 .72225 .5196 Mtetra
.554 .474 .719 r
.72225 .5196 .72586 .52789 .72891 .52752 .72529 .51921 Mtetra
.592 .493 .71 r
.72529 .51921 .72891 .52752 .73191 .52593 .72829 .51762 Mtetra
.621 .508 .703 r
.72829 .51762 .73191 .52593 .73486 .52309 .73123 .51478 Mtetra
.592 .493 .71 r
.73123 .51478 .73486 .52309 .73787 .5215 .73424 .51318 Mtetra
.554 .474 .719 r
.73424 .51318 .73787 .5215 .74093 .52112 .7373 .51279 Mtetra
.57 .482 .715 r
.7373 .51279 .74093 .52112 .74398 .52026 .74034 .51193 Mtetra
.609 .501 .706 r
.74034 .51193 .74398 .52026 .74697 .51799 .74333 .50965 Mtetra
.638 .516 .697 r
.74333 .50965 .74697 .51799 .7499 .51424 .74626 .5059 Mtetra
.653 .523 .692 r
.74626 .5059 .7499 .51424 .75279 .50955 .74914 .50121 Mtetra
.655 .524 .692 r
.74914 .50121 .75279 .50955 .75568 .50469 .75203 .49636 Mtetra
.647 .52 .695 r
.75203 .49636 .75568 .50469 .75859 .50042 .75494 .49209 Mtetra
.627 .51 .701 r
.75494 .49209 .75859 .50042 .76156 .49729 .7579 .48895 Mtetra
.595 .494 .71 r
.7579 .48895 .76156 .49729 .76459 .49557 .76093 .48723 Mtetra
.551 .472 .72 r
.76093 .48723 .76459 .49557 .7677 .49528 .76403 .48693 Mtetra
.499 .445 .727 r
.76403 .48693 .7677 .49528 .77087 .49619 .7672 .48783 Mtetra
.454 .421 .732 r
.7672 .48783 .77087 .49619 .77409 .4979 .77041 .48953 Mtetra
.433 .409 .733 r
.77041 .48953 .77409 .4979 .77733 .49992 .77364 .49154 Mtetra
.447 .417 .732 r
.77364 .49154 .77733 .49992 .78057 .50174 .77688 .49335 Mtetra
.487 .439 .729 r
.77688 .49335 .78057 .50174 .78379 .50289 .78008 .49448 Mtetra
.536 .464 .722 r
.78008 .49448 .78379 .50289 .78696 .50298 .78325 .49456 Mtetra
.581 .487 .713 r
.78325 .49456 .78696 .50298 .79006 .50176 .78635 .49334 Mtetra
.616 .505 .704 r
.78635 .49334 .79006 .50176 .7931 .4991 .78939 .49067 Mtetra
.642 .518 .696 r
.78939 .49067 .7931 .4991 .79607 .49502 .79235 .4866 Mtetra
.661 .526 .689 r
.79235 .4866 .79607 .49502 .79897 .48967 .79525 .48125 Mtetra
.673 .532 .685 r
.79525 .48125 .79897 .48967 .80182 .48328 .7981 .47487 Mtetra
.68 .535 .682 r
.7981 .47487 .80182 .48328 .80463 .47619 .80091 .46778 Mtetra
.684 .537 .68 r
.80091 .46778 .80463 .47619 .80742 .46876 .8037 .46036 Mtetra
.683 .537 .68 r
.8037 .46036 .80742 .46876 .81021 .46137 .80649 .45298 Mtetra
.679 .535 .682 r
.80649 .45298 .81021 .46137 .81302 .4544 .8093 .44601 Mtetra
.671 .531 .685 r
.8093 .44601 .81302 .4544 .81588 .44816 .81215 .43977 Mtetra
.659 .526 .69 r
.81215 .43977 .81588 .44816 .81879 .44294 .81506 .43456 Mtetra
.641 .517 .696 r
.81506 .43456 .81879 .44294 .82177 .43894 .81803 .43056 Mtetra
.616 .505 .704 r
.81803 .43056 .82177 .43894 .82483 .43631 .82109 .42792 Mtetra
.581 .487 .714 r
.82109 .42792 .82483 .43631 .82797 .43508 .82423 .42669 Mtetra
.534 .464 .723 r
.82423 .42669 .82797 .43508 .83121 .43524 .82746 .42683 Mtetra
.472 .431 .731 r
.82746 .42683 .83121 .43524 .83453 .43668 .83077 .42827 Mtetra
.398 .391 .735 r
.83077 .42827 .83453 .43668 .83792 .43925 .83416 .43082 Mtetra
.316 .345 .733 r
.83416 .43082 .83792 .43925 .84138 .44272 .83761 .43428 Mtetra
.242 .302 .726 r
.83761 .43428 .84138 .44272 .84489 .44685 .8411 .43839 Mtetra
.195 .274 .719 r
.8411 .43839 .84489 .44685 .84843 .45134 .84464 .44286 Mtetra
.188 .271 .718 r
.84464 .44286 .84843 .45134 .85199 .45589 .84819 .44739 Mtetra
.224 .292 .723 r
.84819 .44739 .85199 .45589 .85554 .46019 .85173 .45168 Mtetra
.29 .33 .731 r
.85173 .45168 .85554 .46019 .85907 .46397 .85526 .45544 Mtetra
.369 .375 .735 r
.85526 .45544 .85907 .46397 .86257 .46694 .85874 .4584 Mtetra
.445 .417 .733 r
.85874 .4584 .86257 .46694 .866 .46889 .86217 .46033 Mtetra
.51 .451 .726 r
.86217 .46033 .866 .46889 .86937 .46963 .86553 .46106 Mtetra
.561 .477 .718 r
.86553 .46106 .86937 .46963 .87266 .46902 .86881 .46044 Mtetra
.6 .497 .708 r
.86881 .46044 .87266 .46902 .87586 .46698 .87201 .4584 Mtetra
.63 .511 .7 r
.87201 .4584 .87586 .46698 .87896 .4635 .87511 .45492 Mtetra
.652 .522 .692 r
.87511 .45492 .87896 .4635 .88197 .45861 .87812 .45003 Mtetra
.669 .53 .686 r
.87812 .45003 .88197 .45861 .8849 .4524 .88104 .44382 Mtetra
.681 .535 .681 r
.88104 .44382 .8849 .4524 .88774 .44499 .88388 .43642 Mtetra
.69 .539 .677 r
.88388 .43642 .88774 .44499 .89051 .43658 .88665 .42802 Mtetra
.697 .542 .674 r
.88665 .42802 .89051 .43658 .89322 .42737 .88936 .41882 Mtetra
.701 .544 .672 r
.88936 .41882 .89322 .42737 .89589 .41758 .89203 .40904 Mtetra
.704 .545 .671 r
.89203 .40904 .89589 .41758 .89853 .40748 .89467 .39895 Mtetra
.704 .546 .67 r
.89467 .39895 .89853 .40748 .90116 .3973 .8973 .38879 Mtetra
.703 .545 .671 r
.8973 .38879 .90116 .3973 .9038 .38732 .89994 .37881 Mtetra
.7 .544 .672 r
.89994 .37881 .9038 .38732 .90646 .37775 .90261 .36926 Mtetra
.695 .542 .674 r
.90261 .36926 .90646 .37775 .90917 .36884 .90532 .36036 Mtetra
.688 .538 .678 r
.90532 .36036 .90917 .36884 .91194 .36078 .90809 .35231 Mtetra
.678 .534 .682 r
.90809 .35231 .91194 .36078 .91478 .35375 .91093 .34528 Mtetra
.665 .528 .687 r
.91093 .34528 .91478 .35375 .91771 .34788 .91385 .33942 Mtetra
.648 .52 .694 r
.91385 .33942 .91771 .34788 .92074 .3433 .91688 .33484 Mtetra
.625 .509 .701 r
.91688 .33484 .92074 .3433 .92387 .34007 .92001 .33161 Mtetra
.595 .495 .71 r
.92001 .33161 .92387 .34007 .92711 .33824 .92324 .32977 Mtetra
.555 .475 .72 r
.92324 .32977 .92711 .33824 .93047 .3378 .92659 .32932 Mtetra
.502 .448 .729 r
.92659 .32932 .93047 .3378 .93394 .33872 .93006 .33023 Mtetra
.431 .41 .735 r
.93006 .33023 .93394 .33872 .93752 .34093 .93363 .33243 Mtetra
.34 .36 .736 r
.93363 .33243 .93752 .34093 .9412 .34435 .93731 .33583 Mtetra
.227 .296 .726 r
.93731 .33583 .9412 .34435 .94499 .34883 .94108 .34029 Mtetra
.101 .221 .703 r
.94108 .34029 .94499 .34883 .94886 .35423 .94494 .34567 Mtetra
0 .144 .668 r
.94494 .34567 .94886 .35423 .9528 .36037 .94887 .35179 Mtetra
0 .078 .63 r
.94887 .35179 .9528 .36037 .95681 .36707 .95286 .35846 Mtetra
0 .036 .601 r
.95286 .35846 .95681 .36707 .96085 .37411 .9569 .36548 Mtetra
0 .022 .591 r
.9569 .36548 .96085 .37411 .96493 .38128 .96097 .37263 Mtetra
0 .039 .603 r
.96097 .37263 .96493 .38128 .96902 .38836 .96504 .37968 Mtetra
.874 .481 .016 r
.51453 .63222 .51784 .63916 .52058 .6461 .51726 .63913 Mtetra
.885 .493 .04 r
.51726 .63913 .52058 .6461 .52333 .65317 .52001 .64619 Mtetra
.876 .483 .021 r
.52001 .64619 .52333 .65317 .5261 .66019 .52276 .65319 Mtetra
.84 .446 0 r
.52276 .65319 .5261 .66019 .52887 .66693 .52553 .65991 Mtetra
.749 .364 0 r
.52553 .65991 .52887 .66693 .53166 .6732 .52831 .66616 Mtetra
0 0 .382 r
.52831 .66616 .53166 .6732 .53445 .67878 .53109 .67173 Mtetra
0 .016 .589 r
.53109 .67173 .53445 .67878 .53724 .68351 .53388 .67645 Mtetra
.086 .224 .711 r
.53388 .67645 .53724 .68351 .54004 .68722 .53667 .68014 Mtetra
.316 .358 .747 r
.53667 .68014 .54004 .68722 .54283 .68976 .53946 .68267 Mtetra
.457 .435 .746 r
.53946 .68267 .54283 .68976 .54563 .69102 .54224 .68393 Mtetra
.543 .479 .734 r
.54224 .68393 .54563 .69102 .54841 .69094 .54503 .68383 Mtetra
.598 .505 .721 r
.54503 .68383 .54841 .69094 .55119 .68946 .5478 .68235 Mtetra
.634 .522 .71 r
.5478 .68235 .55119 .68946 .55396 .68659 .55057 .67948 Mtetra
.659 .534 .7 r
.55057 .67948 .55396 .68659 .55672 .68237 .55332 .67526 Mtetra
.677 .542 .693 r
.55332 .67526 .55672 .68237 .55946 .67686 .55607 .66976 Mtetra
.689 .547 .687 r
.55607 .66976 .55946 .67686 .56219 .6702 .5588 .6631 Mtetra
.698 .551 .683 r
.5588 .6631 .56219 .6702 .56491 .66253 .56152 .65543 Mtetra
.705 .554 .68 r
.56152 .65543 .56491 .66253 .56762 .65403 .56422 .64694 Mtetra
.709 .556 .678 r
.56422 .64694 .56762 .65403 .57032 .64492 .56692 .63783 Mtetra
.712 .557 .676 r
.56692 .63783 .57032 .64492 .57301 .63541 .56961 .62833 Mtetra
.713 .557 .676 r
.56961 .62833 .57301 .63541 .57569 .62574 .57229 .61868 Mtetra
.57229 .61868 .57569 .62574 .57837 .61617 .57497 .60912 Mtetra
.71 .556 .677 r
.57497 .60912 .57837 .61617 .58105 .60694 .57766 .59989 Mtetra
.707 .554 .679 r
.57766 .59989 .58105 .60694 .58373 .59827 .58034 .59123 Mtetra
.701 .552 .682 r
.58034 .59123 .58373 .59827 .58643 .59039 .58304 .58336 Mtetra
.692 .548 .686 r
.58304 .58336 .58643 .59039 .58914 .58348 .58575 .57645 Mtetra
.68 .543 .692 r
.58575 .57645 .58914 .58348 .59186 .57771 .58847 .57068 Mtetra
.664 .536 .699 r
.58847 .57068 .59186 .57771 .59461 .57318 .59122 .56616 Mtetra
.641 .526 .707 r
.59122 .56616 .59461 .57318 .59738 .56999 .59399 .56296 Mtetra
.608 .511 .718 r
.59399 .56296 .59738 .56999 .60018 .56816 .59678 .56113 Mtetra
.561 .488 .731 r
.59678 .56113 .60018 .56816 .60301 .56768 .5996 .56064 Mtetra
.493 .454 .743 r
.5996 .56064 .60301 .56768 .60586 .56848 .60245 .56143 Mtetra
.396 .403 .75 r
.60245 .56143 .60586 .56848 .60875 .57043 .60533 .56338 Mtetra
.264 .331 .745 r
.60533 .56338 .60875 .57043 .61166 .57338 .60824 .56632 Mtetra
.111 .241 .719 r
.60824 .56632 .61166 .57338 .6146 .57712 .61117 .57004 Mtetra
0 .158 .681 r
.61117 .57004 .6146 .57712 .61755 .58139 .61412 .5743 Mtetra
0 .111 .654 r
.61412 .5743 .61755 .58139 .62053 .58594 .61708 .57883 Mtetra
0 .119 .659 r
.61708 .57883 .62053 .58594 .62351 .59045 .62006 .58333 Mtetra
.011 .18 .693 r
.62006 .58333 .62351 .59045 .62649 .59464 .62304 .58751 Mtetra
.16 .27 .729 r
.62304 .58751 .62649 .59464 .62947 .59822 .62601 .59107 Mtetra
.312 .357 .748 r
.62601 .59107 .62947 .59822 .63244 .60092 .62897 .59376 Mtetra
.435 .424 .748 r
.62897 .59376 .63244 .60092 .63539 .60252 .63192 .59535 Mtetra
.522 .469 .738 r
.63192 .59535 .63539 .60252 .63832 .60284 .63484 .59566 Mtetra
.582 .498 .725 r
.63484 .59566 .63832 .60284 .64122 .60178 .63774 .5946 Mtetra
.623 .517 .713 r
.63774 .5946 .64122 .60178 .64409 .59932 .6406 .59213 Mtetra
.65 .53 .703 r
.6406 .59213 .64409 .59932 .64692 .59549 .64343 .58831 Mtetra
.669 .538 .696 r
.64343 .58831 .64692 .59549 .64973 .59044 .64624 .58326 Mtetra
.682 .543 .69 r
.64624 .58326 .64973 .59044 .65251 .58438 .64901 .5772 Mtetra
.689 .547 .687 r
.64901 .5772 .65251 .58438 .65526 .57758 .65177 .5704 Mtetra
.693 .548 .685 r
.65177 .5704 .65526 .57758 .65801 .57039 .65452 .56321 Mtetra
.694 .549 .685 r
.65452 .56321 .65801 .57039 .66075 .56316 .65726 .55599 Mtetra
.69 .547 .686 r
.65726 .55599 .66075 .56316 .66351 .55627 .66001 .54911 Mtetra
.683 .544 .69 r
.66001 .54911 .66351 .55627 .66628 .55008 .66278 .54292 Mtetra
.671 .539 .695 r
.66278 .54292 .66628 .55008 .66908 .5449 .66558 .53774 Mtetra
.652 .531 .703 r
.66558 .53774 .66908 .5449 .67192 .54096 .66842 .5338 Mtetra
.625 .518 .713 r
.66842 .5338 .67192 .54096 .6748 .5384 .6713 .53124 Mtetra
.586 .5 .725 r
.6713 .53124 .6748 .5384 .67773 .53724 .67423 .53008 Mtetra
.533 .475 .737 r
.67423 .53008 .67773 .53724 .68071 .53737 .6772 .5302 Mtetra
.471 .444 .746 r
.6772 .5302 .68071 .53737 .68372 .53853 .68021 .53135 Mtetra
.418 .416 .75 r
.68021 .53135 .68372 .53853 .68677 .54036 .68325 .53316 Mtetra
.398 .405 .751 r
.68325 .53316 .68677 .54036 .68983 .54239 .6863 .53519 Mtetra
.426 .42 .75 r
.6863 .53519 .68983 .54239 .69289 .54414 .68936 .53692 Mtetra
.486 .451 .744 r
.68936 .53692 .69289 .54414 .69593 .54509 .69239 .53787 Mtetra
.55 .483 .733 r
.69239 .53787 .69593 .54509 .69893 .54485 .69539 .53762 Mtetra
.601 .507 .72 r
.69539 .53762 .69893 .54485 .70189 .54319 .69834 .53595 Mtetra
.635 .523 .709 r
.69834 .53595 .70189 .54319 .7048 .5401 .70125 .53287 Mtetra
.656 .532 .701 r
.70125 .53287 .7048 .5401 .70767 .53588 .70412 .52864 Mtetra
.665 .536 .698 r
.70412 .52864 .70767 .53588 .71053 .53107 .70697 .52383 Mtetra
.662 .535 .699 r
.70697 .52383 .71053 .53107 .71339 .52642 .70983 .51919 Mtetra
.647 .528 .705 r
.70983 .51919 .71339 .52642 .71628 .5227 .71272 .51547 Mtetra
.616 .514 .716 r
.71272 .51547 .71628 .5227 .71924 .52045 .71568 .51321 Mtetra
.574 .495 .728 r
.71568 .51321 .71924 .52045 .72225 .5196 .71869 .51235 Mtetra
.556 .486 .732 r
.71869 .51235 .72225 .5196 .72529 .51921 .72172 .51196 Mtetra
.598 .506 .721 r
.72172 .51196 .72529 .51921 .72829 .51762 .72471 .51036 Mtetra
.629 .52 .711 r
.72471 .51036 .72829 .51762 .73123 .51478 .72766 .50753 Mtetra
.598 .506 .721 r
.72766 .50753 .73123 .51478 .73424 .51318 .73066 .50592 Mtetra
.556 .486 .732 r
.73066 .50592 .73424 .51318 .7373 .51279 .73371 .50552 Mtetra
.574 .495 .728 r
.73371 .50552 .7373 .51279 .74034 .51193 .73675 .50466 Mtetra
.616 .514 .716 r
.73675 .50466 .74034 .51193 .74333 .50965 .73973 .50238 Mtetra
.647 .528 .705 r
.73973 .50238 .74333 .50965 .74626 .5059 .74266 .49863 Mtetra
.662 .535 .698 r
.74266 .49863 .74626 .5059 .74914 .50121 .74554 .49394 Mtetra
.665 .536 .698 r
.74554 .49394 .74914 .50121 .75203 .49636 .74843 .48908 Mtetra
.656 .532 .701 r
.74843 .48908 .75203 .49636 .75494 .49209 .75133 .48481 Mtetra
.635 .523 .709 r
.75133 .48481 .75494 .49209 .7579 .48895 .75429 .48167 Mtetra
.601 .507 .72 r
.75429 .48167 .7579 .48895 .76093 .48723 .75732 .47995 Mtetra
.552 .484 .733 r
.75732 .47995 .76093 .48723 .76403 .48693 .76042 .47964 Mtetra
.492 .455 .744 r
.76042 .47964 .76403 .48693 .7672 .48783 .76358 .48053 Mtetra
.436 .426 .75 r
.76358 .48053 .7672 .48783 .77041 .48953 .76678 .48222 Mtetra
.41 .413 .751 r
.76678 .48222 .77041 .48953 .77364 .49154 .77001 .48422 Mtetra
.428 .422 .75 r
.77001 .48422 .77364 .49154 .77688 .49335 .77324 .48602 Mtetra
.477 .447 .746 r
.77324 .48602 .77688 .49335 .78008 .49448 .77644 .48714 Mtetra
.535 .476 .736 r
.77644 .48714 .78008 .49448 .78325 .49456 .7796 .48722 Mtetra
.586 .5 .725 r
.7796 .48722 .78325 .49456 .78635 .49334 .7827 .48598 Mtetra
.624 .518 .713 r
.7827 .48598 .78635 .49334 .78939 .49067 .78573 .48332 Mtetra
.651 .53 .703 r
.78573 .48332 .78939 .49067 .79235 .4866 .78869 .47924 Mtetra
.67 .538 .695 r
.78869 .47924 .79235 .4866 .79525 .48125 .79159 .47389 Mtetra
.683 .543 .689 r
.79159 .47389 .79525 .48125 .7981 .47487 .79444 .46752 Mtetra
.69 .546 .686 r
.79444 .46752 .7981 .47487 .80091 .46778 .79724 .46044 Mtetra
.693 .548 .684 r
.79724 .46044 .80091 .46778 .8037 .46036 .80003 .45302 Mtetra
.693 .547 .684 r
.80003 .45302 .8037 .46036 .80649 .45298 .80282 .44564 Mtetra
.689 .546 .686 r
.80282 .44564 .80649 .45298 .8093 .44601 .80563 .43867 Mtetra
.681 .543 .69 r
.80563 .43867 .8093 .44601 .81215 .43977 .80848 .43244 Mtetra
.668 .537 .696 r
.80848 .43244 .81215 .43977 .81506 .43456 .81139 .42723 Mtetra
.65 .529 .703 r
.81139 .42723 .81506 .43456 .81803 .43056 .81436 .42323 Mtetra
.623 .518 .713 r
.81436 .42323 .81803 .43056 .82109 .42792 .81742 .42059 Mtetra
.585 .5 .725 r
.81742 .42059 .82109 .42792 .82423 .42669 .82055 .41935 Mtetra
.532 .475 .738 r
.82055 .41935 .82423 .42669 .82746 .42683 .82378 .41949 Mtetra
.459 .439 .748 r
.82378 .41949 .82746 .42683 .83077 .42827 .82708 .42091 Mtetra
.365 .39 .753 r
.82708 .42091 .83077 .42827 .83416 .43082 .83046 .42346 Mtetra
.258 .33 .748 r
.83046 .42346 .83416 .43082 .83761 .43428 .8339 .4269 Mtetra
.157 .273 .733 r
.8339 .4269 .83761 .43428 .8411 .43839 .83739 .431 Mtetra
.093 .235 .72 r
.83739 .431 .8411 .43839 .84464 .44286 .84092 .43545 Mtetra
.084 .23 .718 r
.84092 .43545 .84464 .44286 .84819 .44739 .84446 .43996 Mtetra
.133 .259 .729 r
.84446 .43996 .84819 .44739 .85173 .45168 .848 .44424 Mtetra
.224 .311 .744 r
.848 .44424 .85173 .45168 .85526 .45544 .85151 .44798 Mtetra
.329 .37 .753 r
.85151 .44798 .85526 .45544 .85874 .4584 .85499 .45093 Mtetra
.426 .421 .751 r
.85499 .45093 .85874 .4584 .86217 .46033 .85841 .45285 Mtetra
.504 .461 .742 r
.85841 .45285 .86217 .46033 .86553 .46106 .86177 .45357 Mtetra
.563 .49 .73 r
.86177 .45357 .86553 .46106 .86881 .46044 .86504 .45294 Mtetra
.607 .51 .718 r
.86504 .45294 .86881 .46044 .87201 .4584 .86823 .4509 Mtetra
.638 .524 .707 r
.86823 .4509 .87201 .4584 .87511 .45492 .87133 .44742 Mtetra
.662 .534 .698 r
.87133 .44742 .87511 .45492 .87812 .45003 .87434 .44253 Mtetra
.679 .541 .691 r
.87434 .44253 .87812 .45003 .88104 .44382 .87726 .43632 Mtetra
.691 .546 .685 r
.87726 .43632 .88104 .44382 .88388 .43642 .8801 .42893 Mtetra
.7 .55 .68 r
.8801 .42893 .88388 .43642 .88665 .42802 .88287 .42053 Mtetra
.707 .552 .677 r
.88287 .42053 .88665 .42802 .88936 .41882 .88558 .41134 Mtetra
.711 .554 .674 r
.88558 .41134 .88936 .41882 .89203 .40904 .88825 .40158 Mtetra
.713 .555 .673 r
.88825 .40158 .89203 .40904 .89467 .39895 .89089 .39149 Mtetra
.714 .555 .673 r
.89089 .39149 .89467 .39895 .8973 .38879 .89353 .38134 Mtetra
.712 .555 .673 r
.89353 .38134 .8973 .38879 .89994 .37881 .89617 .37138 Mtetra
.71 .554 .675 r
.89617 .37138 .89994 .37881 .90261 .36926 .89884 .36183 Mtetra
.705 .552 .678 r
.89884 .36183 .90261 .36926 .90532 .36036 .90155 .35294 Mtetra
.698 .549 .681 r
.90155 .35294 .90532 .36036 .90809 .35231 .90431 .34489 Mtetra
.688 .545 .686 r
.90431 .34489 .90809 .35231 .91093 .34528 .90715 .33787 Mtetra
.675 .54 .692 r
.90715 .33787 .91093 .34528 .91385 .33942 .91008 .33201 Mtetra
.657 .532 .7 r
.91008 .33201 .91385 .33942 .91688 .33484 .9131 .32743 Mtetra
.634 .522 .71 r
.9131 .32743 .91688 .33484 .92001 .33161 .91623 .3242 Mtetra
.601 .508 .721 r
.91623 .3242 .92001 .33161 .92324 .32977 .91946 .32235 Mtetra
.557 .487 .733 r
.91946 .32235 .92324 .32977 .92659 .32932 .9228 .3219 Mtetra
.495 .458 .745 r
.9228 .3219 .92659 .32932 .93006 .33023 .92626 .3228 Mtetra
.409 .414 .754 r
.92626 .3228 .93006 .33023 .93363 .33243 .92983 .32499 Mtetra
.291 .351 .752 r
.92983 .32499 .93363 .33243 .93731 .33583 .93349 .32837 Mtetra
.14 .265 .732 r
.93349 .32837 .93731 .33583 .94108 .34029 .93726 .33282 Mtetra
0 .162 .687 r
.93726 .33282 .94108 .34029 .94494 .34567 .94111 .33818 Mtetra
0 .057 .621 r
.94111 .33818 .94494 .34567 .94887 .35179 .94503 .34428 Mtetra
0 0 .553 r
.94503 .34428 .94887 .35179 .95286 .35846 .94901 .35094 Mtetra
0 0 .506 r
.94901 .35094 .95286 .35846 .9569 .36548 .95304 .35793 Mtetra
0 0 .49 r
.95304 .35793 .9569 .36548 .96097 .37263 .95709 .36505 Mtetra
0 0 .51 r
.95709 .36505 .96097 .37263 .96504 .37968 .96116 .37209 Mtetra
.924 .534 .199 r
.51122 .62642 .51453 .63222 .51726 .63913 .51395 .63332 Mtetra
.926 .539 .216 r
.51395 .63332 .51726 .63913 .52001 .64619 .51669 .64037 Mtetra
.924 .535 .203 r
.51669 .64037 .52001 .64619 .52276 .65319 .51944 .64735 Mtetra
.916 .517 .156 r
.51944 .64735 .52276 .65319 .52553 .65991 .5222 .65406 Mtetra
.887 .474 .059 r
.5222 .65406 .52553 .65991 .52831 .66616 .52496 .66029 Mtetra
.798 .376 0 r
.52496 .66029 .52831 .66616 .53109 .67173 .52774 .66585 Mtetra
0 0 .41 r
.52774 .66585 .53109 .67173 .53388 .67645 .53052 .67056 Mtetra
0 .128 .674 r
.53052 .67056 .53388 .67645 .53667 .68014 .5333 .67424 Mtetra
.23 .34 .77 r
.5333 .67424 .53667 .68014 .53946 .68267 .53609 .67676 Mtetra
.433 .446 .773 r
.53609 .67676 .53946 .68267 .54224 .68393 .53887 .67801 Mtetra
.543 .497 .755 r
.53887 .67801 .54224 .68393 .54503 .68383 .54165 .67791 Mtetra
.606 .524 .736 r
.54165 .67791 .54503 .68383 .5478 .68235 .54442 .67643 Mtetra
.645 .54 .721 r
.54442 .67643 .5478 .68235 .55057 .67948 .54719 .67355 Mtetra
.671 .55 .709 r
.54719 .67355 .55057 .67948 .55332 .67526 .54994 .66933 Mtetra
.689 .556 .699 r
.54994 .66933 .55332 .67526 .55607 .66976 .55268 .66383 Mtetra
.701 .561 .692 r
.55268 .66383 .55607 .66976 .5588 .6631 .55542 .65718 Mtetra
.71 .564 .687 r
.55542 .65718 .5588 .6631 .56152 .65543 .55814 .64951 Mtetra
.716 .566 .683 r
.55814 .64951 .56152 .65543 .56422 .64694 .56084 .64103 Mtetra
.72 .567 .681 r
.56084 .64103 .56422 .64694 .56692 .63783 .56354 .63192 Mtetra
.723 .568 .679 r
.56354 .63192 .56692 .63783 .56961 .62833 .56623 .62243 Mtetra
.724 .568 .679 r
.56623 .62243 .56961 .62833 .57229 .61868 .56892 .61278 Mtetra
.723 .568 .679 r
.56892 .61278 .57229 .61868 .57497 .60912 .5716 .60323 Mtetra
.721 .568 .68 r
.5716 .60323 .57497 .60912 .57766 .59989 .57428 .59401 Mtetra
.718 .566 .683 r
.57428 .59401 .57766 .59989 .58034 .59123 .57697 .58535 Mtetra
.712 .565 .686 r
.57697 .58535 .58034 .59123 .58304 .58336 .57967 .57748 Mtetra
.704 .562 .691 r
.57967 .57748 .58304 .58336 .58575 .57645 .58238 .57058 Mtetra
.692 .558 .697 r
.58238 .57058 .58575 .57645 .58847 .57068 .5851 .56481 Mtetra
.676 .552 .706 r
.5851 .56481 .58847 .57068 .59122 .56616 .58784 .56029 Mtetra
.652 .543 .718 r
.58784 .56029 .59122 .56616 .59399 .56296 .59061 .55709 Mtetra
.617 .529 .732 r
.59061 .55709 .59399 .56296 .59678 .56113 .5934 .55526 Mtetra
.564 .507 .75 r
.5934 .55526 .59678 .56113 .5996 .56064 .59622 .55476 Mtetra
.48 .469 .768 r
.59622 .55476 .5996 .56064 .60245 .56143 .59907 .55554 Mtetra
.348 .404 .778 r
.59907 .55554 .60245 .56143 .60533 .56338 .60194 .55748 Mtetra
.153 .299 .76 r
.60194 .55748 .60533 .56338 .60824 .56632 .60484 .56041 Mtetra
0 .159 .694 r
.60484 .56041 .60824 .56632 .61117 .57004 .60777 .56412 Mtetra
0 .03 .601 r
.60777 .56412 .61117 .57004 .61412 .5743 .61071 .56837 Mtetra
0 0 .542 r
.61071 .56837 .61412 .5743 .61708 .57883 .61367 .57289 Mtetra
0 0 .553 r
.61367 .57289 .61708 .57883 .62006 .58333 .61664 .57738 Mtetra
0 .063 .628 r
.61664 .57738 .62006 .58333 .62304 .58751 .61961 .58154 Mtetra
0 .204 .72 r
.61961 .58154 .62304 .58751 .62601 .59107 .62258 .5851 Mtetra
.225 .339 .771 r
.62258 .5851 .62601 .59107 .62897 .59376 .62553 .58778 Mtetra
.403 .432 .776 r
.62553 .58778 .62897 .59376 .63192 .59535 .62847 .58936 Mtetra
.517 .486 .761 r
.62847 .58936 .63192 .59535 .63484 .59566 .63139 .58967 Mtetra
.589 .517 .742 r
.63139 .58967 .63484 .59566 .63774 .5946 .63428 .5886 Mtetra
.633 .535 .726 r
.63428 .5886 .63774 .5946 .6406 .59213 .63714 .58613 Mtetra
.663 .547 .713 r
.63714 .58613 .6406 .59213 .64343 .58831 .63998 .5823 Mtetra
.682 .554 .703 r
.63998 .5823 .64343 .58831 .64624 .58326 .64278 .57725 Mtetra
.694 .558 .696 r
.64278 .57725 .64624 .58326 .64901 .5772 .64556 .5712 Mtetra
.702 .561 .692 r
.64556 .5712 .64901 .5772 .65177 .5704 .64831 .56441 Mtetra
.705 .562 .69 r
.64831 .56441 .65177 .5704 .65452 .56321 .65106 .55722 Mtetra
.706 .562 .69 r
.65106 .55722 .65452 .56321 .65726 .55599 .6538 .55 Mtetra
.703 .561 .691 r
.6538 .55 .65726 .55599 .66001 .54911 .65655 .54312 Mtetra
.695 .559 .695 r
.65655 .54312 .66001 .54911 .66278 .54292 .65932 .53693 Mtetra
.683 .554 .702 r
.65932 .53693 .66278 .54292 .66558 .53774 .66212 .53176 Mtetra
.664 .547 .712 r
.66212 .53176 .66558 .53774 .66842 .5338 .66496 .52782 Mtetra
.635 .536 .725 r
.66496 .52782 .66842 .5338 .6713 .53124 .66784 .52525 Mtetra
.592 .519 .741 r
.66784 .52525 .6713 .53124 .67423 .53008 .67076 .52408 Mtetra
.53 .492 .758 r
.67076 .52408 .67423 .53008 .6772 .5302 .67373 .52419 Mtetra
.452 .456 .772 r
.67373 .52419 .6772 .5302 .68021 .53135 .67673 .52534 Mtetra
.38 .421 .778 r
.67673 .52534 .68021 .53135 .68325 .53316 .67977 .52715 Mtetra
.353 .407 .778 r
.67977 .52715 .68325 .53316 .6863 .53519 .68282 .52917 Mtetra
.392 .427 .777 r
.68282 .52917 .6863 .53519 .68936 .53692 .68586 .53089 Mtetra
.472 .465 .769 r
.68586 .53089 .68936 .53692 .69239 .53787 .68889 .53183 Mtetra
.551 .501 .753 r
.68889 .53183 .69239 .53787 .69539 .53762 .69189 .53158 Mtetra
.609 .526 .735 r
.69189 .53158 .69539 .53762 .69834 .53595 .69484 .5299 Mtetra
.647 .541 .72 r
.69484 .5299 .69834 .53595 .70125 .53287 .69775 .52682 Mtetra
.668 .549 .71 r
.69775 .52682 .70125 .53287 .70412 .52864 .70061 .52259 Mtetra
.677 .552 .705 r
.70061 .52259 .70412 .52864 .70697 .52383 .70346 .51778 Mtetra
.675 .551 .706 r
.70346 .51778 .70697 .52383 .70983 .51919 .70632 .51313 Mtetra
.659 .545 .714 r
.70632 .51313 .70983 .51919 .71272 .51547 .70921 .50941 Mtetra
.626 .533 .729 r
.70921 .50941 .71272 .51547 .71568 .51321 .71216 .50715 Mtetra
.579 .513 .745 r
.71216 .50715 .71568 .51321 .71869 .51235 .71517 .50629 Mtetra
.558 .504 .752 r
.71517 .50629 .71869 .51235 .72172 .51196 .7182 .50589 Mtetra
.606 .525 .736 r
.7182 .50589 .72172 .51196 .72471 .51036 .72118 .50429 Mtetra
.64 .538 .723 r
.72118 .50429 .72471 .51036 .72766 .50753 .72413 .50145 Mtetra
.606 .525 .736 r
.72413 .50145 .72766 .50753 .73066 .50592 .72712 .49984 Mtetra
.558 .504 .752 r
.72712 .49984 .73066 .50592 .73371 .50552 .73017 .49944 Mtetra
.579 .513 .745 r
.73017 .49944 .73371 .50552 .73675 .50466 .73321 .49857 Mtetra
.626 .533 .729 r
.73321 .49857 .73675 .50466 .73973 .50238 .73619 .49629 Mtetra
.659 .545 .714 r
.73619 .49629 .73973 .50238 .74266 .49863 .73911 .49253 Mtetra
.675 .551 .706 r
.73911 .49253 .74266 .49863 .74554 .49394 .742 .48784 Mtetra
.677 .552 .705 r
.742 .48784 .74554 .49394 .74843 .48908 .74488 .48299 Mtetra
.668 .548 .71 r
.74488 .48299 .74843 .48908 .75133 .48481 .74778 .47872 Mtetra
.647 .54 .72 r
.74778 .47872 .75133 .48481 .75429 .48167 .75074 .47558 Mtetra
.61 .526 .735 r
.75074 .47558 .75429 .48167 .75732 .47995 .75377 .47385 Mtetra
.553 .502 .753 r
.75377 .47385 .75732 .47995 .76042 .47964 .75686 .47354 Mtetra
.479 .469 .769 r
.75686 .47354 .76042 .47964 .76358 .48053 .76002 .47442 Mtetra
.406 .434 .777 r
.76002 .47442 .76358 .48053 .76678 .48222 .76321 .4761 Mtetra
.371 .417 .779 r
.76321 .4761 .76678 .48222 .77001 .48422 .76644 .47809 Mtetra
.395 .429 .778 r
.76644 .47809 .77001 .48422 .77324 .48602 .76966 .47988 Mtetra
.46 .46 .771 r
.76966 .47988 .77324 .48602 .77644 .48714 .77285 .481 Mtetra
.533 .494 .758 r
.77285 .481 .77644 .48714 .7796 .48722 .77601 .48106 Mtetra
.592 .519 .741 r
.77601 .48106 .7796 .48722 .7827 .48598 .7791 .47983 Mtetra
.635 .536 .725 r
.7791 .47983 .7827 .48598 .78573 .48332 .78213 .47716 Mtetra
.664 .547 .712 r
.78213 .47716 .78573 .48332 .78869 .47924 .78509 .47308 Mtetra
.683 .554 .702 r
.78509 .47308 .78869 .47924 .79159 .47389 .78799 .46773 Mtetra
.695 .558 .695 r
.78799 .46773 .79159 .47389 .79444 .46752 .79084 .46136 Mtetra
.702 .56 .691 r
.79084 .46136 .79444 .46752 .79724 .46044 .79365 .45428 Mtetra
.706 .561 .689 r
.79365 .45428 .79724 .46044 .80003 .45302 .79643 .44687 Mtetra
.705 .561 .689 r
.79643 .44687 .80003 .45302 .80282 .44564 .79922 .43949 Mtetra
.701 .56 .691 r
.79922 .43949 .80282 .44564 .80563 .43867 .80203 .43253 Mtetra
.694 .557 .696 r
.80203 .43253 .80563 .43867 .80848 .43244 .80488 .4263 Mtetra
.681 .553 .703 r
.80488 .4263 .80848 .43244 .81139 .42723 .80779 .42109 Mtetra
.662 .546 .713 r
.80779 .42109 .81139 .42723 .81436 .42323 .81076 .41709 Mtetra
.634 .536 .725 r
.81076 .41709 .81436 .42323 .81742 .42059 .81381 .41444 Mtetra
.592 .519 .741 r
.81381 .41444 .81742 .42059 .82055 .41935 .81695 .4132 Mtetra
.529 .492 .759 r
.81695 .4132 .82055 .41935 .82378 .41949 .82016 .41333 Mtetra
.437 .45 .775 r
.82016 .41333 .82378 .41949 .82708 .42091 .82346 .41475 Mtetra
.308 .385 .779 r
.82346 .41475 .82708 .42091 .83046 .42346 .82683 .41728 Mtetra
.15 .3 .762 r
.82683 .41728 .83046 .42346 .8339 .4269 .83027 .42071 Mtetra
0 .212 .725 r
.83027 .42071 .8339 .4269 .83739 .431 .83375 .4248 Mtetra
0 .153 .691 r
.83375 .4248 .83739 .431 .84092 .43545 .83727 .42924 Mtetra
0 .145 .686 r
.83727 .42924 .84092 .43545 .84446 .43996 .8408 .43374 Mtetra
0 .19 .713 r
.8408 .43374 .84446 .43996 .848 .44424 .84433 .438 Mtetra
.099 .271 .752 r
.84433 .438 .848 .44424 .85151 .44798 .84784 .44173 Mtetra
.255 .357 .776 r
.84784 .44173 .85151 .44798 .85499 .45093 .85131 .44467 Mtetra
.392 .428 .778 r
.85131 .44467 .85499 .45093 .85841 .45285 .85473 .44658 Mtetra
.495 .477 .766 r
.85473 .44658 .85841 .45285 .86177 .45357 .85808 .44729 Mtetra
.567 .508 .749 r
.85808 .44729 .86177 .45357 .86504 .45294 .86135 .44666 Mtetra
.616 .528 .732 r
.86135 .44666 .86504 .45294 .86823 .4509 .86454 .44461 Mtetra
.65 .542 .718 r
.86454 .44461 .86823 .4509 .87133 .44742 .86763 .44113 Mtetra
.674 .55 .706 r
.86763 .44113 .87133 .44742 .87434 .44253 .87064 .43624 Mtetra
.691 .556 .697 r
.87064 .43624 .87434 .44253 .87726 .43632 .87356 .43004 Mtetra
.704 .561 .69 r
.87356 .43004 .87726 .43632 .8801 .42893 .8764 .42265 Mtetra
.713 .563 .684 r
.8764 .42265 .8801 .42893 .88287 .42053 .87917 .41426 Mtetra
.719 .565 .68 r
.87917 .41426 .88287 .42053 .88558 .41134 .88189 .40507 Mtetra
.723 .567 .678 r
.88189 .40507 .88558 .41134 .88825 .40158 .88456 .39531 Mtetra
.725 .567 .676 r
.88456 .39531 .88825 .40158 .89089 .39149 .8872 .38524 Mtetra
.8872 .38524 .89089 .39149 .89353 .38134 .88984 .37509 Mtetra
.724 .567 .676 r
.88984 .37509 .89353 .38134 .89617 .37138 .89248 .36513 Mtetra
.722 .566 .678 r
.89248 .36513 .89617 .37138 .89884 .36183 .89515 .3556 Mtetra
.717 .565 .681 r
.89515 .3556 .89884 .36183 .90155 .35294 .89786 .34671 Mtetra
.71 .563 .686 r
.89786 .34671 .90155 .35294 .90431 .34489 .90063 .33867 Mtetra
.701 .56 .691 r
.90063 .33867 .90431 .34489 .90715 .33787 .90347 .33165 Mtetra
.688 .555 .699 r
.90347 .33165 .90715 .33787 .91008 .33201 .9064 .32579 Mtetra
.67 .549 .709 r
.9064 .32579 .91008 .33201 .9131 .32743 .90942 .32121 Mtetra
.645 .54 .721 r
.90942 .32121 .9131 .32743 .91623 .3242 .91254 .31797 Mtetra
.61 .526 .735 r
.91254 .31797 .91623 .3242 .91946 .32235 .91577 .31612 Mtetra
.559 .505 .752 r
.91577 .31612 .91946 .32235 .9228 .3219 .91911 .31566 Mtetra
.483 .472 .769 r
.91911 .31566 .9228 .3219 .92626 .3228 .92256 .31655 Mtetra
.37 .418 .78 r
.92256 .31655 .92626 .3228 .92983 .32499 .92612 .31873 Mtetra
.202 .33 .772 r
.92612 .31873 .92983 .32499 .93349 .32837 .92978 .32211 Mtetra
0 .202 .72 r
.92978 .32211 .93349 .32837 .93726 .33282 .93354 .32654 Mtetra
0 .048 .616 r
.93354 .32654 .93726 .33282 .94111 .33818 .93738 .33189 Mtetra
0 0 .486 r
.93738 .33189 .94111 .33818 .94503 .34428 .94129 .33798 Mtetra
0 0 .376 r
.94129 .33798 .94503 .34428 .94901 .35094 .94526 .34461 Mtetra
.658 .242 0 r
.94526 .34461 .94901 .35094 .95304 .35793 .94928 .35159 Mtetra
.676 .258 0 r
.94928 .35159 .95304 .35793 .95709 .36505 .95332 .3587 Mtetra
.653 .239 0 r
.95332 .3587 .95709 .36505 .96116 .37209 .95738 .36572 Mtetra
.908 .543 .331 r
.50792 .62186 .51122 .62642 .51395 .63332 .51064 .62876 Mtetra
.907 .546 .34 r
.51064 .62876 .51395 .63332 .51669 .64037 .51337 .63579 Mtetra
.908 .543 .333 r
.51337 .63579 .51669 .64037 .51944 .64735 .51611 .64276 Mtetra
.909 .535 .306 r
.51611 .64276 .51944 .64735 .5222 .65406 .51887 .64947 Mtetra
.908 .516 .251 r
.51887 .64947 .5222 .65406 .52496 .66029 .52163 .65569 Mtetra
.894 .471 .141 r
.52163 .65569 .52496 .66029 .52774 .66585 .5244 .66124 Mtetra
.815 .358 0 r
.5244 .66124 .52774 .66585 .53052 .67056 .52717 .66594 Mtetra
0 0 .479 r
.52717 .66594 .53052 .67056 .5333 .67424 .52995 .66961 Mtetra
.04 .286 .779 r
.52995 .66961 .5333 .67424 .53609 .67676 .53273 .67213 Mtetra
.385 .462 .817 r
.53273 .67213 .53609 .67676 .53887 .67801 .53551 .67337 Mtetra
.541 .526 .788 r
.53551 .67337 .53887 .67801 .54165 .67791 .53829 .67327 Mtetra
.618 .552 .758 r
.53829 .67327 .54165 .67791 .54442 .67643 .54106 .67178 Mtetra
.661 .565 .736 r
.54106 .67178 .54442 .67643 .54719 .67355 .54382 .66891 Mtetra
.687 .572 .719 r
.54382 .66891 .54719 .67355 .54994 .66933 .54657 .66468 Mtetra
.705 .576 .707 r
.54657 .66468 .54994 .66933 .55268 .66383 .54931 .65918 Mtetra
.716 .578 .699 r
.54931 .65918 .55268 .66383 .55542 .65718 .55205 .65253 Mtetra
.725 .58 .692 r
.55205 .65253 .55542 .65718 .55814 .64951 .55477 .64487 Mtetra
.73 .581 .688 r
.55477 .64487 .55814 .64951 .56084 .64103 .55748 .63638 Mtetra
.734 .582 .685 r
.55748 .63638 .56084 .64103 .56354 .63192 .56018 .62728 Mtetra
.736 .582 .683 r
.56018 .62728 .56354 .63192 .56623 .62243 .56287 .61779 Mtetra
.737 .582 .682 r
.56287 .61779 .56623 .62243 .56892 .61278 .56556 .60815 Mtetra
.56556 .60815 .56892 .61278 .5716 .60323 .56824 .5986 Mtetra
.735 .582 .684 r
.56824 .5986 .5716 .60323 .57428 .59401 .57093 .58938 Mtetra
.732 .581 .687 r
.57093 .58938 .57428 .59401 .57697 .58535 .57362 .58073 Mtetra
.727 .58 .691 r
.57362 .58073 .57697 .58535 .57967 .57748 .57631 .57286 Mtetra
.719 .579 .697 r
.57631 .57286 .57967 .57748 .58238 .57058 .57902 .56596 Mtetra
.708 .576 .705 r
.57902 .56596 .58238 .57058 .5851 .56481 .58175 .56019 Mtetra
.692 .573 .716 r
.58175 .56019 .5851 .56481 .58784 .56029 .58449 .55566 Mtetra
.668 .567 .731 r
.58449 .55566 .58784 .56029 .59061 .55709 .58726 .55247 Mtetra
.63 .556 .752 r
.58726 .55247 .59061 .55709 .5934 .55526 .59005 .55063 Mtetra
.568 .535 .779 r
.59005 .55063 .5934 .55526 .59622 .55476 .59286 .55013 Mtetra
.456 .493 .808 r
.59286 .55013 .59622 .55476 .59907 .55554 .59571 .55091 Mtetra
.251 .398 .817 r
.59571 .55091 .59907 .55554 .60194 .55748 .59858 .55284 Mtetra
0 .212 .737 r
.59858 .55284 .60194 .55748 .60484 .56041 .60147 .55576 Mtetra
0 0 .535 r
.60147 .55576 .60484 .56041 .60777 .56412 .60439 .55947 Mtetra
.642 .187 0 r
.60439 .55947 .60777 .56412 .61071 .56837 .60733 .56371 Mtetra
.715 .253 0 r
.60733 .56371 .61071 .56837 .61367 .57289 .61028 .56822 Mtetra
.704 .243 0 r
.61028 .56822 .61367 .57289 .61664 .57738 .61324 .5727 Mtetra
.598 .15 0 r
.61324 .5727 .61664 .57738 .61961 .58154 .61621 .57685 Mtetra
0 .047 .605 r
.61621 .57685 .61961 .58154 .62258 .5851 .61917 .5804 Mtetra
.039 .285 .779 r
.61917 .5804 .62258 .5851 .62553 .58778 .62212 .58307 Mtetra
.339 .441 .819 r
.62212 .58307 .62553 .58778 .62847 .58936 .62506 .58465 Mtetra
.507 .513 .797 r
.62506 .58465 .62847 .58936 .63139 .58967 .62797 .58495 Mtetra
.597 .545 .767 r
.62797 .58495 .63139 .58967 .63428 .5886 .63086 .58388 Mtetra
.648 .561 .743 r
.63086 .58388 .63428 .5886 .63714 .58613 .63372 .58141 Mtetra
.679 .569 .725 r
.63372 .58141 .63714 .58613 .63998 .5823 .63655 .57758 Mtetra
.698 .574 .712 r
.63655 .57758 .63998 .5823 .64278 .57725 .63935 .57253 Mtetra
.71 .577 .704 r
.63935 .57253 .64278 .57725 .64556 .5712 .64213 .56647 Mtetra
.717 .578 .698 r
.64213 .56647 .64556 .5712 .64831 .56441 .64489 .55969 Mtetra
.721 .579 .696 r
.64489 .55969 .64831 .56441 .65106 .55722 .64764 .5525 Mtetra
.721 .579 .695 r
.64764 .5525 .65106 .55722 .6538 .55 .65038 .54528 Mtetra
.718 .579 .698 r
.65038 .54528 .6538 .55 .65655 .54312 .65313 .5384 Mtetra
.711 .577 .703 r
.65313 .5384 .65655 .54312 .65932 .53693 .6559 .53222 Mtetra
.7 .575 .711 r
.6559 .53222 .65932 .53693 .66212 .53176 .6587 .52704 Mtetra
.681 .57 .724 r
.6587 .52704 .66212 .53176 .66496 .52782 .66154 .5231 Mtetra
.65 .562 .742 r
.66154 .5231 .66496 .52782 .66784 .52525 .66441 .52053 Mtetra
.602 .547 .765 r
.66441 .52053 .66784 .52525 .67076 .52408 .66733 .51936 Mtetra
.525 .52 .792 r
.66733 .51936 .67076 .52408 .67373 .52419 .6703 .51947 Mtetra
.415 .475 .814 r
.6703 .51947 .67373 .52419 .67673 .52534 .6733 .5206 Mtetra
.303 .424 .819 r
.6733 .5206 .67673 .52534 .67977 .52715 .67633 .52241 Mtetra
.259 .403 .817 r
.67633 .52241 .67977 .52715 .68282 .52917 .67937 .52442 Mtetra
.323 .433 .819 r
.67937 .52442 .68282 .52917 .68586 .53089 .68241 .52614 Mtetra
.444 .487 .81 r
.68241 .52614 .68586 .53089 .68889 .53183 .68544 .52707 Mtetra
.551 .529 .784 r
.68544 .52707 .68889 .53183 .69189 .53158 .68843 .52681 Mtetra
.621 .553 .757 r
.68843 .52681 .69189 .53158 .69484 .5299 .69138 .52514 Mtetra
.662 .565 .735 r
.69138 .52514 .69484 .5299 .69775 .52682 .69429 .52205 Mtetra
.685 .571 .721 r
.69429 .52205 .69775 .52682 .70061 .52259 .69715 .51782 Mtetra
.694 .573 .715 r
.69715 .51782 .70061 .52259 .70346 .51778 .7 .51301 Mtetra
.691 .573 .717 r
.7 .51301 .70346 .51778 .70632 .51313 .70286 .50836 Mtetra
.675 .569 .727 r
.70286 .50836 .70632 .51313 .70921 .50941 .70575 .50464 Mtetra
.64 .559 .747 r
.70575 .50464 .70921 .50941 .71216 .50715 .7087 .50237 Mtetra
.586 .542 .772 r
.7087 .50237 .71216 .50715 .71517 .50629 .7117 .50151 Mtetra
.56 .533 .781 r
.7117 .50151 .71517 .50629 .7182 .50589 .71473 .50111 Mtetra
.618 .552 .758 r
.71473 .50111 .7182 .50589 .72118 .50429 .71771 .4995 Mtetra
.656 .563 .739 r
.71771 .4995 .72118 .50429 .72413 .50145 .72065 .49666 Mtetra
.618 .552 .758 r
.72065 .49666 .72413 .50145 .72712 .49984 .72364 .49505 Mtetra
.56 .533 .781 r
.72364 .49505 .72712 .49984 .73017 .49944 .72669 .49464 Mtetra
.586 .542 .772 r
.72669 .49464 .73017 .49944 .73321 .49857 .72972 .49377 Mtetra
.64 .559 .747 r
.72972 .49377 .73321 .49857 .73619 .49629 .7327 .49148 Mtetra
.675 .569 .727 r
.7327 .49148 .73619 .49629 .73911 .49253 .73562 .48773 Mtetra
.691 .573 .717 r
.73562 .48773 .73911 .49253 .742 .48784 .73851 .48304 Mtetra
.694 .573 .715 r
.73851 .48304 .742 .48784 .74488 .48299 .74139 .47818 Mtetra
.685 .571 .721 r
.74139 .47818 .74488 .48299 .74778 .47872 .74429 .47391 Mtetra
.662 .565 .735 r
.74429 .47391 .74778 .47872 .75074 .47558 .74725 .47077 Mtetra
.622 .553 .756 r
.74725 .47077 .75074 .47558 .75377 .47385 .75027 .46903 Mtetra
.554 .53 .783 r
.75027 .46903 .75377 .47385 .75686 .47354 .75336 .46872 Mtetra
.454 .492 .808 r
.75336 .46872 .75686 .47354 .76002 .47442 .75651 .4696 Mtetra
.346 .444 .819 r
.75651 .4696 .76002 .47442 .76321 .4761 .75971 .47127 Mtetra
.29 .418 .819 r
.75971 .47127 .76321 .4761 .76644 .47809 .76292 .47325 Mtetra
.328 .436 .819 r
.76292 .47325 .76644 .47809 .76966 .47988 .76614 .47503 Mtetra
.428 .481 .812 r
.76614 .47503 .76966 .47988 .77285 .481 .76933 .47614 Mtetra
.528 .521 .791 r
.76933 .47614 .77285 .481 .77601 .48106 .77248 .47621 Mtetra
.602 .547 .765 r
.77248 .47621 .77601 .48106 .7791 .47983 .77557 .47497 Mtetra
.65 .561 .742 r
.77557 .47497 .7791 .47983 .78213 .47716 .7786 .4723 Mtetra
.68 .57 .724 r
.7786 .4723 .78213 .47716 .78509 .47308 .78156 .46822 Mtetra
.699 .574 .711 r
.78156 .46822 .78509 .47308 .78799 .46773 .78446 .46287 Mtetra
.711 .577 .702 r
.78446 .46287 .78799 .46773 .79084 .46136 .78731 .45649 Mtetra
.718 .579 .697 r
.78731 .45649 .79084 .46136 .79365 .45428 .79011 .44942 Mtetra
.721 .579 .695 r
.79011 .44942 .79365 .45428 .79643 .44687 .7929 .44201 Mtetra
.7929 .44201 .79643 .44687 .79922 .43949 .7957 .43463 Mtetra
.717 .578 .698 r
.7957 .43463 .79922 .43949 .80203 .43253 .79851 .42767 Mtetra
.71 .577 .704 r
.79851 .42767 .80203 .43253 .80488 .4263 .80136 .42144 Mtetra
.698 .574 .712 r
.80136 .42144 .80488 .4263 .80779 .42109 .80426 .41623 Mtetra
.678 .569 .725 r
.80426 .41623 .80779 .42109 .81076 .41709 .80723 .41223 Mtetra
.649 .561 .743 r
.80723 .41223 .81076 .41709 .81381 .41444 .81028 .40958 Mtetra
.601 .547 .766 r
.81028 .40958 .81381 .41444 .81695 .4132 .81341 .40833 Mtetra
.524 .519 .793 r
.81341 .40833 .81695 .4132 .82016 .41333 .81662 .40846 Mtetra
.394 .466 .816 r
.81662 .40846 .82016 .41333 .82346 .41475 .81992 .40987 Mtetra
.189 .367 .81 r
.81992 .40987 .82346 .41475 .82683 .41728 .82329 .41239 Mtetra
0 .22 .742 r
.82329 .41239 .82683 .41728 .83027 .42071 .82672 .41582 Mtetra
0 .071 .627 r
.82672 .41582 .83027 .42071 .83375 .4248 .83019 .41989 Mtetra
0 0 .541 r
.83019 .41989 .83375 .4248 .83727 .42924 .8337 .42433 Mtetra
0 0 .529 r
.8337 .42433 .83727 .42924 .8408 .43374 .83723 .42882 Mtetra
0 .037 .595 r
.83723 .42882 .8408 .43374 .84433 .438 .84075 .43307 Mtetra
0 .169 .707 r
.84075 .43307 .84433 .438 .84784 .44173 .84426 .43679 Mtetra
.101 .32 .795 r
.84426 .43679 .84784 .44173 .85131 .44467 .84772 .43972 Mtetra
.325 .435 .819 r
.84772 .43972 .85131 .44467 .85473 .44658 .85113 .44163 Mtetra
.477 .501 .804 r
.85113 .44163 .85473 .44658 .85808 .44729 .85448 .44233 Mtetra
.571 .536 .778 r
.85448 .44233 .85808 .44729 .86135 .44666 .85775 .4417 Mtetra
.629 .555 .753 r
.85775 .4417 .86135 .44666 .86454 .44461 .86093 .43965 Mtetra
.666 .566 .732 r
.86093 .43965 .86454 .44461 .86763 .44113 .86402 .43616 Mtetra
.691 .572 .717 r
.86402 .43616 .86763 .44113 .87064 .43624 .86703 .43127 Mtetra
.708 .576 .705 r
.86703 .43127 .87064 .43624 .87356 .43004 .86995 .42507 Mtetra
.72 .579 .696 r
.86995 .42507 .87356 .43004 .8764 .42265 .87279 .41768 Mtetra
.728 .581 .689 r
.87279 .41768 .8764 .42265 .87917 .41426 .87557 .40929 Mtetra
.734 .582 .685 r
.87557 .40929 .87917 .41426 .88189 .40507 .87828 .4001 Mtetra
.738 .582 .681 r
.87828 .4001 .88189 .40507 .88456 .39531 .88096 .39035 Mtetra
.74 .583 .68 r
.88096 .39035 .88456 .39531 .8872 .38524 .8836 .38028 Mtetra
.74 .583 .679 r
.8836 .38028 .8872 .38524 .88984 .37509 .88624 .37014 Mtetra
.739 .583 .68 r
.88624 .37014 .88984 .37509 .89248 .36513 .88889 .36018 Mtetra
.737 .582 .682 r
.88889 .36018 .89248 .36513 .89515 .3556 .89156 .35065 Mtetra
.733 .581 .686 r
.89156 .35065 .89515 .3556 .89786 .34671 .89427 .34176 Mtetra
.726 .58 .691 r
.89427 .34176 .89786 .34671 .90063 .33867 .89704 .33373 Mtetra
.717 .578 .698 r
.89704 .33373 .90063 .33867 .90347 .33165 .89988 .32671 Mtetra
.705 .576 .708 r
.89988 .32671 .90347 .33165 .9064 .32579 .90281 .32085 Mtetra
.687 .571 .72 r
.90281 .32085 .9064 .32579 .90942 .32121 .90583 .31627 Mtetra
.661 .565 .736 r
.90583 .31627 .90942 .32121 .91254 .31797 .90895 .31303 Mtetra
.622 .553 .756 r
.90895 .31303 .91254 .31797 .91577 .31612 .91217 .31118 Mtetra
.561 .533 .781 r
.91217 .31118 .91577 .31612 .91911 .31566 .91551 .31071 Mtetra
.462 .495 .807 r
.91551 .31071 .91911 .31566 .92256 .31655 .91896 .3116 Mtetra
.293 .419 .819 r
.91896 .3116 .92256 .31655 .92612 .31873 .92251 .31377 Mtetra
.021 .275 .774 r
.92251 .31377 .92612 .31873 .92978 .32211 .92617 .31713 Mtetra
0 .062 .618 r
.92617 .31713 .92978 .32211 .93354 .32654 .92991 .32156 Mtetra
.59 .143 0 r
.92991 .32156 .93354 .32654 .93738 .33189 .93375 .3269 Mtetra
.739 .276 0 r
.93375 .3269 .93738 .33189 .94129 .33798 .93765 .33297 Mtetra
.807 .348 0 r
.93765 .33297 .94129 .33798 .94526 .34461 .94162 .3396 Mtetra
.836 .382 0 r
.94162 .3396 .94526 .34461 .94928 .35159 .94563 .34656 Mtetra
.843 .391 0 r
.94563 .34656 .94928 .35159 .95332 .3587 .94966 .35366 Mtetra
.834 .38 0 r
.94966 .35366 .95332 .3587 .95738 .36572 .9537 .36067 Mtetra
.868 .532 .414 r
.50462 .61862 .50792 .62186 .51064 .62876 .50734 .62551 Mtetra
.867 .534 .419 r
.50734 .62551 .51064 .62876 .51337 .63579 .51006 .63254 Mtetra
.867 .533 .415 r
.51006 .63254 .51337 .63579 .51611 .64276 .5128 .63951 Mtetra
.87 .527 .4 r
.5128 .63951 .51611 .64276 .51887 .64947 .51554 .6462 Mtetra
.873 .516 .37 r
.51554 .6462 .51887 .64947 .52163 .65569 .5183 .65242 Mtetra
.875 .493 .313 r
.5183 .65242 .52163 .65569 .5244 .66124 .52106 .65797 Mtetra
.868 .442 .199 r
.52106 .65797 .5244 .66124 .52717 .66594 .52383 .66266 Mtetra
.795 .301 0 r
.52383 .66266 .52717 .66594 .52995 .66961 .52661 .66633 Mtetra
0 .099 .609 r
.52661 .66633 .52995 .66961 .53273 .67213 .52938 .66884 Mtetra
.264 .478 .879 r
.52938 .66884 .53273 .67213 .53551 .67337 .53216 .67008 Mtetra
.534 .574 .842 r
.53216 .67008 .53551 .67337 .53829 .67327 .53493 .66998 Mtetra
.635 .595 .791 r
.53493 .66998 .53829 .67327 .54106 .67178 .5377 .66849 Mtetra
.683 .6 .757 r
.5377 .66849 .54106 .67178 .54382 .66891 .54046 .66561 Mtetra
.709 .601 .734 r
.54046 .66561 .54382 .66891 .54657 .66468 .54321 .66138 Mtetra
.725 .601 .718 r
.54321 .66138 .54657 .66468 .54931 .65918 .54596 .65588 Mtetra
.736 .601 .706 r
.54596 .65588 .54931 .65918 .55205 .65253 .54869 .64923 Mtetra
.743 .6 .698 r
.54869 .64923 .55205 .65253 .55477 .64487 .55141 .64157 Mtetra
.748 .6 .693 r
.55141 .64157 .55477 .64487 .55748 .63638 .55413 .63308 Mtetra
.751 .6 .689 r
.55413 .63308 .55748 .63638 .56018 .62728 .55683 .62398 Mtetra
.752 .599 .687 r
.55683 .62398 .56018 .62728 .56287 .61779 .55952 .61449 Mtetra
.753 .599 .686 r
.55952 .61449 .56287 .61779 .56556 .60815 .56221 .60484 Mtetra
.56221 .60484 .56556 .60815 .56824 .5986 .5649 .59529 Mtetra
.751 .599 .688 r
.5649 .59529 .56824 .5986 .57093 .58938 .56759 .58608 Mtetra
.749 .6 .691 r
.56759 .58608 .57093 .58938 .57362 .58073 .57028 .57743 Mtetra
.744 .6 .697 r
.57028 .57743 .57362 .58073 .57631 .57286 .57298 .56956 Mtetra
.738 .6 .704 r
.57298 .56956 .57631 .57286 .57902 .56596 .57569 .56266 Mtetra
.728 .601 .714 r
.57569 .56266 .57902 .56596 .58175 .56019 .57842 .55688 Mtetra
.714 .601 .729 r
.57842 .55688 .58175 .56019 .58449 .55566 .58116 .55236 Mtetra
.69 .6 .75 r
.58116 .55236 .58449 .55566 .58726 .55247 .58392 .54916 Mtetra
.649 .596 .781 r
.58392 .54916 .58726 .55247 .59005 .55063 .58671 .54732 Mtetra
.572 .582 .825 r
.58671 .54732 .59005 .55063 .59286 .55013 .58953 .54682 Mtetra
.399 .531 .873 r
.58953 .54682 .59286 .55013 .59571 .55091 .59237 .54759 Mtetra
.003 .346 .824 r
.59237 .54759 .59571 .55091 .59858 .55284 .59523 .54952 Mtetra
.521 .016 0 r
.59523 .54952 .59858 .55284 .60147 .55576 .59812 .55244 Mtetra
.764 .261 0 r
.59812 .55244 .60147 .55576 .60439 .55947 .60104 .55614 Mtetra
.832 .359 .033 r
.60104 .55614 .60439 .55947 .60733 .56371 .60397 .56037 Mtetra
.849 .392 .094 r
.60397 .56037 .60733 .56371 .61028 .56822 .60692 .56488 Mtetra
.847 .387 .085 r
.60692 .56488 .61028 .56822 .61324 .5727 .60987 .56935 Mtetra
.82 .339 0 r
.60987 .56935 .61324 .5727 .61621 .57685 .61283 .57351 Mtetra
.717 .205 0 r
.61283 .57351 .61621 .57685 .61917 .5804 .61579 .57705 Mtetra
0 .106 .618 r
.61579 .57705 .61917 .5804 .62212 .58307 .61874 .57972 Mtetra
.178 .437 .868 r
.61874 .57972 .62212 .58307 .62506 .58465 .62167 .58129 Mtetra
.483 .559 .857 r
.62167 .58129 .62506 .58465 .62797 .58495 .62458 .58159 Mtetra
.61 .59 .806 r
.62458 .58159 .62797 .58495 .63086 .58388 .62747 .58052 Mtetra
.67 .599 .767 r
.62747 .58052 .63086 .58388 .63372 .58141 .63033 .57804 Mtetra
.701 .601 .741 r
.63033 .57804 .63372 .58141 .63655 .57758 .63316 .57421 Mtetra
.719 .601 .724 r
.63316 .57421 .63655 .57758 .63935 .57253 .63596 .56916 Mtetra
.73 .601 .713 r
.63596 .56916 .63935 .57253 .64213 .56647 .63874 .5631 Mtetra
.737 .601 .706 r
.63874 .5631 .64213 .56647 .64489 .55969 .6415 .55631 Mtetra
.74 .601 .703 r
.6415 .55631 .64489 .55969 .64764 .5525 .64425 .54912 Mtetra
.74 .601 .702 r
.64425 .54912 .64764 .5525 .65038 .54528 .64699 .5419 Mtetra
.738 .601 .705 r
.64699 .5419 .65038 .54528 .65313 .5384 .64975 .53502 Mtetra
.732 .601 .711 r
.64975 .53502 .65313 .5384 .6559 .53222 .65252 .52884 Mtetra
.721 .601 .722 r
.65252 .52884 .6559 .53222 .6587 .52704 .65532 .52366 Mtetra
.703 .601 .74 r
.65532 .52366 .6587 .52704 .66154 .5231 .65815 .51972 Mtetra
.672 .599 .765 r
.65815 .51972 .66154 .5231 .66441 .52053 .66102 .51715 Mtetra
.615 .591 .803 r
.66102 .51715 .66441 .52053 .66733 .51936 .66394 .51597 Mtetra
.51 .566 .848 r
.66394 .51597 .66733 .51936 .6703 .51947 .66691 .51607 Mtetra
.328 .502 .878 r
.66691 .51607 .6703 .51947 .6733 .5206 .6699 .51721 Mtetra
.112 .403 .855 r
.6699 .51721 .6733 .5206 .67633 .52241 .67293 .51901 Mtetra
.025 .357 .831 r
.67293 .51901 .67633 .52241 .67937 .52442 .67597 .52102 Mtetra
.15 .422 .863 r
.67597 .52102 .67937 .52442 .68241 .52614 .67901 .52273 Mtetra
.378 .522 .875 r
.67901 .52273 .68241 .52614 .68544 .52707 .68203 .52366 Mtetra
.548 .576 .835 r
.68203 .52366 .68544 .52707 .68843 .52681 .68502 .5234 Mtetra
.639 .595 .789 r
.68502 .5234 .68843 .52681 .69138 .52514 .68797 .52172 Mtetra
.684 .6 .756 r
.68797 .52172 .69138 .52514 .69429 .52205 .69087 .51863 Mtetra
.707 .601 .736 r
.69087 .51863 .69429 .52205 .69715 .51782 .69374 .5144 Mtetra
.716 .602 .728 r
.69374 .5144 .69715 .51782 .7 .51301 .69659 .50959 Mtetra
.713 .602 .73 r
.69659 .50959 .7 .51301 .70286 .50836 .69944 .50494 Mtetra
.698 .601 .744 r
.69944 .50494 .70286 .50836 .70575 .50464 .70233 .50121 Mtetra
.661 .598 .774 r
.70233 .50121 .70575 .50464 .7087 .50237 .70528 .49895 Mtetra
.595 .587 .813 r
.70528 .49895 .7087 .50237 .7117 .50151 .70828 .49808 Mtetra
.561 .579 .829 r
.70828 .49808 .7117 .50151 .71473 .50111 .7113 .49767 Mtetra
.635 .594 .791 r
.7113 .49767 .71473 .50111 .71771 .4995 .71429 .49606 Mtetra
.678 .6 .761 r
.71429 .49606 .71771 .4995 .72065 .49666 .71723 .49322 Mtetra
.635 .594 .791 r
.71723 .49322 .72065 .49666 .72364 .49505 .72022 .49161 Mtetra
.561 .579 .829 r
.72022 .49161 .72364 .49505 .72669 .49464 .72326 .4912 Mtetra
.595 .587 .813 r
.72326 .4912 .72669 .49464 .72972 .49377 .72629 .49032 Mtetra
.661 .598 .774 r
.72629 .49032 .72972 .49377 .7327 .49148 .72927 .48803 Mtetra
.698 .601 .744 r
.72927 .48803 .7327 .49148 .73562 .48773 .73219 .48427 Mtetra
.713 .602 .73 r
.73219 .48427 .73562 .48773 .73851 .48304 .73508 .47958 Mtetra
.716 .602 .728 r
.73508 .47958 .73851 .48304 .74139 .47818 .73796 .47472 Mtetra
.707 .602 .736 r
.73796 .47472 .74139 .47818 .74429 .47391 .74086 .47045 Mtetra
.684 .6 .756 r
.74086 .47045 .74429 .47391 .74725 .47077 .74382 .4673 Mtetra
.64 .595 .788 r
.74382 .4673 .74725 .47077 .75027 .46903 .74684 .46557 Mtetra
.553 .577 .833 r
.74684 .46557 .75027 .46903 .75336 .46872 .74992 .46525 Mtetra
.398 .528 .872 r
.74992 .46525 .75336 .46872 .75651 .4696 .75307 .46612 Mtetra
.199 .444 .87 r
.75307 .46612 .75651 .4696 .75971 .47127 .75626 .46779 Mtetra
.091 .391 .849 r
.75626 .46779 .75971 .47127 .76292 .47325 .75947 .46977 Mtetra
.166 .429 .865 r
.75947 .46977 .76292 .47325 .76614 .47503 .76269 .47155 Mtetra
.352 .511 .876 r
.76269 .47155 .76614 .47503 .76933 .47614 .76588 .47266 Mtetra
.516 .567 .846 r
.76588 .47266 .76933 .47614 .77248 .47621 .76902 .47272 Mtetra
.615 .591 .803 r
.76902 .47272 .77248 .47621 .77557 .47497 .77211 .47147 Mtetra
.671 .599 .766 r
.77211 .47147 .77557 .47497 .7786 .4723 .77514 .4688 Mtetra
.703 .602 .74 r
.77514 .4688 .7786 .4723 .78156 .46822 .7781 .46472 Mtetra
.721 .602 .723 r
.7781 .46472 .78156 .46822 .78446 .46287 .781 .45937 Mtetra
.733 .602 .712 r
.781 .45937 .78446 .46287 .78731 .45649 .78384 .45299 Mtetra
.739 .602 .705 r
.78384 .45299 .78731 .45649 .79011 .44942 .78665 .44592 Mtetra
.741 .602 .702 r
.78665 .44592 .79011 .44942 .7929 .44201 .78945 .4385 Mtetra
.78945 .4385 .7929 .44201 .7957 .43463 .79224 .43113 Mtetra
.738 .602 .706 r
.79224 .43113 .7957 .43463 .79851 .42767 .79505 .42416 Mtetra
.731 .602 .713 r
.79505 .42416 .79851 .42767 .80136 .42144 .7979 .41794 Mtetra
.72 .602 .725 r
.7979 .41794 .80136 .42144 .80426 .41623 .8008 .41272 Mtetra
.701 .601 .742 r
.8008 .41272 .80426 .41623 .80723 .41223 .80378 .40872 Mtetra
.67 .599 .767 r
.80378 .40872 .80723 .41223 .81028 .40958 .80682 .40607 Mtetra
.615 .59 .803 r
.80682 .40607 .81028 .40958 .81341 .40833 .80995 .40482 Mtetra
.509 .564 .847 r
.80995 .40482 .81341 .40833 .81662 .40846 .81316 .40494 Mtetra
.293 .486 .876 r
.81316 .40494 .81662 .40846 .81992 .40987 .81645 .40634 Mtetra
0 .286 .784 r
.81645 .40634 .81992 .40987 .82329 .41239 .81982 .40886 Mtetra
0 .013 .519 r
.81982 .40886 .82329 .41239 .82672 .41582 .82324 .41229 Mtetra
.678 .167 0 r
.82324 .41229 .82672 .41582 .83019 .41989 .82671 .41635 Mtetra
.747 .242 0 r
.82671 .41635 .83019 .41989 .8337 .42433 .83022 .42078 Mtetra
.754 .251 0 r
.83022 .42078 .8337 .42433 .83723 .42882 .83374 .42527 Mtetra
.708 .198 0 r
.83374 .42527 .83723 .42882 .84075 .43307 .83726 .42952 Mtetra
.564 .058 0 r
.83726 .42952 .84075 .43307 .84426 .43679 .84076 .43323 Mtetra
0 .189 .703 r
.84076 .43323 .84426 .43679 .84772 .43972 .84422 .43616 Mtetra
.164 .426 .863 r
.84422 .43616 .84772 .43972 .85113 .44163 .84762 .43806 Mtetra
.436 .542 .865 r
.84762 .43806 .85113 .44163 .85448 .44233 .85096 .43876 Mtetra
.576 .582 .823 r
.85096 .43876 .85448 .44233 .85775 .4417 .85423 .43812 Mtetra
.648 .596 .783 r
.85423 .43812 .85775 .4417 .86093 .43965 .85741 .43607 Mtetra
.689 .601 .753 r
.85741 .43607 .86093 .43965 .86402 .43616 .8605 .43258 Mtetra
.714 .603 .731 r
.8605 .43258 .86402 .43616 .86703 .43127 .86351 .42769 Mtetra
.73 .603 .715 r
.86351 .42769 .86703 .43127 .86995 .42507 .86643 .42148 Mtetra
.741 .603 .703 r
.86643 .42148 .86995 .42507 .87279 .41768 .86928 .41409 Mtetra
.748 .602 .695 r
.86928 .41409 .87279 .41768 .87557 .40929 .87205 .4057 Mtetra
.753 .602 .69 r
.87205 .4057 .87557 .40929 .87828 .4001 .87477 .39652 Mtetra
.756 .602 .686 r
.87477 .39652 .87828 .4001 .88096 .39035 .87745 .38676 Mtetra
.758 .602 .684 r
.87745 .38676 .88096 .39035 .8836 .38028 .8801 .37669 Mtetra
.758 .602 .683 r
.8801 .37669 .8836 .38028 .88624 .37014 .88274 .36655 Mtetra
.758 .602 .684 r
.88274 .36655 .88624 .37014 .88889 .36018 .88539 .3566 Mtetra
.755 .602 .687 r
.88539 .3566 .88889 .36018 .89156 .35065 .88806 .34706 Mtetra
.752 .602 .691 r
.88806 .34706 .89156 .35065 .89427 .34176 .89077 .33818 Mtetra
.746 .602 .697 r
.89077 .33818 .89427 .34176 .89704 .33373 .89355 .33014 Mtetra
.738 .603 .706 r
.89355 .33014 .89704 .33373 .89988 .32671 .89639 .32312 Mtetra
.727 .603 .718 r
.89639 .32312 .89988 .32671 .90281 .32085 .89932 .31726 Mtetra
.709 .602 .735 r
.89932 .31726 .90281 .32085 .90583 .31627 .90233 .31268 Mtetra
.683 .6 .757 r
.90233 .31268 .90583 .31627 .90895 .31303 .90545 .30944 Mtetra
.639 .594 .787 r
.90545 .30944 .90895 .31303 .91217 .31118 .90868 .30758 Mtetra
.563 .578 .827 r
.90868 .30758 .91217 .31118 .91551 .31071 .91201 .30711 Mtetra
.413 .531 .868 r
.91201 .30711 .91551 .31071 .91896 .3116 .91546 .30799 Mtetra
.11 .396 .851 r
.91546 .30799 .91896 .3116 .92251 .31377 .919 .31016 Mtetra
0 .113 .632 r
.919 .31016 .92251 .31377 .92617 .31713 .92266 .31352 Mtetra
.676 .167 0 r
.92266 .31352 .92617 .31713 .92991 .32156 .9264 .31794 Mtetra
.806 .32 0 r
.9264 .31794 .92991 .32156 .93375 .3269 .93023 .32327 Mtetra
.851 .393 .081 r
.93023 .32327 .93375 .3269 .93765 .33297 .93413 .32934 Mtetra
.867 .429 .151 r
.93413 .32934 .93765 .33297 .94162 .3396 .93808 .33596 Mtetra
.873 .446 .186 r
.93808 .33596 .94162 .3396 .94563 .34656 .94208 .34292 Mtetra
.875 .451 .196 r
.94208 .34292 .94563 .34656 .94966 .35366 .94611 .35001 Mtetra
.873 .445 .184 r
.94611 .35001 .94966 .35366 .9537 .36067 .95015 .35701 Mtetra
.826 .516 .465 r
.50133 .61673 .50462 .61862 .50734 .62551 .50403 .62361 Mtetra
.826 .518 .469 r
.50403 .62361 .50734 .62551 .51006 .63254 .50675 .63064 Mtetra
.826 .517 .466 r
.50675 .63064 .51006 .63254 .5128 .63951 .50948 .63761 Mtetra
.827 .512 .457 r
.50948 .63761 .5128 .63951 .51554 .6462 .51222 .6443 Mtetra
.828 .503 .439 r
.51222 .6443 .51554 .6462 .5183 .65242 .51497 .65052 Mtetra
.829 .487 .408 r
.51497 .65052 .5183 .65242 .52106 .65797 .51773 .65607 Mtetra
.827 .455 .351 r
.51773 .65607 .52106 .65797 .52383 .66266 .5205 .66076 Mtetra
.813 .387 .231 r
.5205 .66076 .52383 .66266 .52661 .66633 .52327 .66443 Mtetra
.718 .187 0 r
.52327 .66443 .52661 .66633 .52938 .66884 .52604 .66693 Mtetra
0 .392 .802 r
.52604 .66693 .52938 .66884 .53216 .67008 .52881 .66817 Mtetra
.501 .662 .933 r
.52881 .66817 .53216 .67008 .53493 .66998 .53158 .66807 Mtetra
.661 .666 .844 r
.53158 .66807 .53493 .66998 .5377 .66849 .53435 .66657 Mtetra
.714 .652 .786 r
.53435 .66657 .5377 .66849 .54046 .66561 .53711 .66369 Mtetra
.739 .642 .752 r
.53711 .66369 .54046 .66561 .54321 .66138 .53987 .65946 Mtetra
.752 .634 .73 r
.53987 .65946 .54321 .66138 .54596 .65588 .54261 .65396 Mtetra
.76 .629 .715 r
.54261 .65396 .54596 .65588 .54869 .64923 .54534 .6473 Mtetra
.765 .625 .705 r
.54534 .6473 .54869 .64923 .55141 .64157 .54807 .63964 Mtetra
.768 .623 .699 r
.54807 .63964 .55141 .64157 .55413 .63308 .55078 .63115 Mtetra
.771 .621 .694 r
.55078 .63115 .55413 .63308 .55683 .62398 .55349 .62205 Mtetra
.772 .62 .691 r
.55349 .62205 .55683 .62398 .55952 .61449 .55619 .61256 Mtetra
.772 .62 .69 r
.55619 .61256 .55952 .61449 .56221 .60484 .55888 .60291 Mtetra
.772 .62 .691 r
.55888 .60291 .56221 .60484 .5649 .59529 .56158 .59335 Mtetra
.771 .621 .693 r
.56158 .59335 .5649 .59529 .56759 .58608 .56427 .58413 Mtetra
.769 .622 .697 r
.56427 .58413 .56759 .58608 .57028 .57743 .56696 .57548 Mtetra
.766 .624 .703 r
.56696 .57548 .57028 .57743 .57298 .56956 .56966 .56761 Mtetra
.761 .628 .712 r
.56966 .56761 .57298 .56956 .57569 .56266 .57237 .56071 Mtetra
.754 .632 .726 r
.57237 .56071 .57569 .56266 .57842 .55688 .5751 .55493 Mtetra
.742 .639 .746 r
.5751 .55493 .57842 .55688 .58116 .55236 .57784 .5504 Mtetra
.721 .648 .776 r
.57784 .5504 .58116 .55236 .58392 .54916 .58061 .5472 Mtetra
.678 .66 .826 r
.58061 .5472 .58392 .54916 .58671 .54732 .5834 .54536 Mtetra
.569 .665 .903 r
.5834 .54536 .58671 .54732 .58953 .54682 .58621 .54486 Mtetra
.212 .566 .938 r
.58621 .54486 .58953 .54682 .59237 .54759 .58905 .54563 Mtetra
.489 0 0 r
.58905 .54563 .59237 .54759 .59523 .54952 .59191 .54755 Mtetra
.758 .252 .003 r
.59191 .54755 .59523 .54952 .59812 .55244 .5948 .55047 Mtetra
.811 .368 .191 r
.5948 .55047 .59812 .55244 .60104 .55614 .59771 .55417 Mtetra
.824 .414 .268 r
.59771 .55417 .60104 .55614 .60397 .56037 .60063 .55841 Mtetra
.827 .43 .297 r
.60063 .55841 .60397 .56037 .60692 .56488 .60358 .56291 Mtetra
.827 .427 .292 r
.60358 .56291 .60692 .56488 .60987 .56935 .60653 .56738 Mtetra
.822 .404 .252 r
.60653 .56738 .60987 .56935 .61283 .57351 .60949 .57153 Mtetra
.802 .344 .149 r
.60949 .57153 .61283 .57351 .61579 .57705 .61244 .57507 Mtetra
.711 .177 0 r
.61244 .57507 .61579 .57705 .61874 .57972 .61538 .57774 Mtetra
0 .283 .697 r
.61538 .57774 .61874 .57972 .62167 .58129 .61831 .57931 Mtetra
.401 .636 .95 r
.61831 .57931 .62167 .58129 .62458 .58159 .62122 .57961 Mtetra
.628 .667 .869 r
.62122 .57961 .62458 .58159 .62747 .58052 .62411 .57853 Mtetra
.701 .657 .803 r
.62411 .57853 .62747 .58052 .63033 .57804 .62697 .57605 Mtetra
.732 .646 .763 r
.62697 .57605 .63033 .57804 .63316 .57421 .6298 .57222 Mtetra
.748 .638 .739 r
.6298 .57222 .63316 .57421 .63596 .56916 .6326 .56717 Mtetra
.757 .633 .724 r
.6326 .56717 .63596 .56916 .63874 .5631 .63538 .56111 Mtetra
.761 .63 .715 r
.63538 .56111 .63874 .5631 .6415 .55631 .63814 .55432 Mtetra
.764 .629 .711 r
.63814 .55432 .6415 .55631 .64425 .54912 .64089 .54713 Mtetra
.764 .628 .71 r
.64089 .54713 .64425 .54912 .64699 .5419 .64364 .5399 Mtetra
.762 .63 .714 r
.64364 .5399 .64699 .5419 .64975 .53502 .6464 .53302 Mtetra
.757 .633 .722 r
.6464 .53302 .64975 .53502 .65252 .52884 .64917 .52683 Mtetra
.749 .637 .737 r
.64917 .52683 .65252 .52884 .65532 .52366 .65197 .52165 Mtetra
.733 .645 .761 r
.65197 .52165 .65532 .52366 .65815 .51972 .6548 .51771 Mtetra
.703 .655 .8 r
.6548 .51771 .65815 .51972 .66102 .51715 .65768 .51514 Mtetra
.634 .665 .863 r
.65768 .51514 .66102 .51715 .66394 .51597 .66059 .51396 Mtetra
.459 .647 .94 r
.66059 .51396 .66394 .51597 .66691 .51607 .66355 .51406 Mtetra
.051 .484 .887 r
.66355 .51406 .66691 .51607 .6699 .51721 .66655 .51519 Mtetra
0 .207 .617 r
.66655 .51519 .6699 .51721 .67293 .51901 .66957 .51699 Mtetra
.46 0 0 r
.66957 .51699 .67293 .51901 .67597 .52102 .67261 .519 Mtetra
0 .253 .669 r
.67261 .519 .67597 .52102 .67901 .52273 .67564 .52071 Mtetra
.167 .543 .927 r
.67564 .52071 .67901 .52273 .68203 .52366 .67866 .52163 Mtetra
.529 .661 .92 r
.67866 .52163 .68203 .52366 .68502 .5234 .68165 .52137 Mtetra
.665 .663 .838 r
.68165 .52137 .68502 .5234 .68797 .52172 .6846 .51969 Mtetra
.716 .652 .785 r
.6846 .51969 .68797 .52172 .69087 .51863 .6875 .5166 Mtetra
.737 .644 .756 r
.6875 .5166 .69087 .51863 .69374 .5144 .69037 .51237 Mtetra
.745 .641 .745 r
.69037 .51237 .69374 .5144 .69659 .50959 .69322 .50755 Mtetra
.743 .641 .748 r
.69322 .50755 .69659 .50959 .69944 .50494 .69608 .5029 Mtetra
.729 .647 .768 r
.69608 .5029 .69944 .50494 .70233 .50121 .69897 .49917 Mtetra
.691 .658 .813 r
.69897 .49917 .70233 .50121 .70528 .49895 .70191 .4969 Mtetra
.606 .666 .882 r
.70191 .4969 .70528 .49895 .70828 .49808 .70491 .49603 Mtetra
.551 .662 .91 r
.70491 .49603 .70828 .49808 .7113 .49767 .70793 .49563 Mtetra
.66 .663 .842 r
.70793 .49563 .7113 .49767 .71429 .49606 .71091 .49401 Mtetra
.709 .654 .793 r
.71091 .49401 .71429 .49606 .71723 .49322 .71385 .49117 Mtetra
.66 .663 .842 r
.71385 .49117 .71723 .49322 .72022 .49161 .71684 .48955 Mtetra
.552 .662 .91 r
.71684 .48955 .72022 .49161 .72326 .4912 .71989 .48914 Mtetra
.606 .666 .882 r
.71989 .48914 .72326 .4912 .72629 .49032 .72291 .48826 Mtetra
.691 .659 .813 r
.72291 .48826 .72629 .49032 .72927 .48803 .72589 .48597 Mtetra
.729 .648 .768 r
.72589 .48597 .72927 .48803 .73219 .48427 .72881 .48221 Mtetra
.743 .642 .748 r
.72881 .48221 .73219 .48427 .73508 .47958 .7317 .47751 Mtetra
.745 .641 .745 r
.7317 .47751 .73508 .47958 .73796 .47472 .73458 .47265 Mtetra
.737 .644 .756 r
.73458 .47265 .73796 .47472 .74086 .47045 .73748 .46838 Mtetra
.716 .652 .785 r
.73748 .46838 .74086 .47045 .74382 .4673 .74044 .46523 Mtetra
.666 .662 .837 r
.74044 .46523 .74382 .4673 .74684 .46557 .74346 .46349 Mtetra
.538 .66 .915 r
.74346 .46349 .74684 .46557 .74992 .46525 .74654 .46317 Mtetra
.219 .563 .937 r
.74654 .46317 .74992 .46525 .75307 .46612 .74969 .46404 Mtetra
0 .32 .744 r
.74969 .46404 .75307 .46612 .75626 .46779 .75288 .46571 Mtetra
0 .189 .602 r
.75288 .46571 .75626 .46779 .75947 .46977 .75609 .46769 Mtetra
0 .278 .701 r
.75609 .46769 .75947 .46977 .76269 .47155 .7593 .46946 Mtetra
.114 .514 .91 r
.7593 .46946 .76269 .47155 .76588 .47266 .76248 .47057 Mtetra
.47 .648 .936 r
.76248 .47057 .76588 .47266 .76902 .47272 .76563 .47062 Mtetra
.634 .665 .863 r
.76563 .47062 .76902 .47272 .77211 .47147 .76872 .46938 Mtetra
.702 .657 .802 r
.76872 .46938 .77211 .47147 .77514 .4688 .77174 .4667 Mtetra
.734 .647 .762 r
.77174 .4667 .77514 .4688 .7781 .46472 .7747 .46262 Mtetra
.75 .64 .738 r
.7747 .46262 .7781 .46472 .781 .45937 .7776 .45726 Mtetra
.76 .635 .723 r
.7776 .45726 .781 .45937 .78384 .45299 .78045 .45089 Mtetra
.765 .632 .714 r
.78045 .45089 .78384 .45299 .78665 .44592 .78326 .44381 Mtetra
.767 .631 .71 r
.78326 .44381 .78665 .44592 .78945 .4385 .78606 .43639 Mtetra
.766 .631 .711 r
.78606 .43639 .78945 .4385 .79224 .43113 .78885 .42902 Mtetra
.764 .632 .715 r
.78885 .42902 .79224 .43113 .79505 .42416 .79166 .42205 Mtetra
.759 .635 .725 r
.79166 .42205 .79505 .42416 .7979 .41794 .79452 .41582 Mtetra
.749 .64 .74 r
.79452 .41582 .7979 .41794 .8008 .41272 .79742 .4106 Mtetra
.732 .647 .764 r
.79742 .4106 .8008 .41272 .80378 .40872 .80039 .40659 Mtetra
.701 .656 .802 r
.80039 .40659 .80378 .40872 .80682 .40607 .80344 .40394 Mtetra
.633 .664 .862 r
.80344 .40394 .80682 .40607 .80995 .40482 .80657 .40269 Mtetra
.459 .643 .936 r
.80657 .40269 .80995 .40482 .81316 .40494 .80978 .40281 Mtetra
0 .444 .861 r
.80978 .40281 .81316 .40494 .81645 .40634 .81306 .40421 Mtetra
.551 0 0 r
.81306 .40421 .81645 .40634 .81982 .40886 .81642 .40673 Mtetra
.745 .226 0 r
.81642 .40673 .81982 .40886 .82324 .41229 .81984 .41015 Mtetra
.798 .322 .093 r
.81984 .41015 .82324 .41229 .82671 .41635 .82331 .41422 Mtetra
.813 .358 .153 r
.82331 .41422 .82671 .41635 .83022 .42078 .82681 .41864 Mtetra
.814 .362 .159 r
.82681 .41864 .83022 .42078 .83374 .42527 .83033 .42313 Mtetra
.804 .337 .118 r
.83033 .42313 .83374 .42527 .83726 .42952 .83384 .42737 Mtetra
.769 .266 .005 r
.83384 .42737 .83726 .42952 .84076 .43323 .83734 .43109 Mtetra
.649 .093 0 r
.83734 .43109 .84076 .43323 .84422 .43616 .84079 .43401 Mtetra
0 .279 .706 r
.84079 .43401 .84422 .43616 .84762 .43806 .8442 .43591 Mtetra
.308 .597 .947 r
.8442 .43591 .84762 .43806 .85096 .43876 .84754 .43661 Mtetra
.576 .664 .898 r
.84754 .43661 .85096 .43876 .85423 .43812 .8508 .43597 Mtetra
.676 .662 .829 r
.8508 .43597 .85423 .43812 .85741 .43607 .85398 .43391 Mtetra
.721 .653 .781 r
.85398 .43391 .85741 .43607 .8605 .43258 .85707 .43042 Mtetra
.745 .644 .749 r
.85707 .43042 .8605 .43258 .86351 .42769 .86008 .42552 Mtetra
.759 .638 .727 r
.86008 .42552 .86351 .42769 .86643 .42148 .863 .41931 Mtetra
.767 .633 .712 r
.863 .41931 .86643 .42148 .86928 .41409 .86585 .41193 Mtetra
.773 .63 .702 r
.86585 .41193 .86928 .41409 .87205 .4057 .86863 .40353 Mtetra
.777 .627 .695 r
.86863 .40353 .87205 .4057 .87477 .39652 .87135 .39434 Mtetra
.779 .626 .691 r
.87135 .39434 .87477 .39652 .87745 .38676 .87403 .38459 Mtetra
.78 .625 .688 r
.87403 .38459 .87745 .38676 .8801 .37669 .87668 .37451 Mtetra
.87668 .37451 .8801 .37669 .88274 .36655 .87933 .36437 Mtetra
.78 .625 .689 r
.87933 .36437 .88274 .36655 .88539 .3566 .88198 .35441 Mtetra
.778 .626 .692 r
.88198 .35441 .88539 .3566 .88806 .34706 .88466 .34487 Mtetra
.775 .628 .697 r
.88466 .34487 .88806 .34706 .89077 .33818 .88738 .33598 Mtetra
.771 .631 .705 r
.88738 .33598 .89077 .33818 .89355 .33014 .89015 .32794 Mtetra
.765 .634 .716 r
.89015 .32794 .89355 .33014 .89639 .32312 .89299 .32092 Mtetra
.755 .639 .732 r
.89299 .32092 .89639 .32312 .89932 .31726 .89592 .31506 Mtetra
.74 .645 .754 r
.89592 .31506 .89932 .31726 .90233 .31268 .89894 .31047 Mtetra
.714 .653 .787 r
.89894 .31047 .90233 .31268 .90545 .30944 .90206 .30723 Mtetra
.665 .661 .836 r
.90206 .30723 .90545 .30944 .90868 .30758 .90528 .30537 Mtetra
.556 .657 .903 r
.90528 .30537 .90868 .30758 .91201 .30711 .90862 .3049 Mtetra
.266 .575 .94 r
.90862 .3049 .91201 .30711 .91546 .30799 .91206 .30578 Mtetra
0 .225 .656 r
.91206 .30578 .91546 .30799 .919 .31016 .9156 .30794 Mtetra
.692 .149 0 r
.9156 .30794 .919 .31016 .92266 .31352 .91925 .3113 Mtetra
.799 .319 .077 r
.91925 .3113 .92266 .31352 .9264 .31794 .92299 .31572 Mtetra
.829 .394 .203 r
.92299 .31572 .9264 .31794 .93023 .32327 .92681 .32105 Mtetra
.839 .431 .269 r
.92681 .32105 .93023 .32327 .93413 .32934 .93071 .32712 Mtetra
.843 .451 .305 r
.93071 .32712 .93413 .32934 .93808 .33596 .93466 .33373 Mtetra
.844 .461 .323 r
.93466 .33373 .93808 .33596 .94208 .34292 .93865 .34069 Mtetra
.845 .464 .328 r
.93865 .34069 .94208 .34292 .94611 .35001 .94267 .34778 Mtetra
.844 .46 .322 r
.94267 .34778 .94611 .35001 .95015 .35701 .9467 .35477 Mtetra
.791 .501 .498 r
.49803 .61618 .50133 .61673 .50403 .62361 .50073 .62306 Mtetra
.791 .503 .5 r
.50073 .62306 .50403 .62361 .50675 .63064 .50344 .6301 Mtetra
.791 .502 .498 r
.50344 .6301 .50675 .63064 .50948 .63761 .50617 .63707 Mtetra
.79 .497 .492 r
.50617 .63707 .50948 .63761 .51222 .6443 .5089 .64377 Mtetra
.789 .489 .481 r
.5089 .64377 .51222 .6443 .51497 .65052 .51165 .64999 Mtetra
.786 .475 .462 r
.51165 .64999 .51497 .65052 .51773 .65607 .5144 .65554 Mtetra
.78 .45 .429 r
.5144 .65554 .51773 .65607 .5205 .66076 .51716 .66023 Mtetra
.767 .405 .369 r
.51716 .66023 .5205 .66076 .52327 .66443 .51993 .6639 Mtetra
.73 .304 .237 r
.51993 .6639 .52327 .66443 .52604 .66693 .5227 .66641 Mtetra
.548 0 0 r
.5227 .66641 .52604 .66693 .52881 .66817 .52547 .66765 Mtetra
.295 .743 .961 r
.52547 .66765 .52881 .66817 .53158 .66807 .52824 .66754 Mtetra
.693 .79 .925 r
.52824 .66754 .53158 .66807 .53435 .66657 .53101 .66605 Mtetra
.759 .733 .828 r
.53101 .66605 .53435 .66657 .53711 .66369 .53377 .66316 Mtetra
.778 .698 .775 r
.53377 .66316 .53711 .66369 .53987 .65946 .53652 .65893 Mtetra
.786 .678 .745 r
.53652 .65893 .53987 .65946 .54261 .65396 .53927 .65343 Mtetra
.79 .665 .726 r
.53927 .65343 .54261 .65396 .54534 .6473 .54201 .64676 Mtetra
.792 .656 .713 r
.54201 .64676 .54534 .6473 .54807 .63964 .54473 .6391 Mtetra
.793 .651 .704 r
.54473 .6391 .54807 .63964 .55078 .63115 .54745 .6306 Mtetra
.794 .647 .699 r
.54745 .6306 .55078 .63115 .55349 .62205 .55016 .62149 Mtetra
.794 .645 .696 r
.55016 .62149 .55349 .62205 .55619 .61256 .55287 .61199 Mtetra
.795 .644 .695 r
.55287 .61199 .55619 .61256 .55888 .60291 .55556 .60234 Mtetra
.55556 .60234 .55888 .60291 .56158 .59335 .55826 .59278 Mtetra
.794 .646 .698 r
.55826 .59278 .56158 .59335 .56427 .58413 .56095 .58355 Mtetra
.794 .649 .702 r
.56095 .58355 .56427 .58413 .56696 .57548 .56365 .57489 Mtetra
.792 .654 .71 r
.56365 .57489 .56696 .57548 .56966 .56761 .56636 .56702 Mtetra
.79 .662 .721 r
.56636 .56702 .56966 .56761 .57237 .56071 .56907 .56011 Mtetra
.787 .673 .739 r
.56907 .56011 .57237 .56071 .5751 .55493 .5718 .55433 Mtetra
.78 .691 .766 r
.5718 .55433 .5751 .55493 .57784 .5504 .57455 .5498 Mtetra
.764 .72 .812 r
.57455 .5498 .57784 .5504 .58061 .5472 .57731 .54659 Mtetra
.717 .768 .892 r
.57731 .54659 .58061 .5472 .5834 .54536 .5801 .54475 Mtetra
.501 .8 .999 r
.5801 .54475 .5834 .54536 .58621 .54486 .58291 .54425 Mtetra
.298 0 0 r
.58291 .54425 .58621 .54486 .58905 .54563 .58575 .54502 Mtetra
.673 .179 .066 r
.58575 .54502 .58905 .54563 .59191 .54755 .58861 .54694 Mtetra
.747 .334 .266 r
.58861 .54694 .59191 .54755 .5948 .55047 .59149 .54986 Mtetra
.769 .395 .347 r
.59149 .54986 .5948 .55047 .59771 .55417 .5944 .55356 Mtetra
.778 .423 .384 r
.5944 .55356 .59771 .55417 .60063 .55841 .59732 .5578 Mtetra
.781 .433 .398 r
.59732 .5578 .60063 .55841 .60358 .56291 .60026 .5623 Mtetra
.78 .432 .396 r
.60026 .5623 .60358 .56291 .60653 .56738 .60321 .56678 Mtetra
.776 .417 .376 r
.60321 .56678 .60653 .56738 .60949 .57153 .60616 .57093 Mtetra
.765 .381 .328 r
.60616 .57093 .60949 .57153 .61244 .57507 .60911 .57448 Mtetra
.732 .299 .221 r
.60911 .57448 .61244 .57507 .61538 .57774 .61205 .57714 Mtetra
.605 .067 0 r
.61205 .57714 .61538 .57774 .61831 .57931 .61498 .57871 Mtetra
.038 .59 .826 r
.61498 .57871 .61831 .57931 .62122 .57961 .61789 .57901 Mtetra
.634 .805 .965 r
.61789 .57901 .62122 .57961 .62411 .57853 .62077 .57794 Mtetra
.746 .749 .855 r
.62077 .57794 .62411 .57853 .62697 .57605 .62363 .57546 Mtetra
.774 .71 .792 r
.62363 .57546 .62697 .57605 .6298 .57222 .62646 .57162 Mtetra
.785 .688 .757 r
.62646 .57162 .6298 .57222 .6326 .56717 .62927 .56656 Mtetra
.79 .675 .737 r
.62927 .56656 .6326 .56717 .63538 .56111 .63205 .5605 Mtetra
.792 .667 .725 r
.63205 .5605 .63538 .56111 .63814 .55432 .63481 .5537 Mtetra
.793 .663 .72 r
.63481 .5537 .63814 .55432 .64089 .54713 .63757 .54651 Mtetra
.793 .663 .719 r
.63757 .54651 .64089 .54713 .64364 .5399 .64032 .53928 Mtetra
.793 .666 .724 r
.64032 .53928 .64364 .5399 .6464 .53302 .64308 .53239 Mtetra
.79 .673 .734 r
.64308 .53239 .6464 .53302 .64917 .52683 .64585 .5262 Mtetra
.786 .686 .754 r
.64585 .5262 .64917 .52683 .65197 .52165 .64865 .52101 Mtetra
.775 .707 .788 r
.64865 .52101 .65197 .52165 .6548 .51771 .65149 .51707 Mtetra
.747 .745 .85 r
.65149 .51707 .6548 .51771 .65768 .51514 .65436 .51449 Mtetra
.648 .798 .955 r
.65436 .51449 .65768 .51514 .66059 .51396 .65728 .51331 Mtetra
.199 .686 .926 r
.65728 .51331 .66059 .51396 .66355 .51406 .66024 .51341 Mtetra
.449 0 0 r
.66024 .51341 .66355 .51406 .66655 .51519 .66323 .51455 Mtetra
.636 .112 0 r
.66323 .51455 .66655 .51519 .66957 .51699 .66625 .51635 Mtetra
.667 .164 .04 r
.66625 .51635 .66957 .51699 .67261 .519 .66929 .51835 Mtetra
.618 .083 0 r
.66929 .51835 .67261 .519 .67564 .52071 .67232 .52006 Mtetra
.346 0 0 r
.67232 .52006 .67564 .52071 .67866 .52163 .67534 .52099 Mtetra
.396 .773 .992 r
.67534 .52099 .67866 .52163 .68165 .52137 .67832 .52073 Mtetra
.699 .781 .914 r
.67832 .52073 .68165 .52137 .6846 .51969 .68127 .51905 Mtetra
.761 .731 .825 r
.68127 .51905 .6846 .51969 .6875 .5166 .68417 .51595 Mtetra
.779 .704 .782 r
.68417 .51595 .6875 .5166 .69037 .51237 .68704 .51171 Mtetra
.784 .694 .765 r
.68704 .51171 .69037 .51237 .69322 .50755 .68989 .5069 Mtetra
.783 .697 .769 r
.68989 .5069 .69322 .50755 .69608 .5029 .69275 .50224 Mtetra
.772 .715 .799 r
.69275 .50224 .69608 .5029 .69897 .49917 .69564 .49851 Mtetra
.734 .758 .872 r
.69564 .49851 .69897 .49917 .70191 .4969 .69859 .49624 Mtetra
.59 .804 .982 r
.69859 .49624 .70191 .4969 .70491 .49603 .70159 .49537 Mtetra
.458 .789 .999 r
.70159 .49537 .70491 .49603 .70793 .49563 .70461 .49496 Mtetra
.692 .784 .921 r
.70461 .49496 .70793 .49563 .71091 .49401 .70759 .49335 Mtetra
.754 .739 .839 r
.70759 .49335 .71091 .49401 .71385 .49117 .71053 .4905 Mtetra
.692 .783 .921 r
.71053 .4905 .71385 .49117 .71684 .48955 .71352 .48888 Mtetra
.46 .789 .999 r
.71352 .48888 .71684 .48955 .71989 .48914 .71656 .48847 Mtetra
.591 .804 .981 r
.71656 .48847 .71989 .48914 .72291 .48826 .71959 .48758 Mtetra
.734 .759 .872 r
.71959 .48758 .72291 .48826 .72589 .48597 .72257 .48529 Mtetra
.773 .716 .8 r
.72257 .48529 .72589 .48597 .72881 .48221 .72549 .48153 Mtetra
.783 .698 .77 r
.72549 .48153 .72881 .48221 .7317 .47751 .72838 .47683 Mtetra
.784 .695 .766 r
.72838 .47683 .7317 .47751 .73458 .47265 .73126 .47197 Mtetra
.779 .705 .782 r
.73126 .47197 .73458 .47265 .73748 .46838 .73416 .46769 Mtetra
.761 .732 .825 r
.73416 .46769 .73748 .46838 .74044 .46523 .73712 .46454 Mtetra
.7 .779 .912 r
.73712 .46454 .74044 .46523 .74346 .46349 .74014 .4628 Mtetra
.425 .778 .996 r
.74014 .4628 .74346 .46349 .74654 .46317 .74322 .46248 Mtetra
.277 0 0 r
.74322 .46248 .74654 .46317 .74969 .46404 .74637 .46335 Mtetra
.584 .029 0 r
.74637 .46335 .74969 .46404 .75288 .46571 .74955 .46502 Mtetra
.643 .118 0 r
.74955 .46502 .75288 .46571 .75609 .46769 .75276 .46699 Mtetra
.606 .061 0 r
.75276 .46699 .75609 .46769 .7593 .46946 .75597 .46877 Mtetra
.392 0 0 r
.75597 .46877 .7593 .46946 .76248 .47057 .75915 .46988 Mtetra
.239 .705 .946 r
.75915 .46988 .76248 .47057 .76563 .47062 .76229 .46993 Mtetra
.648 .798 .954 r
.76229 .46993 .76563 .47062 .76872 .46938 .76538 .46868 Mtetra
.748 .748 .853 r
.76538 .46868 .76872 .46938 .77174 .4667 .76841 .46601 Mtetra
.777 .712 .791 r
.76841 .46601 .77174 .4667 .7747 .46262 .77137 .46192 Mtetra
.789 .69 .756 r
.77137 .46192 .7747 .46262 .7776 .45726 .77427 .45656 Mtetra
.794 .678 .736 r
.77427 .45656 .7776 .45726 .78045 .45089 .77712 .45018 Mtetra
.797 .67 .724 r
.77712 .45018 .78045 .45089 .78326 .44381 .77994 .4431 Mtetra
.798 .667 .72 r
.77994 .4431 .78326 .44381 .78606 .43639 .78273 .43568 Mtetra
.798 .668 .72 r
.78273 .43568 .78606 .43639 .78885 .42902 .78553 .42829 Mtetra
.796 .671 .726 r
.78553 .42829 .78885 .42902 .79166 .42205 .78835 .42132 Mtetra
.794 .679 .738 r
.78835 .42132 .79166 .42205 .79452 .41582 .7912 .41509 Mtetra
.788 .692 .759 r
.7912 .41509 .79452 .41582 .79742 .4106 .79411 .40986 Mtetra
.775 .713 .794 r
.79411 .40986 .79742 .4106 .80039 .40659 .79708 .40586 Mtetra
.745 .748 .854 r
.79708 .40586 .80039 .40659 .80344 .40394 .80013 .4032 Mtetra
.647 .794 .953 r
.80013 .4032 .80344 .40394 .80657 .40269 .80325 .40194 Mtetra
.22 .691 .94 r
.80325 .40194 .80657 .40269 .80978 .40281 .80646 .40207 Mtetra
.482 0 0 r
.80646 .40207 .80978 .40281 .81306 .40421 .80975 .40347 Mtetra
.697 .207 .077 r
.80975 .40347 .81306 .40421 .81642 .40673 .8131 .40599 Mtetra
.753 .322 .227 r
.8131 .40599 .81642 .40673 .81984 .41015 .81652 .40941 Mtetra
.772 .37 .293 r
.81652 .40941 .81984 .41015 .82331 .41422 .81999 .41348 Mtetra
.779 .391 .32 r
.81999 .41348 .82331 .41422 .82681 .41864 .82348 .4179 Mtetra
.78 .393 .323 r
.82348 .4179 .82681 .41864 .83033 .42313 .827 .42239 Mtetra
.775 .379 .304 r
.827 .42239 .83033 .42313 .83384 .42737 .83051 .42664 Mtetra
.761 .342 .254 r
.83051 .42664 .83384 .42737 .83734 .43109 .834 .43036 Mtetra
.724 .259 .145 r
.834 .43036 .83734 .43109 .84079 .43401 .83745 .43328 Mtetra
.604 .055 0 r
.83745 .43328 .84079 .43401 .8442 .43591 .84085 .43518 Mtetra
0 .458 .709 r
.84085 .43518 .8442 .43591 .84754 .43661 .84419 .43588 Mtetra
.522 .798 .996 r
.84419 .43588 .84754 .43661 .8508 .43597 .84745 .43523 Mtetra
.716 .774 .898 r
.84745 .43523 .8508 .43597 .85398 .43391 .85064 .43318 Mtetra
.768 .731 .819 r
.85064 .43318 .85398 .43391 .85707 .43042 .85373 .42968 Mtetra
.787 .703 .772 r
.85373 .42968 .85707 .43042 .86008 .42552 .85674 .42478 Mtetra
.796 .684 .742 r
.85674 .42478 .86008 .42552 .863 .41931 .85966 .41857 Mtetra
.8 .672 .722 r
.85966 .41857 .863 .41931 .86585 .41193 .86251 .41118 Mtetra
.803 .664 .709 r
.86251 .41118 .86585 .41193 .86863 .40353 .86529 .40278 Mtetra
.805 .658 .701 r
.86529 .40278 .86863 .40353 .87135 .39434 .86802 .39358 Mtetra
.806 .655 .695 r
.86802 .39358 .87135 .39434 .87403 .38459 .8707 .38382 Mtetra
.806 .653 .692 r
.8707 .38382 .87403 .38459 .87668 .37451 .87336 .37373 Mtetra
.87336 .37373 .87668 .37451 .87933 .36437 .87601 .36359 Mtetra
.806 .654 .693 r
.87601 .36359 .87933 .36437 .88198 .35441 .87867 .35362 Mtetra
.805 .656 .697 r
.87867 .35362 .88198 .35441 .88466 .34487 .88135 .34408 Mtetra
.804 .66 .703 r
.88135 .34408 .88466 .34487 .88738 .33598 .88407 .33518 Mtetra
.802 .666 .713 r
.88407 .33518 .88738 .33598 .89015 .32794 .88685 .32713 Mtetra
.799 .675 .727 r
.88685 .32713 .89015 .32794 .89299 .32092 .8897 .32011 Mtetra
.793 .687 .748 r
.8897 .32011 .89299 .32092 .89592 .31506 .89262 .31424 Mtetra
.782 .706 .779 r
.89262 .31424 .89592 .31506 .89894 .31047 .89565 .30965 Mtetra
.76 .734 .829 r
.89565 .30965 .89894 .31047 .90206 .30723 .89877 .30641 Mtetra
.699 .774 .909 r
.89877 .30641 .90206 .30723 .90528 .30537 .90199 .30454 Mtetra
.483 .782 .997 r
.90199 .30454 .90528 .30537 .90862 .3049 .90532 .30407 Mtetra
.182 0 0 r
.90532 .30407 .90862 .3049 .91206 .30578 .90876 .30495 Mtetra
.628 .084 0 r
.90876 .30495 .91206 .30578 .9156 .30794 .9123 .30712 Mtetra
.742 .284 .164 r
.9123 .30712 .9156 .30794 .91925 .3113 .91595 .31047 Mtetra
.777 .37 .279 r
.91595 .31047 .91925 .3113 .92299 .31572 .91968 .31489 Mtetra
.792 .413 .339 r
.91968 .31489 .92299 .31572 .92681 .32105 .9235 .32023 Mtetra
.799 .438 .372 r
.9235 .32023 .92681 .32105 .93071 .32712 .92739 .3263 Mtetra
.803 .451 .392 r
.92739 .3263 .93071 .32712 .93466 .33373 .93134 .33291 Mtetra
.804 .459 .402 r
.93134 .33291 .93466 .33373 .93865 .34069 .93533 .33988 Mtetra
.805 .461 .405 r
.93533 .33988 .93865 .34069 .94267 .34778 .93934 .34697 Mtetra
.804 .458 .401 r
.93934 .34697 .94267 .34778 .9467 .35477 .94337 .35397 Mtetra
.763 .489 .519 r
.49472 .61694 .49803 .61618 .50073 .62306 .49742 .62383 Mtetra
.763 .49 .521 r
.49742 .62383 .50073 .62306 .50344 .6301 .50013 .63087 Mtetra
.763 .489 .52 r
.50013 .63087 .50344 .6301 .50617 .63707 .50285 .63785 Mtetra
.761 .485 .515 r
.50285 .63785 .50617 .63707 .5089 .64377 .50558 .64456 Mtetra
.758 .477 .507 r
.50558 .64456 .5089 .64377 .51165 .64999 .50832 .65079 Mtetra
.752 .464 .494 r
.50832 .65079 .51165 .64999 .5144 .65554 .51107 .65634 Mtetra
.743 .443 .473 r
.51107 .65634 .5144 .65554 .51716 .66023 .51383 .66104 Mtetra
.727 .407 .438 r
.51383 .66104 .51716 .66023 .51993 .6639 .51659 .66471 Mtetra
.694 .339 .37 r
.51659 .66471 .51993 .6639 .5227 .66641 .51936 .66723 Mtetra
.606 .183 .213 r
.51936 .66723 .5227 .66641 .52547 .66765 .52213 .66847 Mtetra
.232 0 0 r
.52213 .66847 .52547 .66765 .52824 .66754 .5249 .66836 Mtetra
.648 .946 .955 r
.5249 .66836 .52824 .66754 .53101 .66605 .52767 .66687 Mtetra
.817 .855 .877 r
.52767 .66687 .53101 .66605 .53377 .66316 .53043 .66398 Mtetra
.83 .777 .802 r
.53043 .66398 .53377 .66316 .53652 .65893 .53318 .65975 Mtetra
.829 .735 .761 r
.53318 .65975 .53652 .65893 .53927 .65343 .53593 .65423 Mtetra
.826 .709 .736 r
.53593 .65423 .53927 .65343 .54201 .64676 .53867 .64757 Mtetra
.824 .694 .72 r
.53867 .64757 .54201 .64676 .54473 .6391 .54141 .63989 Mtetra
.822 .683 .71 r
.54141 .63989 .54473 .6391 .54745 .6306 .54413 .63139 Mtetra
.821 .677 .704 r
.54413 .63139 .54745 .6306 .55016 .62149 .54684 .62227 Mtetra
.82 .673 .7 r
.54684 .62227 .55016 .62149 .55287 .61199 .54955 .61276 Mtetra
.82 .672 .699 r
.54955 .61276 .55287 .61199 .55556 .60234 .55225 .6031 Mtetra
.55225 .6031 .55556 .60234 .55826 .59278 .55495 .59353 Mtetra
.821 .675 .702 r
.55495 .59353 .55826 .59278 .56095 .58355 .55765 .5843 Mtetra
.822 .681 .708 r
.55765 .5843 .56095 .58355 .56365 .57489 .56035 .57563 Mtetra
.823 .69 .717 r
.56035 .57563 .56365 .57489 .56636 .56702 .56306 .56774 Mtetra
.825 .704 .731 r
.56306 .56774 .56636 .56702 .56907 .56011 .56578 .56083 Mtetra
.827 .726 .753 r
.56578 .56083 .56907 .56011 .5718 .55433 .56851 .55504 Mtetra
.829 .762 .789 r
.56851 .55504 .5718 .55433 .57455 .5498 .57126 .55051 Mtetra
.821 .827 .854 r
.57126 .55051 .57455 .5498 .57731 .54659 .57403 .5473 Mtetra
.735 .93 .954 r
.57403 .5473 .57731 .54659 .5801 .54475 .57681 .54546 Mtetra
0 0 0 r
.57681 .54546 .5801 .54475 .58291 .54425 .57962 .54495 Mtetra
.525 .047 .064 r
.57962 .54495 .58291 .54425 .58575 .54502 .58246 .54573 Mtetra
.664 .271 .292 r
.58246 .54573 .58575 .54502 .58861 .54694 .58532 .54765 Mtetra
.709 .359 .381 r
.58532 .54765 .58861 .54694 .59149 .54986 .5882 .55058 Mtetra
.729 .4 .423 r
.5882 .55058 .59149 .54986 .5944 .55356 .5911 .55428 Mtetra
.739 .421 .444 r
.5911 .55428 .5944 .55356 .59732 .5578 .59403 .55853 Mtetra
.742 .429 .453 r
.59403 .55853 .59732 .5578 .60026 .5623 .59696 .56303 Mtetra
.742 .428 .451 r
.59696 .56303 .60026 .5623 .60321 .56678 .59991 .56752 Mtetra
.737 .416 .44 r
.59991 .56752 .60321 .56678 .60616 .57093 .60286 .57167 Mtetra
.724 .39 .413 r
.60286 .57167 .60616 .57093 .60911 .57448 .60581 .57522 Mtetra
.698 .337 .36 r
.60581 .57522 .60911 .57448 .61205 .57714 .60875 .57789 Mtetra
.632 .217 .239 r
.60875 .57789 .61205 .57714 .61498 .57871 .61167 .57946 Mtetra
.394 0 0 r
.61167 .57946 .61498 .57871 .61789 .57901 .61458 .57977 Mtetra
.443 .878 .886 r
.61458 .57977 .61789 .57901 .62077 .57794 .61746 .57869 Mtetra
.796 .893 .913 r
.61746 .57869 .62077 .57794 .62363 .57546 .62032 .57621 Mtetra
.83 .803 .826 r
.62032 .57621 .62363 .57546 .62646 .57162 .62316 .57237 Mtetra
.832 .754 .777 r
.62316 .57237 .62646 .57162 .62927 .56656 .62596 .56731 Mtetra
.831 .727 .75 r
.62596 .56731 .62927 .56656 .63205 .5605 .62875 .56123 Mtetra
.83 .713 .736 r
.62875 .56123 .63205 .5605 .63481 .5537 .63151 .55443 Mtetra
.829 .706 .729 r
.63151 .55443 .63481 .5537 .63757 .54651 .63427 .54723 Mtetra
.829 .705 .728 r
.63427 .54723 .63757 .54651 .64032 .53928 .63702 .54 Mtetra
.829 .711 .734 r
.63702 .54 .64032 .53928 .64308 .53239 .63979 .5331 Mtetra
.831 .724 .747 r
.63979 .5331 .64308 .53239 .64585 .5262 .64256 .5269 Mtetra
.832 .75 .773 r
.64256 .5269 .64585 .5262 .64865 .52101 .64537 .52171 Mtetra
.83 .797 .82 r
.64537 .52171 .64865 .52101 .65149 .51707 .6482 .51776 Mtetra
.799 .884 .907 r
.6482 .51776 .65149 .51707 .65436 .51449 .65108 .51519 Mtetra
.507 .906 .922 r
.65108 .51519 .65436 .51449 .65728 .51331 .654 .51401 Mtetra
.3 0 0 r
.654 .51401 .65728 .51331 .66024 .51341 .65695 .51411 Mtetra
.577 .122 .135 r
.65695 .51411 .66024 .51341 .66323 .51455 .65995 .51524 Mtetra
.648 .238 .254 r
.65995 .51524 .66323 .51455 .66625 .51635 .66297 .51704 Mtetra
.662 .264 .28 r
.66297 .51704 .66625 .51635 .66929 .51835 .666 .51905 Mtetra
.64 .225 .24 r
.666 .51905 .66929 .51835 .67232 .52006 .66903 .52077 Mtetra
.543 .069 .082 r
.66903 .52077 .67232 .52006 .67534 .52099 .67205 .52169 Mtetra
.109 0 0 r
.67205 .52169 .67534 .52099 .67832 .52073 .67503 .52143 Mtetra
.68 .943 .962 r
.67503 .52143 .67832 .52073 .68127 .51905 .67798 .51975 Mtetra
.819 .852 .873 r
.67798 .51975 .68127 .51905 .68417 .51595 .68089 .51665 Mtetra
.833 .79 .811 r
.68089 .51665 .68417 .51595 .68704 .51171 .68376 .51241 Mtetra
.834 .767 .788 r
.68376 .51241 .68704 .51171 .68989 .5069 .68661 .50759 Mtetra
.834 .773 .794 r
.68661 .50759 .68989 .5069 .69275 .50224 .68947 .50293 Mtetra
.829 .814 .835 r
.68947 .50293 .69275 .50224 .69564 .49851 .69236 .4992 Mtetra
.774 .912 .934 r
.69236 .4992 .69564 .49851 .69859 .49624 .69531 .49692 Mtetra
.312 .803 .816 r
.69531 .49692 .69859 .49624 .70159 .49537 .69831 .49605 Mtetra
.009 0 0 r
.69831 .49605 .70159 .49537 .70461 .49496 .70133 .49565 Mtetra
.659 .942 .962 r
.70133 .49565 .70461 .49496 .70759 .49335 .70431 .49403 Mtetra
.81 .871 .892 r
.70431 .49403 .70759 .49335 .71053 .4905 .70725 .49118 Mtetra
.659 .942 .962 r
.70725 .49118 .71053 .4905 .71352 .48888 .71024 .48956 Mtetra
.004 0 0 r
.71024 .48956 .71352 .48888 .71656 .48847 .71328 .48915 Mtetra
.314 .805 .818 r
.71328 .48915 .71656 .48847 .71959 .48758 .71631 .48827 Mtetra
.774 .914 .934 r
.71631 .48827 .71959 .48758 .72257 .48529 .71929 .48597 Mtetra
.83 .816 .836 r
.71929 .48597 .72257 .48529 .72549 .48153 .72221 .48221 Mtetra
.835 .775 .794 r
.72221 .48221 .72549 .48153 .72838 .47683 .7251 .4775 Mtetra
.835 .769 .789 r
.7251 .4775 .72838 .47683 .73126 .47197 .72798 .47264 Mtetra
.834 .792 .811 r
.72798 .47264 .73126 .47197 .73416 .46769 .73089 .46835 Mtetra
.819 .852 .873 r
.73089 .46835 .73416 .46769 .73712 .46454 .73385 .4652 Mtetra
.686 .941 .963 r
.73385 .4652 .73712 .46454 .74014 .4628 .73687 .46346 Mtetra
.059 0 0 r
.73687 .46346 .74014 .4628 .74322 .46248 .73995 .46314 Mtetra
.521 .033 .036 r
.73995 .46314 .74322 .46248 .74637 .46335 .7431 .46401 Mtetra
.629 .199 .207 r
.7431 .46401 .74637 .46335 .74955 .46502 .74628 .46568 Mtetra
.654 .242 .25 r
.74628 .46568 .74955 .46502 .75276 .46699 .74949 .46766 Mtetra
.638 .214 .222 r
.74949 .46766 .75276 .46699 .75597 .46877 .75269 .46944 Mtetra
.561 .091 .096 r
.75269 .46944 .75597 .46877 .75915 .46988 .75588 .47055 Mtetra
.268 0 0 r
.75588 .47055 .75915 .46988 .76229 .46993 .75902 .4706 Mtetra
.508 .906 .923 r
.75902 .4706 .76229 .46993 .76538 .46868 .76211 .46935 Mtetra
.799 .892 .91 r
.76211 .46935 .76538 .46868 .76841 .46601 .76513 .46667 Mtetra
.834 .807 .824 r
.76513 .46667 .76841 .46601 .77137 .46192 .7681 .46258 Mtetra
.838 .759 .775 r
.7681 .46258 .77137 .46192 .77427 .45656 .771 .45722 Mtetra
.837 .733 .749 r
.771 .45722 .77427 .45656 .77712 .45018 .77385 .45083 Mtetra
.836 .719 .734 r
.77385 .45083 .77712 .45018 .77994 .4431 .77667 .44374 Mtetra
.836 .713 .729 r
.77667 .44374 .77994 .4431 .78273 .43568 .77947 .43631 Mtetra
.77947 .43631 .78273 .43568 .78553 .42829 .78227 .42893 Mtetra
.836 .72 .736 r
.78227 .42893 .78553 .42829 .78835 .42132 .78509 .42195 Mtetra
.837 .735 .752 r
.78509 .42195 .78835 .42132 .7912 .41509 .78795 .41571 Mtetra
.838 .762 .779 r
.78795 .41571 .7912 .41509 .79411 .40986 .79086 .41048 Mtetra
.833 .809 .828 r
.79086 .41048 .79411 .40986 .79708 .40586 .79383 .40647 Mtetra
.796 .89 .912 r
.79383 .40647 .79708 .40586 .80013 .4032 .79688 .40381 Mtetra
.516 .907 .932 r
.79688 .40381 .80013 .4032 .80325 .40194 .80001 .40255 Mtetra
.28 0 0 r
.80001 .40255 .80325 .40194 .80646 .40207 .80322 .40268 Mtetra
.595 .136 .135 r
.80322 .40268 .80646 .40207 .80975 .40347 .8065 .40408 Mtetra
.683 .286 .289 r
.8065 .40408 .80975 .40347 .8131 .40599 .80986 .4066 Mtetra
.717 .352 .356 r
.80986 .4066 .8131 .40599 .81652 .40941 .81327 .41003 Mtetra
.733 .384 .389 r
.81327 .41003 .81652 .40941 .81999 .41348 .81674 .4141 Mtetra
.74 .399 .404 r
.81674 .4141 .81999 .41348 .82348 .4179 .82023 .41853 Mtetra
.74 .4 .406 r
.82023 .41853 .82348 .4179 .827 .42239 .82374 .42303 Mtetra
.736 .39 .395 r
.82374 .42303 .827 .42239 .83051 .42664 .82725 .42728 Mtetra
.724 .365 .37 r
.82725 .42728 .83051 .42664 .834 .43036 .83074 .431 Mtetra
.698 .315 .319 r
.83074 .431 .834 .43036 .83745 .43328 .83419 .43393 Mtetra
.64 .211 .213 r
.83419 .43393 .83745 .43328 .84085 .43518 .83759 .43583 Mtetra
.469 0 0 r
.83759 .43583 .84085 .43518 .84419 .43588 .84093 .43653 Mtetra
0 0 0 r
.84093 .43653 .84419 .43588 .84745 .43523 .84419 .43589 Mtetra
.726 .939 .955 r
.84419 .43589 .84745 .43523 .85064 .43318 .84737 .43383 Mtetra
.827 .85 .864 r
.84737 .43383 .85064 .43318 .85373 .42968 .85047 .43033 Mtetra
.841 .785 .797 r
.85047 .43033 .85373 .42968 .85674 .42478 .85348 .42543 Mtetra
.842 .745 .757 r
.85348 .42543 .85674 .42478 .85966 .41857 .85641 .41921 Mtetra
.841 .721 .732 r
.85641 .41921 .85966 .41857 .86251 .41118 .85926 .41181 Mtetra
.839 .706 .716 r
.85926 .41181 .86251 .41118 .86529 .40278 .86204 .4034 Mtetra
.838 .696 .706 r
.86204 .4034 .86529 .40278 .86802 .39358 .86477 .39419 Mtetra
.837 .689 .699 r
.86477 .39419 .86802 .39358 .8707 .38382 .86746 .38442 Mtetra
.837 .686 .696 r
.86746 .38442 .8707 .38382 .87336 .37373 .87013 .37433 Mtetra
.837 .685 .695 r
.87013 .37433 .87336 .37373 .87601 .36359 .87278 .36417 Mtetra
.837 .687 .697 r
.87278 .36417 .87601 .36359 .87867 .35362 .87544 .35419 Mtetra
.837 .691 .701 r
.87544 .35419 .87867 .35362 .88135 .34408 .87813 .34464 Mtetra
.838 .698 .708 r
.87813 .34464 .88135 .34408 .88407 .33518 .88085 .33573 Mtetra
.839 .709 .72 r
.88085 .33573 .88407 .33518 .88685 .32713 .88364 .32768 Mtetra
.841 .726 .738 r
.88364 .32768 .88685 .32713 .8897 .32011 .88649 .32064 Mtetra
.841 .752 .765 r
.88649 .32064 .8897 .32011 .89262 .31424 .88942 .31477 Mtetra
.838 .792 .808 r
.88942 .31477 .89262 .31424 .89565 .30965 .89244 .31018 Mtetra
.818 .858 .878 r
.89244 .31018 .89565 .30965 .89877 .30641 .89556 .30693 Mtetra
.692 .936 .965 r
.89556 .30693 .89877 .30641 .90199 .30454 .89879 .30507 Mtetra
0 0 0 r
.89879 .30507 .90199 .30454 .90532 .30407 .90212 .30459 Mtetra
.492 0 0 r
.90212 .30459 .90532 .30407 .90876 .30495 .90556 .30548 Mtetra
.655 .225 .213 r
.90556 .30548 .90876 .30495 .9123 .30712 .9091 .30764 Mtetra
.713 .33 .323 r
.9091 .30764 .9123 .30712 .91595 .31047 .91274 .31101 Mtetra
.74 .385 .379 r
.91274 .31101 .91595 .31047 .91968 .31489 .91647 .31543 Mtetra
.754 .416 .411 r
.91647 .31543 .91968 .31489 .9235 .32023 .92029 .32077 Mtetra
.762 .435 .431 r
.92029 .32077 .9235 .32023 .92739 .3263 .92418 .32685 Mtetra
.767 .446 .443 r
.92418 .32685 .92739 .3263 .93134 .33291 .92812 .33347 Mtetra
.77 .452 .449 r
.92812 .33347 .93134 .33291 .93533 .33988 .93211 .34044 Mtetra
.771 .454 .451 r
.93211 .34044 .93533 .33988 .93934 .34697 .93612 .34754 Mtetra
.77 .452 .449 r
.93612 .34754 .93934 .34697 .94337 .35397 .94014 .35455 Mtetra
.741 .479 .534 r
.49141 .61894 .49472 .61694 .49742 .62383 .4941 .62584 Mtetra
.741 .48 .535 r
.4941 .62584 .49742 .62383 .50013 .63087 .49681 .6329 Mtetra
.741 .479 .534 r
.49681 .6329 .50013 .63087 .50285 .63785 .49952 .63989 Mtetra
.738 .475 .531 r
.49952 .63989 .50285 .63785 .50558 .64456 .50225 .6466 Mtetra
.734 .467 .525 r
.50225 .6466 .50558 .64456 .50832 .65079 .50499 .65285 Mtetra
.727 .455 .515 r
.50499 .65285 .50832 .65079 .51107 .65634 .50774 .65841 Mtetra
.716 .436 .5 r
.50774 .65841 .51107 .65634 .51383 .66104 .51049 .66312 Mtetra
.698 .406 .476 r
.51049 .66312 .51383 .66104 .51659 .66471 .51325 .6668 Mtetra
.666 .353 .434 r
.51325 .6668 .51659 .66471 .51936 .66723 .51602 .66932 Mtetra
.6 .252 .351 r
.51602 .66932 .51936 .66723 .52213 .66847 .51879 .67056 Mtetra
.421 .007 .146 r
.51879 .67056 .52213 .66847 .5249 .66836 .52156 .67046 Mtetra
0 0 0 r
.52156 .67046 .5249 .66836 .52767 .66687 .52432 .66896 Mtetra
.831 .989 .866 r
.52432 .66896 .52767 .66687 .53043 .66398 .52709 .66608 Mtetra
.888 .88 .821 r
.52709 .66608 .53043 .66398 .53318 .65975 .52985 .66184 Mtetra
.879 .806 .773 r
.52985 .66184 .53318 .65975 .53593 .65423 .5326 .65632 Mtetra
.868 .763 .744 r
.5326 .65632 .53593 .65423 .53867 .64757 .53534 .64964 Mtetra
.86 .737 .726 r
.53534 .64964 .53867 .64757 .54141 .63989 .53808 .64196 Mtetra
.854 .721 .715 r
.53808 .64196 .54141 .63989 .54413 .63139 .54081 .63345 Mtetra
.851 .711 .707 r
.54081 .63345 .54413 .63139 .54684 .62227 .54353 .62432 Mtetra
.849 .705 .703 r
.54353 .62432 .54684 .62227 .54955 .61276 .54624 .61479 Mtetra
.848 .703 .702 r
.54624 .61479 .54955 .61276 .55225 .6031 .54895 .60512 Mtetra
.848 .704 .702 r
.54895 .60512 .55225 .6031 .55495 .59353 .55165 .59554 Mtetra
.85 .708 .706 r
.55165 .59554 .55495 .59353 .55765 .5843 .55436 .58629 Mtetra
.853 .717 .712 r
.55436 .58629 .55765 .5843 .56035 .57563 .55706 .57761 Mtetra
.858 .731 .722 r
.55706 .57761 .56035 .57563 .56306 .56774 .55978 .56972 Mtetra
.865 .754 .738 r
.55978 .56972 .56306 .56774 .56578 .56083 .5625 .5628 Mtetra
.874 .791 .764 r
.5625 .5628 .56578 .56083 .56851 .55504 .56523 .55701 Mtetra
.885 .854 .807 r
.56523 .55701 .56851 .55504 .57126 .55051 .56798 .55247 Mtetra
.863 .96 .866 r
.56798 .55247 .57126 .55051 .57403 .5473 .57075 .54926 Mtetra
.48 .874 .695 r
.57075 .54926 .57403 .5473 .57681 .54546 .57354 .54741 Mtetra
.296 0 0 r
.57354 .54741 .57681 .54546 .57962 .54495 .57635 .54691 Mtetra
.555 .179 .282 r
.57635 .54691 .57962 .54495 .58246 .54573 .57918 .54768 Mtetra
.642 .307 .389 r
.57918 .54768 .58246 .54573 .58532 .54765 .58204 .54962 Mtetra
.68 .368 .439 r
.58204 .54962 .58532 .54765 .5882 .55058 .58492 .55254 Mtetra
.7 .4 .465 r
.58492 .55254 .5882 .55058 .5911 .55428 .58783 .55626 Mtetra
.71 .418 .479 r
.58783 .55626 .5911 .55428 .59403 .55853 .59074 .56051 Mtetra
.714 .425 .485 r
.59074 .56051 .59403 .55853 .59696 .56303 .59368 .56503 Mtetra
.713 .423 .484 r
.59368 .56503 .59696 .56303 .59991 .56752 .59662 .56952 Mtetra
.708 .414 .476 r
.59662 .56952 .59991 .56752 .60286 .57167 .59957 .57368 Mtetra
.695 .392 .459 r
.59957 .57368 .60286 .57167 .60581 .57522 .60252 .57724 Mtetra
.67 .352 .427 r
.60252 .57724 .60581 .57522 .60875 .57789 .60545 .57992 Mtetra
.619 .273 .362 r
.60545 .57992 .60875 .57789 .61167 .57946 .60838 .58149 Mtetra
.492 .093 .212 r
.60838 .58149 .61167 .57946 .61458 .57977 .61129 .58179 Mtetra
.064 0 0 r
.61129 .58179 .61458 .57977 .61746 .57869 .61417 .58072 Mtetra
.724 .989 .832 r
.61417 .58072 .61746 .57869 .62032 .57621 .61703 .57823 Mtetra
.885 .923 .843 r
.61703 .57823 .62032 .57621 .62316 .57237 .61987 .57439 Mtetra
.888 .839 .792 r
.61987 .57439 .62316 .57237 .62596 .56731 .62268 .56932 Mtetra
.879 .793 .761 r
.62268 .56932 .62596 .56731 .62875 .56123 .62547 .56324 Mtetra
.873 .768 .744 r
.62547 .56324 .62875 .56123 .63151 .55443 .62824 .55643 Mtetra
.87 .757 .736 r
.62824 .55643 .63151 .55443 .63427 .54723 .631 .54922 Mtetra
.869 .756 .735 r
.631 .54922 .63427 .54723 .63702 .54 .63375 .54198 Mtetra
.872 .765 .742 r
.63375 .54198 .63702 .54 .63979 .5331 .63652 .53508 Mtetra
.878 .788 .757 r
.63652 .53508 .63979 .5331 .64256 .5269 .6393 .52887 Mtetra
.886 .831 .787 r
.6393 .52887 .64256 .5269 .64537 .52171 .64211 .52368 Mtetra
.886 .913 .838 r
.64211 .52368 .64537 .52171 .6482 .51776 .64495 .51972 Mtetra
.753 .995 .849 r
.64495 .51972 .6482 .51776 .65108 .51519 .64782 .51715 Mtetra
0 0 0 r
.64782 .51715 .65108 .51519 .654 .51401 .65074 .51597 Mtetra
.453 .037 .159 r
.65074 .51597 .654 .51401 .65695 .51411 .6537 .51607 Mtetra
.585 .218 .312 r
.6537 .51607 .65695 .51411 .65995 .51524 .65669 .51721 Mtetra
.631 .286 .368 r
.65669 .51721 .65995 .51524 .66297 .51704 .65971 .51901 Mtetra
.641 .302 .382 r
.65971 .51901 .66297 .51704 .666 .51905 .66274 .52103 Mtetra
.625 .278 .361 r
.66274 .52103 .666 .51905 .66903 .52077 .66577 .52275 Mtetra
.566 .19 .289 r
.66577 .52275 .66903 .52077 .67205 .52169 .66879 .52368 Mtetra
.374 0 .074 r
.66879 .52368 .67205 .52169 .67503 .52143 .67178 .52342 Mtetra
0 0 0 r
.67178 .52342 .67503 .52143 .67798 .51975 .67472 .52173 Mtetra
.838 .987 .866 r
.67472 .52173 .67798 .51975 .68089 .51665 .67763 .51863 Mtetra
.891 .9 .828 r
.67763 .51863 .68089 .51665 .68376 .51241 .6805 .51439 Mtetra
.892 .861 .804 r
.6805 .51439 .68376 .51241 .68661 .50759 .68336 .50956 Mtetra
.892 .871 .81 r
.68336 .50956 .68661 .50759 .68947 .50293 .68622 .5049 Mtetra
.881 .94 .85 r
.68622 .5049 .68947 .50293 .69236 .4992 .68912 .50116 Mtetra
.626 .954 .783 r
.68912 .50116 .69236 .4992 .69531 .49692 .69206 .49888 Mtetra
.164 0 0 r
.69206 .49888 .69531 .49692 .69831 .49605 .69506 .49801 Mtetra
.332 0 .026 r
.69506 .49801 .69831 .49605 .70133 .49565 .69809 .49761 Mtetra
0 0 0 r
.69809 .49761 .70133 .49565 .70431 .49403 .70107 .49599 Mtetra
.796 .997 .859 r
.70107 .49599 .70431 .49403 .70725 .49118 .70401 .49314 Mtetra
0 0 0 r
.70401 .49314 .70725 .49118 .71024 .48956 .707 .49152 Mtetra
.33 0 .023 r
.707 .49152 .71024 .48956 .71328 .48915 .71004 .49111 Mtetra
.162 0 0 r
.71004 .49111 .71328 .48915 .71631 .48827 .71307 .49023 Mtetra
.622 .951 .779 r
.71307 .49023 .71631 .48827 .71929 .48597 .71605 .48793 Mtetra
.881 .943 .85 r
.71605 .48793 .71929 .48597 .72221 .48221 .71898 .48416 Mtetra
.894 .875 .811 r
.71898 .48416 .72221 .48221 .7251 .4775 .72187 .47945 Mtetra
.893 .865 .804 r
.72187 .47945 .7251 .4775 .72798 .47264 .72476 .47458 Mtetra
.892 .904 .828 r
.72476 .47458 .72798 .47264 .73089 .46835 .72767 .47029 Mtetra
.838 .987 .865 r
.72767 .47029 .73089 .46835 .73385 .4652 .73063 .46714 Mtetra
0 0 0 r
.73063 .46714 .73385 .4652 .73687 .46346 .73365 .4654 Mtetra
.354 0 .045 r
.73365 .4654 .73687 .46346 .73995 .46314 .73673 .46508 Mtetra
.556 .171 .268 r
.73673 .46508 .73995 .46314 .7431 .46401 .73987 .46595 Mtetra
.619 .263 .344 r
.73987 .46595 .7431 .46401 .74628 .46568 .74306 .46763 Mtetra
.636 .288 .365 r
.74306 .46763 .74628 .46568 .74949 .46766 .74626 .46961 Mtetra
.625 .271 .351 r
.74626 .46961 .74949 .46766 .75269 .46944 .74947 .47139 Mtetra
.577 .202 .293 r
.74947 .47139 .75269 .46944 .75588 .47055 .75265 .47251 Mtetra
.441 .018 .139 r
.75265 .47251 .75588 .47055 .75902 .4706 .7558 .47257 Mtetra
0 0 0 r
.7558 .47257 .75902 .4706 .76211 .46935 .75889 .47132 Mtetra
.734 .991 .834 r
.75889 .47132 .76211 .46935 .76513 .46667 .76191 .46863 Mtetra
.89 .927 .839 r
.76191 .46863 .76513 .46667 .7681 .46258 .76488 .46454 Mtetra
.894 .846 .789 r
.76488 .46454 .7681 .46258 .771 .45722 .76779 .45917 Mtetra
.887 .8 .758 r
.76779 .45917 .771 .45722 .77385 .45083 .77064 .45278 Mtetra
.882 .777 .741 r
.77064 .45278 .77385 .45083 .77667 .44374 .77347 .44568 Mtetra
.879 .767 .735 r
.77347 .44568 .77667 .44374 .77947 .43631 .77627 .43824 Mtetra
.879 .768 .735 r
.77627 .43824 .77947 .43631 .78227 .42893 .77908 .43084 Mtetra
.882 .78 .744 r
.77908 .43084 .78227 .42893 .78509 .42195 .7819 .42385 Mtetra
.888 .805 .761 r
.7819 .42385 .78509 .42195 .78795 .41571 .78476 .4176 Mtetra
.895 .852 .793 r
.78476 .4176 .78795 .41571 .79086 .41048 .78767 .41237 Mtetra
.887 .932 .843 r
.78767 .41237 .79086 .41048 .79383 .40647 .79065 .40836 Mtetra
.731 .991 .838 r
.79065 .40836 .79383 .40647 .79688 .40381 .7937 .4057 Mtetra
0 0 0 r
.7937 .4057 .79688 .40381 .80001 .40255 .79683 .40444 Mtetra
.448 .021 .136 r
.79683 .40444 .80001 .40255 .80322 .40268 .80004 .40456 Mtetra
.598 .226 .309 r
.80004 .40456 .80322 .40268 .8065 .40408 .80332 .40597 Mtetra
.659 .318 .384 r
.80332 .40597 .8065 .40408 .80986 .4066 .80667 .4085 Mtetra
.688 .364 .422 r
.80667 .4085 .80986 .4066 .81327 .41003 .81009 .41193 Mtetra
.703 .388 .441 r
.81009 .41193 .81327 .41003 .81674 .4141 .81355 .41601 Mtetra
.71 .4 .45 r
.81355 .41601 .81674 .4141 .82023 .41853 .81704 .42046 Mtetra
.711 .401 .452 r
.81704 .42046 .82023 .41853 .82374 .42303 .82055 .42496 Mtetra
.706 .393 .445 r
.82055 .42496 .82374 .42303 .82725 .42728 .82406 .42922 Mtetra
.694 .374 .429 r
.82406 .42922 .82725 .42728 .83074 .431 .82754 .43295 Mtetra
.671 .337 .4 r
.82754 .43295 .83074 .431 .83419 .43393 .831 .43588 Mtetra
.627 .27 .345 r
.831 .43588 .83419 .43393 .83759 .43583 .8344 .43779 Mtetra
.531 .133 .232 r
.8344 .43779 .83759 .43583 .84093 .43653 .83773 .43849 Mtetra
.267 0 0 r
.83773 .43849 .84093 .43653 .84419 .43589 .841 .43785 Mtetra
.425 .833 .642 r
.841 .43785 .84419 .43589 .84737 .43383 .84418 .43579 Mtetra
.853 .984 .856 r
.84418 .43579 .84737 .43383 .85047 .43033 .84728 .43229 Mtetra
.901 .89 .81 r
.84728 .43229 .85047 .43033 .85348 .42543 .85029 .42738 Mtetra
.896 .822 .766 r
.85029 .42738 .85348 .42543 .85641 .41921 .85322 .42115 Mtetra
.887 .781 .738 r
.85322 .42115 .85641 .41921 .85926 .41181 .85608 .41374 Mtetra
.88 .755 .72 r
.85608 .41374 .85926 .41181 .86204 .4034 .85887 .40532 Mtetra
.875 .739 .708 r
.85887 .40532 .86204 .4034 .86477 .39419 .86161 .39611 Mtetra
.872 .729 .701 r
.86161 .39611 .86477 .39419 .86746 .38442 .8643 .38632 Mtetra
.87 .724 .697 r
.8643 .38632 .86746 .38442 .87013 .37433 .86697 .37621 Mtetra
.87 .723 .696 r
.86697 .37621 .87013 .37433 .87278 .36417 .86963 .36604 Mtetra
.871 .725 .698 r
.86963 .36604 .87278 .36417 .87544 .35419 .8723 .35605 Mtetra
.873 .732 .703 r
.8723 .35605 .87544 .35419 .87813 .34464 .87499 .34649 Mtetra
.876 .743 .711 r
.87499 .34649 .87813 .34464 .88085 .33573 .87772 .33757 Mtetra
.882 .761 .724 r
.87772 .33757 .88085 .33573 .88364 .32768 .8805 .3295 Mtetra
.889 .789 .744 r
.8805 .3295 .88364 .32768 .88649 .32064 .88336 .32246 Mtetra
.896 .833 .776 r
.88336 .32246 .88649 .32064 .88942 .31477 .88629 .31659 Mtetra
.897 .903 .822 r
.88629 .31659 .88942 .31477 .89244 .31018 .88932 .31198 Mtetra
.828 .991 .864 r
.88932 .31198 .89244 .31018 .89556 .30693 .89244 .30873 Mtetra
0 0 0 r
.89244 .30873 .89556 .30693 .89879 .30507 .89567 .30687 Mtetra
.298 0 0 r
.89567 .30687 .89879 .30507 .90212 .30459 .899 .3064 Mtetra
.545 .143 .229 r
.899 .3064 .90212 .30459 .90556 .30548 .90244 .30728 Mtetra
.64 .279 .343 r
.90244 .30728 .90556 .30548 .9091 .30764 .90598 .30946 Mtetra
.685 .349 .4 r
.90598 .30946 .9091 .30764 .91274 .31101 .90962 .31282 Mtetra
.71 .389 .433 r
.90962 .31282 .91274 .31101 .91647 .31543 .91336 .31726 Mtetra
.725 .414 .454 r
.91336 .31726 .91647 .31543 .92029 .32077 .91717 .32261 Mtetra
.734 .431 .467 r
.91717 .32261 .92029 .32077 .92418 .32685 .92105 .3287 Mtetra
.74 .44 .475 r
.92105 .3287 .92418 .32685 .92812 .33347 .925 .33533 Mtetra
.743 .446 .479 r
.925 .33533 .92812 .33347 .93211 .34044 .92898 .34232 Mtetra
.744 .447 .48 r
.92898 .34232 .93211 .34044 .93612 .34754 .93299 .34943 Mtetra
.743 .445 .478 r
.93299 .34943 .93612 .34754 .94014 .35455 .93701 .35645 Mtetra
.724 .47 .544 r
.48809 .62207 .49141 .61894 .4941 .62584 .49078 .629 Mtetra
.724 .472 .545 r
.49078 .629 .4941 .62584 .49681 .6329 .49348 .63606 Mtetra
.724 .471 .544 r
.49348 .63606 .49681 .6329 .49952 .63989 .49619 .64307 Mtetra
.721 .467 .541 r
.49619 .64307 .49952 .63989 .50225 .6466 .49892 .6498 Mtetra
.716 .46 .536 r
.49892 .6498 .50225 .6466 .50499 .65285 .50165 .65606 Mtetra
.709 .448 .529 r
.50165 .65606 .50499 .65285 .50774 .65841 .5044 .66164 Mtetra
.697 .43 .517 r
.5044 .66164 .50774 .65841 .51049 .66312 .50715 .66636 Mtetra
.678 .403 .499 r
.50715 .66636 .51049 .66312 .51325 .6668 .50991 .67005 Mtetra
.647 .36 .469 r
.50991 .67005 .51325 .6668 .51602 .66932 .51267 .67257 Mtetra
.591 .284 .416 r
.51267 .67257 .51602 .66932 .51879 .67056 .51544 .67383 Mtetra
.471 .13 .306 r
.51544 .67383 .51879 .67056 .52156 .67046 .51821 .67372 Mtetra
.145 0 .017 r
.51821 .67372 .52156 .67046 .52432 .66896 .52098 .67223 Mtetra
.593 .884 .581 r
.52098 .67223 .52432 .66896 .52709 .66608 .52375 .66934 Mtetra
.912 .974 .788 r
.52375 .66934 .52709 .66608 .52985 .66184 .52651 .66509 Mtetra
.927 .885 .772 r
.52651 .66509 .52985 .66184 .5326 .65632 .52927 .65957 Mtetra
.911 .823 .746 r
.52927 .65957 .5326 .65632 .53534 .64964 .53201 .65288 Mtetra
.898 .785 .728 r
.53201 .65288 .53534 .64964 .53808 .64196 .53475 .64519 Mtetra
.888 .762 .716 r
.53475 .64519 .53808 .64196 .54081 .63345 .53749 .63666 Mtetra
.882 .747 .708 r
.53749 .63666 .54081 .63345 .54353 .62432 .54021 .62752 Mtetra
.878 .739 .704 r
.54021 .62752 .54353 .62432 .54624 .61479 .54293 .61798 Mtetra
.877 .736 .702 r
.54293 .61798 .54624 .61479 .54895 .60512 .54564 .60829 Mtetra
.878 .737 .703 r
.54564 .60829 .54895 .60512 .55165 .59554 .54836 .5987 Mtetra
.88 .744 .707 r
.54836 .5987 .55165 .59554 .55436 .58629 .55107 .58944 Mtetra
.886 .756 .713 r
.55107 .58944 .55436 .58629 .55706 .57761 .55378 .58075 Mtetra
.894 .776 .724 r
.55378 .58075 .55706 .57761 .55978 .56972 .5565 .57284 Mtetra
.906 .809 .74 r
.5565 .57284 .55978 .56972 .5625 .5628 .55922 .56591 Mtetra
.922 .863 .765 r
.55922 .56591 .5625 .5628 .56523 .55701 .56196 .56011 Mtetra
.923 .949 .792 r
.56196 .56011 .56523 .55701 .56798 .55247 .56471 .55556 Mtetra
.749 .972 .704 r
.56471 .55556 .56798 .55247 .57075 .54926 .56748 .55235 Mtetra
0 0 0 r
.56748 .55235 .57075 .54926 .57354 .54741 .57027 .5505 Mtetra
.404 .042 .232 r
.57027 .5505 .57354 .54741 .57635 .54691 .57308 .55 Mtetra
.559 .234 .375 r
.57308 .55 .57635 .54691 .57918 .54768 .57592 .55078 Mtetra
.626 .324 .439 r
.57592 .55078 .57918 .54768 .58204 .54962 .57878 .55272 Mtetra
.66 .372 .472 r
.57878 .55272 .58204 .54962 .58492 .55254 .58166 .55566 Mtetra
.679 .399 .491 r
.58166 .55566 .58492 .55254 .58783 .55626 .58456 .55938 Mtetra
.689 .414 .501 r
.58456 .55938 .58783 .55626 .59074 .56051 .58747 .56365 Mtetra
.694 .42 .505 r
.58747 .56365 .59074 .56051 .59368 .56503 .59041 .56817 Mtetra
.693 .419 .504 r
.59041 .56817 .59368 .56503 .59662 .56952 .59335 .57268 Mtetra
.687 .411 .499 r
.59335 .57268 .59662 .56952 .59957 .57368 .59629 .57685 Mtetra
.674 .392 .486 r
.59629 .57685 .59957 .57368 .60252 .57724 .59924 .58042 Mtetra
.651 .359 .464 r
.59924 .58042 .60252 .57724 .60545 .57992 .60218 .5831 Mtetra
.607 .299 .422 r
.60218 .5831 .60545 .57992 .60838 .58149 .6051 .58469 Mtetra
.516 .181 .338 r
.6051 .58469 .60838 .58149 .61129 .58179 .60801 .58499 Mtetra
.287 0 .134 r
.60801 .58499 .61129 .58179 .61417 .58072 .6109 .58392 Mtetra
0 0 0 r
.6109 .58392 .61417 .58072 .61703 .57823 .61376 .58143 Mtetra
.857 .995 .758 r
.61376 .58143 .61703 .57823 .61987 .57439 .6166 .57758 Mtetra
.932 .929 .781 r
.6166 .57758 .61987 .57439 .62268 .56932 .61941 .57251 Mtetra
.926 .866 .76 r
.61941 .57251 .62268 .56932 .62547 .56324 .6222 .56642 Mtetra
.917 .83 .744 r
.6222 .56642 .62547 .56324 .62824 .55643 .62498 .5596 Mtetra
.912 .813 .736 r
.62498 .5596 .62824 .55643 .631 .54922 .62774 .55238 Mtetra
.911 .812 .736 r
.62774 .55238 .631 .54922 .63375 .54198 .6305 .54513 Mtetra
.916 .825 .742 r
.6305 .54513 .63375 .54198 .63652 .53508 .63327 .53822 Mtetra
.925 .858 .757 r
.63327 .53822 .63652 .53508 .6393 .52887 .63606 .532 Mtetra
.932 .919 .779 r
.63606 .532 .6393 .52887 .64211 .52368 .63887 .5268 Mtetra
.874 .994 .77 r
.63887 .5268 .64211 .52368 .64495 .51972 .64171 .52284 Mtetra
0 0 0 r
.64171 .52284 .64495 .51972 .64782 .51715 .64459 .52026 Mtetra
.253 0 .098 r
.64459 .52026 .64782 .51715 .65074 .51597 .64751 .51908 Mtetra
.492 .148 .31 r
.64751 .51908 .65074 .51597 .6537 .51607 .65047 .51919 Mtetra
.581 .261 .392 r
.65047 .51919 .6537 .51607 .65669 .51721 .65346 .52033 Mtetra
.617 .309 .425 r
.65346 .52033 .65669 .51721 .65971 .51901 .65648 .52214 Mtetra
.625 .321 .434 r
.65648 .52214 .65971 .51901 .66274 .52103 .65951 .52417 Mtetra
.612 .302 .421 r
.65951 .52417 .66274 .52103 .66577 .52275 .66254 .52589 Mtetra
.566 .242 .378 r
.66254 .52589 .66577 .52275 .66879 .52368 .66556 .52683 Mtetra
.446 .092 .269 r
.66556 .52683 .66879 .52368 .67178 .52342 .66855 .52657 Mtetra
.094 0 0 r
.66855 .52657 .67178 .52342 .67472 .52173 .6715 .52489 Mtetra
.617 .898 .596 r
.6715 .52489 .67472 .52173 .67763 .51863 .67441 .52178 Mtetra
.895 .988 .774 r
.67441 .52178 .67763 .51863 .6805 .51439 .67728 .51753 Mtetra
.927 .955 .781 r
.67728 .51753 .6805 .51439 .68336 .50956 .68014 .5127 Mtetra
.922 .965 .782 r
.68014 .5127 .68336 .50956 .68622 .5049 .68301 .50803 Mtetra
.82 .99 .734 r
.68301 .50803 .68622 .5049 .68912 .50116 .6859 .50429 Mtetra
0 0 0 r
.6859 .50429 .68912 .50116 .69206 .49888 .68885 .50201 Mtetra
.337 0 .17 r
.68885 .50201 .69206 .49888 .69506 .49801 .69185 .50114 Mtetra
.424 .063 .247 r
.69185 .50114 .69506 .49801 .69809 .49761 .69488 .50074 Mtetra
.123 0 0 r
.69488 .50074 .69809 .49761 .70107 .49599 .69786 .49913 Mtetra
0 0 0 r
.69786 .49913 .70107 .49599 .70401 .49314 .70081 .49627 Mtetra
.123 0 0 r
.70081 .49627 .70401 .49314 .707 .49152 .7038 .49465 Mtetra
.423 .062 .245 r
.7038 .49465 .707 .49152 .71004 .49111 .70684 .49424 Mtetra
.336 0 .169 r
.70684 .49424 .71004 .49111 .71307 .49023 .70987 .49336 Mtetra
0 0 0 r
.70987 .49336 .71307 .49023 .71605 .48793 .71285 .49106 Mtetra
.814 .988 .727 r
.71285 .49106 .71605 .48793 .71898 .48416 .71578 .48729 Mtetra
.921 .968 .779 r
.71578 .48729 .71898 .48416 .72187 .47945 .71868 .48258 Mtetra
.927 .958 .779 r
.71868 .48258 .72187 .47945 .72476 .47458 .72157 .4777 Mtetra
.893 .989 .769 r
.72157 .4777 .72476 .47458 .72767 .47029 .72448 .4734 Mtetra
.614 .896 .593 r
.72448 .4734 .72767 .47029 .73063 .46714 .72744 .47025 Mtetra
.081 0 0 r
.72744 .47025 .73063 .46714 .73365 .4654 .73047 .46851 Mtetra
.436 .076 .255 r
.73047 .46851 .73365 .4654 .73673 .46508 .73355 .46819 Mtetra
.56 .23 .366 r
.73355 .46819 .73673 .46508 .73987 .46595 .73669 .46907 Mtetra
.607 .292 .41 r
.73669 .46907 .73987 .46595 .74306 .46763 .73988 .47075 Mtetra
.621 .31 .422 r
.73988 .47075 .74306 .46763 .74626 .46961 .74308 .47274 Mtetra
.612 .298 .414 r
.74308 .47274 .74626 .46961 .74947 .47139 .74629 .47453 Mtetra
.575 .25 .38 r
.74629 .47453 .74947 .47139 .75265 .47251 .74947 .47565 Mtetra
.485 .137 .299 r
.74947 .47565 .75265 .47251 .7558 .47257 .75262 .47571 Mtetra
.253 0 .097 r
.75262 .47571 .7558 .47257 .75889 .47132 .75571 .47446 Mtetra
0 0 0 r
.75571 .47446 .75889 .47132 .76191 .46863 .75874 .47178 Mtetra
.855 .993 .744 r
.75874 .47178 .76191 .46863 .76488 .46454 .76171 .46768 Mtetra
.937 .936 .771 r
.76171 .46768 .76488 .46454 .76779 .45917 .76462 .4623 Mtetra
.935 .875 .753 r
.76462 .4623 .76779 .45917 .77064 .45278 .76748 .4559 Mtetra
.927 .841 .739 r
.76748 .4559 .77064 .45278 .77347 .44568 .77031 .44879 Mtetra
.923 .827 .733 r
.77031 .44879 .77347 .44568 .77627 .43824 .77312 .44134 Mtetra
.924 .829 .733 r
.77312 .44134 .77627 .43824 .77908 .43084 .77593 .43393 Mtetra
.929 .846 .741 r
.77593 .43393 .77908 .43084 .7819 .42385 .77876 .42693 Mtetra
.936 .882 .756 r
.77876 .42693 .7819 .42385 .78476 .4176 .78162 .42067 Mtetra
.935 .943 .774 r
.78162 .42067 .78476 .4176 .78767 .41237 .78454 .41543 Mtetra
.843 .993 .741 r
.78454 .41543 .78767 .41237 .79065 .40836 .78752 .41142 Mtetra
0 0 0 r
.78752 .41142 .79065 .40836 .7937 .4057 .79057 .40875 Mtetra
.246 0 .084 r
.79057 .40875 .7937 .4057 .79683 .40444 .7937 .4075 Mtetra
.49 .139 .297 r
.7937 .4075 .79683 .40444 .80004 .40456 .79691 .40763 Mtetra
.591 .267 .388 r
.79691 .40763 .80004 .40456 .80332 .40597 .80019 .40904 Mtetra
.641 .333 .434 r
.80019 .40904 .80332 .40597 .80667 .4085 .80355 .41158 Mtetra
.667 .369 .459 r
.80355 .41158 .80667 .4085 .81009 .41193 .80696 .41502 Mtetra
.682 .389 .472 r
.80696 .41502 .81009 .41193 .81355 .41601 .81042 .41911 Mtetra
.688 .399 .479 r
.81042 .41911 .81355 .41601 .81704 .42046 .81391 .42357 Mtetra
.689 .4 .479 r
.81391 .42357 .81704 .42046 .82055 .42496 .81742 .42808 Mtetra
.684 .393 .475 r
.81742 .42808 .82055 .42496 .82406 .42922 .82093 .43235 Mtetra
.673 .377 .464 r
.82093 .43235 .82406 .42922 .82754 .43295 .82441 .43609 Mtetra
.652 .348 .444 r
.82441 .43609 .82754 .43295 .831 .43588 .82787 .43903 Mtetra
.614 .297 .41 r
.82787 .43903 .831 .43588 .8344 .43779 .83127 .44095 Mtetra
.543 .205 .346 r
.83127 .44095 .8344 .43779 .83773 .43849 .8346 .44166 Mtetra
.39 .021 .213 r
.8346 .44166 .83773 .43849 .841 .43785 .83787 .44102 Mtetra
.008 0 0 r
.83787 .44102 .841 .43785 .84418 .43579 .84106 .43895 Mtetra
.647 .909 .599 r
.84106 .43895 .84418 .43579 .84728 .43229 .84416 .43545 Mtetra
.917 .978 .761 r
.84416 .43545 .84728 .43229 .85029 .42738 .84717 .43053 Mtetra
.943 .903 .754 r
.84717 .43053 .85029 .42738 .85322 .42115 .85011 .4243 Mtetra
.934 .846 .733 r
.85011 .4243 .85322 .42115 .85608 .41374 .85297 .41688 Mtetra
.922 .809 .716 r
.85297 .41688 .85608 .41374 .85887 .40532 .85577 .40845 Mtetra
.914 .786 .705 r
.85577 .40845 .85887 .40532 .86161 .39611 .85851 .39921 Mtetra
.908 .771 .698 r
.85851 .39921 .86161 .39611 .8643 .38632 .86121 .38941 Mtetra
.905 .764 .695 r
.86121 .38941 .8643 .38632 .86697 .37621 .86388 .37929 Mtetra
.905 .763 .694 r
.86388 .37929 .86697 .37621 .86963 .36604 .86655 .3691 Mtetra
.906 .766 .696 r
.86655 .3691 .86963 .36604 .8723 .35605 .86922 .35909 Mtetra
.91 .775 .7 r
.86922 .35909 .8723 .35605 .87499 .34649 .87192 .34951 Mtetra
.916 .792 .708 r
.87192 .34951 .87499 .34649 .87772 .33757 .87465 .34058 Mtetra
.925 .817 .721 r
.87465 .34058 .87772 .33757 .8805 .3295 .87745 .3325 Mtetra
.936 .858 .739 r
.87745 .3325 .8805 .3295 .88336 .32246 .8803 .32545 Mtetra
.942 .918 .761 r
.8803 .32545 .88336 .32246 .88629 .31659 .88324 .31957 Mtetra
.898 .987 .761 r
.88324 .31957 .88629 .31659 .88932 .31198 .88627 .31496 Mtetra
.577 .872 .565 r
.88627 .31496 .88932 .31198 .89244 .30873 .8894 .31171 Mtetra
.058 0 0 r
.8894 .31171 .89244 .30873 .89567 .30687 .89263 .30984 Mtetra
.408 .034 .214 r
.89263 .30984 .89567 .30687 .899 .3064 .89596 .30937 Mtetra
.554 .212 .343 r
.89596 .30937 .899 .3064 .90244 .30728 .8994 .31026 Mtetra
.625 .304 .407 r
.8994 .31026 .90244 .30728 .90598 .30946 .90295 .31244 Mtetra
.664 .357 .443 r
.90295 .31244 .90598 .30946 .90962 .31282 .90659 .31582 Mtetra
.688 .39 .465 r
.90659 .31582 .90962 .31282 .91336 .31726 .91032 .32027 Mtetra
.703 .412 .48 r
.91032 .32027 .91336 .31726 .91717 .32261 .91413 .32563 Mtetra
.713 .426 .489 r
.91413 .32563 .91717 .32261 .92105 .3287 .91801 .33173 Mtetra
.719 .435 .495 r
.91801 .33173 .92105 .3287 .925 .33533 .92195 .33839 Mtetra
.723 .44 .498 r
.92195 .33839 .925 .33533 .92898 .34232 .92594 .34539 Mtetra
.724 .442 .499 r
.92594 .34539 .92898 .34232 .93299 .34943 .92994 .35252 Mtetra
.722 .44 .498 r
.92994 .35252 .93299 .34943 .93701 .35645 .93396 .35956 Mtetra
.711 .464 .551 r
.48476 .62621 .48809 .62207 .49078 .629 .48744 .63315 Mtetra
.712 .466 .551 r
.48744 .63315 .49078 .629 .49348 .63606 .49014 .64024 Mtetra
.711 .465 .551 r
.49014 .64024 .49348 .63606 .49619 .64307 .49285 .64726 Mtetra
.708 .461 .548 r
.49285 .64726 .49619 .64307 .49892 .6498 .49557 .65402 Mtetra
.703 .454 .544 r
.49557 .65402 .49892 .6498 .50165 .65606 .4983 .66029 Mtetra
.695 .443 .538 r
.4983 .66029 .50165 .65606 .5044 .66164 .50105 .66588 Mtetra
.682 .426 .528 r
.50105 .66588 .5044 .66164 .50715 .66636 .5038 .67062 Mtetra
.664 .402 .514 r
.5038 .67062 .50715 .66636 .50991 .67005 .50656 .67432 Mtetra
.634 .363 .491 r
.50656 .67432 .50991 .67005 .51267 .67257 .50932 .67686 Mtetra
.585 .301 .452 r
.50932 .67686 .51267 .67257 .51544 .67383 .51209 .67811 Mtetra
.491 .187 .379 r
.51209 .67811 .51544 .67383 .51821 .67372 .51486 .67802 Mtetra
.281 0 .216 r
.51486 .67802 .51821 .67372 .52098 .67223 .51763 .67652 Mtetra
0 0 0 r
.51763 .67652 .52098 .67223 .52375 .66934 .5204 .67363 Mtetra
.812 .96 .631 r
.5204 .67363 .52375 .66934 .52651 .66509 .52317 .66938 Mtetra
.948 .949 .736 r
.52317 .66938 .52651 .66509 .52927 .65957 .52593 .66385 Mtetra
.948 .881 .735 r
.52593 .66385 .52927 .65957 .53201 .65288 .52868 .65715 Mtetra
.933 .833 .723 r
.52868 .65715 .53201 .65288 .53475 .64519 .53143 .64944 Mtetra
.92 .802 .713 r
.53143 .64944 .53475 .64519 .53749 .63666 .53416 .6409 Mtetra
.912 .783 .706 r
.53416 .6409 .53749 .63666 .54021 .62752 .5369 .63174 Mtetra
.907 .773 .702 r
.5369 .63174 .54021 .62752 .54293 .61798 .53962 .62219 Mtetra
.905 .769 .7 r
.53962 .62219 .54293 .61798 .54564 .60829 .54234 .61248 Mtetra
.906 .771 .701 r
.54234 .61248 .54564 .60829 .54836 .5987 .54506 .60287 Mtetra
.91 .779 .704 r
.54506 .60287 .54836 .5987 .55107 .58944 .54777 .59359 Mtetra
.917 .795 .71 r
.54777 .59359 .55107 .58944 .55378 .58075 .55049 .58489 Mtetra
.928 .821 .72 r
.55049 .58489 .55378 .58075 .5565 .57284 .55322 .57697 Mtetra
.943 .864 .732 r
.55322 .57697 .5565 .57284 .55922 .56591 .55595 .57002 Mtetra
.952 .928 .741 r
.55595 .57002 .55922 .56591 .56196 .56011 .55869 .56421 Mtetra
.883 .98 .691 r
.55869 .56421 .56196 .56011 .56471 .55556 .56144 .55966 Mtetra
0 0 0 r
.56144 .55966 .56471 .55556 .56748 .55235 .56422 .55645 Mtetra
.177 0 .124 r
.56422 .55645 .56748 .55235 .57027 .5505 .56701 .5546 Mtetra
.444 .128 .334 r
.56701 .5546 .57027 .5505 .57308 .55 .56982 .5541 Mtetra
.558 .263 .423 r
.56982 .5541 .57308 .55 .57592 .55078 .57266 .55489 Mtetra
.615 .333 .468 r
.57266 .55489 .57592 .55078 .57878 .55272 .57552 .55684 Mtetra
.646 .374 .492 r
.57552 .55684 .57878 .55272 .58166 .55566 .5784 .55978 Mtetra
.665 .398 .507 r
.5784 .55978 .58166 .55566 .58456 .55938 .58129 .56352 Mtetra
.675 .411 .515 r
.58129 .56352 .58456 .55938 .58747 .56365 .58421 .5678 Mtetra
.679 .417 .518 r
.58421 .5678 .58747 .56365 .59041 .56817 .58714 .57234 Mtetra
.678 .416 .518 r
.58714 .57234 .59041 .56817 .59335 .57268 .59008 .57685 Mtetra
.672 .408 .513 r
.59008 .57685 .59335 .57268 .59629 .57685 .59303 .58105 Mtetra
.66 .392 .503 r
.59303 .58105 .59629 .57685 .59924 .58042 .59597 .58462 Mtetra
.637 .363 .486 r
.59597 .58462 .59924 .58042 .60218 .5831 .59891 .58732 Mtetra
.598 .313 .455 r
.59891 .58732 .60218 .5831 .6051 .58469 .60183 .58891 Mtetra
.524 .223 .398 r
.60183 .58891 .6051 .58469 .60801 .58499 .60474 .58922 Mtetra
.368 .044 .278 r
.60474 .58922 .60801 .58499 .6109 .58392 .60763 .58814 Mtetra
0 0 0 r
.60763 .58814 .6109 .58392 .61376 .58143 .6105 .58566 Mtetra
.631 .858 .486 r
.6105 .58566 .61376 .58143 .6166 .57758 .61334 .58181 Mtetra
.916 .976 .703 r
.61334 .58181 .6166 .57758 .61941 .57251 .61615 .57672 Mtetra
.955 .929 .732 r
.61615 .57672 .61941 .57251 .6222 .56642 .61895 .57063 Mtetra
.953 .888 .729 r
.61895 .57063 .6222 .56642 .62498 .5596 .62173 .5638 Mtetra
.948 .868 .725 r
.62173 .5638 .62498 .5596 .62774 .55238 .6245 .55656 Mtetra
.948 .866 .725 r
.6245 .55656 .62774 .55238 .6305 .54513 .62727 .5493 Mtetra
.952 .883 .728 r
.62727 .5493 .6305 .54513 .63327 .53822 .63004 .54238 Mtetra
.956 .921 .732 r
.63004 .54238 .63327 .53822 .63606 .532 .63283 .53615 Mtetra
.928 .972 .713 r
.63283 .53615 .63606 .532 .63887 .5268 .63565 .53094 Mtetra
.68 .891 .527 r
.63565 .53094 .63887 .5268 .64171 .52284 .63849 .52698 Mtetra
0 0 0 r
.63849 .52698 .64171 .52284 .64459 .52026 .64137 .5244 Mtetra
.348 .019 .258 r
.64137 .5244 .64459 .52026 .64751 .51908 .64429 .52322 Mtetra
.507 .2 .38 r
.64429 .52322 .64751 .51908 .65047 .51919 .64725 .52333 Mtetra
.576 .283 .434 r
.64725 .52333 .65047 .51919 .65346 .52033 .65025 .52448 Mtetra
.607 .321 .457 r
.65025 .52448 .65346 .52033 .65648 .52214 .65327 .5263 Mtetra
.614 .331 .463 r
.65327 .5263 .65648 .52214 .65951 .52417 .6563 .52833 Mtetra
.603 .316 .454 r
.6563 .52833 .65951 .52417 .66254 .52589 .65933 .53006 Mtetra
.564 .269 .425 r
.65933 .53006 .66254 .52589 .66556 .52683 .66235 .531 Mtetra
.473 .161 .356 r
.66235 .531 .66556 .52683 .66855 .52657 .66534 .53075 Mtetra
.252 0 .187 r
.66534 .53075 .66855 .52657 .6715 .52489 .66829 .52907 Mtetra
0 0 0 r
.66829 .52907 .6715 .52489 .67441 .52178 .6712 .52596 Mtetra
.739 .921 .564 r
.6712 .52596 .67441 .52178 .67728 .51753 .67408 .52171 Mtetra
.872 .974 .664 r
.67408 .52171 .67728 .51753 .68014 .5127 .67694 .51687 Mtetra
.844 .967 .643 r
.67694 .51687 .68014 .5127 .68301 .50803 .67981 .51219 Mtetra
0 0 0 r
.67981 .51219 .68301 .50803 .6859 .50429 .68272 .50845 Mtetra
.088 0 .06 r
.68272 .50845 .6859 .50429 .68885 .50201 .68567 .50617 Mtetra
.4 .077 .298 r
.68567 .50617 .68885 .50201 .69185 .50114 .68867 .5053 Mtetra
.458 .142 .342 r
.68867 .5053 .69185 .50114 .69488 .50074 .69169 .5049 Mtetra
.27 0 .199 r
.69169 .5049 .69488 .50074 .69786 .49913 .69468 .50329 Mtetra
0 0 0 r
.69468 .50329 .69786 .49913 .70081 .49627 .69763 .50043 Mtetra
.269 0 .199 r
.69763 .50043 .70081 .49627 .7038 .49465 .70062 .49881 Mtetra
.457 .141 .341 r
.70062 .49881 .7038 .49465 .70684 .49424 .70367 .4984 Mtetra
.4 .076 .297 r
.70367 .4984 .70684 .49424 .70987 .49336 .7067 .49753 Mtetra
.091 0 .064 r
.7067 .49753 .70987 .49336 .71285 .49106 .70969 .49523 Mtetra
0 0 0 r
.70969 .49523 .71285 .49106 .71578 .48729 .71262 .49145 Mtetra
.835 .962 .632 r
.71262 .49145 .71578 .48729 .71868 .48258 .71552 .48673 Mtetra
.864 .971 .654 r
.71552 .48673 .71868 .48258 .72157 .4777 .71841 .48185 Mtetra
.727 .913 .551 r
.71841 .48185 .72157 .4777 .72448 .4734 .72133 .47755 Mtetra
0 0 0 r
.72133 .47755 .72448 .4734 .72744 .47025 .72429 .47438 Mtetra
.245 0 .179 r
.72429 .47438 .72744 .47025 .73047 .46851 .72732 .47264 Mtetra
.467 .151 .346 r
.72732 .47264 .73047 .46851 .73355 .46819 .73041 .47233 Mtetra
.559 .259 .416 r
.73041 .47233 .73355 .46819 .73669 .46907 .73355 .47322 Mtetra
.598 .307 .446 r
.73355 .47322 .73669 .46907 .73988 .47075 .73673 .47491 Mtetra
.611 .322 .455 r
.73673 .47491 .73988 .47075 .74308 .47274 .73994 .47691 Mtetra
.602 .312 .449 r
.73994 .47691 .74308 .47274 .74629 .47453 .74315 .4787 Mtetra
.571 .275 .426 r
.74315 .4787 .74629 .47453 .74947 .47565 .74633 .47983 Mtetra
.502 .192 .373 r
.74633 .47983 .74947 .47565 .75262 .47571 .74948 .4799 Mtetra
.348 .019 .258 r
.74948 .4799 .75262 .47571 .75571 .47446 .75257 .47865 Mtetra
0 0 0 r
.75257 .47865 .75571 .47446 .75874 .47178 .75561 .47596 Mtetra
.618 .843 .462 r
.75561 .47596 .75874 .47178 .76171 .46768 .75858 .47186 Mtetra
.91 .973 .68 r
.75858 .47186 .76171 .46768 .76462 .4623 .76149 .46647 Mtetra
.959 .936 .716 r
.76149 .46647 .76462 .4623 .76748 .4559 .76436 .46006 Mtetra
.961 .901 .717 r
.76436 .46006 .76748 .4559 .77031 .44879 .76719 .45294 Mtetra
.959 .884 .715 r
.76719 .45294 .77031 .44879 .77312 .44134 .77001 .44548 Mtetra
.959 .886 .715 r
.77001 .44548 .77312 .44134 .77593 .43393 .77282 .43806 Mtetra
.962 .906 .718 r
.77282 .43806 .77593 .43393 .77876 .42693 .77565 .43104 Mtetra
.957 .943 .715 r
.77565 .43104 .77876 .42693 .78162 .42067 .77852 .42478 Mtetra
.897 .974 .672 r
.77852 .42478 .78162 .42067 .78454 .41543 .78144 .41953 Mtetra
.592 .828 .447 r
.78144 .41953 .78454 .41543 .78752 .41142 .78443 .4155 Mtetra
0 0 0 r
.78443 .4155 .78752 .41142 .79057 .40875 .78748 .41284 Mtetra
.344 .012 .25 r
.78748 .41284 .79057 .40875 .7937 .4075 .79062 .41159 Mtetra
.506 .194 .371 r
.79062 .41159 .7937 .4075 .79691 .40763 .79383 .41172 Mtetra
.585 .288 .43 r
.79383 .41172 .79691 .40763 .80019 .40904 .79711 .41314 Mtetra
.628 .341 .463 r
.79711 .41314 .80019 .40904 .80355 .41158 .80047 .41569 Mtetra
.653 .372 .481 r
.80047 .41569 .80355 .41158 .80696 .41502 .80388 .41914 Mtetra
.667 .389 .491 r
.80388 .41914 .80696 .41502 .81042 .41911 .80734 .42325 Mtetra
.673 .398 .496 r
.80734 .42325 .81042 .41911 .81391 .42357 .81083 .42772 Mtetra
.674 .399 .497 r
.81083 .42772 .81391 .42357 .81742 .42808 .81434 .43225 Mtetra
.669 .393 .493 r
.81434 .43225 .81742 .42808 .82093 .43235 .81785 .43653 Mtetra
.658 .379 .485 r
.81785 .43653 .82093 .43235 .82441 .43609 .82133 .44028 Mtetra
.638 .353 .47 r
.82133 .44028 .82441 .43609 .82787 .43903 .82479 .44324 Mtetra
.604 .312 .446 r
.82479 .44324 .82787 .43903 .83127 .44095 .82819 .44516 Mtetra
.546 .241 .403 r
.82819 .44516 .83127 .44095 .8346 .44166 .83153 .44588 Mtetra
.435 .115 .322 r
.83153 .44588 .8346 .44166 .83787 .44102 .8348 .44524 Mtetra
.202 0 .151 r
.8348 .44524 .83787 .44102 .84106 .43895 .83798 .44318 Mtetra
0 0 0 r
.83798 .44318 .84106 .43895 .84416 .43545 .84109 .43967 Mtetra
.79 .936 .577 r
.84109 .43967 .84416 .43545 .84717 .43053 .84411 .43475 Mtetra
.949 .957 .694 r
.84411 .43475 .84717 .43053 .85011 .4243 .84705 .4285 Mtetra
.966 .904 .707 r
.84705 .4285 .85011 .4243 .85297 .41688 .84992 .42107 Mtetra
.958 .86 .701 r
.84992 .42107 .85297 .41688 .85577 .40845 .85272 .41262 Mtetra
.949 .831 .694 r
.85272 .41262 .85577 .40845 .85851 .39921 .85547 .40337 Mtetra
.942 .813 .689 r
.85547 .40337 .85851 .39921 .86121 .38941 .85817 .39355 Mtetra
.938 .804 .686 r
.85817 .39355 .86121 .38941 .86388 .37929 .86085 .38341 Mtetra
.937 .802 .686 r
.86085 .38341 .86388 .37929 .86655 .3691 .86353 .3732 Mtetra
.939 .806 .687 r
.86353 .3732 .86655 .3691 .86922 .35909 .86621 .36317 Mtetra
.943 .818 .691 r
.86621 .36317 .86922 .35909 .87192 .34951 .86891 .35358 Mtetra
.951 .839 .697 r
.86891 .35358 .87192 .34951 .87465 .34058 .87165 .34463 Mtetra
.96 .871 .704 r
.87165 .34463 .87465 .34058 .87745 .3325 .87445 .33654 Mtetra
.965 .917 .708 r
.87445 .33654 .87745 .3325 .8803 .32545 .87731 .32947 Mtetra
.934 .966 .687 r
.87731 .32947 .8803 .32545 .88324 .31957 .88026 .32358 Mtetra
.733 .911 .543 r
.88026 .32358 .88324 .31957 .88627 .31496 .88329 .31896 Mtetra
0 0 0 r
.88329 .31896 .88627 .31496 .8894 .31171 .88642 .31571 Mtetra
.233 0 .162 r
.88642 .31571 .8894 .31171 .89263 .30984 .88965 .31384 Mtetra
.449 .123 .321 r
.88965 .31384 .89263 .30984 .89596 .30937 .89299 .31337 Mtetra
.555 .246 .399 r
.89299 .31337 .89596 .30937 .8994 .31026 .89643 .31427 Mtetra
.614 .317 .443 r
.89643 .31427 .8994 .31026 .90295 .31244 .89997 .31646 Mtetra
.649 .361 .469 r
.89997 .31646 .90295 .31244 .90659 .31582 .90361 .31985 Mtetra
.672 .39 .486 r
.90361 .31985 .90659 .31582 .91032 .32027 .90735 .32431 Mtetra
.688 .41 .497 r
.90735 .32431 .91032 .32027 .91413 .32563 .91116 .32969 Mtetra
.698 .423 .504 r
.91116 .32969 .91413 .32563 .91801 .33173 .91504 .33582 Mtetra
.704 .431 .509 r
.91504 .33582 .91801 .33173 .92195 .33839 .91898 .34249 Mtetra
.708 .436 .511 r
.91898 .34249 .92195 .33839 .92594 .34539 .92296 .34951 Mtetra
.709 .437 .512 r
.92296 .34951 .92594 .34539 .92994 .35252 .92697 .35666 Mtetra
.707 .436 .511 r
.92697 .35666 .92994 .35252 .93396 .35956 .93099 .36372 Mtetra
.701 .46 .555 r
.48142 .63117 .48476 .62621 .48744 .63315 .4841 .63814 Mtetra
.702 .461 .556 r
.4841 .63814 .48744 .63315 .49014 .64024 .48679 .64525 Mtetra
.701 .46 .555 r
.48679 .64525 .49014 .64024 .49285 .64726 .4895 .6523 Mtetra
.698 .456 .553 r
.4895 .6523 .49285 .64726 .49557 .65402 .49222 .65907 Mtetra
.693 .449 .55 r
.49222 .65907 .49557 .65402 .4983 .66029 .49495 .66536 Mtetra
.685 .439 .544 r
.49495 .66536 .4983 .66029 .50105 .66588 .49769 .67098 Mtetra
.672 .423 .536 r
.49769 .67098 .50105 .66588 .5038 .67062 .50044 .67573 Mtetra
.654 .4 .523 r
.50044 .67573 .5038 .67062 .50656 .67432 .5032 .67944 Mtetra
.626 .365 .504 r
.5032 .67944 .50656 .67432 .50932 .67686 .50596 .68199 Mtetra
.58 .311 .473 r
.50596 .68199 .50932 .67686 .51209 .67811 .50873 .68326 Mtetra
.5 .218 .418 r
.50873 .68326 .51209 .67811 .51486 .67802 .5115 .68316 Mtetra
.342 .044 .306 r
.5115 .68316 .51486 .67802 .51763 .67652 .51428 .68167 Mtetra
0 0 .054 r
.51428 .68167 .51763 .67652 .5204 .67363 .51705 .67878 Mtetra
.595 .801 .388 r
.51705 .67878 .5204 .67363 .52317 .66938 .51982 .67452 Mtetra
.915 .964 .65 r
.51982 .67452 .52317 .66938 .52593 .66385 .52258 .66898 Mtetra
.966 .924 .705 r
.52258 .66898 .52593 .66385 .52868 .65715 .52534 .66227 Mtetra
.959 .874 .708 r
.52534 .66227 .52868 .65715 .53143 .64944 .52809 .65455 Mtetra
.947 .839 .704 r
.52809 .65455 .53143 .64944 .53416 .6409 .53084 .64599 Mtetra
.937 .816 .7 r
.53084 .64599 .53416 .6409 .5369 .63174 .53357 .63681 Mtetra
.931 .804 .697 r
.53357 .63681 .5369 .63174 .53962 .62219 .53631 .62724 Mtetra
.929 .799 .695 r
.53631 .62724 .53962 .62219 .54234 .61248 .53903 .61751 Mtetra
.93 .801 .696 r
.53903 .61751 .54234 .61248 .54506 .60287 .54176 .60788 Mtetra
.935 .811 .699 r
.54176 .60788 .54506 .60287 .54777 .59359 .54448 .59859 Mtetra
.943 .83 .703 r
.54448 .59859 .54777 .59359 .55049 .58489 .5472 .58986 Mtetra
.955 .861 .708 r
.5472 .58986 .55049 .58489 .55322 .57697 .54993 .58193 Mtetra
.965 .908 .709 r
.54993 .58193 .55322 .57697 .55595 .57002 .55267 .57497 Mtetra
.943 .96 .68 r
.55267 .57497 .55595 .57002 .55869 .56421 .55542 .56915 Mtetra
.731 .892 .501 r
.55542 .56915 .55869 .56421 .56144 .55966 .55818 .5646 Mtetra
0 0 0 r
.55818 .5646 .56144 .55966 .56422 .55645 .56095 .56138 Mtetra
.269 0 .247 r
.56095 .56138 .56422 .55645 .56701 .5546 .56375 .55953 Mtetra
.463 .172 .385 r
.56375 .55953 .56701 .5546 .56982 .5541 .56656 .55904 Mtetra
.556 .279 .45 r
.56656 .55904 .56982 .5541 .57266 .55489 .5694 .55983 Mtetra
.607 .339 .485 r
.5694 .55983 .57266 .55489 .57552 .55684 .57226 .56179 Mtetra
.637 .375 .505 r
.57226 .56179 .57552 .55684 .5784 .55978 .57514 .56475 Mtetra
.655 .397 .517 r
.57514 .56475 .5784 .55978 .58129 .56352 .57803 .5685 Mtetra
.665 .409 .524 r
.57803 .5685 .58129 .56352 .58421 .5678 .58095 .57279 Mtetra
.669 .415 .527 r
.58095 .57279 .58421 .5678 .58714 .57234 .58388 .57735 Mtetra
.668 .414 .527 r
.58388 .57735 .58714 .57234 .59008 .57685 .58682 .58188 Mtetra
.662 .406 .523 r
.58682 .58188 .59008 .57685 .59303 .58105 .58976 .58609 Mtetra
.65 .391 .514 r
.58976 .58609 .59303 .58105 .59597 .58462 .59271 .58968 Mtetra
.628 .365 .5 r
.59271 .58968 .59597 .58462 .59891 .58732 .59564 .59238 Mtetra
.592 .321 .475 r
.59564 .59238 .59891 .58732 .60183 .58891 .59857 .59398 Mtetra
.528 .247 .432 r
.59857 .59398 .60183 .58891 .60474 .58922 .60148 .5943 Mtetra
.405 .11 .347 r
.60148 .5943 .60474 .58922 .60763 .58814 .60437 .59323 Mtetra
.144 0 .164 r
.60437 .59323 .60763 .58814 .6105 .58566 .60724 .59074 Mtetra
0 0 0 r
.60724 .59074 .6105 .58566 .61334 .58181 .61008 .58688 Mtetra
.805 .925 .546 r
.61008 .58688 .61334 .58181 .61615 .57672 .61291 .58179 Mtetra
.943 .958 .666 r
.61291 .58179 .61615 .57672 .61895 .57063 .61571 .57569 Mtetra
.967 .93 .693 r
.61571 .57569 .61895 .57063 .62173 .5638 .61849 .56884 Mtetra
.969 .911 .699 r
.61849 .56884 .62173 .5638 .6245 .55656 .62127 .5616 Mtetra
.969 .909 .699 r
.62127 .5616 .6245 .55656 .62727 .5493 .62404 .55432 Mtetra
.968 .925 .695 r
.62404 .55432 .62727 .5493 .63004 .54238 .62682 .54738 Mtetra
.951 .954 .674 r
.62682 .54738 .63004 .54238 .63283 .53615 .62962 .54115 Mtetra
.837 .94 .574 r
.62962 .54115 .63283 .53615 .63565 .53094 .63243 .53593 Mtetra
0 0 0 r
.63243 .53593 .63565 .53094 .63849 .52698 .63528 .53196 Mtetra
.116 0 .14 r
.63528 .53196 .63849 .52698 .64137 .5244 .63817 .52938 Mtetra
.39 .092 .333 r
.63817 .52938 .64137 .5244 .64429 .52322 .64109 .5282 Mtetra
.513 .228 .418 r
.64109 .5282 .64429 .52322 .64725 .52333 .64405 .52832 Mtetra
.572 .296 .458 r
.64405 .52832 .64725 .52333 .65025 .52448 .64705 .52948 Mtetra
.6 .328 .477 r
.64705 .52948 .65025 .52448 .65327 .5263 .65007 .53131 Mtetra
.607 .337 .481 r
.65007 .53131 .65327 .5263 .6563 .52833 .6531 .53335 Mtetra
.596 .324 .474 r
.6531 .53335 .6563 .52833 .65933 .53006 .65613 .53509 Mtetra
.562 .284 .451 r
.65613 .53509 .65933 .53006 .66235 .531 .65915 .53604 Mtetra
.486 .198 .4 r
.65915 .53604 .66235 .531 .66534 .53075 .66214 .53579 Mtetra
.321 .019 .287 r
.66214 .53579 .66534 .53075 .66829 .52907 .6651 .53411 Mtetra
0 0 .042 r
.6651 .53411 .66829 .52907 .6712 .52596 .66801 .531 Mtetra
0 0 0 r
.66801 .531 .6712 .52596 .67408 .52171 .6709 .52674 Mtetra
.702 .866 .459 r
.6709 .52674 .67408 .52171 .67694 .51687 .67376 .52189 Mtetra
.648 .831 .417 r
.67376 .52189 .67694 .51687 .67981 .51219 .67664 .51721 Mtetra
0 0 0 r
.67664 .51721 .67981 .51219 .68272 .50845 .67954 .51346 Mtetra
.208 0 .207 r
.67954 .51346 .68272 .50845 .68567 .50617 .6825 .51118 Mtetra
.429 .134 .36 r
.6825 .51118 .68567 .50617 .68867 .5053 .6855 .51032 Mtetra
.474 .183 .391 r
.6855 .51032 .68867 .5053 .69169 .5049 .68853 .50992 Mtetra
.334 .032 .295 r
.68853 .50992 .69169 .5049 .69468 .50329 .69152 .50831 Mtetra
.063 0 .106 r
.69152 .50831 .69468 .50329 .69763 .50043 .69447 .50545 Mtetra
.334 .032 .295 r
.69447 .50545 .69763 .50043 .70062 .49881 .69747 .50383 Mtetra
.473 .182 .39 r
.69747 .50383 .70062 .49881 .70367 .4984 .70051 .50342 Mtetra
.429 .134 .36 r
.70051 .50342 .70367 .4984 .7067 .49753 .70355 .50255 Mtetra
.21 0 .21 r
.70355 .50255 .7067 .49753 .70969 .49523 .70654 .50025 Mtetra
0 0 0 r
.70654 .50025 .70969 .49523 .71262 .49145 .70947 .49647 Mtetra
.631 .817 .399 r
.70947 .49647 .71262 .49145 .71552 .48673 .71238 .49174 Mtetra
.685 .853 .441 r
.71238 .49174 .71552 .48673 .71841 .48185 .71527 .48685 Mtetra
0 0 0 r
.71527 .48685 .71841 .48185 .72133 .47755 .7182 .48254 Mtetra
0 0 .044 r
.7182 .48254 .72133 .47755 .72429 .47438 .72116 .47938 Mtetra
.316 .013 .282 r
.72116 .47938 .72429 .47438 .72732 .47264 .72419 .47764 Mtetra
.481 .19 .394 r
.72419 .47764 .72732 .47264 .73041 .47233 .72728 .47733 Mtetra
.558 .276 .444 r
.72728 .47733 .73041 .47233 .73355 .47322 .73043 .47823 Mtetra
.592 .317 .467 r
.73043 .47823 .73355 .47322 .73673 .47491 .73361 .47992 Mtetra
.603 .329 .475 r
.73361 .47992 .73673 .47491 .73994 .47691 .73682 .48193 Mtetra
.596 .321 .47 r
.73682 .48193 .73994 .47691 .74315 .4787 .74003 .48374 Mtetra
.568 .289 .452 r
.74003 .48374 .74315 .4787 .74633 .47983 .74322 .48487 Mtetra
.51 .222 .413 r
.74322 .48487 .74633 .47983 .74948 .4799 .74637 .48495 Mtetra
.39 .091 .333 r
.74637 .48495 .74948 .4799 .75257 .47865 .74946 .4837 Mtetra
.136 0 .16 r
.74946 .4837 .75257 .47865 .75561 .47596 .7525 .48101 Mtetra
0 0 0 r
.7525 .48101 .75561 .47596 .75858 .47186 .75547 .4769 Mtetra
.781 .905 .508 r
.75547 .4769 .75858 .47186 .76149 .46647 .75839 .47151 Mtetra
.934 .954 .635 r
.75839 .47151 .76149 .46647 .76436 .46006 .76127 .46509 Mtetra
.967 .937 .669 r
.76127 .46509 .76436 .46006 .76719 .45294 .7641 .45795 Mtetra
.972 .923 .677 r
.7641 .45795 .76719 .45294 .77001 .44548 .76692 .45047 Mtetra
.972 .925 .676 r
.76692 .45047 .77001 .44548 .77282 .43806 .76974 .44304 Mtetra
.964 .94 .666 r
.76974 .44304 .77282 .43806 .77565 .43104 .77258 .43601 Mtetra
.923 .955 .626 r
.77258 .43601 .77565 .43104 .77852 .42478 .77546 .42974 Mtetra
.752 .89 .486 r
.77546 .42974 .77852 .42478 .78144 .41953 .77838 .42448 Mtetra
0 0 0 r
.77838 .42448 .78144 .41953 .78443 .4155 .78137 .42045 Mtetra
.138 0 .157 r
.78137 .42045 .78443 .4155 .78748 .41284 .78443 .41778 Mtetra
.388 .087 .328 r
.78443 .41778 .78748 .41284 .79062 .41159 .78756 .41653 Mtetra
.513 .223 .411 r
.78756 .41653 .79062 .41159 .79383 .41172 .79078 .41667 Mtetra
.58 .3 .455 r
.79078 .41667 .79383 .41172 .79711 .41314 .79407 .4181 Mtetra
.619 .345 .48 r
.79407 .4181 .79711 .41314 .80047 .41569 .79742 .42066 Mtetra
.643 .373 .495 r
.79742 .42066 .80047 .41569 .80388 .41914 .80084 .42413 Mtetra
.656 .389 .504 r
.80084 .42413 .80388 .41914 .80734 .42325 .8043 .42825 Mtetra
.663 .397 .508 r
.8043 .42825 .80734 .42325 .81083 .42772 .80779 .43274 Mtetra
.663 .398 .508 r
.80779 .43274 .81083 .42772 .81434 .43225 .8113 .43728 Mtetra
.659 .392 .505 r
.8113 .43728 .81434 .43225 .81785 .43653 .8148 .44158 Mtetra
.648 .379 .499 r
.8148 .44158 .81785 .43653 .82133 .44028 .81829 .44535 Mtetra
.629 .357 .487 r
.81829 .44535 .82133 .44028 .82479 .44324 .82175 .44832 Mtetra
.598 .32 .467 r
.82175 .44832 .82479 .44324 .82819 .44516 .82515 .45026 Mtetra
.546 .261 .434 r
.82515 .45026 .82819 .44516 .83153 .44588 .82849 .45097 Mtetra
.456 .162 .376 r
.82849 .45097 .83153 .44588 .8348 .44524 .83176 .45034 Mtetra
.286 0 .265 r
.83176 .45034 .8348 .44524 .83798 .44318 .83495 .44828 Mtetra
0 0 .036 r
.83495 .44828 .83798 .44318 .84109 .43967 .83806 .44477 Mtetra
0 0 0 r
.83806 .44477 .84109 .43967 .84411 .43475 .84109 .43984 Mtetra
.88 .94 .572 r
.84109 .43984 .84411 .43475 .84705 .4285 .84404 .43358 Mtetra
.967 .936 .652 r
.84404 .43358 .84705 .4285 .84992 .42107 .84691 .42613 Mtetra
.978 .899 .671 r
.84691 .42613 .84992 .42107 .85272 .41262 .84972 .41767 Mtetra
.973 .869 .674 r
.84972 .41767 .85272 .41262 .85547 .40337 .85247 .4084 Mtetra
.967 .849 .673 r
.85247 .4084 .85547 .40337 .85817 .39355 .85518 .39856 Mtetra
.963 .838 .672 r
.85518 .39856 .85817 .39355 .86085 .38341 .85787 .38839 Mtetra
.962 .836 .672 r
.85787 .38839 .86085 .38341 .86353 .3732 .86055 .37816 Mtetra
.964 .841 .672 r
.86055 .37816 .86353 .3732 .86621 .36317 .86324 .36812 Mtetra
.969 .854 .673 r
.86324 .36812 .86621 .36317 .86891 .35358 .86595 .3585 Mtetra
.975 .877 .674 r
.86595 .3585 .86891 .35358 .87165 .34463 .86869 .34954 Mtetra
.977 .91 .669 r
.86869 .34954 .87165 .34463 .87445 .33654 .8715 .34143 Mtetra
.957 .944 .643 r
.8715 .34143 .87445 .33654 .87731 .32947 .87437 .33435 Mtetra
.839 .927 .543 r
.87437 .33435 .87731 .32947 .88026 .32358 .87732 .32844 Mtetra
0 0 0 r
.87732 .32844 .88026 .32358 .88329 .31896 .88035 .32382 Mtetra
.003 0 .065 r
.88035 .32382 .88329 .31896 .88642 .31571 .88349 .32056 Mtetra
.308 .001 .271 r
.88349 .32056 .88642 .31571 .88965 .31384 .88672 .3187 Mtetra
.467 .169 .375 r
.88672 .3187 .88965 .31384 .89299 .31337 .89006 .31824 Mtetra
.554 .266 .431 r
.89006 .31824 .89299 .31337 .89643 .31427 .89351 .31914 Mtetra
.606 .325 .464 r
.89351 .31914 .89643 .31427 .89997 .31646 .89705 .32134 Mtetra
.64 .364 .485 r
.89705 .32134 .89997 .31646 .90361 .31985 .9007 .32475 Mtetra
.662 .39 .499 r
.9007 .32475 .90361 .31985 .90735 .32431 .90443 .32922 Mtetra
.677 .408 .508 r
.90443 .32922 .90735 .32431 .91116 .32969 .90824 .33462 Mtetra
.687 .42 .514 r
.90824 .33462 .91116 .32969 .91504 .33582 .91213 .34077 Mtetra
.693 .428 .518 r
.91213 .34077 .91504 .33582 .91898 .34249 .91607 .34747 Mtetra
.697 .433 .52 r
.91607 .34747 .91898 .34249 .92296 .34951 .92005 .35451 Mtetra
.698 .434 .521 r
.92005 .35451 .92296 .34951 .92697 .35666 .92406 .36169 Mtetra
.696 .432 .52 r
.92406 .36169 .92697 .35666 .93099 .36372 .92807 .36877 Mtetra
.695 .457 .559 r
.47806 .63678 .48142 .63117 .4841 .63814 .48074 .64377 Mtetra
.696 .458 .559 r
.48074 .64377 .4841 .63814 .48679 .64525 .48343 .6509 Mtetra
.695 .457 .559 r
.48343 .6509 .48679 .64525 .4895 .6523 .48614 .65797 Mtetra
.692 .453 .557 r
.48614 .65797 .4895 .6523 .49222 .65907 .48885 .66477 Mtetra
.687 .446 .553 r
.48885 .66477 .49222 .65907 .49495 .66536 .49158 .67108 Mtetra
.678 .436 .548 r
.49158 .67108 .49495 .66536 .49769 .67098 .49432 .67672 Mtetra
.666 .421 .541 r
.49432 .67672 .49769 .67098 .50044 .67573 .49707 .68149 Mtetra
.647 .399 .529 r
.49707 .68149 .50044 .67573 .5032 .67944 .49983 .68522 Mtetra
.62 .367 .512 r
.49983 .68522 .5032 .67944 .50596 .68199 .50259 .68778 Mtetra
.577 .317 .485 r
.50259 .68778 .50596 .68199 .50873 .68326 .50536 .68906 Mtetra
.505 .235 .439 r
.50536 .68906 .50873 .68326 .5115 .68316 .50814 .68897 Mtetra
.372 .091 .352 r
.50814 .68897 .5115 .68316 .51428 .68167 .51091 .68748 Mtetra
.1 0 .168 r
.51091 .68748 .51428 .68167 .51705 .67878 .51369 .68458 Mtetra
0 0 0 r
.51369 .68458 .51705 .67878 .51982 .67452 .51646 .68032 Mtetra
.835 .924 .537 r
.51646 .68032 .51982 .67452 .52258 .66898 .51923 .67477 Mtetra
.96 .944 .66 r
.51923 .67477 .52258 .66898 .52534 .66227 .52199 .66804 Mtetra
.973 .902 .687 r
.52199 .66804 .52534 .66227 .52809 .65455 .52475 .66031 Mtetra
.965 .866 .691 r
.52475 .66031 .52809 .65455 .53084 .64599 .5275 .65173 Mtetra
.956 .842 .691 r
.5275 .65173 .53084 .64599 .53357 .63681 .53025 .64253 Mtetra
.949 .828 .689 r
.53025 .64253 .53357 .63681 .53631 .62724 .53299 .63294 Mtetra
.947 .822 .689 r
.53299 .63294 .53631 .62724 .53903 .61751 .53572 .62319 Mtetra
.948 .825 .689 r
.53572 .62319 .53903 .61751 .54176 .60788 .53845 .61354 Mtetra
.953 .836 .69 r
.53845 .61354 .54176 .60788 .54448 .59859 .54118 .60422 Mtetra
.961 .857 .692 r
.54118 .60422 .54448 .59859 .5472 .58986 .54391 .59548 Mtetra
.971 .89 .69 r
.54391 .59548 .5472 .58986 .54993 .58193 .54665 .58753 Mtetra
.969 .933 .674 r
.54665 .58753 .54993 .58193 .55267 .57497 .54939 .58056 Mtetra
.895 .948 .594 r
.54939 .58056 .55267 .57497 .55542 .56915 .55214 .57474 Mtetra
0 0 0 r
.55214 .57474 .55542 .56915 .55818 .5646 .5549 .57017 Mtetra
0 0 .08 r
.5549 .57017 .55818 .5646 .56095 .56138 .55768 .56695 Mtetra
.314 .027 .308 r
.55768 .56695 .56095 .56138 .56375 .55953 .56048 .5651 Mtetra
.473 .196 .413 r
.56048 .5651 .56375 .55953 .56656 .55904 .5633 .56461 Mtetra
.555 .288 .466 r
.5633 .56461 .56656 .55904 .5694 .55983 .56613 .56541 Mtetra
.602 .342 .496 r
.56613 .56541 .5694 .55983 .57226 .56179 .56899 .56738 Mtetra
.631 .375 .513 r
.56899 .56738 .57226 .56179 .57514 .56475 .57187 .57035 Mtetra
.648 .396 .524 r
.57187 .57035 .57514 .56475 .57803 .5685 .57477 .57412 Mtetra
.658 .408 .53 r
.57477 .57412 .57803 .5685 .58095 .57279 .57769 .57843 Mtetra
.662 .413 .533 r
.57769 .57843 .58095 .57279 .58388 .57735 .58062 .58301 Mtetra
.661 .412 .532 r
.58062 .58301 .58388 .57735 .58682 .58188 .58355 .58756 Mtetra
.655 .405 .529 r
.58355 .58756 .58682 .58188 .58976 .58609 .5865 .59178 Mtetra
.643 .391 .521 r
.5865 .59178 .58976 .58609 .59271 .58968 .58944 .59538 Mtetra
.622 .366 .509 r
.58944 .59538 .59271 .58968 .59564 .59238 .59238 .5981 Mtetra
.588 .326 .487 r
.59238 .5981 .59564 .59238 .59857 .59398 .59531 .59971 Mtetra
.529 .26 .451 r
.59531 .59971 .59857 .59398 .60148 .5943 .59822 .60004 Mtetra
.424 .145 .383 r
.59822 .60004 .60148 .5943 .60437 .59323 .60111 .59897 Mtetra
.217 0 .247 r
.60111 .59897 .60437 .59323 .60724 .59074 .60399 .59648 Mtetra
0 0 0 r
.60399 .59648 .60724 .59074 .61008 .58688 .60683 .59262 Mtetra
.652 .813 .378 r
.60683 .59262 .61008 .58688 .61291 .58179 .60966 .58752 Mtetra
.89 .941 .576 r
.60966 .58752 .61291 .58179 .61571 .57569 .61247 .5814 Mtetra
.955 .945 .641 r
.61247 .5814 .61571 .57569 .61849 .56884 .61526 .57454 Mtetra
.969 .933 .66 r
.61526 .57454 .61849 .56884 .62127 .5616 .61804 .56728 Mtetra
.97 .932 .661 r
.61804 .56728 .62127 .5616 .62404 .55432 .62082 .55999 Mtetra
.96 .943 .647 r
.62082 .55999 .62404 .55432 .62682 .54738 .6236 .55304 Mtetra
.908 .946 .593 r
.6236 .55304 .62682 .54738 .62962 .54115 .6264 .5468 Mtetra
.7 .844 .416 r
.6264 .5468 .62962 .54115 .63243 .53593 .62922 .54157 Mtetra
0 0 0 r
.62922 .54157 .63243 .53593 .63528 .53196 .63208 .53759 Mtetra
.195 0 .23 r
.63208 .53759 .63528 .53196 .63817 .52938 .63497 .53501 Mtetra
.412 .13 .373 r
.63497 .53501 .63817 .52938 .64109 .5282 .63789 .53384 Mtetra
.517 .244 .44 r
.63789 .53384 .64109 .5282 .64405 .52832 .64086 .53396 Mtetra
.57 .303 .473 r
.64086 .53396 .64405 .52832 .64705 .52948 .64385 .53512 Mtetra
.595 .332 .488 r
.64385 .53512 .64705 .52948 .65007 .53131 .64687 .53697 Mtetra
.602 .34 .492 r
.64687 .53697 .65007 .53131 .6531 .53335 .64991 .53902 Mtetra
.592 .328 .486 r
.64991 .53902 .6531 .53335 .65613 .53509 .65294 .54077 Mtetra
.56 .293 .467 r
.65294 .54077 .65613 .53509 .65915 .53604 .65596 .54173 Mtetra
.493 .218 .425 r
.65596 .54173 .65915 .53604 .66214 .53579 .65895 .54148 Mtetra
.356 .072 .338 r
.65895 .54148 .66214 .53579 .6651 .53411 .66191 .5398 Mtetra
.086 0 .159 r
.66191 .5398 .6651 .53411 .66801 .531 .66483 .53669 Mtetra
0 0 0 r
.66483 .53669 .66801 .531 .6709 .52674 .66772 .53242 Mtetra
.66772 .53242 .6709 .52674 .67376 .52189 .67059 .52757 Mtetra
.67059 .52757 .67376 .52189 .67664 .51721 .67347 .52288 Mtetra
0 0 .028 r
.67347 .52288 .67664 .51721 .67954 .51346 .67638 .51912 Mtetra
.266 0 .279 r
.67638 .51912 .67954 .51346 .6825 .51118 .67934 .51684 Mtetra
.444 .165 .393 r
.67934 .51684 .6825 .51118 .6855 .51032 .68235 .51598 Mtetra
.482 .206 .417 r
.68235 .51598 .6855 .51032 .68853 .50992 .68537 .51559 Mtetra
.366 .082 .343 r
.68537 .51559 .68853 .50992 .69152 .50831 .68837 .51398 Mtetra
.154 0 .205 r
.68837 .51398 .69152 .50831 .69447 .50545 .69132 .51112 Mtetra
.365 .082 .343 r
.69132 .51112 .69447 .50545 .69747 .50383 .69432 .5095 Mtetra
.482 .205 .417 r
.69432 .5095 .69747 .50383 .70051 .50342 .69737 .5091 Mtetra
.444 .164 .393 r
.69737 .5091 .70051 .50342 .70355 .50255 .70041 .50823 Mtetra
.268 0 .28 r
.70041 .50823 .70355 .50255 .70654 .50025 .7034 .50593 Mtetra
0 0 .038 r
.7034 .50593 .70654 .50025 .70947 .49647 .70634 .50215 Mtetra
0 0 0 r
.70634 .50215 .70947 .49647 .71238 .49174 .70925 .49741 Mtetra
.70925 .49741 .71238 .49174 .71527 .48685 .71215 .49251 Mtetra
.71215 .49251 .71527 .48685 .7182 .48254 .71508 .4882 Mtetra
.087 0 .161 r
.71508 .4882 .7182 .48254 .72116 .47938 .71805 .48503 Mtetra
.352 .067 .334 r
.71805 .48503 .72116 .47938 .72419 .47764 .72108 .48329 Mtetra
.489 .212 .42 r
.72108 .48329 .72419 .47764 .72728 .47733 .72418 .48299 Mtetra
.556 .286 .461 r
.72418 .48299 .72728 .47733 .73043 .47823 .72732 .48389 Mtetra
.588 .322 .48 r
.72732 .48389 .73043 .47823 .73361 .47992 .73051 .4856 Mtetra
.599 .334 .486 r
.73051 .4856 .73361 .47992 .73682 .48193 .73372 .48762 Mtetra
.592 .326 .482 r
.73372 .48762 .73682 .48193 .74003 .48374 .73693 .48944 Mtetra
.566 .297 .467 r
.73693 .48944 .74003 .48374 .74322 .48487 .74012 .49058 Mtetra
.513 .239 .435 r
.74012 .49058 .74322 .48487 .74637 .48495 .74327 .49066 Mtetra
.412 .13 .373 r
.74327 .49066 .74637 .48495 .74946 .4837 .74637 .48942 Mtetra
.21 0 .244 r
.74637 .48942 .74946 .4837 .7525 .48101 .74941 .48673 Mtetra
0 0 0 r
.74941 .48673 .7525 .48101 .75547 .4769 .75239 .48261 Mtetra
.75239 .48261 .75547 .4769 .75839 .47151 .75531 .47721 Mtetra
.865 .923 .531 r
.75531 .47721 .75839 .47151 .76127 .46509 .75819 .47077 Mtetra
.941 .941 .602 r
.75819 .47077 .76127 .46509 .7641 .45795 .76104 .46362 Mtetra
.961 .937 .623 r
.76104 .46362 .7641 .45795 .76692 .45047 .76386 .45613 Mtetra
.959 .937 .622 r
.76386 .45613 .76692 .45047 .76974 .44304 .76669 .44868 Mtetra
.934 .941 .595 r
.76669 .44868 .76974 .44304 .77258 .43601 .76953 .44164 Mtetra
.843 .914 .513 r
.76953 .44164 .77258 .43601 .77546 .42974 .77241 .43535 Mtetra
0 0 0 r
.77241 .43535 .77546 .42974 .77838 .42448 .77534 .43008 Mtetra
0 0 .006 r
.77534 .43008 .77838 .42448 .78137 .42045 .77834 .42605 Mtetra
.212 0 .242 r
.77834 .42605 .78137 .42045 .78443 .41778 .7814 .42338 Mtetra
.41 .126 .368 r
.7814 .42338 .78443 .41778 .78756 .41653 .78454 .42213 Mtetra
.517 .24 .434 r
.78454 .42213 .78756 .41653 .79078 .41667 .78775 .42228 Mtetra
.577 .307 .47 r
.78775 .42228 .79078 .41667 .79407 .4181 .79104 .42372 Mtetra
.614 .348 .491 r
.79104 .42372 .79407 .4181 .79742 .42066 .7944 .42629 Mtetra
.636 .374 .504 r
.7944 .42629 .79742 .42066 .80084 .42413 .79782 .42978 Mtetra
.649 .389 .512 r
.79782 .42978 .80084 .42413 .8043 .42825 .80128 .43392 Mtetra
.656 .396 .515 r
.80128 .43392 .8043 .42825 .80779 .43274 .80477 .43842 Mtetra
.656 .397 .516 r
.80477 .43842 .80779 .43274 .8113 .43728 .80828 .44298 Mtetra
.652 .392 .513 r
.80828 .44298 .8113 .43728 .8148 .44158 .81179 .44731 Mtetra
.641 .38 .507 r
.81179 .44731 .8148 .44158 .81829 .44535 .81528 .45109 Mtetra
.623 .359 .497 r
.81528 .45109 .81829 .44535 .82175 .44832 .81873 .45407 Mtetra
.593 .325 .48 r
.81873 .45407 .82175 .44832 .82515 .45026 .82214 .45602 Mtetra
.546 .273 .453 r
.82214 .45602 .82515 .45026 .82849 .45097 .82548 .45675 Mtetra
.467 .188 .406 r
.82548 .45675 .82849 .45097 .83176 .45034 .82876 .45612 Mtetra
.327 .044 .321 r
.82876 .45612 .83176 .45034 .83495 .44828 .83195 .45406 Mtetra
.066 0 .155 r
.83195 .45406 .83495 .44828 .83806 .44477 .83507 .45054 Mtetra
0 0 0 r
.83507 .45054 .83806 .44477 .84109 .43984 .8381 .4456 Mtetra
.763 .864 .431 r
.8381 .4456 .84109 .43984 .84404 .43358 .84105 .43933 Mtetra
.934 .934 .578 r
.84105 .43933 .84404 .43358 .84691 .42613 .84393 .43187 Mtetra
.978 .919 .629 r
.84393 .43187 .84691 .42613 .84972 .41767 .84674 .42339 Mtetra
.984 .893 .646 r
.84674 .42339 .84972 .41767 .85247 .4084 .8495 .4141 Mtetra
.982 .874 .652 r
.8495 .4141 .85247 .4084 .85518 .39856 .85222 .40423 Mtetra
.979 .863 .653 r
.85222 .40423 .85518 .39856 .85787 .38839 .85492 .39405 Mtetra
.978 .86 .654 r
.85492 .39405 .85787 .38839 .86055 .37816 .8576 .38379 Mtetra
.98 .866 .653 r
.8576 .38379 .86055 .37816 .86324 .36812 .8603 .37373 Mtetra
.982 .879 .651 r
.8603 .37373 .86324 .36812 .86595 .3585 .86301 .36409 Mtetra
.984 .901 .643 r
.86301 .36409 .86595 .3585 .86869 .34954 .86577 .3551 Mtetra
.972 .926 .621 r
.86577 .3551 .86869 .34954 .8715 .34143 .86858 .34697 Mtetra
.91 .931 .557 r
.86858 .34697 .8715 .34143 .87437 .33435 .87145 .33988 Mtetra
.7 .829 .386 r
.87145 .33988 .87437 .33435 .87732 .32844 .87441 .33397 Mtetra
0 0 0 r
.87441 .33397 .87732 .32844 .88035 .32382 .87745 .32934 Mtetra
.108 0 .176 r
.87745 .32934 .88035 .32382 .88349 .32056 .88059 .32608 Mtetra
.345 .058 .325 r
.88059 .32608 .88349 .32056 .88672 .3187 .88383 .32421 Mtetra
.477 .194 .405 r
.88383 .32421 .88672 .3187 .89006 .31824 .88717 .32375 Mtetra
.554 .277 .45 r
.88717 .32375 .89006 .31824 .89351 .31914 .89062 .32467 Mtetra
.602 .33 .477 r
.89062 .32467 .89351 .31914 .89705 .32134 .89417 .32688 Mtetra
.633 .365 .495 r
.89417 .32688 .89705 .32134 .9007 .32475 .89781 .3303 Mtetra
.654 .39 .507 r
.89781 .3303 .9007 .32475 .90443 .32922 .90155 .3348 Mtetra
.669 .407 .515 r
.90155 .3348 .90443 .32922 .90824 .33462 .90536 .34022 Mtetra
.679 .419 .52 r
.90536 .34022 .90824 .33462 .91213 .34077 .90925 .34639 Mtetra
.686 .426 .524 r
.90925 .34639 .91213 .34077 .91607 .34747 .91319 .35311 Mtetra
.689 .43 .526 r
.91319 .35311 .91607 .34747 .92005 .35451 .91717 .36018 Mtetra
.69 .432 .526 r
.91717 .36018 .92005 .35451 .92406 .36169 .92118 .36738 Mtetra
.689 .43 .526 r
.92118 .36738 .92406 .36169 .92807 .36877 .9252 .3745 Mtetra
.691 .455 .56 r
.47469 .6428 .47806 .63678 .48074 .64377 .47737 .64981 Mtetra
.692 .456 .561 r
.47737 .64981 .48074 .64377 .48343 .6509 .48006 .65697 Mtetra
.691 .455 .561 r
.48006 .65697 .48343 .6509 .48614 .65797 .48276 .66407 Mtetra
.688 .451 .559 r
.48276 .66407 .48614 .65797 .48885 .66477 .48548 .67089 Mtetra
.682 .445 .556 r
.48548 .67089 .48885 .66477 .49158 .67108 .4882 .67723 Mtetra
.674 .435 .551 r
.4882 .67723 .49158 .67108 .49432 .67672 .49094 .68289 Mtetra
.662 .42 .543 r
.49094 .68289 .49432 .67672 .49707 .68149 .49369 .68768 Mtetra
.643 .398 .533 r
.49369 .68768 .49707 .68149 .49983 .68522 .49645 .69143 Mtetra
.616 .367 .517 r
.49645 .69143 .49983 .68522 .50259 .68778 .49921 .694 Mtetra
.575 .32 .492 r
.49921 .694 .50259 .68778 .50536 .68906 .50198 .69528 Mtetra
.507 .245 .451 r
.50198 .69528 .50536 .68906 .50814 .68897 .50476 .6952 Mtetra
.387 .116 .375 r
.50476 .6952 .50814 .68897 .51091 .68748 .50754 .69371 Mtetra
.151 0 .222 r
.50754 .69371 .51091 .68748 .51369 .68458 .51032 .69081 Mtetra
0 0 0 r
.51032 .69081 .51369 .68458 .51646 .68032 .51309 .68654 Mtetra
.756 .87 .445 r
.51309 .68654 .51646 .68032 .51923 .67477 .51587 .68098 Mtetra
.942 .945 .617 r
.51587 .68098 .51923 .67477 .52199 .66804 .51864 .67425 Mtetra
.976 .917 .667 r
.51864 .67425 .52199 .66804 .52475 .66031 .5214 .66649 Mtetra
.974 .883 .679 r
.5214 .66649 .52475 .66031 .5275 .65173 .52416 .6579 Mtetra
.966 .858 .682 r
.52416 .6579 .5275 .65173 .53025 .64253 .52691 .64868 Mtetra
.96 .843 .682 r
.52691 .64868 .53025 .64253 .53299 .63294 .52966 .63907 Mtetra
.958 .838 .682 r
.52966 .63907 .53299 .63294 .53572 .62319 .5324 .6293 Mtetra
.959 .84 .682 r
.5324 .6293 .53572 .62319 .53845 .61354 .53513 .61962 Mtetra
.964 .852 .682 r
.53513 .61962 .53845 .61354 .54118 .60422 .53787 .61029 Mtetra
.971 .873 .681 r
.53787 .61029 .54118 .60422 .54391 .59548 .54061 .60153 Mtetra
.977 .906 .673 r
.54061 .60153 .54391 .59548 .54665 .58753 .54335 .59356 Mtetra
.961 .941 .641 r
.54335 .59356 .54665 .58753 .54939 .58056 .5461 .58658 Mtetra
.838 .916 .519 r
.5461 .58658 .54939 .58056 .55214 .57474 .54885 .58074 Mtetra
0 0 0 r
.54885 .58074 .55214 .57474 .5549 .57017 .55162 .57617 Mtetra
.053 0 .149 r
.55162 .57617 .5549 .57017 .55768 .56695 .55441 .57294 Mtetra
.336 .06 .338 r
.55441 .57294 .55768 .56695 .56048 .5651 .55721 .5711 Mtetra
.478 .209 .428 r
.55721 .5711 .56048 .5651 .5633 .56461 .56003 .57061 Mtetra
.555 .293 .475 r
.56003 .57061 .5633 .56461 .56613 .56541 .56286 .57142 Mtetra
.599 .344 .502 r
.56286 .57142 .56613 .56541 .56899 .56738 .56572 .5734 Mtetra
.627 .376 .518 r
.56572 .5734 .56899 .56738 .57187 .57035 .5686 .57638 Mtetra
.644 .395 .528 r
.5686 .57638 .57187 .57035 .57477 .57412 .5715 .58017 Mtetra
.654 .407 .533 r
.5715 .58017 .57477 .57412 .57769 .57843 .57442 .58449 Mtetra
.658 .412 .536 r
.57442 .58449 .57769 .57843 .58062 .58301 .57735 .58909 Mtetra
.657 .411 .535 r
.57735 .58909 .58062 .58301 .58355 .58756 .58029 .59366 Mtetra
.651 .404 .532 r
.58029 .59366 .58355 .58756 .5865 .59178 .58323 .5979 Mtetra
.639 .39 .525 r
.58323 .5979 .5865 .59178 .58944 .59538 .58617 .60152 Mtetra
.619 .367 .513 r
.58617 .60152 .58944 .59538 .59238 .5981 .58911 .60426 Mtetra
.586 .329 .494 r
.58911 .60426 .59238 .5981 .59531 .59971 .59204 .60588 Mtetra
.53 .267 .461 r
.59204 .60588 .59531 .59971 .59822 .60004 .59495 .60621 Mtetra
.433 .163 .402 r
.59495 .60621 .59822 .60004 .60111 .59897 .59785 .60514 Mtetra
.252 0 .287 r
.59785 .60514 .60111 .59897 .60399 .59648 .60073 .60265 Mtetra
0 0 .063 r
.60073 .60265 .60399 .59648 .60683 .59262 .60358 .59878 Mtetra
0 0 0 r
.60358 .59878 .60683 .59262 .60966 .58752 .60641 .59368 Mtetra
.831 .906 .498 r
.60641 .59368 .60966 .58752 .61247 .5814 .60922 .58755 Mtetra
.931 .941 .593 r
.60922 .58755 .61247 .5814 .61526 .57454 .61202 .58068 Mtetra
.958 .939 .623 r
.61202 .58068 .61526 .57454 .61804 .56728 .61481 .5734 Mtetra
.96 .938 .625 r
.61481 .5734 .61804 .56728 .62082 .55999 .61759 .56609 Mtetra
.939 .941 .601 r
.61759 .56609 .62082 .55999 .6236 .55304 .62038 .55913 Mtetra
.856 .918 .521 r
.62038 .55913 .6236 .55304 .6264 .5468 .62319 .55287 Mtetra
0 0 0 r
.62319 .55287 .6264 .5468 .62922 .54157 .62601 .54763 Mtetra
0 0 .031 r
.62601 .54763 .62922 .54157 .63208 .53759 .62887 .54365 Mtetra
.233 0 .273 r
.62887 .54365 .63208 .53759 .63497 .53501 .63176 .54107 Mtetra
.422 .15 .393 r
.63176 .54107 .63497 .53501 .63789 .53384 .63469 .5399 Mtetra
.518 .252 .451 r
.63469 .5399 .63789 .53384 .64086 .53396 .63766 .54003 Mtetra
.568 .307 .481 r
.63766 .54003 .64086 .53396 .64385 .53512 .64066 .5412 Mtetra
.593 .335 .495 r
.64066 .5412 .64385 .53512 .64687 .53697 .64368 .54306 Mtetra
.599 .342 .499 r
.64368 .54306 .64687 .53697 .64991 .53902 .64671 .54512 Mtetra
.589 .331 .493 r
.64671 .54512 .64991 .53902 .65294 .54077 .64975 .54688 Mtetra
.559 .297 .475 r
.64975 .54688 .65294 .54077 .65596 .54173 .65277 .54785 Mtetra
.497 .229 .438 r
.65277 .54785 .65596 .54173 .65895 .54148 .65577 .54761 Mtetra
.372 .098 .363 r
.65577 .54761 .65895 .54148 .66191 .5398 .65873 .54593 Mtetra
.139 0 .215 r
.65873 .54593 .66191 .5398 .66483 .53669 .66165 .54281 Mtetra
0 0 0 r
.66165 .54281 .66483 .53669 .66772 .53242 .66455 .53854 Mtetra
.66455 .53854 .66772 .53242 .67059 .52757 .66742 .53368 Mtetra
.66742 .53368 .67059 .52757 .67347 .52288 .67031 .52898 Mtetra
0 0 .107 r
.67031 .52898 .67347 .52288 .67638 .51912 .67322 .52522 Mtetra
.294 .019 .313 r
.67322 .52522 .67638 .51912 .67934 .51684 .67618 .52294 Mtetra
.452 .181 .411 r
.67618 .52294 .67934 .51684 .68235 .51598 .67919 .52209 Mtetra
.487 .218 .431 r
.67919 .52209 .68235 .51598 .68537 .51559 .68222 .5217 Mtetra
.381 .107 .368 r
.68222 .5217 .68537 .51559 .68837 .51398 .68522 .52009 Mtetra
.198 0 .253 r
.68522 .52009 .68837 .51398 .69132 .51112 .68818 .51722 Mtetra
.381 .107 .368 r
.68818 .51722 .69132 .51112 .69432 .5095 .69118 .51561 Mtetra
.486 .217 .431 r
.69118 .51561 .69432 .5095 .69737 .5091 .69423 .51522 Mtetra
.452 .18 .41 r
.69423 .51522 .69737 .5091 .70041 .50823 .69727 .51435 Mtetra
.296 .02 .315 r
.69727 .51435 .70041 .50823 .7034 .50593 .70027 .51205 Mtetra
0 0 .115 r
.70027 .51205 .7034 .50593 .70634 .50215 .70321 .50826 Mtetra
0 0 0 r
.70321 .50826 .70634 .50215 .70925 .49741 .70613 .50351 Mtetra
.70613 .50351 .70925 .49741 .71215 .49251 .70903 .49861 Mtetra
0 0 .006 r
.70903 .49861 .71215 .49251 .71508 .4882 .71197 .49429 Mtetra
.141 0 .216 r
.71197 .49429 .71508 .4882 .71805 .48503 .71494 .49112 Mtetra
.369 .094 .359 r
.71494 .49112 .71805 .48503 .72108 .48329 .71798 .48938 Mtetra
.492 .223 .433 r
.71798 .48938 .72108 .48329 .72418 .48299 .72107 .48908 Mtetra
.556 .291 .47 r
.72107 .48908 .72418 .48299 .72732 .48389 .72422 .48999 Mtetra
.586 .325 .487 r
.72422 .48999 .72732 .48389 .73051 .4856 .72741 .49171 Mtetra
.596 .336 .493 r
.72741 .49171 .73051 .4856 .73372 .48762 .73062 .49375 Mtetra
.589 .329 .489 r
.73062 .49375 .73372 .48762 .73693 .48944 .73383 .49558 Mtetra
.565 .302 .476 r
.73383 .49558 .73693 .48944 .74012 .49058 .73703 .49673 Mtetra
.515 .248 .447 r
.73703 .49673 .74012 .49058 .74327 .49066 .74018 .49681 Mtetra
.422 .15 .393 r
.74018 .49681 .74327 .49066 .74637 .48942 .74328 .49557 Mtetra
.246 0 .285 r
.74328 .49557 .74637 .48942 .74941 .48673 .74633 .49288 Mtetra
0 0 .077 r
.74633 .49288 .74941 .48673 .75239 .48261 .74931 .48876 Mtetra
0 0 0 r
.74931 .48876 .75239 .48261 .75531 .47721 .75224 .48335 Mtetra
.793 .876 .444 r
.75224 .48335 .75531 .47721 .75819 .47077 .75513 .4769 Mtetra
.905 .926 .543 r
.75513 .4769 .75819 .47077 .76104 .46362 .75798 .46973 Mtetra
.937 .932 .575 r
.75798 .46973 .76104 .46362 .76386 .45613 .76081 .46222 Mtetra
.934 .932 .572 r
.76081 .46222 .76386 .45613 .76669 .44868 .76364 .45476 Mtetra
.893 .922 .532 r
.76364 .45476 .76669 .44868 .76953 .44164 .76649 .44771 Mtetra
.765 .86 .421 r
.76649 .44771 .76953 .44164 .77241 .43535 .76938 .4414 Mtetra
0 0 0 r
.76938 .4414 .77241 .43535 .77534 .43008 .77231 .43613 Mtetra
0 0 .088 r
.77231 .43613 .77534 .43008 .77834 .42605 .77531 .43209 Mtetra
.247 0 .283 r
.77531 .43209 .77834 .42605 .7814 .42338 .77838 .42942 Mtetra
.421 .146 .389 r
.77838 .42942 .7814 .42338 .78454 .42213 .78152 .42817 Mtetra
.518 .249 .446 r
.78152 .42817 .78454 .42213 .78775 .42228 .78474 .42832 Mtetra
.576 .311 .478 r
.78474 .42832 .78775 .42228 .79104 .42372 .78803 .42977 Mtetra
.611 .35 .497 r
.78803 .42977 .79104 .42372 .7944 .42629 .79139 .43236 Mtetra
.632 .374 .509 r
.79139 .43236 .7944 .42629 .79782 .42978 .79481 .43586 Mtetra
.645 .389 .516 r
.79481 .43586 .79782 .42978 .80128 .43392 .79827 .44002 Mtetra
.651 .396 .519 r
.79827 .44002 .80128 .43392 .80477 .43842 .80176 .44454 Mtetra
.652 .397 .52 r
.80176 .44454 .80477 .43842 .80828 .44298 .80527 .44913 Mtetra
.648 .391 .517 r
.80527 .44913 .80828 .44298 .81179 .44731 .80878 .45347 Mtetra
.637 .38 .512 r
.80878 .45347 .81179 .44731 .81528 .45109 .81227 .45727 Mtetra
.619 .36 .502 r
.81227 .45727 .81528 .45109 .81873 .45407 .81573 .46027 Mtetra
.591 .328 .487 r
.81573 .46027 .81873 .45407 .82214 .45602 .81914 .46223 Mtetra
.546 .279 .462 r
.81914 .46223 .82214 .45602 .82548 .45675 .82249 .46297 Mtetra
.473 .202 .421 r
.82249 .46297 .82548 .45675 .82876 .45612 .82577 .46234 Mtetra
.347 .074 .349 r
.82577 .46234 .82876 .45612 .83195 .45406 .82896 .46028 Mtetra
.122 0 .212 r
.82896 .46028 .83195 .45406 .83507 .45054 .83208 .45676 Mtetra
0 0 0 r
.83208 .45676 .83507 .45054 .8381 .4456 .83512 .45181 Mtetra
.665 .789 .327 r
.83512 .45181 .8381 .4456 .84105 .43933 .83808 .44553 Mtetra
.892 .914 .514 r
.83808 .44553 .84105 .43933 .84393 .43187 .84096 .43805 Mtetra
.967 .923 .592 r
.84096 .43805 .84393 .43187 .84674 .42339 .84378 .42955 Mtetra
.985 .905 .621 r
.84378 .42955 .84674 .42339 .8495 .4141 .84655 .42024 Mtetra
.987 .887 .633 r
.84655 .42024 .8495 .4141 .85222 .40423 .84928 .41035 Mtetra
.986 .877 .637 r
.84928 .41035 .85222 .40423 .85492 .39405 .85198 .40014 Mtetra
.985 .874 .638 r
.85198 .40014 .85492 .39405 .8576 .38379 .85467 .38986 Mtetra
.986 .88 .636 r
.85467 .38986 .8576 .38379 .8603 .37373 .85738 .37977 Mtetra
.987 .892 .63 r
.85738 .37977 .8603 .37373 .86301 .36409 .8601 .37011 Mtetra
.982 .911 .615 r
.8601 .37011 .86301 .36409 .86577 .3551 .86286 .3611 Mtetra
.955 .926 .578 r
.86286 .3611 .86577 .3551 .86858 .34697 .86568 .35296 Mtetra
.856 .9 .484 r
.86568 .35296 .86858 .34697 .87145 .33988 .86856 .34585 Mtetra
0 0 0 r
.86856 .34585 .87145 .33988 .87441 .33397 .87152 .33992 Mtetra
0 0 .01 r
.87152 .33992 .87441 .33397 .87745 .32934 .87457 .33529 Mtetra
.159 0 .228 r
.87457 .33529 .87745 .32934 .88059 .32608 .87771 .33202 Mtetra
.364 .086 .352 r
.87771 .33202 .88059 .32608 .88383 .32421 .88095 .33016 Mtetra
.482 .207 .42 r
.88095 .33016 .88383 .32421 .88717 .32375 .8843 .32971 Mtetra
.553 .283 .46 r
.8843 .32971 .88717 .32375 .89062 .32467 .88775 .33063 Mtetra
.599 .332 .484 r
.88775 .33063 .89062 .32467 .89417 .32688 .8913 .33286 Mtetra
.629 .366 .501 r
.8913 .33286 .89417 .32688 .89781 .3303 .89495 .33629 Mtetra
.65 .39 .512 r
.89495 .33629 .89781 .3303 .90155 .3348 .89868 .34081 Mtetra
.665 .406 .519 r
.89868 .34081 .90155 .3348 .90536 .34022 .9025 .34625 Mtetra
.675 .417 .524 r
.9025 .34625 .90536 .34022 .90925 .34639 .90639 .35245 Mtetra
.681 .425 .527 r
.90639 .35245 .90925 .34639 .91319 .35311 .91033 .3592 Mtetra
.685 .429 .529 r
.91033 .3592 .91319 .35311 .91717 .36018 .91431 .3663 Mtetra
.686 .43 .53 r
.91431 .3663 .91717 .36018 .92118 .36738 .91832 .37353 Mtetra
.685 .429 .529 r
.91832 .37353 .92118 .36738 .9252 .3745 .92234 .38067 Mtetra
.689 .454 .561 r
.47131 .64901 .47469 .6428 .47737 .64981 .47399 .65605 Mtetra
.69 .455 .562 r
.47399 .65605 .47737 .64981 .48006 .65697 .47668 .66324 Mtetra
.689 .454 .561 r
.47668 .66324 .48006 .65697 .48276 .66407 .47938 .67036 Mtetra
.686 .451 .56 r
.47938 .67036 .48276 .66407 .48548 .67089 .48209 .67721 Mtetra
.681 .444 .556 r
.48209 .67721 .48548 .67089 .4882 .67723 .48481 .68357 Mtetra
.672 .434 .552 r
.48481 .68357 .4882 .67723 .49094 .68289 .48755 .68925 Mtetra
.66 .419 .545 r
.48755 .68925 .49094 .68289 .49369 .68768 .49029 .69406 Mtetra
.642 .398 .534 r
.49029 .69406 .49369 .68768 .49645 .69143 .49305 .69782 Mtetra
.615 .367 .519 r
.49305 .69782 .49645 .69143 .49921 .694 .49582 .70041 Mtetra
.574 .321 .495 r
.49582 .70041 .49921 .694 .50198 .69528 .49859 .70171 Mtetra
.508 .248 .455 r
.49859 .70171 .50198 .69528 .50476 .6952 .50137 .70163 Mtetra
.392 .124 .384 r
.50137 .70163 .50476 .6952 .50754 .69371 .50415 .70014 Mtetra
.17 0 .241 r
.50415 .70014 .50754 .69371 .51032 .69081 .50693 .69724 Mtetra
0 0 0 r
.50693 .69724 .51032 .69081 .51309 .68654 .50971 .69296 Mtetra
.718 .842 .404 r
.50971 .69296 .51309 .68654 .51587 .68098 .51249 .68739 Mtetra
.931 .942 .596 r
.51249 .68739 .51587 .68098 .51864 .67425 .51527 .68065 Mtetra
.976 .922 .656 r
.51527 .68065 .51864 .67425 .5214 .66649 .51804 .67287 Mtetra
.977 .889 .673 r
.51804 .67287 .5214 .66649 .52416 .6579 .5208 .66426 Mtetra
.97 .864 .678 r
.5208 .66426 .52416 .6579 .52691 .64868 .52356 .65502 Mtetra
.965 .85 .679 r
.52356 .65502 .52691 .64868 .52966 .63907 .52631 .64539 Mtetra
.962 .844 .679 r
.52631 .64539 .52966 .63907 .5324 .6293 .52906 .63559 Mtetra
.963 .847 .679 r
.52906 .63559 .5324 .6293 .53513 .61962 .53181 .6259 Mtetra
.968 .858 .678 r
.53181 .6259 .53513 .61962 .53787 .61029 .53455 .61654 Mtetra
.974 .88 .676 r
.53455 .61654 .53787 .61029 .54061 .60153 .5373 .60776 Mtetra
.978 .911 .665 r
.5373 .60776 .54061 .60153 .54335 .59356 .54004 .59977 Mtetra
.954 .941 .624 r
.54004 .59977 .54335 .59356 .5461 .58658 .5428 .59278 Mtetra
.81 .897 .484 r
.5428 .59278 .5461 .58658 .54885 .58074 .54556 .58693 Mtetra
0 0 0 r
.54556 .58693 .54885 .58074 .55162 .57617 .54833 .58235 Mtetra
.077 0 .174 r
.54833 .58235 .55162 .57617 .55441 .57294 .55112 .57912 Mtetra
.344 .071 .348 r
.55112 .57912 .55441 .57294 .55721 .5711 .55392 .57727 Mtetra
.48 .214 .433 r
.55392 .57727 .55721 .5711 .56003 .57061 .55674 .57679 Mtetra
.554 .295 .478 r
.55674 .57679 .56003 .57061 .56286 .57142 .55958 .57761 Mtetra
.598 .345 .504 r
.55958 .57761 .56286 .57142 .56572 .5734 .56244 .5796 Mtetra
.625 .376 .52 r
.56244 .5796 .56572 .5734 .5686 .57638 .56533 .5826 Mtetra
.642 .395 .529 r
.56533 .5826 .5686 .57638 .5715 .58017 .56822 .5864 Mtetra
.652 .406 .535 r
.56822 .5864 .5715 .58017 .57442 .58449 .57114 .59075 Mtetra
.656 .411 .537 r
.57114 .59075 .57442 .58449 .57735 .58909 .57407 .59536 Mtetra
.57407 .59536 .57735 .58909 .58029 .59366 .57701 .59995 Mtetra
.65 .404 .533 r
.57701 .59995 .58029 .59366 .58323 .5979 .57995 .60421 Mtetra
.638 .39 .527 r
.57995 .60421 .58323 .5979 .58617 .60152 .58289 .60785 Mtetra
.618 .367 .515 r
.58289 .60785 .58617 .60152 .58911 .60426 .58583 .6106 Mtetra
.585 .33 .496 r
.58583 .6106 .58911 .60426 .59204 .60588 .58876 .61223 Mtetra
.53 .27 .465 r
.58876 .61223 .59204 .60588 .59495 .60621 .59168 .61257 Mtetra
.437 .169 .409 r
.59168 .61257 .59495 .60621 .59785 .60514 .59458 .61151 Mtetra
.264 0 .302 r
.59458 .61151 .59785 .60514 .60073 .60265 .59746 .60901 Mtetra
0 0 .093 r
.59746 .60901 .60073 .60265 .60358 .59878 .60031 .60514 Mtetra
0 0 0 r
.60031 .60514 .60358 .59878 .60641 .59368 .60315 .60003 Mtetra
.8 .886 .462 r
.60315 .60003 .60641 .59368 .60922 .58755 .60597 .59389 Mtetra
.917 .935 .569 r
.60597 .59389 .60922 .58755 .61202 .58068 .60877 .587 Mtetra
.95 .938 .605 r
.60877 .587 .61202 .58068 .61481 .5734 .61156 .57971 Mtetra
.952 .937 .607 r
.61156 .57971 .61481 .5734 .61759 .56609 .61435 .57239 Mtetra
.927 .937 .579 r
.61435 .57239 .61759 .56609 .62038 .55913 .61715 .56541 Mtetra
.829 .901 .488 r
.61715 .56541 .62038 .55913 .62319 .55287 .61996 .55914 Mtetra
0 0 0 r
.61996 .55914 .62319 .55287 .62601 .54763 .62279 .55389 Mtetra
0 0 .064 r
.62279 .55389 .62601 .54763 .62887 .54365 .62566 .54991 Mtetra
.246 0 .288 r
.62566 .54991 .62887 .54365 .63176 .54107 .62855 .54732 Mtetra
.426 .157 .4 r
.62855 .54732 .63176 .54107 .63469 .5399 .63148 .54615 Mtetra
.519 .256 .455 r
.63148 .54615 .63469 .5399 .63766 .54003 .63445 .54629 Mtetra
.568 .309 .484 r
.63445 .54629 .63766 .54003 .64066 .5412 .63745 .54747 Mtetra
.592 .336 .497 r
.63745 .54747 .64066 .5412 .64368 .54306 .64048 .54934 Mtetra
.598 .343 .501 r
.64048 .54934 .64368 .54306 .64671 .54512 .64351 .55141 Mtetra
.589 .332 .496 r
.64351 .55141 .64671 .54512 .64975 .54688 .64655 .55319 Mtetra
.559 .299 .479 r
.64655 .55319 .64975 .54688 .65277 .54785 .64957 .55416 Mtetra
.498 .233 .443 r
.64957 .55416 .65277 .54785 .65577 .54761 .65257 .55393 Mtetra
.378 .108 .372 r
.65257 .55393 .65577 .54761 .65873 .54593 .65554 .55225 Mtetra
.158 0 .234 r
.65554 .55225 .65873 .54593 .66165 .54281 .65846 .54913 Mtetra
0 0 .03 r
.65846 .54913 .66165 .54281 .66455 .53854 .66136 .54486 Mtetra
0 0 0 r
.66136 .54486 .66455 .53854 .66742 .53368 .66424 .53998 Mtetra
.66424 .53998 .66742 .53368 .67031 .52898 .66713 .53528 Mtetra
.006 0 .134 r
.66713 .53528 .67031 .52898 .67322 .52522 .67005 .53151 Mtetra
.304 .032 .326 r
.67005 .53151 .67322 .52522 .67618 .52294 .67302 .52923 Mtetra
.455 .187 .417 r
.67302 .52923 .67618 .52294 .67919 .52209 .67603 .52838 Mtetra
.488 .222 .437 r
.67603 .52838 .67919 .52209 .68222 .5217 .67906 .528 Mtetra
.387 .116 .376 r
.67906 .528 .68222 .5217 .68522 .52009 .68206 .52639 Mtetra
.213 0 .269 r
.68206 .52639 .68522 .52009 .68818 .51722 .68503 .52352 Mtetra
.387 .116 .376 r
.68503 .52352 .68818 .51722 .69118 .51561 .68803 .52191 Mtetra
.488 .222 .436 r
.68803 .52191 .69118 .51561 .69423 .51522 .69109 .52152 Mtetra
.455 .186 .417 r
.69109 .52152 .69423 .51522 .69727 .51435 .69413 .52066 Mtetra
.306 .034 .327 r
.69413 .52066 .69727 .51435 .70027 .51205 .69713 .51836 Mtetra
.014 0 .142 r
.69713 .51836 .70027 .51205 .70321 .50826 .70008 .51456 Mtetra
0 0 0 r
.70008 .51456 .70321 .50826 .70613 .50351 .703 .50981 Mtetra
.703 .50981 .70613 .50351 .70903 .49861 .70591 .50489 Mtetra
0 0 .041 r
.70591 .50489 .70903 .49861 .71197 .49429 .70885 .50057 Mtetra
.16 0 .235 r
.70885 .50057 .71197 .49429 .71494 .49112 .71183 .49739 Mtetra
.375 .104 .369 r
.71183 .49739 .71494 .49112 .71798 .48938 .71487 .49566 Mtetra
.494 .227 .438 r
.71487 .49566 .71798 .48938 .72107 .48908 .71796 .49536 Mtetra
.555 .293 .474 r
.71796 .49536 .72107 .48908 .72422 .48999 .72112 .49628 Mtetra
.585 .326 .49 r
.72112 .49628 .72422 .48999 .72741 .49171 .72431 .49802 Mtetra
.595 .337 .496 r
.72431 .49802 .72741 .49171 .73062 .49375 .72752 .50006 Mtetra
.588 .33 .492 r
.72752 .50006 .73062 .49375 .73383 .49558 .73074 .50191 Mtetra
.565 .303 .479 r
.73074 .50191 .73383 .49558 .73703 .49673 .73393 .50307 Mtetra
.516 .251 .452 r
.73393 .50307 .73703 .49673 .74018 .49681 .73709 .50316 Mtetra
.426 .157 .4 r
.73709 .50316 .74018 .49681 .74328 .49557 .74019 .50192 Mtetra
.258 0 .299 r
.74019 .50192 .74328 .49557 .74633 .49288 .74324 .49923 Mtetra
0 0 .107 r
.74324 .49923 .74633 .49288 .74931 .48876 .74623 .4951 Mtetra
0 0 0 r
.74623 .4951 .74931 .48876 .75224 .48335 .74917 .48968 Mtetra
.759 .851 .406 r
.74917 .48968 .75224 .48335 .75513 .4769 .75206 .48322 Mtetra
.885 .915 .515 r
.75206 .48322 .75513 .4769 .75798 .46973 .75491 .47604 Mtetra
.923 .926 .551 r
.75491 .47604 .75798 .46973 .76081 .46222 .75775 .46851 Mtetra
.919 .925 .548 r
.75775 .46851 .76081 .46222 .76364 .45476 .76059 .46103 Mtetra
.871 .909 .502 r
.76059 .46103 .76364 .45476 .76649 .44771 .76345 .45396 Mtetra
.728 .832 .381 r
.76345 .45396 .76649 .44771 .76938 .4414 .76634 .44765 Mtetra
0 0 0 r
.76634 .44765 .76938 .4414 .77231 .43613 .76928 .44236 Mtetra
0 0 .117 r
.76928 .44236 .77231 .43613 .77531 .43209 .77228 .43832 Mtetra
.26 0 .298 r
.77228 .43832 .77531 .43209 .77838 .42942 .77535 .43564 Mtetra
.425 .154 .396 r
.77535 .43564 .77838 .42942 .78152 .42817 .7785 .4344 Mtetra
.519 .252 .45 r
.7785 .4344 .78152 .42817 .78474 .42832 .78172 .43456 Mtetra
.575 .312 .481 r
.78172 .43456 .78474 .42832 .78803 .42977 .78501 .43602 Mtetra
.609 .35 .5 r
.78501 .43602 .78803 .42977 .79139 .43236 .78837 .43862 Mtetra
.631 .374 .511 r
.78837 .43862 .79139 .43236 .79481 .43586 .79179 .44214 Mtetra
.644 .389 .518 r
.79179 .44214 .79481 .43586 .79827 .44002 .79526 .44632 Mtetra
.65 .396 .521 r
.79526 .44632 .79827 .44002 .80176 .44454 .79876 .45086 Mtetra
.651 .396 .521 r
.79876 .45086 .80176 .44454 .80527 .44913 .80227 .45547 Mtetra
.646 .391 .519 r
.80227 .45547 .80527 .44913 .80878 .45347 .80578 .45983 Mtetra
.636 .38 .514 r
.80578 .45983 .80878 .45347 .81227 .45727 .80927 .46365 Mtetra
.618 .36 .505 r
.80927 .46365 .81227 .45727 .81573 .46027 .81273 .46666 Mtetra
.59 .329 .49 r
.81273 .46666 .81573 .46027 .81914 .46223 .81614 .46864 Mtetra
.546 .282 .466 r
.81614 .46864 .81914 .46223 .82249 .46297 .81949 .46938 Mtetra
.475 .207 .427 r
.81949 .46938 .82249 .46297 .82577 .46234 .82277 .46876 Mtetra
.355 .084 .359 r
.82277 .46876 .82577 .46234 .82896 .46028 .82598 .4667 Mtetra
.142 0 .232 r
.82598 .4667 .82896 .46028 .83208 .45676 .8291 .46318 Mtetra
0 0 .006 r
.8291 .46318 .83208 .45676 .83512 .45181 .83214 .45822 Mtetra
0 0 0 r
.83214 .45822 .83512 .45181 .83808 .44553 .8351 .45193 Mtetra
.87 .9 .484 r
.8351 .45193 .83808 .44553 .84096 .43805 .838 .44443 Mtetra
.959 .922 .574 r
.838 .44443 .84096 .43805 .84378 .42955 .84082 .43591 Mtetra
.983 .908 .609 r
.84082 .43591 .84378 .42955 .84655 .42024 .8436 .42658 Mtetra
.988 .892 .623 r
.8436 .42658 .84655 .42024 .84928 .41035 .84633 .41667 Mtetra
.988 .882 .629 r
.84633 .41667 .84928 .41035 .85198 .40014 .84904 .40643 Mtetra
.988 .88 .63 r
.84904 .40643 .85198 .40014 .85467 .38986 .85174 .39613 Mtetra
.988 .885 .628 r
.85174 .39613 .85467 .38986 .85738 .37977 .85445 .38601 Mtetra
.987 .897 .62 r
.85445 .38601 .85738 .37977 .8601 .37011 .85718 .37633 Mtetra
.979 .913 .602 r
.85718 .37633 .8601 .37011 .86286 .3611 .85995 .3673 Mtetra
.944 .922 .557 r
.85995 .3673 .86286 .3611 .86568 .35296 .86278 .35914 Mtetra
.828 .882 .45 r
.86278 .35914 .86568 .35296 .86856 .34585 .86566 .35201 Mtetra
0 0 0 r
.86566 .35201 .86856 .34585 .87152 .33992 .86863 .34607 Mtetra
0 0 .044 r
.86863 .34607 .87152 .33992 .87457 .33529 .87168 .34143 Mtetra
.176 0 .247 r
.87168 .34143 .87457 .33529 .87771 .33202 .87483 .33816 Mtetra
.37 .096 .362 r
.87483 .33816 .87771 .33202 .88095 .33016 .87808 .3363 Mtetra
.484 .212 .426 r
.87808 .3363 .88095 .33016 .8843 .32971 .88143 .33585 Mtetra
.553 .285 .463 r
.88143 .33585 .8843 .32971 .88775 .33063 .88488 .33678 Mtetra
.598 .333 .487 r
.88488 .33678 .88775 .33063 .8913 .33286 .88844 .33902 Mtetra
.628 .366 .503 r
.88844 .33902 .8913 .33286 .89495 .33629 .89208 .34248 Mtetra
.649 .389 .513 r
.89208 .34248 .89495 .33629 .89868 .34081 .89582 .34702 Mtetra
.663 .406 .521 r
.89582 .34702 .89868 .34081 .9025 .34625 .89964 .35248 Mtetra
.673 .417 .526 r
.89964 .35248 .9025 .34625 .90639 .35245 .90353 .3587 Mtetra
.68 .424 .529 r
.90353 .3587 .90639 .35245 .91033 .3592 .90747 .36548 Mtetra
.683 .428 .531 r
.90747 .36548 .91033 .3592 .91431 .3663 .91146 .37261 Mtetra
.684 .43 .531 r
.91146 .37261 .91431 .3663 .91832 .37353 .91547 .37987 Mtetra
.683 .428 .53 r
.91547 .37987 .91832 .37353 .92234 .38067 .91949 .38704 Mtetra
.69 .454 .561 r
.46792 .65516 .47131 .64901 .47399 .65605 .47059 .66223 Mtetra
.691 .456 .561 r
.47059 .66223 .47399 .65605 .47668 .66324 .47328 .66944 Mtetra
.69 .455 .561 r
.47328 .66944 .47668 .66324 .47938 .67036 .47598 .67659 Mtetra
.687 .451 .559 r
.47598 .67659 .47938 .67036 .48209 .67721 .47868 .68346 Mtetra
.682 .444 .556 r
.47868 .68346 .48209 .67721 .48481 .68357 .48141 .68985 Mtetra
.673 .434 .551 r
.48141 .68985 .48481 .68357 .48755 .68925 .48414 .69555 Mtetra
.661 .419 .544 r
.48414 .69555 .48755 .68925 .49029 .69406 .48689 .70038 Mtetra
.643 .398 .534 r
.48689 .70038 .49029 .69406 .49305 .69782 .48964 .70416 Mtetra
.616 .367 .518 r
.48964 .70416 .49305 .69782 .49582 .70041 .49241 .70677 Mtetra
.575 .321 .494 r
.49241 .70677 .49582 .70041 .49859 .70171 .49519 .70807 Mtetra
.508 .246 .453 r
.49519 .70807 .49859 .70171 .50137 .70163 .49796 .708 Mtetra
.389 .12 .38 r
.49796 .708 .50137 .70163 .50415 .70014 .50075 .70651 Mtetra
.161 0 .232 r
.50075 .70651 .50415 .70014 .50693 .69724 .50353 .70361 Mtetra
0 0 0 r
.50353 .70361 .50693 .69724 .50971 .69296 .50632 .69933 Mtetra
.736 .856 .424 r
.50632 .69933 .50971 .69296 .51249 .68739 .5091 .69375 Mtetra
.937 .944 .606 r
.5091 .69375 .51249 .68739 .51527 .68065 .51188 .68698 Mtetra
.976 .92 .661 r
.51188 .68698 .51527 .68065 .51804 .67287 .51466 .6792 Mtetra
.975 .886 .676 r
.51466 .6792 .51804 .67287 .5208 .66426 .51743 .67057 Mtetra
.968 .861 .68 r
.51743 .67057 .5208 .66426 .52356 .65502 .5202 .6613 Mtetra
.963 .847 .68 r
.5202 .6613 .52356 .65502 .52631 .64539 .52296 .65165 Mtetra
.96 .841 .68 r
.52296 .65165 .52631 .64539 .52906 .63559 .52572 .64183 Mtetra
.961 .844 .68 r
.52572 .64183 .52906 .63559 .53181 .6259 .52847 .63211 Mtetra
.966 .855 .68 r
.52847 .63211 .53181 .6259 .53455 .61654 .53122 .62273 Mtetra
.973 .877 .678 r
.53122 .62273 .53455 .61654 .5373 .60776 .53397 .61393 Mtetra
.977 .909 .669 r
.53397 .61393 .5373 .60776 .54004 .59977 .53672 .60593 Mtetra
.957 .941 .633 r
.53672 .60593 .54004 .59977 .5428 .59278 .53948 .59892 Mtetra
.824 .907 .501 r
.53948 .59892 .5428 .59278 .54556 .58693 .54225 .59306 Mtetra
0 0 0 r
.54225 .59306 .54556 .58693 .54833 .58235 .54503 .58847 Mtetra
.065 0 .162 r
.54503 .58847 .54833 .58235 .55112 .57912 .54782 .58524 Mtetra
.34 .066 .343 r
.54782 .58524 .55112 .57912 .55392 .57727 .55062 .5834 Mtetra
.479 .212 .43 r
.55062 .5834 .55392 .57727 .55674 .57679 .55345 .58292 Mtetra
.554 .294 .476 r
.55345 .58292 .55674 .57679 .55958 .57761 .55629 .58375 Mtetra
.599 .344 .503 r
.55629 .58375 .55958 .57761 .56244 .5796 .55915 .58575 Mtetra
.626 .376 .519 r
.55915 .58575 .56244 .5796 .56533 .5826 .56203 .58877 Mtetra
.643 .395 .528 r
.56203 .58877 .56533 .5826 .56822 .5864 .56493 .59258 Mtetra
.653 .407 .534 r
.56493 .59258 .56822 .5864 .57114 .59075 .56785 .59695 Mtetra
.657 .412 .537 r
.56785 .59695 .57114 .59075 .57407 .59536 .57077 .60158 Mtetra
.656 .411 .536 r
.57077 .60158 .57407 .59536 .57701 .59995 .57371 .60619 Mtetra
.651 .404 .533 r
.57371 .60619 .57701 .59995 .57995 .60421 .57666 .61047 Mtetra
.639 .39 .526 r
.57666 .61047 .57995 .60421 .58289 .60785 .5796 .61412 Mtetra
.618 .367 .514 r
.5796 .61412 .58289 .60785 .58583 .6106 .58254 .61689 Mtetra
.585 .329 .495 r
.58254 .61689 .58583 .6106 .58876 .61223 .58547 .61853 Mtetra
.53 .269 .463 r
.58547 .61853 .58876 .61223 .59168 .61257 .58839 .61887 Mtetra
.435 .166 .406 r
.58839 .61887 .59168 .61257 .59458 .61151 .59129 .61781 Mtetra
.258 0 .295 r
.59129 .61781 .59458 .61151 .59746 .60901 .59417 .61532 Mtetra
0 0 .079 r
.59417 .61532 .59746 .60901 .60031 .60514 .59704 .61144 Mtetra
0 0 0 r
.59704 .61144 .60031 .60514 .60315 .60003 .59988 .60632 Mtetra
.815 .896 .48 r
.59988 .60632 .60315 .60003 .60597 .59389 .6027 .60017 Mtetra
.924 .938 .581 r
.6027 .60017 .60597 .59389 .60877 .587 .60551 .59327 Mtetra
.954 .938 .614 r
.60551 .59327 .60877 .587 .61156 .57971 .60831 .58596 Mtetra
.956 .938 .616 r
.60831 .58596 .61156 .57971 .61435 .57239 .61111 .57862 Mtetra
.933 .939 .59 r
.61111 .57862 .61435 .57239 .61715 .56541 .61391 .57163 Mtetra
.843 .91 .504 r
.61391 .57163 .61715 .56541 .61996 .55914 .61672 .56535 Mtetra
0 0 0 r
.61672 .56535 .61996 .55914 .62279 .55389 .61956 .56009 Mtetra
0 0 .049 r
.61956 .56009 .62279 .55389 .62566 .54991 .62243 .5561 Mtetra
.24 0 .281 r
.62243 .5561 .62566 .54991 .62855 .54732 .62533 .55351 Mtetra
.424 .154 .397 r
.62533 .55351 .62855 .54732 .63148 .54615 .62826 .55235 Mtetra
.519 .254 .453 r
.62826 .55235 .63148 .54615 .63445 .54629 .63123 .55249 Mtetra
.568 .308 .482 r
.63123 .55249 .63445 .54629 .63745 .54747 .63423 .55368 Mtetra
.592 .335 .496 r
.63423 .55368 .63745 .54747 .64048 .54934 .63726 .55556 Mtetra
.599 .342 .5 r
.63726 .55556 .64048 .54934 .64351 .55141 .6403 .55765 Mtetra
.589 .332 .494 r
.6403 .55765 .64351 .55141 .64655 .55319 .64334 .55944 Mtetra
.559 .298 .477 r
.64334 .55944 .64655 .55319 .64957 .55416 .64636 .56042 Mtetra
.497 .231 .441 r
.64636 .56042 .64957 .55416 .65257 .55393 .64936 .56019 Mtetra
.376 .103 .368 r
.64936 .56019 .65257 .55393 .65554 .55225 .65233 .55852 Mtetra
.149 0 .225 r
.65233 .55852 .65554 .55225 .65846 .54913 .65526 .55539 Mtetra
0 0 .013 r
.65526 .55539 .65846 .54913 .66136 .54486 .65817 .55111 Mtetra
0 0 0 r
.65817 .55111 .66136 .54486 .66424 .53998 .66105 .54623 Mtetra
.66105 .54623 .66424 .53998 .66713 .53528 .66395 .54151 Mtetra
0 0 .121 r
.66395 .54151 .66713 .53528 .67005 .53151 .66687 .53775 Mtetra
.3 .026 .32 r
.66687 .53775 .67005 .53151 .67302 .52923 .66984 .53547 Mtetra
.453 .184 .414 r
.66984 .53547 .67302 .52923 .67603 .52838 .67285 .53462 Mtetra
.488 .22 .434 r
.67285 .53462 .67603 .52838 .67906 .528 .67589 .53424 Mtetra
.384 .112 .372 r
.67589 .53424 .67906 .528 .68206 .52639 .67889 .53263 Mtetra
.206 0 .261 r
.67889 .53263 .68206 .52639 .68503 .52352 .68186 .52976 Mtetra
.384 .112 .372 r
.68186 .52976 .68503 .52352 .68803 .52191 .68487 .52815 Mtetra
.487 .219 .434 r
.68487 .52815 .68803 .52191 .69109 .52152 .68793 .52777 Mtetra
.453 .184 .414 r
.68793 .52777 .69109 .52152 .69413 .52066 .69098 .52691 Mtetra
.301 .028 .321 r
.69098 .52691 .69413 .52066 .69713 .51836 .69398 .52461 Mtetra
.001 0 .129 r
.69398 .52461 .69713 .51836 .70008 .51456 .69693 .52081 Mtetra
0 0 0 r
.69693 .52081 .70008 .51456 .703 .50981 .69985 .51605 Mtetra
.69985 .51605 .703 .50981 .70591 .50489 .70277 .51112 Mtetra
0 0 .024 r
.70277 .51112 .70591 .50489 .70885 .50057 .70571 .50679 Mtetra
.151 0 .226 r
.70571 .50679 .70885 .50057 .71183 .49739 .7087 .50361 Mtetra
.372 .099 .364 r
.7087 .50361 .71183 .49739 .71487 .49566 .71174 .50188 Mtetra
.493 .225 .436 r
.71174 .50188 .71487 .49566 .71796 .49536 .71484 .50159 Mtetra
.556 .292 .472 r
.71484 .50159 .71796 .49536 .72112 .49628 .718 .50252 Mtetra
.586 .325 .489 r
.718 .50252 .72112 .49628 .72431 .49802 .72119 .50426 Mtetra
.595 .336 .494 r
.72119 .50426 .72431 .49802 .72752 .50006 .7244 .50632 Mtetra
.589 .329 .491 r
.7244 .50632 .72752 .50006 .73074 .50191 .72762 .50818 Mtetra
.565 .303 .477 r
.72762 .50818 .73074 .50191 .73393 .50307 .73082 .50935 Mtetra
.516 .25 .449 r
.73082 .50935 .73393 .50307 .73709 .50316 .73398 .50945 Mtetra
.424 .153 .396 r
.73398 .50945 .73709 .50316 .74019 .50192 .73709 .50821 Mtetra
.252 0 .293 r
.73709 .50821 .74019 .50192 .74324 .49923 .74014 .50552 Mtetra
0 0 .093 r
.74014 .50552 .74324 .49923 .74623 .4951 .74313 .50138 Mtetra
0 0 0 r
.74313 .50138 .74623 .4951 .74917 .48968 .74607 .49595 Mtetra
.776 .863 .425 r
.74607 .49595 .74917 .48968 .75206 .48322 .74897 .48948 Mtetra
.895 .92 .529 r
.74897 .48948 .75206 .48322 .75491 .47604 .75183 .48228 Mtetra
.93 .929 .563 r
.75183 .48228 .75491 .47604 .75775 .46851 .75468 .47474 Mtetra
.927 .929 .56 r
.75468 .47474 .75775 .46851 .76059 .46103 .75752 .46724 Mtetra
.882 .916 .517 r
.75752 .46724 .76059 .46103 .76345 .45396 .76038 .46016 Mtetra
.746 .846 .401 r
.76038 .46016 .76345 .45396 .76634 .44765 .76328 .45383 Mtetra
0 0 0 r
.76328 .45383 .76634 .44765 .76928 .44236 .76623 .44854 Mtetra
0 0 .104 r
.76623 .44854 .76928 .44236 .77228 .43832 .76923 .44449 Mtetra
.254 0 .291 r
.76923 .44449 .77228 .43832 .77535 .43564 .77231 .44181 Mtetra
.423 .15 .393 r
.77231 .44181 .77535 .43564 .7785 .4344 .77546 .44057 Mtetra
.519 .251 .448 r
.77546 .44057 .7785 .4344 .78172 .43456 .77868 .44074 Mtetra
.575 .312 .48 r
.77868 .44074 .78172 .43456 .78501 .43602 .78198 .44221 Mtetra
.61 .35 .499 r
.78198 .44221 .78501 .43602 .78837 .43862 .78534 .44482 Mtetra
.632 .374 .51 r
.78534 .44482 .78837 .43862 .79179 .44214 .78877 .44836 Mtetra
.644 .389 .517 r
.78877 .44836 .79179 .44214 .79526 .44632 .79223 .45256 Mtetra
.651 .396 .52 r
.79223 .45256 .79526 .44632 .79876 .45086 .79573 .45712 Mtetra
.651 .396 .521 r
.79573 .45712 .79876 .45086 .80227 .45547 .79924 .46175 Mtetra
.647 .391 .518 r
.79924 .46175 .80227 .45547 .80578 .45983 .80275 .46613 Mtetra
.636 .38 .513 r
.80275 .46613 .80578 .45983 .80927 .46365 .80625 .46997 Mtetra
.619 .36 .504 r
.80625 .46997 .80927 .46365 .81273 .46666 .80971 .473 Mtetra
.59 .329 .488 r
.80971 .473 .81273 .46666 .81614 .46864 .81312 .47499 Mtetra
.546 .281 .464 r
.81312 .47499 .81614 .46864 .81949 .46938 .81648 .47574 Mtetra
.474 .204 .424 r
.81648 .47574 .81949 .46938 .82277 .46876 .81976 .47513 Mtetra
.351 .079 .354 r
.81976 .47513 .82277 .46876 .82598 .4667 .82297 .47306 Mtetra
.133 0 .222 r
.82297 .47306 .82598 .4667 .8291 .46318 .8261 .46954 Mtetra
0 0 0 r
.8261 .46954 .8291 .46318 .83214 .45822 .82914 .46457 Mtetra
.643 .771 .304 r
.82914 .46457 .83214 .45822 .8351 .45193 .83211 .45827 Mtetra
.881 .907 .499 r
.83211 .45827 .8351 .45193 .838 .44443 .83501 .45075 Mtetra
.963 .922 .583 r
.83501 .45075 .838 .44443 .84082 .43591 .83785 .44221 Mtetra
.984 .906 .615 r
.83785 .44221 .84082 .43591 .8436 .42658 .84063 .43286 Mtetra
.987 .89 .628 r
.84063 .43286 .8436 .42658 .84633 .41667 .84337 .42292 Mtetra
.987 .88 .633 r
.84337 .42292 .84633 .41667 .84904 .40643 .84609 .41266 Mtetra
.987 .877 .634 r
.84609 .41266 .84904 .40643 .85174 .39613 .8488 .40233 Mtetra
.987 .882 .632 r
.8488 .40233 .85174 .39613 .85445 .38601 .85151 .39219 Mtetra
.987 .895 .625 r
.85151 .39219 .85445 .38601 .85718 .37633 .85425 .38248 Mtetra
.98 .912 .609 r
.85425 .38248 .85718 .37633 .85995 .3673 .85703 .37344 Mtetra
.949 .924 .568 r
.85703 .37344 .85995 .3673 .86278 .35914 .85986 .36525 Mtetra
.842 .891 .467 r
.85986 .36525 .86278 .35914 .86566 .35201 .86275 .35812 Mtetra
0 0 0 r
.86275 .35812 .86566 .35201 .86863 .34607 .86572 .35217 Mtetra
0 0 .028 r
.86572 .35217 .86863 .34607 .87168 .34143 .86878 .34752 Mtetra
.168 0 .238 r
.86878 .34752 .87168 .34143 .87483 .33816 .87193 .34424 Mtetra
.367 .091 .357 r
.87193 .34424 .87483 .33816 .87808 .3363 .87519 .34238 Mtetra
.483 .21 .423 r
.87519 .34238 .87808 .3363 .88143 .33585 .87854 .34194 Mtetra
.553 .284 .462 r
.87854 .34194 .88143 .33585 .88488 .33678 .882 .34288 Mtetra
.598 .333 .486 r
.882 .34288 .88488 .33678 .88844 .33902 .88555 .34513 Mtetra
.629 .366 .502 r
.88555 .34513 .88844 .33902 .89208 .34248 .8892 .34861 Mtetra
.649 .39 .513 r
.8892 .34861 .89208 .34248 .89582 .34702 .89294 .35316 Mtetra
.664 .406 .52 r
.89294 .35316 .89582 .34702 .89964 .35248 .89676 .35866 Mtetra
.674 .417 .525 r
.89676 .35866 .89964 .35248 .90353 .3587 .90065 .3649 Mtetra
.68 .424 .528 r
.90065 .3649 .90353 .3587 .90747 .36548 .9046 .37171 Mtetra
.684 .429 .53 r
.9046 .37171 .90747 .36548 .91146 .37261 .90858 .37887 Mtetra
.685 .43 .53 r
.90858 .37887 .91146 .37261 .91547 .37987 .9126 .38616 Mtetra
.684 .428 .53 r
.9126 .38616 .91547 .37987 .91949 .38704 .91662 .39336 Mtetra
.693 .456 .559 r
.46452 .66101 .46792 .65516 .47059 .66223 .46719 .6681 Mtetra
.694 .457 .56 r
.46719 .6681 .47059 .66223 .47328 .66944 .46987 .67534 Mtetra
.693 .456 .559 r
.46987 .67534 .47328 .66944 .47598 .67659 .47256 .68251 Mtetra
.69 .452 .558 r
.47256 .68251 .47598 .67659 .47868 .68346 .47527 .68941 Mtetra
.685 .446 .554 r
.47527 .68941 .47868 .68346 .48141 .68985 .47799 .69582 Mtetra
.676 .436 .549 r
.47799 .69582 .48141 .68985 .48414 .69555 .48072 .70155 Mtetra
.664 .421 .542 r
.48072 .70155 .48414 .69555 .48689 .70038 .48347 .70639 Mtetra
.646 .399 .531 r
.48347 .70639 .48689 .70038 .48964 .70416 .48623 .71019 Mtetra
.618 .367 .514 r
.48623 .71019 .48964 .70416 .49241 .70677 .48899 .71281 Mtetra
.576 .318 .488 r
.48899 .71281 .49241 .70677 .49519 .70807 .49177 .71412 Mtetra
.506 .239 .444 r
.49177 .71412 .49519 .70807 .49796 .708 .49455 .71406 Mtetra
.378 .102 .362 r
.49455 .71406 .49796 .708 .50075 .70651 .49734 .71257 Mtetra
.122 0 .191 r
.49734 .71257 .50075 .70651 .50353 .70361 .50012 .70966 Mtetra
0 0 0 r
.50012 .70966 .50353 .70361 .50632 .69933 .50291 .70538 Mtetra
.805 .905 .501 r
.50291 .70538 .50632 .69933 .5091 .69375 .5057 .69979 Mtetra
.954 .946 .644 r
.5057 .69979 .5091 .69375 .51188 .68698 .50849 .69301 Mtetra
.975 .909 .68 r
.50849 .69301 .51188 .68698 .51466 .6792 .51127 .68521 Mtetra
.969 .873 .687 r
.51127 .68521 .51466 .6792 .51743 .67057 .51405 .67656 Mtetra
.96 .848 .687 r
.51405 .67656 .51743 .67057 .5202 .6613 .51682 .66728 Mtetra
.954 .834 .687 r
.51682 .66728 .5202 .6613 .52296 .65165 .51959 .6576 Mtetra
.952 .829 .686 r
.51959 .6576 .52296 .65165 .52572 .64183 .52235 .64776 Mtetra
.953 .831 .686 r
.52235 .64776 .52572 .64183 .52847 .63211 .52511 .63802 Mtetra
.958 .842 .687 r
.52511 .63802 .52847 .63211 .53122 .62273 .52787 .62862 Mtetra
.966 .864 .688 r
.52787 .62862 .53122 .62273 .53397 .61393 .53063 .6198 Mtetra
.974 .896 .684 r
.53063 .6198 .53397 .61393 .53672 .60593 .53339 .61178 Mtetra
.967 .937 .662 r
.53339 .61178 .53672 .60593 .53948 .59892 .53615 .60476 Mtetra
.874 .938 .565 r
.53615 .60476 .53948 .59892 .54225 .59306 .53893 .59889 Mtetra
0 0 0 r
.53893 .59889 .54225 .59306 .54503 .58847 .54171 .59429 Mtetra
.014 0 .11 r
.54171 .59429 .54503 .58847 .54782 .58524 .5445 .59106 Mtetra
.324 .041 .321 r
.5445 .59106 .54782 .58524 .55062 .5834 .54731 .58921 Mtetra
.475 .202 .419 r
.54731 .58921 .55062 .5834 .55345 .58292 .55014 .58874 Mtetra
.555 .291 .47 r
.55014 .58874 .55345 .58292 .55629 .58375 .55298 .58958 Mtetra
.601 .343 .498 r
.55298 .58958 .55629 .58375 .55915 .58575 .55584 .59159 Mtetra
.629 .376 .515 r
.55584 .59159 .55915 .58575 .56203 .58877 .55873 .59462 Mtetra
.646 .396 .526 r
.55873 .59462 .56203 .58877 .56493 .59258 .56162 .59845 Mtetra
.656 .407 .531 r
.56162 .59845 .56493 .59258 .56785 .59695 .56454 .60284 Mtetra
.66 .412 .534 r
.56454 .60284 .56785 .59695 .57077 .60158 .56747 .60749 Mtetra
.56747 .60749 .57077 .60158 .57371 .60619 .5704 .61212 Mtetra
.654 .405 .53 r
.5704 .61212 .57371 .60619 .57666 .61047 .57335 .61641 Mtetra
.642 .39 .523 r
.57335 .61641 .57666 .61047 .5796 .61412 .57629 .62009 Mtetra
.621 .366 .511 r
.57629 .62009 .5796 .61412 .58254 .61689 .57923 .62286 Mtetra
.587 .327 .49 r
.57923 .62286 .58254 .61689 .58547 .61853 .58216 .62451 Mtetra
.53 .263 .455 r
.58216 .62451 .58547 .61853 .58839 .61887 .58508 .62487 Mtetra
.428 .152 .391 r
.58508 .62487 .58839 .61887 .59129 .61781 .58799 .62381 Mtetra
.232 0 .265 r
.58799 .62381 .59129 .61781 .59417 .61532 .59087 .62132 Mtetra
0 0 .013 r
.59087 .62132 .59417 .61532 .59704 .61144 .59374 .61743 Mtetra
0 0 0 r
.59374 .61743 .59704 .61144 .59988 .60632 .59659 .6123 Mtetra
.868 .929 .546 r
.59659 .6123 .59988 .60632 .6027 .60017 .59941 .60614 Mtetra
.947 .945 .623 r
.59941 .60614 .6027 .60017 .60551 .59327 .60223 .59922 Mtetra
.966 .937 .646 r
.60223 .59922 .60551 .59327 .60831 .58596 .60503 .5919 Mtetra
.967 .935 .648 r
.60503 .5919 .60831 .58596 .61111 .57862 .60784 .58455 Mtetra
.953 .943 .63 r
.60784 .58455 .61111 .57862 .61391 .57163 .61065 .57754 Mtetra
.889 .937 .565 r
.61065 .57754 .61391 .57163 .61672 .56535 .61347 .57125 Mtetra
.656 .81 .371 r
.61347 .57125 .61672 .56535 .61956 .56009 .61631 .56598 Mtetra
0 0 0 r
.61631 .56598 .61956 .56009 .62243 .5561 .61918 .56198 Mtetra
.212 0 .249 r
.61918 .56198 .62243 .5561 .62533 .55351 .62208 .5594 Mtetra
.416 .139 .381 r
.62208 .5594 .62533 .55351 .62826 .55235 .62502 .55823 Mtetra
.518 .248 .445 r
.62502 .55823 .62826 .55235 .63123 .55249 .62799 .55838 Mtetra
.569 .305 .476 r
.62799 .55838 .63123 .55249 .63423 .55368 .631 .55959 Mtetra
.594 .333 .491 r
.631 .55959 .63423 .55368 .63726 .55556 .63402 .56147 Mtetra
.601 .341 .495 r
.63402 .56147 .63726 .55556 .6403 .55765 .63706 .56357 Mtetra
.591 .33 .489 r
.63706 .56357 .6403 .55765 .64334 .55944 .6401 .56537 Mtetra
.56 .295 .471 r
.6401 .56537 .64334 .55944 .64636 .56042 .64313 .56636 Mtetra
.495 .223 .431 r
.64313 .56636 .64636 .56042 .64936 .56019 .64613 .56614 Mtetra
.363 .083 .349 r
.64613 .56614 .64936 .56019 .65233 .55852 .6491 .56447 Mtetra
.109 0 .183 r
.6491 .56447 .65233 .55852 .65526 .55539 .65204 .56134 Mtetra
0 0 0 r
.65204 .56134 .65526 .55539 .65817 .55111 .65495 .55705 Mtetra
.65495 .55705 .65817 .55111 .66105 .54623 .65784 .55216 Mtetra
.65784 .55216 .66105 .54623 .66395 .54151 .66074 .54744 Mtetra
0 0 .062 r
.66074 .54744 .66395 .54151 .66687 .53775 .66366 .54367 Mtetra
.278 0 .294 r
.66366 .54367 .66687 .53775 .66984 .53547 .66664 .54139 Mtetra
.448 .172 .401 r
.66664 .54139 .66984 .53547 .67285 .53462 .66965 .54054 Mtetra
.484 .211 .423 r
.66965 .54054 .67285 .53462 .67589 .53424 .67269 .54017 Mtetra
.373 .093 .354 r
.67269 .54017 .67589 .53424 .67889 .53263 .6757 .53856 Mtetra
.173 0 .226 r
.6757 .53856 .67889 .53263 .68186 .52976 .67867 .53569 Mtetra
.372 .093 .354 r
.67867 .53569 .68186 .52976 .68487 .52815 .68169 .53408 Mtetra
.484 .21 .423 r
.68169 .53408 .68487 .52815 .68793 .52777 .68475 .5337 Mtetra
.447 .171 .401 r
.68475 .5337 .68793 .52777 .69098 .52691 .6878 .53285 Mtetra
.28 0 .295 r
.6878 .53285 .69098 .52691 .69398 .52461 .6908 .53054 Mtetra
0 0 .071 r
.6908 .53054 .69398 .52461 .69693 .52081 .69376 .52674 Mtetra
0 0 0 r
.69376 .52674 .69693 .52081 .69985 .51605 .69669 .52197 Mtetra
.69669 .52197 .69985 .51605 .70277 .51112 .69961 .51704 Mtetra
.69961 .51704 .70277 .51112 .70571 .50679 .70255 .5127 Mtetra
.111 0 .185 r
.70255 .5127 .70571 .50679 .7087 .50361 .70554 .50952 Mtetra
.359 .079 .345 r
.70554 .50952 .7087 .50361 .71174 .50188 .70859 .50779 Mtetra
.49 .216 .426 r
.70859 .50779 .71174 .50188 .71484 .50159 .71169 .5075 Mtetra
.556 .288 .465 r
.71169 .5075 .71484 .50159 .718 .50252 .71485 .50844 Mtetra
.588 .323 .483 r
.71485 .50844 .718 .50252 .72119 .50426 .71805 .5102 Mtetra
.598 .335 .489 r
.71805 .5102 .72119 .50426 .7244 .50632 .72126 .51227 Mtetra
.591 .327 .485 r
.72126 .51227 .7244 .50632 .72762 .50818 .72448 .51414 Mtetra
.566 .299 .471 r
.72448 .51414 .72762 .50818 .73082 .50935 .72768 .51532 Mtetra
.514 .243 .44 r
.72768 .51532 .73082 .50935 .73398 .50945 .73084 .51542 Mtetra
.416 .138 .381 r
.73084 .51542 .73398 .50945 .73709 .50821 .73395 .51419 Mtetra
.226 0 .262 r
.73395 .51419 .73709 .50821 .74014 .50552 .73701 .51149 Mtetra
0 0 .03 r
.73701 .51149 .74014 .50552 .74313 .50138 .74001 .50735 Mtetra
0 0 0 r
.74001 .50735 .74313 .50138 .74607 .49595 .74296 .50191 Mtetra
.838 .906 .497 r
.74296 .50191 .74607 .49595 .74897 .48948 .74586 .49542 Mtetra
.929 .936 .58 r
.74586 .49542 .74897 .48948 .75183 .48228 .74872 .48821 Mtetra
.953 .936 .605 r
.74872 .48821 .75183 .48228 .75468 .47474 .75158 .48066 Mtetra
.95 .937 .603 r
.75158 .48066 .75468 .47474 .75752 .46724 .75443 .47314 Mtetra
.92 .935 .571 r
.75443 .47314 .75752 .46724 .76038 .46016 .7573 .46605 Mtetra
.814 .894 .477 r
.7573 .46605 .76038 .46016 .76328 .45383 .7602 .4597 Mtetra
0 0 0 r
.7602 .4597 .76328 .45383 .76623 .44854 .76315 .4544 Mtetra
0 0 .042 r
.76315 .4544 .76623 .44854 .76923 .44449 .76616 .45034 Mtetra
.227 0 .26 r
.76616 .45034 .76923 .44449 .77231 .44181 .76924 .44767 Mtetra
.415 .135 .377 r
.76924 .44767 .77231 .44181 .77546 .44057 .77239 .44643 Mtetra
.517 .244 .439 r
.77239 .44643 .77546 .44057 .77868 .44074 .77562 .4466 Mtetra
.577 .309 .473 r
.77562 .4466 .77868 .44074 .78198 .44221 .77892 .44809 Mtetra
.613 .349 .494 r
.77892 .44809 .78198 .44221 .78534 .44482 .78229 .45071 Mtetra
.635 .374 .506 r
.78229 .45071 .78534 .44482 .78877 .44836 .78571 .45427 Mtetra
.648 .389 .514 r
.78571 .45427 .78877 .44836 .79223 .45256 .78918 .45848 Mtetra
.654 .396 .517 r
.78918 .45848 .79223 .45256 .79573 .45712 .79267 .46307 Mtetra
.655 .397 .517 r
.79267 .46307 .79573 .45712 .79924 .46175 .79619 .46771 Mtetra
.65 .392 .515 r
.79619 .46771 .79924 .46175 .80275 .46613 .7997 .47211 Mtetra
.64 .38 .509 r
.7997 .47211 .80275 .46613 .80625 .46997 .8032 .47597 Mtetra
.621 .359 .499 r
.8032 .47597 .80625 .46997 .80971 .473 .80666 .47902 Mtetra
.592 .327 .483 r
.80666 .47902 .80971 .473 .81312 .47499 .81007 .48101 Mtetra
.546 .276 .457 r
.81007 .48101 .81312 .47499 .81648 .47574 .81343 .48178 Mtetra
.47 .194 .413 r
.81343 .48178 .81648 .47574 .81976 .47513 .81672 .48117 Mtetra
.336 .057 .333 r
.81672 .48117 .81976 .47513 .82297 .47306 .81993 .47911 Mtetra
.091 0 .18 r
.81993 .47911 .82297 .47306 .8261 .46954 .82306 .47557 Mtetra
0 0 0 r
.82306 .47557 .8261 .46954 .82914 .46457 .82612 .4706 Mtetra
.725 .835 .389 r
.82612 .4706 .82914 .46457 .83211 .45827 .82909 .46428 Mtetra
.919 .928 .554 r
.82909 .46428 .83211 .45827 .83501 .45075 .832 .45675 Mtetra
.975 .922 .615 r
.832 .45675 .83501 .45075 .83785 .44221 .83484 .44819 Mtetra
.985 .898 .637 r
.83484 .44819 .83785 .44221 .84063 .43286 .83763 .43882 Mtetra
.984 .88 .645 r
.83763 .43882 .84063 .43286 .84337 .42292 .84038 .42886 Mtetra
.982 .869 .647 r
.84038 .42886 .84337 .42292 .84609 .41266 .8431 .41858 Mtetra
.982 .866 .648 r
.8431 .41858 .84609 .41266 .8488 .40233 .84582 .40822 Mtetra
.983 .872 .647 r
.84582 .40822 .8488 .40233 .85151 .39219 .84854 .39806 Mtetra
.985 .885 .643 r
.84854 .39806 .85151 .39219 .85425 .38248 .85129 .38833 Mtetra
.984 .906 .633 r
.85129 .38833 .85425 .38248 .85703 .37344 .85407 .37926 Mtetra
.966 .927 .605 r
.85407 .37926 .85703 .37344 .85986 .36525 .8569 .37106 Mtetra
.89 .921 .529 r
.8569 .37106 .85986 .36525 .86275 .35812 .8598 .36391 Mtetra
.657 .794 .341 r
.8598 .36391 .86275 .35812 .86572 .35217 .86278 .35795 Mtetra
0 0 0 r
.86278 .35795 .86572 .35217 .86878 .34752 .86585 .35329 Mtetra
.13 0 .199 r
.86585 .35329 .86878 .34752 .87193 .34424 .869 .35001 Mtetra
.353 .07 .337 r
.869 .35001 .87193 .34424 .87519 .34238 .87226 .34815 Mtetra
.479 .2 .411 r
.87226 .34815 .87519 .34238 .87854 .34194 .87562 .34771 Mtetra
.554 .279 .454 r
.87562 .34771 .87854 .34194 .882 .34288 .87908 .34866 Mtetra
.6 .331 .48 r
.87908 .34866 .882 .34288 .88555 .34513 .88263 .35093 Mtetra
.632 .366 .497 r
.88263 .35093 .88555 .34513 .8892 .34861 .88629 .35442 Mtetra
.653 .39 .509 r
.88629 .35442 .8892 .34861 .89294 .35316 .89003 .359 Mtetra
.667 .407 .517 r
.89003 .359 .89294 .35316 .89676 .35866 .89385 .36451 Mtetra
.677 .418 .522 r
.89385 .36451 .89676 .35866 .90065 .3649 .89774 .37078 Mtetra
.684 .426 .525 r
.89774 .37078 .90065 .3649 .9046 .37171 .90169 .37762 Mtetra
.687 .43 .527 r
.90169 .37762 .9046 .37171 .90858 .37887 .90567 .3848 Mtetra
.689 .431 .528 r
.90567 .3848 .90858 .37887 .9126 .38616 .90969 .39212 Mtetra
.687 .429 .527 r
.90969 .39212 .9126 .38616 .91662 .39336 .91371 .39935 Mtetra
.699 .459 .557 r
.4611 .66631 .46452 .66101 .46719 .6681 .46377 .67343 Mtetra
.7 .46 .557 r
.46377 .67343 .46719 .6681 .46987 .67534 .46645 .68069 Mtetra
.699 .459 .557 r
.46645 .68069 .46987 .67534 .47256 .68251 .46914 .68789 Mtetra
.696 .455 .555 r
.46914 .68789 .47256 .68251 .47527 .68941 .47185 .69481 Mtetra
.691 .448 .551 r
.47185 .69481 .47527 .68941 .47799 .69582 .47457 .70124 Mtetra
.682 .438 .546 r
.47457 .70124 .47799 .69582 .48072 .70155 .4773 .70699 Mtetra
.67 .422 .538 r
.4773 .70699 .48072 .70155 .48347 .70639 .48004 .71185 Mtetra
.651 .4 .526 r
.48004 .71185 .48347 .70639 .48623 .71019 .4828 .71567 Mtetra
.623 .366 .507 r
.4828 .71567 .48623 .71019 .48899 .71281 .48556 .71829 Mtetra
.579 .313 .478 r
.48556 .71829 .48899 .71281 .49177 .71412 .48834 .71961 Mtetra
.502 .225 .426 r
.48834 .71961 .49177 .71412 .49455 .71406 .49112 .71955 Mtetra
.354 .064 .325 r
.49112 .71955 .49455 .71406 .49734 .71257 .49391 .71807 Mtetra
.037 0 .102 r
.49391 .71807 .49734 .71257 .50012 .70966 .4967 .71516 Mtetra
0 0 0 r
.4967 .71516 .50012 .70966 .50291 .70538 .4995 .71087 Mtetra
.892 .956 .613 r
.4995 .71087 .50291 .70538 .5057 .69979 .50229 .70527 Mtetra
.966 .934 .69 r
.50229 .70527 .5057 .69979 .50849 .69301 .50508 .69848 Mtetra
.965 .885 .702 r
.50508 .69848 .50849 .69301 .51127 .68521 .50787 .69066 Mtetra
.954 .849 .7 r
.50787 .69066 .51127 .68521 .51405 .67656 .51065 .68199 Mtetra
.944 .826 .697 r
.51065 .68199 .51405 .67656 .51682 .66728 .51343 .6727 Mtetra
.938 .812 .694 r
.51343 .6727 .51682 .66728 .51959 .6576 .51621 .66299 Mtetra
.936 .807 .693 r
.51621 .66299 .51959 .6576 .52235 .64776 .51898 .65314 Mtetra
.937 .81 .694 r
.51898 .65314 .52235 .64776 .52511 .63802 .52175 .64338 Mtetra
.942 .82 .696 r
.52175 .64338 .52511 .63802 .52787 .62862 .52451 .63396 Mtetra
.95 .84 .699 r
.52451 .63396 .52787 .62862 .53063 .6198 .52728 .62512 Mtetra
.961 .872 .702 r
.52728 .62512 .53063 .6198 .53339 .61178 .53004 .61709 Mtetra
.968 .918 .698 r
.53004 .61709 .53339 .61178 .53615 .60476 .53281 .61005 Mtetra
.93 .96 .653 r
.53281 .61005 .53615 .60476 .53893 .59889 .53559 .60417 Mtetra
.669 .845 .433 r
.53559 .60417 .53893 .59889 .54171 .59429 .53837 .59957 Mtetra
0 0 0 r
.53837 .59957 .54171 .59429 .5445 .59106 .54117 .59633 Mtetra
.288 0 .273 r
.54117 .59633 .5445 .59106 .54731 .58921 .54398 .59449 Mtetra
.467 .182 .396 r
.54398 .59449 .54731 .58921 .55014 .58874 .54681 .59402 Mtetra
.556 .283 .456 r
.54681 .59402 .55014 .58874 .55298 .58958 .54966 .59486 Mtetra
.605 .34 .489 r
.54966 .59486 .55298 .58958 .55584 .59159 .55252 .59688 Mtetra
.634 .375 .508 r
.55252 .59688 .55584 .59159 .55873 .59462 .5554 .59993 Mtetra
.652 .397 .52 r
.5554 .59993 .55873 .59462 .56162 .59845 .5583 .60377 Mtetra
.662 .409 .526 r
.5583 .60377 .56162 .59845 .56454 .60284 .56121 .60817 Mtetra
.666 .414 .529 r
.56121 .60817 .56454 .60284 .56747 .60749 .56414 .61285 Mtetra
.666 .413 .529 r
.56414 .61285 .56747 .60749 .5704 .61212 .56707 .61749 Mtetra
.66 .406 .525 r
.56707 .61749 .5704 .61212 .57335 .61641 .57002 .6218 Mtetra
.647 .391 .517 r
.57002 .6218 .57335 .61641 .57629 .62009 .57296 .62549 Mtetra
.626 .365 .503 r
.57296 .62549 .57629 .62009 .57923 .62286 .5759 .62828 Mtetra
.591 .323 .48 r
.5759 .62828 .57923 .62286 .58216 .62451 .57884 .62994 Mtetra
.529 .252 .439 r
.57884 .62994 .58216 .62451 .58508 .62487 .58176 .6303 Mtetra
.413 .124 .362 r
.58176 .6303 .58508 .62487 .58799 .62381 .58466 .62925 Mtetra
.175 0 .199 r
.58466 .62925 .58799 .62381 .59087 .62132 .58755 .62675 Mtetra
0 0 0 r
.58755 .62675 .59087 .62132 .59374 .61743 .59042 .62286 Mtetra
.753 .89 .487 r
.59042 .62286 .59374 .61743 .59659 .6123 .59327 .61772 Mtetra
.929 .956 .637 r
.59327 .61772 .59659 .6123 .59941 .60614 .59611 .61155 Mtetra
.966 .938 .677 r
.59611 .61155 .59941 .60614 .60223 .59922 .59893 .60462 Mtetra
.971 .921 .686 r
.59893 .60462 .60223 .59922 .60503 .5919 .60174 .59728 Mtetra
.971 .919 .687 r
.60174 .59728 .60503 .5919 .60784 .58455 .60455 .58992 Mtetra
.968 .934 .68 r
.60455 .58992 .60784 .58455 .61065 .57754 .60736 .5829 Mtetra
.94 .955 .648 r
.60736 .5829 .61065 .57754 .61347 .57125 .61019 .57659 Mtetra
.792 .911 .519 r
.61019 .57659 .61347 .57125 .61631 .56598 .61303 .57132 Mtetra
0 0 0 r
.61303 .57132 .61631 .56598 .61918 .56198 .61591 .56732 Mtetra
.149 0 .178 r
.61591 .56732 .61918 .56198 .62208 .5594 .61881 .56473 Mtetra
.399 .108 .35 r
.61881 .56473 .62208 .5594 .62502 .55823 .62175 .56357 Mtetra
.515 .235 .427 r
.62175 .56357 .62502 .55823 .62799 .55838 .62473 .56372 Mtetra
.572 .299 .464 r
.62473 .56372 .62799 .55838 .631 .55959 .62773 .56493 Mtetra
.598 .33 .481 r
.62773 .56493 .631 .55959 .63402 .56147 .63076 .56683 Mtetra
.605 .338 .486 r
.63076 .56683 .63402 .56147 .63706 .56357 .6338 .56894 Mtetra
.595 .326 .479 r
.6338 .56894 .63706 .56357 .6401 .56537 .63684 .57075 Mtetra
.562 .288 .458 r
.63684 .57075 .6401 .56537 .64313 .56636 .63987 .57175 Mtetra
.489 .206 .41 r
.63987 .57175 .64313 .56636 .64613 .56614 .64288 .57153 Mtetra
.336 .041 .308 r
.64288 .57153 .64613 .56614 .6491 .56447 .64585 .56986 Mtetra
.021 0 .091 r
.64585 .56986 .6491 .56447 .65204 .56134 .64879 .56673 Mtetra
0 0 0 r
.64879 .56673 .65204 .56134 .65495 .55705 .6517 .56243 Mtetra
.636 .814 .389 r
.6517 .56243 .65495 .55705 .65784 .55216 .6546 .55754 Mtetra
0 0 0 r
.6546 .55754 .65784 .55216 .66074 .54744 .6575 .55281 Mtetra
.6575 .55281 .66074 .54744 .66366 .54367 .66043 .54903 Mtetra
.233 0 .237 r
.66043 .54903 .66366 .54367 .66664 .54139 .66341 .54675 Mtetra
.436 .147 .374 r
.66341 .54675 .66664 .54139 .66965 .54054 .66643 .54591 Mtetra
.478 .193 .402 r
.66643 .54591 .66965 .54054 .67269 .54017 .66947 .54554 Mtetra
.347 .053 .315 r
.66947 .54554 .67269 .54017 .6757 .53856 .67248 .54393 Mtetra
.101 0 .148 r
.67248 .54393 .6757 .53856 .67867 .53569 .67545 .54106 Mtetra
.347 .052 .315 r
.67545 .54106 .67867 .53569 .68169 .53408 .67847 .53945 Mtetra
.477 .192 .401 r
.67847 .53945 .68169 .53408 .68475 .5337 .68153 .53908 Mtetra
.436 .146 .374 r
.68153 .53908 .68475 .5337 .6878 .53285 .68458 .53822 Mtetra
.235 0 .239 r
.68458 .53822 .6878 .53285 .6908 .53054 .68759 .53592 Mtetra
0 0 0 r
.68759 .53592 .6908 .53054 .69376 .52674 .69056 .53211 Mtetra
.69056 .53211 .69376 .52674 .69669 .52197 .69349 .52734 Mtetra
.618 .799 .37 r
.69349 .52734 .69669 .52197 .69961 .51704 .69642 .5224 Mtetra
0 0 0 r
.69642 .5224 .69961 .51704 .70255 .5127 .69936 .51805 Mtetra
.023 0 .093 r
.69936 .51805 .70255 .5127 .70554 .50952 .70236 .51487 Mtetra
.331 .035 .303 r
.70236 .51487 .70554 .50952 .70859 .50779 .70541 .51314 Mtetra
.484 .199 .404 r
.70541 .51314 .70859 .50779 .71169 .5075 .70851 .51286 Mtetra
.557 .28 .451 r
.70851 .51286 .71169 .5075 .71485 .50844 .71167 .5138 Mtetra
.591 .319 .473 r
.71167 .5138 .71485 .50844 .71805 .5102 .71487 .51557 Mtetra
.602 .331 .479 r
.71487 .51557 .71805 .5102 .72126 .51227 .71809 .51765 Mtetra
.595 .323 .475 r
.71809 .51765 .72126 .51227 .72448 .51414 .7213 .51953 Mtetra
.568 .292 .458 r
.7213 .51953 .72448 .51414 .72768 .51532 .7245 .52072 Mtetra
.511 .229 .422 r
.7245 .52072 .72768 .51532 .73084 .51542 .72767 .52083 Mtetra
.399 .107 .35 r
.72767 .52083 .73084 .51542 .73395 .51419 .73078 .5196 Mtetra
.167 0 .196 r
.73078 .5196 .73395 .51419 .73701 .51149 .73385 .5169 Mtetra
0 0 0 r
.73385 .5169 .73701 .51149 .74001 .50735 .73685 .51276 Mtetra
.725 .864 .445 r
.73685 .51276 .74001 .50735 .74296 .50191 .7398 .50731 Mtetra
.914 .948 .601 r
.7398 .50731 .74296 .50191 .74586 .49542 .74271 .5008 Mtetra
.961 .941 .648 r
.74271 .5008 .74586 .49542 .74872 .48821 .74558 .49358 Mtetra
.971 .931 .66 r
.74558 .49358 .74872 .48821 .75158 .48066 .74844 .48601 Mtetra
.97 .932 .659 r
.74844 .48601 .75158 .48066 .75443 .47314 .7513 .47848 Mtetra
.957 .944 .643 r
.7513 .47848 .75443 .47314 .7573 .46605 .75417 .47137 Mtetra
.9 .945 .588 r
.75417 .47137 .7573 .46605 .7602 .4597 .75708 .46502 Mtetra
.692 .844 .42 r
.75708 .46502 .7602 .4597 .76315 .4544 .76003 .4597 Mtetra
0 0 0 r
.76003 .4597 .76315 .4544 .76616 .45034 .76305 .45564 Mtetra
.169 0 .193 r
.76305 .45564 .76616 .45034 .76924 .44767 .76613 .45297 Mtetra
.397 .103 .345 r
.76613 .45297 .76924 .44767 .77239 .44643 .76929 .45173 Mtetra
.515 .23 .42 r
.76929 .45173 .77239 .44643 .77562 .4466 .77252 .45191 Mtetra
.579 .303 .461 r
.77252 .45191 .77562 .4466 .77892 .44809 .77582 .4534 Mtetra
.617 .347 .485 r
.77582 .4534 .77892 .44809 .78229 .45071 .77919 .45604 Mtetra
.64 .374 .499 r
.77919 .45604 .78229 .45071 .78571 .45427 .78261 .45961 Mtetra
.654 .389 .507 r
.78261 .45961 .78571 .45427 .78918 .45848 .78608 .46384 Mtetra
.66 .397 .511 r
.78608 .46384 .78918 .45848 .79267 .46307 .78958 .46845 Mtetra
.661 .398 .511 r
.78958 .46845 .79267 .46307 .79619 .46771 .79309 .47311 Mtetra
.656 .392 .509 r
.79309 .47311 .79619 .46771 .7997 .47211 .7966 .47753 Mtetra
.645 .38 .502 r
.7966 .47753 .7997 .47211 .8032 .47597 .8001 .4814 Mtetra
.627 .358 .491 r
.8001 .4814 .8032 .47597 .80666 .47902 .80356 .48446 Mtetra
.596 .323 .472 r
.80356 .48446 .80666 .47902 .81007 .48101 .80698 .48647 Mtetra
.546 .266 .442 r
.80698 .48647 .81007 .48101 .81343 .48178 .81034 .48724 Mtetra
.461 .173 .389 r
.81034 .48724 .81343 .48178 .81672 .48117 .81363 .48664 Mtetra
.303 .009 .288 r
.81363 .48664 .81672 .48117 .81993 .47911 .81685 .48458 Mtetra
0 0 .086 r
.81685 .48458 .81993 .47911 .82306 .47557 .81998 .48104 Mtetra
0 0 0 r
.81998 .48104 .82306 .47557 .82612 .4706 .82304 .47606 Mtetra
.843 .919 .523 r
.82304 .47606 .82612 .4706 .82909 .46428 .82602 .46973 Mtetra
.959 .939 .628 r
.82602 .46973 .82909 .46428 .832 .45675 .82893 .46218 Mtetra
.98 .908 .657 r
.82893 .46218 .832 .45675 .83484 .44819 .83178 .45361 Mtetra
.978 .879 .665 r
.83178 .45361 .83484 .44819 .83763 .43882 .83458 .44421 Mtetra
.973 .858 .666 r
.83458 .44421 .83763 .43882 .84038 .42886 .83733 .43423 Mtetra
.969 .848 .666 r
.83733 .43423 .84038 .42886 .8431 .41858 .84007 .42392 Mtetra
.969 .845 .666 r
.84007 .42392 .8431 .41858 .84582 .40822 .84279 .41355 Mtetra
.97 .85 .666 r
.84279 .41355 .84582 .40822 .84854 .39806 .84552 .40336 Mtetra
.975 .864 .666 r
.84552 .40336 .84854 .39806 .85129 .38833 .84827 .39361 Mtetra
.979 .887 .664 r
.84827 .39361 .85129 .38833 .85407 .37926 .85106 .38452 Mtetra
.978 .918 .654 r
.85106 .38452 .85407 .37926 .8569 .37106 .8539 .37631 Mtetra
.944 .944 .615 r
.8539 .37631 .8569 .37106 .8598 .36391 .85681 .36914 Mtetra
.793 .897 .488 r
.85681 .36914 .8598 .36391 .86278 .35795 .85979 .36317 Mtetra
0 0 0 r
.85979 .36317 .86278 .35795 .86585 .35329 .86286 .3585 Mtetra
.047 0 .111 r
.86286 .3585 .86585 .35329 .869 .35001 .86602 .35522 Mtetra
.324 .025 .293 r
.86602 .35522 .869 .35001 .87226 .34815 .86928 .35336 Mtetra
.472 .179 .387 r
.86928 .35336 .87226 .34815 .87562 .34771 .87264 .35293 Mtetra
.554 .27 .439 r
.87264 .35293 .87562 .34771 .87908 .34866 .8761 .35389 Mtetra
.605 .327 .469 r
.8761 .35389 .87908 .34866 .88263 .35093 .87967 .35617 Mtetra
.637 .365 .489 r
.87967 .35617 .88263 .35093 .88629 .35442 .88332 .35967 Mtetra
.659 .39 .502 r
.88332 .35967 .88629 .35442 .89003 .359 .88706 .36427 Mtetra
.674 .408 .511 r
.88706 .36427 .89003 .359 .89385 .36451 .89089 .3698 Mtetra
.684 .42 .517 r
.89089 .3698 .89385 .36451 .89774 .37078 .89478 .3761 Mtetra
.69 .428 .52 r
.89478 .3761 .89774 .37078 .90169 .37762 .89872 .38295 Mtetra
.694 .432 .522 r
.89872 .38295 .90169 .37762 .90567 .3848 .90271 .39017 Mtetra
.695 .433 .523 r
.90271 .39017 .90567 .3848 .90969 .39212 .90672 .39751 Mtetra
.694 .432 .522 r
.90672 .39751 .90969 .39212 .91371 .39935 .91075 .40477 Mtetra
.707 .463 .552 r
.45769 .67085 .4611 .66631 .46377 .67343 .46035 .67798 Mtetra
.708 .464 .553 r
.46035 .67798 .46377 .67343 .46645 .68069 .46303 .68527 Mtetra
.708 .463 .553 r
.46303 .68527 .46645 .68069 .46914 .68789 .46572 .69249 Mtetra
.705 .459 .55 r
.46572 .69249 .46914 .68789 .47185 .69481 .46842 .69943 Mtetra
.7 .452 .547 r
.46842 .69943 .47185 .69481 .47457 .70124 .47113 .70588 Mtetra
.691 .442 .54 r
.47113 .70588 .47457 .70124 .4773 .70699 .47386 .71164 Mtetra
.679 .425 .531 r
.47386 .71164 .4773 .70699 .48004 .71185 .4766 .71652 Mtetra
.66 .401 .517 r
.4766 .71652 .48004 .71185 .4828 .71567 .47936 .72035 Mtetra
.631 .365 .496 r
.47936 .72035 .4828 .71567 .48556 .71829 .48212 .72299 Mtetra
.583 .305 .46 r
.48212 .72299 .48556 .71829 .48834 .71961 .4849 .72432 Mtetra
.495 .2 .394 r
.4849 .72432 .48834 .71961 .49112 .71955 .48768 .72426 Mtetra
.307 0 .253 r
.48768 .72426 .49112 .71955 .49391 .71807 .49047 .72278 Mtetra
0 0 0 r
.49047 .72278 .49391 .71807 .4967 .71516 .49327 .71987 Mtetra
.748 .919 .555 r
.49327 .71987 .4967 .71516 .4995 .71087 .49607 .71557 Mtetra
.944 .961 .714 r
.49607 .71557 .4995 .71087 .50229 .70527 .49886 .70996 Mtetra
.956 .897 .727 r
.49886 .70996 .50229 .70527 .50508 .69848 .50166 .70316 Mtetra
.943 .847 .719 r
.50166 .70316 .50508 .69848 .50787 .69066 .50445 .69533 Mtetra
.93 .815 .711 r
.50445 .69533 .50787 .69066 .51065 .68199 .50725 .68664 Mtetra
.921 .794 .704 r
.50725 .68664 .51065 .68199 .51343 .6727 .51003 .67733 Mtetra
.915 .783 .701 r
.51003 .67733 .51343 .6727 .51621 .66299 .51281 .66761 Mtetra
.913 .779 .699 r
.51281 .66761 .51621 .66299 .51898 .65314 .51559 .65773 Mtetra
.914 .781 .7 r
.51559 .65773 .51898 .65314 .52175 .64338 .51836 .64795 Mtetra
.918 .79 .703 r
.51836 .64795 .52175 .64338 .52451 .63396 .52113 .63852 Mtetra
.926 .807 .708 r
.52113 .63852 .52451 .63396 .52728 .62512 .5239 .62967 Mtetra
.938 .835 .717 r
.5239 .62967 .52728 .62512 .53004 .61709 .52668 .62162 Mtetra
.952 .88 .726 r
.52668 .62162 .53004 .61709 .53281 .61005 .52945 .61457 Mtetra
.954 .943 .725 r
.52945 .61457 .53281 .61005 .53559 .60417 .53223 .60868 Mtetra
.843 .964 .636 r
.53223 .60868 .53559 .60417 .53837 .59957 .53502 .60407 Mtetra
0 0 0 r
.53502 .60407 .53837 .59957 .54117 .59633 .53782 .60083 Mtetra
.216 0 .176 r
.53782 .60083 .54117 .59633 .54398 .59449 .54064 .59898 Mtetra
.453 .146 .354 r
.54064 .59898 .54398 .59449 .54681 .59402 .54347 .59852 Mtetra
.558 .27 .434 r
.54347 .59852 .54681 .59402 .54966 .59486 .54631 .59937 Mtetra
.612 .336 .474 r
.54631 .59937 .54966 .59486 .55252 .59688 .54918 .6014 Mtetra
.643 .375 .497 r
.54918 .6014 .55252 .59688 .5554 .59993 .55206 .60446 Mtetra
.661 .398 .511 r
.55206 .60446 .5554 .59993 .5583 .60377 .55495 .60832 Mtetra
.671 .411 .519 r
.55495 .60832 .5583 .60377 .56121 .60817 .55787 .61273 Mtetra
.676 .417 .522 r
.55787 .61273 .56121 .60817 .56414 .61285 .56079 .61742 Mtetra
.675 .416 .521 r
.56079 .61742 .56414 .61285 .56707 .61749 .56373 .62208 Mtetra
.669 .408 .517 r
.56373 .62208 .56707 .61749 .57002 .6218 .56667 .62641 Mtetra
.657 .392 .508 r
.56667 .62641 .57002 .6218 .57296 .62549 .56961 .63011 Mtetra
.634 .364 .491 r
.56961 .63011 .57296 .62549 .5759 .62828 .57255 .63291 Mtetra
.596 .317 .463 r
.57255 .63291 .5759 .62828 .57884 .62994 .57549 .63458 Mtetra
.526 .233 .412 r
.57549 .63458 .57884 .62994 .58176 .6303 .57841 .63494 Mtetra
.384 .071 .306 r
.57841 .63494 .58176 .6303 .58466 .62925 .58132 .63389 Mtetra
.057 0 .063 r
.58132 .63389 .58466 .62925 .58755 .62675 .58421 .63139 Mtetra
0 0 0 r
.58421 .63139 .58755 .62675 .59042 .62286 .58708 .6275 Mtetra
.89 .971 .659 r
.58708 .6275 .59042 .62286 .59327 .61772 .58994 .62235 Mtetra
.957 .943 .715 r
.58994 .62235 .59327 .61772 .59611 .61155 .59277 .61616 Mtetra
.96 .904 .72 r
.59277 .61616 .59611 .61155 .59893 .60462 .5956 .60923 Mtetra
.957 .884 .719 r
.5956 .60923 .59893 .60462 .60174 .59728 .59841 .60188 Mtetra
.957 .882 .718 r
.59841 .60188 .60174 .59728 .60455 .58992 .60123 .5945 Mtetra
.96 .899 .72 r
.60123 .5945 .60455 .58992 .60736 .5829 .60405 .58747 Mtetra
.959 .936 .717 r
.60405 .58747 .60736 .5829 .61019 .57659 .60688 .58115 Mtetra
.908 .972 .674 r
.60688 .58115 .61019 .57659 .61303 .57132 .60973 .57587 Mtetra
.589 .818 .428 r
.60973 .57587 .61303 .57132 .61591 .56732 .61261 .57186 Mtetra
.02 0 .031 r
.61261 .57186 .61591 .56732 .61881 .56473 .61552 .56927 Mtetra
.366 .049 .289 r
.61552 .56927 .61881 .56473 .62175 .56357 .61846 .56811 Mtetra
.51 .211 .396 r
.61846 .56811 .62175 .56357 .62473 .56372 .62144 .56827 Mtetra
.575 .289 .444 r
.62144 .56827 .62473 .56372 .62773 .56493 .62444 .56949 Mtetra
.605 .324 .465 r
.62444 .56949 .62773 .56493 .63076 .56683 .62747 .5714 Mtetra
.612 .333 .47 r
.62747 .5714 .63076 .56683 .6338 .56894 .63051 .57352 Mtetra
.601 .319 .462 r
.63051 .57352 .6338 .56894 .63684 .57075 .63355 .57533 Mtetra
.564 .275 .435 r
.63355 .57533 .63684 .57075 .63987 .57175 .63658 .57634 Mtetra
.479 .176 .374 r
.63658 .57634 .63987 .57175 .64288 .57153 .63959 .57613 Mtetra
.282 0 .228 r
.63959 .57613 .64288 .57153 .64585 .56986 .64256 .57445 Mtetra
0 0 0 r
.64256 .57445 .64585 .56986 .64879 .56673 .64551 .57132 Mtetra
.657 .86 .473 r
.64551 .57132 .64879 .56673 .6517 .56243 .64842 .56702 Mtetra
.826 .951 .603 r
.64842 .56702 .6517 .56243 .6546 .55754 .65132 .56212 Mtetra
.788 .934 .574 r
.65132 .56212 .6546 .55754 .6575 .55281 .65423 .55738 Mtetra
0 0 0 r
.65423 .55738 .6575 .55281 .66043 .54903 .65716 .5536 Mtetra
.139 0 .122 r
.65716 .5536 .66043 .54903 .66341 .54675 .66014 .55132 Mtetra
.413 .101 .323 r
.66014 .55132 .66341 .54675 .66643 .54591 .66316 .55048 Mtetra
.465 .159 .362 r
.66316 .55048 .66643 .54591 .66947 .54554 .66621 .55011 Mtetra
.297 0 .239 r
.66621 .55011 .66947 .54554 .67248 .54393 .66922 .54851 Mtetra
0 0 0 r
.66922 .54851 .67248 .54393 .67545 .54106 .6722 .54564 Mtetra
.297 0 .238 r
.6722 .54564 .67545 .54106 .67847 .53945 .67522 .54403 Mtetra
.465 .158 .361 r
.67522 .54403 .67847 .53945 .68153 .53908 .67828 .54366 Mtetra
.413 .1 .323 r
.67828 .54366 .68153 .53908 .68458 .53822 .68134 .54281 Mtetra
.142 0 .125 r
.68134 .54281 .68458 .53822 .68759 .53592 .68435 .5405 Mtetra
0 0 0 r
.68435 .5405 .68759 .53592 .69056 .53211 .68731 .53669 Mtetra
.776 .927 .559 r
.68731 .53669 .69056 .53211 .69349 .52734 .69025 .53191 Mtetra
.815 .945 .59 r
.69025 .53191 .69349 .52734 .69642 .5224 .69318 .52696 Mtetra
.643 .849 .458 r
.69318 .52696 .69642 .5224 .69936 .51805 .69614 .52261 Mtetra
0 0 0 r
.69614 .52261 .69936 .51805 .70236 .51487 .69913 .51942 Mtetra
.275 0 .221 r
.69913 .51942 .70236 .51487 .70541 .51314 .70218 .51769 Mtetra
.473 .167 .365 r
.70218 .51769 .70541 .51314 .70851 .51286 .70529 .51742 Mtetra
.559 .267 .427 r
.70529 .51742 .70851 .51286 .71167 .5138 .70845 .51837 Mtetra
.597 .311 .454 r
.70845 .51837 .71167 .5138 .71487 .51557 .71165 .52014 Mtetra
.608 .326 .463 r
.71165 .52014 .71487 .51557 .71809 .51765 .71487 .52224 Mtetra
.601 .316 .457 r
.71487 .52224 .71809 .51765 .7213 .51953 .71809 .52412 Mtetra
.571 .281 .436 r
.71809 .52412 .7213 .51953 .7245 .52072 .72129 .52532 Mtetra
.506 .205 .389 r
.72129 .52532 .7245 .52072 .72767 .52083 .72445 .52543 Mtetra
.366 .049 .289 r
.72445 .52543 .72767 .52083 .73078 .5196 .72757 .52421 Mtetra
.047 0 .058 r
.72757 .52421 .73078 .5196 .73385 .5169 .73064 .52151 Mtetra
0 0 0 r
.73064 .52151 .73385 .5169 .73685 .51276 .73364 .51736 Mtetra
.878 .963 .63 r
.73364 .51736 .73685 .51276 .7398 .50731 .7366 .5119 Mtetra
.957 .948 .695 r
.7366 .5119 .7398 .50731 .74271 .5008 .73951 .50538 Mtetra
.967 .915 .704 r
.73951 .50538 .74271 .5008 .74558 .49358 .74239 .49815 Mtetra
.966 .899 .705 r
.74239 .49815 .74558 .49358 .74844 .48601 .74525 .49056 Mtetra
.966 .901 .705 r
.74525 .49056 .74844 .48601 .7513 .47848 .74812 .48302 Mtetra
.966 .92 .704 r
.74812 .48302 .7513 .47848 .75417 .47137 .751 .4759 Mtetra
.953 .953 .691 r
.751 .4759 .75417 .47137 .75708 .46502 .75391 .46953 Mtetra
.86 .958 .618 r
.75391 .46953 .75708 .46502 .76003 .4597 .75687 .46421 Mtetra
0 0 0 r
.75687 .46421 .76003 .4597 .76305 .45564 .75989 .46015 Mtetra
.048 0 .054 r
.75989 .46015 .76305 .45564 .76613 .45297 .76297 .45747 Mtetra
.363 .043 .282 r
.76297 .45747 .76613 .45297 .76929 .45173 .76613 .45623 Mtetra
.51 .206 .387 r
.76613 .45623 .76929 .45173 .77252 .45191 .76936 .45642 Mtetra
.584 .293 .44 r
.76936 .45642 .77252 .45191 .77582 .4534 .77267 .45792 Mtetra
.625 .343 .47 r
.77267 .45792 .77582 .4534 .77919 .45604 .77604 .46057 Mtetra
.649 .373 .487 r
.77604 .46057 .77919 .45604 .78261 .45961 .77946 .46415 Mtetra
.663 .39 .496 r
.77946 .46415 .78261 .45961 .78608 .46384 .78293 .4684 Mtetra
.67 .398 .501 r
.78293 .4684 .78608 .46384 .78958 .46845 .78643 .47302 Mtetra
.67 .399 .501 r
.78643 .47302 .78958 .46845 .79309 .47311 .78994 .4777 Mtetra
.666 .393 .498 r
.78994 .4777 .79309 .47311 .7966 .47753 .79345 .48213 Mtetra
.655 .379 .49 r
.79345 .48213 .7966 .47753 .8001 .4814 .79695 .48602 Mtetra
.635 .355 .477 r
.79695 .48602 .8001 .4814 .80356 .48446 .80041 .48909 Mtetra
.602 .316 .454 r
.80041 .48909 .80356 .48446 .80698 .48647 .80383 .49111 Mtetra
.547 .25 .415 r
.80383 .49111 .80698 .48647 .81034 .48724 .80719 .49189 Mtetra
.444 .134 .344 r
.80719 .49189 .81034 .48724 .81363 .48664 .81049 .49129 Mtetra
.237 0 .198 r
.81049 .49129 .81363 .48664 .81685 .48458 .81371 .48923 Mtetra
0 0 0 r
.81371 .48923 .81685 .48458 .81998 .48104 .81685 .48569 Mtetra
.718 .885 .493 r
.81685 .48569 .81998 .48104 .82304 .47606 .81991 .4807 Mtetra
.935 .96 .66 r
.81991 .4807 .82304 .47606 .82602 .46973 .8229 .47436 Mtetra
.97 .918 .692 r
.8229 .47436 .82602 .46973 .82893 .46218 .82581 .4668 Mtetra
.966 .875 .693 r
.82581 .4668 .82893 .46218 .83178 .45361 .82867 .45821 Mtetra
.958 .844 .689 r
.82867 .45821 .83178 .45361 .83458 .44421 .83147 .44879 Mtetra
.951 .826 .685 r
.83147 .44879 .83458 .44421 .83733 .43423 .83423 .43879 Mtetra
.947 .816 .682 r
.83423 .43879 .83733 .43423 .84007 .42392 .83697 .42846 Mtetra
.946 .813 .682 r
.83697 .42846 .84007 .42392 .84279 .41355 .8397 .41807 Mtetra
.948 .818 .683 r
.8397 .41807 .84279 .41355 .84552 .40336 .84244 .40786 Mtetra
.953 .831 .686 r
.84244 .40786 .84552 .40336 .84827 .39361 .8452 .39809 Mtetra
.96 .852 .69 r
.8452 .39809 .84827 .39361 .85106 .38452 .84799 .38899 Mtetra
.968 .886 .694 r
.84799 .38899 .85106 .38452 .8539 .37631 .85084 .38075 Mtetra
.967 .93 .691 r
.85084 .38075 .8539 .37631 .85681 .36914 .85375 .37357 Mtetra
.913 .964 .647 r
.85375 .37357 .85681 .36914 .85979 .36317 .85674 .36759 Mtetra
.649 .848 .451 r
.85674 .36759 .85979 .36317 .86286 .3585 .85981 .36292 Mtetra
0 0 0 r
.85981 .36292 .86286 .3585 .86602 .35522 .86298 .35964 Mtetra
.265 0 .207 r
.86298 .35964 .86602 .35522 .86928 .35336 .86624 .35778 Mtetra
.457 .142 .343 r
.86624 .35778 .86928 .35336 .87264 .35293 .8696 .35735 Mtetra
.556 .254 .412 r
.8696 .35735 .87264 .35293 .8761 .35389 .87307 .35831 Mtetra
.612 .321 .451 r
.87307 .35831 .8761 .35389 .87967 .35617 .87663 .3606 Mtetra
.646 .363 .475 r
.87663 .3606 .87967 .35617 .88332 .35967 .88029 .36412 Mtetra
.669 .391 .491 r
.88029 .36412 .88332 .35967 .88706 .36427 .88403 .36873 Mtetra
.684 .41 .501 r
.88403 .36873 .88706 .36427 .89089 .3698 .88785 .37429 Mtetra
.694 .422 .508 r
.88785 .37429 .89089 .3698 .89478 .3761 .89174 .3806 Mtetra
.7 .431 .512 r
.89174 .3806 .89478 .3761 .89872 .38295 .89569 .38748 Mtetra
.704 .435 .515 r
.89569 .38748 .89872 .38295 .90271 .39017 .89968 .39472 Mtetra
.705 .436 .515 r
.89968 .39472 .90271 .39017 .90672 .39751 .90369 .40209 Mtetra
.704 .435 .515 r
.90369 .40209 .90672 .39751 .91075 .40477 .90771 .40936 Mtetra
.719 .469 .546 r
.45426 .67441 .45769 .67085 .46035 .67798 .45693 .68156 Mtetra
.72 .47 .547 r
.45693 .68156 .46035 .67798 .46303 .68527 .4596 .68886 Mtetra
.72 .469 .546 r
.4596 .68886 .46303 .68527 .46572 .69249 .46228 .6961 Mtetra
.717 .465 .544 r
.46228 .6961 .46572 .69249 .46842 .69943 .46498 .70306 Mtetra
.712 .458 .539 r
.46498 .70306 .46842 .69943 .47113 .70588 .46769 .70953 Mtetra
.704 .447 .532 r
.46769 .70953 .47113 .70588 .47386 .71164 .47042 .7153 Mtetra
.692 .43 .521 r
.47042 .7153 .47386 .71164 .4766 .71652 .47316 .7202 Mtetra
.674 .404 .505 r
.47316 .7202 .4766 .71652 .47936 .72035 .47591 .72404 Mtetra
.644 .362 .478 r
.47591 .72404 .47936 .72035 .48212 .72299 .47868 .72668 Mtetra
.59 .291 .43 r
.47868 .72668 .48212 .72299 .4849 .72432 .48145 .72802 Mtetra
.481 .154 .335 r
.48145 .72802 .4849 .72432 .48768 .72426 .48424 .72797 Mtetra
.204 0 .1 r
.48424 .72797 .48768 .72426 .49047 .72278 .48703 .72648 Mtetra
0 0 0 r
.48703 .72648 .49047 .72278 .49327 .71987 .48982 .72357 Mtetra
.898 .987 .755 r
.48982 .72357 .49327 .71987 .49607 .71557 .49263 .71926 Mtetra
.938 .907 .766 r
.49263 .71926 .49607 .71557 .49886 .70996 .49543 .71365 Mtetra
.924 .841 .744 r
.49543 .71365 .49886 .70996 .50166 .70316 .49823 .70684 Mtetra
.909 .8 .727 r
.49823 .70684 .50166 .70316 .50445 .69533 .50103 .69899 Mtetra
.898 .774 .715 r
.50103 .69899 .50445 .69533 .50725 .68664 .50382 .6903 Mtetra
.891 .758 .708 r
.50382 .6903 .50725 .68664 .51003 .67733 .50662 .68097 Mtetra
.887 .749 .704 r
.50662 .68097 .51003 .67733 .51281 .66761 .5094 .67123 Mtetra
.886 .746 .702 r
.5094 .67123 .51281 .66761 .51559 .65773 .51219 .66134 Mtetra
.886 .747 .703 r
.51219 .66134 .51559 .65773 .51836 .64795 .51497 .65154 Mtetra
.89 .754 .706 r
.51497 .65154 .51836 .64795 .52113 .63852 .51774 .64209 Mtetra
.896 .768 .713 r
.51774 .64209 .52113 .63852 .5239 .62967 .52052 .63323 Mtetra
.905 .79 .723 r
.52052 .63323 .5239 .62967 .52668 .62162 .5233 .62516 Mtetra
.918 .826 .739 r
.5233 .62516 .52668 .62162 .52945 .61457 .52608 .6181 Mtetra
.934 .885 .761 r
.52608 .6181 .52945 .61457 .53223 .60868 .52886 .6122 Mtetra
.923 .969 .773 r
.52886 .6122 .53223 .60868 .53502 .60407 .53166 .60759 Mtetra
.658 .912 .599 r
.53166 .60759 .53502 .60407 .53782 .60083 .53446 .60435 Mtetra
.055 0 0 r
.53446 .60435 .53782 .60083 .54064 .59898 .53727 .6025 Mtetra
.422 .078 .274 r
.53727 .6025 .54064 .59898 .54347 .59852 .5401 .60204 Mtetra
.56 .247 .394 r
.5401 .60204 .54347 .59852 .54631 .59937 .54295 .60289 Mtetra
.623 .329 .45 r
.54295 .60289 .54631 .59937 .54918 .6014 .54581 .60493 Mtetra
.656 .374 .48 r
.54581 .60493 .54918 .6014 .55206 .60446 .54869 .608 Mtetra
.675 .4 .497 r
.54869 .608 .55206 .60446 .55495 .60832 .55159 .61187 Mtetra
.685 .414 .506 r
.55159 .61187 .55495 .60832 .55787 .61273 .5545 .6163 Mtetra
.689 .42 .51 r
.5545 .6163 .55787 .61273 .56079 .61742 .55742 .621 Mtetra
.689 .419 .51 r
.55742 .621 .56079 .61742 .56373 .62208 .56035 .62567 Mtetra
.683 .411 .504 r
.56035 .62567 .56373 .62208 .56667 .62641 .56329 .63001 Mtetra
.67 .393 .493 r
.56329 .63001 .56667 .62641 .56961 .63011 .56624 .63372 Mtetra
.647 .361 .472 r
.56624 .63372 .56961 .63011 .57255 .63291 .56918 .63653 Mtetra
.605 .305 .435 r
.56918 .63653 .57255 .63291 .57549 .63458 .57211 .63821 Mtetra
.521 .199 .362 r
.57211 .63821 .57549 .63458 .57841 .63494 .57503 .63858 Mtetra
.322 0 .194 r
.57503 .63858 .57841 .63494 .58132 .63389 .57794 .63753 Mtetra
0 0 0 r
.57794 .63753 .58132 .63389 .58421 .63139 .58084 .63503 Mtetra
.807 .978 .691 r
.58084 .63503 .58421 .63139 .58708 .6275 .58371 .63113 Mtetra
.936 .952 .766 r
.58371 .63113 .58708 .6275 .58994 .62235 .58657 .62598 Mtetra
.938 .887 .755 r
.58657 .62598 .58994 .62235 .59277 .61616 .58941 .61978 Mtetra
.93 .848 .742 r
.58941 .61978 .59277 .61616 .5956 .60923 .59224 .61283 Mtetra
.924 .83 .735 r
.59224 .61283 .5956 .60923 .59841 .60188 .59506 .60547 Mtetra
.923 .829 .734 r
.59506 .60547 .59841 .60188 .60123 .5945 .59788 .59808 Mtetra
.928 .844 .74 r
.59788 .59808 .60123 .5945 .60405 .58747 .60071 .59104 Mtetra
.937 .879 .752 r
.60071 .59104 .60405 .58747 .60688 .58115 .60354 .58471 Mtetra
.938 .942 .766 r
.60354 .58471 .60688 .58115 .60973 .57587 .6064 .57942 Mtetra
.835 .986 .713 r
.6064 .57942 .60973 .57587 .61261 .57186 .60928 .57541 Mtetra
0 0 0 r
.60928 .57541 .61261 .57186 .61552 .56927 .61219 .57282 Mtetra
.295 0 .164 r
.61219 .57282 .61552 .56927 .61846 .56811 .61513 .57166 Mtetra
.5 .17 .338 r
.61513 .57166 .61846 .56811 .62144 .56827 .61811 .57182 Mtetra
.58 .271 .408 r
.61811 .57182 .62144 .56827 .62444 .56949 .62112 .57305 Mtetra
.614 .314 .438 r
.62112 .57305 .62444 .56949 .62747 .5714 .62414 .57496 Mtetra
.623 .326 .445 r
.62414 .57496 .62747 .5714 .63051 .57352 .62718 .57709 Mtetra
.61 .309 .434 r
.62718 .57709 .63051 .57352 .63355 .57533 .63023 .57892 Mtetra
.567 .253 .397 r
.63023 .57892 .63355 .57533 .63658 .57634 .63326 .57993 Mtetra
.459 .121 .304 r
.63326 .57993 .63658 .57634 .63959 .57613 .63627 .57972 Mtetra
.162 0 .057 r
.63627 .57972 .63959 .57613 .64256 .57445 .63924 .57805 Mtetra
0 0 0 r
.63924 .57805 .64256 .57445 .64551 .57132 .64219 .57491 Mtetra
.866 .989 .726 r
.64219 .57491 .64551 .57132 .64842 .56702 .64511 .57061 Mtetra
.924 .973 .758 r
.64511 .57061 .64842 .56702 .65132 .56212 .64801 .5657 Mtetra
.913 .981 .753 r
.64801 .5657 .65132 .56212 .65423 .55738 .65092 .56095 Mtetra
.752 .956 .65 r
.65092 .56095 .65423 .55738 .65716 .5536 .65386 .55717 Mtetra
0 0 0 r
.65386 .55717 .65716 .5536 .66014 .55132 .65684 .55489 Mtetra
.365 .01 .223 r
.65684 .55489 .66014 .55132 .66316 .55048 .65986 .55405 Mtetra
.44 .096 .285 r
.65986 .55405 .66316 .55048 .66621 .55011 .66291 .55369 Mtetra
.187 0 .076 r
.66291 .55369 .66621 .55011 .66922 .54851 .66592 .55208 Mtetra
0 0 0 r
.66592 .55208 .66922 .54851 .6722 .54564 .6689 .54921 Mtetra
.186 0 .075 r
.6689 .54921 .6722 .54564 .67522 .54403 .67192 .5476 Mtetra
.439 .095 .284 r
.67192 .5476 .67522 .54403 .67828 .54366 .67499 .54723 Mtetra
.365 .009 .222 r
.67499 .54723 .67828 .54366 .68134 .54281 .67805 .54638 Mtetra
0 0 0 r
.67805 .54638 .68134 .54281 .68435 .5405 .68106 .54408 Mtetra
.742 .95 .64 r
.68106 .54408 .68435 .5405 .68731 .53669 .68403 .54026 Mtetra
.911 .982 .748 r
.68403 .54026 .68731 .53669 .69025 .53191 .68697 .53547 Mtetra
.922 .975 .753 r
.68697 .53547 .69025 .53191 .69318 .52696 .6899 .53051 Mtetra
.861 .988 .72 r
.6899 .53051 .69318 .52696 .69614 .52261 .69286 .52616 Mtetra
0 0 0 r
.69286 .52616 .69614 .52261 .69913 .51942 .69586 .52297 Mtetra
.152 0 .045 r
.69586 .52297 .69913 .51942 .70218 .51769 .69891 .52124 Mtetra
.451 .108 .292 r
.69891 .52124 .70218 .51769 .70529 .51742 .70202 .52097 Mtetra
.561 .242 .386 r
.70202 .52097 .70529 .51742 .70845 .51837 .70518 .52193 Mtetra
.605 .299 .424 r
.70518 .52193 .70845 .51837 .71165 .52014 .70838 .52371 Mtetra
.618 .316 .435 r
.70838 .52371 .71165 .52014 .71487 .52224 .7116 .52581 Mtetra
.61 .305 .428 r
.7116 .52581 .71487 .52224 .71809 .52412 .71482 .5277 Mtetra
.575 .26 .398 r
.71482 .5277 .71809 .52412 .72129 .52532 .71802 .5289 Mtetra
.494 .16 .329 r
.71802 .5289 .72129 .52532 .72445 .52543 .72119 .52903 Mtetra
.295 0 .164 r
.72119 .52903 .72445 .52543 .72757 .52421 .72431 .5278 Mtetra
0 0 0 r
.72431 .5278 .72757 .52421 .73064 .52151 .72738 .5251 Mtetra
.801 .972 .673 r
.72738 .5251 .73064 .52151 .73364 .51736 .73039 .52094 Mtetra
.939 .956 .753 r
.73039 .52094 .73364 .51736 .7366 .5119 .73335 .51547 Mtetra
.946 .897 .746 r
.73335 .51547 .7366 .5119 .73951 .50538 .73626 .50895 Mtetra
.94 .861 .735 r
.73626 .50895 .73951 .50538 .74239 .49815 .73915 .5017 Mtetra
.936 .845 .729 r
.73915 .5017 .74239 .49815 .74525 .49056 .74201 .49411 Mtetra
.936 .847 .73 r
.74201 .49411 .74525 .49056 .74812 .48302 .74488 .48655 Mtetra
.941 .865 .736 r
.74488 .48655 .74812 .48302 .751 .4759 .74777 .47942 Mtetra
.947 .904 .748 r
.74777 .47942 .751 .4759 .75391 .46953 .75068 .47305 Mtetra
.935 .963 .753 r
.75068 .47305 .75391 .46953 .75687 .46421 .75365 .46772 Mtetra
.784 .967 .666 r
.75365 .46772 .75687 .46421 .75989 .46015 .75667 .46364 Mtetra
0 0 0 r
.75667 .46364 .75989 .46015 .76297 .45747 .75976 .46096 Mtetra
.289 0 .153 r
.75976 .46096 .76297 .45747 .76613 .45623 .76292 .45973 Mtetra
.498 .162 .327 r
.76292 .45973 .76613 .45623 .76936 .45642 .76615 .45992 Mtetra
.59 .276 .405 r
.76615 .45992 .76936 .45642 .77267 .45792 .76946 .46143 Mtetra
.637 .337 .445 r
.76946 .46143 .77267 .45792 .77604 .46057 .77282 .46409 Mtetra
.663 .371 .467 r
.77282 .46409 .77604 .46057 .77946 .46415 .77625 .46768 Mtetra
.677 .39 .48 r
.77625 .46768 .77946 .46415 .78293 .4684 .77971 .47194 Mtetra
.684 .4 .485 r
.77971 .47194 .78293 .4684 .78643 .47302 .78321 .47657 Mtetra
.685 .401 .486 r
.78321 .47657 .78643 .47302 .78994 .4777 .78673 .48127 Mtetra
.68 .394 .482 r
.78673 .48127 .78994 .4777 .79345 .48213 .79024 .48572 Mtetra
.668 .379 .472 r
.79024 .48572 .79345 .48213 .79695 .48602 .79374 .48962 Mtetra
.648 .351 .454 r
.79374 .48962 .79695 .48602 .80041 .48909 .7972 .4927 Mtetra
.612 .304 .424 r
.7972 .4927 .80041 .48909 .80383 .49111 .80062 .49473 Mtetra
.546 .221 .369 r
.80062 .49473 .80383 .49111 .80719 .49189 .80398 .49551 Mtetra
.41 .06 .258 r
.80398 .49551 .80719 .49189 .81049 .49129 .80728 .49491 Mtetra
.091 0 .002 r
.80728 .49491 .81049 .49129 .81371 .48923 .8105 .49285 Mtetra
0 0 0 r
.8105 .49285 .81371 .48923 .81685 .48569 .81364 .4893 Mtetra
.896 .984 .72 r
.81364 .4893 .81685 .48569 .81991 .4807 .81671 .48431 Mtetra
.951 .925 .742 r
.81671 .48431 .81991 .4807 .8229 .47436 .8197 .47796 Mtetra
.946 .865 .728 r
.8197 .47796 .8229 .47436 .82581 .4668 .82262 .47039 Mtetra
.934 .825 .713 r
.82262 .47039 .82581 .4668 .82867 .45821 .82548 .46178 Mtetra
.925 .8 .703 r
.82548 .46178 .82867 .45821 .83147 .44879 .82829 .45235 Mtetra
.919 .784 .696 r
.82829 .45235 .83147 .44879 .83423 .43879 .83106 .44233 Mtetra
.916 .776 .693 r
.83106 .44233 .83423 .43879 .83697 .42846 .8338 .43199 Mtetra
.915 .775 .692 r
.8338 .43199 .83697 .42846 .8397 .41807 .83654 .42157 Mtetra
.916 .778 .694 r
.83654 .42157 .8397 .41807 .84244 .40786 .83928 .41135 Mtetra
.921 .789 .698 r
.83928 .41135 .84244 .40786 .8452 .39809 .84205 .40156 Mtetra
.927 .806 .706 r
.84205 .40156 .8452 .39809 .84799 .38899 .84485 .39244 Mtetra
.937 .835 .717 r
.84485 .39244 .84799 .38899 .85084 .38075 .8477 .38419 Mtetra
.948 .878 .733 r
.8477 .38419 .85084 .38075 .85375 .37357 .85062 .377 Mtetra
.948 .94 .747 r
.85062 .377 .85375 .37357 .85674 .36759 .85361 .37101 Mtetra
.867 .986 .711 r
.85361 .37101 .85674 .36759 .85981 .36292 .85669 .36634 Mtetra
0 0 0 r
.85669 .36634 .85981 .36292 .86298 .35964 .85986 .36305 Mtetra
.134 0 .021 r
.85986 .36305 .86298 .35964 .86624 .35778 .86312 .36119 Mtetra
.427 .072 .257 r
.86312 .36119 .86624 .35778 .8696 .35735 .86649 .36076 Mtetra
.556 .226 .365 r
.86649 .36076 .8696 .35735 .87307 .35831 .86995 .36173 Mtetra
.622 .31 .421 r
.86995 .36173 .87307 .35831 .87663 .3606 .87352 .36403 Mtetra
.66 .36 .453 r
.87352 .36403 .87663 .3606 .88029 .36412 .87717 .36756 Mtetra
.683 .391 .473 r
.87717 .36756 .88029 .36412 .88403 .36873 .88092 .37219 Mtetra
.698 .412 .486 r
.88092 .37219 .88403 .36873 .88785 .37429 .88474 .37775 Mtetra
.708 .426 .495 r
.88474 .37775 .88785 .37429 .89174 .3806 .88863 .38409 Mtetra
.715 .435 .5 r
.88863 .38409 .89174 .3806 .89569 .38748 .89257 .39099 Mtetra
.718 .439 .503 r
.89257 .39099 .89569 .38748 .89968 .39472 .89656 .39824 Mtetra
.719 .441 .504 r
.89656 .39824 .89968 .39472 .90369 .40209 .90057 .40563 Mtetra
.718 .439 .503 r
.90057 .40563 .90369 .40209 .90771 .40936 .90459 .41293 Mtetra
.736 .477 .537 r
.45084 .67682 .45426 .67441 .45693 .68156 .4535 .68399 Mtetra
.737 .478 .539 r
.4535 .68399 .45693 .68156 .4596 .68886 .45617 .6913 Mtetra
.736 .477 .538 r
.45617 .6913 .4596 .68886 .46228 .6961 .45885 .69855 Mtetra
.733 .473 .535 r
.45885 .69855 .46228 .6961 .46498 .70306 .46154 .70553 Mtetra
.729 .466 .529 r
.46154 .70553 .46498 .70306 .46769 .70953 .46425 .71201 Mtetra
.722 .454 .52 r
.46425 .71201 .46769 .70953 .47042 .7153 .46697 .7178 Mtetra
.711 .435 .507 r
.46697 .7178 .47042 .7153 .47316 .7202 .46971 .7227 Mtetra
.693 .406 .485 r
.46971 .7227 .47316 .7202 .47591 .72404 .47246 .72655 Mtetra
.662 .358 .448 r
.47246 .72655 .47591 .72404 .47868 .72668 .47522 .7292 Mtetra
.6 .267 .377 r
.47522 .7292 .47868 .72668 .48145 .72802 .478 .73054 Mtetra
.447 .06 .212 r
.478 .73054 .48145 .72802 .48424 .72797 .48078 .73049 Mtetra
0 0 0 r
.48078 .73049 .48424 .72797 .48703 .72648 .48357 .72901 Mtetra
.794 .999 .82 r
.48357 .72901 .48703 .72648 .48982 .72357 .48637 .72609 Mtetra
.901 .911 .82 r
.48637 .72609 .48982 .72357 .49263 .71926 .48918 .72178 Mtetra
.893 .828 .775 r
.48918 .72178 .49263 .71926 .49543 .71365 .49198 .71616 Mtetra
.88 .779 .746 r
.49198 .71616 .49543 .71365 .49823 .70684 .49479 .70934 Mtetra
.871 .75 .727 r
.49479 .70934 .49823 .70684 .50103 .69899 .49759 .70149 Mtetra
.864 .732 .715 r
.49759 .70149 .50103 .69899 .50382 .6903 .50039 .69278 Mtetra
.86 .721 .708 r
.50039 .69278 .50382 .6903 .50662 .68097 .50319 .68343 Mtetra
.857 .714 .703 r
.50319 .68343 .50662 .68097 .5094 .67123 .50598 .67368 Mtetra
.856 .712 .702 r
.50598 .67368 .5094 .67123 .51219 .66134 .50877 .66378 Mtetra
.857 .713 .703 r
.50877 .66378 .51219 .66134 .51497 .65154 .51156 .65397 Mtetra
.859 .718 .706 r
.51156 .65397 .51497 .65154 .51774 .64209 .51434 .64451 Mtetra
.862 .727 .712 r
.51434 .64451 .51774 .64209 .52052 .63323 .51712 .63563 Mtetra
.868 .743 .723 r
.51712 .63563 .52052 .63323 .5233 .62516 .5199 .62756 Mtetra
.877 .769 .74 r
.5199 .62756 .5233 .62516 .52608 .6181 .52269 .62049 Mtetra
.888 .811 .766 r
.52269 .62049 .52608 .6181 .52886 .6122 .52548 .61458 Mtetra
.899 .883 .808 r
.52548 .61458 .52886 .6122 .53166 .60759 .52827 .60996 Mtetra
.855 .988 .847 r
.52827 .60996 .53166 .60759 .53446 .60435 .53108 .60672 Mtetra
0 0 0 r
.53108 .60672 .53446 .60435 .53727 .6025 .53389 .60487 Mtetra
.347 0 .094 r
.53389 .60487 .53727 .6025 .5401 .60204 .53672 .60441 Mtetra
.56 .203 .32 r
.53672 .60441 .5401 .60204 .54295 .60289 .53957 .60526 Mtetra
.638 .316 .409 r
.53957 .60526 .54295 .60289 .54581 .60493 .54243 .60731 Mtetra
.675 .371 .452 r
.54243 .60731 .54581 .60493 .54869 .608 .54531 .61038 Mtetra
.694 .402 .475 r
.54531 .61038 .54869 .608 .55159 .61187 .5482 .61427 Mtetra
.704 .418 .488 r
.5482 .61427 .55159 .61187 .5545 .6163 .55111 .6187 Mtetra
.708 .425 .493 r
.55111 .6187 .5545 .6163 .55742 .621 .55403 .62341 Mtetra
.708 .424 .492 r
.55403 .62341 .55742 .621 .56035 .62567 .55696 .62809 Mtetra
.702 .414 .485 r
.55696 .62809 .56035 .62567 .56329 .63001 .5599 .63244 Mtetra
.689 .394 .469 r
.5599 .63244 .56329 .63001 .56624 .63372 .56284 .63616 Mtetra
.665 .357 .441 r
.56284 .63616 .56624 .63372 .56918 .63653 .56578 .63898 Mtetra
.617 .285 .386 r
.56578 .63898 .56918 .63653 .57211 .63821 .56871 .64066 Mtetra
.506 .131 .264 r
.56871 .64066 .57211 .63821 .57503 .63858 .57163 .64103 Mtetra
.165 0 0 r
.57163 .64103 .57503 .63858 .57794 .63753 .57455 .63998 Mtetra
.627 .942 .725 r
.57455 .63998 .57794 .63753 .58084 .63503 .57744 .63748 Mtetra
.892 .957 .835 r
.57744 .63748 .58084 .63503 .58371 .63113 .58032 .63358 Mtetra
.903 .866 .793 r
.58032 .63358 .58371 .63113 .58657 .62598 .58318 .62842 Mtetra
.893 .813 .762 r
.58318 .62842 .58657 .62598 .58941 .61978 .58603 .62222 Mtetra
.886 .785 .745 r
.58603 .62222 .58941 .61978 .59224 .61283 .58886 .61526 Mtetra
.882 .772 .737 r
.58886 .61526 .59224 .61283 .59506 .60547 .59169 .60789 Mtetra
.881 .771 .736 r
.59169 .60789 .59506 .60547 .59788 .59808 .59451 .60049 Mtetra
.885 .782 .743 r
.59451 .60049 .59788 .59808 .60071 .59104 .59734 .59344 Mtetra
.892 .807 .759 r
.59734 .59344 .60071 .59104 .60354 .58471 .60018 .58711 Mtetra
.901 .857 .789 r
.60018 .58711 .60354 .58471 .6064 .57942 .60304 .58181 Mtetra
.895 .946 .833 r
.60304 .58181 .6064 .57942 .60928 .57541 .60592 .57779 Mtetra
.671 .964 .759 r
.60592 .57779 .60928 .57541 .61219 .57282 .60883 .5752 Mtetra
.11 0 0 r
.60883 .5752 .61219 .57282 .61513 .57166 .61178 .57404 Mtetra
.474 .085 .221 r
.61178 .57404 .61513 .57166 .61811 .57182 .61475 .57421 Mtetra
.587 .238 .344 r
.61475 .57421 .61811 .57182 .62112 .57305 .61776 .57544 Mtetra
.628 .297 .391 r
.61776 .57544 .62112 .57305 .62414 .57496 .62078 .57736 Mtetra
.638 .312 .402 r
.62078 .57736 .62414 .57496 .62718 .57709 .62382 .57949 Mtetra
.623 .29 .385 r
.62382 .57949 .62718 .57709 .63023 .57892 .62687 .58132 Mtetra
.569 .213 .325 r
.62687 .58132 .63023 .57892 .63326 .57993 .6299 .58234 Mtetra
.409 .004 .156 r
.6299 .58234 .63326 .57993 .63627 .57972 .6329 .58213 Mtetra
0 0 0 r
.6329 .58213 .63627 .57972 .63924 .57805 .63588 .58046 Mtetra
.806 1 .823 r
.63588 .58046 .63924 .57805 .64219 .57491 .63883 .57732 Mtetra
.902 .933 .824 r
.63883 .57732 .64219 .57491 .64511 .57061 .64175 .57301 Mtetra
.906 .89 .804 r
.64175 .57301 .64511 .57061 .64801 .5657 .64466 .5681 Mtetra
.906 .902 .809 r
.64466 .5681 .64801 .5657 .65092 .56095 .64757 .56335 Mtetra
.883 .972 .838 r
.64757 .56335 .65092 .56095 .65386 .55717 .65051 .55956 Mtetra
.496 .865 .638 r
.65051 .55956 .65386 .55717 .65684 .55489 .65349 .55727 Mtetra
.244 0 0 r
.65349 .55727 .65684 .55489 .65986 .55405 .65652 .55644 Mtetra
.376 0 .119 r
.65652 .55644 .65986 .55405 .66291 .55369 .65956 .55608 Mtetra
0 0 0 r
.65956 .55608 .66291 .55369 .66592 .55208 .66258 .55447 Mtetra
.736 .988 .791 r
.66258 .55447 .66592 .55208 .6689 .54921 .66556 .55159 Mtetra
0 0 0 r
.66556 .55159 .6689 .54921 .67192 .5476 .66859 .54998 Mtetra
.375 0 .116 r
.66859 .54998 .67192 .5476 .67499 .54723 .67165 .54962 Mtetra
.243 0 0 r
.67165 .54962 .67499 .54723 .67805 .54638 .67471 .54877 Mtetra
.49 .86 .632 r
.67471 .54877 .67805 .54638 .68106 .54408 .67772 .54646 Mtetra
.882 .975 .836 r
.67772 .54646 .68106 .54408 .68403 .54026 .6807 .54264 Mtetra
.908 .905 .809 r
.6807 .54264 .68403 .54026 .68697 .53547 .68364 .53785 Mtetra
.908 .894 .804 r
.68364 .53785 .68697 .53547 .6899 .53051 .68658 .53289 Mtetra
.903 .936 .824 r
.68658 .53289 .6899 .53051 .69286 .52616 .68954 .52853 Mtetra
.805 1 .822 r
.68954 .52853 .69286 .52616 .69586 .52297 .69254 .52534 Mtetra
0 0 0 r
.69254 .52534 .69586 .52297 .69891 .52124 .69559 .5236 Mtetra
.394 0 .133 r
.69559 .5236 .69891 .52124 .70202 .52097 .6987 .52333 Mtetra
.561 .197 .307 r
.6987 .52333 .70202 .52097 .70518 .52193 .70186 .5243 Mtetra
.617 .276 .37 r
.70186 .5243 .70518 .52193 .70838 .52371 .70506 .52608 Mtetra
.633 .299 .388 r
.70506 .52608 .70838 .52371 .7116 .52581 .70828 .52819 Mtetra
.623 .284 .376 r
.70828 .52819 .7116 .52581 .71482 .5277 .7115 .53009 Mtetra
.58 .223 .328 r
.7115 .53009 .71482 .5277 .71802 .5289 .7147 .5313 Mtetra
.464 .069 .205 r
.7147 .5313 .71802 .5289 .72119 .52903 .71787 .53142 Mtetra
.109 0 0 r
.71787 .53142 .72119 .52903 .72431 .5278 .72099 .53019 Mtetra
.642 .948 .731 r
.72099 .53019 .72431 .5278 .72738 .5251 .72406 .52749 Mtetra
.895 .96 .829 r
.72406 .52749 .72738 .5251 .73039 .52094 .72707 .52333 Mtetra
.91 .873 .789 r
.72707 .52333 .73039 .52094 .73335 .51547 .73003 .51786 Mtetra
.902 .822 .759 r
.73003 .51786 .73335 .51547 .73626 .50895 .73295 .51133 Mtetra
.895 .795 .742 r
.73295 .51133 .73626 .50895 .73915 .5017 .73584 .50407 Mtetra
.892 .784 .735 r
.73584 .50407 .73915 .5017 .74201 .49411 .73871 .49646 Mtetra
.892 .785 .736 r
.73871 .49646 .74201 .49411 .74488 .48655 .74159 .4889 Mtetra
.896 .798 .744 r
.74159 .4889 .74488 .48655 .74777 .47942 .74448 .48175 Mtetra
.903 .827 .762 r
.74448 .48175 .74777 .47942 .75068 .47305 .7474 .47537 Mtetra
.91 .88 .793 r
.7474 .47537 .75068 .47305 .75365 .46772 .75036 .47004 Mtetra
.891 .965 .832 r
.75036 .47004 .75365 .46772 .75667 .46364 .75339 .46596 Mtetra
.639 .948 .736 r
.75339 .46596 .75667 .46364 .75976 .46096 .75648 .46328 Mtetra
.097 0 0 r
.75648 .46328 .75976 .46096 .76292 .45973 .75964 .46205 Mtetra
.47 .072 .202 r
.75964 .46205 .76292 .45973 .76615 .45992 .76288 .46224 Mtetra
.599 .245 .34 r
.76288 .46224 .76615 .45992 .76946 .46143 .76618 .46375 Mtetra
.655 .325 .403 r
.76618 .46375 .76946 .46143 .77282 .46409 .76955 .46642 Mtetra
.683 .368 .436 r
.76955 .46642 .77282 .46409 .77625 .46768 .77297 .47002 Mtetra
.697 .391 .453 r
.77297 .47002 .77625 .46768 .77971 .47194 .77643 .47429 Mtetra
.704 .401 .461 r
.77643 .47429 .77971 .47194 .78321 .47657 .77993 .47893 Mtetra
.705 .402 .462 r
.77993 .47893 .78321 .47657 .78673 .48127 .78344 .48364 Mtetra
.7 .395 .456 r
.78344 .48364 .78673 .48127 .79024 .48572 .78695 .48809 Mtetra
.688 .377 .443 r
.78695 .48809 .79024 .48572 .79374 .48962 .79045 .492 Mtetra
.666 .343 .417 r
.79045 .492 .79374 .48962 .7972 .4927 .79391 .49509 Mtetra
.625 .283 .371 r
.79391 .49509 .7972 .4927 .80062 .49473 .79733 .49713 Mtetra
.54 .165 .279 r
.79733 .49713 .80062 .49473 .80398 .49551 .80069 .49791 Mtetra
.325 0 .062 r
.80069 .49791 .80398 .49551 .80728 .49491 .80399 .49732 Mtetra
0 0 0 r
.80399 .49732 .80728 .49491 .8105 .49285 .80721 .49525 Mtetra
.825 1 .816 r
.80721 .49525 .8105 .49285 .81364 .4893 .81036 .49171 Mtetra
.914 .921 .806 r
.81036 .49171 .81364 .4893 .81671 .48431 .81343 .48671 Mtetra
.911 .846 .766 r
.81343 .48671 .81671 .48431 .8197 .47796 .81642 .48035 Mtetra
.901 .799 .738 r
.81642 .48035 .8197 .47796 .82262 .47039 .81935 .47277 Mtetra
.892 .77 .719 r
.81935 .47277 .82262 .47039 .82548 .46178 .82221 .46415 Mtetra
.886 .752 .708 r
.82221 .46415 .82548 .46178 .82829 .45235 .82503 .4547 Mtetra
.882 .741 .7 r
.82503 .4547 .82829 .45235 .83106 .44233 .8278 .44467 Mtetra
.88 .735 .697 r
.8278 .44467 .83106 .44233 .8338 .43199 .83056 .43431 Mtetra
.88 .734 .696 r
.83056 .43431 .8338 .43199 .83654 .42157 .8333 .42388 Mtetra
.881 .736 .698 r
.8333 .42388 .83654 .42157 .83928 .41135 .83605 .41364 Mtetra
.883 .744 .702 r
.83605 .41364 .83928 .41135 .84205 .40156 .83882 .40384 Mtetra
.888 .756 .711 r
.83882 .40384 .84205 .40156 .84485 .39244 .84163 .3947 Mtetra
.894 .777 .724 r
.84163 .3947 .84485 .39244 .8477 .38419 .84448 .38645 Mtetra
.903 .808 .745 r
.84448 .38645 .8477 .38419 .85062 .377 .84741 .37925 Mtetra
.912 .858 .775 r
.84741 .37925 .85062 .377 .85361 .37101 .8504 .37325 Mtetra
.908 .936 .817 r
.8504 .37325 .85361 .37101 .85669 .36634 .85348 .36857 Mtetra
.788 .998 .814 r
.85348 .36857 .85669 .36634 .85986 .36305 .85665 .36528 Mtetra
0 0 0 r
.85665 .36528 .85986 .36305 .86312 .36119 .85992 .36342 Mtetra
.351 0 .067 r
.85992 .36342 .86312 .36119 .86649 .36076 .86328 .36299 Mtetra
.553 .173 .275 r
.86328 .36299 .86649 .36076 .86995 .36173 .86675 .36396 Mtetra
.637 .291 .368 r
.86675 .36396 .86995 .36173 .87352 .36403 .87031 .36627 Mtetra
.679 .354 .417 r
.87031 .36627 .87352 .36403 .87717 .36756 .87397 .36981 Mtetra
.704 .391 .446 r
.87397 .36981 .87717 .36756 .88092 .37219 .87771 .37444 Mtetra
.719 .415 .464 r
.87771 .37444 .88092 .37219 .88474 .37775 .88153 .38003 Mtetra
.728 .431 .475 r
.88153 .38003 .88474 .37775 .88863 .38409 .88542 .38637 Mtetra
.734 .44 .482 r
.88542 .38637 .88863 .38409 .89257 .39099 .88936 .39328 Mtetra
.737 .445 .486 r
.88936 .39328 .89257 .39099 .89656 .39824 .89334 .40055 Mtetra
.738 .447 .487 r
.89334 .40055 .89656 .39824 .90057 .40563 .89735 .40796 Mtetra
.737 .445 .486 r
.89735 .40796 .90057 .40563 .90459 .41293 .90137 .41527 Mtetra
.757 .487 .525 r
.44742 .67796 .45084 .67682 .4535 .68399 .45007 .68513 Mtetra
.757 .489 .526 r
.45007 .68513 .4535 .68399 .45617 .6913 .45274 .69246 Mtetra
.757 .487 .525 r
.45274 .69246 .45617 .6913 .45885 .69855 .45541 .69972 Mtetra
.755 .483 .521 r
.45541 .69972 .45885 .69855 .46154 .70553 .4581 .7067 Mtetra
.752 .476 .514 r
.4581 .7067 .46154 .70553 .46425 .71201 .4608 .71319 Mtetra
.746 .463 .502 r
.4608 .71319 .46425 .71201 .46697 .7178 .46352 .71898 Mtetra
.736 .443 .484 r
.46352 .71898 .46697 .7178 .46971 .7227 .46626 .72389 Mtetra
.72 .41 .453 r
.46626 .72389 .46971 .7227 .47246 .72655 .469 .72775 Mtetra
.688 .349 .395 r
.469 .72775 .47246 .72655 .47522 .7292 .47177 .7304 Mtetra
.611 .216 .27 r
.47177 .7304 .47522 .7292 .478 .73054 .47454 .73175 Mtetra
.33 0 0 r
.47454 .73175 .478 .73054 .48078 .73049 .47732 .7317 Mtetra
.559 .935 .884 r
.47732 .7317 .48078 .73049 .48357 .72901 .48012 .73022 Mtetra
.83 .896 .888 r
.48012 .73022 .48357 .72901 .48637 .72609 .48292 .7273 Mtetra
.846 .803 .809 r
.48292 .7273 .48637 .72609 .48918 .72178 .48572 .72298 Mtetra
.842 .752 .765 r
.48572 .72298 .48918 .72178 .49198 .71616 .48853 .71736 Mtetra
.837 .723 .738 r
.48853 .71736 .49198 .71616 .49479 .70934 .49134 .71053 Mtetra
.833 .704 .722 r
.49134 .71053 .49479 .70934 .49759 .70149 .49415 .70267 Mtetra
.83 .692 .711 r
.49415 .70267 .49759 .70149 .50039 .69278 .49695 .69395 Mtetra
.829 .685 .705 r
.49695 .69395 .50039 .69278 .50319 .68343 .49975 .6846 Mtetra
.828 .681 .701 r
.49975 .6846 .50319 .68343 .50598 .67368 .50255 .67484 Mtetra
.827 .679 .699 r
.50255 .67484 .50598 .67368 .50877 .66378 .50535 .66492 Mtetra
.827 .68 .7 r
.50535 .66492 .50877 .66378 .51156 .65397 .50814 .6551 Mtetra
.828 .683 .703 r
.50814 .6551 .51156 .65397 .51434 .64451 .51092 .64563 Mtetra
.83 .69 .709 r
.51092 .64563 .51434 .64451 .51712 .63563 .51371 .63674 Mtetra
.832 .7 .718 r
.51371 .63674 .51712 .63563 .5199 .62756 .5165 .62866 Mtetra
.835 .716 .733 r
.5165 .62866 .5199 .62756 .52269 .62049 .51928 .62158 Mtetra
.839 .742 .756 r
.51928 .62158 .52269 .62049 .52548 .61458 .52207 .61567 Mtetra
.843 .785 .796 r
.52207 .61567 .52548 .61458 .52827 .60996 .52487 .61105 Mtetra
.836 .863 .865 r
.52487 .61105 .52827 .60996 .53108 .60672 .52768 .6078 Mtetra
.705 .964 .941 r
.52768 .6078 .53108 .60672 .53389 .60487 .5305 .60595 Mtetra
.094 0 0 r
.5305 .60595 .53389 .60487 .53672 .60441 .53333 .60549 Mtetra
.548 .108 .156 r
.53333 .60549 .53672 .60441 .53957 .60526 .53617 .60635 Mtetra
.661 .29 .331 r
.53617 .60635 .53957 .60526 .54243 .60731 .53903 .6084 Mtetra
.703 .366 .404 r
.53903 .6084 .54243 .60731 .54531 .61038 .54191 .61148 Mtetra
.722 .404 .44 r
.54191 .61148 .54531 .61038 .5482 .61427 .5448 .61536 Mtetra
.731 .423 .458 r
.5448 .61536 .5482 .61427 .55111 .6187 .5477 .61981 Mtetra
.735 .431 .465 r
.5477 .61981 .55111 .6187 .55403 .62341 .55062 .62452 Mtetra
.735 .429 .464 r
.55062 .62452 .55403 .62341 .55696 .62809 .55355 .62921 Mtetra
.729 .418 .454 r
.55355 .62921 .55696 .62809 .5599 .63244 .55648 .63357 Mtetra
.717 .394 .431 r
.55648 .63357 .5599 .63244 .56284 .63616 .55942 .63729 Mtetra
.692 .347 .386 r
.55942 .63729 .56284 .63616 .56578 .63898 .56236 .64012 Mtetra
.634 .245 .289 r
.56236 .64012 .56578 .63898 .56871 .64066 .56529 .6418 Mtetra
.449 0 .026 r
.56529 .6418 .56871 .64066 .57163 .64103 .56821 .64217 Mtetra
.28 .773 .715 r
.56821 .64217 .57163 .64103 .57455 .63998 .57112 .64112 Mtetra
.798 .938 .921 r
.57112 .64112 .57455 .63998 .57744 .63748 .57402 .63862 Mtetra
.846 .835 .834 r
.57402 .63862 .57744 .63748 .58032 .63358 .5769 .63472 Mtetra
.847 .775 .782 r
.5769 .63472 .58032 .63358 .58318 .62842 .57976 .62955 Mtetra
.843 .744 .754 r
.57976 .62955 .58318 .62842 .58603 .62222 .58261 .62334 Mtetra
.841 .726 .738 r
.58261 .62334 .58603 .62222 .58886 .61526 .58545 .61638 Mtetra
.839 .718 .731 r
.58545 .61638 .58886 .61526 .59169 .60789 .58828 .609 Mtetra
.839 .718 .73 r
.58828 .609 .59169 .60789 .59451 .60049 .5911 .60159 Mtetra
.84 .724 .736 r
.5911 .60159 .59451 .60049 .59734 .59344 .59394 .59453 Mtetra
.843 .74 .75 r
.59394 .59453 .59734 .59344 .60018 .58711 .59678 .58819 Mtetra
.846 .77 .778 r
.59678 .58819 .60018 .58711 .60304 .58181 .59964 .58289 Mtetra
.846 .827 .829 r
.59964 .58289 .60304 .58181 .60592 .57779 .60252 .57887 Mtetra
.805 .928 .916 r
.60252 .57887 .60592 .57779 .60883 .5752 .60544 .57627 Mtetra
.364 .831 .785 r
.60544 .57627 .60883 .5752 .61178 .57404 .60838 .57512 Mtetra
.381 0 0 r
.60838 .57512 .61178 .57404 .61475 .57421 .61136 .57528 Mtetra
.589 .167 .209 r
.61136 .57528 .61475 .57421 .61776 .57544 .61436 .57652 Mtetra
.648 .262 .3 r
.61436 .57652 .61776 .57544 .62078 .57736 .61739 .57844 Mtetra
.66 .284 .321 r
.61739 .57844 .62078 .57736 .62382 .57949 .62043 .58058 Mtetra
.641 .251 .289 r
.62043 .58058 .62382 .57949 .62687 .58132 .62347 .58241 Mtetra
.562 .125 .169 r
.62347 .58241 .62687 .58132 .6299 .58234 .6265 .58343 Mtetra
.239 0 0 r
.6265 .58343 .6299 .58234 .6329 .58213 .6295 .58322 Mtetra
.614 .952 .916 r
.6295 .58322 .6329 .58213 .63588 .58046 .63248 .58155 Mtetra
.833 .892 .884 r
.63248 .58155 .63588 .58046 .63883 .57732 .63543 .57841 Mtetra
.849 .818 .818 r
.63543 .57841 .63883 .57732 .64175 .57301 .63836 .57409 Mtetra
.849 .791 .794 r
.63836 .57409 .64175 .57301 .64466 .5681 .64127 .56918 Mtetra
.849 .798 .8 r
.64127 .56918 .64466 .5681 .64757 .56335 .64418 .56442 Mtetra
.846 .847 .845 r
.64418 .56442 .64757 .56335 .65051 .55956 .64712 .56063 Mtetra
.765 .956 .935 r
.64712 .56063 .65051 .55956 .65349 .55727 .6501 .55834 Mtetra
0 0 0 r
.6501 .55834 .65349 .55727 .65652 .55644 .65313 .55751 Mtetra
.16 0 0 r
.65313 .55751 .65652 .55644 .65956 .55608 .65618 .55715 Mtetra
.581 .942 .905 r
.65618 .55715 .65956 .55608 .66258 .55447 .65919 .55554 Mtetra
.82 .915 .902 r
.65919 .55554 .66258 .55447 .66556 .55159 .66217 .55266 Mtetra
.582 .942 .905 r
.66217 .55266 .66556 .55159 .66859 .54998 .6652 .55105 Mtetra
.156 0 0 r
.6652 .55105 .66859 .54998 .67165 .54962 .66826 .55069 Mtetra
0 0 0 r
.66826 .55069 .67165 .54962 .67471 .54877 .67132 .54984 Mtetra
.764 .957 .935 r
.67132 .54984 .67471 .54877 .67772 .54646 .67434 .54753 Mtetra
.847 .85 .846 r
.67434 .54753 .67772 .54646 .6807 .54264 .67731 .5437 Mtetra
.851 .8 .801 r
.67731 .5437 .6807 .54264 .68364 .53785 .68026 .53891 Mtetra
.851 .793 .794 r
.68026 .53891 .68364 .53785 .68658 .53289 .6832 .53394 Mtetra
.85 .82 .819 r
.6832 .53394 .68658 .53289 .68954 .52853 .68616 .52958 Mtetra
.833 .893 .884 r
.68616 .52958 .68954 .52853 .69254 .52534 .68916 .52638 Mtetra
.625 .955 .922 r
.68916 .52638 .69254 .52534 .69559 .5236 .69222 .52465 Mtetra
.201 0 0 r
.69222 .52465 .69559 .5236 .6987 .52333 .69533 .52438 Mtetra
.546 .096 .134 r
.69533 .52438 .6987 .52333 .70186 .5243 .69849 .52535 Mtetra
.632 .23 .263 r
.69849 .52535 .70186 .5243 .70506 .52608 .70168 .52714 Mtetra
.653 .265 .296 r
.70168 .52714 .70506 .52608 .70828 .52819 .7049 .52925 Mtetra
.64 .242 .274 r
.7049 .52925 .70828 .52819 .7115 .53009 .70812 .53115 Mtetra
.577 .142 .178 r
.70812 .53115 .7115 .53009 .7147 .5313 .71132 .53236 Mtetra
.359 0 0 r
.71132 .53236 .7147 .5313 .71787 .53142 .71449 .53248 Mtetra
.364 .832 .786 r
.71449 .53248 .71787 .53142 .72099 .53019 .71761 .53126 Mtetra
.803 .937 .918 r
.71761 .53126 .72099 .53019 .72406 .52749 .72068 .52855 Mtetra
.851 .838 .833 r
.72068 .52855 .72406 .52749 .72707 .52333 .72369 .52439 Mtetra
.853 .78 .78 r
.72369 .52439 .72707 .52333 .73003 .51786 .72666 .51891 Mtetra
.85 .749 .752 r
.72666 .51891 .73003 .51786 .73295 .51133 .72958 .51237 Mtetra
.848 .733 .737 r
.72958 .51237 .73295 .51133 .73584 .50407 .73247 .5051 Mtetra
.847 .726 .73 r
.73247 .5051 .73584 .50407 .73871 .49646 .73535 .49749 Mtetra
.847 .727 .731 r
.73535 .49749 .73871 .49646 .74159 .4889 .73823 .48992 Mtetra
.848 .735 .739 r
.73823 .48992 .74159 .4889 .74448 .48175 .74112 .48277 Mtetra
.85 .753 .755 r
.74112 .48277 .74448 .48175 .7474 .47537 .74404 .47638 Mtetra
.852 .785 .785 r
.74404 .47638 .7474 .47537 .75036 .47004 .74701 .47104 Mtetra
.849 .841 .837 r
.74701 .47104 .75036 .47004 .75339 .46596 .75004 .46696 Mtetra
.799 .935 .92 r
.75004 .46696 .75339 .46596 .75648 .46328 .75313 .46427 Mtetra
.379 .842 .805 r
.75313 .46427 .75648 .46328 .75964 .46205 .7563 .46304 Mtetra
.368 0 0 r
.7563 .46304 .75964 .46205 .76288 .46224 .75953 .46323 Mtetra
.605 .179 .206 r
.75953 .46323 .76288 .46224 .76618 .46375 .76283 .46475 Mtetra
.679 .303 .326 r
.76283 .46475 .76618 .46375 .76955 .46642 .7662 .46742 Mtetra
.711 .361 .382 r
.7662 .46742 .76955 .46642 .77297 .47002 .76962 .47103 Mtetra
.726 .389 .409 r
.76962 .47103 .77297 .47002 .77643 .47429 .77308 .4753 Mtetra
.732 .402 .422 r
.77308 .4753 .77643 .47429 .77993 .47893 .77657 .47995 Mtetra
.733 .404 .423 r
.77657 .47995 .77993 .47893 .78344 .48364 .78008 .48466 Mtetra
.728 .395 .414 r
.78008 .48466 .78344 .48364 .78695 .48809 .78359 .48913 Mtetra
.717 .372 .393 r
.78359 .48913 .78695 .48809 .79045 .492 .78708 .49304 Mtetra
.693 .328 .351 r
.78708 .49304 .79045 .492 .79391 .49509 .79055 .49614 Mtetra
.642 .24 .267 r
.79055 .49614 .79391 .49509 .79733 .49713 .79396 .49817 Mtetra
.507 .036 .071 r
.79396 .49817 .79733 .49713 .80069 .49791 .79733 .49896 Mtetra
.04 0 0 r
.79733 .49896 .80069 .49791 .80399 .49732 .80062 .49837 Mtetra
.685 .967 .932 r
.80062 .49837 .80399 .49732 .80721 .49525 .80385 .4963 Mtetra
.842 .89 .874 r
.80385 .4963 .80721 .49525 .81036 .49171 .807 .49275 Mtetra
.858 .811 .803 r
.807 .49275 .81036 .49171 .81343 .48671 .81007 .48775 Mtetra
.856 .764 .76 r
.81007 .48775 .81343 .48671 .81642 .48035 .81307 .48138 Mtetra
.853 .736 .734 r
.81307 .48138 .81642 .48035 .81935 .47277 .816 .47379 Mtetra
.85 .718 .717 r
.816 .47379 .81935 .47277 .82221 .46415 .81886 .46516 Mtetra
.848 .706 .706 r
.81886 .46516 .82221 .46415 .82503 .4547 .82168 .45571 Mtetra
.846 .699 .7 r
.82168 .45571 .82503 .4547 .8278 .44467 .82446 .44566 Mtetra
.845 .695 .696 r
.82446 .44566 .8278 .44467 .83056 .43431 .82722 .43529 Mtetra
.845 .695 .695 r
.82722 .43529 .83056 .43431 .8333 .42388 .82997 .42485 Mtetra
.846 .696 .697 r
.82997 .42485 .8333 .42388 .83605 .41364 .83272 .4146 Mtetra
.846 .701 .702 r
.83272 .4146 .83605 .41364 .83882 .40384 .8355 .40479 Mtetra
.848 .709 .709 r
.8355 .40479 .83882 .40384 .84163 .3947 .83831 .39564 Mtetra
.85 .722 .721 r
.83831 .39564 .84163 .3947 .84448 .38645 .84117 .38738 Mtetra
.853 .742 .74 r
.84117 .38738 .84448 .38645 .84741 .37925 .8441 .38017 Mtetra
.855 .772 .769 r
.8441 .38017 .84741 .37925 .8504 .37325 .8471 .37416 Mtetra
.854 .821 .815 r
.8471 .37416 .8504 .37325 .85348 .36857 .85018 .36948 Mtetra
.83 .9 .889 r
.85018 .36948 .85348 .36857 .85665 .36528 .85335 .36618 Mtetra
.639 .955 .934 r
.85335 .36618 .85665 .36528 .85992 .36342 .85662 .36432 Mtetra
.093 0 0 r
.85662 .36432 .85992 .36342 .86328 .36299 .85999 .3639 Mtetra
.526 .051 .07 r
.85999 .3639 .86328 .36299 .86675 .36396 .86345 .36487 Mtetra
.656 .251 .265 r
.86345 .36487 .86675 .36396 .87031 .36627 .86701 .36718 Mtetra
.707 .341 .353 r
.86701 .36718 .87031 .36627 .87397 .36981 .87067 .37073 Mtetra
.732 .39 .4 r
.87067 .37073 .87397 .36981 .87771 .37444 .87441 .37537 Mtetra
.747 .418 .427 r
.87441 .37537 .87771 .37444 .88153 .38003 .87822 .38096 Mtetra
.755 .436 .444 r
.87822 .38096 .88153 .38003 .88542 .38637 .88211 .38731 Mtetra
.76 .447 .455 r
.88211 .38731 .88542 .38637 .88936 .39328 .88605 .39424 Mtetra
.763 .452 .46 r
.88605 .39424 .88936 .39328 .89334 .40055 .89003 .40151 Mtetra
.764 .454 .462 r
.89003 .40151 .89334 .40055 .89735 .40796 .89403 .40893 Mtetra
.763 .452 .46 r
.89403 .40893 .89735 .40796 .90137 .41527 .89805 .41625 Mtetra
.784 .5 .506 r
.444 .67772 .44742 .67796 .45007 .68513 .44665 .6849 Mtetra
.784 .502 .508 r
.44665 .6849 .45007 .68513 .45274 .69246 .44931 .69223 Mtetra
.784 .5 .507 r
.44931 .69223 .45274 .69246 .45541 .69972 .45198 .6995 Mtetra
.783 .496 .501 r
.45198 .6995 .45541 .69972 .4581 .7067 .45466 .70648 Mtetra
.781 .488 .492 r
.45466 .70648 .4581 .7067 .4608 .71319 .45736 .71298 Mtetra
.778 .475 .475 r
.45736 .71298 .4608 .71319 .46352 .71898 .46008 .71878 Mtetra
.771 .452 .447 r
.46008 .71878 .46352 .71898 .46626 .72389 .46281 .72369 Mtetra
.758 .412 .397 r
.46281 .72369 .46626 .72389 .469 .72775 .46555 .72755 Mtetra
.725 .326 .293 r
.46555 .72755 .469 .72775 .47177 .7304 .46831 .73021 Mtetra
.596 .084 .004 r
.46831 .73021 .47177 .7304 .47454 .73175 .47108 .73155 Mtetra
.121 .664 .833 r
.47108 .73155 .47454 .73175 .47732 .7317 .47386 .7315 Mtetra
.692 .834 .951 r
.47386 .7315 .47732 .7317 .48012 .73022 .47666 .73002 Mtetra
.772 .76 .842 r
.47666 .73002 .48012 .73022 .48292 .7273 .47946 .7271 Mtetra
.79 .716 .782 r
.47946 .7271 .48292 .7273 .48572 .72298 .48226 .72278 Mtetra
.796 .691 .749 r
.48226 .72278 .48572 .72298 .48853 .71736 .48507 .71715 Mtetra
.798 .675 .728 r
.48507 .71715 .48853 .71736 .49134 .71053 .48788 .71032 Mtetra
.799 .665 .714 r
.48788 .71032 .49134 .71053 .49415 .70267 .49069 .70245 Mtetra
.8 .658 .706 r
.49069 .70245 .49415 .70267 .49695 .69395 .4935 .69372 Mtetra
.8 .653 .7 r
.4935 .69372 .49695 .69395 .49975 .6846 .49631 .68436 Mtetra
.801 .651 .697 r
.49631 .68436 .49975 .6846 .50255 .67484 .49911 .6746 Mtetra
.801 .65 .695 r
.49911 .6746 .50255 .67484 .50535 .66492 .50191 .66467 Mtetra
.801 .65 .696 r
.50191 .66467 .50535 .66492 .50814 .6551 .50471 .65485 Mtetra
.8 .652 .699 r
.50471 .65485 .50814 .6551 .51092 .64563 .5075 .64537 Mtetra
.8 .656 .703 r
.5075 .64537 .51092 .64563 .51371 .63674 .51029 .63647 Mtetra
.8 .662 .711 r
.51029 .63647 .51371 .63674 .5165 .62866 .51308 .62839 Mtetra
.798 .671 .724 r
.51308 .62839 .5165 .62866 .51928 .62158 .51587 .6213 Mtetra
.796 .685 .742 r
.51587 .6213 .51928 .62158 .52207 .61567 .51866 .61539 Mtetra
.791 .707 .772 r
.51866 .61539 .52207 .61567 .52487 .61105 .52146 .61076 Mtetra
.776 .744 .823 r
.52146 .61076 .52487 .61105 .52768 .6078 .52427 .60751 Mtetra
.724 .806 .916 r
.52427 .60751 .52768 .6078 .5305 .60595 .52709 .60566 Mtetra
.415 .812 .985 r
.52709 .60566 .5305 .60595 .53333 .60549 .52992 .6052 Mtetra
.429 0 0 r
.52992 .6052 .53333 .60549 .53617 .60635 .53276 .60606 Mtetra
.684 .228 .162 r
.53276 .60606 .53617 .60635 .53903 .6084 .53562 .60811 Mtetra
.741 .351 .313 r
.53562 .60811 .53903 .6084 .54191 .61148 .53849 .61119 Mtetra
.76 .403 .378 r
.53849 .61119 .54191 .61148 .5448 .61536 .54137 .61508 Mtetra
.769 .427 .408 r
.54137 .61508 .5448 .61536 .5477 .61981 .54428 .61952 Mtetra
.772 .437 .42 r
.54428 .61952 .5477 .61981 .55062 .62452 .54719 .62424 Mtetra
.771 .435 .418 r
.54719 .62424 .55062 .62452 .55355 .62921 .55011 .62894 Mtetra
.767 .422 .401 r
.55011 .62894 .55355 .62921 .55648 .63357 .55304 .6333 Mtetra
.756 .391 .363 r
.55304 .6333 .55648 .63357 .55942 .63729 .55598 .63702 Mtetra
.729 .322 .278 r
.55598 .63702 .55942 .63729 .56236 .64012 .55891 .63985 Mtetra
.636 .142 .061 r
.55891 .63985 .56236 .64012 .56529 .6418 .56184 .64153 Mtetra
.156 0 0 r
.56184 .64153 .56529 .6418 .56821 .64217 .56476 .6419 Mtetra
.61 .848 .989 r
.56476 .6419 .56821 .64217 .57112 .64112 .56767 .64085 Mtetra
.757 .781 .873 r
.56767 .64085 .57112 .64112 .57402 .63862 .57057 .63835 Mtetra
.787 .731 .801 r
.57057 .63835 .57402 .63862 .5769 .63472 .57345 .63444 Mtetra
.796 .703 .762 r
.57345 .63444 .5769 .63472 .57976 .62955 .57632 .62927 Mtetra
.799 .686 .74 r
.57632 .62927 .57976 .62955 .58261 .62334 .57917 .62306 Mtetra
.801 .677 .728 r
.57917 .62306 .58261 .62334 .58545 .61638 .58201 .61609 Mtetra
.802 .673 .722 r
.58201 .61609 .58545 .61638 .58828 .609 .58484 .60871 Mtetra
.802 .672 .721 r
.58484 .60871 .58828 .609 .5911 .60159 .58767 .60129 Mtetra
.801 .676 .726 r
.58767 .60129 .5911 .60159 .59394 .59453 .59051 .59423 Mtetra
.8 .684 .738 r
.59051 .59423 .59394 .59453 .59678 .58819 .59335 .58788 Mtetra
.796 .7 .759 r
.59335 .58788 .59678 .58819 .59964 .58289 .59621 .58258 Mtetra
.787 .727 .797 r
.59621 .58258 .59964 .58289 .60252 .57887 .5991 .57856 Mtetra
.759 .775 .866 r
.5991 .57856 .60252 .57887 .60544 .57627 .60201 .57596 Mtetra
.632 .841 .981 r
.60201 .57596 .60544 .57627 .60838 .57512 .60496 .5748 Mtetra
.014 .584 .771 r
.60496 .5748 .60838 .57512 .61136 .57528 .60793 .57496 Mtetra
.534 0 0 r
.60793 .57496 .61136 .57528 .61436 .57652 .61093 .5762 Mtetra
.659 .176 .093 r
.61093 .5762 .61436 .57652 .61739 .57844 .61396 .57812 Mtetra
.681 .216 .142 r
.61396 .57812 .61739 .57844 .62043 .58058 .61699 .58026 Mtetra
.647 .154 .067 r
.61699 .58026 .62043 .58058 .62347 .58241 .62003 .5821 Mtetra
.463 0 0 r
.62003 .5821 .62347 .58241 .6265 .58343 .62306 .58312 Mtetra
.264 .745 .93 r
.62306 .58312 .6265 .58343 .6295 .58322 .62607 .58291 Mtetra
.701 .823 .94 r
.62607 .58291 .6295 .58322 .63248 .58155 .62905 .58123 Mtetra
.774 .758 .838 r
.62905 .58123 .63248 .58155 .63543 .57841 .632 .57809 Mtetra
.791 .723 .789 r
.632 .57809 .63543 .57841 .63836 .57409 .63492 .57377 Mtetra
.795 .71 .771 r
.63492 .57377 .63836 .57409 .64127 .56918 .63783 .56885 Mtetra
.794 .714 .776 r
.63783 .56885 .64127 .56918 .64418 .56442 .64075 .56409 Mtetra
.785 .737 .809 r
.64075 .56409 .64418 .56442 .64712 .56063 .64369 .56029 Mtetra
.744 .793 .892 r
.64369 .56029 .64712 .56063 .6501 .55834 .64667 .55801 Mtetra
.548 .841 .998 r
.64667 .55801 .6501 .55834 .65313 .55751 .6497 .55717 Mtetra
.353 .786 .968 r
.6497 .55717 .65313 .55751 .65618 .55715 .65274 .55681 Mtetra
.692 .826 .947 r
.65274 .55681 .65618 .55715 .65919 .55554 .65576 .5552 Mtetra
.767 .769 .854 r
.65576 .5552 .65919 .55554 .66217 .55266 .65874 .55232 Mtetra
.692 .826 .947 r
.65874 .55232 .66217 .55266 .6652 .55105 .66177 .55071 Mtetra
.357 .787 .969 r
.66177 .55071 .6652 .55105 .66826 .55069 .66483 .55034 Mtetra
.549 .841 .998 r
.66483 .55034 .66826 .55069 .67132 .54984 .66789 .54949 Mtetra
.744 .794 .893 r
.66789 .54949 .67132 .54984 .67434 .54753 .6709 .54718 Mtetra
.785 .738 .809 r
.6709 .54718 .67434 .54753 .67731 .5437 .67388 .54335 Mtetra
.795 .715 .776 r
.67388 .54335 .67731 .5437 .68026 .53891 .67682 .53855 Mtetra
.796 .712 .771 r
.67682 .53855 .68026 .53891 .6832 .53394 .67977 .53358 Mtetra
.791 .725 .79 r
.67977 .53358 .6832 .53394 .68616 .52958 .68273 .52922 Mtetra
.774 .758 .839 r
.68273 .52922 .68616 .52958 .68916 .52638 .68573 .52602 Mtetra
.703 .82 .938 r
.68573 .52602 .68916 .52638 .69222 .52465 .68879 .52428 Mtetra
.308 .764 .952 r
.68879 .52428 .69222 .52465 .69533 .52438 .6919 .52401 Mtetra
.414 0 0 r
.6919 .52401 .69533 .52438 .69849 .52535 .69505 .52498 Mtetra
.625 .112 .008 r
.69505 .52498 .69849 .52535 .70168 .52714 .69825 .52677 Mtetra
.665 .181 .09 r
.69825 .52677 .70168 .52714 .7049 .52925 .70146 .52888 Mtetra
.64 .137 .037 r
.70146 .52888 .7049 .52925 .70812 .53115 .70468 .53079 Mtetra
.496 0 0 r
.70468 .53079 .70812 .53115 .71132 .53236 .70788 .532 Mtetra
.063 .619 .813 r
.70788 .532 .71132 .53236 .71449 .53248 .71104 .53212 Mtetra
.632 .841 .98 r
.71104 .53212 .71449 .53248 .71761 .53126 .71417 .53089 Mtetra
.76 .78 .87 r
.71417 .53089 .71761 .53126 .72068 .52855 .71724 .52818 Mtetra
.79 .733 .8 r
.71724 .52818 .72068 .52855 .72369 .52439 .72025 .52402 Mtetra
.8 .706 .761 r
.72025 .52402 .72369 .52439 .72666 .51891 .72322 .51853 Mtetra
.804 .69 .739 r
.72322 .51853 .72666 .51891 .72958 .51237 .72615 .51199 Mtetra
.806 .681 .727 r
.72615 .51199 .72958 .51237 .73247 .5051 .72904 .50472 Mtetra
.807 .678 .722 r
.72904 .50472 .73247 .5051 .73535 .49749 .73192 .4971 Mtetra
.73192 .4971 .73535 .49749 .73823 .48992 .7348 .48952 Mtetra
.806 .682 .728 r
.7348 .48952 .73823 .48992 .74112 .48277 .7377 .48236 Mtetra
.804 .692 .741 r
.7377 .48236 .74112 .48277 .74404 .47638 .74062 .47597 Mtetra
.799 .708 .764 r
.74062 .47597 .74404 .47638 .74701 .47104 .7436 .47063 Mtetra
.788 .735 .803 r
.7436 .47063 .74701 .47104 .75004 .46696 .74663 .46654 Mtetra
.757 .78 .871 r
.74663 .46654 .75004 .46696 .75313 .46427 .74972 .46386 Mtetra
.632 .837 .979 r
.74972 .46386 .75313 .46427 .7563 .46304 .75288 .46262 Mtetra
.044 .604 .807 r
.75288 .46262 .7563 .46304 .75953 .46323 .75611 .46281 Mtetra
.558 .006 0 r
.75611 .46281 .75953 .46323 .76283 .46475 .75941 .46433 Mtetra
.705 .249 .165 r
.75941 .46433 .76283 .46475 .7662 .46742 .76277 .467 Mtetra
.748 .341 .28 r
.76277 .467 .7662 .46742 .76962 .47103 .76619 .47061 Mtetra
.764 .382 .331 r
.76619 .47061 .76962 .47103 .77308 .4753 .76965 .47489 Mtetra
.771 .4 .353 r
.76965 .47489 .77308 .4753 .77657 .47995 .77314 .47954 Mtetra
.771 .402 .356 r
.77314 .47954 .77657 .47995 .78008 .48466 .77665 .48426 Mtetra
.767 .389 .34 r
.77665 .48426 .78008 .48466 .78359 .48913 .78015 .48872 Mtetra
.755 .358 .301 r
.78015 .48872 .78359 .48913 .78708 .49304 .78364 .49264 Mtetra
.725 .29 .217 r
.78364 .49264 .78708 .49304 .79055 .49614 .7871 .49574 Mtetra
.64 .132 .024 r
.7871 .49574 .79055 .49614 .79396 .49817 .79052 .49778 Mtetra
.301 0 0 r
.79052 .49778 .79396 .49817 .79733 .49896 .79388 .49857 Mtetra
.45 .818 .994 r
.79388 .49857 .79733 .49896 .80062 .49837 .79717 .49797 Mtetra
.722 .814 .922 r
.79717 .49797 .80062 .49837 .80385 .4963 .8004 .4959 Mtetra
.781 .758 .832 r
.8004 .4959 .80385 .4963 .807 .49275 .80355 .49235 Mtetra
.799 .721 .778 r
.80355 .49235 .807 .49275 .81007 .48775 .80662 .48734 Mtetra
.806 .698 .746 r
.80662 .48734 .81007 .48775 .81307 .48138 .80962 .48097 Mtetra
.81 .683 .725 r
.80962 .48097 .81307 .48138 .816 .47379 .81255 .47337 Mtetra
.812 .673 .711 r
.81255 .47337 .816 .47379 .81886 .46516 .81543 .46474 Mtetra
.813 .667 .702 r
.81543 .46474 .81886 .46516 .82168 .45571 .81825 .45527 Mtetra
.813 .663 .696 r
.81825 .45527 .82168 .45571 .82446 .44566 .82104 .44522 Mtetra
.813 .66 .693 r
.82104 .44522 .82446 .44566 .82722 .43529 .8238 .43484 Mtetra
.814 .66 .692 r
.8238 .43484 .82722 .43529 .82997 .42485 .82655 .42439 Mtetra
.813 .661 .694 r
.82655 .42439 .82997 .42485 .83272 .4146 .82931 .41413 Mtetra
.813 .664 .698 r
.82931 .41413 .83272 .4146 .8355 .40479 .83209 .40431 Mtetra
.812 .668 .704 r
.83209 .40431 .8355 .40479 .83831 .39564 .83491 .39516 Mtetra
.811 .676 .714 r
.83491 .39516 .83831 .39564 .84117 .38738 .83777 .38689 Mtetra
.809 .686 .729 r
.83777 .38689 .84117 .38738 .8441 .38017 .8407 .37968 Mtetra
.804 .702 .752 r
.8407 .37968 .8441 .38017 .8471 .37416 .8437 .37367 Mtetra
.795 .725 .787 r
.8437 .37367 .8471 .37416 .85018 .36948 .84678 .36898 Mtetra
.773 .761 .843 r
.84678 .36898 .85018 .36948 .85335 .36618 .84996 .36568 Mtetra
.703 .814 .934 r
.84996 .36568 .85335 .36618 .85662 .36432 .85323 .36382 Mtetra
.399 .793 .987 r
.85323 .36382 .85662 .36432 .85999 .3639 .85659 .36339 Mtetra
.341 0 0 r
.85659 .36339 .85999 .3639 .86345 .36487 .86005 .36437 Mtetra
.659 .154 .034 r
.86005 .36437 .86345 .36487 .86701 .36718 .86361 .36668 Mtetra
.741 .311 .229 r
.86361 .36668 .86701 .36718 .87067 .37073 .86726 .37022 Mtetra
.77 .382 .319 r
.86726 .37022 .87067 .37073 .87441 .37537 .871 .37487 Mtetra
.784 .42 .367 r
.871 .37487 .87441 .37537 .87822 .38096 .87481 .38046 Mtetra
.79 .441 .395 r
.87481 .38046 .87822 .38096 .88211 .38731 .87869 .38682 Mtetra
.794 .454 .412 r
.87869 .38682 .88211 .38731 .88605 .39424 .88263 .39375 Mtetra
.796 .46 .42 r
.88263 .39375 .88605 .39424 .89003 .40151 .8866 .40103 Mtetra
.797 .462 .423 r
.8866 .40103 .89003 .40151 .89403 .40893 .8906 .40845 Mtetra
.796 .46 .42 r
.8906 .40845 .89403 .40893 .89805 .41625 .89461 .41578 Mtetra
.817 .515 .479 r
.4406 .67609 .444 .67772 .44665 .6849 .44324 .68327 Mtetra
.817 .517 .482 r
.44324 .68327 .44665 .6849 .44931 .69223 .44589 .6906 Mtetra
.817 .516 .48 r
.44589 .6906 .44931 .69223 .45198 .6995 .44855 .69786 Mtetra
.818 .511 .472 r
.44855 .69786 .45198 .6995 .45466 .70648 .45123 .70485 Mtetra
.818 .503 .457 r
.45123 .70485 .45466 .70648 .45736 .71298 .45392 .71134 Mtetra
.818 .488 .431 r
.45392 .71134 .45736 .71298 .46008 .71878 .45663 .71714 Mtetra
.816 .461 .384 r
.45663 .71714 .46008 .71878 .46281 .72369 .45936 .72205 Mtetra
.807 .405 .291 r
.45936 .72205 .46281 .72369 .46555 .72755 .4621 .72591 Mtetra
.749 .256 .058 r
.4621 .72591 .46555 .72755 .46831 .73021 .46485 .72857 Mtetra
.323 0 0 r
.46485 .72857 .46831 .73021 .47108 .73155 .46762 .72991 Mtetra
.457 .685 .964 r
.46762 .72991 .47108 .73155 .47386 .7315 .4704 .72986 Mtetra
.664 .69 .864 r
.4704 .72986 .47386 .7315 .47666 .73002 .4732 .72838 Mtetra
.722 .668 .796 r
.4732 .72838 .47666 .73002 .47946 .7271 .476 .72545 Mtetra
.747 .653 .757 r
.476 .72545 .47946 .7271 .48226 .72278 .4788 .72113 Mtetra
.759 .643 .733 r
.4788 .72113 .48226 .72278 .48507 .71715 .48161 .7155 Mtetra
.766 .637 .717 r
.48161 .7155 .48507 .71715 .48788 .71032 .48443 .70866 Mtetra
.771 .632 .707 r
.48443 .70866 .48788 .71032 .49069 .70245 .48724 .70079 Mtetra
.774 .629 .7 r
.48724 .70079 .49069 .70245 .4935 .69372 .49005 .69206 Mtetra
.776 .627 .695 r
.49005 .69206 .4935 .69372 .49631 .68436 .49286 .6827 Mtetra
.777 .625 .692 r
.49286 .6827 .49631 .68436 .49911 .6746 .49567 .67293 Mtetra
.777 .625 .691 r
.49567 .67293 .49911 .6746 .50191 .66467 .49847 .663 Mtetra
.49847 .663 .50191 .66467 .50471 .65485 .50127 .65317 Mtetra
.776 .626 .694 r
.50127 .65317 .50471 .65485 .5075 .64537 .50407 .64369 Mtetra
.775 .628 .698 r
.50407 .64369 .5075 .64537 .51029 .63647 .50686 .63479 Mtetra
.772 .631 .704 r
.50686 .63479 .51029 .63647 .51308 .62839 .50965 .6267 Mtetra
.768 .635 .714 r
.50965 .6267 .51308 .62839 .51587 .6213 .51244 .61961 Mtetra
.761 .641 .728 r
.51244 .61961 .51587 .6213 .51866 .61539 .51524 .6137 Mtetra
.75 .65 .75 r
.51524 .6137 .51866 .61539 .52146 .61076 .51804 .60907 Mtetra
.729 .663 .785 r
.51804 .60907 .52146 .61076 .52427 .60751 .52085 .60581 Mtetra
.683 .681 .842 r
.52085 .60581 .52427 .60751 .52709 .60566 .52366 .60396 Mtetra
.551 .692 .933 r
.52366 .60396 .52709 .60566 .52992 .6052 .52649 .6035 Mtetra
.058 .52 .894 r
.52649 .6035 .52992 .6052 .53276 .60606 .52933 .60436 Mtetra
.613 .044 0 r
.52933 .60436 .53276 .60606 .53562 .60811 .53219 .60641 Mtetra
.775 .302 .118 r
.53219 .60641 .53562 .60811 .53849 .61119 .53505 .60949 Mtetra
.807 .391 .258 r
.53505 .60949 .53849 .61119 .54137 .61508 .53794 .61337 Mtetra
.815 .427 .318 r
.53794 .61337 .54137 .61508 .54428 .61952 .54083 .61782 Mtetra
.818 .44 .34 r
.54083 .61782 .54428 .61952 .54719 .62424 .54374 .62254 Mtetra
.817 .438 .336 r
.54374 .62254 .54719 .62424 .55011 .62894 .54666 .62723 Mtetra
.814 .419 .305 r
.54666 .62723 .55011 .62894 .55304 .6333 .54959 .63159 Mtetra
.801 .372 .227 r
.54959 .63159 .55304 .6333 .55598 .63702 .55252 .63531 Mtetra
.747 .247 .035 r
.55252 .63531 .55598 .63702 .55891 .63985 .55545 .63814 Mtetra
.447 0 0 r
.55545 .63814 .55891 .63985 .56184 .64153 .55838 .63982 Mtetra
.32 .642 .966 r
.55838 .63982 .56184 .64153 .56476 .6419 .5613 .64019 Mtetra
.625 .694 .894 r
.5613 .64019 .56476 .6419 .56767 .64085 .5642 .63914 Mtetra
.708 .675 .816 r
.5642 .63914 .56767 .64085 .57057 .63835 .5671 .63663 Mtetra
.74 .659 .77 r
.5671 .63663 .57057 .63835 .57345 .63444 .56998 .63272 Mtetra
.755 .649 .743 r
.56998 .63272 .57345 .63444 .57632 .62927 .57285 .62755 Mtetra
.764 .642 .727 r
.57285 .62755 .57632 .62927 .57917 .62306 .5757 .62133 Mtetra
.768 .638 .717 r
.5757 .62133 .57917 .62306 .58201 .61609 .57854 .61436 Mtetra
.77 .636 .713 r
.57854 .61436 .58201 .61609 .58484 .60871 .58138 .60697 Mtetra
.77 .636 .712 r
.58138 .60697 .58484 .60871 .58767 .60129 .58421 .59955 Mtetra
.769 .637 .716 r
.58421 .59955 .58767 .60129 .59051 .59423 .58705 .59249 Mtetra
.765 .641 .725 r
.58705 .59249 .59051 .59423 .59335 .58788 .58989 .58614 Mtetra
.757 .647 .741 r
.58989 .58614 .59335 .58788 .59621 .58258 .59276 .58083 Mtetra
.741 .658 .767 r
.59276 .58083 .59621 .58258 .5991 .57856 .59564 .57681 Mtetra
.71 .673 .812 r
.59564 .57681 .5991 .57856 .60201 .57596 .59856 .57421 Mtetra
.633 .691 .886 r
.59856 .57421 .60201 .57596 .60496 .5748 .6015 .57305 Mtetra
.402 .664 .966 r
.6015 .57305 .60496 .5748 .60793 .57496 .60447 .57321 Mtetra
0 .393 .78 r
.60447 .57321 .60793 .57496 .61093 .5762 .60747 .57444 Mtetra
.517 0 0 r
.60747 .57444 .61093 .5762 .61396 .57812 .61049 .57636 Mtetra
.593 .02 0 r
.61049 .57636 .61396 .57812 .61699 .58026 .61353 .5785 Mtetra
.473 0 0 r
.61353 .5785 .61699 .58026 .62003 .5821 .61656 .58034 Mtetra
.002 .485 .866 r
.61656 .58034 .62003 .5821 .62306 .58312 .61959 .58135 Mtetra
.499 .686 .95 r
.61959 .58135 .62306 .58312 .62607 .58291 .62259 .58115 Mtetra
.669 .686 .857 r
.62259 .58115 .62607 .58291 .62905 .58123 .62557 .57947 Mtetra
.724 .668 .794 r
.62557 .57947 .62905 .58123 .632 .57809 .62852 .57632 Mtetra
.745 .656 .762 r
.62852 .57632 .632 .57809 .63492 .57377 .63144 .572 Mtetra
.753 .652 .749 r
.63144 .572 .63492 .57377 .63783 .56885 .63436 .56707 Mtetra
.751 .653 .753 r
.63436 .56707 .63783 .56885 .64075 .56409 .63727 .56231 Mtetra
.737 .661 .775 r
.63727 .56231 .64075 .56409 .64369 .56029 .64022 .55852 Mtetra
.698 .678 .827 r
.64022 .55852 .64369 .56029 .64667 .55801 .6432 .55623 Mtetra
.598 .692 .909 r
.6432 .55623 .64667 .55801 .6497 .55717 .64622 .55539 Mtetra
.528 .688 .94 r
.64622 .55539 .6497 .55717 .65274 .55681 .64926 .55502 Mtetra
.663 .687 .862 r
.64926 .55502 .65274 .55681 .65576 .5552 .65228 .55342 Mtetra
.717 .671 .804 r
.65228 .55342 .65576 .5552 .65874 .55232 .65526 .55053 Mtetra
.663 .686 .861 r
.65526 .55053 .65874 .55232 .66177 .55071 .65829 .54892 Mtetra
.529 .688 .94 r
.65829 .54892 .66177 .55071 .66483 .55034 .66135 .54855 Mtetra
.598 .692 .908 r
.66135 .54855 .66483 .55034 .66789 .54949 .6644 .5477 Mtetra
.697 .678 .828 r
.6644 .5477 .66789 .54949 .6709 .54718 .66742 .54539 Mtetra
.737 .662 .776 r
.66742 .54539 .6709 .54718 .67388 .54335 .6704 .54155 Mtetra
.751 .654 .753 r
.6704 .54155 .67388 .54335 .67682 .53855 .67334 .53675 Mtetra
.753 .652 .75 r
.67334 .53675 .67682 .53855 .67977 .53358 .67629 .53178 Mtetra
.746 .657 .762 r
.67629 .53178 .67977 .53358 .68273 .52922 .67925 .52741 Mtetra
.724 .668 .795 r
.67925 .52741 .68273 .52922 .68573 .52602 .68225 .52421 Mtetra
.67 .685 .856 r
.68225 .52421 .68573 .52602 .68879 .52428 .68531 .52247 Mtetra
.511 .685 .945 r
.68531 .52247 .68879 .52428 .6919 .52401 .68841 .5222 Mtetra
.073 .522 .9 r
.68841 .5222 .6919 .52401 .69505 .52498 .69157 .52316 Mtetra
.393 0 0 r
.69157 .52316 .69505 .52498 .69825 .52677 .69476 .52495 Mtetra
.528 0 0 r
.69476 .52495 .69825 .52677 .70146 .52888 .69797 .52706 Mtetra
.441 0 0 r
.69797 .52706 .70146 .52888 .70468 .53079 .70118 .52896 Mtetra
0 .443 .832 r
.70118 .52896 .70468 .53079 .70788 .532 .70438 .53017 Mtetra
.42 .666 .963 r
.70438 .53017 .70788 .532 .71104 .53212 .70754 .53029 Mtetra
.633 .691 .886 r
.70754 .53029 .71104 .53212 .71417 .53089 .71067 .52906 Mtetra
.71 .675 .814 r
.71067 .52906 .71417 .53089 .71724 .52818 .71374 .52635 Mtetra
.742 .66 .769 r
.71374 .52635 .71724 .52818 .72025 .52402 .71675 .52218 Mtetra
.758 .65 .742 r
.71675 .52218 .72025 .52402 .72322 .51853 .71972 .5167 Mtetra
.767 .644 .725 r
.71972 .5167 .72322 .51853 .72615 .51199 .72265 .51015 Mtetra
.772 .64 .716 r
.72265 .51015 .72615 .51199 .72904 .50472 .72555 .50288 Mtetra
.773 .639 .712 r
.72555 .50288 .72904 .50472 .73192 .4971 .72843 .49525 Mtetra
.773 .639 .713 r
.72843 .49525 .73192 .4971 .7348 .48952 .73131 .48767 Mtetra
.771 .641 .717 r
.73131 .48767 .7348 .48952 .7377 .48236 .73421 .48051 Mtetra
.766 .645 .727 r
.73421 .48051 .7377 .48236 .74062 .47597 .73714 .47411 Mtetra
.757 .651 .744 r
.73714 .47411 .74062 .47597 .7436 .47063 .74011 .46877 Mtetra
.741 .661 .771 r
.74011 .46877 .7436 .47063 .74663 .46654 .74314 .46468 Mtetra
.708 .674 .815 r
.74314 .46468 .74663 .46654 .74972 .46386 .74623 .46199 Mtetra
.632 .688 .885 r
.74623 .46199 .74972 .46386 .75288 .46262 .74939 .46075 Mtetra
.406 .659 .962 r
.74939 .46075 .75288 .46262 .75611 .46281 .75262 .46094 Mtetra
0 .346 .742 r
.75262 .46094 .75611 .46281 .75941 .46433 .75592 .46246 Mtetra
.652 .094 0 r
.75592 .46246 .75941 .46433 .76277 .467 .75928 .46513 Mtetra
.771 .282 .065 r
.75928 .46513 .76277 .467 .76619 .47061 .76269 .46874 Mtetra
.802 .354 .178 r
.76269 .46874 .76619 .47061 .76965 .47489 .76615 .47302 Mtetra
.812 .383 .224 r
.76615 .47302 .76965 .47489 .77314 .47954 .76963 .47767 Mtetra
.813 .386 .229 r
.76963 .47767 .77314 .47954 .77665 .48426 .77313 .48238 Mtetra
.807 .366 .197 r
.77313 .48238 .77665 .48426 .78015 .48872 .77663 .48685 Mtetra
.785 .312 .112 r
.77663 .48685 .78015 .48872 .78364 .49264 .78012 .49076 Mtetra
.713 .182 0 r
.78012 .49076 .78364 .49264 .7871 .49574 .78358 .49386 Mtetra
.434 0 0 r
.78358 .49386 .7871 .49574 .79052 .49778 .78699 .4959 Mtetra
.196 .582 .942 r
.78699 .4959 .79052 .49778 .79388 .49857 .79035 .49668 Mtetra
.561 .69 .927 r
.79035 .49668 .79388 .49857 .79717 .49797 .79364 .49608 Mtetra
.682 .684 .846 r
.79364 .49608 .79717 .49797 .8004 .4959 .79686 .49401 Mtetra
.73 .669 .79 r
.79686 .49401 .8004 .4959 .80355 .49235 .80001 .49046 Mtetra
.753 .656 .754 r
.80001 .49046 .80355 .49235 .80662 .48734 .80309 .48545 Mtetra
.767 .648 .73 r
.80309 .48545 .80662 .48734 .80962 .48097 .80609 .47907 Mtetra
.775 .641 .714 r
.80609 .47907 .80962 .48097 .81255 .47337 .80903 .47147 Mtetra
.78 .637 .703 r
.80903 .47147 .81255 .47337 .81543 .46474 .8119 .46283 Mtetra
.783 .634 .696 r
.8119 .46283 .81543 .46474 .81825 .45527 .81473 .45336 Mtetra
.785 .632 .691 r
.81473 .45336 .81825 .45527 .82104 .44522 .81752 .44331 Mtetra
.786 .631 .689 r
.81752 .44331 .82104 .44522 .8238 .43484 .82028 .43293 Mtetra
.786 .631 .688 r
.82028 .43293 .8238 .43484 .82655 .42439 .82304 .42247 Mtetra
.786 .631 .689 r
.82304 .42247 .82655 .42439 .82931 .41413 .8258 .41221 Mtetra
.784 .633 .693 r
.8258 .41221 .82931 .41413 .83209 .40431 .82859 .40239 Mtetra
.782 .635 .698 r
.82859 .40239 .83209 .40431 .83491 .39516 .83141 .39323 Mtetra
.778 .638 .706 r
.83141 .39323 .83491 .39516 .83777 .38689 .83428 .38496 Mtetra
.772 .643 .718 r
.83428 .38496 .83777 .38689 .8407 .37968 .83721 .37774 Mtetra
.763 .649 .735 r
.83721 .37774 .8407 .37968 .8437 .37367 .84021 .37173 Mtetra
.749 .658 .76 r
.84021 .37173 .8437 .37367 .84678 .36898 .84329 .36703 Mtetra
.722 .669 .797 r
.84329 .36703 .84678 .36898 .84996 .36568 .84647 .36373 Mtetra
.669 .682 .854 r
.84647 .36373 .84996 .36568 .85323 .36382 .84973 .36187 Mtetra
.536 .681 .932 r
.84973 .36187 .85323 .36382 .85659 .36339 .8531 .36144 Mtetra
.145 .55 .925 r
.8531 .36144 .85659 .36339 .86005 .36437 .85656 .36241 Mtetra
.481 0 0 r
.85656 .36241 .86005 .36437 .86361 .36668 .86011 .36472 Mtetra
.74 .222 0 r
.86011 .36472 .86361 .36668 .86726 .37022 .86376 .36826 Mtetra
.805 .352 .163 r
.86376 .36826 .86726 .37022 .871 .37487 .86749 .37291 Mtetra
.825 .411 .26 r
.86749 .37291 .871 .37487 .87481 .38046 .8713 .3785 Mtetra
.832 .442 .312 r
.8713 .3785 .87481 .38046 .87869 .38682 .87517 .38486 Mtetra
.834 .458 .341 r
.87517 .38486 .87869 .38682 .88263 .39375 .8791 .39178 Mtetra
.836 .467 .355 r
.8791 .39178 .88263 .39375 .8866 .40103 .88307 .39907 Mtetra
.836 .469 .36 r
.88307 .39907 .8866 .40103 .8906 .40845 .88706 .40649 Mtetra
.836 .466 .354 r
.88706 .40649 .8906 .40845 .89461 .41578 .89107 .41381 Mtetra
.856 .532 .438 r
.4372 .67307 .4406 .67609 .44324 .68327 .43983 .68024 Mtetra
.856 .534 .442 r
.43983 .68024 .44324 .68327 .44589 .6906 .44248 .68757 Mtetra
.856 .533 .439 r
.44248 .68757 .44589 .6906 .44855 .69786 .44514 .69483 Mtetra
.858 .528 .427 r
.44514 .69483 .44855 .69786 .45123 .70485 .44781 .70181 Mtetra
.861 .518 .402 r
.44781 .70181 .45123 .70485 .45392 .71134 .45049 .7083 Mtetra
.864 .5 .358 r
.45049 .7083 .45392 .71134 .45663 .71714 .4532 .71409 Mtetra
.864 .461 .271 r
.4532 .71409 .45663 .71714 .45936 .72205 .45592 .719 Mtetra
.831 .361 .075 r
.45592 .719 .45936 .72205 .4621 .72591 .45865 .72286 Mtetra
.572 .042 0 r
.45865 .72286 .4621 .72591 .46485 .72857 .4614 .72551 Mtetra
.151 .45 .881 r
.4614 .72551 .46485 .72857 .46762 .72991 .46417 .72685 Mtetra
.516 .587 .864 r
.46417 .72685 .46762 .72991 .4704 .72986 .46695 .7268 Mtetra
.636 .608 .804 r
.46695 .7268 .4704 .72986 .4732 .72838 .46974 .72531 Mtetra
.688 .61 .764 r
.46974 .72531 .4732 .72838 .476 .72545 .47254 .72238 Mtetra
.715 .609 .738 r
.47254 .72238 .476 .72545 .4788 .72113 .47534 .71806 Mtetra
.731 .608 .72 r
.47534 .71806 .4788 .72113 .48161 .7155 .47816 .71242 Mtetra
.741 .607 .708 r
.47816 .71242 .48161 .7155 .48443 .70866 .48097 .70559 Mtetra
.748 .606 .7 r
.48097 .70559 .48443 .70866 .48724 .70079 .48379 .69771 Mtetra
.752 .605 .694 r
.48379 .69771 .48724 .70079 .49005 .69206 .4866 .68899 Mtetra
.755 .604 .69 r
.4866 .68899 .49005 .69206 .49286 .6827 .48941 .67962 Mtetra
.757 .604 .687 r
.48941 .67962 .49286 .6827 .49567 .67293 .49222 .66985 Mtetra
.758 .604 .687 r
.49222 .66985 .49567 .67293 .49847 .663 .49503 .65992 Mtetra
.757 .604 .687 r
.49503 .65992 .49847 .663 .50127 .65317 .49783 .65009 Mtetra
.756 .604 .689 r
.49783 .65009 .50127 .65317 .50407 .64369 .50063 .64061 Mtetra
.753 .604 .692 r
.50063 .64061 .50407 .64369 .50686 .63479 .50343 .63171 Mtetra
.749 .605 .698 r
.50343 .63171 .50686 .63479 .50965 .6267 .50622 .62362 Mtetra
.743 .606 .705 r
.50622 .62362 .50965 .6267 .51244 .61961 .50901 .61653 Mtetra
.734 .607 .717 r
.50901 .61653 .51244 .61961 .51524 .6137 .51181 .61061 Mtetra
.719 .609 .733 r
.51181 .61061 .51524 .6137 .51804 .60907 .51461 .60598 Mtetra
.695 .61 .757 r
.51461 .60598 .51804 .60907 .52085 .60581 .51742 .60273 Mtetra
.652 .608 .792 r
.51742 .60273 .52085 .60581 .52366 .60396 .52023 .60087 Mtetra
.563 .595 .844 r
.52023 .60087 .52366 .60396 .52649 .6035 .52306 .60041 Mtetra
.341 .529 .895 r
.52306 .60041 .52649 .6035 .52933 .60436 .52589 .60126 Mtetra
0 .256 .749 r
.52589 .60126 .52933 .60436 .53219 .60641 .52874 .60331 Mtetra
.67 .143 0 r
.52874 .60331 .53219 .60641 .53505 .60949 .53161 .60638 Mtetra
.815 .332 .016 r
.53161 .60638 .53505 .60949 .53794 .61337 .53449 .61027 Mtetra
.849 .402 .144 r
.53449 .61027 .53794 .61337 .54083 .61782 .53738 .61471 Mtetra
.857 .425 .19 r
.53738 .61471 .54083 .61782 .54374 .62254 .54028 .61942 Mtetra
.856 .421 .183 r
.54028 .61942 .54374 .62254 .54666 .62723 .5432 .62411 Mtetra
.844 .388 .117 r
.5432 .62411 .54666 .62723 .54959 .63159 .54612 .62846 Mtetra
.79 .292 0 r
.54612 .62846 .54959 .63159 .55252 .63531 .54904 .63218 Mtetra
.557 .03 0 r
.54904 .63218 .55252 .63531 .55545 .63814 .55197 .635 Mtetra
.039 .389 .85 r
.55197 .635 .55545 .63814 .55838 .63982 .55489 .63668 Mtetra
.452 .568 .881 r
.55489 .63668 .55838 .63982 .5613 .64019 .55781 .63705 Mtetra
.608 .604 .821 r
.55781 .63705 .5613 .64019 .5642 .63914 .56071 .636 Mtetra
.674 .61 .776 r
.56071 .636 .5642 .63914 .5671 .63663 .56361 .63349 Mtetra
.707 .61 .747 r
.56361 .63349 .5671 .63663 .56998 .63272 .56649 .62958 Mtetra
.725 .609 .727 r
.56649 .62958 .56998 .63272 .57285 .62755 .56936 .6244 Mtetra
.736 .608 .715 r
.56936 .6244 .57285 .62755 .5757 .62133 .57221 .61818 Mtetra
.742 .607 .708 r
.57221 .61818 .5757 .62133 .57854 .61436 .57505 .61121 Mtetra
.745 .607 .704 r
.57505 .61121 .57854 .61436 .58138 .60697 .57789 .60382 Mtetra
.57789 .60382 .58138 .60697 .58421 .59955 .58073 .5964 Mtetra
.743 .607 .707 r
.58073 .5964 .58421 .59955 .58705 .59249 .58356 .58933 Mtetra
.737 .608 .714 r
.58356 .58933 .58705 .59249 .58989 .58614 .58641 .58298 Mtetra
.727 .609 .726 r
.58641 .58298 .58989 .58614 .59276 .58083 .58928 .57767 Mtetra
.708 .61 .745 r
.58928 .57767 .59276 .58083 .59564 .57681 .59216 .57365 Mtetra
.676 .61 .774 r
.59216 .57365 .59564 .57681 .59856 .57421 .59508 .57104 Mtetra
.614 .604 .817 r
.59508 .57104 .59856 .57421 .6015 .57305 .59802 .56988 Mtetra
.487 .577 .871 r
.59802 .56988 .6015 .57305 .60447 .57321 .60099 .57004 Mtetra
.245 .489 .891 r
.60099 .57004 .60447 .57321 .60747 .57444 .60398 .57127 Mtetra
0 .341 .818 r
.60398 .57127 .60747 .57444 .61049 .57636 .607 .57319 Mtetra
0 .274 .765 r
.607 .57319 .61049 .57636 .61353 .5785 .61003 .57532 Mtetra
.005 .369 .837 r
.61003 .57532 .61353 .5785 .61656 .58034 .61306 .57715 Mtetra
.314 .518 .894 r
.61306 .57715 .61656 .58034 .61959 .58135 .61608 .57817 Mtetra
.534 .589 .856 r
.61608 .57817 .61959 .58135 .62259 .58115 .61908 .57795 Mtetra
.64 .607 .801 r
.61908 .57795 .62259 .58115 .62557 .57947 .62206 .57627 Mtetra
.69 .61 .763 r
.62206 .57627 .62557 .57947 .62852 .57632 .62501 .57313 Mtetra
.713 .61 .741 r
.62501 .57313 .62852 .57632 .63144 .572 .62793 .5688 Mtetra
.721 .61 .732 r
.62793 .5688 .63144 .572 .63436 .56707 .63085 .56388 Mtetra
.719 .61 .734 r
.63085 .56388 .63436 .56707 .63727 .56231 .63376 .55911 Mtetra
.703 .61 .75 r
.63376 .55911 .63727 .56231 .64022 .55852 .6367 .55531 Mtetra
.664 .609 .783 r
.6367 .55531 .64022 .55852 .6432 .55623 .63969 .55302 Mtetra
.591 .6 .83 r
.63969 .55302 .6432 .55623 .64622 .55539 .64271 .55218 Mtetra
.55 .592 .849 r
.64271 .55218 .64622 .55539 .64926 .55502 .64575 .55181 Mtetra
.636 .607 .803 r
.64575 .55181 .64926 .55502 .65228 .55342 .64876 .5502 Mtetra
.682 .61 .769 r
.64876 .5502 .65228 .55342 .65526 .55053 .65174 .54731 Mtetra
.636 .607 .803 r
.65174 .54731 .65526 .55053 .65829 .54892 .65476 .54569 Mtetra
.55 .592 .849 r
.65476 .54569 .65829 .54892 .66135 .54855 .65782 .54532 Mtetra
.591 .6 .83 r
.65782 .54532 .66135 .54855 .6644 .5477 .66088 .54447 Mtetra
.664 .609 .783 r
.66088 .54447 .6644 .5477 .66742 .54539 .66389 .54216 Mtetra
.703 .611 .75 r
.66389 .54216 .66742 .54539 .6704 .54155 .66687 .53832 Mtetra
.719 .61 .734 r
.66687 .53832 .6704 .54155 .67334 .53675 .66981 .53352 Mtetra
.722 .61 .732 r
.66981 .53352 .67334 .53675 .67629 .53178 .67276 .52854 Mtetra
.713 .61 .741 r
.67276 .52854 .67629 .53178 .67925 .52741 .67572 .52417 Mtetra
.69 .61 .763 r
.67572 .52417 .67925 .52741 .68225 .52421 .67872 .52097 Mtetra
.641 .607 .8 r
.67872 .52097 .68225 .52421 .68531 .52247 .68177 .51923 Mtetra
.54 .59 .853 r
.68177 .51923 .68531 .52247 .68841 .5222 .68488 .51895 Mtetra
.341 .527 .893 r
.68488 .51895 .68841 .5222 .69157 .52316 .68803 .51991 Mtetra
.074 .404 .858 r
.68803 .51991 .69157 .52316 .69476 .52495 .69122 .5217 Mtetra
0 .325 .807 r
.69122 .5217 .69476 .52495 .69797 .52706 .69443 .5238 Mtetra
.03 .381 .844 r
.69443 .5238 .69797 .52706 .70118 .52896 .69764 .5257 Mtetra
.28 .502 .893 r
.69764 .5257 .70118 .52896 .70438 .53017 .70083 .52691 Mtetra
.494 .578 .868 r
.70083 .52691 .70438 .53017 .70754 .53029 .70399 .52703 Mtetra
.614 .604 .817 r
.70399 .52703 .70754 .53029 .71067 .52906 .70711 .52579 Mtetra
.675 .61 .775 r
.70711 .52579 .71067 .52906 .71374 .52635 .71018 .52308 Mtetra
.708 .611 .746 r
.71018 .52308 .71374 .52635 .71675 .52218 .71319 .51891 Mtetra
.727 .61 .726 r
.71319 .51891 .71675 .52218 .71972 .5167 .71616 .51342 Mtetra
.738 .609 .714 r
.71616 .51342 .71972 .5167 .72265 .51015 .71909 .50687 Mtetra
.744 .608 .707 r
.71909 .50687 .72265 .51015 .72555 .50288 .72199 .4996 Mtetra
.747 .608 .704 r
.72199 .4996 .72555 .50288 .72843 .49525 .72487 .49197 Mtetra
.72487 .49197 .72843 .49525 .73131 .48767 .72776 .48439 Mtetra
.744 .608 .708 r
.72776 .48439 .73131 .48767 .73421 .48051 .73066 .47722 Mtetra
.737 .609 .715 r
.73066 .47722 .73421 .48051 .73714 .47411 .73359 .47083 Mtetra
.726 .61 .728 r
.73359 .47083 .73714 .47411 .74011 .46877 .73656 .46548 Mtetra
.707 .611 .747 r
.73656 .46548 .74011 .46877 .74314 .46468 .73959 .46139 Mtetra
.674 .61 .776 r
.73959 .46139 .74314 .46468 .74623 .46199 .74268 .4587 Mtetra
.613 .603 .817 r
.74268 .4587 .74623 .46199 .74939 .46075 .74584 .45746 Mtetra
.486 .575 .87 r
.74584 .45746 .74939 .46075 .75262 .46094 .74907 .45764 Mtetra
.203 .466 .884 r
.74907 .45764 .75262 .46094 .75592 .46246 .75236 .45915 Mtetra
0 .185 .686 r
.75236 .45915 .75592 .46246 .75928 .46513 .75572 .46182 Mtetra
.634 .109 0 r
.75572 .46182 .75928 .46513 .76269 .46874 .75912 .46543 Mtetra
.765 .258 0 r
.75912 .46543 .76269 .46874 .76615 .47302 .76257 .4697 Mtetra
.805 .315 0 r
.76257 .4697 .76615 .47302 .76963 .47767 .76605 .47434 Mtetra
.809 .321 0 r
.76605 .47434 .76963 .47767 .77313 .48238 .76955 .47905 Mtetra
.782 .282 0 r
.76955 .47905 .77313 .48238 .77663 .48685 .77304 .48351 Mtetra
.693 .171 0 r
.77304 .48351 .77663 .48685 .78012 .49076 .77652 .48743 Mtetra
0 .068 .562 r
.77652 .48743 .78012 .49076 .78358 .49386 .77997 .49052 Mtetra
.03 .379 .843 r
.77997 .49052 .78358 .49386 .78699 .4959 .78338 .49255 Mtetra
.393 .545 .888 r
.78338 .49255 .78699 .4959 .79035 .49668 .78674 .49333 Mtetra
.568 .595 .841 r
.78674 .49333 .79035 .49668 .79364 .49608 .79003 .49273 Mtetra
.65 .609 .794 r
.79003 .49273 .79364 .49608 .79686 .49401 .79325 .49066 Mtetra
.694 .611 .759 r
.79325 .49066 .79686 .49401 .80001 .49046 .7964 .4871 Mtetra
.72 .611 .735 r
.7964 .4871 .80001 .49046 .80309 .48545 .79947 .48208 Mtetra
.736 .61 .718 r
.79947 .48208 .80309 .48545 .80609 .47907 .80248 .47571 Mtetra
.747 .609 .705 r
.80248 .47571 .80609 .47907 .80903 .47147 .80541 .46811 Mtetra
.754 .608 .696 r
.80541 .46811 .80903 .47147 .8119 .46283 .80829 .45947 Mtetra
.759 .607 .69 r
.80829 .45947 .8119 .46283 .81473 .45336 .81112 .45 Mtetra
.762 .607 .686 r
.81112 .45 .81473 .45336 .81752 .44331 .81391 .43994 Mtetra
.763 .607 .684 r
.81391 .43994 .81752 .44331 .82028 .43293 .81668 .42956 Mtetra
.764 .607 .684 r
.81668 .42956 .82028 .43293 .82304 .42247 .81944 .41911 Mtetra
.763 .607 .685 r
.81944 .41911 .82304 .42247 .8258 .41221 .82221 .40884 Mtetra
.761 .607 .688 r
.82221 .40884 .8258 .41221 .82859 .40239 .825 .39902 Mtetra
.757 .608 .692 r
.825 .39902 .82859 .40239 .83141 .39323 .82782 .38986 Mtetra
.752 .608 .699 r
.82782 .38986 .83141 .39323 .83428 .38496 .83069 .38158 Mtetra
.744 .609 .708 r
.83069 .38158 .83428 .38496 .83721 .37774 .83362 .37437 Mtetra
.733 .61 .721 r
.83362 .37437 .83721 .37774 .84021 .37173 .83663 .36835 Mtetra
.715 .611 .739 r
.83663 .36835 .84021 .37173 .84329 .36703 .83971 .36366 Mtetra
.688 .611 .764 r
.83971 .36366 .84329 .36703 .84647 .36373 .84288 .36035 Mtetra
.641 .606 .799 r
.84288 .36035 .84647 .36373 .84973 .36187 .84615 .35849 Mtetra
.552 .59 .846 r
.84615 .35849 .84973 .36187 .8531 .36144 .84951 .35805 Mtetra
.364 .532 .888 r
.84951 .35805 .8531 .36144 .85656 .36241 .85297 .35902 Mtetra
0 .34 .818 r
.85297 .35902 .85656 .36241 .86011 .36472 .85652 .36133 Mtetra
.521 .007 0 r
.85652 .36133 .86011 .36472 .86376 .36826 .86016 .36487 Mtetra
.762 .255 0 r
.86016 .36487 .86376 .36826 .86749 .37291 .86389 .36951 Mtetra
.837 .37 .064 r
.86389 .36951 .86749 .37291 .8713 .3785 .86769 .37509 Mtetra
.861 .424 .167 r
.86769 .37509 .8713 .3785 .87517 .38486 .87155 .38144 Mtetra
.869 .451 .222 r
.87155 .38144 .87517 .38486 .8791 .39178 .87547 .38836 Mtetra
.872 .463 .249 r
.87547 .38836 .8791 .39178 .88307 .39907 .87944 .39564 Mtetra
.872 .467 .256 r
.87944 .39564 .88307 .39907 .88706 .40649 .88342 .40305 Mtetra
.872 .463 .247 r
.88342 .40305 .88706 .40649 .89107 .41381 .88742 .41037 Mtetra
.896 .547 .377 r
.43381 .66874 .4372 .67307 .43983 .68024 .43644 .6759 Mtetra
.895 .549 .384 r
.43644 .6759 .43983 .68024 .44248 .68757 .43908 .68322 Mtetra
.896 .548 .378 r
.43908 .68322 .44248 .68757 .44514 .69483 .44173 .69047 Mtetra
.898 .542 .358 r
.44173 .69047 .44514 .69483 .44781 .70181 .44439 .69744 Mtetra
.901 .528 .316 r
.44439 .69744 .44781 .70181 .45049 .7083 .44707 .70392 Mtetra
.9 .498 .236 r
.44707 .70392 .45049 .7083 .4532 .71409 .44977 .70971 Mtetra
.869 .424 .07 r
.44977 .70971 .4532 .71409 .45592 .719 .45248 .71461 Mtetra
.687 .212 0 r
.45248 .71461 .45592 .719 .45865 .72286 .45521 .71846 Mtetra
0 .199 .728 r
.45521 .71846 .45865 .72286 .4614 .72551 .45796 .7211 Mtetra
.329 .451 .833 r
.45796 .7211 .4614 .72551 .46417 .72685 .46072 .72244 Mtetra
.528 .532 .803 r
.46072 .72244 .46417 .72685 .46695 .7268 .4635 .72238 Mtetra
.617 .56 .767 r
.4635 .72238 .46695 .7268 .46974 .72531 .46628 .72089 Mtetra
.664 .572 .741 r
.46628 .72089 .46974 .72531 .47254 .72238 .46908 .71796 Mtetra
.692 .578 .723 r
.46908 .71796 .47254 .72238 .47534 .71806 .47189 .71364 Mtetra
.709 .582 .71 r
.47189 .71364 .47534 .71806 .47816 .71242 .4747 .708 Mtetra
.721 .584 .7 r
.4747 .708 .47816 .71242 .48097 .70559 .47752 .70117 Mtetra
.729 .585 .694 r
.47752 .70117 .48097 .70559 .48379 .69771 .48033 .6933 Mtetra
.735 .586 .689 r
.48033 .6933 .48379 .69771 .4866 .68899 .48315 .68457 Mtetra
.738 .586 .685 r
.48315 .68457 .4866 .68899 .48941 .67962 .48596 .67521 Mtetra
.741 .586 .683 r
.48596 .67521 .48941 .67962 .49222 .66985 .48878 .66544 Mtetra
.48878 .66544 .49222 .66985 .49503 .65992 .49159 .65551 Mtetra
.49159 .65551 .49503 .65992 .49783 .65009 .49439 .64569 Mtetra
.739 .586 .685 r
.49439 .64569 .49783 .65009 .50063 .64061 .49719 .6362 Mtetra
.736 .586 .687 r
.49719 .6362 .50063 .64061 .50343 .63171 .49999 .62731 Mtetra
.731 .585 .692 r
.49999 .62731 .50343 .63171 .50622 .62362 .50278 .61922 Mtetra
.724 .584 .698 r
.50278 .61922 .50622 .62362 .50901 .61653 .50558 .61213 Mtetra
.713 .582 .707 r
.50558 .61213 .50901 .61653 .51181 .61061 .50837 .60621 Mtetra
.697 .579 .72 r
.50837 .60621 .51181 .61061 .51461 .60598 .51117 .60158 Mtetra
.672 .574 .737 r
.51117 .60158 .51461 .60598 .51742 .60273 .51398 .59832 Mtetra
.631 .564 .76 r
.51398 .59832 .51742 .60273 .52023 .60087 .51679 .59647 Mtetra
.56 .542 .792 r
.51679 .59647 .52023 .60087 .52306 .60041 .51961 .596 Mtetra
.424 .492 .825 r
.51961 .596 .52306 .60041 .52589 .60126 .52245 .59684 Mtetra
.15 .363 .818 r
.52245 .59684 .52589 .60126 .52874 .60331 .52529 .59889 Mtetra
0 .103 .65 r
.52529 .59889 .52874 .60331 .53161 .60638 .52815 .60195 Mtetra
.63 .161 0 r
.52815 .60195 .53161 .60638 .53449 .61027 .53103 .60583 Mtetra
.774 .301 0 r
.53103 .60583 .53449 .61027 .53738 .61471 .53391 .61026 Mtetra
.816 .35 0 r
.53391 .61026 .53738 .61471 .54028 .61942 .53681 .61497 Mtetra
.81 .342 0 r
.53681 .61497 .54028 .61942 .5432 .62411 .53972 .61965 Mtetra
.746 .271 0 r
.53972 .61965 .5432 .62411 .54612 .62846 .54263 .624 Mtetra
0 0 .446 r
.54263 .624 .54612 .62846 .54904 .63218 .54555 .62771 Mtetra
0 .201 .73 r
.54555 .62771 .54904 .63218 .55197 .635 .54847 .63052 Mtetra
.269 .423 .832 r
.54847 .63052 .55197 .635 .55489 .63668 .55139 .6322 Mtetra
.488 .517 .813 r
.55139 .6322 .55489 .63668 .55781 .63705 .5543 .63256 Mtetra
.594 .553 .778 r
.5543 .63256 .55781 .63705 .56071 .636 .55721 .6315 Mtetra
.651 .569 .75 r
.55721 .6315 .56071 .636 .56361 .63349 .5601 .62899 Mtetra
.683 .576 .729 r
.5601 .62899 .56361 .63349 .56649 .62958 .56298 .62508 Mtetra
.703 .58 .715 r
.56298 .62508 .56649 .62958 .56936 .6244 .56585 .6199 Mtetra
.715 .583 .706 r
.56585 .6199 .56936 .6244 .57221 .61818 .5687 .61368 Mtetra
.722 .584 .7 r
.5687 .61368 .57221 .61818 .57505 .61121 .57155 .60671 Mtetra
.725 .584 .697 r
.57155 .60671 .57505 .61121 .57789 .60382 .57438 .59932 Mtetra
.726 .584 .697 r
.57438 .59932 .57789 .60382 .58073 .5964 .57722 .5919 Mtetra
.723 .584 .699 r
.57722 .5919 .58073 .5964 .58356 .58933 .58006 .58484 Mtetra
.716 .583 .705 r
.58006 .58484 .58356 .58933 .58641 .58298 .58291 .57849 Mtetra
.704 .581 .714 r
.58291 .57849 .58641 .58298 .58928 .57767 .58577 .57318 Mtetra
.685 .577 .728 r
.58577 .57318 .58928 .57767 .59216 .57365 .58866 .56915 Mtetra
.653 .569 .748 r
.58866 .56915 .59216 .57365 .59508 .57104 .59157 .56654 Mtetra
.599 .555 .776 r
.59157 .56654 .59508 .57104 .59802 .56988 .59451 .56538 Mtetra
.509 .525 .808 r
.59451 .56538 .59802 .56988 .60099 .57004 .59747 .56553 Mtetra
.372 .469 .831 r
.59747 .56553 .60099 .57004 .60398 .57127 .60046 .56675 Mtetra
.223 .4 .828 r
.60046 .56675 .60398 .57127 .607 .57319 .60348 .56867 Mtetra
.163 .37 .82 r
.60348 .56867 .607 .57319 .61003 .57532 .6065 .5708 Mtetra
.249 .413 .83 r
.6065 .5708 .61003 .57532 .61306 .57715 .60953 .57262 Mtetra
.408 .485 .827 r
.60953 .57262 .61306 .57715 .61608 .57817 .61254 .57363 Mtetra
.54 .536 .799 r
.61254 .57363 .61608 .57817 .61908 .57795 .61554 .57341 Mtetra
.621 .561 .766 r
.61554 .57341 .61908 .57795 .62206 .57627 .61852 .57173 Mtetra
.666 .573 .741 r
.61852 .57173 .62206 .57627 .62501 .57313 .62147 .56858 Mtetra
.689 .578 .725 r
.62147 .56858 .62501 .57313 .62793 .5688 .62439 .56425 Mtetra
.698 .58 .718 r
.62439 .56425 .62793 .5688 .63085 .56388 .6273 .55933 Mtetra
.696 .579 .72 r
.6273 .55933 .63085 .56388 .63376 .55911 .63022 .55456 Mtetra
.68 .576 .732 r
.63022 .55456 .63376 .55911 .6367 .55531 .63316 .55076 Mtetra
.642 .567 .754 r
.63316 .55076 .6367 .55531 .63969 .55302 .63614 .54846 Mtetra
.581 .549 .784 r
.63614 .54846 .63969 .55302 .64271 .55218 .63916 .54762 Mtetra
.551 .539 .795 r
.63916 .54762 .64271 .55218 .64575 .55181 .64219 .54725 Mtetra
.618 .56 .767 r
.64219 .54725 .64575 .55181 .64876 .5502 .6452 .54563 Mtetra
.659 .571 .745 r
.6452 .54563 .64876 .5502 .65174 .54731 .64818 .54274 Mtetra
.618 .56 .767 r
.64818 .54274 .65174 .54731 .65476 .54569 .6512 .54112 Mtetra
.551 .539 .795 r
.6512 .54112 .65476 .54569 .65782 .54532 .65426 .54075 Mtetra
.581 .549 .784 r
.65426 .54075 .65782 .54532 .66088 .54447 .65731 .53989 Mtetra
.642 .567 .755 r
.65731 .53989 .66088 .54447 .66389 .54216 .66032 .53757 Mtetra
.679 .576 .732 r
.66032 .53757 .66389 .54216 .66687 .53832 .6633 .53373 Mtetra
.696 .579 .72 r
.6633 .53373 .66687 .53832 .66981 .53352 .66624 .52893 Mtetra
.698 .58 .718 r
.66624 .52893 .66981 .53352 .67276 .52854 .66919 .52395 Mtetra
.689 .578 .725 r
.66919 .52395 .67276 .52854 .67572 .52417 .67215 .51958 Mtetra
.666 .573 .741 r
.67215 .51958 .67572 .52417 .67872 .52097 .67515 .51637 Mtetra
.622 .561 .765 r
.67515 .51637 .67872 .52097 .68177 .51923 .6782 .51463 Mtetra
.544 .537 .797 r
.6782 .51463 .68177 .51923 .68488 .51895 .6813 .51435 Mtetra
.422 .491 .825 r
.6813 .51435 .68488 .51895 .68803 .51991 .68445 .51531 Mtetra
.281 .428 .832 r
.68445 .51531 .68803 .51991 .69122 .5217 .68763 .51709 Mtetra
.206 .392 .826 r
.68763 .51709 .69122 .5217 .69443 .5238 .69083 .51919 Mtetra
.258 .417 .831 r
.69083 .51919 .69443 .5238 .69764 .5257 .69404 .52108 Mtetra
.388 .477 .829 r
.69404 .52108 .69764 .5257 .70083 .52691 .69723 .52228 Mtetra
.513 .526 .807 r
.69723 .52228 .70083 .52691 .70399 .52703 .70038 .52239 Mtetra
.599 .555 .776 r
.70038 .52239 .70399 .52703 .70711 .52579 .7035 .52115 Mtetra
.652 .569 .749 r
.7035 .52115 .70711 .52579 .71018 .52308 .70657 .51844 Mtetra
.684 .577 .728 r
.70657 .51844 .71018 .52308 .71319 .51891 .70958 .51426 Mtetra
.704 .581 .714 r
.70958 .51426 .71319 .51891 .71616 .51342 .71255 .50877 Mtetra
.717 .583 .705 r
.71255 .50877 .71616 .51342 .71909 .50687 .71548 .50223 Mtetra
.723 .584 .699 r
.71548 .50223 .71909 .50687 .72199 .4996 .71838 .49495 Mtetra
.726 .585 .696 r
.71838 .49495 .72199 .4996 .72487 .49197 .72127 .48733 Mtetra
.726 .585 .697 r
.72127 .48733 .72487 .49197 .72776 .48439 .72415 .47974 Mtetra
.722 .584 .7 r
.72415 .47974 .72776 .48439 .73066 .47722 .72705 .47258 Mtetra
.715 .583 .706 r
.72705 .47258 .73066 .47722 .73359 .47083 .72998 .46619 Mtetra
.703 .58 .715 r
.72998 .46619 .73359 .47083 .73656 .46548 .73295 .46083 Mtetra
.683 .576 .73 r
.73295 .46083 .73656 .46548 .73959 .46139 .73598 .45674 Mtetra
.651 .569 .749 r
.73598 .45674 .73959 .46139 .74268 .4587 .73907 .45405 Mtetra
.599 .554 .776 r
.73907 .45405 .74268 .4587 .74584 .45746 .74223 .45281 Mtetra
.508 .524 .808 r
.74223 .45281 .74584 .45746 .74907 .45764 .74545 .45299 Mtetra
.346 .458 .832 r
.74545 .45299 .74907 .45764 .75236 .45915 .74874 .45449 Mtetra
.074 .322 .801 r
.74874 .45449 .75236 .45915 .75572 .46182 .75209 .45715 Mtetra
0 .12 .665 r
.75209 .45715 .75572 .46182 .75912 .46543 .75549 .46075 Mtetra
0 0 .489 r
.75549 .46075 .75912 .46543 .76257 .4697 .75893 .46501 Mtetra
.611 .146 0 r
.75893 .46501 .76257 .4697 .76605 .47434 .76241 .46965 Mtetra
.623 .157 0 r
.76241 .46965 .76605 .47434 .76955 .47905 .76589 .47435 Mtetra
0 0 .446 r
.76589 .47435 .76955 .47905 .77304 .48351 .76938 .4788 Mtetra
0 .057 .607 r
.76938 .4788 .77304 .48351 .77652 .48743 .77286 .48271 Mtetra
0 .256 .766 r
.77286 .48271 .77652 .48743 .77997 .49052 .7763 .48579 Mtetra
.255 .415 .83 r
.7763 .48579 .77997 .49052 .78338 .49255 .77971 .48782 Mtetra
.451 .502 .821 r
.77971 .48782 .78338 .49255 .78674 .49333 .78306 .48859 Mtetra
.564 .543 .79 r
.78306 .48859 .78674 .49333 .79003 .49273 .78634 .48799 Mtetra
.63 .563 .761 r
.78634 .48799 .79003 .49273 .79325 .49066 .78956 .48591 Mtetra
.67 .574 .738 r
.78956 .48591 .79325 .49066 .7964 .4871 .79271 .48235 Mtetra
.696 .579 .72 r
.79271 .48235 .7964 .4871 .79947 .48208 .79579 .47733 Mtetra
.713 .583 .707 r
.79579 .47733 .79947 .48208 .80248 .47571 .79879 .47096 Mtetra
.725 .585 .697 r
.79879 .47096 .80248 .47571 .80541 .46811 .80173 .46336 Mtetra
.734 .586 .69 r
.80173 .46336 .80541 .46811 .80829 .45947 .80461 .45472 Mtetra
.739 .587 .685 r
.80461 .45472 .80829 .45947 .81112 .45 .80744 .44525 Mtetra
.743 .587 .682 r
.80744 .44525 .81112 .45 .81391 .43994 .81023 .4352 Mtetra
.745 .587 .68 r
.81023 .4352 .81391 .43994 .81668 .42956 .81301 .42482 Mtetra
.81301 .42482 .81668 .42956 .81944 .41911 .81577 .41437 Mtetra
.744 .587 .681 r
.81577 .41437 .81944 .41911 .82221 .40884 .81854 .40411 Mtetra
.742 .587 .683 r
.81854 .40411 .82221 .40884 .825 .39902 .82133 .39429 Mtetra
.738 .586 .687 r
.82133 .39429 .825 .39902 .82782 .38986 .82415 .38513 Mtetra
.731 .585 .692 r
.82415 .38513 .82782 .38986 .83069 .38158 .82703 .37686 Mtetra
.722 .584 .7 r
.82703 .37686 .83069 .38158 .83362 .37437 .82996 .36964 Mtetra
.71 .582 .71 r
.82996 .36964 .83362 .37437 .83663 .36835 .83296 .36362 Mtetra
.691 .578 .724 r
.83296 .36362 .83663 .36835 .83971 .36366 .83605 .35893 Mtetra
.664 .572 .742 r
.83605 .35893 .83971 .36366 .84288 .36035 .83922 .35562 Mtetra
.622 .561 .765 r
.83922 .35562 .84288 .36035 .84615 .35849 .84248 .35375 Mtetra
.553 .54 .794 r
.84248 .35375 .84615 .35849 .84951 .35805 .84584 .35331 Mtetra
.432 .495 .823 r
.84584 .35331 .84951 .35805 .85297 .35902 .84929 .35428 Mtetra
.214 .395 .826 r
.84929 .35428 .85297 .35902 .85652 .36133 .85283 .35658 Mtetra
0 .197 .727 r
.85283 .35658 .85652 .36133 .86016 .36487 .85647 .36011 Mtetra
0 0 .484 r
.85647 .36011 .86016 .36487 .86389 .36951 .86019 .36474 Mtetra
.726 .252 0 r
.86019 .36474 .86389 .36951 .86769 .37509 .86398 .37031 Mtetra
.82 .356 0 r
.86398 .37031 .86769 .37509 .87155 .38144 .86784 .37665 Mtetra
.858 .408 .033 r
.86784 .37665 .87155 .38144 .87547 .38836 .87175 .38356 Mtetra
.873 .432 .081 r
.87175 .38356 .87547 .38836 .87944 .39564 .87571 .39083 Mtetra
.877 .438 .094 r
.87571 .39083 .87944 .39564 .88342 .40305 .87968 .39823 Mtetra
.872 .43 .077 r
.87968 .39823 .88342 .40305 .88742 .41037 .88367 .40554 Mtetra
.925 .553 .289 r
.43044 .66322 .43381 .66874 .43644 .6759 .43306 .67037 Mtetra
.925 .557 .3 r
.43306 .67037 .43644 .6759 .43908 .68322 .43569 .67768 Mtetra
.925 .554 .291 r
.43569 .67768 .43908 .68322 .44173 .69047 .43833 .68492 Mtetra
.924 .543 .258 r
.43833 .68492 .44173 .69047 .44439 .69744 .44099 .69188 Mtetra
.917 .518 .188 r
.44099 .69188 .44439 .69744 .44707 .70392 .44366 .69835 Mtetra
.881 .459 .052 r
.44366 .69835 .44707 .70392 .44977 .70971 .44635 .70412 Mtetra
.742 .31 0 r
.44635 .70412 .44977 .70971 .45248 .71461 .44906 .70901 Mtetra
0 0 .568 r
.44906 .70901 .45248 .71461 .45521 .71846 .45178 .71285 Mtetra
.117 .291 .765 r
.45178 .71285 .45521 .71846 .45796 .7211 .45452 .71549 Mtetra
.394 .438 .787 r
.45452 .71549 .45796 .7211 .46072 .72244 .45728 .71681 Mtetra
.532 .5 .767 r
.45728 .71681 .46072 .72244 .4635 .72238 .46005 .71675 Mtetra
.605 .53 .744 r
.46005 .71675 .4635 .72238 .46628 .72089 .46284 .71525 Mtetra
.648 .546 .726 r
.46284 .71525 .46628 .72089 .46908 .71796 .46563 .71233 Mtetra
.675 .556 .712 r
.46563 .71233 .46908 .71796 .47189 .71364 .46844 .708 Mtetra
.694 .562 .702 r
.46844 .708 .47189 .71364 .4747 .708 .47125 .70237 Mtetra
.706 .566 .694 r
.47125 .70237 .4747 .708 .47752 .70117 .47406 .69553 Mtetra
.715 .569 .689 r
.47406 .69553 .47752 .70117 .48033 .6933 .47688 .68766 Mtetra
.721 .571 .684 r
.47688 .68766 .48033 .6933 .48315 .68457 .4797 .67894 Mtetra
.725 .572 .682 r
.4797 .67894 .48315 .68457 .48596 .67521 .48252 .66958 Mtetra
.728 .573 .68 r
.48252 .66958 .48596 .67521 .48878 .66544 .48533 .65982 Mtetra
.729 .573 .679 r
.48533 .65982 .48878 .66544 .49159 .65551 .48814 .6499 Mtetra
.728 .573 .68 r
.48814 .6499 .49159 .65551 .49439 .64569 .49095 .64008 Mtetra
.726 .572 .681 r
.49095 .64008 .49439 .64569 .49719 .6362 .49375 .6306 Mtetra
.723 .571 .683 r
.49375 .6306 .49719 .6362 .49999 .62731 .49655 .62171 Mtetra
.717 .569 .687 r
.49655 .62171 .49999 .62731 .50278 .61922 .49935 .61362 Mtetra
.709 .567 .692 r
.49935 .61362 .50278 .61922 .50558 .61213 .50214 .60654 Mtetra
.697 .563 .7 r
.50214 .60654 .50558 .61213 .50837 .60621 .50494 .60062 Mtetra
.68 .558 .709 r
.50494 .60062 .50837 .60621 .51117 .60158 .50774 .59599 Mtetra
.655 .549 .722 r
.50774 .59599 .51117 .60158 .51398 .59832 .51054 .59273 Mtetra
.618 .535 .739 r
.51054 .59273 .51398 .59832 .51679 .59647 .51335 .59087 Mtetra
.557 .511 .76 r
.51335 .59087 .51679 .59647 .51961 .596 .51617 .5904 Mtetra
.456 .467 .782 r
.51617 .5904 .51961 .596 .52245 .59684 .519 .59124 Mtetra
.283 .383 .788 r
.519 .59124 .52245 .59684 .52529 .59889 .52184 .59327 Mtetra
.015 .233 .74 r
.52184 .59327 .52529 .59889 .52815 .60195 .52469 .59633 Mtetra
0 .038 .607 r
.52469 .59633 .52815 .60195 .53103 .60583 .52756 .6002 Mtetra
0 0 .454 r
.52756 .6002 .53103 .60583 .53391 .61026 .53044 .60462 Mtetra
0 0 .371 r
.53044 .60462 .53391 .61026 .53681 .61497 .53333 .60932 Mtetra
0 0 .385 r
.53333 .60932 .53681 .61497 .53972 .61965 .53623 .61398 Mtetra
0 0 .495 r
.53623 .61398 .53972 .61965 .54263 .624 .53914 .61832 Mtetra
0 .099 .656 r
.53914 .61832 .54263 .624 .54555 .62771 .54205 .62203 Mtetra
.114 .291 .765 r
.54205 .62203 .54555 .62771 .54847 .63052 .54497 .62483 Mtetra
.356 .419 .789 r
.54497 .62483 .54847 .63052 .55139 .6322 .54788 .6265 Mtetra
.501 .487 .774 r
.54788 .6265 .55139 .6322 .5543 .63256 .55079 .62685 Mtetra
.585 .523 .751 r
.55079 .62685 .5543 .63256 .55721 .6315 .55369 .62579 Mtetra
.635 .542 .732 r
.55369 .62579 .55721 .6315 .5601 .62899 .55658 .62328 Mtetra
.666 .553 .717 r
.55658 .62328 .5601 .62899 .56298 .62508 .55946 .61936 Mtetra
.686 .56 .706 r
.55946 .61936 .56298 .62508 .56585 .6199 .56233 .61419 Mtetra
.699 .564 .698 r
.56233 .61419 .56585 .6199 .5687 .61368 .56518 .60797 Mtetra
.707 .566 .694 r
.56518 .60797 .5687 .61368 .57155 .60671 .56802 .601 Mtetra
.71 .567 .691 r
.56802 .601 .57155 .60671 .57438 .59932 .57086 .59361 Mtetra
.711 .567 .691 r
.57086 .59361 .57438 .59932 .57722 .5919 .5737 .5862 Mtetra
.708 .566 .693 r
.5737 .5862 .57722 .5919 .58006 .58484 .57654 .57913 Mtetra
.7 .564 .698 r
.57654 .57913 .58006 .58484 .58291 .57849 .57939 .57278 Mtetra
.688 .56 .705 r
.57939 .57278 .58291 .57849 .58577 .57318 .58225 .56747 Mtetra
.668 .554 .716 r
.58225 .56747 .58577 .57318 .58866 .56915 .58513 .56344 Mtetra
.637 .543 .731 r
.58513 .56344 .58866 .56915 .59157 .56654 .58804 .56084 Mtetra
.589 .524 .75 r
.58804 .56084 .59157 .56654 .59451 .56538 .59098 .55966 Mtetra
.517 .495 .771 r
.59098 .55966 .59451 .56538 .59747 .56553 .59394 .55981 Mtetra
.42 .451 .786 r
.59394 .55981 .59747 .56553 .60046 .56675 .59693 .56103 Mtetra
.326 .405 .79 r
.59693 .56103 .60046 .56675 .60348 .56867 .59993 .56294 Mtetra
.29 .387 .789 r
.59993 .56294 .60348 .56867 .6065 .5708 .60295 .56506 Mtetra
.342 .413 .79 r
.60295 .56506 .6065 .5708 .60953 .57262 .60597 .56687 Mtetra
.445 .462 .783 r
.60597 .56687 .60953 .57262 .61254 .57363 .60899 .56787 Mtetra
.541 .505 .765 r
.60899 .56787 .61254 .57363 .61554 .57341 .61198 .56765 Mtetra
.608 .532 .743 r
.61198 .56765 .61554 .57341 .61852 .57173 .61495 .56596 Mtetra
.649 .547 .725 r
.61495 .56596 .61852 .57173 .62147 .56858 .6179 .56281 Mtetra
.672 .555 .714 r
.6179 .56281 .62147 .56858 .62439 .56425 .62082 .55849 Mtetra
.682 .558 .708 r
.62082 .55849 .62439 .56425 .6273 .55933 .62373 .55356 Mtetra
.679 .557 .71 r
.62373 .55356 .6273 .55933 .63022 .55456 .62665 .54879 Mtetra
.663 .552 .719 r
.62665 .54879 .63022 .55456 .63316 .55076 .62958 .54499 Mtetra
.627 .539 .735 r
.62958 .54499 .63316 .55076 .63614 .54846 .63256 .54269 Mtetra
.574 .518 .755 r
.63256 .54269 .63614 .54846 .63916 .54762 .63558 .54184 Mtetra
.55 .508 .762 r
.63558 .54184 .63916 .54762 .64219 .54725 .63861 .54146 Mtetra
.605 .531 .744 r
.63861 .54146 .64219 .54725 .6452 .54563 .64162 .53985 Mtetra
.643 .545 .728 r
.64162 .53985 .6452 .54563 .64818 .54274 .64459 .53695 Mtetra
.605 .531 .744 r
.64459 .53695 .64818 .54274 .6512 .54112 .64761 .53533 Mtetra
.55 .509 .762 r
.64761 .53533 .6512 .54112 .65426 .54075 .65066 .53495 Mtetra
.574 .518 .755 r
.65066 .53495 .65426 .54075 .65731 .53989 .65371 .53408 Mtetra
.627 .539 .735 r
.65371 .53408 .65731 .53989 .66032 .53757 .65672 .53176 Mtetra
.663 .552 .719 r
.65672 .53176 .66032 .53757 .6633 .53373 .65969 .52792 Mtetra
.679 .557 .71 r
.65969 .52792 .6633 .53373 .66624 .52893 .66264 .52312 Mtetra
.682 .558 .708 r
.66264 .52312 .66624 .52893 .66919 .52395 .66558 .51814 Mtetra
.672 .555 .714 r
.66558 .51814 .66919 .52395 .67215 .51958 .66854 .51377 Mtetra
.649 .547 .725 r
.66854 .51377 .67215 .51958 .67515 .51637 .67154 .51056 Mtetra
.609 .532 .743 r
.67154 .51056 .67515 .51637 .6782 .51463 .67458 .50881 Mtetra
.544 .506 .764 r
.67458 .50881 .6782 .51463 .6813 .51435 .67768 .50853 Mtetra
.454 .467 .782 r
.67768 .50853 .6813 .51435 .68445 .51531 .68082 .50948 Mtetra
.361 .423 .79 r
.68082 .50948 .68445 .51531 .68763 .51709 .684 .51125 Mtetra
.315 .4 .79 r
.684 .51125 .68763 .51709 .69083 .51919 .6872 .51334 Mtetra
.347 .416 .791 r
.6872 .51334 .69083 .51919 .69404 .52108 .6904 .51522 Mtetra
.431 .456 .785 r
.6904 .51522 .69404 .52108 .69723 .52228 .69358 .51641 Mtetra
.52 .496 .77 r
.69358 .51641 .69723 .52228 .70038 .52239 .69673 .51652 Mtetra
.589 .525 .75 r
.69673 .51652 .70038 .52239 .7035 .52115 .69985 .51528 Mtetra
.636 .542 .731 r
.69985 .51528 .7035 .52115 .70657 .51844 .70291 .51256 Mtetra
.667 .553 .716 r
.70291 .51256 .70657 .51844 .70958 .51426 .70592 .50838 Mtetra
.688 .56 .705 r
.70592 .50838 .70958 .51426 .71255 .50877 .70889 .5029 Mtetra
.7 .564 .697 r
.70889 .5029 .71255 .50877 .71548 .50223 .71182 .49635 Mtetra
.708 .566 .693 r
.71182 .49635 .71548 .50223 .71838 .49495 .71472 .48908 Mtetra
.711 .567 .69 r
.71472 .48908 .71838 .49495 .72127 .48733 .71761 .48146 Mtetra
.71 .567 .691 r
.71761 .48146 .72127 .48733 .72415 .47974 .72049 .47388 Mtetra
.707 .566 .693 r
.72049 .47388 .72415 .47974 .72705 .47258 .72339 .46672 Mtetra
.699 .563 .698 r
.72339 .46672 .72705 .47258 .72998 .46619 .72632 .46032 Mtetra
.686 .559 .706 r
.72632 .46032 .72998 .46619 .73295 .46083 .7293 .45497 Mtetra
.666 .553 .717 r
.7293 .45497 .73295 .46083 .73598 .45674 .73232 .45088 Mtetra
.636 .542 .732 r
.73232 .45088 .73598 .45674 .73907 .45405 .73541 .44818 Mtetra
.589 .525 .75 r
.73541 .44818 .73907 .45405 .74223 .45281 .73856 .44693 Mtetra
.516 .495 .771 r
.73856 .44693 .74223 .45281 .74545 .45299 .74178 .44711 Mtetra
.402 .443 .789 r
.74178 .44711 .74545 .45299 .74874 .45449 .74506 .4486 Mtetra
.232 .358 .786 r
.74506 .4486 .74874 .45449 .75209 .45715 .74841 .45126 Mtetra
.019 .238 .743 r
.74841 .45126 .75209 .45715 .75549 .46075 .7518 .45484 Mtetra
0 .117 .668 r
.7518 .45484 .75549 .46075 .75893 .46501 .75524 .4591 Mtetra
0 .04 .607 r
.75524 .4591 .75893 .46501 .76241 .46965 .7587 .46372 Mtetra
0 .029 .599 r
.7587 .46372 .76241 .46965 .76589 .47435 .76218 .46841 Mtetra
0 .088 .647 r
.76218 .46841 .76589 .47435 .76938 .4788 .76566 .47285 Mtetra
0 .197 .721 r
.76566 .47285 .76938 .4788 .77286 .48271 .76913 .47674 Mtetra
.161 .319 .776 r
.76913 .47674 .77286 .48271 .7763 .48579 .77257 .47982 Mtetra
.344 .415 .791 r
.77257 .47982 .7763 .48579 .77971 .48782 .77597 .48183 Mtetra
.474 .476 .78 r
.77597 .48183 .77971 .48782 .78306 .48859 .77931 .4826 Mtetra
.56 .513 .76 r
.77931 .4826 .78306 .48859 .78634 .48799 .7826 .48199 Mtetra
.616 .535 .74 r
.7826 .48199 .78634 .48799 .78956 .48591 .78581 .47991 Mtetra
.653 .548 .723 r
.78581 .47991 .78956 .48591 .79271 .48235 .78896 .47635 Mtetra
.679 .557 .71 r
.78896 .47635 .79271 .48235 .79579 .47733 .79203 .47133 Mtetra
.697 .562 .699 r
.79203 .47133 .79579 .47733 .79879 .47096 .79503 .46496 Mtetra
.709 .566 .691 r
.79503 .46496 .79879 .47096 .80173 .46336 .79797 .45736 Mtetra
.718 .569 .685 r
.79797 .45736 .80173 .46336 .80461 .45472 .80085 .44872 Mtetra
.724 .57 .681 r
.80085 .44872 .80461 .45472 .80744 .44525 .80369 .43926 Mtetra
.728 .572 .678 r
.80369 .43926 .80744 .44525 .81023 .4352 .80648 .42922 Mtetra
.73 .572 .677 r
.80648 .42922 .81023 .4352 .81301 .42482 .80926 .41884 Mtetra
.731 .572 .676 r
.80926 .41884 .81301 .42482 .81577 .41437 .81203 .4084 Mtetra
.73 .572 .677 r
.81203 .4084 .81577 .41437 .81854 .40411 .8148 .39814 Mtetra
.727 .571 .679 r
.8148 .39814 .81854 .40411 .82133 .39429 .81759 .38833 Mtetra
.722 .57 .682 r
.81759 .38833 .82133 .39429 .82415 .38513 .82041 .37918 Mtetra
.716 .568 .687 r
.82041 .37918 .82415 .38513 .82703 .37686 .82329 .37091 Mtetra
.706 .565 .693 r
.82329 .37091 .82703 .37686 .82996 .36964 .82622 .36369 Mtetra
.693 .561 .702 r
.82622 .36369 .82996 .36964 .83296 .36362 .82922 .35768 Mtetra
.674 .555 .712 r
.82922 .35768 .83296 .36362 .83605 .35893 .83231 .35298 Mtetra
.648 .546 .726 r
.83231 .35298 .83605 .35893 .83922 .35562 .83547 .34967 Mtetra
.609 .532 .743 r
.83547 .34967 .83922 .35562 .84248 .35375 .83873 .3478 Mtetra
.551 .51 .763 r
.83873 .3478 .84248 .35375 .84584 .35331 .84209 .34735 Mtetra
.461 .471 .782 r
.84209 .34735 .84584 .35331 .84929 .35428 .84553 .34831 Mtetra
.316 .402 .792 r
.84553 .34831 .84929 .35428 .85283 .35658 .84907 .3506 Mtetra
.094 .283 .764 r
.84907 .3506 .85283 .35658 .85647 .36011 .8527 .35412 Mtetra
0 .107 .661 r
.8527 .35412 .85647 .36011 .86019 .36474 .85641 .35873 Mtetra
0 0 .491 r
.85641 .35873 .86019 .36474 .86398 .37031 .8602 .3643 Mtetra
.65 .223 0 r
.8602 .3643 .86398 .37031 .86784 .37665 .86405 .37062 Mtetra
.746 .308 0 r
.86405 .37062 .86784 .37665 .87175 .38356 .86795 .37752 Mtetra
.789 .35 0 r
.86795 .37752 .87175 .38356 .87571 .39083 .87189 .38477 Mtetra
.801 .361 0 r
.87189 .38477 .87571 .39083 .87968 .39823 .87586 .39215 Mtetra
.786 .347 0 r
.87586 .39215 .87968 .39823 .88367 .40554 .87984 .39945 Mtetra
.927 .541 .178 r
.42708 .6567 .43044 .66322 .43306 .67037 .42969 .66384 Mtetra
.93 .547 .195 r
.42969 .66384 .43306 .67037 .43569 .67768 .43231 .67112 Mtetra
.927 .542 .181 r
.43231 .67112 .43569 .67768 .43833 .68492 .43495 .67835 Mtetra
.915 .523 .131 r
.43495 .67835 .43833 .68492 .44099 .69188 .4376 .68529 Mtetra
.879 .476 .029 r
.4376 .68529 .44099 .69188 .44366 .69835 .44026 .69174 Mtetra
.772 .369 0 r
.44026 .69174 .44366 .69835 .44635 .70412 .44294 .6975 Mtetra
0 0 .432 r
.44294 .6975 .44635 .70412 .44906 .70901 .44564 .70238 Mtetra
0 .123 .666 r
.44564 .70238 .44906 .70901 .45178 .71285 .44836 .70621 Mtetra
.231 .323 .752 r
.44836 .70621 .45178 .71285 .45452 .71549 .4511 .70883 Mtetra
.425 .428 .759 r
.4511 .70883 .45452 .71549 .45728 .71681 .45385 .71015 Mtetra
.533 .482 .745 r
.45385 .71015 .45728 .71681 .46005 .71675 .45662 .71008 Mtetra
.597 .511 .729 r
.45662 .71008 .46005 .71675 .46284 .71525 .4594 .70858 Mtetra
.637 .529 .715 r
.4594 .70858 .46284 .71525 .46563 .71233 .46219 .70565 Mtetra
.663 .54 .704 r
.46219 .70565 .46563 .71233 .46844 .708 .46499 .70133 Mtetra
.682 .548 .696 r
.46499 .70133 .46844 .708 .47125 .70237 .4678 .69569 Mtetra
.695 .553 .689 r
.4678 .69569 .47125 .70237 .47406 .69553 .47062 .68887 Mtetra
.704 .557 .685 r
.47062 .68887 .47406 .69553 .47688 .68766 .47344 .681 Mtetra
.711 .559 .681 r
.47344 .681 .47688 .68766 .4797 .67894 .47626 .67229 Mtetra
.715 .561 .679 r
.47626 .67229 .4797 .67894 .48252 .66958 .47907 .66294 Mtetra
.718 .562 .677 r
.47907 .66294 .48252 .66958 .48533 .65982 .48189 .65318 Mtetra
.719 .562 .677 r
.48189 .65318 .48533 .65982 .48814 .6499 .4847 .64327 Mtetra
.718 .562 .677 r
.4847 .64327 .48814 .6499 .49095 .64008 .48751 .63345 Mtetra
.716 .562 .678 r
.48751 .63345 .49095 .64008 .49375 .6306 .49031 .62399 Mtetra
.712 .56 .68 r
.49031 .62399 .49375 .6306 .49655 .62171 .49311 .6151 Mtetra
.706 .558 .683 r
.49311 .6151 .49655 .62171 .49935 .61362 .49591 .60702 Mtetra
.698 .554 .688 r
.49591 .60702 .49935 .61362 .50214 .60654 .49871 .59994 Mtetra
.686 .55 .694 r
.49871 .59994 .50214 .60654 .50494 .60062 .5015 .59402 Mtetra
.669 .543 .702 r
.5015 .59402 .50494 .60062 .50774 .59599 .5043 .58939 Mtetra
.644 .533 .713 r
.5043 .58939 .50774 .59599 .51054 .59273 .5071 .58613 Mtetra
.608 .517 .725 r
.5071 .58613 .51054 .59273 .51335 .59087 .50991 .58427 Mtetra
.554 .492 .741 r
.50991 .58427 .51335 .59087 .51617 .5904 .51272 .58379 Mtetra
.471 .452 .755 r
.51272 .58379 .51617 .5904 .519 .59124 .51554 .58462 Mtetra
.344 .386 .762 r
.51554 .58462 .519 .59124 .52184 .59327 .51838 .58664 Mtetra
.16 .284 .743 r
.51838 .58664 .52184 .59327 .52469 .59633 .52123 .58969 Mtetra
0 .152 .684 r
.52123 .58969 .52469 .59633 .52756 .6002 .52409 .59355 Mtetra
0 .032 .603 r
.52409 .59355 .52756 .6002 .53044 .60462 .52696 .59796 Mtetra
0 0 .55 r
.52696 .59796 .53044 .60462 .53333 .60932 .52984 .60264 Mtetra
0 0 .56 r
.52984 .60264 .53333 .60932 .53623 .61398 .53274 .60729 Mtetra
0 .063 .626 r
.53274 .60729 .53623 .61398 .53914 .61832 .53564 .61162 Mtetra
.009 .194 .706 r
.53564 .61162 .53914 .61832 .54205 .62203 .53855 .61531 Mtetra
.227 .322 .753 r
.53855 .61531 .54205 .62203 .54497 .62483 .54146 .6181 Mtetra
.396 .414 .761 r
.54146 .6181 .54497 .62483 .54788 .6265 .54436 .61976 Mtetra
.508 .47 .75 r
.54436 .61976 .54788 .6265 .55079 .62685 .54727 .62011 Mtetra
.579 .504 .734 r
.54727 .62011 .55079 .62685 .55369 .62579 .55016 .61904 Mtetra
.625 .524 .72 r
.55016 .61904 .55369 .62579 .55658 .62328 .55305 .61652 Mtetra
.655 .537 .708 r
.55305 .61652 .55658 .62328 .55946 .61936 .55593 .61261 Mtetra
.674 .545 .699 r
.55593 .61261 .55946 .61936 .56233 .61419 .55879 .60744 Mtetra
.687 .55 .693 r
.55879 .60744 .56233 .61419 .56518 .60797 .56165 .60122 Mtetra
.695 .553 .689 r
.56165 .60122 .56518 .60797 .56802 .601 .56449 .59425 Mtetra
.699 .555 .687 r
.56449 .59425 .56802 .601 .57086 .59361 .56733 .58687 Mtetra
.56733 .58687 .57086 .59361 .5737 .5862 .57016 .57946 Mtetra
.696 .553 .688 r
.57016 .57946 .5737 .5862 .57654 .57913 .573 .5724 Mtetra
.689 .551 .692 r
.573 .5724 .57654 .57913 .57939 .57278 .57585 .56605 Mtetra
.676 .546 .698 r
.57585 .56605 .57939 .57278 .58225 .56747 .57871 .56075 Mtetra
.657 .537 .707 r
.57871 .56075 .58225 .56747 .58513 .56344 .58159 .55672 Mtetra
.627 .525 .719 r
.58159 .55672 .58513 .56344 .58804 .56084 .5845 .5541 Mtetra
.583 .505 .733 r
.5845 .5541 .58804 .56084 .59098 .55966 .58743 .55293 Mtetra
.521 .477 .748 r
.58743 .55293 .59098 .55966 .59394 .55981 .59039 .55307 Mtetra
.444 .439 .759 r
.59039 .55307 .59394 .55981 .59693 .56103 .59337 .55428 Mtetra
.374 .403 .763 r
.59337 .55428 .59693 .56103 .59993 .56294 .59637 .55617 Mtetra
.348 .389 .763 r
.59637 .55617 .59993 .56294 .60295 .56506 .59938 .55828 Mtetra
.385 .409 .762 r
.59938 .55828 .60295 .56506 .60597 .56687 .6024 .56009 Mtetra
.463 .448 .757 r
.6024 .56009 .60597 .56687 .60899 .56787 .60541 .56108 Mtetra
.541 .486 .744 r
.60541 .56108 .60899 .56787 .61198 .56765 .6084 .56086 Mtetra
.6 .513 .728 r
.6084 .56086 .61198 .56765 .61495 .56596 .61137 .55916 Mtetra
.638 .53 .714 r
.61137 .55916 .61495 .56596 .6179 .56281 .61431 .55601 Mtetra
.66 .539 .705 r
.61431 .55601 .6179 .56281 .62082 .55849 .61723 .55168 Mtetra
.67 .543 .701 r
.61723 .55168 .62082 .55849 .62373 .55356 .62014 .54675 Mtetra
.667 .542 .702 r
.62014 .54675 .62373 .55356 .62665 .54879 .62305 .54199 Mtetra
.651 .535 .709 r
.62305 .54199 .62665 .54879 .62958 .54499 .62599 .53819 Mtetra
.617 .521 .722 r
.62599 .53819 .62958 .54499 .63256 .54269 .62896 .53588 Mtetra
.569 .499 .737 r
.62896 .53588 .63256 .54269 .63558 .54184 .63197 .53502 Mtetra
.548 .49 .742 r
.63197 .53502 .63558 .54184 .63861 .54146 .635 .53465 Mtetra
.597 .512 .729 r
.635 .53465 .63861 .54146 .64162 .53985 .638 .53302 Mtetra
.632 .527 .717 r
.638 .53302 .64162 .53985 .64459 .53695 .64098 .53012 Mtetra
.597 .512 .729 r
.64098 .53012 .64459 .53695 .64761 .53533 .64399 .5285 Mtetra
.548 .49 .742 r
.64399 .5285 .64761 .53533 .65066 .53495 .64704 .52811 Mtetra
.569 .499 .737 r
.64704 .52811 .65066 .53495 .65371 .53408 .65008 .52724 Mtetra
.617 .521 .722 r
.65008 .52724 .65371 .53408 .65672 .53176 .65309 .52492 Mtetra
.651 .535 .709 r
.65309 .52492 .65672 .53176 .65969 .52792 .65606 .52108 Mtetra
.667 .542 .702 r
.65606 .52108 .65969 .52792 .66264 .52312 .659 .51627 Mtetra
.67 .543 .701 r
.659 .51627 .66264 .52312 .66558 .51814 .66194 .5113 Mtetra
.66 .539 .705 r
.66194 .5113 .66558 .51814 .66854 .51377 .6649 .50692 Mtetra
.638 .53 .714 r
.6649 .50692 .66854 .51377 .67154 .51056 .6679 .50371 Mtetra
.6 .513 .728 r
.6679 .50371 .67154 .51056 .67458 .50881 .67094 .50196 Mtetra
.543 .488 .744 r
.67094 .50196 .67458 .50881 .67768 .50853 .67403 .50167 Mtetra
.47 .452 .757 r
.67403 .50167 .67768 .50853 .68082 .50948 .67717 .50261 Mtetra
.399 .417 .763 r
.67717 .50261 .68082 .50948 .684 .51125 .68034 .50437 Mtetra
.365 .399 .764 r
.68034 .50437 .684 .51125 .6872 .51334 .68353 .50645 Mtetra
.388 .411 .763 r
.68353 .50645 .6872 .51334 .6904 .51522 .68672 .50832 Mtetra
.452 .444 .759 r
.68672 .50832 .6904 .51522 .69358 .51641 .6899 .50951 Mtetra
.523 .478 .748 r
.6899 .50951 .69358 .51641 .69673 .51652 .69305 .50961 Mtetra
.583 .505 .733 r
.69305 .50961 .69673 .51652 .69985 .51528 .69616 .50836 Mtetra
.626 .524 .719 r
.69616 .50836 .69985 .51528 .70291 .51256 .69922 .50564 Mtetra
.656 .537 .707 r
.69922 .50564 .70291 .51256 .70592 .50838 .70223 .50146 Mtetra
.675 .545 .698 r
.70223 .50146 .70592 .50838 .70889 .5029 .7052 .49597 Mtetra
.688 .55 .692 r
.7052 .49597 .70889 .5029 .71182 .49635 .70813 .48943 Mtetra
.696 .553 .688 r
.70813 .48943 .71182 .49635 .71472 .48908 .71103 .48216 Mtetra
.699 .554 .686 r
.71103 .48216 .71472 .48908 .71761 .48146 .71391 .47454 Mtetra
.71391 .47454 .71761 .48146 .72049 .47388 .7168 .46697 Mtetra
.695 .552 .688 r
.7168 .46697 .72049 .47388 .72339 .46672 .7197 .45981 Mtetra
.687 .549 .693 r
.7197 .45981 .72339 .46672 .72632 .46032 .72263 .45342 Mtetra
.674 .544 .699 r
.72263 .45342 .72632 .46032 .7293 .45497 .7256 .44807 Mtetra
.654 .536 .708 r
.7256 .44807 .7293 .45497 .73232 .45088 .72862 .44398 Mtetra
.625 .524 .72 r
.72862 .44398 .73232 .45088 .73541 .44818 .7317 .44128 Mtetra
.582 .506 .734 r
.7317 .44128 .73541 .44818 .73856 .44693 .73485 .44002 Mtetra
.52 .477 .749 r
.73485 .44002 .73856 .44693 .74178 .44711 .73807 .44019 Mtetra
.429 .433 .761 r
.73807 .44019 .74178 .44711 .74506 .4486 .74134 .44168 Mtetra
.305 .368 .763 r
.74134 .44168 .74506 .4486 .74841 .45126 .74468 .44432 Mtetra
.156 .285 .746 r
.74468 .44432 .74841 .45126 .7518 .45484 .74807 .44789 Mtetra
.015 .202 .712 r
.74807 .44789 .7518 .45484 .75524 .4591 .7515 .45213 Mtetra
0 .147 .682 r
.7515 .45213 .75524 .4591 .7587 .46372 .75495 .45674 Mtetra
0 .14 .678 r
.75495 .45674 .7587 .46372 .76218 .46841 .75843 .46142 Mtetra
0 .182 .702 r
.75843 .46142 .76218 .46841 .76566 .47285 .7619 .46584 Mtetra
.108 .258 .736 r
.7619 .46584 .76566 .47285 .76913 .47674 .76536 .46972 Mtetra
.255 .341 .76 r
.76536 .46972 .76913 .47674 .77257 .47982 .76879 .47278 Mtetra
.386 .41 .764 r
.76879 .47278 .77257 .47982 .77597 .48183 .77218 .47479 Mtetra
.486 .46 .755 r
.77218 .47479 .77597 .48183 .77931 .4826 .77552 .47555 Mtetra
.557 .494 .74 r
.77552 .47555 .77931 .4826 .7826 .48199 .7788 .47493 Mtetra
.607 .516 .726 r
.7788 .47493 .7826 .48199 .78581 .47991 .78201 .47285 Mtetra
.642 .531 .713 r
.78201 .47285 .78581 .47991 .78896 .47635 .78515 .46928 Mtetra
.666 .541 .702 r
.78515 .46928 .78896 .47635 .79203 .47133 .78822 .46426 Mtetra
.684 .548 .693 r
.78822 .46426 .79203 .47133 .79503 .46496 .79123 .45789 Mtetra
.697 .553 .686 r
.79123 .45789 .79503 .46496 .79797 .45736 .79416 .4503 Mtetra
.706 .556 .681 r
.79416 .4503 .79797 .45736 .80085 .44872 .79705 .44167 Mtetra
.713 .558 .678 r
.79705 .44167 .80085 .44872 .80369 .43926 .79988 .43222 Mtetra
.717 .56 .675 r
.79988 .43222 .80369 .43926 .80648 .42922 .80268 .42218 Mtetra
.719 .561 .674 r
.80268 .42218 .80648 .42922 .80926 .41884 .80546 .41181 Mtetra
.72 .561 .673 r
.80546 .41181 .80926 .41884 .81203 .4084 .80822 .40138 Mtetra
.719 .561 .674 r
.80822 .40138 .81203 .4084 .8148 .39814 .811 .39113 Mtetra
.716 .56 .676 r
.811 .39113 .8148 .39814 .81759 .38833 .81379 .38132 Mtetra
.711 .558 .679 r
.81379 .38132 .81759 .38833 .82041 .37918 .81662 .37218 Mtetra
.704 .555 .683 r
.81662 .37218 .82041 .37918 .82329 .37091 .81949 .36392 Mtetra
.694 .552 .688 r
.81949 .36392 .82329 .37091 .82622 .36369 .82242 .3567 Mtetra
.681 .546 .695 r
.82242 .3567 .82622 .36369 .82922 .35768 .82543 .35069 Mtetra
.662 .539 .704 r
.82543 .35069 .82922 .35768 .83231 .35298 .82851 .34599 Mtetra
.636 .529 .715 r
.82851 .34599 .83231 .35298 .83547 .34967 .83167 .34268 Mtetra
.601 .514 .728 r
.83167 .34268 .83547 .34967 .83873 .3478 .83493 .3408 Mtetra
.549 .491 .743 r
.83493 .3408 .83873 .3478 .84209 .34735 .83827 .34035 Mtetra
.475 .456 .757 r
.83827 .34035 .84209 .34735 .84553 .34831 .84172 .3413 Mtetra
.364 .401 .766 r
.84172 .3413 .84553 .34831 .84907 .3506 .84525 .34358 Mtetra
.205 .315 .756 r
.84525 .34358 .84907 .3506 .8527 .35412 .84887 .34708 Mtetra
0 .193 .709 r
.84887 .34708 .8527 .35412 .85641 .35873 .85257 .35169 Mtetra
0 .049 .616 r
.85257 .35169 .85641 .35873 .8602 .3643 .85635 .35723 Mtetra
0 0 .5 r
.85635 .35723 .8602 .3643 .86405 .37062 .86019 .36354 Mtetra
0 0 .398 r
.86019 .36354 .86405 .37062 .86795 .37752 .86408 .37042 Mtetra
.625 .234 0 r
.86408 .37042 .86795 .37752 .87189 .38477 .86801 .37765 Mtetra
.644 .249 0 r
.86801 .37765 .87189 .38477 .87586 .39215 .87197 .38501 Mtetra
0 0 .339 r
.87197 .38501 .87586 .39215 .87984 .39945 .87594 .39229 Mtetra
.895 .51 .063 r
.42373 .6494 .42708 .6567 .42969 .66384 .42634 .65652 Mtetra
.904 .52 .086 r
.42634 .65652 .42969 .66384 .43231 .67112 .42895 .66378 Mtetra
.897 .512 .067 r
.42895 .66378 .43231 .67112 .43495 .67835 .43157 .67099 Mtetra
.868 .48 .003 r
.43157 .67099 .43495 .67835 .4376 .68529 .43421 .67791 Mtetra
.791 .408 0 r
.43421 .67791 .4376 .68529 .44026 .69174 .43687 .68435 Mtetra
0 0 .32 r
.43687 .68435 .44026 .69174 .44294 .6975 .43955 .69009 Mtetra
0 0 .544 r
.43955 .69009 .44294 .6975 .44564 .70238 .44224 .69495 Mtetra
.035 .185 .69 r
.44224 .69495 .44564 .70238 .44836 .70621 .44495 .69876 Mtetra
.287 .336 .739 r
.44495 .69876 .44836 .70621 .4511 .70883 .44768 .70138 Mtetra
.441 .422 .742 r
.44768 .70138 .4511 .70883 .45385 .71015 .45042 .70269 Mtetra
.533 .47 .731 r
.45042 .70269 .45385 .71015 .45662 .71008 .45319 .70261 Mtetra
.591 .499 .719 r
.45319 .70261 .45662 .71008 .4594 .70858 .45597 .70111 Mtetra
.629 .518 .708 r
.45597 .70111 .4594 .70858 .46219 .70565 .45876 .69818 Mtetra
.655 .53 .699 r
.45876 .69818 .46219 .70565 .46499 .70133 .46156 .69385 Mtetra
.674 .538 .692 r
.46156 .69385 .46499 .70133 .4678 .69569 .46437 .68822 Mtetra
.687 .544 .686 r
.46437 .68822 .4678 .69569 .47062 .68887 .46718 .6814 Mtetra
.697 .548 .682 r
.46718 .6814 .47062 .68887 .47344 .681 .47 .67354 Mtetra
.703 .551 .679 r
.47 .67354 .47344 .681 .47626 .67229 .47282 .66483 Mtetra
.708 .553 .676 r
.47282 .66483 .47626 .67229 .47907 .66294 .47564 .65549 Mtetra
.711 .555 .675 r
.47564 .65549 .47907 .66294 .48189 .65318 .47845 .64574 Mtetra
.712 .555 .675 r
.47845 .64574 .48189 .65318 .4847 .64327 .48127 .63584 Mtetra
.711 .555 .675 r
.48127 .63584 .4847 .64327 .48751 .63345 .48407 .62604 Mtetra
.709 .554 .676 r
.48407 .62604 .48751 .63345 .49031 .62399 .48688 .61658 Mtetra
.705 .552 .678 r
.48688 .61658 .49031 .62399 .49311 .6151 .48968 .6077 Mtetra
.699 .55 .681 r
.48968 .6077 .49311 .6151 .49591 .60702 .49248 .59962 Mtetra
.69 .546 .685 r
.49248 .59962 .49591 .60702 .49871 .59994 .49527 .59255 Mtetra
.678 .54 .69 r
.49527 .59255 .49871 .59994 .5015 .59402 .49807 .58664 Mtetra
.661 .532 .697 r
.49807 .58664 .5015 .59402 .5043 .58939 .50086 .58201 Mtetra
.637 .521 .706 r
.50086 .58201 .5043 .58939 .5071 .58613 .50366 .57874 Mtetra
.602 .505 .716 r
.50366 .57874 .5071 .58613 .50991 .58427 .50646 .57687 Mtetra
.552 .481 .728 r
.50646 .57687 .50991 .58427 .51272 .58379 .50927 .57639 Mtetra
.48 .443 .74 r
.50927 .57639 .51272 .58379 .51554 .58462 .51209 .57721 Mtetra
.374 .387 .745 r
.51209 .57721 .51554 .58462 .51838 .58664 .51492 .57923 Mtetra
.231 .305 .735 r
.51492 .57923 .51838 .58664 .52123 .58969 .51776 .58226 Mtetra
.064 .206 .701 r
.51776 .58226 .52123 .58969 .52409 .59355 .52061 .5861 Mtetra
0 .114 .653 r
.52061 .5861 .52409 .59355 .52696 .59796 .52348 .5905 Mtetra
0 .063 .621 r
.52348 .5905 .52696 .59796 .52984 .60264 .52636 .59516 Mtetra
0 .072 .627 r
.52636 .59516 .52984 .60264 .53274 .60729 .52924 .5998 Mtetra
0 .138 .667 r
.52924 .5998 .53274 .60729 .53564 .61162 .53214 .60411 Mtetra
.116 .238 .714 r
.53214 .60411 .53564 .61162 .53855 .61531 .53504 .60779 Mtetra
.283 .335 .74 r
.53504 .60779 .53855 .61531 .54146 .6181 .53794 .61057 Mtetra
.416 .41 .744 r
.53794 .61057 .54146 .6181 .54436 .61976 .54084 .61222 Mtetra
.511 .459 .735 r
.54084 .61222 .54436 .61976 .54727 .62011 .54374 .61256 Mtetra
.575 .491 .723 r
.54374 .61256 .54727 .62011 .55016 .61904 .54663 .61149 Mtetra
.618 .512 .712 r
.54663 .61149 .55016 .61904 .55305 .61652 .54952 .60897 Mtetra
.647 .526 .702 r
.54952 .60897 .55305 .61652 .55593 .61261 .55239 .60505 Mtetra
.666 .535 .694 r
.55239 .60505 .55593 .61261 .55879 .60744 .55525 .59988 Mtetra
.679 .54 .689 r
.55525 .59988 .55879 .60744 .56165 .60122 .55811 .59367 Mtetra
.687 .544 .686 r
.55811 .59367 .56165 .60122 .56449 .59425 .56095 .5867 Mtetra
.691 .546 .684 r
.56095 .5867 .56449 .59425 .56733 .58687 .56379 .57933 Mtetra
.56379 .57933 .56733 .58687 .57016 .57946 .56662 .57192 Mtetra
.688 .544 .685 r
.56662 .57192 .57016 .57946 .573 .5724 .56946 .56487 Mtetra
.681 .541 .688 r
.56946 .56487 .573 .5724 .57585 .56605 .57231 .55853 Mtetra
.668 .535 .694 r
.57231 .55853 .57585 .56605 .57871 .56075 .57517 .55322 Mtetra
.649 .527 .701 r
.57517 .55322 .57871 .56075 .58159 .55672 .57805 .54919 Mtetra
.62 .513 .711 r
.57805 .54919 .58159 .55672 .5845 .5541 .58095 .54657 Mtetra
.578 .493 .723 r
.58095 .54657 .5845 .5541 .58743 .55293 .58388 .54539 Mtetra
.522 .466 .734 r
.58388 .54539 .58743 .55293 .59039 .55307 .58683 .54553 Mtetra
.456 .431 .742 r
.58683 .54553 .59039 .55307 .59337 .55428 .58981 .54672 Mtetra
.398 .4 .745 r
.58981 .54672 .59337 .55428 .59637 .55617 .5928 .54861 Mtetra
.377 .389 .746 r
.5928 .54861 .59637 .55617 .59938 .55828 .59581 .55071 Mtetra
.408 .406 .745 r
.59581 .55071 .59938 .55828 .6024 .56009 .59882 .5525 Mtetra
.472 .44 .741 r
.59882 .5525 .6024 .56009 .60541 .56108 .60182 .55349 Mtetra
.54 .475 .731 r
.60182 .55349 .60541 .56108 .6084 .56086 .6048 .55325 Mtetra
.594 .501 .718 r
.6048 .55325 .6084 .56086 .61137 .55916 .60777 .55155 Mtetra
.631 .518 .707 r
.60777 .55155 .61137 .55916 .61431 .55601 .61071 .5484 Mtetra
.652 .528 .7 r
.61071 .5484 .61431 .55601 .61723 .55168 .61362 .54407 Mtetra
.662 .532 .696 r
.61362 .54407 .61723 .55168 .62014 .54675 .61653 .53914 Mtetra
.659 .531 .697 r
.61653 .53914 .62014 .54675 .62305 .54199 .61944 .53438 Mtetra
.643 .524 .703 r
.61944 .53438 .62305 .54199 .62599 .53819 .62238 .53058 Mtetra
.611 .509 .714 r
.62238 .53058 .62599 .53819 .62896 .53588 .62535 .52827 Mtetra
.566 .487 .726 r
.62535 .52827 .62896 .53588 .63197 .53502 .62835 .52741 Mtetra
.547 .478 .73 r
.62835 .52741 .63197 .53502 .635 .53465 .63138 .52702 Mtetra
.592 .5 .719 r
.63138 .52702 .635 .53465 .638 .53302 .63438 .52539 Mtetra
.625 .515 .709 r
.63438 .52539 .638 .53302 .64098 .53012 .63735 .52249 Mtetra
.592 .5 .719 r
.63735 .52249 .64098 .53012 .64399 .5285 .64035 .52086 Mtetra
.547 .478 .73 r
.64035 .52086 .64399 .5285 .64704 .52811 .6434 .52046 Mtetra
.566 .487 .726 r
.6434 .52046 .64704 .52811 .65008 .52724 .64644 .51959 Mtetra
.611 .509 .714 r
.64644 .51959 .65008 .52724 .65309 .52492 .64944 .51726 Mtetra
.643 .524 .703 r
.64944 .51726 .65309 .52492 .65606 .52108 .65241 .51342 Mtetra
.659 .531 .697 r
.65241 .51342 .65606 .52108 .659 .51627 .65535 .50861 Mtetra
.661 .532 .696 r
.65535 .50861 .659 .51627 .66194 .5113 .65829 .50364 Mtetra
.652 .528 .7 r
.65829 .50364 .66194 .5113 .6649 .50692 .66124 .49926 Mtetra
.631 .518 .707 r
.66124 .49926 .6649 .50692 .6679 .50371 .66423 .49605 Mtetra
.595 .501 .718 r
.66423 .49605 .6679 .50371 .67094 .50196 .66727 .4943 Mtetra
.543 .476 .731 r
.66727 .4943 .67094 .50196 .67403 .50167 .67036 .494 Mtetra
.478 .444 .741 r
.67036 .494 .67403 .50167 .67717 .50261 .67349 .49493 Mtetra
.418 .412 .746 r
.67349 .49493 .67717 .50261 .68034 .50437 .67666 .49668 Mtetra
.391 .397 .747 r
.67666 .49668 .68034 .50437 .68353 .50645 .67984 .49875 Mtetra
.41 .408 .746 r
.67984 .49875 .68353 .50645 .68672 .50832 .68303 .50061 Mtetra
.463 .436 .742 r
.68303 .50061 .68672 .50832 .6899 .50951 .6862 .50178 Mtetra
.525 .467 .734 r
.6862 .50178 .6899 .50951 .69305 .50961 .68934 .50187 Mtetra
.578 .493 .723 r
.68934 .50187 .69305 .50961 .69616 .50836 .69244 .50062 Mtetra
.619 .513 .711 r
.69244 .50062 .69616 .50836 .69922 .50564 .6955 .4979 Mtetra
.648 .526 .701 r
.6955 .4979 .69922 .50564 .70223 .50146 .69851 .49372 Mtetra
.667 .534 .693 r
.69851 .49372 .70223 .50146 .7052 .49597 .70148 .48823 Mtetra
.68 .54 .688 r
.70148 .48823 .7052 .49597 .70813 .48943 .7044 .4817 Mtetra
.688 .543 .684 r
.7044 .4817 .70813 .48943 .71103 .48216 .7073 .47443 Mtetra
.691 .545 .683 r
.7073 .47443 .71103 .48216 .71391 .47454 .71019 .46682 Mtetra
.71019 .46682 .71391 .47454 .7168 .46697 .71307 .45925 Mtetra
.687 .543 .685 r
.71307 .45925 .7168 .46697 .7197 .45981 .71597 .4521 Mtetra
.678 .539 .689 r
.71597 .4521 .7197 .45981 .72263 .45342 .7189 .44571 Mtetra
.665 .534 .694 r
.7189 .44571 .72263 .45342 .7256 .44807 .72187 .44036 Mtetra
.646 .525 .702 r
.72187 .44036 .7256 .44807 .72862 .44398 .72489 .43627 Mtetra
.618 .512 .712 r
.72489 .43627 .72862 .44398 .7317 .44128 .72797 .43357 Mtetra
.578 .494 .723 r
.72797 .43357 .7317 .44128 .73485 .44002 .73111 .43231 Mtetra
.522 .466 .735 r
.73111 .43231 .73485 .44002 .73807 .44019 .73432 .43247 Mtetra
.444 .426 .745 r
.73432 .43247 .73807 .44019 .74134 .44168 .73759 .43394 Mtetra
.342 .372 .747 r
.73759 .43394 .74134 .44168 .74468 .44432 .74092 .43657 Mtetra
.225 .306 .738 r
.74092 .43657 .74468 .44432 .74807 .44789 .7443 .44013 Mtetra
.116 .242 .719 r
.7443 .44013 .74807 .44789 .7515 .45213 .74772 .44435 Mtetra
.046 .2 .701 r
.74772 .44435 .7515 .45213 .75495 .45674 .75117 .44894 Mtetra
.037 .194 .699 r
.75117 .44894 .75495 .45674 .75843 .46142 .75463 .4536 Mtetra
.09 .227 .713 r
.75463 .4536 .75843 .46142 .7619 .46584 .7581 .45801 Mtetra
.188 .285 .732 r
.7581 .45801 .7619 .46584 .76536 .46972 .76155 .46187 Mtetra
.302 .35 .745 r
.76155 .46187 .76536 .46972 .76879 .47278 .76497 .46492 Mtetra
.407 .407 .747 r
.76497 .46492 .76879 .47278 .77218 .47479 .76835 .46691 Mtetra
.492 .451 .74 r
.76835 .46691 .77218 .47479 .77552 .47555 .77169 .46767 Mtetra
.555 .482 .728 r
.77169 .46767 .77552 .47555 .7788 .47493 .77496 .46704 Mtetra
.601 .504 .717 r
.77496 .46704 .7788 .47493 .78201 .47285 .77817 .46495 Mtetra
.634 .519 .706 r
.77817 .46495 .78201 .47285 .78515 .46928 .78131 .46138 Mtetra
.658 .53 .697 r
.78131 .46138 .78515 .46928 .78822 .46426 .78438 .45637 Mtetra
.676 .538 .689 r
.78438 .45637 .78822 .46426 .79123 .45789 .78738 .45 Mtetra
.689 .543 .683 r
.78738 .45 .79123 .45789 .79416 .4503 .79032 .44241 Mtetra
.698 .547 .679 r
.79032 .44241 .79416 .4503 .79705 .44167 .7932 .43379 Mtetra
.705 .55 .675 r
.7932 .43379 .79705 .44167 .79988 .43222 .79603 .42435 Mtetra
.709 .552 .673 r
.79603 .42435 .79988 .43222 .80268 .42218 .79883 .41432 Mtetra
.711 .553 .672 r
.79883 .41432 .80268 .42218 .80546 .41181 .80161 .40397 Mtetra
.712 .553 .671 r
.80161 .40397 .80546 .41181 .80822 .40138 .80438 .39354 Mtetra
.711 .552 .672 r
.80438 .39354 .80822 .40138 .811 .39113 .80716 .38331 Mtetra
.708 .551 .674 r
.80716 .38331 .811 .39113 .81379 .38132 .80995 .37351 Mtetra
.703 .549 .676 r
.80995 .37351 .81379 .38132 .81662 .37218 .81278 .36437 Mtetra
.696 .546 .68 r
.81278 .36437 .81662 .37218 .81949 .36392 .81565 .35612 Mtetra
.686 .542 .685 r
.81565 .35612 .81949 .36392 .82242 .3567 .81858 .34891 Mtetra
.672 .536 .691 r
.81858 .34891 .82242 .3567 .82543 .35069 .82158 .3429 Mtetra
.654 .528 .699 r
.82158 .3429 .82543 .35069 .82851 .34599 .82466 .3382 Mtetra
.629 .517 .708 r
.82466 .3382 .82851 .34599 .83167 .34268 .82782 .33489 Mtetra
.595 .502 .719 r
.82782 .33489 .83167 .34268 .83493 .3408 .83107 .333 Mtetra
.548 .48 .731 r
.83107 .333 .83493 .3408 .83827 .34035 .83442 .33255 Mtetra
.482 .447 .742 r
.83442 .33255 .83827 .34035 .84172 .3413 .83785 .33348 Mtetra
.389 .399 .749 r
.83785 .33348 .84172 .3413 .84525 .34358 .84138 .33575 Mtetra
.262 .329 .744 r
.84138 .33575 .84525 .34358 .84887 .34708 .84499 .33924 Mtetra
.099 .235 .717 r
.84499 .33924 .84887 .34708 .85257 .35169 .84868 .34382 Mtetra
0 .121 .661 r
.84868 .34382 .85257 .35169 .85635 .35723 .85245 .34935 Mtetra
0 .009 .584 r
.85245 .34935 .85635 .35723 .86019 .36354 .85628 .35564 Mtetra
0 0 .509 r
.85628 .35564 .86019 .36354 .86408 .37042 .86016 .36249 Mtetra
0 0 .458 r
.86016 .36249 .86408 .37042 .86801 .37765 .86408 .3697 Mtetra
0 0 .441 r
.86408 .3697 .86801 .37765 .87197 .38501 .86802 .37704 Mtetra
0 0 .462 r
.86802 .37704 .87197 .38501 .87594 .39229 .87198 .38429 Mtetra
.85 .474 0 r
.42039 .64157 .42373 .6494 .42634 .65652 .42299 .64867 Mtetra
.865 .488 0 r
.42299 .64867 .42634 .65652 .42895 .66378 .42559 .65591 Mtetra
.853 .477 0 r
.42559 .65591 .42895 .66378 .43157 .67099 .42821 .6631 Mtetra
.808 .435 0 r
.42821 .6631 .43157 .67099 .43421 .67791 .43084 .67 Mtetra
.702 .346 0 r
.43084 .67 .43421 .67791 .43687 .68435 .43349 .67642 Mtetra
0 0 .41 r
.43349 .67642 .43687 .68435 .43955 .69009 .43616 .68214 Mtetra
0 .024 .591 r
.43616 .68214 .43955 .69009 .44224 .69495 .43884 .68698 Mtetra
.102 .214 .696 r
.43884 .68698 .44224 .69495 .44495 .69876 .44154 .69078 Mtetra
.314 .342 .73 r
.44154 .69078 .44495 .69876 .44768 .70138 .44427 .69339 Mtetra
.449 .418 .732 r
.44427 .69339 .44768 .70138 .45042 .70269 .44701 .69469 Mtetra
.533 .464 .723 r
.44701 .69469 .45042 .70269 .45319 .70261 .44977 .6946 Mtetra
.588 .492 .713 r
.44977 .6946 .45319 .70261 .45597 .70111 .45254 .69309 Mtetra
.625 .511 .704 r
.45254 .69309 .45597 .70111 .45876 .69818 .45533 .69016 Mtetra
.651 .523 .696 r
.45533 .69016 .45876 .69818 .46156 .69385 .45813 .68583 Mtetra
.669 .532 .689 r
.45813 .68583 .46156 .69385 .46437 .68822 .46093 .6802 Mtetra
.682 .539 .684 r
.46093 .6802 .46437 .68822 .46718 .6814 .46375 .67339 Mtetra
.692 .543 .68 r
.46375 .67339 .46718 .6814 .47 .67354 .46657 .66553 Mtetra
.699 .546 .677 r
.46657 .66553 .47 .67354 .47282 .66483 .46938 .65684 Mtetra
.703 .548 .675 r
.46938 .65684 .47282 .66483 .47564 .65549 .4722 .6475 Mtetra
.706 .55 .674 r
.4722 .6475 .47564 .65549 .47845 .64574 .47502 .63777 Mtetra
.707 .55 .673 r
.47502 .63777 .47845 .64574 .48127 .63584 .47783 .62788 Mtetra
.47783 .62788 .48127 .63584 .48407 .62604 .48064 .61809 Mtetra
.704 .549 .674 r
.48064 .61809 .48407 .62604 .48688 .61658 .48345 .60864 Mtetra
.7 .547 .676 r
.48345 .60864 .48688 .61658 .48968 .6077 .48625 .59977 Mtetra
.694 .544 .679 r
.48625 .59977 .48968 .6077 .49248 .59962 .48905 .5917 Mtetra
.685 .54 .683 r
.48905 .5917 .49248 .59962 .49527 .59255 .49184 .58463 Mtetra
.673 .534 .688 r
.49184 .58463 .49527 .59255 .49807 .58664 .49463 .57872 Mtetra
.656 .526 .694 r
.49463 .57872 .49807 .58664 .50086 .58201 .49743 .57409 Mtetra
.632 .515 .702 r
.49743 .57409 .50086 .58201 .50366 .57874 .50022 .57083 Mtetra
.599 .498 .711 r
.50022 .57083 .50366 .57874 .50646 .57687 .50302 .56896 Mtetra
.551 .474 .721 r
.50302 .56896 .50646 .57687 .50927 .57639 .50583 .56846 Mtetra
.484 .438 .731 r
.50583 .56846 .50927 .57639 .51209 .57721 .50864 .56928 Mtetra
.39 .386 .735 r
.50864 .56928 .51209 .57721 .51492 .57923 .51146 .57128 Mtetra
.266 .315 .728 r
.51146 .57128 .51492 .57923 .51776 .58226 .5143 .5743 Mtetra
.125 .231 .704 r
.5143 .5743 .51776 .58226 .52061 .5861 .51714 .57813 Mtetra
.001 .154 .67 r
.51714 .57813 .52061 .5861 .52348 .5905 .52 .5825 Mtetra
0 .111 .647 r
.52 .5825 .52348 .5905 .52636 .59516 .52287 .58716 Mtetra
0 .118 .651 r
.52287 .58716 .52636 .59516 .52924 .5998 .52575 .59178 Mtetra
.034 .174 .68 r
.52575 .59178 .52924 .5998 .53214 .60411 .52863 .59607 Mtetra
.169 .258 .713 r
.52863 .59607 .53214 .60411 .53504 .60779 .53153 .59973 Mtetra
.31 .341 .732 r
.53153 .59973 .53504 .60779 .53794 .61057 .53442 .6025 Mtetra
.427 .407 .734 r
.53442 .6025 .53794 .61057 .54084 .61222 .53732 .60414 Mtetra
.513 .453 .727 r
.53732 .60414 .54084 .61222 .54374 .61256 .54021 .60447 Mtetra
.572 .484 .717 r
.54021 .60447 .54374 .61256 .54663 .61149 .5431 .60339 Mtetra
.614 .505 .707 r
.5431 .60339 .54663 .61149 .54952 .60897 .54598 .60087 Mtetra
.642 .519 .698 r
.54598 .60087 .54952 .60897 .55239 .60505 .54885 .59695 Mtetra
.661 .528 .691 r
.54885 .59695 .55239 .60505 .55525 .59988 .55171 .59178 Mtetra
.674 .534 .687 r
.55171 .59178 .55525 .59988 .55811 .59367 .55456 .58557 Mtetra
.682 .538 .683 r
.55456 .58557 .55811 .59367 .56095 .5867 .55741 .57861 Mtetra
.686 .54 .682 r
.55741 .57861 .56095 .5867 .56379 .57933 .56024 .57125 Mtetra
.687 .54 .682 r
.56024 .57125 .56379 .57933 .56662 .57192 .56308 .56385 Mtetra
.683 .539 .683 r
.56308 .56385 .56662 .57192 .56946 .56487 .56592 .5568 Mtetra
.676 .535 .686 r
.56592 .5568 .56946 .56487 .57231 .55853 .56876 .55046 Mtetra
.663 .529 .691 r
.56876 .55046 .57231 .55853 .57517 .55322 .57162 .54516 Mtetra
.644 .52 .698 r
.57162 .54516 .57517 .55322 .57805 .54919 .5745 .54112 Mtetra
.615 .506 .706 r
.5745 .54112 .57805 .54919 .58095 .54657 .57739 .53851 Mtetra
.576 .486 .716 r
.57739 .53851 .58095 .54657 .58388 .54539 .58032 .53732 Mtetra
.523 .459 .726 r
.58032 .53732 .58388 .54539 .58683 .54553 .58326 .53744 Mtetra
.463 .427 .733 r
.58326 .53744 .58683 .54553 .58981 .54672 .58623 .53863 Mtetra
.411 .399 .736 r
.58623 .53863 .58981 .54672 .5928 .54861 .58922 .54051 Mtetra
.392 .389 .736 r
.58922 .54051 .5928 .54861 .59581 .55071 .59222 .54259 Mtetra
.419 .403 .735 r
.59222 .54259 .59581 .55071 .59882 .5525 .59522 .54438 Mtetra
.477 .435 .732 r
.59522 .54438 .59882 .5525 .60182 .55349 .59822 .54535 Mtetra
.54 .468 .723 r
.59822 .54535 .60182 .55349 .6048 .55325 .6012 .54511 Mtetra
.591 .494 .713 r
.6012 .54511 .6048 .55325 .60777 .55155 .60416 .5434 Mtetra
.626 .511 .703 r
.60416 .5434 .60777 .55155 .61071 .5484 .6071 .54025 Mtetra
.647 .522 .696 r
.6071 .54025 .61071 .5484 .61362 .54407 .61001 .53592 Mtetra
.656 .526 .693 r
.61001 .53592 .61362 .54407 .61653 .53914 .61292 .53099 Mtetra
.654 .525 .694 r
.61292 .53099 .61653 .53914 .61944 .53438 .61583 .52623 Mtetra
.638 .517 .699 r
.61583 .52623 .61944 .53438 .62238 .53058 .61876 .52243 Mtetra
.607 .502 .709 r
.61876 .52243 .62238 .53058 .62535 .52827 .62172 .52012 Mtetra
.564 .48 .719 r
.62172 .52012 .62535 .52827 .62835 .52741 .62472 .51924 Mtetra
.546 .471 .723 r
.62472 .51924 .62835 .52741 .63138 .52702 .62774 .51885 Mtetra
.588 .493 .713 r
.62774 .51885 .63138 .52702 .63438 .52539 .63074 .51722 Mtetra
.62 .508 .705 r
.63074 .51722 .63438 .52539 .63735 .52249 .63371 .51432 Mtetra
.588 .493 .713 r
.63371 .51432 .63735 .52249 .64035 .52086 .63671 .51268 Mtetra
.546 .471 .723 r
.63671 .51268 .64035 .52086 .6434 .52046 .63975 .51227 Mtetra
.564 .481 .719 r
.63975 .51227 .6434 .52046 .64644 .51959 .64278 .51139 Mtetra
.607 .502 .709 r
.64278 .51139 .64644 .51959 .64944 .51726 .64578 .50906 Mtetra
.638 .517 .699 r
.64578 .50906 .64944 .51726 .65241 .51342 .64874 .50522 Mtetra
.654 .525 .694 r
.64874 .50522 .65241 .51342 .65535 .50861 .65168 .50042 Mtetra
.656 .526 .693 r
.65168 .50042 .65535 .50861 .65829 .50364 .65462 .49544 Mtetra
.647 .521 .696 r
.65462 .49544 .65829 .50364 .66124 .49926 .65757 .49107 Mtetra
.626 .511 .703 r
.65757 .49107 .66124 .49926 .66423 .49605 .66056 .48786 Mtetra
.591 .494 .713 r
.66056 .48786 .66423 .49605 .66727 .4943 .66359 .48609 Mtetra
.542 .469 .723 r
.66359 .48609 .66727 .4943 .67036 .494 .66668 .48579 Mtetra
.483 .438 .732 r
.66668 .48579 .67036 .494 .67349 .49493 .6698 .48671 Mtetra
.429 .41 .736 r
.6698 .48671 .67349 .49493 .67666 .49668 .67296 .48844 Mtetra
.404 .396 .737 r
.67296 .48844 .67666 .49668 .67984 .49875 .67614 .4905 Mtetra
.421 .405 .736 r
.67614 .4905 .67984 .49875 .68303 .50061 .67931 .49235 Mtetra
.469 .431 .733 r
.67931 .49235 .68303 .50061 .6862 .50178 .68248 .49351 Mtetra
.525 .461 .726 r
.68248 .49351 .6862 .50178 .68934 .50187 .68562 .4936 Mtetra
.576 .486 .716 r
.68562 .4936 .68934 .50187 .69244 .50062 .68872 .49234 Mtetra
.615 .506 .706 r
.68872 .49234 .69244 .50062 .6955 .4979 .69177 .48961 Mtetra
.643 .519 .697 r
.69177 .48961 .6955 .4979 .69851 .49372 .69478 .48543 Mtetra
.662 .528 .69 r
.69478 .48543 .69851 .49372 .70148 .48823 .69774 .47995 Mtetra
.675 .534 .685 r
.69774 .47995 .70148 .48823 .7044 .4817 .70066 .47341 Mtetra
.682 .538 .682 r
.70066 .47341 .7044 .4817 .7073 .47443 .70356 .46616 Mtetra
.686 .539 .681 r
.70356 .46616 .7073 .47443 .71019 .46682 .70645 .45855 Mtetra
.685 .539 .681 r
.70645 .45855 .71019 .46682 .71307 .45925 .70933 .45099 Mtetra
.681 .537 .683 r
.70933 .45099 .71307 .45925 .71597 .4521 .71223 .44385 Mtetra
.673 .533 .686 r
.71223 .44385 .71597 .4521 .7189 .44571 .71516 .43746 Mtetra
.66 .527 .691 r
.71516 .43746 .7189 .44571 .72187 .44036 .71812 .43211 Mtetra
.641 .518 .698 r
.71812 .43211 .72187 .44036 .72489 .43627 .72114 .42802 Mtetra
.614 .505 .707 r
.72114 .42802 .72489 .43627 .72797 .43357 .72422 .42531 Mtetra
.576 .487 .717 r
.72422 .42531 .72797 .43357 .73111 .43231 .72736 .42405 Mtetra
.523 .46 .727 r
.72736 .42405 .73111 .43231 .73432 .43247 .73056 .4242 Mtetra
.451 .422 .735 r
.73056 .4242 .73432 .43247 .73759 .43394 .73382 .42566 Mtetra
.361 .373 .738 r
.73382 .42566 .73759 .43394 .74092 .43657 .73714 .42827 Mtetra
.26 .316 .731 r
.73714 .42827 .74092 .43657 .7443 .44013 .74051 .43182 Mtetra
.167 .261 .717 r
.74051 .43182 .7443 .44013 .74772 .44435 .74392 .43602 Mtetra
.107 .225 .705 r
.74392 .43602 .74772 .44435 .75117 .44894 .74736 .4406 Mtetra
.099 .221 .703 r
.74736 .4406 .75117 .44894 .75463 .4536 .75082 .44524 Mtetra
.145 .248 .713 r
.75082 .44524 .75463 .4536 .7581 .45801 .75427 .44963 Mtetra
.228 .297 .727 r
.75427 .44963 .7581 .45801 .76155 .46187 .75771 .45347 Mtetra
.327 .354 .737 r
.75771 .45347 .76155 .46187 .76497 .46492 .76113 .45651 Mtetra
.419 .405 .737 r
.76113 .45651 .76497 .46492 .76835 .46691 .76451 .45849 Mtetra
.495 .445 .731 r
.76451 .45849 .76835 .46691 .77169 .46767 .76783 .45923 Mtetra
.553 .475 .721 r
.76783 .45923 .77169 .46767 .77496 .46704 .7711 .45859 Mtetra
.597 .497 .711 r
.7711 .45859 .77496 .46704 .77817 .46495 .77431 .4565 Mtetra
.629 .512 .702 r
.77431 .4565 .77817 .46495 .78131 .46138 .77744 .45293 Mtetra
.653 .524 .693 r
.77744 .45293 .78131 .46138 .78438 .45637 .78051 .44792 Mtetra
.671 .532 .686 r
.78051 .44792 .78438 .45637 .78738 .45 .78351 .44155 Mtetra
.684 .537 .681 r
.78351 .44155 .78738 .45 .79032 .44241 .78644 .43397 Mtetra
.693 .542 .677 r
.78644 .43397 .79032 .44241 .7932 .43379 .78932 .42536 Mtetra
.7 .545 .674 r
.78932 .42536 .7932 .43379 .79603 .42435 .79216 .41593 Mtetra
.704 .546 .672 r
.79216 .41593 .79603 .42435 .79883 .41432 .79496 .40591 Mtetra
.706 .547 .67 r
.79496 .40591 .79883 .41432 .80161 .40397 .79774 .39557 Mtetra
.707 .548 .67 r
.79774 .39557 .80161 .40397 .80438 .39354 .80051 .38516 Mtetra
.706 .547 .671 r
.80051 .38516 .80438 .39354 .80716 .38331 .80329 .37493 Mtetra
.703 .546 .672 r
.80329 .37493 .80716 .38331 .80995 .37351 .80608 .36515 Mtetra
.698 .544 .675 r
.80608 .36515 .80995 .37351 .81278 .36437 .80891 .35602 Mtetra
.691 .541 .678 r
.80891 .35602 .81278 .36437 .81565 .35612 .81178 .34777 Mtetra
.68 .536 .682 r
.81178 .34777 .81565 .35612 .81858 .34891 .81471 .34057 Mtetra
.667 .53 .688 r
.81471 .34057 .81858 .34891 .82158 .3429 .81771 .33457 Mtetra
.649 .522 .695 r
.81771 .33457 .82158 .3429 .82466 .3382 .82079 .32987 Mtetra
.624 .51 .703 r
.82079 .32987 .82466 .3382 .82782 .33489 .82395 .32655 Mtetra
.592 .495 .713 r
.82395 .32655 .82782 .33489 .83107 .333 .82719 .32466 Mtetra
.547 .473 .724 r
.82719 .32466 .83107 .333 .83442 .33255 .83053 .3242 Mtetra
.486 .442 .733 r
.83053 .3242 .83442 .33255 .83785 .33348 .83396 .32512 Mtetra
.403 .398 .739 r
.83396 .32512 .83785 .33348 .84138 .33575 .83747 .32737 Mtetra
.291 .336 .736 r
.83747 .32737 .84138 .33575 .84499 .33924 .84108 .33085 Mtetra
.151 .254 .717 r
.84108 .33085 .84499 .33924 .84868 .34382 .84476 .33541 Mtetra
0 .158 .677 r
.84476 .33541 .84868 .34382 .85245 .34935 .84851 .34092 Mtetra
0 .061 .619 r
.84851 .34092 .85245 .34935 .85628 .35564 .85233 .34719 Mtetra
0 0 .561 r
.85233 .34719 .85628 .35564 .86016 .36249 .8562 .35402 Mtetra
0 0 .519 r
.8562 .35402 .86016 .36249 .86408 .3697 .86011 .3612 Mtetra
0 0 .506 r
.86011 .3612 .86408 .3697 .86802 .37704 .86404 .36852 Mtetra
0 0 .523 r
.86404 .36852 .86802 .37704 .87198 .38429 .86799 .37574 Mtetra
.821 .452 0 r
.41706 .6335 .42039 .64157 .42299 .64867 .41965 .64058 Mtetra
.839 .468 0 r
.41965 .64058 .42299 .64867 .42559 .65591 .42224 .6478 Mtetra
.825 .456 0 r
.42224 .6478 .42559 .65591 .42821 .6631 .42485 .65496 Mtetra
.772 .409 0 r
.42485 .65496 .42821 .6631 .43084 .67 .42747 .66184 Mtetra
0 0 .27 r
.42747 .66184 .43084 .67 .43349 .67642 .43011 .66824 Mtetra
0 0 .446 r
.43011 .66824 .43349 .67642 .43616 .68214 .43277 .67394 Mtetra
0 .05 .606 r
.43277 .67394 .43616 .68214 .43884 .68698 .43545 .67877 Mtetra
.129 .225 .696 r
.43545 .67877 .43884 .68698 .44154 .69078 .43815 .68255 Mtetra
.326 .344 .726 r
.43815 .68255 .44154 .69078 .44427 .69339 .44086 .68514 Mtetra
.452 .416 .728 r
.44086 .68514 .44427 .69339 .44701 .69469 .4436 .68643 Mtetra
.533 .461 .72 r
.4436 .68643 .44701 .69469 .44977 .6946 .44635 .68634 Mtetra
.587 .489 .711 r
.44635 .68634 .44977 .6946 .45254 .69309 .44912 .68483 Mtetra
.623 .508 .702 r
.44912 .68483 .45254 .69309 .45533 .69016 .45191 .68189 Mtetra
.648 .521 .694 r
.45191 .68189 .45533 .69016 .45813 .68583 .4547 .67757 Mtetra
.667 .53 .688 r
.4547 .67757 .45813 .68583 .46093 .6802 .45751 .67194 Mtetra
.68 .536 .683 r
.45751 .67194 .46093 .6802 .46375 .67339 .46032 .66513 Mtetra
.69 .541 .679 r
.46032 .66513 .46375 .67339 .46657 .66553 .46314 .65728 Mtetra
.696 .544 .676 r
.46314 .65728 .46657 .66553 .46938 .65684 .46596 .64859 Mtetra
.701 .546 .674 r
.46596 .64859 .46938 .65684 .4722 .6475 .46878 .63927 Mtetra
.704 .548 .673 r
.46878 .63927 .4722 .6475 .47502 .63777 .47159 .62955 Mtetra
.705 .548 .673 r
.47159 .62955 .47502 .63777 .47783 .62788 .47441 .61967 Mtetra
.704 .548 .673 r
.47441 .61967 .47783 .62788 .48064 .61809 .47722 .60989 Mtetra
.702 .547 .674 r
.47722 .60989 .48064 .61809 .48345 .60864 .48002 .60045 Mtetra
.698 .545 .676 r
.48002 .60045 .48345 .60864 .48625 .59977 .48283 .59159 Mtetra
.692 .542 .678 r
.48283 .59159 .48625 .59977 .48905 .5917 .48562 .58353 Mtetra
.683 .538 .682 r
.48562 .58353 .48905 .5917 .49184 .58463 .48841 .57647 Mtetra
.671 .532 .687 r
.48841 .57647 .49184 .58463 .49463 .57872 .49121 .57056 Mtetra
.653 .523 .693 r
.49121 .57056 .49463 .57872 .49743 .57409 .494 .56594 Mtetra
.63 .512 .7 r
.494 .56594 .49743 .57409 .50022 .57083 .49679 .56267 Mtetra
.597 .495 .709 r
.49679 .56267 .50022 .57083 .50302 .56896 .49958 .56079 Mtetra
.551 .471 .718 r
.49958 .56079 .50302 .56896 .50583 .56846 .50238 .56029 Mtetra
.486 .436 .727 r
.50238 .56029 .50583 .56846 .50864 .56928 .50519 .5611 Mtetra
.396 .386 .731 r
.50519 .5611 .50864 .56928 .51146 .57128 .50801 .56309 Mtetra
.28 .319 .724 r
.50801 .56309 .51146 .57128 .5143 .5743 .51084 .5661 Mtetra
.15 .241 .704 r
.51084 .5661 .5143 .5743 .51714 .57813 .51368 .56991 Mtetra
.035 .169 .675 r
.51368 .56991 .51714 .57813 .52 .5825 .51652 .57427 Mtetra
0 .13 .655 r
.51652 .57427 .52 .5825 .52287 .58716 .51939 .5789 Mtetra
0 .137 .658 r
.51939 .5789 .52287 .58716 .52575 .59178 .52226 .5835 Mtetra
.065 .188 .683 r
.52226 .5835 .52575 .59178 .52863 .59607 .52513 .58778 Mtetra
.191 .266 .711 r
.52513 .58778 .52863 .59607 .53153 .59973 .52802 .59143 Mtetra
.322 .343 .728 r
.52802 .59143 .53153 .59973 .53442 .6025 .53091 .59418 Mtetra
.431 .406 .73 r
.53091 .59418 .53442 .6025 .53732 .60414 .5338 .59581 Mtetra
.513 .451 .724 r
.5338 .59581 .53732 .60414 .54021 .60447 .53669 .59613 Mtetra
.571 .481 .714 r
.53669 .59613 .54021 .60447 .5431 .60339 .53957 .59504 Mtetra
.612 .502 .705 r
.53957 .59504 .5431 .60339 .54598 .60087 .54245 .59252 Mtetra
.64 .516 .697 r
.54245 .59252 .54598 .60087 .54885 .59695 .54532 .5886 Mtetra
.659 .526 .69 r
.54532 .5886 .54885 .59695 .55171 .59178 .54817 .58343 Mtetra
.672 .532 .685 r
.54817 .58343 .55171 .59178 .55456 .58557 .55102 .57723 Mtetra
.68 .536 .682 r
.55102 .57723 .55456 .58557 .55741 .57861 .55386 .57028 Mtetra
.684 .538 .681 r
.55386 .57028 .55741 .57861 .56024 .57125 .5567 .56292 Mtetra
.5567 .56292 .56024 .57125 .56308 .56385 .55953 .55552 Mtetra
.681 .536 .682 r
.55953 .55552 .56308 .56385 .56592 .5568 .56237 .54848 Mtetra
.673 .533 .685 r
.56237 .54848 .56592 .5568 .56876 .55046 .56522 .54215 Mtetra
.661 .526 .69 r
.56522 .54215 .56876 .55046 .57162 .54516 .56807 .53684 Mtetra
.642 .517 .696 r
.56807 .53684 .57162 .54516 .5745 .54112 .57095 .53281 Mtetra
.614 .503 .704 r
.57095 .53281 .5745 .54112 .57739 .53851 .57384 .53019 Mtetra
.575 .483 .714 r
.57384 .53019 .57739 .53851 .58032 .53732 .57676 .529 Mtetra
.524 .457 .723 r
.57676 .529 .58032 .53732 .58326 .53744 .5797 .52912 Mtetra
.465 .425 .729 r
.5797 .52912 .58326 .53744 .58623 .53863 .58266 .53029 Mtetra
.416 .398 .731 r
.58266 .53029 .58623 .53863 .58922 .54051 .58564 .53215 Mtetra
.398 .388 .732 r
.58564 .53215 .58922 .54051 .59222 .54259 .58864 .53423 Mtetra
.424 .402 .731 r
.58864 .53423 .59222 .54259 .59522 .54438 .59163 .536 Mtetra
.479 .433 .728 r
.59163 .536 .59522 .54438 .59822 .54535 .59462 .53696 Mtetra
.54 .465 .72 r
.59462 .53696 .59822 .54535 .6012 .54511 .5976 .53671 Mtetra
.589 .491 .71 r
.5976 .53671 .6012 .54511 .60416 .5434 .60055 .535 Mtetra
.624 .508 .701 r
.60055 .535 .60416 .5434 .6071 .54025 .60349 .53184 Mtetra
.645 .519 .695 r
.60349 .53184 .6071 .54025 .61001 .53592 .6064 .52752 Mtetra
.654 .523 .692 r
.6064 .52752 .61001 .53592 .61292 .53099 .6093 .52259 Mtetra
.652 .522 .692 r
.6093 .52259 .61292 .53099 .61583 .52623 .61221 .51783 Mtetra
.636 .514 .697 r
.61221 .51783 .61583 .52623 .61876 .52243 .61514 .51403 Mtetra
.605 .499 .706 r
.61514 .51403 .61876 .52243 .62172 .52012 .6181 .51171 Mtetra
.563 .477 .716 r
.6181 .51171 .62172 .52012 .62472 .51924 .62109 .51083 Mtetra
.546 .468 .719 r
.62109 .51083 .62472 .51924 .62774 .51885 .62411 .51043 Mtetra
.587 .49 .711 r
.62411 .51043 .62774 .51885 .63074 .51722 .6271 .50879 Mtetra
.618 .505 .703 r
.6271 .50879 .63074 .51722 .63371 .51432 .63006 .50589 Mtetra
.587 .49 .711 r
.63006 .50589 .63371 .51432 .63671 .51268 .63306 .50425 Mtetra
.546 .468 .719 r
.63306 .50425 .63671 .51268 .63975 .51227 .63609 .50384 Mtetra
.563 .477 .716 r
.63609 .50384 .63975 .51227 .64278 .51139 .63912 .50295 Mtetra
.605 .499 .706 r
.63912 .50295 .64278 .51139 .64578 .50906 .64212 .50061 Mtetra
.636 .514 .697 r
.64212 .50061 .64578 .50906 .64874 .50522 .64508 .49677 Mtetra
.652 .522 .692 r
.64508 .49677 .64874 .50522 .65168 .50042 .64801 .49197 Mtetra
.654 .523 .691 r
.64801 .49197 .65168 .50042 .65462 .49544 .65095 .487 Mtetra
.645 .518 .695 r
.65095 .487 .65462 .49544 .65757 .49107 .6539 .48262 Mtetra
.624 .508 .701 r
.6539 .48262 .65757 .49107 .66056 .48786 .65688 .47941 Mtetra
.59 .491 .71 r
.65688 .47941 .66056 .48786 .66359 .48609 .65991 .47764 Mtetra
.542 .467 .72 r
.65991 .47764 .66359 .48609 .66668 .48579 .66299 .47733 Mtetra
.484 .436 .728 r
.66299 .47733 .66668 .48579 .6698 .48671 .66611 .47823 Mtetra
.433 .408 .732 r
.66611 .47823 .6698 .48671 .67296 .48844 .66926 .47996 Mtetra
.41 .395 .732 r
.66926 .47996 .67296 .48844 .67614 .4905 .67243 .482 Mtetra
.426 .404 .732 r
.67243 .482 .67614 .4905 .67931 .49235 .6756 .48384 Mtetra
.471 .429 .729 r
.6756 .48384 .67931 .49235 .68248 .49351 .67876 .48499 Mtetra
.526 .458 .723 r
.67876 .48499 .68248 .49351 .68562 .4936 .68189 .48506 Mtetra
.575 .483 .714 r
.68189 .48506 .68562 .4936 .68872 .49234 .68498 .4838 Mtetra
.613 .502 .704 r
.68498 .4838 .68872 .49234 .69177 .48961 .68803 .48107 Mtetra
.64 .516 .696 r
.68803 .48107 .69177 .48961 .69478 .48543 .69104 .47689 Mtetra
.66 .525 .689 r
.69104 .47689 .69478 .48543 .69774 .47995 .694 .47141 Mtetra
.672 .531 .684 r
.694 .47141 .69774 .47995 .70066 .47341 .69692 .46488 Mtetra
.68 .535 .681 r
.69692 .46488 .70066 .47341 .70356 .46616 .69982 .45763 Mtetra
.684 .536 .68 r
.69982 .45763 .70356 .46616 .70645 .45855 .7027 .45003 Mtetra
.683 .536 .68 r
.7027 .45003 .70645 .45855 .70933 .45099 .70559 .44248 Mtetra
.679 .534 .682 r
.70559 .44248 .70933 .45099 .71223 .44385 .70848 .43534 Mtetra
.671 .531 .685 r
.70848 .43534 .71223 .44385 .71516 .43746 .71141 .42896 Mtetra
.658 .525 .69 r
.71141 .42896 .71516 .43746 .71812 .43211 .71437 .42361 Mtetra
.639 .515 .696 r
.71437 .42361 .71812 .43211 .72114 .42802 .71739 .41952 Mtetra
.612 .502 .705 r
.71739 .41952 .72114 .42802 .72422 .42531 .72046 .41681 Mtetra
.574 .484 .714 r
.72046 .41681 .72422 .42531 .72736 .42405 .72359 .41554 Mtetra
.523 .457 .724 r
.72359 .41554 .72736 .42405 .73056 .4242 .72679 .41568 Mtetra
.454 .421 .731 r
.72679 .41568 .73056 .4242 .73382 .42566 .73004 .41713 Mtetra
.369 .374 .734 r
.73004 .41713 .73382 .42566 .73714 .42827 .73336 .41973 Mtetra
.274 .319 .728 r
.73336 .41973 .73714 .42827 .74051 .43182 .73672 .42325 Mtetra
.187 .268 .716 r
.73672 .42325 .74051 .43182 .74392 .43602 .74012 .42744 Mtetra
.132 .235 .705 r
.74012 .42744 .74392 .43602 .74736 .4406 .74355 .432 Mtetra
.124 .231 .704 r
.74355 .432 .74736 .4406 .75082 .44524 .747 .43662 Mtetra
.167 .256 .712 r
.747 .43662 .75082 .44524 .75427 .44963 .75044 .44099 Mtetra
.244 .302 .725 r
.75044 .44099 .75427 .44963 .75771 .45347 .75388 .44482 Mtetra
.336 .355 .733 r
.75388 .44482 .75771 .45347 .76113 .45651 .75728 .44784 Mtetra
.424 .404 .733 r
.75728 .44784 .76113 .45651 .76451 .45849 .76065 .4498 Mtetra
.496 .443 .727 r
.76065 .4498 .76451 .45849 .76783 .45923 .76397 .45053 Mtetra
.553 .472 .718 r
.76397 .45053 .76783 .45923 .7711 .45859 .76723 .44989 Mtetra
.595 .494 .709 r
.76723 .44989 .7711 .45859 .77431 .4565 .77043 .44779 Mtetra
.627 .509 .7 r
.77043 .44779 .77431 .4565 .77744 .45293 .77356 .44422 Mtetra
.651 .521 .692 r
.77356 .44422 .77744 .45293 .78051 .44792 .77663 .43921 Mtetra
.668 .529 .685 r
.77663 .43921 .78051 .44792 .78351 .44155 .77962 .43285 Mtetra
.681 .535 .68 r
.77962 .43285 .78351 .44155 .78644 .43397 .78256 .42528 Mtetra
.691 .539 .676 r
.78256 .42528 .78644 .43397 .78932 .42536 .78544 .41667 Mtetra
.697 .542 .673 r
.78544 .41667 .78932 .42536 .79216 .41593 .78828 .40725 Mtetra
.702 .544 .671 r
.78828 .40725 .79216 .41593 .79496 .40591 .79108 .39725 Mtetra
.704 .545 .67 r
.79108 .39725 .79496 .40591 .79774 .39557 .79386 .38692 Mtetra
.705 .545 .669 r
.79386 .38692 .79774 .39557 .80051 .38516 .79663 .37652 Mtetra
.703 .545 .67 r
.79663 .37652 .80051 .38516 .80329 .37493 .79941 .36631 Mtetra
.7 .544 .671 r
.79941 .36631 .80329 .37493 .80608 .36515 .80221 .35653 Mtetra
.695 .541 .674 r
.80221 .35653 .80608 .36515 .80891 .35602 .80503 .34742 Mtetra
.688 .538 .677 r
.80503 .34742 .80891 .35602 .81178 .34777 .80791 .33918 Mtetra
.678 .533 .681 r
.80791 .33918 .81178 .34777 .81471 .34057 .81084 .33198 Mtetra
.665 .527 .687 r
.81084 .33198 .81471 .34057 .81771 .33457 .81383 .32598 Mtetra
.647 .519 .694 r
.81383 .32598 .81771 .33457 .82079 .32987 .8169 .32129 Mtetra
.622 .507 .702 r
.8169 .32129 .82079 .32987 .82395 .32655 .82006 .31797 Mtetra
.59 .492 .711 r
.82006 .31797 .82395 .32655 .82719 .32466 .8233 .31607 Mtetra
.547 .47 .72 r
.8233 .31607 .82719 .32466 .83053 .3242 .82663 .3156 Mtetra
.488 .44 .729 r
.82663 .3156 .83053 .3242 .83396 .32512 .83005 .31651 Mtetra
.408 .397 .735 r
.83005 .31651 .83396 .32512 .83747 .32737 .83356 .31875 Mtetra
.303 .338 .733 r
.83356 .31875 .83747 .32737 .84108 .33085 .83715 .32221 Mtetra
.172 .262 .716 r
.83715 .32221 .84108 .33085 .84476 .33541 .84083 .32675 Mtetra
.024 .172 .681 r
.84083 .32675 .84476 .33541 .84851 .34092 .84457 .33224 Mtetra
0 .082 .631 r
.84457 .33224 .84851 .34092 .85233 .34719 .84838 .33848 Mtetra
0 .006 .58 r
.84838 .33848 .85233 .34719 .8562 .35402 .85224 .34529 Mtetra
0 0 .543 r
.85224 .34529 .8562 .35402 .86011 .3612 .85613 .35244 Mtetra
0 0 .53 r
.85613 .35244 .86011 .3612 .86404 .36852 .86005 .35973 Mtetra
0 0 .546 r
.86005 .35973 .86404 .36852 .86799 .37574 .86399 .36694 Mtetra
.827 .456 0 r
.41373 .62548 .41706 .6335 .41965 .64058 .41631 .63253 Mtetra
.843 .472 0 r
.41631 .63253 .41965 .64058 .42224 .6478 .4189 .63974 Mtetra
.83 .459 0 r
.4189 .63974 .42224 .6478 .42485 .65496 .4215 .64688 Mtetra
.778 .414 0 r
.4215 .64688 .42485 .65496 .42747 .66184 .42411 .65374 Mtetra
.662 .319 0 r
.42411 .65374 .42747 .66184 .43011 .66824 .42674 .66011 Mtetra
0 0 .44 r
.42674 .66011 .43011 .66824 .43277 .67394 .42939 .6658 Mtetra
0 .045 .604 r
.42939 .6658 .43277 .67394 .43545 .67877 .43206 .67061 Mtetra
.125 .224 .696 r
.43206 .67061 .43545 .67877 .43815 .68255 .43475 .67437 Mtetra
.324 .343 .727 r
.43475 .67437 .43815 .68255 .44086 .68514 .43746 .67695 Mtetra
.452 .417 .729 r
.43746 .67695 .44086 .68514 .4436 .68643 .44019 .67823 Mtetra
.533 .461 .721 r
.44019 .67823 .4436 .68643 .44635 .68634 .44294 .67813 Mtetra
.587 .49 .711 r
.44294 .67813 .44635 .68634 .44912 .68483 .44571 .67661 Mtetra
.623 .508 .702 r
.44571 .67661 .44912 .68483 .45191 .68189 .44849 .67367 Mtetra
.649 .521 .694 r
.44849 .67367 .45191 .68189 .4547 .67757 .45128 .66935 Mtetra
.667 .53 .688 r
.45128 .66935 .4547 .67757 .45751 .67194 .45408 .66373 Mtetra
.68 .537 .683 r
.45408 .66373 .45751 .67194 .46032 .66513 .4569 .65692 Mtetra
.69 .541 .679 r
.4569 .65692 .46032 .66513 .46314 .65728 .45971 .64908 Mtetra
.697 .544 .676 r
.45971 .64908 .46314 .65728 .46596 .64859 .46253 .6404 Mtetra
.701 .547 .674 r
.46253 .6404 .46596 .64859 .46878 .63927 .46535 .63109 Mtetra
.704 .548 .673 r
.46535 .63109 .46878 .63927 .47159 .62955 .46817 .62138 Mtetra
.705 .548 .673 r
.46817 .62138 .47159 .62955 .47441 .61967 .47099 .61152 Mtetra
.47099 .61152 .47441 .61967 .47722 .60989 .4738 .60174 Mtetra
.703 .547 .674 r
.4738 .60174 .47722 .60989 .48002 .60045 .4766 .59232 Mtetra
.699 .545 .676 r
.4766 .59232 .48002 .60045 .48283 .59159 .4794 .58347 Mtetra
.692 .542 .678 r
.4794 .58347 .48283 .59159 .48562 .58353 .4822 .57542 Mtetra
.683 .538 .682 r
.4822 .57542 .48562 .58353 .48841 .57647 .48499 .56836 Mtetra
.671 .532 .687 r
.48499 .56836 .48841 .57647 .49121 .57056 .48778 .56246 Mtetra
.654 .524 .693 r
.48778 .56246 .49121 .57056 .494 .56594 .49057 .55783 Mtetra
.63 .512 .7 r
.49057 .55783 .494 .56594 .49679 .56267 .49336 .55456 Mtetra
.597 .495 .709 r
.49336 .55456 .49679 .56267 .49958 .56079 .49615 .55268 Mtetra
.551 .471 .719 r
.49615 .55268 .49958 .56079 .50238 .56029 .49895 .55218 Mtetra
.485 .436 .727 r
.49895 .55218 .50238 .56029 .50519 .5611 .50175 .55297 Mtetra
.395 .386 .731 r
.50175 .55297 .50519 .5611 .50801 .56309 .50456 .55495 Mtetra
.278 .318 .725 r
.50456 .55495 .50801 .56309 .51084 .5661 .50738 .55794 Mtetra
.146 .239 .704 r
.50738 .55794 .51084 .5661 .51368 .56991 .51021 .56174 Mtetra
.03 .167 .674 r
.51021 .56174 .51368 .56991 .51652 .57427 .51305 .56608 Mtetra
0 .127 .654 r
.51305 .56608 .51652 .57427 .51939 .5789 .51591 .5707 Mtetra
0 .134 .657 r
.51591 .5707 .51939 .5789 .52226 .5835 .51877 .57528 Mtetra
.06 .186 .683 r
.51877 .57528 .52226 .5835 .52513 .58778 .52164 .57954 Mtetra
.187 .264 .712 r
.52164 .57954 .52513 .58778 .52802 .59143 .52452 .58318 Mtetra
.32 .343 .729 r
.52452 .58318 .52802 .59143 .53091 .59418 .5274 .58591 Mtetra
.431 .406 .731 r
.5274 .58591 .53091 .59418 .5338 .59581 .53028 .58753 Mtetra
.513 .451 .724 r
.53028 .58753 .5338 .59581 .53669 .59613 .53317 .58784 Mtetra
.572 .482 .714 r
.53317 .58784 .53669 .59613 .53957 .59504 .53605 .58675 Mtetra
.612 .503 .705 r
.53605 .58675 .53957 .59504 .54245 .59252 .53892 .58422 Mtetra
.64 .517 .697 r
.53892 .58422 .54245 .59252 .54532 .5886 .54178 .5803 Mtetra
.659 .526 .69 r
.54178 .5803 .54532 .5886 .54817 .58343 .54464 .57514 Mtetra
.672 .532 .686 r
.54464 .57514 .54817 .58343 .55102 .57723 .54749 .56894 Mtetra
.68 .536 .683 r
.54749 .56894 .55102 .57723 .55386 .57028 .55033 .56199 Mtetra
.684 .538 .681 r
.55033 .56199 .55386 .57028 .5567 .56292 .55316 .55464 Mtetra
.685 .538 .681 r
.55316 .55464 .5567 .56292 .55953 .55552 .556 .54725 Mtetra
.681 .537 .682 r
.556 .54725 .55953 .55552 .56237 .54848 .55883 .54021 Mtetra
.674 .533 .685 r
.55883 .54021 .56237 .54848 .56522 .54215 .56167 .53389 Mtetra
.661 .527 .69 r
.56167 .53389 .56522 .54215 .56807 .53684 .56453 .52859 Mtetra
.642 .518 .696 r
.56453 .52859 .56807 .53684 .57095 .53281 .5674 .52456 Mtetra
.614 .504 .705 r
.5674 .52456 .57095 .53281 .57384 .53019 .57029 .52193 Mtetra
.575 .484 .714 r
.57029 .52193 .57384 .53019 .57676 .529 .5732 .52073 Mtetra
.523 .457 .723 r
.5732 .52073 .57676 .529 .5797 .52912 .57614 .52084 Mtetra
.465 .426 .73 r
.57614 .52084 .5797 .52912 .58266 .53029 .5791 .52201 Mtetra
.415 .398 .732 r
.5791 .52201 .58266 .53029 .58564 .53215 .58207 .52386 Mtetra
.397 .388 .732 r
.58207 .52386 .58564 .53215 .58864 .53423 .58506 .52592 Mtetra
.423 .403 .732 r
.58506 .52592 .58864 .53423 .59163 .536 .58805 .52768 Mtetra
.479 .433 .728 r
.58805 .52768 .59163 .536 .59462 .53696 .59103 .52863 Mtetra
.54 .466 .721 r
.59103 .52863 .59462 .53696 .5976 .53671 .594 .52837 Mtetra
.59 .491 .711 r
.594 .52837 .5976 .53671 .60055 .535 .59695 .52666 Mtetra
.624 .509 .701 r
.59695 .52666 .60055 .535 .60349 .53184 .59988 .5235 Mtetra
.646 .519 .695 r
.59988 .5235 .60349 .53184 .6064 .52752 .60279 .51917 Mtetra
.655 .524 .692 r
.60279 .51917 .6064 .52752 .6093 .52259 .60569 .51425 Mtetra
.652 .522 .693 r
.60569 .51425 .6093 .52259 .61221 .51783 .6086 .50949 Mtetra
.637 .515 .698 r
.6086 .50949 .61221 .51783 .61514 .51403 .61152 .50568 Mtetra
.605 .499 .707 r
.61152 .50568 .61514 .51403 .6181 .51171 .61448 .50336 Mtetra
.563 .478 .717 r
.61448 .50336 .6181 .51171 .62109 .51083 .61747 .50248 Mtetra
.546 .469 .72 r
.61747 .50248 .62109 .51083 .62411 .51043 .62048 .50207 Mtetra
.587 .49 .711 r
.62048 .50207 .62411 .51043 .6271 .50879 .62346 .50043 Mtetra
.619 .506 .703 r
.62346 .50043 .6271 .50879 .63006 .50589 .62642 .49752 Mtetra
.587 .49 .711 r
.62642 .49752 .63006 .50589 .63306 .50425 .62942 .49587 Mtetra
.546 .469 .72 r
.62942 .49587 .63306 .50425 .63609 .50384 .63245 .49545 Mtetra
.563 .478 .717 r
.63245 .49545 .63609 .50384 .63912 .50295 .63547 .49456 Mtetra
.605 .499 .707 r
.63547 .49456 .63912 .50295 .64212 .50061 .63846 .49222 Mtetra
.636 .515 .698 r
.63846 .49222 .64212 .50061 .64508 .49677 .64141 .48837 Mtetra
.652 .522 .693 r
.64141 .48837 .64508 .49677 .64801 .49197 .64435 .48357 Mtetra
.654 .523 .692 r
.64435 .48357 .64801 .49197 .65095 .487 .64728 .4786 Mtetra
.645 .519 .695 r
.64728 .4786 .65095 .487 .6539 .48262 .65023 .47423 Mtetra
.624 .509 .701 r
.65023 .47423 .6539 .48262 .65688 .47941 .65321 .47101 Mtetra
.59 .492 .711 r
.65321 .47101 .65688 .47941 .65991 .47764 .65623 .46924 Mtetra
.542 .467 .721 r
.65623 .46924 .65991 .47764 .66299 .47733 .65931 .46892 Mtetra
.484 .437 .729 r
.65931 .46892 .66299 .47733 .66611 .47823 .66242 .46982 Mtetra
.432 .409 .732 r
.66242 .46982 .66611 .47823 .66926 .47996 .66556 .47153 Mtetra
.409 .395 .733 r
.66556 .47153 .66926 .47996 .67243 .482 .66873 .47356 Mtetra
.425 .404 .733 r
.66873 .47356 .67243 .482 .6756 .48384 .67189 .47538 Mtetra
.471 .429 .73 r
.67189 .47538 .6756 .48384 .67876 .48499 .67504 .47652 Mtetra
.526 .459 .723 r
.67504 .47652 .67876 .48499 .68189 .48506 .67817 .47659 Mtetra
.575 .484 .714 r
.67817 .47659 .68189 .48506 .68498 .4838 .68126 .47532 Mtetra
.613 .503 .705 r
.68126 .47532 .68498 .4838 .68803 .48107 .6843 .47258 Mtetra
.641 .517 .696 r
.6843 .47258 .68803 .48107 .69104 .47689 .6873 .4684 Mtetra
.66 .526 .689 r
.6873 .4684 .69104 .47689 .694 .47141 .69026 .46293 Mtetra
.673 .532 .684 r
.69026 .46293 .694 .47141 .69692 .46488 .69318 .4564 Mtetra
.68 .535 .681 r
.69318 .4564 .69692 .46488 .69982 .45763 .69608 .44916 Mtetra
.684 .537 .68 r
.69608 .44916 .69982 .45763 .7027 .45003 .69896 .44157 Mtetra
.69896 .44157 .7027 .45003 .70559 .44248 .70185 .43402 Mtetra
.679 .535 .682 r
.70185 .43402 .70559 .44248 .70848 .43534 .70474 .42689 Mtetra
.671 .531 .685 r
.70474 .42689 .70848 .43534 .71141 .42896 .70767 .42051 Mtetra
.658 .525 .69 r
.70767 .42051 .71141 .42896 .71437 .42361 .71063 .41517 Mtetra
.639 .516 .697 r
.71063 .41517 .71437 .42361 .71739 .41952 .71364 .41108 Mtetra
.612 .503 .705 r
.71364 .41108 .71739 .41952 .72046 .41681 .71671 .40836 Mtetra
.575 .484 .715 r
.71671 .40836 .72046 .41681 .72359 .41554 .71983 .40708 Mtetra
.523 .458 .724 r
.71983 .40708 .72359 .41554 .72679 .41568 .72302 .40721 Mtetra
.454 .421 .732 r
.72302 .40721 .72679 .41568 .73004 .41713 .72627 .40865 Mtetra
.368 .374 .734 r
.72627 .40865 .73004 .41713 .73336 .41973 .72958 .41124 Mtetra
.272 .319 .729 r
.72958 .41124 .73336 .41973 .73672 .42325 .73293 .41475 Mtetra
.184 .267 .716 r
.73293 .41475 .73672 .42325 .74012 .42744 .73633 .41892 Mtetra
.128 .234 .705 r
.73633 .41892 .74012 .42744 .74355 .432 .73975 .42346 Mtetra
.12 .229 .704 r
.73975 .42346 .74355 .432 .747 .43662 .74318 .42806 Mtetra
.163 .255 .713 r
.74318 .42806 .747 .43662 .75044 .44099 .74662 .43241 Mtetra
.242 .301 .725 r
.74662 .43241 .75044 .44099 .75388 .44482 .75004 .43622 Mtetra
.335 .355 .733 r
.75004 .43622 .75388 .44482 .75728 .44784 .75344 .43922 Mtetra
.423 .404 .734 r
.75344 .43922 .75728 .44784 .76065 .4498 .7568 .44117 Mtetra
.496 .443 .728 r
.7568 .44117 .76065 .4498 .76397 .45053 .76012 .44189 Mtetra
.553 .473 .719 r
.76012 .44189 .76397 .45053 .76723 .44989 .76337 .44124 Mtetra
.596 .494 .709 r
.76337 .44124 .76723 .44989 .77043 .44779 .76657 .43914 Mtetra
.628 .51 .7 r
.76657 .43914 .77043 .44779 .77356 .44422 .76969 .43557 Mtetra
.651 .521 .692 r
.76969 .43557 .77356 .44422 .77663 .43921 .77276 .43056 Mtetra
.669 .529 .685 r
.77276 .43056 .77663 .43921 .77962 .43285 .77575 .4242 Mtetra
.682 .535 .68 r
.77575 .4242 .77962 .43285 .78256 .42528 .77869 .41664 Mtetra
.691 .54 .676 r
.77869 .41664 .78256 .42528 .78544 .41667 .78157 .40804 Mtetra
.698 .543 .673 r
.78157 .40804 .78544 .41667 .78828 .40725 .7844 .39863 Mtetra
.702 .544 .671 r
.7844 .39863 .78828 .40725 .79108 .39725 .78721 .38864 Mtetra
.704 .546 .67 r
.78721 .38864 .79108 .39725 .79386 .38692 .78999 .37832 Mtetra
.705 .546 .67 r
.78999 .37832 .79386 .38692 .79663 .37652 .79276 .36794 Mtetra
.704 .545 .67 r
.79276 .36794 .79663 .37652 .79941 .36631 .79554 .35774 Mtetra
.701 .544 .672 r
.79554 .35774 .79941 .36631 .80221 .35653 .79834 .34798 Mtetra
.696 .542 .674 r
.79834 .34798 .80221 .35653 .80503 .34742 .80116 .33888 Mtetra
.689 .538 .677 r
.80116 .33888 .80503 .34742 .80791 .33918 .80404 .33064 Mtetra
.679 .534 .682 r
.80404 .33064 .80791 .33918 .81084 .33198 .80697 .32345 Mtetra
.665 .528 .687 r
.80697 .32345 .81084 .33198 .81383 .32598 .80996 .31745 Mtetra
.647 .519 .694 r
.80996 .31745 .81383 .32598 .8169 .32129 .81303 .31276 Mtetra
.623 .508 .702 r
.81303 .31276 .8169 .32129 .82006 .31797 .81618 .30944 Mtetra
.591 .492 .711 r
.81618 .30944 .82006 .31797 .8233 .31607 .81941 .30754 Mtetra
.547 .47 .721 r
.81941 .30754 .8233 .31607 .82663 .3156 .82274 .30706 Mtetra
.487 .44 .73 r
.82274 .30706 .82663 .3156 .83005 .31651 .82615 .30796 Mtetra
.407 .397 .736 r
.82615 .30796 .83005 .31651 .83356 .31875 .82965 .31018 Mtetra
.301 .338 .733 r
.82965 .31018 .83356 .31875 .83715 .32221 .83324 .31362 Mtetra
.168 .261 .716 r
.83324 .31362 .83715 .32221 .84083 .32675 .8369 .31815 Mtetra
.019 .17 .68 r
.8369 .31815 .84083 .32675 .84457 .33224 .84064 .32361 Mtetra
0 .078 .629 r
.84064 .32361 .84457 .33224 .84838 .33848 .84443 .32983 Mtetra
0 .002 .577 r
.84443 .32983 .84838 .33848 .85224 .34529 .84828 .33661 Mtetra
0 0 .539 r
.84828 .33661 .85224 .34529 .85613 .35244 .85216 .34374 Mtetra
0 0 .526 r
.85216 .34374 .85613 .35244 .86005 .35973 .85607 .35101 Mtetra
0 0 .542 r
.85607 .35101 .86005 .35973 .86399 .36694 .85999 .35818 Mtetra
.863 .484 0 r
.4104 .61781 .41373 .62548 .41631 .63253 .41297 .62484 Mtetra
.876 .497 .021 r
.41297 .62484 .41631 .63253 .4189 .63974 .41555 .63202 Mtetra
.866 .486 .001 r
.41555 .63202 .4189 .63974 .4215 .64688 .41814 .63914 Mtetra
.825 .447 0 r
.41814 .63914 .4215 .64688 .42411 .65374 .42075 .64598 Mtetra
.726 .362 0 r
.42075 .64598 .42411 .65374 .42674 .66011 .42337 .65234 Mtetra
0 0 .39 r
.42337 .65234 .42674 .66011 .42939 .6658 .42601 .65801 Mtetra
0 .01 .581 r
.42601 .65801 .42939 .6658 .43206 .67061 .42867 .6628 Mtetra
.087 .208 .695 r
.42867 .6628 .43206 .67061 .43475 .67437 .43136 .66655 Mtetra
.308 .341 .732 r
.43136 .66655 .43475 .67437 .43746 .67695 .43406 .66912 Mtetra
.447 .419 .734 r
.43406 .66912 .43746 .67695 .44019 .67823 .43679 .67039 Mtetra
.533 .465 .725 r
.43679 .67039 .44019 .67823 .44294 .67813 .43953 .67028 Mtetra
.589 .494 .714 r
.43953 .67028 .44294 .67813 .44571 .67661 .44229 .66876 Mtetra
.626 .512 .705 r
.44229 .66876 .44571 .67661 .44849 .67367 .44507 .66582 Mtetra
.652 .525 .696 r
.44507 .66582 .44849 .67367 .45128 .66935 .44786 .66149 Mtetra
.67 .534 .69 r
.44786 .66149 .45128 .66935 .45408 .66373 .45066 .65587 Mtetra
.683 .54 .684 r
.45066 .65587 .45408 .66373 .4569 .65692 .45347 .64907 Mtetra
.693 .544 .68 r
.45347 .64907 .4569 .65692 .45971 .64908 .45629 .64124 Mtetra
.7 .548 .677 r
.45629 .64124 .45971 .64908 .46253 .6404 .45911 .63257 Mtetra
.704 .55 .675 r
.45911 .63257 .46253 .6404 .46535 .63109 .46193 .62327 Mtetra
.707 .551 .674 r
.46193 .62327 .46535 .63109 .46817 .62138 .46475 .61357 Mtetra
.708 .551 .674 r
.46475 .61357 .46817 .62138 .47099 .61152 .46757 .60371 Mtetra
.46757 .60371 .47099 .61152 .4738 .60174 .47038 .59395 Mtetra
.705 .55 .675 r
.47038 .59395 .4738 .60174 .4766 .59232 .47318 .58453 Mtetra
.701 .548 .677 r
.47318 .58453 .4766 .59232 .4794 .58347 .47599 .57569 Mtetra
.695 .546 .679 r
.47599 .57569 .4794 .58347 .4822 .57542 .47878 .56765 Mtetra
.686 .541 .683 r
.47878 .56765 .4822 .57542 .48499 .56836 .48157 .5606 Mtetra
.674 .536 .688 r
.48157 .5606 .48499 .56836 .48778 .56246 .48436 .5547 Mtetra
.657 .528 .695 r
.48436 .5547 .48778 .56246 .49057 .55783 .48715 .55008 Mtetra
.633 .516 .703 r
.48715 .55008 .49057 .55783 .49336 .55456 .48993 .54681 Mtetra
.599 .5 .712 r
.48993 .54681 .49336 .55456 .49615 .55268 .49272 .54492 Mtetra
.552 .475 .723 r
.49272 .54492 .49615 .55268 .49895 .55218 .49551 .54441 Mtetra
.483 .439 .733 r
.49551 .54441 .49895 .55218 .50175 .55297 .49831 .54519 Mtetra
.386 .387 .737 r
.49831 .54519 .50175 .55297 .50456 .55495 .50111 .54716 Mtetra
.258 .313 .729 r
.50111 .54716 .50456 .55495 .50738 .55794 .50393 .55014 Mtetra
.112 .226 .703 r
.50393 .55014 .50738 .55794 .51021 .56174 .50675 .55392 Mtetra
0 .145 .667 r
.50675 .55392 .51021 .56174 .51305 .56608 .50959 .55825 Mtetra
0 .1 .642 r
.50959 .55825 .51305 .56608 .51591 .5707 .51243 .56285 Mtetra
0 .108 .647 r
.51243 .56285 .51591 .5707 .51877 .57528 .51529 .56742 Mtetra
.017 .166 .678 r
.51529 .56742 .51877 .57528 .52164 .57954 .51815 .57166 Mtetra
.158 .253 .713 r
.51815 .57166 .52164 .57954 .52452 .58318 .52102 .57528 Mtetra
.304 .34 .734 r
.52102 .57528 .52452 .58318 .5274 .58591 .5239 .57801 Mtetra
.425 .408 .737 r
.5239 .57801 .5274 .58591 .53028 .58753 .52677 .57961 Mtetra
.512 .455 .729 r
.52677 .57961 .53028 .58753 .53317 .58784 .52965 .57992 Mtetra
.573 .486 .718 r
.52965 .57992 .53317 .58784 .53605 .58675 .53253 .57882 Mtetra
.615 .507 .708 r
.53253 .57882 .53605 .58675 .53892 .58422 .5354 .57628 Mtetra
.643 .521 .699 r
.5354 .57628 .53892 .58422 .54178 .5803 .53826 .57237 Mtetra
.662 .53 .692 r
.53826 .57237 .54178 .5803 .54464 .57514 .54111 .5672 Mtetra
.675 .536 .687 r
.54111 .5672 .54464 .57514 .54749 .56894 .54396 .56101 Mtetra
.683 .54 .684 r
.54396 .56101 .54749 .56894 .55033 .56199 .5468 .55407 Mtetra
.687 .541 .682 r
.5468 .55407 .55033 .56199 .55316 .55464 .54963 .54672 Mtetra
.688 .542 .682 r
.54963 .54672 .55316 .55464 .556 .54725 .55247 .53934 Mtetra
.684 .54 .683 r
.55247 .53934 .556 .54725 .55883 .54021 .5553 .53231 Mtetra
.677 .537 .687 r
.5553 .53231 .55883 .54021 .56167 .53389 .55814 .52598 Mtetra
.664 .531 .692 r
.55814 .52598 .56167 .53389 .56453 .52859 .56099 .52069 Mtetra
.645 .522 .699 r
.56099 .52069 .56453 .52859 .5674 .52456 .56386 .51665 Mtetra
.616 .508 .708 r
.56386 .51665 .5674 .52456 .57029 .52193 .56675 .51403 Mtetra
.576 .488 .718 r
.56675 .51403 .57029 .52193 .5732 .52073 .56966 .51282 Mtetra
.523 .461 .728 r
.56966 .51282 .5732 .52073 .57614 .52084 .57259 .51292 Mtetra
.461 .428 .735 r
.57259 .51292 .57614 .52084 .5791 .52201 .57554 .51408 Mtetra
.408 .399 .738 r
.57554 .51408 .5791 .52201 .58207 .52386 .57851 .51592 Mtetra
.389 .389 .738 r
.57851 .51592 .58207 .52386 .58506 .52592 .58149 .51796 Mtetra
.417 .404 .738 r
.58149 .51796 .58506 .52592 .58805 .52768 .58447 .51971 Mtetra
.476 .436 .734 r
.58447 .51971 .58805 .52768 .59103 .52863 .58745 .52066 Mtetra
.54 .47 .725 r
.58745 .52066 .59103 .52863 .594 .52837 .59042 .52039 Mtetra
.592 .496 .714 r
.59042 .52039 .594 .52837 .59695 .52666 .59336 .51867 Mtetra
.627 .513 .704 r
.59336 .51867 .59695 .52666 .59988 .5235 .59629 .51551 Mtetra
.649 .523 .697 r
.59629 .51551 .59988 .5235 .60279 .51917 .59919 .51118 Mtetra
.658 .527 .694 r
.59919 .51118 .60279 .51917 .60569 .51425 .60209 .50626 Mtetra
.655 .526 .695 r
.60209 .50626 .60569 .51425 .6086 .50949 .60499 .5015 Mtetra
.64 .519 .7 r
.60499 .5015 .6086 .50949 .61152 .50568 .60792 .49769 Mtetra
.608 .504 .71 r
.60792 .49769 .61152 .50568 .61448 .50336 .61087 .49537 Mtetra
.564 .482 .721 r
.61087 .49537 .61448 .50336 .61747 .50248 .61386 .49448 Mtetra
.546 .473 .724 r
.61386 .49448 .61747 .50248 .62048 .50207 .61686 .49407 Mtetra
.589 .494 .715 r
.61686 .49407 .62048 .50207 .62346 .50043 .61984 .49242 Mtetra
.621 .51 .706 r
.61984 .49242 .62346 .50043 .62642 .49752 .6228 .48951 Mtetra
.589 .494 .715 r
.6228 .48951 .62642 .49752 .62942 .49587 .62579 .48785 Mtetra
.546 .473 .724 r
.62579 .48785 .62942 .49587 .63245 .49545 .62881 .48743 Mtetra
.565 .482 .721 r
.62881 .48743 .63245 .49545 .63547 .49456 .63183 .48653 Mtetra
.608 .503 .71 r
.63183 .48653 .63547 .49456 .63846 .49222 .63481 .48418 Mtetra
.639 .519 .7 r
.63481 .48418 .63846 .49222 .64141 .48837 .63777 .48034 Mtetra
.655 .526 .695 r
.63777 .48034 .64141 .48837 .64435 .48357 .6407 .47554 Mtetra
.657 .527 .694 r
.6407 .47554 .64435 .48357 .64728 .4786 .64363 .47057 Mtetra
.648 .523 .697 r
.64363 .47057 .64728 .4786 .65023 .47423 .64657 .4662 Mtetra
.627 .513 .704 r
.64657 .4662 .65023 .47423 .65321 .47101 .64955 .46298 Mtetra
.592 .496 .714 r
.64955 .46298 .65321 .47101 .65623 .46924 .65257 .4612 Mtetra
.542 .471 .725 r
.65257 .4612 .65623 .46924 .65931 .46892 .65564 .46087 Mtetra
.482 .44 .734 r
.65564 .46087 .65931 .46892 .66242 .46982 .65874 .46176 Mtetra
.426 .41 .738 r
.65874 .46176 .66242 .46982 .66556 .47153 .66188 .46346 Mtetra
.401 .396 .739 r
.66188 .46346 .66556 .47153 .66873 .47356 .66504 .46548 Mtetra
.419 .406 .739 r
.66504 .46548 .66873 .47356 .67189 .47538 .6682 .46729 Mtetra
.467 .432 .735 r
.6682 .46729 .67189 .47538 .67504 .47652 .67134 .46842 Mtetra
.525 .462 .728 r
.67134 .46842 .67504 .47652 .67817 .47659 .67446 .46847 Mtetra
.576 .488 .718 r
.67446 .46847 .67817 .47659 .68126 .47532 .67754 .4672 Mtetra
.616 .507 .707 r
.67754 .4672 .68126 .47532 .6843 .47258 .68059 .46446 Mtetra
.644 .521 .698 r
.68059 .46446 .6843 .47258 .6873 .4684 .68358 .46028 Mtetra
.663 .53 .691 r
.68358 .46028 .6873 .4684 .69026 .46293 .68654 .45481 Mtetra
.676 .535 .686 r
.68654 .45481 .69026 .46293 .69318 .4564 .68946 .44829 Mtetra
.684 .539 .683 r
.68946 .44829 .69318 .4564 .69608 .44916 .69236 .44105 Mtetra
.687 .54 .681 r
.69236 .44105 .69608 .44916 .69896 .44157 .69524 .43346 Mtetra
.69524 .43346 .69896 .44157 .70185 .43402 .69812 .42592 Mtetra
.683 .538 .683 r
.69812 .42592 .70185 .43402 .70474 .42689 .70102 .4188 Mtetra
.674 .535 .687 r
.70102 .4188 .70474 .42689 .70767 .42051 .70394 .41242 Mtetra
.661 .529 .692 r
.70394 .41242 .70767 .42051 .71063 .41517 .7069 .40709 Mtetra
.642 .52 .699 r
.7069 .40709 .71063 .41517 .71364 .41108 .70991 .40299 Mtetra
.615 .507 .708 r
.70991 .40299 .71364 .41108 .71671 .40836 .71297 .40027 Mtetra
.576 .488 .718 r
.71297 .40027 .71671 .40836 .71983 .40708 .71609 .39899 Mtetra
.522 .461 .729 r
.71609 .39899 .71983 .40708 .72302 .40721 .71928 .39911 Mtetra
.45 .423 .738 r
.71928 .39911 .72302 .40721 .72627 .40865 .72252 .40054 Mtetra
.357 .373 .74 r
.72252 .40054 .72627 .40865 .72958 .41124 .72582 .40311 Mtetra
.252 .314 .733 r
.72582 .40311 .72958 .41124 .73293 .41475 .72917 .4066 Mtetra
.156 .257 .718 r
.72917 .4066 .73293 .41475 .73633 .41892 .73255 .41075 Mtetra
.094 .22 .705 r
.73255 .41075 .73633 .41892 .73975 .42346 .73596 .41528 Mtetra
.086 .215 .703 r
.73596 .41528 .73975 .42346 .74318 .42806 .73939 .41986 Mtetra
.133 .243 .713 r
.73939 .41986 .74318 .42806 .74662 .43241 .74282 .42419 Mtetra
.219 .295 .729 r
.74282 .42419 .74662 .43241 .75004 .43622 .74623 .42799 Mtetra
.321 .353 .739 r
.74623 .42799 .75004 .43622 .75344 .43922 .74962 .43097 Mtetra
.416 .405 .739 r
.74962 .43097 .75344 .43922 .7568 .44117 .75298 .43292 Mtetra
.494 .447 .733 r
.75298 .43292 .7568 .44117 .76012 .44189 .75628 .43362 Mtetra
.554 .477 .723 r
.75628 .43362 .76012 .44189 .76337 .44124 .75953 .43297 Mtetra
.598 .499 .712 r
.75953 .43297 .76337 .44124 .76657 .43914 .76272 .43086 Mtetra
.63 .514 .703 r
.76272 .43086 .76657 .43914 .76969 .43557 .76585 .42728 Mtetra
.654 .525 .694 r
.76585 .42728 .76969 .43557 .77276 .43056 .76891 .42228 Mtetra
.672 .533 .687 r
.76891 .42228 .77276 .43056 .77575 .4242 .7719 .41592 Mtetra
.685 .539 .681 r
.7719 .41592 .77575 .4242 .77869 .41664 .77483 .40836 Mtetra
.694 .543 .677 r
.77483 .40836 .77869 .41664 .78157 .40804 .77771 .39978 Mtetra
.701 .546 .674 r
.77771 .39978 .78157 .40804 .7844 .39863 .78055 .39038 Mtetra
.705 .548 .672 r
.78055 .39038 .7844 .39863 .78721 .38864 .78336 .3804 Mtetra
.708 .549 .671 r
.78336 .3804 .78721 .38864 .78999 .37832 .78614 .37009 Mtetra
.708 .549 .67 r
.78614 .37009 .78999 .37832 .79276 .36794 .78891 .35972 Mtetra
.707 .548 .671 r
.78891 .35972 .79276 .36794 .79554 .35774 .79169 .34953 Mtetra
.704 .547 .672 r
.79169 .34953 .79554 .35774 .79834 .34798 .79449 .33978 Mtetra
.699 .545 .675 r
.79449 .33978 .79834 .34798 .80116 .33888 .79732 .33069 Mtetra
.692 .542 .678 r
.79732 .33069 .80116 .33888 .80404 .33064 .80019 .32246 Mtetra
.682 .538 .683 r
.80019 .32246 .80404 .33064 .80697 .32345 .80312 .31528 Mtetra
.668 .532 .689 r
.80312 .31528 .80697 .32345 .80996 .31745 .80611 .30929 Mtetra
.65 .523 .696 r
.80611 .30929 .80996 .31745 .81303 .31276 .80918 .30459 Mtetra
.626 .512 .705 r
.80918 .30459 .81303 .31276 .81618 .30944 .81232 .30127 Mtetra
.593 .497 .714 r
.81232 .30127 .81618 .30944 .81941 .30754 .81555 .29936 Mtetra
.547 .475 .725 r
.81555 .29936 .81941 .30754 .82274 .30706 .81887 .29887 Mtetra
.485 .443 .735 r
.81887 .29887 .82274 .30706 .82615 .30796 .82228 .29977 Mtetra
.4 .398 .742 r
.82228 .29977 .82615 .30796 .82965 .31018 .82577 .30197 Mtetra
.285 .334 .738 r
.82577 .30197 .82965 .31018 .83324 .31362 .82935 .3054 Mtetra
.139 .25 .717 r
.82935 .3054 .83324 .31362 .8369 .31815 .833 .30991 Mtetra
0 .15 .674 r
.833 .30991 .8369 .31815 .84064 .32361 .83673 .31535 Mtetra
0 .049 .612 r
.83673 .31535 .84064 .32361 .84443 .32983 .84051 .32155 Mtetra
0 0 .55 r
.84051 .32155 .84443 .32983 .84828 .33661 .84435 .3283 Mtetra
0 0 .506 r
.84435 .3283 .84828 .33661 .85216 .34374 .84822 .33541 Mtetra
0 0 .492 r
.84822 .33541 .85216 .34374 .85607 .35101 .85212 .34265 Mtetra
0 0 .51 r
.85212 .34265 .85607 .35101 .85999 .35818 .85602 .3498 Mtetra
.908 .52 .097 r
.40707 .61077 .4104 .61781 .41297 .62484 .40963 .61778 Mtetra
.915 .53 .118 r
.40963 .61778 .41297 .62484 .41555 .63202 .4122 .62495 Mtetra
.909 .522 .101 r
.4122 .62495 .41555 .63202 .41814 .63914 .41478 .63205 Mtetra
.885 .494 .041 r
.41478 .63205 .41814 .63914 .42075 .64598 .41738 .63887 Mtetra
.821 .43 0 r
.41738 .63887 .42075 .64598 .42337 .65234 .41999 .64521 Mtetra
.664 .294 0 r
.41999 .64521 .42337 .65234 .42601 .65801 .42263 .65086 Mtetra
0 0 .52 r
.42263 .65086 .42601 .65801 .42867 .6628 .42528 .65564 Mtetra
.002 .171 .686 r
.42528 .65564 .42867 .6628 .43136 .66655 .42796 .65938 Mtetra
.274 .333 .743 r
.42796 .65938 .43136 .66655 .43406 .66912 .43066 .66193 Mtetra
.437 .423 .746 r
.43066 .66193 .43406 .66912 .43679 .67039 .43338 .66319 Mtetra
.533 .473 .735 r
.43338 .66319 .43679 .67039 .43953 .67028 .43612 .66308 Mtetra
.593 .503 .722 r
.43612 .66308 .43953 .67028 .44229 .66876 .43888 .66155 Mtetra
.631 .521 .71 r
.43888 .66155 .44229 .66876 .44507 .66582 .44165 .65861 Mtetra
.658 .533 .7 r
.44165 .65861 .44507 .66582 .44786 .66149 .44444 .65429 Mtetra
.676 .541 .693 r
.44444 .65429 .44786 .66149 .45066 .65587 .44724 .64867 Mtetra
.689 .547 .687 r
.44724 .64867 .45066 .65587 .45347 .64907 .45005 .64187 Mtetra
.699 .551 .683 r
.45005 .64187 .45347 .64907 .45629 .64124 .45287 .63405 Mtetra
.705 .554 .679 r
.45287 .63405 .45629 .64124 .45911 .63257 .45569 .62538 Mtetra
.71 .556 .677 r
.45569 .62538 .45911 .63257 .46193 .62327 .45851 .61609 Mtetra
.713 .557 .676 r
.45851 .61609 .46193 .62327 .46475 .61357 .46133 .6064 Mtetra
.714 .557 .675 r
.46133 .6064 .46475 .61357 .46757 .60371 .46415 .59655 Mtetra
.713 .557 .675 r
.46415 .59655 .46757 .60371 .47038 .59395 .46696 .5868 Mtetra
.711 .556 .676 r
.46696 .5868 .47038 .59395 .47318 .58453 .46977 .57739 Mtetra
.707 .554 .678 r
.46977 .57739 .47318 .58453 .47599 .57569 .47257 .56856 Mtetra
.701 .552 .682 r
.47257 .56856 .47599 .57569 .47878 .56765 .47537 .56052 Mtetra
.692 .548 .686 r
.47537 .56052 .47878 .56765 .48157 .5606 .47816 .55347 Mtetra
.68 .543 .691 r
.47816 .55347 .48157 .5606 .48436 .5547 .48094 .54758 Mtetra
.663 .535 .699 r
.48094 .54758 .48436 .5547 .48715 .55008 .48373 .54295 Mtetra
.639 .524 .708 r
.48373 .54295 .48715 .55008 .48993 .54681 .48651 .53968 Mtetra
.604 .508 .719 r
.48651 .53968 .48993 .54681 .49272 .54492 .4893 .53779 Mtetra
.553 .484 .732 r
.4893 .53779 .49272 .54492 .49551 .54441 .49208 .53727 Mtetra
.478 .446 .744 r
.49208 .53727 .49551 .54441 .49831 .54519 .49487 .53805 Mtetra
.367 .387 .749 r
.49487 .53805 .49831 .54519 .50111 .54716 .49767 .54001 Mtetra
.214 .301 .737 r
.49767 .54001 .50111 .54716 .50393 .55014 .50048 .54298 Mtetra
.035 .193 .698 r
.50048 .54298 .50393 .55014 .50675 .55392 .5033 .54674 Mtetra
0 .094 .644 r
.5033 .54674 .50675 .55392 .50959 .55825 .50612 .55106 Mtetra
0 .04 .607 r
.50612 .55106 .50959 .55825 .51243 .56285 .50896 .55564 Mtetra
0 .049 .614 r
.50896 .55564 .51243 .56285 .51529 .56742 .51181 .5602 Mtetra
0 .121 .66 r
.51181 .5602 .51529 .56742 .51815 .57166 .51467 .56443 Mtetra
.091 .228 .713 r
.51467 .56443 .51815 .57166 .52102 .57528 .51753 .56803 Mtetra
.269 .333 .744 r
.51753 .56803 .52102 .57528 .5239 .57801 .5204 .57074 Mtetra
.411 .411 .749 r
.5204 .57074 .5239 .57801 .52677 .57961 .52327 .57234 Mtetra
.51 .462 .739 r
.52327 .57234 .52677 .57961 .52965 .57992 .52614 .57264 Mtetra
.576 .495 .726 r
.52614 .57264 .52965 .57992 .53253 .57882 .52901 .57153 Mtetra
.62 .515 .714 r
.52901 .57153 .53253 .57882 .5354 .57628 .53188 .569 Mtetra
.649 .529 .704 r
.53188 .569 .5354 .57628 .53826 .57237 .53474 .56508 Mtetra
.668 .537 .696 r
.53474 .56508 .53826 .57237 .54111 .5672 .53759 .55992 Mtetra
.681 .543 .69 r
.53759 .55992 .54111 .5672 .54396 .56101 .54044 .55372 Mtetra
.689 .546 .686 r
.54044 .55372 .54396 .56101 .5468 .55407 .54328 .54679 Mtetra
.693 .548 .685 r
.54328 .54679 .5468 .55407 .54963 .54672 .54611 .53945 Mtetra
.694 .548 .684 r
.54611 .53945 .54963 .54672 .55247 .53934 .54894 .53207 Mtetra
.69 .547 .686 r
.54894 .53207 .55247 .53934 .5553 .53231 .55178 .52504 Mtetra
.683 .544 .689 r
.55178 .52504 .5553 .53231 .55814 .52598 .55462 .51872 Mtetra
.67 .538 .695 r
.55462 .51872 .55814 .52598 .56099 .52069 .55747 .51343 Mtetra
.651 .53 .703 r
.55747 .51343 .56099 .52069 .56386 .51665 .56034 .50939 Mtetra
.622 .516 .713 r
.56034 .50939 .56386 .51665 .56675 .51403 .56322 .50676 Mtetra
.58 .497 .726 r
.56322 .50676 .56675 .51403 .56966 .51282 .56612 .50555 Mtetra
.522 .469 .738 r
.56612 .50555 .56966 .51282 .57259 .51292 .56905 .50565 Mtetra
.453 .434 .747 r
.56905 .50565 .57259 .51292 .57554 .51408 .572 .50679 Mtetra
.392 .401 .75 r
.572 .50679 .57554 .51408 .57851 .51592 .57496 .50862 Mtetra
.37 .389 .75 r
.57496 .50862 .57851 .51592 .58149 .51796 .57793 .51066 Mtetra
.402 .407 .75 r
.57793 .51066 .58149 .51796 .58447 .51971 .58091 .5124 Mtetra
.47 .442 .745 r
.58091 .5124 .58447 .51971 .58745 .52066 .58388 .51333 Mtetra
.541 .478 .734 r
.58388 .51333 .58745 .52066 .59042 .52039 .58684 .51306 Mtetra
.596 .504 .721 r
.58684 .51306 .59042 .52039 .59336 .51867 .58979 .51133 Mtetra
.633 .521 .709 r
.58979 .51133 .59336 .51867 .59629 .51551 .59271 .50817 Mtetra
.655 .531 .701 r
.59271 .50817 .59629 .51551 .59919 .51118 .59561 .50384 Mtetra
.664 .535 .697 r
.59561 .50384 .59919 .51118 .60209 .50626 .59851 .49892 Mtetra
.661 .534 .698 r
.59851 .49892 .60209 .50626 .60499 .5015 .60141 .49417 Mtetra
.645 .527 .705 r
.60141 .49417 .60499 .5015 .60792 .49769 .60433 .49036 Mtetra
.613 .512 .716 r
.60433 .49036 .60792 .49769 .61087 .49537 .60728 .48803 Mtetra
.567 .491 .729 r
.60728 .48803 .61087 .49537 .61386 .49448 .61026 .48713 Mtetra
.547 .481 .733 r
.61026 .48713 .61386 .49448 .61686 .49407 .61326 .48671 Mtetra
.593 .503 .722 r
.61326 .48671 .61686 .49407 .61984 .49242 .61623 .48506 Mtetra
.627 .519 .711 r
.61623 .48506 .61984 .49242 .6228 .48951 .61919 .48214 Mtetra
.593 .503 .722 r
.61919 .48214 .6228 .48951 .62579 .48785 .62217 .48048 Mtetra
.547 .481 .733 r
.62217 .48048 .62579 .48785 .62881 .48743 .62519 .48005 Mtetra
.567 .491 .729 r
.62519 .48005 .62881 .48743 .63183 .48653 .62821 .47915 Mtetra
.612 .512 .716 r
.62821 .47915 .63183 .48653 .63481 .48418 .63119 .4768 Mtetra
.645 .527 .705 r
.63119 .4768 .63481 .48418 .63777 .48034 .63414 .47295 Mtetra
.661 .534 .698 r
.63414 .47295 .63777 .48034 .6407 .47554 .63707 .46815 Mtetra
.664 .535 .697 r
.63707 .46815 .6407 .47554 .64363 .47057 .64 .46319 Mtetra
.654 .531 .701 r
.64 .46319 .64363 .47057 .64657 .4662 .64294 .45881 Mtetra
.633 .521 .709 r
.64294 .45881 .64657 .4662 .64955 .46298 .64591 .45559 Mtetra
.596 .505 .721 r
.64591 .45559 .64955 .46298 .65257 .4612 .64893 .45381 Mtetra
.543 .479 .734 r
.64893 .45381 .65257 .4612 .65564 .46087 .65199 .45347 Mtetra
.476 .446 .745 r
.65199 .45347 .65564 .46087 .65874 .46176 .65509 .45435 Mtetra
.414 .414 .75 r
.65509 .45435 .65874 .46176 .66188 .46346 .65822 .45604 Mtetra
.385 .398 .751 r
.65822 .45604 .66188 .46346 .66504 .46548 .66137 .45805 Mtetra
.405 .409 .751 r
.66137 .45805 .66504 .46548 .6682 .46729 .66453 .45985 Mtetra
.46 .438 .747 r
.66453 .45985 .6682 .46729 .67134 .46842 .66766 .46097 Mtetra
.525 .47 .738 r
.66766 .46097 .67134 .46842 .67446 .46847 .67078 .46102 Mtetra
.58 .497 .726 r
.67078 .46102 .67446 .46847 .67754 .4672 .67386 .45973 Mtetra
.621 .516 .713 r
.67386 .45973 .67754 .4672 .68059 .46446 .6769 .45699 Mtetra
.65 .529 .703 r
.6769 .45699 .68059 .46446 .68358 .46028 .67989 .45282 Mtetra
.669 .537 .695 r
.67989 .45282 .68358 .46028 .68654 .45481 .68285 .44734 Mtetra
.682 .543 .689 r
.68285 .44734 .68654 .45481 .68946 .44829 .68577 .44083 Mtetra
.69 .546 .685 r
.68577 .44083 .68946 .44829 .69236 .44105 .68866 .43359 Mtetra
.693 .547 .684 r
.68866 .43359 .69236 .44105 .69524 .43346 .69154 .42601 Mtetra
.69154 .42601 .69524 .43346 .69812 .42592 .69443 .41848 Mtetra
.689 .545 .686 r
.69443 .41848 .69812 .42592 .70102 .4188 .69732 .41136 Mtetra
.681 .542 .69 r
.69732 .41136 .70102 .4188 .70394 .41242 .70024 .40499 Mtetra
.668 .537 .695 r
.70024 .40499 .70394 .41242 .7069 .40709 .7032 .39965 Mtetra
.648 .528 .703 r
.7032 .39965 .7069 .40709 .70991 .40299 .70621 .39556 Mtetra
.62 .516 .714 r
.70621 .39556 .70991 .40299 .71297 .40027 .70927 .39284 Mtetra
.579 .497 .726 r
.70927 .39284 .71297 .40027 .71609 .39899 .71238 .39155 Mtetra
.521 .469 .739 r
.71238 .39155 .71609 .39899 .71928 .39911 .71556 .39166 Mtetra
.44 .428 .749 r
.71556 .39166 .71928 .39911 .72252 .40054 .7188 .39308 Mtetra
.333 .371 .752 r
.7188 .39308 .72252 .40054 .72582 .40311 .72209 .39563 Mtetra
.209 .302 .741 r
.72209 .39563 .72582 .40311 .72917 .4066 .72543 .39911 Mtetra
.092 .233 .718 r
.72543 .39911 .72917 .4066 .73255 .41075 .7288 .40325 Mtetra
.017 .188 .698 r
.7288 .40325 .73255 .41075 .73596 .41528 .73221 .40775 Mtetra
.007 .182 .695 r
.73221 .40775 .73596 .41528 .73939 .41986 .73562 .41232 Mtetra
.064 .216 .711 r
.73562 .41232 .73939 .41986 .74282 .42419 .73904 .41664 Mtetra
.169 .279 .734 r
.73904 .41664 .74282 .42419 .74623 .42799 .74245 .42042 Mtetra
.291 .348 .749 r
.74245 .42042 .74623 .42799 .74962 .43097 .74583 .42339 Mtetra
.402 .408 .751 r
.74583 .42339 .74962 .43097 .75298 .43292 .74918 .42532 Mtetra
.49 .454 .744 r
.74918 .42532 .75298 .43292 .75628 .43362 .75248 .42602 Mtetra
.556 .485 .732 r
.75248 .42602 .75628 .43362 .75953 .43297 .75573 .42536 Mtetra
.602 .507 .719 r
.75573 .42536 .75953 .43297 .76272 .43086 .75891 .42325 Mtetra
.636 .522 .708 r
.75891 .42325 .76272 .43086 .76585 .42728 .76203 .41967 Mtetra
.66 .533 .698 r
.76203 .41967 .76585 .42728 .76891 .42228 .76509 .41466 Mtetra
.678 .541 .69 r
.76509 .41466 .76891 .42228 .7719 .41592 .76808 .40831 Mtetra
.691 .546 .684 r
.76808 .40831 .7719 .41592 .77483 .40836 .77102 .40076 Mtetra
.7 .55 .679 r
.77102 .40076 .77483 .40836 .77771 .39978 .7739 .39218 Mtetra
.707 .552 .676 r
.7739 .39218 .77771 .39978 .78055 .39038 .77674 .38279 Mtetra
.711 .554 .674 r
.77674 .38279 .78055 .39038 .78336 .3804 .77954 .37282 Mtetra
.714 .555 .672 r
.77954 .37282 .78336 .3804 .78614 .37009 .78233 .36252 Mtetra
.78233 .36252 .78614 .37009 .78891 .35972 .7851 .35216 Mtetra
.713 .555 .673 r
.7851 .35216 .78891 .35972 .79169 .34953 .78788 .34198 Mtetra
.71 .554 .674 r
.78788 .34198 .79169 .34953 .79449 .33978 .79068 .33224 Mtetra
.705 .552 .677 r
.79068 .33224 .79449 .33978 .79732 .33069 .79351 .32316 Mtetra
.698 .549 .681 r
.79351 .32316 .79732 .33069 .80019 .32246 .79638 .31494 Mtetra
.688 .545 .686 r
.79638 .31494 .80019 .32246 .80312 .31528 .79931 .30776 Mtetra
.674 .539 .692 r
.79931 .30776 .80312 .31528 .80611 .30929 .8023 .30177 Mtetra
.656 .531 .7 r
.8023 .30177 .80611 .30929 .80918 .30459 .80537 .29707 Mtetra
.631 .521 .71 r
.80537 .29707 .80918 .30459 .81232 .30127 .80851 .29375 Mtetra
.597 .505 .721 r
.80851 .29375 .81232 .30127 .81555 .29936 .81174 .29184 Mtetra
.549 .483 .734 r
.81174 .29184 .81555 .29936 .81887 .29887 .81505 .29134 Mtetra
.48 .45 .746 r
.81505 .29134 .81887 .29887 .82228 .29977 .81845 .29222 Mtetra
.383 .4 .754 r
.81845 .29222 .82228 .29977 .82577 .30197 .82193 .29442 Mtetra
.249 .326 .748 r
.82193 .29442 .82577 .30197 .82935 .3054 .8255 .29783 Mtetra
.074 .225 .717 r
.8255 .29783 .82935 .3054 .833 .30991 .82915 .30232 Mtetra
0 .104 .652 r
.82915 .30232 .833 .30991 .83673 .31535 .83286 .30774 Mtetra
0 0 .566 r
.83286 .30774 .83673 .31535 .84051 .32155 .83664 .31392 Mtetra
0 0 .483 r
.83664 .31392 .84051 .32155 .84435 .3283 .84046 .32066 Mtetra
0 0 .428 r
.84046 .32066 .84435 .3283 .84822 .33541 .84432 .32774 Mtetra
0 0 .41 r
.84432 .32774 .84822 .33541 .85212 .34265 .84821 .33496 Mtetra
0 0 .432 r
.84821 .33496 .85212 .34265 .85602 .3498 .85211 .34209 Mtetra
.93 .547 .215 r
.40372 .60461 .40707 .61077 .40963 .61778 .40628 .61161 Mtetra
.931 .552 .231 r
.40628 .61161 .40963 .61778 .4122 .62495 .40884 .61876 Mtetra
.93 .548 .219 r
.40884 .61876 .4122 .62495 .41478 .63205 .41141 .62584 Mtetra
.923 .532 .174 r
.41141 .62584 .41478 .63205 .41738 .63887 .414 .63265 Mtetra
.898 .493 .082 r
.414 .63265 .41738 .63887 .41999 .64521 .41661 .63898 Mtetra
.816 .402 0 r
.41661 .63898 .41999 .64521 .42263 .65086 .41924 .64461 Mtetra
0 0 .372 r
.41924 .64461 .42263 .65086 .42528 .65564 .42188 .64938 Mtetra
0 .092 .648 r
.42188 .64938 .42528 .65564 .42796 .65938 .42455 .65311 Mtetra
.204 .317 .758 r
.42455 .65311 .42796 .65938 .43066 .66193 .42725 .65565 Mtetra
.418 .431 .767 r
.42725 .65565 .43066 .66193 .43338 .66319 .42996 .65691 Mtetra
.533 .487 .751 r
.42996 .65691 .43338 .66319 .43612 .66308 .4327 .65679 Mtetra
.599 .517 .733 r
.4327 .65679 .43612 .66308 .43888 .66155 .43545 .65525 Mtetra
.64 .534 .718 r
.43545 .65525 .43888 .66155 .44165 .65861 .43822 .65231 Mtetra
.667 .545 .707 r
.43822 .65231 .44165 .65861 .44444 .65429 .44101 .64799 Mtetra
.686 .552 .698 r
.44101 .64799 .44444 .65429 .44724 .64867 .44381 .64237 Mtetra
.698 .557 .691 r
.44381 .64237 .44724 .64867 .45005 .64187 .44662 .63557 Mtetra
.708 .561 .686 r
.44662 .63557 .45005 .64187 .45287 .63405 .44944 .62776 Mtetra
.714 .563 .682 r
.44944 .62776 .45287 .63405 .45569 .62538 .45226 .6191 Mtetra
.718 .564 .68 r
.45226 .6191 .45569 .62538 .45851 .61609 .45508 .60981 Mtetra
.721 .565 .678 r
.45508 .60981 .45851 .61609 .46133 .6064 .4579 .60013 Mtetra
.722 .566 .677 r
.4579 .60013 .46133 .6064 .46415 .59655 .46072 .59029 Mtetra
.721 .566 .678 r
.46072 .59029 .46415 .59655 .46696 .5868 .46354 .58054 Mtetra
.719 .565 .679 r
.46354 .58054 .46696 .5868 .46977 .57739 .46635 .57114 Mtetra
.716 .564 .681 r
.46635 .57114 .46977 .57739 .47257 .56856 .46915 .56231 Mtetra
.71 .561 .685 r
.46915 .56231 .47257 .56856 .47537 .56052 .47195 .55428 Mtetra
.701 .558 .689 r
.47195 .55428 .47537 .56052 .47816 .55347 .47474 .54724 Mtetra
.689 .554 .696 r
.47474 .54724 .47816 .55347 .48094 .54758 .47753 .54134 Mtetra
.672 .547 .704 r
.47753 .54134 .48094 .54758 .48373 .54295 .48031 .53672 Mtetra
.648 .538 .716 r
.48031 .53672 .48373 .54295 .48651 .53968 .48309 .53344 Mtetra
.611 .523 .73 r
.48309 .53344 .48651 .53968 .4893 .53779 .48587 .53155 Mtetra
.556 .498 .746 r
.48587 .53155 .4893 .53779 .49208 .53727 .48865 .53103 Mtetra
.468 .457 .763 r
.48865 .53103 .49208 .53727 .49487 .53805 .49144 .5318 Mtetra
.329 .387 .77 r
.49144 .5318 .49487 .53805 .49767 .54001 .49424 .53375 Mtetra
.124 .273 .746 r
.49424 .53375 .49767 .54001 .50048 .54298 .49704 .5367 Mtetra
0 .125 .67 r
.49704 .5367 .50048 .54298 .5033 .54674 .49985 .54046 Mtetra
0 0 .57 r
.49985 .54046 .5033 .54674 .50612 .55106 .50267 .54476 Mtetra
0 0 .508 r
.50267 .54476 .50612 .55106 .50896 .55564 .5055 .54933 Mtetra
0 0 .519 r
.5055 .54933 .50896 .55564 .51181 .5602 .50834 .55388 Mtetra
0 .026 .599 r
.50834 .55388 .51181 .5602 .51467 .56443 .51119 .55809 Mtetra
0 .172 .699 r
.51119 .55809 .51467 .56443 .51753 .56803 .51405 .56169 Mtetra
.2 .316 .759 r
.51405 .56169 .51753 .56803 .5204 .57074 .51691 .56439 Mtetra
.386 .416 .77 r
.51691 .56439 .5204 .57074 .52327 .57234 .51978 .56598 Mtetra
.507 .475 .757 r
.51978 .56598 .52327 .57234 .52614 .57264 .52264 .56627 Mtetra
.581 .509 .739 r
.52264 .56627 .52614 .57264 .52901 .57153 .52551 .56516 Mtetra
.628 .529 .723 r
.52551 .56516 .52901 .57153 .53188 .569 .52837 .56262 Mtetra
.658 .542 .711 r
.52837 .56262 .53188 .569 .53474 .56508 .53123 .5587 Mtetra
.678 .549 .701 r
.53123 .5587 .53474 .56508 .53759 .55992 .53408 .55354 Mtetra
.691 .554 .695 r
.53408 .55354 .53759 .55992 .54044 .55372 .53693 .54735 Mtetra
.699 .557 .69 r
.53693 .54735 .54044 .55372 .54328 .54679 .53977 .54042 Mtetra
.703 .558 .688 r
.53977 .54042 .54328 .54679 .54611 .53945 .5426 .53308 Mtetra
.703 .559 .688 r
.5426 .53308 .54611 .53945 .54894 .53207 .54543 .52571 Mtetra
.7 .557 .69 r
.54543 .52571 .54894 .53207 .55178 .52504 .54827 .51868 Mtetra
.692 .555 .694 r
.54827 .51868 .55178 .52504 .55462 .51872 .55111 .51236 Mtetra
.68 .55 .7 r
.55111 .51236 .55462 .51872 .55747 .51343 .55396 .50707 Mtetra
.66 .542 .71 r
.55396 .50707 .55747 .51343 .56034 .50939 .55682 .50303 Mtetra
.63 .53 .723 r
.55682 .50303 .56034 .50939 .56322 .50676 .5597 .5004 Mtetra
.585 .511 .738 r
.5597 .5004 .56322 .50676 .56612 .50555 .5626 .49919 Mtetra
.52 .482 .755 r
.5626 .49919 .56612 .50555 .56905 .50565 .56553 .49927 Mtetra
.438 .443 .767 r
.56553 .49927 .56905 .50565 .572 .50679 .56847 .50041 Mtetra
.362 .405 .771 r
.56847 .50041 .572 .50679 .57496 .50862 .57142 .50223 Mtetra
.334 .39 .771 r
.57142 .50223 .57496 .50862 .57793 .51066 .57439 .50426 Mtetra
.375 .411 .771 r
.57439 .50426 .57793 .51066 .58091 .5124 .57736 .50599 Mtetra
.459 .453 .765 r
.57736 .50599 .58091 .5124 .58388 .51333 .58033 .50691 Mtetra
.541 .492 .75 r
.58033 .50691 .58388 .51333 .58684 .51306 .58329 .50663 Mtetra
.603 .519 .732 r
.58329 .50663 .58684 .51306 .58979 .51133 .58623 .50491 Mtetra
.642 .535 .718 r
.58623 .50491 .58979 .51133 .59271 .50817 .58915 .50174 Mtetra
.664 .544 .708 r
.58915 .50174 .59271 .50817 .59561 .50384 .59205 .49741 Mtetra
.673 .547 .703 r
.59205 .49741 .59561 .50384 .59851 .49892 .59494 .49249 Mtetra
.671 .547 .705 r
.59494 .49249 .59851 .49892 .60141 .49417 .59784 .48774 Mtetra
.655 .54 .712 r
.59784 .48774 .60141 .49417 .60433 .49036 .60076 .48393 Mtetra
.621 .526 .726 r
.60076 .48393 .60433 .49036 .60728 .48803 .60371 .4816 Mtetra
.571 .505 .742 r
.60371 .4816 .60728 .48803 .61026 .48713 .60668 .4807 Mtetra
.549 .495 .748 r
.60668 .4807 .61026 .48713 .61326 .48671 .60968 .48027 Mtetra
.6 .518 .733 r
.60968 .48027 .61326 .48671 .61623 .48506 .61265 .47861 Mtetra
.635 .532 .72 r
.61265 .47861 .61623 .48506 .61919 .48214 .6156 .47569 Mtetra
.6 .518 .733 r
.6156 .47569 .61919 .48214 .62217 .48048 .61859 .47403 Mtetra
.549 .496 .748 r
.61859 .47403 .62217 .48048 .62519 .48005 .6216 .47359 Mtetra
.571 .505 .742 r
.6216 .47359 .62519 .48005 .62821 .47915 .62461 .47268 Mtetra
.62 .526 .726 r
.62461 .47268 .62821 .47915 .63119 .4768 .62759 .47033 Mtetra
.655 .54 .712 r
.62759 .47033 .63119 .4768 .63414 .47295 .63054 .46648 Mtetra
.671 .546 .705 r
.63054 .46648 .63414 .47295 .63707 .46815 .63347 .46168 Mtetra
.673 .547 .703 r
.63347 .46168 .63707 .46815 .64 .46319 .63639 .45672 Mtetra
.664 .544 .708 r
.63639 .45672 .64 .46319 .64294 .45881 .63933 .45234 Mtetra
.642 .535 .718 r
.63933 .45234 .64294 .45881 .64591 .45559 .6423 .44912 Mtetra
.603 .519 .732 r
.6423 .44912 .64591 .45559 .64893 .45381 .64532 .44733 Mtetra
.544 .493 .75 r
.64532 .44733 .64893 .45381 .65199 .45347 .64837 .44699 Mtetra
.466 .457 .764 r
.64837 .44699 .65199 .45347 .65509 .45435 .65147 .44786 Mtetra
.39 .419 .771 r
.65147 .44786 .65509 .45435 .65822 .45604 .6546 .44954 Mtetra
.353 .4 .772 r
.6546 .44954 .65822 .45604 .66137 .45805 .65774 .45154 Mtetra
.378 .414 .771 r
.65774 .45154 .66137 .45805 .66453 .45985 .66088 .45333 Mtetra
.447 .448 .766 r
.66088 .45333 .66453 .45985 .66766 .46097 .66402 .45444 Mtetra
.523 .484 .754 r
.66402 .45444 .66766 .46097 .67078 .46102 .66713 .45448 Mtetra
.585 .511 .738 r
.66713 .45448 .67078 .46102 .67386 .45973 .6702 .45319 Mtetra
.629 .53 .723 r
.6702 .45319 .67386 .45973 .6769 .45699 .67324 .45045 Mtetra
.659 .542 .71 r
.67324 .45045 .6769 .45699 .67989 .45282 .67623 .44627 Mtetra
.679 .549 .7 r
.67623 .44627 .67989 .45282 .68285 .44734 .67918 .4408 Mtetra
.692 .554 .693 r
.67918 .4408 .68285 .44734 .68577 .44083 .6821 .43429 Mtetra
.699 .557 .689 r
.6821 .43429 .68577 .44083 .68866 .43359 .685 .42705 Mtetra
.703 .558 .687 r
.685 .42705 .68866 .43359 .69154 .42601 .68788 .41948 Mtetra
.702 .558 .688 r
.68788 .41948 .69154 .42601 .69443 .41848 .69076 .41195 Mtetra
.698 .556 .69 r
.69076 .41195 .69443 .41848 .69732 .41136 .69366 .40483 Mtetra
.69 .554 .694 r
.69366 .40483 .69732 .41136 .70024 .40499 .69658 .39846 Mtetra
.677 .549 .701 r
.69658 .39846 .70024 .40499 .7032 .39965 .69954 .39313 Mtetra
.658 .541 .711 r
.69954 .39313 .7032 .39965 .70621 .39556 .70254 .38903 Mtetra
.628 .53 .723 r
.70254 .38903 .70621 .39556 .70927 .39284 .7056 .38631 Mtetra
.585 .511 .739 r
.7056 .38631 .70927 .39284 .71238 .39155 .70871 .38501 Mtetra
.519 .482 .755 r
.70871 .38501 .71238 .39155 .71556 .39166 .71188 .38512 Mtetra
.423 .436 .769 r
.71188 .38512 .71556 .39166 .7188 .39308 .71512 .38653 Mtetra
.287 .367 .771 r
.71512 .38653 .7188 .39308 .72209 .39563 .7184 .38907 Mtetra
.122 .275 .748 r
.7184 .38907 .72209 .39563 .72543 .39911 .72173 .39254 Mtetra
0 .182 .706 r
.72173 .39254 .72543 .39911 .7288 .40325 .7251 .39666 Mtetra
0 .121 .669 r
.7251 .39666 .7288 .40325 .73221 .40775 .72849 .40116 Mtetra
0 .113 .663 r
.72849 .40116 .73221 .40775 .73562 .41232 .7319 .40571 Mtetra
0 .159 .693 r
.7319 .40571 .73562 .41232 .73904 .41664 .73532 .41002 Mtetra
.069 .244 .736 r
.73532 .41002 .73904 .41664 .74245 .42042 .73872 .41378 Mtetra
.232 .337 .766 r
.73872 .41378 .74245 .42042 .74583 .42339 .74209 .41674 Mtetra
.376 .413 .772 r
.74209 .41674 .74583 .42339 .74918 .42532 .74543 .41866 Mtetra
.483 .465 .762 r
.74543 .41866 .74918 .42532 .75248 .42602 .74873 .41935 Mtetra
.558 .5 .746 r
.74873 .41935 .75248 .42602 .75573 .42536 .75197 .41868 Mtetra
.61 .522 .73 r
.75197 .41868 .75573 .42536 .75891 .42325 .75515 .41657 Mtetra
.645 .536 .716 r
.75515 .41657 .75891 .42325 .76203 .41967 .75827 .41299 Mtetra
.67 .546 .704 r
.75827 .41299 .76203 .41967 .76509 .41466 .76132 .40798 Mtetra
.688 .552 .695 r
.76132 .40798 .76509 .41466 .76808 .40831 .76432 .40163 Mtetra
.701 .557 .688 r
.76432 .40163 .76808 .40831 .77102 .40076 .76725 .39408 Mtetra
.71 .56 .683 r
.76725 .39408 .77102 .40076 .7739 .39218 .77013 .38551 Mtetra
.716 .562 .679 r
.77013 .38551 .7739 .39218 .77674 .38279 .77297 .37613 Mtetra
.72 .564 .676 r
.77297 .37613 .77674 .38279 .77954 .37282 .77578 .36616 Mtetra
.723 .564 .675 r
.77578 .36616 .77954 .37282 .78233 .36252 .77856 .35588 Mtetra
.723 .565 .674 r
.77856 .35588 .78233 .36252 .7851 .35216 .78134 .34552 Mtetra
.722 .564 .675 r
.78134 .34552 .7851 .35216 .78788 .34198 .78412 .33535 Mtetra
.719 .563 .677 r
.78412 .33535 .78788 .34198 .79068 .33224 .78693 .32562 Mtetra
.715 .562 .68 r
.78693 .32562 .79068 .33224 .79351 .32316 .78976 .31654 Mtetra
.708 .559 .684 r
.78976 .31654 .79351 .32316 .79638 .31494 .79263 .30833 Mtetra
.698 .556 .69 r
.79263 .30833 .79638 .31494 .79931 .30776 .79556 .30115 Mtetra
.684 .551 .697 r
.79556 .30115 .79931 .30776 .8023 .30177 .79855 .29516 Mtetra
.666 .544 .707 r
.79855 .29516 .8023 .30177 .80537 .29707 .80161 .29046 Mtetra
.64 .534 .718 r
.80161 .29046 .80537 .29707 .80851 .29375 .80475 .28714 Mtetra
.603 .52 .733 r
.80475 .28714 .80851 .29375 .81174 .29184 .80797 .28522 Mtetra
.55 .497 .749 r
.80797 .28522 .81174 .29184 .81505 .29134 .81128 .28472 Mtetra
.471 .461 .765 r
.81128 .28472 .81505 .29134 .81845 .29222 .81467 .28559 Mtetra
.352 .402 .774 r
.81467 .28559 .81845 .29222 .82193 .29442 .81815 .28778 Mtetra
.178 .308 .76 r
.81815 .28778 .82193 .29442 .8255 .29783 .82171 .29117 Mtetra
0 .173 .701 r
.82171 .29117 .8255 .29783 .82915 .30232 .82535 .29565 Mtetra
0 .015 .589 r
.82535 .29565 .82915 .30232 .83286 .30774 .82905 .30106 Mtetra
0 0 .455 r
.82905 .30106 .83286 .30774 .83664 .31392 .83282 .30722 Mtetra
.62 .22 0 r
.83282 .30722 .83664 .31392 .84046 .32066 .83663 .31394 Mtetra
.682 .272 0 r
.83663 .31394 .84046 .32066 .84432 .32774 .84048 .32101 Mtetra
.7 .286 0 r
.84048 .32101 .84432 .32774 .84821 .33496 .84436 .32821 Mtetra
.678 .268 0 r
.84436 .32821 .84821 .33496 .85211 .34209 .84825 .33532 Mtetra
.917 .552 .322 r
.40036 .59955 .40372 .60461 .40628 .61161 .40291 .60654 Mtetra
.916 .554 .332 r
.40291 .60654 .40628 .61161 .40884 .61876 .40546 .61367 Mtetra
.916 .552 .324 r
.40546 .61367 .40884 .61876 .41141 .62584 .40803 .62075 Mtetra
.917 .544 .296 r
.40803 .62075 .41141 .62584 .414 .63265 .41061 .62755 Mtetra
.916 .524 .237 r
.41061 .62755 .414 .63265 .41661 .63898 .41321 .63386 Mtetra
.897 .477 .121 r
.41321 .63386 .41661 .63898 .41924 .64461 .41583 .63949 Mtetra
.803 .357 0 r
.41583 .63949 .41924 .64461 .42188 .64938 .41847 .64424 Mtetra
0 0 .498 r
.41847 .64424 .42188 .64938 .42455 .65311 .42114 .64796 Mtetra
.054 .273 .766 r
.42114 .64796 .42455 .65311 .42725 .65565 .42382 .6505 Mtetra
.379 .444 .802 r
.42382 .6505 .42725 .65565 .42996 .65691 .42653 .65175 Mtetra
.532 .511 .778 r
.42653 .65175 .42996 .65691 .4327 .65679 .42927 .65162 Mtetra
.61 .54 .751 r
.42927 .65162 .4327 .65679 .43545 .65525 .43202 .65009 Mtetra
.654 .555 .731 r
.43202 .65009 .43545 .65525 .43822 .65231 .43479 .64714 Mtetra
.681 .564 .716 r
.43479 .64714 .43822 .65231 .44101 .64799 .43758 .64282 Mtetra
.699 .569 .705 r
.43758 .64282 .44101 .64799 .44381 .64237 .44038 .6372 Mtetra
.711 .572 .696 r
.44038 .6372 .44381 .64237 .44662 .63557 .44319 .63041 Mtetra
.72 .574 .69 r
.44319 .63041 .44662 .63557 .44944 .62776 .446 .62259 Mtetra
.726 .576 .686 r
.446 .62259 .44944 .62776 .45226 .6191 .44883 .61393 Mtetra
.73 .577 .683 r
.44883 .61393 .45226 .6191 .45508 .60981 .45165 .60465 Mtetra
.732 .577 .681 r
.45165 .60465 .45508 .60981 .4579 .60013 .45448 .59497 Mtetra
.733 .578 .681 r
.45448 .59497 .4579 .60013 .46072 .59029 .4573 .58514 Mtetra
.733 .577 .681 r
.4573 .58514 .46072 .59029 .46354 .58054 .46011 .5754 Mtetra
.731 .577 .682 r
.46011 .5754 .46354 .58054 .46635 .57114 .46292 .566 Mtetra
.727 .576 .685 r
.46292 .566 .46635 .57114 .46915 .56231 .46573 .55717 Mtetra
.722 .575 .689 r
.46573 .55717 .46915 .56231 .47195 .55428 .46853 .54914 Mtetra
.714 .573 .695 r
.46853 .54914 .47195 .55428 .47474 .54724 .47132 .5421 Mtetra
.703 .57 .702 r
.47132 .5421 .47474 .54724 .47753 .54134 .47411 .53621 Mtetra
.686 .565 .713 r
.47411 .53621 .47753 .54134 .48031 .53672 .47689 .53158 Mtetra
.661 .558 .727 r
.47689 .53158 .48031 .53672 .48309 .53344 .47967 .52831 Mtetra
.623 .545 .746 r
.47967 .52831 .48309 .53344 .48587 .53155 .48245 .52641 Mtetra
.559 .522 .77 r
.48245 .52641 .48587 .53155 .48865 .53103 .48523 .52588 Mtetra
.449 .476 .795 r
.48523 .52588 .48865 .53103 .49144 .5318 .48801 .52665 Mtetra
.251 .382 .801 r
.48801 .52665 .49144 .5318 .49424 .53375 .4908 .52859 Mtetra
0 .204 .729 r
.4908 .52859 .49424 .53375 .49704 .5367 .49359 .53154 Mtetra
0 0 .548 r
.49359 .53154 .49704 .5367 .49985 .54046 .4964 .53529 Mtetra
.613 .181 0 r
.4964 .53529 .49985 .54046 .50267 .54476 .49921 .53958 Mtetra
.692 .248 0 r
.49921 .53958 .50267 .54476 .5055 .54933 .50204 .54414 Mtetra
.68 .237 0 r
.50204 .54414 .5055 .54933 .50834 .55388 .50487 .54868 Mtetra
0 0 .413 r
.50487 .54868 .50834 .55388 .51119 .55809 .50771 .55288 Mtetra
0 .048 .612 r
.50771 .55288 .51119 .55809 .51405 .56169 .51057 .55647 Mtetra
.052 .273 .766 r
.51057 .55647 .51405 .56169 .51691 .56439 .51342 .55916 Mtetra
.335 .423 .804 r
.51342 .55916 .51691 .56439 .51978 .56598 .51629 .56074 Mtetra
.499 .498 .786 r
.51629 .56074 .51978 .56598 .52264 .56627 .51915 .56103 Mtetra
.589 .533 .76 r
.51915 .56103 .52264 .56627 .52551 .56516 .52201 .55992 Mtetra
.641 .551 .738 r
.52201 .55992 .52551 .56516 .52837 .56262 .52487 .55737 Mtetra
.672 .561 .721 r
.52487 .55737 .52837 .56262 .53123 .5587 .52773 .55345 Mtetra
.692 .567 .709 r
.52773 .55345 .53123 .5587 .53408 .55354 .53058 .54829 Mtetra
.704 .57 .701 r
.53058 .54829 .53408 .55354 .53693 .54735 .53343 .5421 Mtetra
.712 .572 .696 r
.53343 .5421 .53693 .54735 .53977 .54042 .53627 .53517 Mtetra
.716 .573 .693 r
.53627 .53517 .53977 .54042 .5426 .53308 .5391 .52783 Mtetra
.5391 .52783 .5426 .53308 .54543 .52571 .54194 .52046 Mtetra
.713 .572 .695 r
.54194 .52046 .54543 .52571 .54827 .51868 .54477 .51344 Mtetra
.706 .571 .7 r
.54477 .51344 .54827 .51868 .55111 .51236 .54761 .50712 Mtetra
.694 .567 .708 r
.54761 .50712 .55111 .51236 .55396 .50707 .55046 .50183 Mtetra
.674 .562 .72 r
.55046 .50183 .55396 .50707 .55682 .50303 .55332 .49779 Mtetra
.643 .552 .737 r
.55332 .49779 .55682 .50303 .5597 .5004 .5562 .49516 Mtetra
.593 .535 .758 r
.5562 .49516 .5597 .5004 .5626 .49919 .5591 .49394 Mtetra
.516 .505 .782 r
.5591 .49394 .5626 .49919 .56553 .49927 .56202 .49402 Mtetra
.409 .458 .8 r
.56202 .49402 .56553 .49927 .56847 .50041 .56495 .49515 Mtetra
.301 .407 .804 r
.56495 .49515 .56847 .50041 .57142 .50223 .56791 .49696 Mtetra
.259 .386 .802 r
.56791 .49696 .57142 .50223 .57439 .50426 .57087 .49899 Mtetra
.32 .416 .804 r
.57087 .49899 .57439 .50426 .57736 .50599 .57383 .50071 Mtetra
.437 .471 .797 r
.57383 .50071 .57736 .50599 .58033 .50691 .5768 .50163 Mtetra
.542 .515 .775 r
.5768 .50163 .58033 .50691 .58329 .50663 .57975 .50134 Mtetra
.613 .542 .75 r
.57975 .50134 .58329 .50663 .58623 .50491 .58269 .49961 Mtetra
.655 .556 .73 r
.58269 .49961 .58623 .50491 .58915 .50174 .5856 .49644 Mtetra
.678 .563 .717 r
.5856 .49644 .58915 .50174 .59205 .49741 .58851 .49212 Mtetra
.687 .565 .712 r
.58851 .49212 .59205 .49741 .59494 .49249 .5914 .4872 Mtetra
.685 .565 .713 r
.5914 .4872 .59494 .49249 .59784 .48774 .5943 .48244 Mtetra
.669 .56 .723 r
.5943 .48244 .59784 .48774 .60076 .48393 .59721 .47862 Mtetra
.633 .548 .741 r
.59721 .47862 .60076 .48393 .60371 .4816 .60016 .47629 Mtetra
.577 .529 .764 r
.60016 .47629 .60371 .4816 .60668 .4807 .60313 .47539 Mtetra
.551 .519 .773 r
.60313 .47539 .60668 .4807 .60968 .48027 .60612 .47495 Mtetra
.61 .54 .752 r
.60612 .47495 .60968 .48027 .61265 .47861 .60909 .47329 Mtetra
.648 .553 .734 r
.60909 .47329 .61265 .47861 .6156 .47569 .61204 .47037 Mtetra
.61 .54 .752 r
.61204 .47037 .6156 .47569 .61859 .47403 .61502 .46871 Mtetra
.552 .519 .773 r
.61502 .46871 .61859 .47403 .6216 .47359 .61803 .46826 Mtetra
.577 .529 .764 r
.61803 .46826 .6216 .47359 .62461 .47268 .62104 .46734 Mtetra
.633 .548 .741 r
.62104 .46734 .62461 .47268 .62759 .47033 .62401 .46499 Mtetra
.668 .56 .723 r
.62401 .46499 .62759 .47033 .63054 .46648 .62696 .46114 Mtetra
.685 .565 .713 r
.62696 .46114 .63054 .46648 .63347 .46168 .62989 .45634 Mtetra
.687 .565 .712 r
.62989 .45634 .63347 .46168 .63639 .45672 .63281 .45138 Mtetra
.678 .563 .718 r
.63281 .45138 .63639 .45672 .63933 .45234 .63575 .447 Mtetra
.655 .556 .73 r
.63575 .447 .63933 .45234 .6423 .44912 .63872 .44378 Mtetra
.614 .542 .75 r
.63872 .44378 .6423 .44912 .64532 .44733 .64173 .44199 Mtetra
.546 .517 .774 r
.64173 .44199 .64532 .44733 .64837 .44699 .64479 .44164 Mtetra
.447 .476 .796 r
.64479 .44164 .64837 .44699 .65147 .44786 .64788 .4425 Mtetra
.342 .427 .804 r
.64788 .4425 .65147 .44786 .6546 .44954 .651 .44418 Mtetra
.289 .401 .804 r
.651 .44418 .6546 .44954 .65774 .45154 .65414 .44616 Mtetra
.326 .419 .804 r
.65414 .44616 .65774 .45154 .66088 .45333 .65728 .44795 Mtetra
.422 .464 .799 r
.65728 .44795 .66088 .45333 .66402 .45444 .66041 .44905 Mtetra
.52 .506 .781 r
.66041 .44905 .66402 .45444 .66713 .45448 .66351 .44909 Mtetra
.593 .535 .758 r
.66351 .44909 .66713 .45448 .6702 .45319 .66658 .4478 Mtetra
.642 .551 .737 r
.66658 .4478 .6702 .45319 .67324 .45045 .66962 .44505 Mtetra
.673 .561 .72 r
.66962 .44505 .67324 .45045 .67623 .44627 .67261 .44087 Mtetra
.693 .567 .708 r
.67261 .44087 .67623 .44627 .67918 .4408 .67556 .4354 Mtetra
.706 .57 .7 r
.67556 .4354 .67918 .4408 .6821 .43429 .67848 .42888 Mtetra
.713 .572 .695 r
.67848 .42888 .6821 .43429 .685 .42705 .68138 .42166 Mtetra
.716 .573 .693 r
.68138 .42166 .685 .42705 .68788 .41948 .68426 .41408 Mtetra
.68426 .41408 .68788 .41948 .69076 .41195 .68714 .40655 Mtetra
.712 .572 .695 r
.68714 .40655 .69076 .41195 .69366 .40483 .69004 .39944 Mtetra
.704 .57 .701 r
.69004 .39944 .69366 .40483 .69658 .39846 .69296 .39307 Mtetra
.692 .566 .709 r
.69296 .39307 .69658 .39846 .69954 .39313 .69592 .38773 Mtetra
.672 .561 .721 r
.69592 .38773 .69954 .39313 .70254 .38903 .69892 .38364 Mtetra
.641 .551 .737 r
.69892 .38364 .70254 .38903 .7056 .38631 .70197 .38091 Mtetra
.593 .535 .758 r
.70197 .38091 .7056 .38631 .70871 .38501 .70508 .37961 Mtetra
.515 .505 .783 r
.70508 .37961 .70871 .38501 .71188 .38512 .70825 .37971 Mtetra
.389 .45 .802 r
.70825 .37971 .71188 .38512 .71512 .38653 .71148 .38111 Mtetra
.193 .352 .796 r
.71148 .38111 .71512 .38653 .7184 .38907 .71476 .38365 Mtetra
0 .212 .734 r
.71476 .38365 .7184 .38907 .72173 .39254 .71808 .38711 Mtetra
0 .071 .632 r
.71808 .38711 .72173 .39254 .7251 .39666 .72144 .39122 Mtetra
0 0 .553 r
.72144 .39122 .7251 .39666 .72849 .40116 .72483 .3957 Mtetra
0 0 .542 r
.72483 .3957 .72849 .40116 .7319 .40571 .72823 .40025 Mtetra
0 .039 .603 r
.72823 .40025 .7319 .40571 .73532 .41002 .73164 .40454 Mtetra
0 .164 .703 r
.73164 .40454 .73532 .41002 .73872 .41378 .73503 .4083 Mtetra
.11 .307 .781 r
.73503 .4083 .73872 .41378 .74209 .41674 .7384 .41125 Mtetra
.323 .418 .805 r
.7384 .41125 .74209 .41674 .74543 .41866 .74174 .41316 Mtetra
.469 .485 .792 r
.74174 .41316 .74543 .41866 .74873 .41935 .74503 .41385 Mtetra
.562 .523 .769 r
.74503 .41385 .74873 .41935 .75197 .41868 .74826 .41317 Mtetra
.621 .544 .747 r
.74826 .41317 .75197 .41868 .75515 .41657 .75144 .41105 Mtetra
.659 .557 .728 r
.75144 .41105 .75515 .41657 .75827 .41299 .75456 .40747 Mtetra
.685 .564 .713 r
.75456 .40747 .75827 .41299 .76132 .40798 .75761 .40246 Mtetra
.702 .569 .702 r
.75761 .40246 .76132 .40798 .76432 .40163 .7606 .39612 Mtetra
.715 .572 .693 r
.7606 .39612 .76432 .40163 .76725 .39408 .76354 .38857 Mtetra
.723 .575 .687 r
.76354 .38857 .76725 .39408 .77013 .38551 .76642 .38 Mtetra
.729 .576 .683 r
.76642 .38 .77013 .38551 .77297 .37613 .76926 .37062 Mtetra
.733 .577 .68 r
.76926 .37062 .77297 .37613 .77578 .36616 .77207 .36066 Mtetra
.735 .577 .678 r
.77207 .36066 .77578 .36616 .77856 .35588 .77486 .35038 Mtetra
.736 .578 .678 r
.77486 .35038 .77856 .35588 .78134 .34552 .77764 .34003 Mtetra
.735 .577 .678 r
.77764 .34003 .78134 .34552 .78412 .33535 .78043 .32987 Mtetra
.732 .577 .68 r
.78043 .32987 .78412 .33535 .78693 .32562 .78323 .32013 Mtetra
.728 .576 .684 r
.78323 .32013 .78693 .32562 .78976 .31654 .78606 .31106 Mtetra
.721 .574 .689 r
.78606 .31106 .78976 .31654 .79263 .30833 .78894 .30285 Mtetra
.712 .572 .696 r
.78894 .30285 .79263 .30833 .79556 .30115 .79186 .29567 Mtetra
.699 .568 .705 r
.79186 .29567 .79556 .30115 .79855 .29516 .79485 .28968 Mtetra
.68 .563 .716 r
.79485 .28968 .79855 .29516 .80161 .29046 .79791 .28499 Mtetra
.653 .555 .731 r
.79791 .28499 .80161 .29046 .80475 .28714 .80105 .28166 Mtetra
.614 .542 .75 r
.80105 .28166 .80475 .28714 .80797 .28522 .80427 .27974 Mtetra
.553 .52 .772 r
.80427 .27974 .80797 .28522 .81128 .28472 .80758 .27923 Mtetra
.454 .479 .795 r
.80758 .27923 .81128 .28472 .81467 .28559 .81097 .2801 Mtetra
.291 .403 .805 r
.81097 .2801 .81467 .28559 .81815 .28778 .81444 .28227 Mtetra
.034 .265 .763 r
.81444 .28227 .81815 .28778 .82171 .29117 .81799 .28566 Mtetra
0 .062 .624 r
.81799 .28566 .82171 .29117 .82535 .29565 .82162 .29013 Mtetra
0 0 .418 r
.82162 .29013 .82535 .29565 .82905 .30106 .82532 .29553 Mtetra
.721 .272 0 r
.82532 .29553 .82905 .30106 .83282 .30722 .82907 .30167 Mtetra
.797 .347 0 r
.82907 .30167 .83282 .30722 .83663 .31394 .83288 .30838 Mtetra
.829 .382 0 r
.83288 .30838 .83663 .31394 .84048 .32101 .83672 .31543 Mtetra
.837 .392 0 r
.83672 .31543 .84048 .32101 .84436 .32821 .84059 .32262 Mtetra
.827 .38 0 r
.84059 .32262 .84436 .32821 .84825 .33532 .84447 .32972 Mtetra
.881 .541 .401 r
.39698 .59575 .40036 .59955 .40291 .60654 .39952 .60273 Mtetra
.88 .543 .407 r
.39952 .60273 .40291 .60654 .40546 .61367 .40206 .60986 Mtetra
.881 .541 .402 r
.40206 .60986 .40546 .61367 .40803 .62075 .40462 .61692 Mtetra
.883 .536 .385 r
.40462 .61692 .40803 .62075 .41061 .62755 .4072 .62371 Mtetra
.887 .524 .351 r
.4072 .62371 .41061 .62755 .41321 .63386 .40979 .63002 Mtetra
.889 .499 .286 r
.40979 .63002 .41321 .63386 .41583 .63949 .41241 .63564 Mtetra
.875 .442 .153 r
.41241 .63564 .41583 .63949 .41847 .64424 .41504 .64039 Mtetra
.767 .277 0 r
.41504 .64039 .41847 .64424 .42114 .64796 .4177 .64411 Mtetra
0 .138 .669 r
.4177 .64411 .42114 .64796 .42382 .6505 .42039 .64664 Mtetra
.29 .46 .856 r
.42039 .64664 .42382 .6505 .42653 .65175 .42309 .64788 Mtetra
.528 .551 .823 r
.42309 .64788 .42653 .65175 .42927 .65162 .42582 .64775 Mtetra
.625 .577 .78 r
.42582 .64775 .42927 .65162 .43202 .65009 .42857 .64621 Mtetra
.673 .586 .749 r
.42857 .64621 .43202 .65009 .43479 .64714 .43134 .64326 Mtetra
.7 .59 .728 r
.43134 .64326 .43479 .64714 .43758 .64282 .43413 .63894 Mtetra
.717 .591 .714 r
.43413 .63894 .43758 .64282 .44038 .6372 .43693 .63332 Mtetra
.729 .592 .703 r
.43693 .63332 .44038 .6372 .44319 .63041 .43974 .62653 Mtetra
.736 .593 .696 r
.43974 .62653 .44319 .63041 .446 .62259 .44256 .61871 Mtetra
.741 .593 .691 r
.44256 .61871 .446 .62259 .44883 .61393 .44538 .61006 Mtetra
.745 .593 .687 r
.44538 .61006 .44883 .61393 .45165 .60465 .44821 .60078 Mtetra
.747 .593 .685 r
.44821 .60078 .45165 .60465 .45448 .59497 .45104 .5911 Mtetra
.748 .593 .684 r
.45104 .5911 .45448 .59497 .4573 .58514 .45386 .58126 Mtetra
.747 .593 .685 r
.45386 .58126 .4573 .58514 .46011 .5754 .45668 .57153 Mtetra
.746 .593 .686 r
.45668 .57153 .46011 .5754 .46292 .566 .45949 .56213 Mtetra
.743 .593 .689 r
.45949 .56213 .46292 .566 .46573 .55717 .4623 .55331 Mtetra
.738 .593 .694 r
.4623 .55331 .46573 .55717 .46853 .54914 .4651 .54528 Mtetra
.731 .592 .701 r
.4651 .54528 .46853 .54914 .47132 .5421 .46789 .53824 Mtetra
.721 .592 .711 r
.46789 .53824 .47132 .5421 .47411 .53621 .47068 .53234 Mtetra
.705 .59 .724 r
.47068 .53234 .47411 .53621 .47689 .53158 .47346 .52771 Mtetra
.681 .587 .744 r
.47346 .52771 .47689 .53158 .47967 .52831 .47624 .52444 Mtetra
.64 .579 .771 r
.47624 .52444 .47967 .52831 .48245 .52641 .47902 .52254 Mtetra
.564 .561 .809 r
.47902 .52254 .48245 .52641 .48523 .52588 .48179 .52201 Mtetra
.407 .508 .849 r
.48179 .52201 .48523 .52588 .48801 .52665 .48457 .52277 Mtetra
.067 .349 .823 r
.48457 .52277 .48801 .52665 .4908 .52859 .48736 .5247 Mtetra
0 .028 .558 r
.48736 .5247 .4908 .52859 .49359 .53154 .49015 .52765 Mtetra
.726 .232 0 r
.49015 .52765 .49359 .53154 .4964 .53529 .49295 .53139 Mtetra
.821 .346 0 r
.49295 .53139 .4964 .53529 .49921 .53958 .49576 .53567 Mtetra
.846 .384 .035 r
.49576 .53567 .49921 .53958 .50204 .54414 .49858 .54023 Mtetra
.843 .378 .023 r
.49858 .54023 .50204 .54414 .50487 .54868 .5014 .54476 Mtetra
.804 .322 0 r
.5014 .54476 .50487 .54868 .50771 .55288 .50424 .54896 Mtetra
.664 .169 0 r
.50424 .54896 .50771 .55288 .51057 .55647 .50709 .55254 Mtetra
0 .143 .674 r
.50709 .55254 .51057 .55647 .51342 .55916 .50994 .55523 Mtetra
.216 .425 .851 r
.50994 .55523 .51342 .55916 .51629 .56074 .5128 .5568 Mtetra
.482 .536 .835 r
.5128 .5568 .51629 .56074 .51915 .56103 .51566 .55708 Mtetra
.601 .571 .792 r
.51566 .55708 .51915 .56103 .52201 .55992 .51852 .55597 Mtetra
.66 .584 .759 r
.51852 .55597 .52201 .55992 .52487 .55737 .52138 .55342 Mtetra
.692 .589 .735 r
.52138 .55342 .52487 .55737 .52773 .55345 .52424 .5495 Mtetra
.711 .591 .72 r
.52424 .5495 .52773 .55345 .53058 .54829 .52709 .54434 Mtetra
.723 .592 .709 r
.52709 .54434 .53058 .54829 .53343 .5421 .52993 .53815 Mtetra
.729 .593 .703 r
.52993 .53815 .53343 .5421 .53627 .53517 .53278 .53122 Mtetra
.733 .593 .7 r
.53278 .53122 .53627 .53517 .5391 .52783 .53561 .52388 Mtetra
.53561 .52388 .5391 .52783 .54194 .52046 .53845 .51651 Mtetra
.73 .593 .702 r
.53845 .51651 .54194 .52046 .54477 .51344 .54128 .50949 Mtetra
.724 .592 .708 r
.54128 .50949 .54477 .51344 .54761 .50712 .54412 .50317 Mtetra
.713 .591 .718 r
.54412 .50317 .54761 .50712 .55046 .50183 .54697 .49787 Mtetra
.694 .589 .734 r
.54697 .49787 .55046 .50183 .55332 .49779 .54983 .49384 Mtetra
.662 .584 .757 r
.54983 .49384 .55332 .49779 .5562 .49516 .55271 .4912 Mtetra
.606 .572 .79 r
.55271 .4912 .5562 .49516 .5591 .49394 .55561 .48998 Mtetra
.506 .543 .829 r
.55561 .48998 .5591 .49394 .56202 .49402 .55852 .49005 Mtetra
.344 .482 .854 r
.55852 .49005 .56202 .49402 .56495 .49515 .56145 .49118 Mtetra
.159 .396 .842 r
.56145 .49118 .56495 .49515 .56791 .49696 .5644 .49299 Mtetra
.085 .358 .827 r
.5644 .49299 .56791 .49696 .57087 .49899 .56736 .495 Mtetra
.192 .413 .847 r
.56736 .495 .57087 .49899 .57383 .50071 .57032 .49672 Mtetra
.388 .5 .851 r
.57032 .49672 .57383 .50071 .5768 .50163 .57328 .49764 Mtetra
.542 .554 .817 r
.57328 .49764 .5768 .50163 .57975 .50134 .57623 .49735 Mtetra
.629 .577 .777 r
.57623 .49735 .57975 .50134 .58269 .49961 .57917 .49561 Mtetra
.675 .586 .748 r
.57917 .49561 .58269 .49961 .5856 .49644 .58208 .49244 Mtetra
.698 .59 .731 r
.58208 .49244 .5856 .49644 .58851 .49212 .58498 .48811 Mtetra
.707 .591 .723 r
.58498 .48811 .58851 .49212 .5914 .4872 .58788 .48319 Mtetra
.705 .59 .725 r
.58788 .48319 .5914 .4872 .5943 .48244 .59077 .47843 Mtetra
.688 .588 .738 r
.59077 .47843 .5943 .48244 .59721 .47862 .59369 .47462 Mtetra
.651 .582 .764 r
.59369 .47462 .59721 .47862 .60016 .47629 .59663 .47228 Mtetra
.586 .567 .799 r
.59663 .47228 .60016 .47629 .60313 .47539 .5996 .47137 Mtetra
.554 .558 .813 r
.5996 .47137 .60313 .47539 .60612 .47495 .60259 .47093 Mtetra
.625 .576 .779 r
.60259 .47093 .60612 .47495 .60909 .47329 .60556 .46927 Mtetra
.668 .585 .753 r
.60556 .46927 .60909 .47329 .61204 .47037 .60851 .46635 Mtetra
.625 .577 .779 r
.60851 .46635 .61204 .47037 .61502 .46871 .61148 .46468 Mtetra
.554 .558 .812 r
.61148 .46468 .61502 .46871 .61803 .46826 .61449 .46423 Mtetra
.587 .567 .799 r
.61449 .46423 .61803 .46826 .62104 .46734 .61749 .46331 Mtetra
.651 .582 .764 r
.61749 .46331 .62104 .46734 .62401 .46499 .62047 .46095 Mtetra
.688 .588 .738 r
.62047 .46095 .62401 .46499 .62696 .46114 .62342 .45711 Mtetra
.705 .59 .725 r
.62342 .45711 .62696 .46114 .62989 .45634 .62634 .4523 Mtetra
.707 .591 .723 r
.62634 .4523 .62989 .45634 .63281 .45138 .62927 .44734 Mtetra
.698 .59 .731 r
.62927 .44734 .63281 .45138 .63575 .447 .63221 .44296 Mtetra
.675 .586 .748 r
.63221 .44296 .63575 .447 .63872 .44378 .63518 .43973 Mtetra
.63 .577 .777 r
.63518 .43973 .63872 .44378 .64173 .44199 .63818 .43794 Mtetra
.546 .555 .815 r
.63818 .43794 .64173 .44199 .64479 .44164 .64123 .43759 Mtetra
.405 .507 .849 r
.64123 .43759 .64479 .44164 .64788 .4425 .64432 .43844 Mtetra
.233 .432 .851 r
.64432 .43844 .64788 .4425 .651 .44418 .64744 .44011 Mtetra
.14 .386 .838 r
.64744 .44011 .651 .44418 .65414 .44616 .65057 .4421 Mtetra
.205 .418 .848 r
.65057 .4421 .65414 .44616 .65728 .44795 .65371 .44388 Mtetra
.365 .49 .853 r
.65371 .44388 .65728 .44795 .66041 .44905 .65683 .44497 Mtetra
.511 .545 .827 r
.65683 .44497 .66041 .44905 .66351 .44909 .65993 .44501 Mtetra
.606 .572 .79 r
.65993 .44501 .66351 .44909 .66658 .4478 .663 .44371 Mtetra
.661 .584 .758 r
.663 .44371 .66658 .4478 .66962 .44505 .66604 .44096 Mtetra
.693 .589 .735 r
.66604 .44096 .66962 .44505 .67261 .44087 .66903 .43678 Mtetra
.713 .592 .719 r
.66903 .43678 .67261 .44087 .67556 .4354 .67198 .43131 Mtetra
.725 .593 .708 r
.67198 .43131 .67556 .4354 .67848 .42888 .6749 .42479 Mtetra
.731 .593 .702 r
.6749 .42479 .67848 .42888 .68138 .42166 .6778 .41756 Mtetra
.734 .593 .699 r
.6778 .41756 .68138 .42166 .68426 .41408 .68068 .40999 Mtetra
.68068 .40999 .68426 .41408 .68714 .40655 .68357 .40246 Mtetra
.73 .593 .703 r
.68357 .40246 .68714 .40655 .69004 .39944 .68646 .39534 Mtetra
.723 .593 .709 r
.68646 .39534 .69004 .39944 .69296 .39307 .68938 .38898 Mtetra
.711 .591 .72 r
.68938 .38898 .69296 .39307 .69592 .38773 .69234 .38364 Mtetra
.692 .589 .736 r
.69234 .38364 .69592 .38773 .69892 .38364 .69534 .37954 Mtetra
.66 .584 .758 r
.69534 .37954 .69892 .38364 .70197 .38091 .69839 .37681 Mtetra
.605 .572 .79 r
.69839 .37681 .70197 .38091 .70508 .37961 .7015 .37551 Mtetra
.505 .542 .828 r
.7015 .37551 .70508 .37961 .70825 .37971 .70467 .3756 Mtetra
.313 .468 .854 r
.70467 .3756 .70825 .37971 .71148 .38111 .70789 .377 Mtetra
0 .297 .794 r
.70789 .377 .71148 .38111 .71476 .38365 .71116 .37953 Mtetra
0 .053 .587 r
.71116 .37953 .71476 .38365 .71808 .38711 .71448 .38298 Mtetra
.619 .13 0 r
.71448 .38298 .71808 .38711 .72144 .39122 .71784 .38709 Mtetra
.706 .213 0 r
.71784 .38709 .72144 .39122 .72483 .3957 .72122 .39156 Mtetra
.715 .222 0 r
.72122 .39156 .72483 .3957 .72823 .40025 .72462 .3961 Mtetra
.656 .164 0 r
.72462 .3961 .72823 .40025 .73164 .40454 .72801 .40039 Mtetra
0 0 .511 r
.72801 .40039 .73164 .40454 .73503 .4083 .7314 .40414 Mtetra
0 .214 .735 r
.7314 .40414 .73503 .4083 .7384 .41125 .73477 .40709 Mtetra
.202 .416 .847 r
.73477 .40709 .7384 .41125 .74174 .41316 .7381 .40899 Mtetra
.439 .519 .843 r
.7381 .40899 .74174 .41316 .74503 .41385 .74138 .40967 Mtetra
.568 .562 .807 r
.74138 .40967 .74503 .41385 .74826 .41317 .74462 .40899 Mtetra
.638 .579 .772 r
.74462 .40899 .74826 .41317 .75144 .41105 .74779 .40687 Mtetra
.679 .587 .746 r
.74779 .40687 .75144 .41105 .75456 .40747 .75091 .40328 Mtetra
.705 .591 .726 r
.75091 .40328 .75456 .40747 .75761 .40246 .75396 .39827 Mtetra
.722 .593 .711 r
.75396 .39827 .75761 .40246 .7606 .39612 .75695 .39193 Mtetra
.733 .594 .7 r
.75695 .39193 .7606 .39612 .76354 .38857 .75989 .38438 Mtetra
.741 .594 .693 r
.75989 .38438 .76354 .38857 .76642 .38 .76278 .37581 Mtetra
.746 .594 .687 r
.76278 .37581 .76642 .38 .76926 .37062 .76562 .36643 Mtetra
.75 .595 .684 r
.76562 .36643 .76926 .37062 .77207 .36066 .76843 .35647 Mtetra
.752 .595 .682 r
.76843 .35647 .77207 .36066 .77486 .35038 .77122 .34619 Mtetra
.752 .595 .681 r
.77122 .34619 .77486 .35038 .77764 .34003 .77401 .33585 Mtetra
.751 .595 .682 r
.77401 .33585 .77764 .34003 .78043 .32987 .7768 .32568 Mtetra
.749 .595 .685 r
.7768 .32568 .78043 .32987 .78323 .32013 .7796 .31595 Mtetra
.745 .594 .689 r
.7796 .31595 .78323 .32013 .78606 .31106 .78244 .30688 Mtetra
.739 .594 .695 r
.78244 .30688 .78606 .31106 .78894 .30285 .78531 .29867 Mtetra
.73 .593 .703 r
.78531 .29867 .78894 .30285 .79186 .29567 .78824 .2915 Mtetra
.718 .592 .714 r
.78824 .2915 .79186 .29567 .79485 .28968 .79123 .28551 Mtetra
.7 .59 .729 r
.79123 .28551 .79485 .28968 .79791 .28499 .79429 .28081 Mtetra
.673 .586 .75 r
.79429 .28081 .79791 .28499 .80105 .28166 .79743 .27748 Mtetra
.63 .577 .777 r
.79743 .27748 .80105 .28166 .80427 .27974 .80064 .27555 Mtetra
.556 .558 .811 r
.80064 .27555 .80427 .27974 .80758 .27923 .80395 .27504 Mtetra
.418 .51 .846 r
.80395 .27504 .80758 .27923 .81097 .2801 .80733 .2759 Mtetra
.154 .391 .839 r
.80733 .2759 .81097 .2801 .81444 .28227 .8108 .27807 Mtetra
0 .145 .678 r
.8108 .27807 .81444 .28227 .81799 .28566 .81435 .28145 Mtetra
.619 .131 0 r
.81435 .28145 .81799 .28566 .82162 .29013 .81797 .28591 Mtetra
.785 .301 0 r
.81797 .28591 .82162 .29013 .82532 .29553 .82166 .2913 Mtetra
.847 .385 .028 r
.82166 .2913 .82532 .29553 .82907 .30167 .82541 .29744 Mtetra
.87 .427 .108 r
.82541 .29744 .82907 .30167 .83288 .30838 .8292 .30414 Mtetra
.878 .446 .148 r
.8292 .30414 .83288 .30838 .83672 .31543 .83304 .31118 Mtetra
.881 .451 .159 r
.83304 .31118 .83672 .31543 .84059 .32262 .8369 .31836 Mtetra
.878 .444 .145 r
.8369 .31836 .84059 .32262 .84447 .32972 .84077 .32545 Mtetra
.84 .524 .454 r
.39357 .5933 .39698 .59575 .39952 .60273 .3961 .60028 Mtetra
.839 .525 .458 r
.3961 .60028 .39952 .60273 .40206 .60986 .39864 .60741 Mtetra
.84 .524 .455 r
.39864 .60741 .40206 .60986 .40462 .61692 .4012 .61447 Mtetra
.841 .519 .445 r
.4012 .61447 .40462 .61692 .4072 .62371 .40377 .62126 Mtetra
.843 .51 .424 r
.40377 .62126 .4072 .62371 .40979 .63002 .40635 .62756 Mtetra
.845 .493 .388 r
.40635 .62756 .40979 .63002 .41241 .63564 .40896 .63318 Mtetra
.844 .459 .319 r
.40896 .63318 .41241 .63564 .41504 .64039 .41159 .63793 Mtetra
.826 .38 .17 r
.41159 .63793 .41504 .64039 .4177 .64411 .41425 .64164 Mtetra
.676 .131 0 r
.41425 .64164 .4177 .64411 .42039 .64664 .41693 .64417 Mtetra
.026 .434 .868 r
.41693 .64417 .42039 .64664 .42309 .64788 .41963 .64541 Mtetra
.51 .624 .9 r
.41963 .64541 .42309 .64788 .42582 .64775 .42236 .64528 Mtetra
.649 .637 .824 r
.42236 .64528 .42582 .64775 .42857 .64621 .42511 .64374 Mtetra
.701 .632 .776 r
.42511 .64374 .42857 .64621 .43134 .64326 .42788 .64079 Mtetra
.727 .626 .745 r
.42788 .64079 .43134 .64326 .43413 .63894 .43066 .63646 Mtetra
.742 .622 .725 r
.43066 .63646 .43413 .63894 .43693 .63332 .43346 .63084 Mtetra
.751 .618 .712 r
.43346 .63084 .43693 .63332 .43974 .62653 .43628 .62404 Mtetra
.757 .616 .703 r
.43628 .62404 .43974 .62653 .44256 .61871 .4391 .61623 Mtetra
.761 .614 .696 r
.4391 .61623 .44256 .61871 .44538 .61006 .44193 .60757 Mtetra
.763 .613 .692 r
.44193 .60757 .44538 .61006 .44821 .60078 .44476 .59829 Mtetra
.765 .612 .69 r
.44476 .59829 .44821 .60078 .45104 .5911 .44759 .58861 Mtetra
.765 .612 .689 r
.44759 .58861 .45104 .5911 .45386 .58126 .45041 .57877 Mtetra
.45041 .57877 .45386 .58126 .45668 .57153 .45324 .56903 Mtetra
.764 .613 .691 r
.45324 .56903 .45668 .57153 .45949 .56213 .45605 .55963 Mtetra
.762 .614 .695 r
.45605 .55963 .45949 .56213 .4623 .55331 .45886 .55081 Mtetra
.758 .615 .7 r
.45886 .55081 .4623 .55331 .4651 .54528 .46167 .54278 Mtetra
.753 .617 .709 r
.46167 .54278 .4651 .54528 .46789 .53824 .46446 .53573 Mtetra
.744 .62 .721 r
.46446 .53573 .46789 .53824 .47068 .53234 .46725 .52983 Mtetra
.731 .624 .74 r
.46725 .52983 .47068 .53234 .47346 .52771 .47003 .52521 Mtetra
.708 .629 .767 r
.47003 .52521 .47346 .52771 .47624 .52444 .47281 .52193 Mtetra
.665 .634 .809 r
.47281 .52193 .47624 .52444 .47902 .52254 .47558 .52003 Mtetra
.566 .63 .874 r
.47558 .52003 .47902 .52254 .48179 .52201 .47836 .51949 Mtetra
.285 .552 .925 r
.47836 .51949 .48179 .52201 .48457 .52277 .48114 .52025 Mtetra
0 .173 .625 r
.48114 .52025 .48457 .52277 .48736 .5247 .48392 .52218 Mtetra
.737 .212 0 r
.48392 .52218 .48736 .5247 .49015 .52765 .4867 .52512 Mtetra
.82 .357 .122 r
.4867 .52512 .49015 .52765 .49295 .53139 .4895 .52886 Mtetra
.839 .411 .219 r
.4895 .52886 .49295 .53139 .49576 .53567 .4923 .53315 Mtetra
.843 .43 .254 r
.4923 .53315 .49576 .53567 .49858 .54023 .49512 .5377 Mtetra
.842 .427 .249 r
.49512 .5377 .49858 .54023 .5014 .54476 .49794 .54222 Mtetra
.835 .4 .199 r
.49794 .54222 .5014 .54476 .50424 .54896 .50077 .54642 Mtetra
.806 .327 .069 r
.50077 .54642 .50424 .54896 .50709 .55254 .50361 .55 Mtetra
.665 .119 0 r
.50361 .55 .50709 .55254 .50994 .55523 .50646 .55269 Mtetra
0 .348 .802 r
.50646 .55269 .50994 .55523 .5128 .5568 .50932 .55426 Mtetra
.431 .602 .918 r
.50932 .55426 .5128 .5568 .51566 .55708 .51218 .55454 Mtetra
.618 .635 .846 r
.51218 .55454 .51566 .55708 .51852 .55597 .51504 .55342 Mtetra
.687 .634 .79 r
.51504 .55342 .51852 .55597 .52138 .55342 .51789 .55087 Mtetra
.72 .629 .755 r
.51789 .55087 .52138 .55342 .52424 .5495 .52075 .54695 Mtetra
.737 .624 .733 r
.52075 .54695 .52424 .5495 .52709 .54434 .5236 .54178 Mtetra
.747 .621 .72 r
.5236 .54178 .52709 .54434 .52993 .53815 .52645 .53559 Mtetra
.752 .619 .712 r
.52645 .53559 .52993 .53815 .53278 .53122 .52929 .52866 Mtetra
.755 .618 .708 r
.52929 .52866 .53278 .53122 .53561 .52388 .53213 .52132 Mtetra
.755 .618 .707 r
.53213 .52132 .53561 .52388 .53845 .51651 .53497 .51395 Mtetra
.753 .619 .711 r
.53497 .51395 .53845 .51651 .54128 .50949 .5378 .50692 Mtetra
.748 .621 .718 r
.5378 .50692 .54128 .50949 .54412 .50317 .54065 .5006 Mtetra
.738 .624 .731 r
.54065 .5006 .54412 .50317 .54697 .49787 .5435 .4953 Mtetra
.721 .628 .753 r
.5435 .4953 .54697 .49787 .54983 .49384 .54636 .49126 Mtetra
.69 .633 .787 r
.54636 .49126 .54983 .49384 .55271 .4912 .54923 .48862 Mtetra
.624 .635 .84 r
.54923 .48862 .55271 .4912 .55561 .48998 .55213 .4874 Mtetra
.475 .612 .907 r
.55213 .4874 .55561 .48998 .55852 .49005 .55504 .48747 Mtetra
.157 .495 .906 r
.55504 .48747 .55852 .49005 .56145 .49118 .55797 .4886 Mtetra
0 .283 .743 r
.55797 .4886 .56145 .49118 .5644 .49299 .56091 .4904 Mtetra
0 .197 .655 r
.56091 .4904 .5644 .49299 .56736 .495 .56387 .49241 Mtetra
0 .322 .78 r
.56387 .49241 .56736 .495 .57032 .49672 .56683 .49413 Mtetra
.249 .536 .921 r
.56683 .49413 .57032 .49672 .57328 .49764 .56978 .49504 Mtetra
.533 .624 .888 r
.56978 .49504 .57328 .49764 .57623 .49735 .57273 .49475 Mtetra
.653 .635 .82 r
.57273 .49475 .57623 .49735 .57917 .49561 .57566 .49301 Mtetra
.703 .632 .774 r
.57566 .49301 .57917 .49561 .58208 .49244 .57858 .48984 Mtetra
.725 .628 .749 r
.57858 .48984 .58208 .49244 .58498 .48811 .58148 .48551 Mtetra
.734 .626 .739 r
.58148 .48551 .58498 .48811 .58788 .48319 .58438 .48058 Mtetra
.731 .626 .741 r
.58438 .48058 .58788 .48319 .59077 .47843 .58727 .47582 Mtetra
.717 .629 .759 r
.58727 .47582 .59077 .47843 .59369 .47462 .59019 .47201 Mtetra
.678 .634 .799 r
.59019 .47201 .59369 .47462 .59663 .47228 .59313 .46967 Mtetra
.598 .633 .856 r
.59313 .46967 .59663 .47228 .5996 .47137 .5961 .46876 Mtetra
.551 .627 .88 r
.5961 .46876 .5996 .47137 .60259 .47093 .59908 .46831 Mtetra
.648 .635 .823 r
.59908 .46831 .60259 .47093 .60556 .46927 .60205 .46665 Mtetra
.696 .633 .782 r
.60205 .46665 .60556 .46927 .60851 .46635 .605 .46372 Mtetra
.648 .635 .823 r
.605 .46372 .60851 .46635 .61148 .46468 .60797 .46205 Mtetra
.552 .627 .88 r
.60797 .46205 .61148 .46468 .61449 .46423 .61098 .4616 Mtetra
.599 .633 .856 r
.61098 .4616 .61449 .46423 .61749 .46331 .61398 .46068 Mtetra
.678 .634 .799 r
.61398 .46068 .61749 .46331 .62047 .46095 .61695 .45832 Mtetra
.717 .63 .76 r
.61695 .45832 .62047 .46095 .62342 .45711 .6199 .45447 Mtetra
.732 .627 .741 r
.6199 .45447 .62342 .45711 .62634 .4523 .62283 .44966 Mtetra
.734 .626 .739 r
.62283 .44966 .62634 .4523 .62927 .44734 .62575 .44469 Mtetra
.725 .628 .749 r
.62575 .44469 .62927 .44734 .63221 .44296 .62869 .44031 Mtetra
.703 .632 .774 r
.62869 .44031 .63221 .44296 .63518 .43973 .63166 .43708 Mtetra
.654 .635 .819 r
.63166 .43708 .63518 .43973 .63818 .43794 .63467 .43529 Mtetra
.54 .624 .884 r
.63467 .43529 .63818 .43794 .64123 .43759 .63772 .43493 Mtetra
.287 .549 .923 r
.63772 .43493 .64123 .43759 .64432 .43844 .6408 .43579 Mtetra
0 .373 .826 r
.6408 .43579 .64432 .43844 .64744 .44011 .64391 .43745 Mtetra
0 .265 .729 r
.64391 .43745 .64744 .44011 .65057 .4421 .64704 .43943 Mtetra
0 .34 .798 r
.64704 .43943 .65057 .4421 .65371 .44388 .65017 .44121 Mtetra
.205 .515 .914 r
.65017 .44121 .65371 .44388 .65683 .44497 .6533 .44231 Mtetra
.484 .613 .903 r
.6533 .44231 .65683 .44497 .65993 .44501 .6564 .44234 Mtetra
.624 .635 .84 r
.6564 .44234 .65993 .44501 .663 .44371 .65946 .44104 Mtetra
.689 .634 .789 r
.65946 .44104 .663 .44371 .66604 .44096 .66249 .43829 Mtetra
.722 .629 .754 r
.66249 .43829 .66604 .44096 .66903 .43678 .66549 .4341 Mtetra
.739 .625 .732 r
.66549 .4341 .66903 .43678 .67198 .43131 .66844 .42863 Mtetra
.749 .623 .719 r
.66844 .42863 .67198 .43131 .6749 .42479 .67136 .42211 Mtetra
.755 .621 .711 r
.67136 .42211 .6749 .42479 .6778 .41756 .67426 .41488 Mtetra
.757 .62 .707 r
.67426 .41488 .6778 .41756 .68068 .40999 .67715 .4073 Mtetra
.757 .62 .708 r
.67715 .4073 .68068 .40999 .68357 .40246 .68003 .39977 Mtetra
.754 .621 .712 r
.68003 .39977 .68357 .40246 .68646 .39534 .68293 .39265 Mtetra
.748 .623 .72 r
.68293 .39265 .68646 .39534 .68938 .38898 .68585 .38628 Mtetra
.738 .626 .734 r
.68585 .38628 .68938 .38898 .69234 .38364 .68881 .38094 Mtetra
.72 .629 .756 r
.68881 .38094 .69234 .38364 .69534 .37954 .69181 .37684 Mtetra
.688 .633 .789 r
.69181 .37684 .69534 .37954 .69839 .37681 .69486 .37411 Mtetra
.623 .633 .84 r
.69486 .37411 .69839 .37681 .7015 .37551 .69797 .3728 Mtetra
.475 .609 .904 r
.69797 .3728 .7015 .37551 .70467 .3756 .70113 .3729 Mtetra
.105 .464 .89 r
.70113 .3729 .70467 .3756 .70789 .377 .70435 .37429 Mtetra
.441 0 0 r
.70435 .37429 .70789 .377 .71116 .37953 .70762 .37682 Mtetra
.713 .181 0 r
.70762 .37682 .71116 .37953 .71448 .38298 .71094 .38027 Mtetra
.794 .299 .006 r
.71094 .38027 .71448 .38298 .71784 .38709 .71429 .38437 Mtetra
.817 .344 .081 r
.71429 .38437 .71784 .38709 .72122 .39156 .71766 .38884 Mtetra
.819 .348 .089 r
.71766 .38884 .72122 .39156 .72462 .3961 .72105 .39337 Mtetra
.804 .318 .037 r
.72105 .39337 .72462 .3961 .72801 .40039 .72445 .39766 Mtetra
.75 .231 0 r
.72445 .39766 .72801 .40039 .7314 .40414 .72783 .40141 Mtetra
.573 .023 0 r
.72783 .40141 .7314 .40414 .73477 .40709 .73119 .40435 Mtetra
0 .339 .799 r
.73119 .40435 .73477 .40709 .7381 .40899 .73452 .40625 Mtetra
.356 .573 .922 r
.73452 .40625 .7381 .40899 .74138 .40967 .7378 .40693 Mtetra
.572 .629 .87 r
.7378 .40693 .74138 .40967 .74462 .40899 .74103 .40624 Mtetra
.664 .636 .812 r
.74103 .40624 .74462 .40899 .74779 .40687 .74421 .40412 Mtetra
.708 .633 .77 r
.74421 .40412 .74779 .40687 .75091 .40328 .74732 .40053 Mtetra
.733 .628 .742 r
.74732 .40053 .75091 .40328 .75396 .39827 .75038 .39552 Mtetra
.748 .625 .723 r
.75038 .39552 .75396 .39827 .75695 .39193 .75337 .38917 Mtetra
.758 .622 .709 r
.75337 .38917 .75695 .39193 .75989 .38438 .75631 .38162 Mtetra
.764 .62 .699 r
.75631 .38162 .75989 .38438 .76278 .37581 .7592 .37305 Mtetra
.768 .618 .693 r
.7592 .37305 .76278 .37581 .76562 .36643 .76204 .36367 Mtetra
.771 .617 .689 r
.76204 .36367 .76562 .36643 .76843 .35647 .76486 .35371 Mtetra
.772 .616 .686 r
.76486 .35371 .76843 .35647 .77122 .34619 .76765 .34343 Mtetra
.76765 .34343 .77122 .34619 .77401 .33585 .77044 .33308 Mtetra
.772 .616 .687 r
.77044 .33308 .77401 .33585 .7768 .32568 .77323 .32291 Mtetra
.77 .617 .69 r
.77323 .32291 .7768 .32568 .7796 .31595 .77604 .31318 Mtetra
.767 .618 .695 r
.77604 .31318 .7796 .31595 .78244 .30688 .77888 .30411 Mtetra
.762 .62 .702 r
.77888 .30411 .78244 .30688 .78531 .29867 .78176 .29589 Mtetra
.755 .622 .712 r
.78176 .29589 .78531 .29867 .78824 .2915 .78469 .28872 Mtetra
.745 .625 .727 r
.78469 .28872 .78824 .2915 .79123 .28551 .78768 .28272 Mtetra
.728 .629 .747 r
.78768 .28272 .79123 .28551 .79429 .28081 .79074 .27802 Mtetra
.701 .632 .776 r
.79074 .27802 .79429 .28081 .79743 .27748 .79388 .27469 Mtetra
.653 .634 .818 r
.79388 .27469 .79743 .27748 .80064 .27555 .79709 .27276 Mtetra
.555 .623 .875 r
.79709 .27276 .80064 .27555 .80395 .27504 .80039 .27225 Mtetra
.321 .556 .92 r
.80039 .27225 .80395 .27504 .80733 .2759 .80377 .27311 Mtetra
0 .29 .759 r
.80377 .27311 .80733 .2759 .8108 .27807 .80724 .27527 Mtetra
.634 .09 0 r
.80724 .27527 .8108 .27807 .81435 .28145 .81078 .27865 Mtetra
.793 .296 0 r
.81078 .27865 .81435 .28145 .81797 .28591 .8144 .28311 Mtetra
.837 .386 .147 r
.8144 .28311 .81797 .28591 .82166 .2913 .81808 .28849 Mtetra
.851 .43 .228 r
.81808 .28849 .82166 .2913 .82541 .29744 .82182 .29463 Mtetra
.856 .452 .271 r
.82182 .29463 .82541 .29744 .8292 .30414 .82561 .30132 Mtetra
.858 .463 .293 r
.82561 .30132 .8292 .30414 .83304 .31118 .82944 .30836 Mtetra
.858 .466 .299 r
.82944 .30836 .83304 .31118 .8369 .31836 .83329 .31553 Mtetra
.858 .462 .291 r
.83329 .31553 .8369 .31836 .84077 .32545 .83715 .32262 Mtetra
.802 .507 .489 r
.39014 .59224 .39357 .5933 .3961 .60028 .39266 .59922 Mtetra
.803 .508 .491 r
.39266 .59922 .3961 .60028 .39864 .60741 .3952 .60635 Mtetra
.803 .507 .489 r
.3952 .60635 .39864 .60741 .4012 .61447 .39775 .61342 Mtetra
.802 .503 .482 r
.39775 .61342 .4012 .61447 .40377 .62126 .40031 .62021 Mtetra
.801 .494 .469 r
.40031 .62021 .40377 .62126 .40635 .62756 .40289 .62651 Mtetra
.8 .479 .447 r
.40289 .62651 .40635 .62756 .40896 .63318 .40549 .63213 Mtetra
.796 .454 .408 r
.40549 .63213 .40896 .63318 .41159 .63793 .40812 .63688 Mtetra
.784 .403 .334 r
.40812 .63688 .41159 .63793 .41425 .64164 .41077 .64059 Mtetra
.74 .28 .16 r
.41077 .64059 .41425 .64164 .41693 .64417 .41345 .64312 Mtetra
.462 0 0 r
.41345 .64312 .41693 .64417 .41963 .64541 .41615 .64436 Mtetra
.408 .736 .992 r
.41615 .64436 .41963 .64541 .42236 .64528 .41887 .64423 Mtetra
.682 .739 .894 r
.41887 .64423 .42236 .64528 .42511 .64374 .42162 .64269 Mtetra
.742 .7 .812 r
.42162 .64269 .42511 .64374 .42788 .64079 .42439 .63973 Mtetra
.763 .676 .767 r
.42439 .63973 .42788 .64079 .43066 .63646 .42718 .6354 Mtetra
.773 .661 .739 r
.42718 .6354 .43066 .63646 .43346 .63084 .42998 .62978 Mtetra
.779 .651 .722 r
.42998 .62978 .43346 .63084 .43628 .62404 .4328 .62298 Mtetra
.782 .645 .71 r
.4328 .62298 .43628 .62404 .4391 .61623 .43562 .61516 Mtetra
.784 .64 .702 r
.43562 .61516 .4391 .61623 .44193 .60757 .43845 .6065 Mtetra
.785 .637 .697 r
.43845 .6065 .44193 .60757 .44476 .59829 .44129 .59721 Mtetra
.786 .636 .694 r
.44129 .59721 .44476 .59829 .44759 .58861 .44412 .58752 Mtetra
.786 .635 .693 r
.44412 .58752 .44759 .58861 .45041 .57877 .44695 .57768 Mtetra
.786 .635 .694 r
.44695 .57768 .45041 .57877 .45324 .56903 .44978 .56794 Mtetra
.786 .637 .696 r
.44978 .56794 .45324 .56903 .45605 .55963 .4526 .55853 Mtetra
.785 .639 .7 r
.4526 .55853 .45605 .55963 .45886 .55081 .45541 .5497 Mtetra
.783 .643 .707 r
.45541 .5497 .45886 .55081 .46167 .54278 .45822 .54167 Mtetra
.78 .649 .718 r
.45822 .54167 .46167 .54278 .46446 .53573 .46102 .53462 Mtetra
.774 .658 .734 r
.46102 .53462 .46446 .53573 .46725 .52983 .46381 .52872 Mtetra
.765 .671 .759 r
.46381 .52872 .46725 .52983 .47003 .52521 .46659 .52409 Mtetra
.747 .692 .798 r
.46659 .52409 .47003 .52521 .47281 .52193 .46937 .5208 Mtetra
.702 .724 .867 r
.46937 .5208 .47281 .52193 .47558 .52003 .47214 .5189 Mtetra
.542 .751 .973 r
.47214 .5189 .47558 .52003 .47836 .51949 .47492 .51837 Mtetra
0 .453 .763 r
.47492 .51837 .47836 .51949 .48114 .52025 .47769 .51912 Mtetra
.655 .117 0 r
.47769 .51912 .48114 .52025 .48392 .52218 .48047 .52106 Mtetra
.76 .318 .201 r
.48047 .52106 .48392 .52218 .4867 .52512 .48325 .524 Mtetra
.786 .391 .307 r
.48325 .524 .4867 .52512 .4895 .52886 .48604 .52774 Mtetra
.794 .423 .353 r
.48604 .52774 .4895 .52886 .4923 .53315 .48884 .53202 Mtetra
.797 .434 .371 r
.48884 .53202 .4923 .53315 .49512 .5377 .49165 .53657 Mtetra
.796 .433 .368 r
.49165 .53657 .49512 .5377 .49794 .54222 .49447 .5411 Mtetra
.792 .416 .343 r
.49447 .5411 .49794 .54222 .50077 .54642 .4973 .5453 Mtetra
.78 .374 .283 r
.4973 .5453 .50077 .54642 .50361 .55 .50014 .54888 Mtetra
.741 .274 .139 r
.50014 .54888 .50361 .55 .50646 .55269 .50298 .55156 Mtetra
.549 0 0 r
.50298 .55156 .50646 .55269 .50932 .55426 .50584 .55313 Mtetra
.215 .657 .951 r
.50584 .55313 .50932 .55426 .51218 .55454 .50869 .55341 Mtetra
.636 .749 .93 r
.50869 .55341 .51218 .55454 .51504 .55342 .51155 .55229 Mtetra
.728 .712 .835 r
.51155 .55229 .51504 .55342 .51789 .55087 .51441 .54974 Mtetra
.758 .685 .781 r
.51441 .54974 .51789 .55087 .52075 .54695 .51727 .54582 Mtetra
.771 .669 .75 r
.51727 .54582 .52075 .54695 .5236 .54178 .52012 .54065 Mtetra
.777 .659 .732 r
.52012 .54065 .5236 .54178 .52645 .53559 .52297 .53445 Mtetra
.781 .653 .722 r
.52297 .53445 .52645 .53559 .52929 .52866 .52581 .52751 Mtetra
.782 .65 .717 r
.52581 .52751 .52929 .52866 .53213 .52132 .52865 .52017 Mtetra
.782 .65 .716 r
.52865 .52017 .53213 .52132 .53497 .51395 .53149 .5128 Mtetra
.781 .652 .72 r
.53149 .5128 .53497 .51395 .5378 .50692 .53433 .50577 Mtetra
.778 .658 .73 r
.53433 .50577 .5378 .50692 .54065 .5006 .53718 .49944 Mtetra
.772 .667 .748 r
.53718 .49944 .54065 .5006 .5435 .4953 .54003 .49414 Mtetra
.759 .683 .778 r
.54003 .49414 .5435 .4953 .54636 .49126 .54289 .4901 Mtetra
.73 .709 .831 r
.54289 .4901 .54636 .49126 .54923 .48862 .54577 .48746 Mtetra
.646 .743 .92 r
.54577 .48746 .54923 .48862 .55213 .4874 .54866 .48623 Mtetra
.334 .703 .983 r
.54866 .48623 .55213 .4874 .55504 .48747 .55157 .4863 Mtetra
.311 0 0 r
.55157 .4863 .55504 .48747 .55797 .4886 .5545 .48743 Mtetra
.595 .028 0 r
.5545 .48743 .55797 .4886 .56091 .4904 .55744 .48923 Mtetra
.644 .097 0 r
.55744 .48923 .56091 .4904 .56387 .49241 .56039 .49124 Mtetra
.567 0 0 r
.56039 .49124 .56387 .49241 .56683 .49413 .56335 .49296 Mtetra
0 .406 .717 r
.56335 .49296 .56683 .49413 .56978 .49504 .5663 .49387 Mtetra
.471 .741 .987 r
.5663 .49387 .56978 .49504 .57273 .49475 .56925 .49358 Mtetra
.687 .732 .885 r
.56925 .49358 .57273 .49475 .57566 .49301 .57218 .49184 Mtetra
.743 .7 .81 r
.57218 .49184 .57566 .49301 .57858 .48984 .57509 .48866 Mtetra
.763 .681 .772 r
.57509 .48866 .57858 .48984 .58148 .48551 .578 .48433 Mtetra
.769 .673 .757 r
.578 .48433 .58148 .48551 .58438 .48058 .58089 .4794 Mtetra
.767 .675 .761 r
.58089 .4794 .58438 .48058 .58727 .47582 .58379 .47463 Mtetra
.755 .688 .787 r
.58379 .47463 .58727 .47582 .59019 .47201 .58671 .47081 Mtetra
.717 .717 .849 r
.58671 .47081 .59019 .47201 .59313 .46967 .58965 .46848 Mtetra
.603 .749 .947 r
.58965 .46848 .59313 .46967 .5961 .46876 .59262 .46756 Mtetra
.512 .746 .98 r
.59262 .46756 .5961 .46876 .59908 .46831 .5956 .46712 Mtetra
.681 .734 .891 r
.5956 .46712 .59908 .46831 .60205 .46665 .59857 .46545 Mtetra
.736 .705 .821 r
.59857 .46545 .60205 .46665 .605 .46372 .60151 .46252 Mtetra
.681 .734 .891 r
.60151 .46252 .605 .46372 .60797 .46205 .60449 .46085 Mtetra
.513 .746 .979 r
.60449 .46085 .60797 .46205 .61098 .4616 .60749 .4604 Mtetra
.603 .749 .947 r
.60749 .4604 .61098 .4616 .61398 .46068 .61049 .45947 Mtetra
.717 .718 .85 r
.61049 .45947 .61398 .46068 .61695 .45832 .61347 .45711 Mtetra
.756 .689 .788 r
.61347 .45711 .61695 .45832 .6199 .45447 .61641 .45326 Mtetra
.768 .676 .762 r
.61641 .45326 .6199 .45447 .62283 .44966 .61934 .44845 Mtetra
.769 .674 .758 r
.61934 .44845 .62283 .44966 .62575 .44469 .62227 .44348 Mtetra
.763 .682 .773 r
.62227 .44348 .62575 .44469 .62869 .44031 .62521 .43909 Mtetra
.743 .7 .81 r
.62521 .43909 .62869 .44031 .63166 .43708 .62818 .43586 Mtetra
.688 .731 .883 r
.62818 .43586 .63166 .43708 .63467 .43529 .63118 .43406 Mtetra
.489 .741 .983 r
.63118 .43406 .63467 .43529 .63772 .43493 .63423 .43371 Mtetra
0 .465 .786 r
.63423 .43371 .63772 .43493 .6408 .43579 .63731 .43456 Mtetra
.511 0 0 r
.63731 .43456 .6408 .43579 .64391 .43745 .64042 .43623 Mtetra
.603 .038 0 r
.64042 .43623 .64391 .43745 .64704 .43943 .64355 .43821 Mtetra
.545 0 0 r
.64355 .43821 .64704 .43943 .65017 .44121 .64668 .43998 Mtetra
0 .354 .668 r
.64668 .43998 .65017 .44121 .6533 .44231 .6498 .44108 Mtetra
.361 .709 .986 r
.6498 .44108 .6533 .44231 .6564 .44234 .6529 .44111 Mtetra
.646 .743 .92 r
.6529 .44111 .6564 .44234 .65946 .44104 .65596 .4398 Mtetra
.73 .711 .833 r
.65596 .4398 .65946 .44104 .66249 .43829 .65899 .43705 Mtetra
.76 .687 .78 r
.65899 .43705 .66249 .43829 .66549 .4341 .66198 .43286 Mtetra
.774 .671 .749 r
.66198 .43286 .66549 .4341 .66844 .42863 .66494 .42738 Mtetra
.781 .661 .731 r
.66494 .42738 .66844 .42863 .67136 .42211 .66786 .42086 Mtetra
.785 .656 .721 r
.66786 .42086 .67136 .42211 .67426 .41488 .67077 .41363 Mtetra
.786 .654 .716 r
.67077 .41363 .67426 .41488 .67715 .4073 .67365 .40605 Mtetra
.786 .654 .717 r
.67365 .40605 .67715 .4073 .68003 .39977 .67654 .39851 Mtetra
.784 .657 .722 r
.67654 .39851 .68003 .39977 .68293 .39265 .67944 .39139 Mtetra
.78 .662 .733 r
.67944 .39139 .68293 .39265 .68585 .38628 .68237 .38502 Mtetra
.773 .672 .752 r
.68237 .38502 .68585 .38628 .68881 .38094 .68533 .37967 Mtetra
.759 .687 .783 r
.68533 .37967 .68881 .38094 .69181 .37684 .68833 .37557 Mtetra
.728 .711 .834 r
.68833 .37557 .69181 .37684 .69486 .37411 .69138 .37283 Mtetra
.644 .74 .919 r
.69138 .37283 .69486 .37411 .69797 .3728 .69449 .37153 Mtetra
.344 .699 .983 r
.69449 .37153 .69797 .3728 .70113 .3729 .69765 .37162 Mtetra
.357 0 0 r
.69765 .37162 .70113 .3729 .70435 .37429 .70086 .37301 Mtetra
.684 .154 0 r
.70086 .37301 .70435 .37429 .70762 .37682 .70413 .37554 Mtetra
.762 .302 .155 r
.70413 .37554 .70762 .37682 .71094 .38027 .70744 .37899 Mtetra
.786 .361 .241 r
.70744 .37899 .71094 .38027 .71429 .38437 .71079 .38309 Mtetra
.794 .385 .276 r
.71079 .38309 .71429 .38437 .71766 .38884 .71416 .38756 Mtetra
.795 .388 .28 r
.71416 .38756 .71766 .38884 .72105 .39337 .71755 .39209 Mtetra
.789 .371 .256 r
.71755 .39209 .72105 .39337 .72445 .39766 .72093 .39638 Mtetra
.772 .326 .191 r
.72093 .39638 .72445 .39766 .72783 .40141 .72431 .40013 Mtetra
.723 .223 .044 r
.72431 .40013 .72783 .40141 .73119 .40435 .72767 .40307 Mtetra
.541 0 0 r
.72767 .40307 .73119 .40435 .73452 .40625 .73099 .40497 Mtetra
.059 .562 .884 r
.73099 .40497 .73452 .40625 .7378 .40693 .73428 .40565 Mtetra
.555 .747 .967 r
.73428 .40565 .7378 .40693 .74103 .40624 .73751 .40496 Mtetra
.701 .728 .871 r
.73751 .40496 .74103 .40624 .74421 .40412 .74068 .40283 Mtetra
.749 .7 .805 r
.74068 .40283 .74421 .40412 .74732 .40053 .7438 .39925 Mtetra
.771 .68 .763 r
.7438 .39925 .74732 .40053 .75038 .39552 .74685 .39423 Mtetra
.782 .667 .737 r
.74685 .39423 .75038 .39552 .75337 .38917 .74985 .38788 Mtetra
.788 .657 .719 r
.74985 .38788 .75337 .38917 .75631 .38162 .75279 .38032 Mtetra
.792 .651 .707 r
.75279 .38032 .75631 .38162 .7592 .37305 .75568 .37175 Mtetra
.794 .647 .699 r
.75568 .37175 .7592 .37305 .76204 .36367 .75853 .36236 Mtetra
.796 .644 .694 r
.75853 .36236 .76204 .36367 .76486 .35371 .76135 .35239 Mtetra
.797 .643 .691 r
.76135 .35239 .76486 .35371 .76765 .34343 .76415 .34211 Mtetra
.797 .642 .69 r
.76415 .34211 .76765 .34343 .77044 .33308 .76694 .33175 Mtetra
.796 .643 .692 r
.76694 .33175 .77044 .33308 .77323 .32291 .76974 .32158 Mtetra
.795 .645 .695 r
.76974 .32158 .77323 .32291 .77604 .31318 .77255 .31184 Mtetra
.794 .648 .701 r
.77255 .31184 .77604 .31318 .77888 .30411 .77539 .30276 Mtetra
.791 .653 .71 r
.77539 .30276 .77888 .30411 .78176 .29589 .77827 .29454 Mtetra
.786 .659 .723 r
.77827 .29454 .78176 .29589 .78469 .28872 .78121 .28736 Mtetra
.779 .669 .742 r
.78121 .28736 .78469 .28872 .78768 .28272 .7842 .28137 Mtetra
.766 .682 .77 r
.7842 .28137 .78768 .28272 .79074 .27802 .78726 .27666 Mtetra
.742 .702 .813 r
.78726 .27666 .79074 .27802 .79388 .27469 .7904 .27333 Mtetra
.687 .727 .881 r
.7904 .27333 .79388 .27469 .79709 .27276 .79361 .2714 Mtetra
.524 .736 .971 r
.79361 .2714 .79709 .27276 .80039 .27225 .79691 .27088 Mtetra
.003 .52 .857 r
.79691 .27088 .80039 .27225 .80377 .27311 .80029 .27174 Mtetra
.574 0 0 r
.80029 .27174 .80377 .27311 .80724 .27527 .80375 .2739 Mtetra
.744 .255 .075 r
.80375 .2739 .80724 .27527 .81078 .27865 .80729 .27728 Mtetra
.79 .36 .226 r
.80729 .27728 .81078 .27865 .8144 .28311 .81091 .28174 Mtetra
.807 .41 .302 r
.81091 .28174 .8144 .28311 .81808 .28849 .81458 .28712 Mtetra
.813 .438 .344 r
.81458 .28712 .81808 .28849 .82182 .29463 .81832 .29326 Mtetra
.817 .453 .368 r
.81832 .29326 .82182 .29463 .82561 .30132 .82211 .29995 Mtetra
.818 .461 .38 r
.82211 .29995 .82561 .30132 .82944 .30836 .82593 .307 Mtetra
.819 .463 .383 r
.82593 .307 .82944 .30836 .83329 .31553 .82977 .31417 Mtetra
.818 .46 .379 r
.82977 .31417 .83329 .31553 .83715 .32262 .83363 .32126 Mtetra
.772 .492 .511 r
.38667 .59252 .39014 .59224 .39266 .59922 .38919 .5995 Mtetra
.773 .494 .513 r
.38919 .5995 .39266 .59922 .3952 .60635 .39172 .60664 Mtetra
.773 .493 .511 r
.39172 .60664 .3952 .60635 .39775 .61342 .39427 .61371 Mtetra
.771 .488 .506 r
.39427 .61371 .39775 .61342 .40031 .62021 .39682 .6205 Mtetra
.768 .48 .497 r
.39682 .6205 .40031 .62021 .40289 .62651 .3994 .62682 Mtetra
.764 .467 .482 r
.3994 .62682 .40289 .62651 .40549 .63213 .402 .63244 Mtetra
.756 .444 .457 r
.402 .63244 .40549 .63213 .40812 .63688 .40462 .6372 Mtetra
.74 .405 .413 r
.40462 .6372 .40812 .63688 .41077 .64059 .40727 .64091 Mtetra
.705 .326 .326 r
.40727 .64091 .41077 .64059 .41345 .64312 .40994 .64344 Mtetra
.594 .122 .103 r
.40994 .64344 .41345 .64312 .41615 .64436 .41264 .64468 Mtetra
.027 0 0 r
.41264 .64468 .41615 .64436 .41887 .64423 .41537 .64455 Mtetra
.696 .895 .969 r
.41537 .64455 .41887 .64423 .42162 .64269 .41812 .64301 Mtetra
.795 .801 .857 r
.41812 .64301 .42162 .64269 .42439 .63973 .42088 .64005 Mtetra
.809 .744 .791 r
.42088 .64005 .42439 .63973 .42718 .6354 .42367 .63572 Mtetra
.811 .711 .755 r
.42367 .63572 .42718 .6354 .42998 .62978 .42648 .63009 Mtetra
.811 .691 .732 r
.42648 .63009 .42998 .62978 .4328 .62298 .4293 .62329 Mtetra
.811 .679 .718 r
.4293 .62329 .4328 .62298 .43562 .61516 .43213 .61546 Mtetra
.811 .67 .708 r
.43213 .61546 .43562 .61516 .43845 .6065 .43496 .60679 Mtetra
.81 .665 .702 r
.43496 .60679 .43845 .6065 .44129 .59721 .4378 .59749 Mtetra
.81 .662 .699 r
.4378 .59749 .44129 .59721 .44412 .58752 .44064 .5878 Mtetra
.81 .661 .697 r
.44064 .5878 .44412 .58752 .44695 .57768 .44347 .57795 Mtetra
.81 .661 .698 r
.44347 .57795 .44695 .57768 .44978 .56794 .44631 .56819 Mtetra
.81 .664 .701 r
.44631 .56819 .44978 .56794 .4526 .55853 .44913 .55878 Mtetra
.81 .668 .706 r
.44913 .55878 .4526 .55853 .45541 .5497 .45195 .54994 Mtetra
.811 .675 .714 r
.45195 .54994 .45541 .5497 .45822 .54167 .45476 .5419 Mtetra
.811 .687 .727 r
.45476 .5419 .45822 .54167 .46102 .53462 .45756 .53485 Mtetra
.811 .704 .747 r
.45756 .53485 .46102 .53462 .46381 .52872 .46035 .52894 Mtetra
.808 .732 .78 r
.46035 .52894 .46381 .52872 .46659 .52409 .46314 .52431 Mtetra
.798 .78 .837 r
.46314 .52431 .46659 .52409 .46937 .5208 .46591 .52102 Mtetra
.741 .863 .937 r
.46591 .52102 .46937 .5208 .47214 .5189 .46869 .51912 Mtetra
.312 .796 .896 r
.46869 .51912 .47214 .5189 .47492 .51837 .47146 .51858 Mtetra
.471 0 0 r
.47146 .51858 .47492 .51837 .47769 .51912 .47424 .51934 Mtetra
.668 .24 .221 r
.47424 .51934 .47769 .51912 .48047 .52106 .47701 .52128 Mtetra
.722 .348 .342 r
.47701 .52128 .48047 .52106 .48325 .524 .47979 .52422 Mtetra
.742 .397 .396 r
.47979 .52422 .48325 .524 .48604 .52774 .48258 .52796 Mtetra
.752 .42 .423 r
.48258 .52796 .48604 .52774 .48884 .53202 .48538 .53225 Mtetra
.755 .429 .433 r
.48538 .53225 .48884 .53202 .49165 .53657 .48818 .53681 Mtetra
.755 .428 .431 r
.48818 .53681 .49165 .53657 .49447 .5411 .491 .54134 Mtetra
.75 .415 .417 r
.491 .54134 .49447 .5411 .4973 .5453 .49382 .54554 Mtetra
.737 .385 .384 r
.49382 .54554 .4973 .5453 .50014 .54888 .49666 .54912 Mtetra
.709 .322 .314 r
.49666 .54912 .50014 .54888 .50298 .55156 .4995 .55181 Mtetra
.628 .169 .144 r
.4995 .55181 .50298 .55156 .50584 .55313 .50235 .55338 Mtetra
.267 0 0 r
.50235 .55338 .50584 .55313 .50869 .55341 .5052 .55366 Mtetra
.581 .898 .985 r
.5052 .55366 .50869 .55341 .51155 .55229 .50806 .55254 Mtetra
.779 .83 .892 r
.50806 .55254 .51155 .55229 .51441 .54974 .51092 .54999 Mtetra
.807 .763 .812 r
.51092 .54999 .51441 .54974 .51727 .54582 .51378 .54606 Mtetra
.813 .726 .769 r
.51378 .54606 .51727 .54582 .52012 .54065 .51664 .54089 Mtetra
.814 .706 .745 r
.51664 .54089 .52012 .54065 .52297 .53445 .51949 .53469 Mtetra
.814 .694 .732 r
.51949 .53469 .52297 .53445 .52581 .52751 .52233 .52774 Mtetra
.814 .689 .726 r
.52233 .52774 .52581 .52751 .52865 .52017 .52518 .52039 Mtetra
.814 .688 .725 r
.52518 .52039 .52865 .52017 .53149 .5128 .52802 .51301 Mtetra
.814 .693 .73 r
.52802 .51301 .53149 .5128 .53433 .50577 .53086 .50597 Mtetra
.814 .703 .742 r
.53086 .50597 .53433 .50577 .53718 .49944 .53371 .49965 Mtetra
.813 .723 .766 r
.53371 .49965 .53718 .49944 .54003 .49414 .53656 .49434 Mtetra
.807 .758 .807 r
.53656 .49434 .54003 .49414 .54289 .4901 .53943 .4903 Mtetra
.781 .823 .885 r
.53943 .4903 .54289 .4901 .54577 .48746 .54231 .48765 Mtetra
.615 .897 .987 r
.54231 .48765 .54577 .48746 .54866 .48623 .5452 .48642 Mtetra
.123 0 0 r
.5452 .48642 .54866 .48623 .55157 .4863 .54811 .4865 Mtetra
.549 .038 0 r
.54811 .4865 .55157 .4863 .5545 .48743 .55103 .48762 Mtetra
.648 .197 .167 r
.55103 .48762 .5545 .48743 .55744 .48923 .55397 .48943 Mtetra
.666 .23 .205 r
.55397 .48943 .55744 .48923 .56039 .49124 .55692 .49144 Mtetra
.637 .179 .147 r
.55692 .49144 .56039 .49124 .56335 .49296 .55988 .49316 Mtetra
.497 0 0 r
.55988 .49316 .56335 .49296 .5663 .49387 .56283 .49407 Mtetra
.128 .677 .776 r
.56283 .49407 .5663 .49387 .56925 .49358 .56577 .49378 Mtetra
.711 .884 .961 r
.56577 .49378 .56925 .49358 .57218 .49184 .56871 .49204 Mtetra
.796 .799 .854 r
.56871 .49204 .57218 .49184 .57509 .48866 .57162 .48886 Mtetra
.811 .753 .799 r
.57162 .48886 .57509 .48866 .578 .48433 .57453 .48452 Mtetra
.813 .736 .779 r
.57453 .48452 .578 .48433 .58089 .4794 .57742 .47959 Mtetra
.813 .74 .784 r
.57742 .47959 .58089 .4794 .58379 .47463 .58033 .47482 Mtetra
.806 .771 .821 r
.58033 .47482 .58379 .47463 .58671 .47081 .58324 .471 Mtetra
.765 .846 .913 r
.58324 .471 .58671 .47081 .58965 .46848 .58618 .46866 Mtetra
.496 .875 .974 r
.58618 .46866 .58965 .46848 .59262 .46756 .58915 .46774 Mtetra
.234 .749 .853 r
.58915 .46774 .59262 .46756 .5956 .46712 .59213 .4673 Mtetra
.699 .887 .967 r
.59213 .4673 .5956 .46712 .59857 .46545 .5951 .46563 Mtetra
.789 .813 .871 r
.5951 .46563 .59857 .46545 .60151 .46252 .59805 .4627 Mtetra
.699 .887 .967 r
.59805 .4627 .60151 .46252 .60449 .46085 .60102 .46102 Mtetra
.239 .752 .857 r
.60102 .46102 .60449 .46085 .60749 .4604 .60403 .46057 Mtetra
.497 .876 .975 r
.60403 .46057 .60749 .4604 .61049 .45947 .60703 .45965 Mtetra
.765 .847 .913 r
.60703 .45965 .61049 .45947 .61347 .45711 .61 .45728 Mtetra
.807 .773 .822 r
.61 .45728 .61347 .45711 .61641 .45326 .61295 .45342 Mtetra
.814 .742 .785 r
.61295 .45342 .61641 .45326 .61934 .44845 .61588 .44861 Mtetra
.814 .738 .78 r
.61588 .44861 .61934 .44845 .62227 .44348 .61881 .44363 Mtetra
.811 .755 .8 r
.61881 .44363 .62227 .44348 .62521 .43909 .62175 .43925 Mtetra
.797 .799 .854 r
.62175 .43925 .62521 .43909 .62818 .43586 .62472 .43601 Mtetra
.713 .88 .959 r
.62472 .43601 .62818 .43586 .63118 .43406 .62773 .43421 Mtetra
.181 .714 .822 r
.62773 .43421 .63118 .43406 .63423 .43371 .63077 .43386 Mtetra
.462 0 0 r
.63077 .43386 .63423 .43371 .63731 .43456 .63385 .43471 Mtetra
.621 .145 .101 r
.63385 .43471 .63731 .43456 .64042 .43623 .63696 .43638 Mtetra
.654 .201 .164 r
.63696 .43638 .64042 .43623 .64355 .43821 .64008 .43836 Mtetra
.633 .164 .123 r
.64008 .43836 .64355 .43821 .64668 .43998 .64321 .44014 Mtetra
.523 0 0 r
.64321 .44014 .64668 .43998 .6498 .44108 .64633 .44124 Mtetra
.077 0 0 r
.64633 .44124 .6498 .44108 .6529 .44111 .64943 .44126 Mtetra
.615 .897 .987 r
.64943 .44126 .6529 .44111 .65596 .4398 .65249 .43996 Mtetra
.782 .829 .889 r
.65249 .43996 .65596 .4398 .65899 .43705 .65552 .43721 Mtetra
.811 .766 .811 r
.65552 .43721 .65899 .43705 .66198 .43286 .65852 .43301 Mtetra
.818 .73 .768 r
.65852 .43301 .66198 .43286 .66494 .42738 .66148 .42753 Mtetra
.82 .71 .744 r
.66148 .42753 .66494 .42738 .66786 .42086 .6644 .421 Mtetra
.82 .699 .731 r
.6644 .421 .66786 .42086 .67077 .41363 .66731 .41376 Mtetra
.82 .694 .725 r
.66731 .41376 .67077 .41363 .67365 .40605 .6702 .40618 Mtetra
.82 .695 .726 r
.6702 .40618 .67365 .40605 .67654 .39851 .67309 .39863 Mtetra
.82 .7 .733 r
.67309 .39863 .67654 .39851 .67944 .39139 .676 .3915 Mtetra
.819 .712 .747 r
.676 .3915 .67944 .39139 .68237 .38502 .67892 .38513 Mtetra
.817 .733 .771 r
.67892 .38513 .68237 .38502 .68533 .37967 .68189 .37978 Mtetra
.809 .768 .814 r
.68189 .37978 .68533 .37967 .68833 .37557 .68489 .37567 Mtetra
.779 .828 .89 r
.68489 .37567 .68833 .37557 .69138 .37283 .68794 .37293 Mtetra
.617 .893 .988 r
.68794 .37293 .69138 .37283 .69449 .37153 .69105 .37162 Mtetra
.093 0 0 r
.69105 .37162 .69449 .37153 .69765 .37162 .69421 .37171 Mtetra
.57 .058 0 r
.69421 .37171 .69765 .37162 .70086 .37301 .69742 .37311 Mtetra
.689 .259 .221 r
.69742 .37311 .70086 .37301 .70413 .37554 .70069 .37564 Mtetra
.729 .34 .313 r
.70069 .37564 .70413 .37554 .70744 .37899 .70399 .37909 Mtetra
.746 .378 .356 r
.70399 .37909 .70744 .37899 .71079 .38309 .70734 .3832 Mtetra
.753 .394 .374 r
.70734 .3832 .71079 .38309 .71416 .38756 .71071 .38767 Mtetra
.754 .396 .376 r
.71071 .38767 .71416 .38756 .71755 .39209 .71409 .39221 Mtetra
.749 .384 .363 r
.71409 .39221 .71755 .39209 .72093 .39638 .71747 .3965 Mtetra
.736 .355 .33 r
.71747 .3965 .72093 .39638 .72431 .40013 .72085 .40025 Mtetra
.708 .295 .262 r
.72085 .40025 .72431 .40013 .72767 .40307 .7242 .4032 Mtetra
.634 .161 .112 r
.7242 .4032 .72767 .40307 .73099 .40497 .72753 .4051 Mtetra
.379 0 0 r
.72753 .4051 .73099 .40497 .73428 .40565 .73081 .40578 Mtetra
.361 .82 .927 r
.73081 .40578 .73428 .40565 .73751 .40496 .73404 .40509 Mtetra
.737 .873 .943 r
.73404 .40509 .73751 .40496 .74068 .40283 .73721 .40296 Mtetra
.804 .798 .846 r
.73721 .40296 .74068 .40283 .7438 .39925 .74033 .39937 Mtetra
.819 .75 .787 r
.74033 .39937 .7438 .39925 .74685 .39423 .74339 .39435 Mtetra
.823 .72 .751 r
.74339 .39435 .74685 .39423 .74985 .38788 .74638 .38799 Mtetra
.824 .701 .729 r
.74638 .38799 .74985 .38788 .75279 .38032 .74933 .38043 Mtetra
.825 .689 .714 r
.74933 .38043 .75279 .38032 .75568 .37175 .75222 .37184 Mtetra
.825 .681 .704 r
.75222 .37184 .75568 .37175 .75853 .36236 .75508 .36245 Mtetra
.824 .676 .698 r
.75508 .36245 .75853 .36236 .76135 .35239 .7579 .35248 Mtetra
.824 .673 .695 r
.7579 .35248 .76135 .35239 .76415 .34211 .76071 .34218 Mtetra
.824 .672 .694 r
.76071 .34218 .76415 .34211 .76694 .33175 .76351 .33181 Mtetra
.824 .674 .696 r
.76351 .33181 .76694 .33175 .76974 .32158 .76631 .32163 Mtetra
.824 .677 .7 r
.76631 .32163 .76974 .32158 .77255 .31184 .76912 .31189 Mtetra
.824 .683 .707 r
.76912 .31189 .77255 .31184 .77539 .30276 .77197 .3028 Mtetra
.824 .692 .718 r
.77197 .3028 .77539 .30276 .77827 .29454 .77486 .29457 Mtetra
.823 .705 .734 r
.77486 .29457 .77827 .29454 .78121 .28736 .77779 .28739 Mtetra
.821 .725 .758 r
.77779 .28739 .78121 .28736 .7842 .28137 .78079 .28138 Mtetra
.815 .755 .796 r
.78079 .28138 .7842 .28137 .78726 .27666 .78385 .27668 Mtetra
.795 .804 .859 r
.78385 .27668 .78726 .27666 .7904 .27333 .78699 .27334 Mtetra
.714 .873 .956 r
.78699 .27334 .7904 .27333 .79361 .2714 .79021 .27141 Mtetra
.301 .784 .911 r
.79021 .27141 .79361 .2714 .79691 .27088 .7935 .27089 Mtetra
.411 0 0 r
.7935 .27089 .79691 .27088 .80029 .27174 .79688 .27175 Mtetra
.652 .179 .117 r
.79688 .27175 .80029 .27174 .80375 .2739 .80034 .27391 Mtetra
.723 .313 .27 r
.80034 .27391 .80375 .2739 .80729 .27728 .80388 .27729 Mtetra
.753 .378 .344 r
.80388 .27729 .80729 .27728 .81091 .28174 .80749 .28175 Mtetra
.767 .413 .385 r
.80749 .28175 .81091 .28174 .81458 .28712 .81116 .28715 Mtetra
.775 .434 .41 r
.81116 .28715 .81458 .28712 .81832 .29326 .81489 .29329 Mtetra
.78 .447 .424 r
.81489 .29329 .81832 .29326 .82211 .29995 .81867 .29999 Mtetra
.782 .453 .432 r
.81867 .29999 .82211 .29995 .82593 .307 .82249 .30704 Mtetra
.782 .455 .434 r
.82249 .30704 .82593 .307 .82977 .31417 .82633 .31422 Mtetra
.782 .453 .431 r
.82633 .31422 .82977 .31417 .83363 .32126 .83018 .32131 Mtetra
.75 .481 .525 r
.38318 .594 .38667 .59252 .38919 .5995 .3857 .60099 Mtetra
.75 .483 .527 r
.3857 .60099 .38919 .5995 .39172 .60664 .38822 .60814 Mtetra
.75 .482 .526 r
.38822 .60814 .39172 .60664 .39427 .61371 .39076 .61522 Mtetra
.748 .477 .522 r
.39076 .61522 .39427 .61371 .39682 .6205 .39331 .62203 Mtetra
.744 .469 .515 r
.39331 .62203 .39682 .6205 .3994 .62682 .39588 .62835 Mtetra
.737 .456 .504 r
.39588 .62835 .3994 .62682 .402 .63244 .39848 .63398 Mtetra
.727 .436 .486 r
.39848 .63398 .402 .63244 .40462 .6372 .4011 .63874 Mtetra
.709 .402 .456 r
.4011 .63874 .40462 .6372 .40727 .64091 .40374 .64246 Mtetra
.675 .341 .402 r
.40374 .64246 .40727 .64091 .40994 .64344 .40642 .645 Mtetra
.597 .213 .287 r
.40642 .645 .40994 .64344 .41264 .64468 .40911 .64625 Mtetra
.338 0 0 r
.40911 .64625 .41264 .64468 .41537 .64455 .41184 .64612 Mtetra
.502 .905 .801 r
.41184 .64612 .41537 .64455 .41812 .64301 .41459 .64457 Mtetra
.841 .927 .888 r
.41459 .64457 .41812 .64301 .42088 .64005 .41736 .64161 Mtetra
.86 .826 .813 r
.41736 .64161 .42088 .64005 .42367 .63572 .42015 .63728 Mtetra
.854 .769 .768 r
.42015 .63728 .42367 .63572 .42648 .63009 .42295 .63164 Mtetra
.847 .736 .741 r
.42295 .63164 .42648 .63009 .4293 .62329 .42578 .62483 Mtetra
.842 .715 .724 r
.42578 .62483 .4293 .62329 .43213 .61546 .42861 .61699 Mtetra
.838 .702 .713 r
.42861 .61699 .43213 .61546 .43496 .60679 .43145 .60831 Mtetra
.836 .694 .706 r
.43145 .60831 .43496 .60679 .4378 .59749 .43429 .59901 Mtetra
.835 .689 .702 r
.43429 .59901 .4378 .59749 .44064 .5878 .43714 .5893 Mtetra
.834 .688 .701 r
.43714 .5893 .44064 .5878 .44347 .57795 .43998 .57944 Mtetra
.43998 .57944 .44347 .57795 .44631 .56819 .44282 .56967 Mtetra
.835 .692 .705 r
.44282 .56967 .44631 .56819 .44913 .55878 .44565 .56025 Mtetra
.837 .699 .71 r
.44565 .56025 .44913 .55878 .45195 .54994 .44847 .5514 Mtetra
.84 .71 .72 r
.44847 .5514 .45195 .54994 .45476 .5419 .45128 .54335 Mtetra
.845 .729 .735 r
.45128 .54335 .45476 .5419 .45756 .53485 .45409 .53629 Mtetra
.851 .757 .759 r
.45409 .53629 .45756 .53485 .46035 .52894 .45688 .53038 Mtetra
.857 .806 .8 r
.45688 .53038 .46035 .52894 .46314 .52431 .45967 .52574 Mtetra
.85 .892 .868 r
.45967 .52574 .46314 .52431 .46591 .52102 .46245 .52245 Mtetra
.682 .975 .904 r
.46245 .52245 .46591 .52102 .46869 .51912 .46523 .52055 Mtetra
.134 0 0 r
.46523 .52055 .46869 .51912 .47146 .51858 .468 .52001 Mtetra
.536 .113 .185 r
.468 .52001 .47146 .51858 .47424 .51934 .47077 .52077 Mtetra
.647 .284 .342 r
.47077 .52077 .47424 .51934 .47701 .52128 .47355 .52271 Mtetra
.69 .358 .41 r
.47355 .52271 .47701 .52128 .47979 .52422 .47632 .52566 Mtetra
.711 .396 .443 r
.47632 .52566 .47979 .52422 .48258 .52796 .47911 .52941 Mtetra
.721 .415 .461 r
.47911 .52941 .48258 .52796 .48538 .53225 .4819 .5337 Mtetra
.725 .423 .468 r
.4819 .5337 .48538 .53225 .48818 .53681 .4847 .53827 Mtetra
.724 .422 .467 r
.4847 .53827 .48818 .53681 .491 .54134 .48751 .54281 Mtetra
.718 .411 .457 r
.48751 .54281 .491 .54134 .49382 .54554 .49034 .54702 Mtetra
.705 .387 .435 r
.49034 .54702 .49382 .54554 .49666 .54912 .49317 .5506 Mtetra
.679 .339 .393 r
.49317 .5506 .49666 .54912 .4995 .55181 .49601 .5533 Mtetra
.619 .241 .304 r
.49601 .5533 .4995 .55181 .50235 .55338 .49886 .55487 Mtetra
.445 0 .073 r
.49886 .55487 .50235 .55338 .5052 .55366 .50171 .55516 Mtetra
0 0 0 r
.50171 .55516 .5052 .55366 .50806 .55254 .50457 .55404 Mtetra
.8 .967 .911 r
.50457 .55404 .50806 .55254 .51092 .54999 .50743 .55148 Mtetra
.861 .861 .838 r
.50743 .55148 .51092 .54999 .51378 .54606 .51029 .54755 Mtetra
.86 .795 .786 r
.51029 .54755 .51378 .54606 .51664 .54089 .51315 .54237 Mtetra
.855 .759 .756 r
.51315 .54237 .51664 .54089 .51949 .53469 .516 .53616 Mtetra
.851 .74 .74 r
.516 .53616 .51949 .53469 .52233 .52774 .51886 .52921 Mtetra
.849 .731 .733 r
.51886 .52921 .52233 .52774 .52518 .52039 .5217 .52185 Mtetra
.849 .73 .732 r
.5217 .52185 .52518 .52039 .52802 .51301 .52455 .51446 Mtetra
.85 .738 .739 r
.52455 .51446 .52802 .51301 .53086 .50597 .5274 .50742 Mtetra
.854 .755 .753 r
.5274 .50742 .53086 .50597 .53371 .49965 .53025 .50108 Mtetra
.859 .789 .781 r
.53025 .50108 .53371 .49965 .53656 .49434 .5331 .49577 Mtetra
.861 .852 .833 r
.5331 .49577 .53656 .49434 .53943 .4903 .53597 .49172 Mtetra
.81 .959 .91 r
.53597 .49172 .53943 .4903 .54231 .48765 .53885 .48907 Mtetra
.294 .772 .673 r
.53885 .48907 .54231 .48765 .5452 .48642 .54174 .48785 Mtetra
.385 0 0 r
.54174 .48785 .5452 .48642 .54811 .4865 .54465 .48792 Mtetra
.576 .168 .232 r
.54465 .48792 .54811 .4865 .55103 .48762 .54758 .48905 Mtetra
.633 .257 .314 r
.54758 .48905 .55103 .48762 .55397 .48943 .55051 .49086 Mtetra
.646 .278 .332 r
.55051 .49086 .55397 .48943 .55692 .49144 .55346 .49288 Mtetra
.627 .247 .304 r
.55346 .49288 .55692 .49144 .55988 .49316 .55641 .4946 Mtetra
.549 .129 .196 r
.55641 .4946 .55988 .49316 .56283 .49407 .55937 .49551 Mtetra
.259 0 0 r
.55937 .49551 .56283 .49407 .56577 .49378 .56231 .49522 Mtetra
.569 .939 .851 r
.56231 .49522 .56577 .49378 .56871 .49204 .56524 .49348 Mtetra
.844 .923 .884 r
.56524 .49348 .56871 .49204 .57162 .48886 .56816 .4903 Mtetra
.864 .842 .822 r
.56816 .4903 .57162 .48886 .57453 .48452 .57107 .48596 Mtetra
.863 .812 .797 r
.57107 .48596 .57453 .48452 .57742 .47959 .57397 .48102 Mtetra
.864 .82 .804 r
.57397 .48102 .57742 .47959 .58033 .47482 .57687 .47624 Mtetra
.86 .875 .848 r
.57687 .47624 .58033 .47482 .58324 .471 .57979 .47242 Mtetra
.757 .979 .916 r
.57979 .47242 .58324 .471 .58618 .46866 .58273 .47008 Mtetra
0 0 0 r
.58273 .47008 .58618 .46866 .58915 .46774 .5857 .46916 Mtetra
.191 0 0 r
.5857 .46916 .58915 .46774 .59213 .4673 .58868 .46872 Mtetra
.531 .921 .832 r
.58868 .46872 .59213 .4673 .5951 .46563 .59165 .46705 Mtetra
.828 .946 .899 r
.59165 .46705 .5951 .46563 .59805 .4627 .5946 .46412 Mtetra
.532 .922 .833 r
.5946 .46412 .59805 .4627 .60102 .46102 .59758 .46244 Mtetra
.188 0 0 r
.59758 .46244 .60102 .46102 .60403 .46057 .60058 .46199 Mtetra
0 0 0 r
.60058 .46199 .60403 .46057 .60703 .45965 .60358 .46106 Mtetra
.755 .98 .915 r
.60358 .46106 .60703 .45965 .61 .45728 .60655 .4587 Mtetra
.861 .878 .849 r
.60655 .4587 .61 .45728 .61295 .45342 .6095 .45484 Mtetra
.865 .822 .805 r
.6095 .45484 .61295 .45342 .61588 .44861 .61244 .45002 Mtetra
.865 .815 .798 r
.61244 .45002 .61588 .44861 .61881 .44363 .61537 .44504 Mtetra
.865 .845 .823 r
.61537 .44504 .61881 .44363 .62175 .43925 .61831 .44065 Mtetra
.844 .924 .884 r
.61831 .44065 .62175 .43925 .62472 .43601 .62128 .43741 Mtetra
.583 .945 .861 r
.62128 .43741 .62472 .43601 .62773 .43421 .62429 .43561 Mtetra
.227 0 0 r
.62429 .43561 .62773 .43421 .63077 .43386 .62734 .43525 Mtetra
.535 .102 .165 r
.62734 .43525 .63077 .43386 .63385 .43471 .63042 .43611 Mtetra
.618 .227 .28 r
.63042 .43611 .63385 .43471 .63696 .43638 .63352 .43778 Mtetra
.639 .26 .31 r
.63352 .43778 .63696 .43638 .64008 .43836 .63665 .43977 Mtetra
.625 .238 .29 r
.63665 .43977 .64008 .43836 .64321 .44014 .63977 .44155 Mtetra
.564 .145 .204 r
.63977 .44155 .64321 .44014 .64633 .44124 .64289 .44265 Mtetra
.365 0 0 r
.64289 .44265 .64633 .44124 .64943 .44126 .64599 .44268 Mtetra
.294 .773 .674 r
.64599 .44268 .64943 .44126 .65249 .43996 .64905 .44138 Mtetra
.805 .966 .909 r
.64905 .44138 .65249 .43996 .65552 .43721 .65209 .43862 Mtetra
.866 .865 .836 r
.65209 .43862 .65552 .43721 .65852 .43301 .65508 .43442 Mtetra
.866 .8 .784 r
.65508 .43442 .65852 .43301 .66148 .42753 .65804 .42893 Mtetra
.862 .766 .754 r
.65804 .42893 .66148 .42753 .6644 .421 .66097 .4224 Mtetra
.859 .747 .739 r
.66097 .4224 .6644 .421 .66731 .41376 .66388 .41515 Mtetra
.857 .74 .733 r
.66388 .41515 .66731 .41376 .6702 .40618 .66678 .40755 Mtetra
.66678 .40755 .6702 .40618 .67309 .39863 .66968 .4 Mtetra
.859 .75 .741 r
.66968 .4 .67309 .39863 .676 .3915 .67258 .39286 Mtetra
.862 .769 .758 r
.67258 .39286 .676 .3915 .67892 .38513 .67551 .38648 Mtetra
.866 .805 .788 r
.67551 .38648 .67892 .38513 .68189 .37978 .67848 .38112 Mtetra
.864 .869 .84 r
.67848 .38112 .68189 .37978 .68489 .37567 .68148 .37701 Mtetra
.802 .965 .912 r
.68148 .37701 .68489 .37567 .68794 .37293 .68454 .37427 Mtetra
.311 .787 .697 r
.68454 .37427 .68794 .37293 .69105 .37162 .68764 .37296 Mtetra
.373 0 0 r
.68764 .37296 .69105 .37162 .69421 .37171 .6908 .37306 Mtetra
.591 .179 .229 r
.6908 .37306 .69421 .37171 .69742 .37311 .69402 .37445 Mtetra
.665 .297 .337 r
.69402 .37445 .69742 .37311 .70069 .37564 .69728 .37699 Mtetra
.698 .353 .389 r
.69728 .37699 .70069 .37564 .70399 .37909 .70059 .38045 Mtetra
.714 .382 .415 r
.70059 .38045 .70399 .37909 .70734 .3832 .70393 .38456 Mtetra
.721 .395 .426 r
.70393 .38456 .70734 .3832 .71071 .38767 .70729 .38905 Mtetra
.722 .396 .428 r
.70729 .38905 .71071 .38767 .71409 .39221 .71067 .39359 Mtetra
.717 .387 .419 r
.71067 .39359 .71409 .39221 .71747 .3965 .71405 .39789 Mtetra
.704 .365 .399 r
.71405 .39789 .71747 .3965 .72085 .40025 .71743 .40165 Mtetra
.679 .321 .36 r
.71743 .40165 .72085 .40025 .7242 .4032 .72078 .4046 Mtetra
.627 .236 .283 r
.72078 .4046 .7242 .4032 .72753 .4051 .7241 .4065 Mtetra
.499 .047 .11 r
.7241 .4065 .72753 .4051 .73081 .40578 .72738 .40718 Mtetra
.086 0 0 r
.72738 .40718 .73081 .40578 .73404 .40509 .73061 .4065 Mtetra
.654 .97 .886 r
.73061 .4065 .73404 .40509 .73721 .40296 .73379 .40437 Mtetra
.854 .921 .874 r
.73379 .40437 .73721 .40296 .74033 .39937 .73691 .40077 Mtetra
.872 .835 .806 r
.73691 .40077 .74033 .39937 .74339 .39435 .73997 .39575 Mtetra
.869 .782 .763 r
.73997 .39575 .74339 .39435 .74638 .38799 .74297 .38938 Mtetra
.864 .75 .736 r
.74297 .38938 .74638 .38799 .74933 .38043 .74592 .38181 Mtetra
.86 .73 .719 r
.74592 .38181 .74933 .38043 .75222 .37184 .74882 .37321 Mtetra
.857 .717 .708 r
.74882 .37321 .75222 .37184 .75508 .36245 .75168 .36381 Mtetra
.855 .709 .701 r
.75168 .36381 .75508 .36245 .7579 .35248 .75451 .35382 Mtetra
.854 .705 .697 r
.75451 .35382 .7579 .35248 .76071 .34218 .75732 .34351 Mtetra
.853 .704 .697 r
.75732 .34351 .76071 .34218 .76351 .33181 .76012 .33313 Mtetra
.854 .706 .698 r
.76012 .33313 .76351 .33181 .76631 .32163 .76293 .32294 Mtetra
.855 .712 .703 r
.76293 .32294 .76631 .32163 .76912 .31189 .76575 .31318 Mtetra
.857 .721 .711 r
.76575 .31318 .76912 .31189 .77197 .3028 .7686 .30408 Mtetra
.86 .735 .723 r
.7686 .30408 .77197 .3028 .77486 .29457 .77149 .29585 Mtetra
.864 .757 .742 r
.77149 .29585 .77486 .29457 .77779 .28739 .77443 .28865 Mtetra
.869 .791 .772 r
.77443 .28865 .77779 .28739 .78079 .28138 .77743 .28264 Mtetra
.869 .845 .818 r
.77743 .28264 .78079 .28138 .78385 .27668 .7805 .27793 Mtetra
.841 .931 .888 r
.7805 .27793 .78385 .27668 .78699 .27334 .78364 .27459 Mtetra
.602 .952 .88 r
.78364 .27459 .78699 .27334 .79021 .27141 .78686 .27266 Mtetra
.133 0 0 r
.78686 .27266 .79021 .27141 .7935 .27089 .79015 .27214 Mtetra
.517 .061 .109 r
.79015 .27214 .7935 .27089 .79688 .27175 .79353 .273 Mtetra
.642 .247 .281 r
.79353 .273 .79688 .27175 .80034 .27391 .79699 .27517 Mtetra
.694 .335 .362 r
.79699 .27517 .80034 .27391 .80388 .27729 .80052 .27856 Mtetra
.721 .383 .405 r
.80052 .27856 .80388 .27729 .80749 .28175 .80413 .28303 Mtetra
.736 .411 .432 r
.80413 .28303 .80749 .28175 .81116 .28715 .8078 .28843 Mtetra
.745 .429 .448 r
.8078 .28843 .81116 .28715 .81489 .29329 .81153 .29458 Mtetra
.751 .44 .458 r
.81153 .29458 .81489 .29329 .81867 .29999 .81531 .30129 Mtetra
.754 .446 .463 r
.81531 .30129 .81867 .29999 .82249 .30704 .81912 .30835 Mtetra
.755 .448 .464 r
.81912 .30835 .82249 .30704 .82633 .31422 .82296 .31554 Mtetra
.754 .445 .463 r
.82296 .31554 .82633 .31422 .83018 .32131 .82681 .32265 Mtetra
.733 .473 .535 r
.37966 .59648 .38318 .594 .3857 .60099 .38217 .60349 Mtetra
.734 .475 .536 r
.38217 .60349 .3857 .60099 .38822 .60814 .38469 .61065 Mtetra
.734 .473 .535 r
.38469 .61065 .38822 .60814 .39076 .61522 .38723 .61775 Mtetra
.731 .469 .532 r
.38723 .61775 .39076 .61522 .39331 .62203 .38978 .62457 Mtetra
.727 .461 .526 r
.38978 .62457 .39331 .62203 .39588 .62835 .39234 .6309 Mtetra
.719 .449 .517 r
.39234 .6309 .39588 .62835 .39848 .63398 .39493 .63655 Mtetra
.707 .43 .502 r
.39493 .63655 .39848 .63398 .4011 .63874 .39755 .64132 Mtetra
.688 .399 .479 r
.39755 .64132 .4011 .63874 .40374 .64246 .40019 .64505 Mtetra
.655 .348 .44 r
.40019 .64505 .40374 .64246 .40642 .645 .40286 .64759 Mtetra
.589 .251 .365 r
.40286 .64759 .40642 .645 .40911 .64625 .40556 .64884 Mtetra
.423 .03 .187 r
.40556 .64884 .40911 .64625 .41184 .64612 .40828 .64871 Mtetra
0 0 0 r
.40828 .64871 .41184 .64612 .41459 .64457 .41103 .64717 Mtetra
.808 1 .826 r
.41103 .64717 .41459 .64457 .41736 .64161 .41381 .64421 Mtetra
.902 .909 .819 r
.41381 .64421 .41736 .64161 .42015 .63728 .4166 .63987 Mtetra
.893 .828 .775 r
.4166 .63987 .42015 .63728 .42295 .63164 .41941 .63423 Mtetra
.881 .78 .746 r
.41941 .63423 .42295 .63164 .42578 .62483 .42224 .6274 Mtetra
.871 .751 .728 r
.42224 .6274 .42578 .62483 .42861 .61699 .42507 .61956 Mtetra
.864 .733 .716 r
.42507 .61956 .42861 .61699 .43145 .60831 .42792 .61087 Mtetra
.86 .722 .709 r
.42792 .61087 .43145 .60831 .43429 .59901 .43077 .60154 Mtetra
.858 .716 .704 r
.43077 .60154 .43429 .59901 .43714 .5893 .43362 .59182 Mtetra
.857 .713 .703 r
.43362 .59182 .43714 .5893 .43998 .57944 .43647 .58195 Mtetra
.857 .714 .703 r
.43647 .58195 .43998 .57944 .44282 .56967 .43931 .57217 Mtetra
.859 .719 .707 r
.43931 .57217 .44282 .56967 .44565 .56025 .44215 .56273 Mtetra
.863 .729 .713 r
.44215 .56273 .44565 .56025 .44847 .5514 .44497 .55388 Mtetra
.868 .745 .724 r
.44497 .55388 .44847 .5514 .45128 .54335 .44779 .54581 Mtetra
.877 .77 .74 r
.44779 .54581 .45128 .54335 .45409 .53629 .4506 .53874 Mtetra
.889 .811 .766 r
.4506 .53874 .45409 .53629 .45688 .53038 .4534 .53282 Mtetra
.899 .881 .807 r
.4534 .53282 .45688 .53038 .45967 .52574 .45619 .52818 Mtetra
.86 .985 .847 r
.45619 .52818 .45967 .52574 .46245 .52245 .45897 .52489 Mtetra
0 0 0 r
.45897 .52489 .46245 .52245 .46523 .52055 .46175 .52298 Mtetra
.314 0 .06 r
.46175 .52298 .46523 .52055 .468 .52001 .46452 .52245 Mtetra
.546 .183 .304 r
.46452 .52245 .468 .52001 .47077 .52077 .46729 .52321 Mtetra
.63 .303 .399 r
.46729 .52321 .47077 .52077 .47355 .52271 .47007 .52516 Mtetra
.669 .362 .445 r
.47007 .52516 .47355 .52271 .47632 .52566 .47284 .52811 Mtetra
.689 .394 .47 r
.47284 .52811 .47632 .52566 .47911 .52941 .47563 .53187 Mtetra
.7 .411 .483 r
.47563 .53187 .47911 .52941 .4819 .5337 .47842 .53618 Mtetra
.705 .418 .488 r
.47842 .53618 .4819 .5337 .4847 .53827 .48121 .54075 Mtetra
.704 .417 .487 r
.48121 .54075 .4847 .53827 .48751 .54281 .48402 .5453 Mtetra
.698 .407 .48 r
.48402 .5453 .48751 .54281 .49034 .54702 .48684 .54952 Mtetra
.684 .386 .464 r
.48684 .54952 .49034 .54702 .49317 .5506 .48967 .55311 Mtetra
.659 .347 .433 r
.48967 .55311 .49317 .5506 .49601 .5533 .49251 .55582 Mtetra
.607 .271 .374 r
.49251 .55582 .49601 .5533 .49886 .55487 .49536 .5574 Mtetra
.487 .106 .243 r
.49536 .5574 .49886 .55487 .50171 .55516 .49822 .55768 Mtetra
.117 0 0 r
.49822 .55768 .50171 .55516 .50457 .55404 .50107 .55656 Mtetra
.66 .958 .747 r
.50107 .55656 .50457 .55404 .50743 .55148 .50394 .55401 Mtetra
.894 .953 .834 r
.50394 .55401 .50743 .55148 .51029 .54755 .5068 .55007 Mtetra
.903 .865 .793 r
.5068 .55007 .51029 .54755 .51315 .54237 .50966 .54488 Mtetra
.893 .813 .762 r
.50966 .54488 .51315 .54237 .516 .53616 .51252 .53867 Mtetra
.886 .786 .745 r
.51252 .53867 .516 .53616 .51886 .52921 .51537 .53171 Mtetra
.882 .773 .737 r
.51537 .53171 .51886 .52921 .5217 .52185 .51823 .52434 Mtetra
.882 .772 .737 r
.51823 .52434 .5217 .52185 .52455 .51446 .52108 .51694 Mtetra
.885 .782 .743 r
.52108 .51694 .52455 .51446 .5274 .50742 .52393 .50988 Mtetra
.892 .808 .759 r
.52393 .50988 .5274 .50742 .53025 .50108 .52678 .50354 Mtetra
.901 .856 .788 r
.52678 .50354 .53025 .50108 .5331 .49577 .52964 .49822 Mtetra
.897 .943 .832 r
.52964 .49822 .5331 .49577 .53597 .49172 .53251 .49417 Mtetra
.7 .976 .776 r
.53251 .49417 .53597 .49172 .53885 .48907 .53539 .49152 Mtetra
.059 0 0 r
.53539 .49152 .53885 .48907 .54174 .48785 .53828 .49029 Mtetra
.452 .056 .198 r
.53828 .49029 .54174 .48785 .54465 .48792 .54119 .49037 Mtetra
.575 .22 .33 r
.54119 .49037 .54465 .48792 .54758 .48905 .54412 .49151 Mtetra
.619 .283 .38 r
.54412 .49151 .54758 .48905 .55051 .49086 .54706 .49332 Mtetra
.63 .299 .392 r
.54706 .49332 .55051 .49086 .55346 .49288 .55 .49534 Mtetra
.614 .275 .374 r
.55 .49534 .55346 .49288 .55641 .4946 .55295 .49707 Mtetra
.556 .194 .309 r
.55295 .49707 .55641 .4946 .55937 .49551 .55591 .49799 Mtetra
.381 0 .127 r
.55591 .49799 .55937 .49551 .56231 .49522 .55885 .4977 Mtetra
0 0 0 r
.55885 .4977 .56231 .49522 .56524 .49348 .56178 .49596 Mtetra
.819 1 .828 r
.56178 .49596 .56524 .49348 .56816 .4903 .56471 .49277 Mtetra
.903 .93 .823 r
.56471 .49277 .56816 .4903 .57107 .48596 .56761 .48843 Mtetra
.906 .889 .803 r
.56761 .48843 .57107 .48596 .57397 .48102 .57052 .48348 Mtetra
.906 .899 .809 r
.57052 .48348 .57397 .48102 .57687 .47624 .57342 .4787 Mtetra
.885 .968 .837 r
.57342 .4787 .57687 .47624 .57979 .47242 .57634 .47487 Mtetra
.541 .894 .671 r
.57634 .47487 .57979 .47242 .58273 .47008 .57929 .47253 Mtetra
.202 0 0 r
.57929 .47253 .58273 .47008 .5857 .46916 .58226 .47161 Mtetra
.345 0 .087 r
.58226 .47161 .5857 .46916 .58868 .46872 .58524 .47117 Mtetra
0 0 0 r
.58524 .47117 .58868 .46872 .59165 .46705 .58821 .4695 Mtetra
.757 .993 .802 r
.58821 .4695 .59165 .46705 .5946 .46412 .59116 .46657 Mtetra
0 0 0 r
.59116 .46657 .5946 .46412 .59758 .46244 .59414 .46489 Mtetra
.343 0 .085 r
.59414 .46489 .59758 .46244 .60058 .46199 .59714 .46444 Mtetra
.2 0 0 r
.59714 .46444 .60058 .46199 .60358 .46106 .60014 .46352 Mtetra
.536 .89 .666 r
.60014 .46352 .60358 .46106 .60655 .4587 .60312 .46115 Mtetra
.885 .971 .836 r
.60312 .46115 .60655 .4587 .6095 .45484 .60607 .45729 Mtetra
.908 .903 .808 r
.60607 .45729 .6095 .45484 .61244 .45002 .60901 .45247 Mtetra
.908 .892 .803 r
.60901 .45247 .61244 .45002 .61537 .44504 .61194 .44748 Mtetra
.903 .933 .823 r
.61194 .44748 .61537 .44504 .61831 .44065 .61489 .44308 Mtetra
.818 1 .827 r
.61489 .44308 .61831 .44065 .62128 .43741 .61786 .43984 Mtetra
0 0 0 r
.61786 .43984 .62128 .43741 .62429 .43561 .62087 .43804 Mtetra
.365 0 .102 r
.62087 .43804 .62429 .43561 .62734 .43525 .62392 .43768 Mtetra
.546 .177 .291 r
.62392 .43768 .62734 .43525 .63042 .43611 .627 .43855 Mtetra
.607 .261 .358 r
.627 .43855 .63042 .43611 .63352 .43778 .6301 .44022 Mtetra
.624 .286 .377 r
.6301 .44022 .63352 .43778 .63665 .43977 .63322 .44222 Mtetra
.613 .27 .364 r
.63322 .44222 .63665 .43977 .63977 .44155 .63635 .444 Mtetra
.567 .204 .313 r
.63635 .444 .63977 .44155 .64289 .44265 .63947 .44511 Mtetra
.441 .04 .181 r
.63947 .44511 .64289 .44265 .64599 .44268 .64256 .44514 Mtetra
.058 0 0 r
.64256 .44514 .64599 .44268 .64905 .44138 .64563 .44384 Mtetra
.673 .963 .751 r
.64563 .44384 .64905 .44138 .65209 .43862 .64867 .44108 Mtetra
.897 .956 .829 r
.64867 .44108 .65209 .43862 .65508 .43442 .65167 .43688 Mtetra
.909 .872 .788 r
.65167 .43688 .65508 .43442 .65804 .42893 .65463 .43138 Mtetra
.902 .822 .759 r
.65463 .43138 .65804 .42893 .66097 .4224 .65756 .42484 Mtetra
.895 .795 .743 r
.65756 .42484 .66097 .4224 .66388 .41515 .66048 .41758 Mtetra
.892 .785 .736 r
.66048 .41758 .66388 .41515 .66678 .40755 .66338 .40997 Mtetra
.892 .786 .736 r
.66338 .40997 .66678 .40755 .66968 .4 .66628 .40241 Mtetra
.896 .799 .745 r
.66628 .40241 .66968 .4 .67258 .39286 .66919 .39526 Mtetra
.903 .827 .762 r
.66919 .39526 .67258 .39286 .67551 .38648 .67213 .38887 Mtetra
.909 .878 .793 r
.67213 .38887 .67551 .38648 .67848 .38112 .6751 .38351 Mtetra
.893 .961 .832 r
.6751 .38351 .67848 .38112 .68148 .37701 .6781 .37939 Mtetra
.671 .963 .756 r
.6781 .37939 .68148 .37701 .68454 .37427 .68116 .37665 Mtetra
.046 0 0 r
.68116 .37665 .68454 .37427 .68764 .37296 .68427 .37534 Mtetra
.447 .042 .177 r
.68427 .37534 .68764 .37296 .6908 .37306 .68743 .37544 Mtetra
.587 .228 .326 r
.68743 .37544 .6908 .37306 .69402 .37445 .69064 .37684 Mtetra
.647 .314 .394 r
.69064 .37684 .69402 .37445 .69728 .37699 .6939 .37938 Mtetra
.677 .359 .428 r
.6939 .37938 .69728 .37699 .70059 .38045 .69721 .38285 Mtetra
.692 .383 .447 r
.69721 .38285 .70059 .38045 .70393 .38456 .70055 .38697 Mtetra
.699 .394 .455 r
.70055 .38697 .70393 .38456 .70729 .38905 .70391 .39146 Mtetra
.7 .395 .456 r
.70391 .39146 .70729 .38905 .71067 .39359 .70729 .39602 Mtetra
.695 .387 .45 r
.70729 .39602 .71067 .39359 .71405 .39789 .71067 .40033 Mtetra
.683 .368 .436 r
.71067 .40033 .71405 .39789 .71743 .40165 .71404 .4041 Mtetra
.659 .333 .409 r
.71404 .4041 .71743 .40165 .72078 .4046 .71739 .40705 Mtetra
.615 .268 .359 r
.71739 .40705 .72078 .4046 .7241 .4065 .72071 .40897 Mtetra
.523 .142 .26 r
.72071 .40897 .7241 .4065 .72738 .40718 .72399 .40965 Mtetra
.289 0 .027 r
.72399 .40965 .72738 .40718 .73061 .4065 .72723 .40896 Mtetra
0 0 0 r
.72723 .40896 .73061 .4065 .73379 .40437 .7304 .40683 Mtetra
.836 .999 .821 r
.7304 .40683 .73379 .40437 .73691 .40077 .73352 .40323 Mtetra
.914 .918 .806 r
.73352 .40323 .73691 .40077 .73997 .39575 .73659 .3982 Mtetra
.911 .845 .766 r
.73659 .3982 .73997 .39575 .74297 .38938 .73959 .39183 Mtetra
.901 .799 .739 r
.73959 .39183 .74297 .38938 .74592 .38181 .74255 .38425 Mtetra
.892 .771 .72 r
.74255 .38425 .74592 .38181 .74882 .37321 .74545 .37564 Mtetra
.886 .753 .709 r
.74545 .37564 .74882 .37321 .75168 .36381 .74832 .36622 Mtetra
.883 .742 .702 r
.74832 .36622 .75168 .36381 .75451 .35382 .75116 .35622 Mtetra
.881 .736 .698 r
.75116 .35622 .75451 .35382 .75732 .34351 .75397 .34589 Mtetra
.88 .735 .697 r
.75397 .34589 .75732 .34351 .76012 .33313 .75678 .3355 Mtetra
.881 .738 .699 r
.75678 .3355 .76012 .33313 .76293 .32294 .75959 .32529 Mtetra
.884 .745 .704 r
.75959 .32529 .76293 .32294 .76575 .31318 .76242 .31552 Mtetra
.888 .757 .712 r
.76242 .31552 .76575 .31318 .7686 .30408 .76528 .30641 Mtetra
.894 .777 .725 r
.76528 .30641 .7686 .30408 .77149 .29585 .76817 .29816 Mtetra
.903 .808 .745 r
.76817 .29816 .77149 .29585 .77443 .28865 .77112 .29096 Mtetra
.911 .857 .775 r
.77112 .29096 .77443 .28865 .77743 .28264 .77412 .28494 Mtetra
.908 .932 .816 r
.77412 .28494 .77743 .28264 .7805 .27793 .77719 .28022 Mtetra
.803 1 .821 r
.77719 .28022 .7805 .27793 .78364 .27459 .78033 .27687 Mtetra
0 0 0 r
.78033 .27687 .78364 .27459 .78686 .27266 .78355 .27494 Mtetra
.317 0 .032 r
.78355 .27494 .78686 .27266 .79015 .27214 .78685 .27443 Mtetra
.537 .151 .256 r
.78685 .27443 .79015 .27214 .79353 .273 .79023 .27529 Mtetra
.628 .276 .356 r
.79023 .27529 .79353 .273 .79699 .27517 .79369 .27747 Mtetra
.673 .344 .408 r
.79369 .27747 .79699 .27517 .80052 .27856 .79722 .28086 Mtetra
.699 .383 .439 r
.79722 .28086 .80052 .27856 .80413 .28303 .80083 .28534 Mtetra
.715 .409 .458 r
.80083 .28534 .80413 .28303 .8078 .28843 .8045 .29075 Mtetra
.725 .425 .47 r
.8045 .29075 .8078 .28843 .81153 .29458 .80822 .29692 Mtetra
.731 .435 .478 r
.80822 .29692 .81153 .29458 .81531 .30129 .812 .30364 Mtetra
.734 .44 .482 r
.812 .30364 .81531 .30129 .81912 .30835 .81581 .31072 Mtetra
.735 .442 .483 r
.81581 .31072 .81912 .30835 .82296 .31554 .81964 .31793 Mtetra
.734 .44 .482 r
.81964 .31793 .82296 .31554 .82681 .32265 .82349 .32505 Mtetra
.723 .468 .54 r
.37612 .5997 .37966 .59648 .38217 .60349 .37863 .60673 Mtetra
.724 .469 .541 r
.37863 .60673 .38217 .60349 .38469 .61065 .38114 .6139 Mtetra
.723 .468 .54 r
.38114 .6139 .38469 .61065 .38723 .61775 .38367 .62102 Mtetra
.72 .464 .538 r
.38367 .62102 .38723 .61775 .38978 .62457 .38622 .62785 Mtetra
.715 .456 .533 r
.38622 .62785 .38978 .62457 .39234 .6309 .38878 .6342 Mtetra
.707 .444 .524 r
.38878 .6342 .39234 .6309 .39493 .63655 .39137 .63986 Mtetra
.695 .426 .512 r
.39137 .63986 .39493 .63655 .39755 .64132 .39398 .64465 Mtetra
.676 .397 .492 r
.39398 .64465 .39755 .64132 .40019 .64505 .39662 .64839 Mtetra
.643 .351 .46 r
.39662 .64839 .40019 .64505 .40286 .64759 .39929 .65094 Mtetra
.583 .269 .402 r
.39929 .65094 .40286 .64759 .40556 .64884 .40199 .65219 Mtetra
.451 .1 .278 r
.40199 .65219 .40556 .64884 .40828 .64871 .40471 .65207 Mtetra
.081 0 0 r
.40471 .65207 .40828 .64871 .41103 .64717 .40746 .65052 Mtetra
.662 .931 .648 r
.40746 .65052 .41103 .64717 .41381 .64421 .41024 .64756 Mtetra
.915 .965 .797 r
.41024 .64756 .41381 .64421 .4166 .63987 .41303 .64321 Mtetra
.922 .876 .773 r
.41303 .64321 .4166 .63987 .41941 .63423 .41585 .63756 Mtetra
.907 .817 .747 r
.41585 .63756 .41941 .63423 .42224 .6274 .41868 .63073 Mtetra
.894 .781 .729 r
.41868 .63073 .42224 .6274 .42507 .61956 .42152 .62287 Mtetra
.885 .758 .717 r
.42152 .62287 .42507 .61956 .42792 .61087 .42437 .61417 Mtetra
.879 .744 .709 r
.42437 .61417 .42792 .61087 .43077 .60154 .42723 .60483 Mtetra
.876 .737 .705 r
.42723 .60483 .43077 .60154 .43362 .59182 .43008 .5951 Mtetra
.874 .734 .703 r
.43008 .5951 .43362 .59182 .43647 .58195 .43294 .58521 Mtetra
.875 .735 .704 r
.43294 .58521 .43647 .58195 .43931 .57217 .43579 .57541 Mtetra
.878 .741 .707 r
.43579 .57541 .43931 .57217 .44215 .56273 .43863 .56596 Mtetra
.883 .753 .714 r
.43863 .56596 .44215 .56273 .44497 .55388 .44146 .55709 Mtetra
.891 .772 .725 r
.44146 .55709 .44497 .55388 .44779 .54581 .44429 .54902 Mtetra
.902 .804 .741 r
.44429 .54902 .44779 .54581 .4506 .53874 .4471 .54193 Mtetra
.917 .855 .766 r
.4471 .54193 .4506 .53874 .4534 .53282 .4499 .53601 Mtetra
.922 .938 .796 r
.4499 .53601 .4534 .53282 .45619 .52818 .45269 .53136 Mtetra
.79 .989 .745 r
.45269 .53136 .45619 .52818 .45897 .52489 .45548 .52806 Mtetra
0 0 0 r
.45548 .52806 .45897 .52489 .46175 .52298 .45826 .52616 Mtetra
.374 0 .194 r
.45826 .52616 .46175 .52298 .46452 .52245 .46103 .52562 Mtetra
.547 .215 .357 r
.46103 .52562 .46452 .52245 .46729 .52321 .4638 .52639 Mtetra
.62 .312 .427 r
.4638 .52639 .46729 .52321 .47007 .52516 .46658 .52834 Mtetra
.657 .364 .464 r
.46658 .52834 .47007 .52516 .47284 .52811 .46935 .53131 Mtetra
.677 .393 .484 r
.46935 .53131 .47284 .52811 .47563 .53187 .47213 .53508 Mtetra
.688 .409 .495 r
.47213 .53508 .47563 .53187 .47842 .53618 .47492 .53939 Mtetra
.692 .415 .499 r
.47492 .53939 .47842 .53618 .48121 .54075 .47772 .54398 Mtetra
.691 .414 .499 r
.47772 .54398 .48121 .54075 .48402 .5453 .48052 .54854 Mtetra
.685 .405 .492 r
.48052 .54854 .48402 .5453 .48684 .54952 .48334 .55277 Mtetra
.672 .385 .479 r
.48334 .55277 .48684 .54952 .48967 .55311 .48617 .55638 Mtetra
.647 .35 .454 r
.48617 .55638 .48967 .55311 .49251 .55582 .48901 .55909 Mtetra
.599 .285 .409 r
.48901 .55909 .49251 .55582 .49536 .5574 .49185 .56068 Mtetra
.5 .155 .314 r
.49185 .56068 .49536 .5574 .49822 .55768 .49471 .56096 Mtetra
.241 0 .081 r
.49471 .56096 .49822 .55768 .50107 .55656 .49757 .55985 Mtetra
0 0 0 r
.49757 .55985 .50107 .55656 .50394 .55401 .50043 .55729 Mtetra
.875 .994 .78 r
.50043 .55729 .50394 .55401 .5068 .55007 .5033 .55335 Mtetra
.928 .919 .784 r
.5033 .55335 .5068 .55007 .50966 .54488 .50616 .54815 Mtetra
.922 .858 .761 r
.50616 .54815 .50966 .54488 .51252 .53867 .50902 .54193 Mtetra
.912 .823 .745 r
.50902 .54193 .51252 .53867 .51537 .53171 .51188 .53496 Mtetra
.907 .808 .737 r
.51188 .53496 .51537 .53171 .51823 .52434 .51474 .52758 Mtetra
.907 .806 .737 r
.51474 .52758 .51823 .52434 .52108 .51694 .5176 .52017 Mtetra
.911 .819 .743 r
.5176 .52017 .52108 .51694 .52393 .50988 .52045 .5131 Mtetra
.92 .85 .758 r
.52045 .5131 .52393 .50988 .52678 .50354 .52331 .50675 Mtetra
.928 .909 .782 r
.52331 .50675 .52678 .50354 .52964 .49822 .52618 .50143 Mtetra
.888 .99 .788 r
.52618 .50143 .52964 .49822 .53251 .49417 .52905 .49737 Mtetra
0 0 0 r
.52905 .49737 .53251 .49417 .53539 .49152 .53193 .49472 Mtetra
.203 0 .04 r
.53193 .49472 .53539 .49152 .53828 .49029 .53482 .49349 Mtetra
.473 .119 .283 r
.53482 .49349 .53828 .49029 .54119 .49037 .53773 .49357 Mtetra
.571 .244 .375 r
.53773 .49357 .54119 .49037 .54412 .49151 .54066 .49471 Mtetra
.61 .296 .412 r
.54066 .49471 .54412 .49151 .54706 .49332 .54359 .49653 Mtetra
.62 .309 .422 r
.54359 .49653 .54706 .49332 .55 .49534 .54654 .49856 Mtetra
.605 .289 .408 r
.54654 .49856 .55 .49534 .55295 .49707 .54949 .50029 Mtetra
.555 .223 .36 r
.54949 .50029 .55295 .49707 .55591 .49799 .55244 .50122 Mtetra
.422 .057 .237 r
.55244 .50122 .55591 .49799 .55885 .4977 .55539 .50093 Mtetra
.024 0 0 r
.55539 .50093 .55885 .4977 .56178 .49596 .55833 .49919 Mtetra
.682 .941 .661 r
.55833 .49919 .56178 .49596 .56471 .49277 .56125 .496 Mtetra
.904 .981 .788 r
.56125 .496 .56471 .49277 .56761 .48843 .56416 .49165 Mtetra
.927 .944 .788 r
.56416 .49165 .56761 .48843 .57052 .48348 .56707 .4867 Mtetra
.923 .955 .789 r
.56707 .4867 .57052 .48348 .57342 .4787 .56998 .48192 Mtetra
.847 .996 .764 r
.56998 .48192 .57342 .4787 .57634 .47487 .5729 .47808 Mtetra
0 0 0 r
.5729 .47808 .57634 .47487 .57929 .47253 .57585 .47574 Mtetra
.298 0 .123 r
.57585 .47574 .57929 .47253 .58226 .47161 .57882 .47482 Mtetra
.396 .025 .211 r
.57882 .47482 .58226 .47161 .58524 .47117 .5818 .47439 Mtetra
.057 0 0 r
.5818 .47439 .58524 .47117 .58821 .4695 .58477 .47272 Mtetra
.565 .872 .578 r
.58477 .47272 .58821 .4695 .59116 .46657 .58772 .46978 Mtetra
.056 0 0 r
.58772 .46978 .59116 .46657 .59414 .46489 .5907 .4681 Mtetra
.395 .023 .209 r
.5907 .4681 .59414 .46489 .59714 .46444 .59371 .46766 Mtetra
.298 0 .122 r
.59371 .46766 .59714 .46444 .60014 .46352 .59671 .46673 Mtetra
0 0 0 r
.59671 .46673 .60014 .46352 .60312 .46115 .59969 .46437 Mtetra
.842 .996 .759 r
.59969 .46437 .60312 .46115 .60607 .45729 .60264 .4605 Mtetra
.923 .958 .787 r
.60264 .4605 .60607 .45729 .60901 .45247 .60558 .45567 Mtetra
.927 .948 .786 r
.60558 .45567 .60901 .45247 .61194 .44748 .60852 .45067 Mtetra
.902 .983 .785 r
.60852 .45067 .61194 .44748 .61489 .44308 .61147 .44627 Mtetra
.68 .94 .658 r
.61147 .44627 .61489 .44308 .61786 .43984 .61445 .44303 Mtetra
.009 0 0 r
.61445 .44303 .61786 .43984 .62087 .43804 .61746 .44122 Mtetra
.41 .039 .22 r
.61746 .44122 .62087 .43804 .62392 .43768 .6205 .44087 Mtetra
.548 .21 .347 r
.6205 .44087 .62392 .43768 .627 .43855 .62358 .44174 Mtetra
.6 .277 .395 r
.62358 .44174 .627 .43855 .6301 .44022 .62669 .44343 Mtetra
.615 .298 .41 r
.62669 .44343 .6301 .44022 .63322 .44222 .62981 .44542 Mtetra
.605 .284 .4 r
.62981 .44542 .63322 .44222 .63635 .444 .63294 .44722 Mtetra
.565 .231 .363 r
.63294 .44722 .63635 .444 .63947 .44511 .63606 .44833 Mtetra
.466 .107 .271 r
.63606 .44833 .63947 .44511 .64256 .44514 .63915 .44836 Mtetra
.203 0 .04 r
.63915 .44836 .64256 .44514 .64563 .44384 .64222 .44706 Mtetra
0 0 0 r
.64222 .44706 .64563 .44384 .64867 .44108 .64526 .4443 Mtetra
.874 .994 .769 r
.64526 .4443 .64867 .44108 .65167 .43688 .64826 .44009 Mtetra
.934 .925 .776 r
.64826 .44009 .65167 .43688 .65463 .43138 .65123 .43459 Mtetra
.93 .867 .755 r
.65123 .43459 .65463 .43138 .65756 .42484 .65417 .42804 Mtetra
.923 .835 .741 r
.65417 .42804 .65756 .42484 .66048 .41758 .65709 .42077 Mtetra
.919 .821 .734 r
.65709 .42077 .66048 .41758 .66338 .40997 .65999 .41315 Mtetra
.919 .823 .735 r
.65999 .41315 .66338 .40997 .66628 .40241 .6629 .40558 Mtetra
.924 .839 .743 r
.6629 .40558 .66628 .40241 .66919 .39526 .66582 .39842 Mtetra
.931 .873 .758 r
.66582 .39842 .66919 .39526 .67213 .38887 .66876 .39201 Mtetra
.933 .933 .779 r
.66876 .39201 .67213 .38887 .6751 .38351 .67173 .38665 Mtetra
.865 .995 .767 r
.67173 .38665 .6751 .38351 .6781 .37939 .67474 .38252 Mtetra
0 0 0 r
.67474 .38252 .6781 .37939 .68116 .37665 .6778 .37978 Mtetra
.195 0 .025 r
.6778 .37978 .68116 .37665 .68427 .37534 .68091 .37847 Mtetra
.471 .109 .269 r
.68091 .37847 .68427 .37534 .68743 .37544 .68407 .37857 Mtetra
.582 .25 .372 r
.68407 .37857 .68743 .37544 .69064 .37684 .68728 .37998 Mtetra
.635 .321 .422 r
.68728 .37998 .69064 .37684 .6939 .37938 .69054 .38253 Mtetra
.664 .361 .45 r
.69054 .38253 .6939 .37938 .69721 .38285 .69385 .38601 Mtetra
.679 .382 .464 r
.69385 .38601 .69721 .38285 .70055 .38697 .69718 .39015 Mtetra
.686 .393 .471 r
.69718 .39015 .70055 .38697 .70391 .39146 .70055 .39465 Mtetra
.687 .394 .472 r
.70055 .39465 .70391 .39146 .70729 .39602 .70392 .39922 Mtetra
.682 .387 .467 r
.70392 .39922 .70729 .39602 .71067 .40033 .7073 .40354 Mtetra
.67 .369 .455 r
.7073 .40354 .71067 .40033 .71404 .4041 .71067 .40732 Mtetra
.647 .338 .434 r
.71067 .40732 .71404 .4041 .71739 .40705 .71402 .41028 Mtetra
.607 .283 .396 r
.71402 .41028 .71739 .40705 .72071 .40897 .71734 .41221 Mtetra
.529 .183 .325 r
.71734 .41221 .72071 .40897 .72399 .40965 .72063 .41289 Mtetra
.358 0 .172 r
.72063 .41289 .72399 .40965 .72723 .40896 .72386 .41221 Mtetra
0 0 0 r
.72386 .41221 .72723 .40896 .7304 .40683 .72704 .41008 Mtetra
.709 .949 .661 r
.72704 .41008 .7304 .40683 .73352 .40323 .73016 .40648 Mtetra
.922 .97 .774 r
.73016 .40648 .73352 .40323 .73659 .3982 .73323 .40144 Mtetra
.939 .894 .758 r
.73323 .40144 .73659 .3982 .73959 .39183 .73624 .39505 Mtetra
.929 .839 .735 r
.73624 .39505 .73959 .39183 .74255 .38425 .7392 .38746 Mtetra
.918 .804 .718 r
.7392 .38746 .74255 .38425 .74545 .37564 .74211 .37884 Mtetra
.91 .781 .707 r
.74211 .37884 .74545 .37564 .74832 .36622 .74498 .3694 Mtetra
.905 .768 .7 r
.74498 .3694 .74832 .36622 .75116 .35622 .74783 .35938 Mtetra
.902 .761 .696 r
.74783 .35938 .75116 .35622 .75397 .34589 .75065 .34904 Mtetra
.901 .759 .695 r
.75065 .34904 .75397 .34589 .75678 .3355 .75347 .33863 Mtetra
.903 .763 .697 r
.75347 .33863 .75678 .3355 .75959 .32529 .75629 .32841 Mtetra
.906 .772 .702 r
.75629 .32841 .75959 .32529 .76242 .31552 .75912 .31862 Mtetra
.912 .787 .71 r
.75912 .31862 .76242 .31552 .76528 .30641 .76198 .30949 Mtetra
.92 .812 .723 r
.76198 .30949 .76528 .30641 .76817 .29816 .76488 .30123 Mtetra
.931 .85 .741 r
.76488 .30123 .76817 .29816 .77112 .29096 .76783 .29401 Mtetra
.938 .908 .765 r
.76783 .29401 .77112 .29096 .77412 .28494 .77084 .28799 Mtetra
.907 .981 .777 r
.77084 .28799 .77412 .28494 .77719 .28022 .77391 .28326 Mtetra
.648 .922 .635 r
.77391 .28326 .77719 .28022 .78033 .27687 .77706 .27992 Mtetra
0 0 0 r
.77706 .27992 .78033 .27687 .78355 .27494 .78028 .27798 Mtetra
.378 0 .174 r
.78028 .27798 .78355 .27494 .78685 .27443 .78358 .27747 Mtetra
.541 .19 .321 r
.78358 .27747 .78685 .27443 .79023 .27529 .78696 .27834 Mtetra
.618 .29 .393 r
.78696 .27834 .79023 .27529 .79369 .27747 .79042 .28053 Mtetra
.66 .348 .433 r
.79042 .28053 .79369 .27747 .79722 .28086 .79395 .28393 Mtetra
.685 .383 .458 r
.79395 .28393 .79722 .28086 .80083 .28534 .79755 .28842 Mtetra
.701 .406 .473 r
.79755 .28842 .80083 .28534 .8045 .29075 .80122 .29385 Mtetra
.712 .421 .483 r
.80122 .29385 .8045 .29075 .80822 .29692 .80495 .30003 Mtetra
.718 .431 .49 r
.80495 .30003 .80822 .29692 .812 .30364 .80872 .30677 Mtetra
.722 .436 .493 r
.80872 .30677 .812 .30364 .81581 .31072 .81253 .31386 Mtetra
.723 .438 .494 r
.81253 .31386 .81581 .31072 .81964 .31793 .81636 .32109 Mtetra
.721 .436 .493 r
.81636 .32109 .81964 .31793 .82349 .32505 .8202 .32823 Mtetra
.718 .465 .543 r
.37256 .60333 .37612 .5997 .37863 .60673 .37506 .61037 Mtetra
.719 .467 .544 r
.37506 .61037 .37863 .60673 .38114 .6139 .37757 .61757 Mtetra
.718 .465 .543 r
.37757 .61757 .38114 .6139 .38367 .62102 .3801 .6247 Mtetra
.715 .461 .541 r
.3801 .6247 .38367 .62102 .38622 .62785 .38264 .63155 Mtetra
.71 .454 .536 r
.38264 .63155 .38622 .62785 .38878 .6342 .3852 .63792 Mtetra
.702 .442 .528 r
.3852 .63792 .38878 .6342 .39137 .63986 .38778 .64359 Mtetra
.689 .424 .517 r
.38778 .64359 .39137 .63986 .39398 .64465 .3904 .64839 Mtetra
.669 .396 .499 r
.3904 .64839 .39398 .64465 .39662 .64839 .39303 .65214 Mtetra
.637 .352 .469 r
.39303 .65214 .39662 .64839 .39929 .65094 .3957 .6547 Mtetra
.58 .276 .418 r
.3957 .6547 .39929 .65094 .40199 .65219 .3984 .65596 Mtetra
.461 .127 .313 r
.3984 .65596 .40199 .65219 .40471 .65207 .40112 .65584 Mtetra
.155 0 .051 r
.40112 .65584 .40471 .65207 .40746 .65052 .40387 .6543 Mtetra
.536 .833 .505 r
.40387 .6543 .40746 .65052 .41024 .64756 .40665 .65133 Mtetra
.905 .984 .766 r
.40665 .65133 .41024 .64756 .41303 .64321 .40945 .64698 Mtetra
.935 .902 .767 r
.40945 .64698 .41303 .64321 .41585 .63756 .41227 .64132 Mtetra
.921 .838 .745 r
.41227 .64132 .41585 .63756 .41868 .63073 .4151 .63448 Mtetra
.907 .798 .728 r
.4151 .63448 .41868 .63073 .42152 .62287 .41795 .62661 Mtetra
.897 .773 .717 r
.41795 .62661 .42152 .62287 .42437 .61417 .42081 .61789 Mtetra
.89 .758 .709 r
.42081 .61789 .42437 .61417 .42723 .60483 .42367 .60854 Mtetra
.886 .749 .705 r
.42367 .60854 .42723 .60483 .43008 .5951 .42653 .59879 Mtetra
.885 .746 .703 r
.42653 .59879 .43008 .5951 .43294 .58521 .42939 .58888 Mtetra
.885 .747 .704 r
.42939 .58888 .43294 .58521 .43579 .57541 .43225 .57907 Mtetra
.888 .754 .707 r
.43225 .57907 .43579 .57541 .43863 .56596 .4351 .5696 Mtetra
.894 .767 .714 r
.4351 .5696 .43863 .56596 .44146 .55709 .43794 .56072 Mtetra
.903 .789 .724 r
.43794 .56072 .44146 .55709 .44429 .54902 .44077 .55263 Mtetra
.916 .824 .74 r
.44077 .55263 .44429 .54902 .4471 .54193 .44358 .54554 Mtetra
.931 .88 .762 r
.44358 .54554 .4471 .54193 .4499 .53601 .44639 .5396 Mtetra
.925 .963 .778 r
.44639 .5396 .4499 .53601 .45269 .53136 .44919 .53494 Mtetra
.705 .942 .643 r
.44919 .53494 .45269 .53136 .45548 .52806 .45197 .53165 Mtetra
0 0 0 r
.45197 .53165 .45548 .52806 .45826 .52616 .45475 .52974 Mtetra
.396 .043 .245 r
.45475 .52974 .45826 .52616 .46103 .52562 .45753 .52921 Mtetra
.547 .228 .379 r
.45753 .52921 .46103 .52562 .4638 .52639 .4603 .52999 Mtetra
.615 .316 .44 r
.4603 .52999 .4638 .52639 .46658 .52834 .46307 .53194 Mtetra
.65 .364 .472 r
.46307 .53194 .46658 .52834 .46935 .53131 .46585 .53492 Mtetra
.67 .392 .491 r
.46585 .53492 .46935 .53131 .47213 .53508 .46863 .5387 Mtetra
.681 .407 .501 r
.46863 .5387 .47213 .53508 .47492 .53939 .47141 .54303 Mtetra
.686 .414 .505 r
.47141 .54303 .47492 .53939 .47772 .54398 .47421 .54763 Mtetra
.685 .413 .504 r
.47421 .54763 .47772 .54398 .48052 .54854 .47701 .5522 Mtetra
.679 .404 .498 r
.47701 .5522 .48052 .54854 .48334 .55277 .47983 .55644 Mtetra
.665 .385 .486 r
.47983 .55644 .48334 .55277 .48617 .55638 .48265 .56006 Mtetra
.641 .351 .464 r
.48265 .56006 .48617 .55638 .48901 .55909 .48549 .56278 Mtetra
.596 .291 .423 r
.48549 .56278 .48901 .55909 .49185 .56068 .48834 .56438 Mtetra
.504 .176 .343 r
.48834 .56438 .49185 .56068 .49471 .56096 .49119 .56467 Mtetra
.285 0 .155 r
.49119 .56467 .49471 .56096 .49757 .55985 .49405 .56355 Mtetra
0 0 0 r
.49405 .56355 .49757 .55985 .50043 .55729 .49692 .56099 Mtetra
.832 .987 .717 r
.49692 .56099 .50043 .55729 .5033 .55335 .49979 .55704 Mtetra
.936 .945 .77 r
.49979 .55704 .5033 .55335 .50616 .54815 .50266 .55185 Mtetra
.936 .882 .756 r
.50266 .55185 .50616 .54815 .50902 .54193 .50552 .54561 Mtetra
.927 .845 .743 r
.50552 .54561 .50902 .54193 .51188 .53496 .50839 .53863 Mtetra
.922 .828 .736 r
.50839 .53863 .51188 .53496 .51474 .52758 .51125 .53124 Mtetra
.921 .826 .735 r
.51125 .53124 .51474 .52758 .5176 .52017 .51411 .52382 Mtetra
.926 .84 .741 r
.51411 .52382 .5176 .52017 .52045 .5131 .51697 .51674 Mtetra
.934 .875 .754 r
.51697 .51674 .52045 .5131 .52331 .50675 .51983 .51038 Mtetra
.937 .936 .77 r
.51983 .51038 .52331 .50675 .52618 .50143 .5227 .50505 Mtetra
.855 .991 .734 r
.5227 .50505 .52618 .50143 .52905 .49737 .52558 .50098 Mtetra
0 0 0 r
.52558 .50098 .52905 .49737 .53193 .49472 .52846 .49833 Mtetra
.254 0 .123 r
.52846 .49833 .53193 .49472 .53482 .49349 .53136 .49711 Mtetra
.481 .144 .317 r
.53136 .49711 .53482 .49349 .53773 .49357 .53427 .49719 Mtetra
.569 .254 .394 r
.53427 .49719 .53773 .49357 .54066 .49471 .53719 .49834 Mtetra
.606 .301 .427 r
.53719 .49834 .54066 .49471 .54359 .49653 .54013 .50016 Mtetra
.615 .313 .435 r
.54013 .50016 .54359 .49653 .54654 .49856 .54307 .5022 Mtetra
.601 .295 .423 r
.54307 .5022 .54654 .49856 .54949 .50029 .54602 .50394 Mtetra
.555 .235 .382 r
.54602 .50394 .54949 .50029 .55244 .50122 .54898 .50487 Mtetra
.436 .091 .279 r
.54898 .50487 .55244 .50122 .55539 .50093 .55192 .50459 Mtetra
.108 0 .004 r
.55192 .50459 .55539 .50093 .55833 .49919 .55486 .50285 Mtetra
.561 .849 .522 r
.55486 .50285 .55833 .49919 .56125 .496 .55779 .49966 Mtetra
.881 .99 .743 r
.55779 .49966 .56125 .496 .56416 .49165 .5607 .4953 Mtetra
.927 .968 .765 r
.5607 .4953 .56416 .49165 .56707 .4867 .56361 .49034 Mtetra
.918 .976 .762 r
.56361 .49034 .56707 .4867 .56998 .48192 .56652 .48555 Mtetra
.786 .973 .684 r
.56652 .48555 .56998 .48192 .5729 .47808 .56945 .48171 Mtetra
0 0 0 r
.56945 .48171 .5729 .47808 .57585 .47574 .5724 .47937 Mtetra
.332 0 .189 r
.5724 .47937 .57585 .47574 .57882 .47482 .57537 .47846 Mtetra
.415 .064 .258 r
.57537 .47846 .57882 .47482 .5818 .47439 .57836 .47802 Mtetra
.135 0 .025 r
.57836 .47802 .5818 .47439 .58477 .47272 .58133 .47635 Mtetra
0 0 0 r
.58133 .47635 .58477 .47272 .58772 .46978 .58429 .47341 Mtetra
.135 0 .024 r
.58429 .47341 .58772 .46978 .5907 .4681 .58727 .47174 Mtetra
.414 .062 .257 r
.58727 .47174 .5907 .4681 .59371 .46766 .59027 .47129 Mtetra
.332 0 .188 r
.59027 .47129 .59371 .46766 .59671 .46673 .59327 .47037 Mtetra
0 0 0 r
.59327 .47037 .59671 .46673 .59969 .46437 .59626 .468 Mtetra
.779 .969 .675 r
.59626 .468 .59969 .46437 .60264 .4605 .59921 .46413 Mtetra
.917 .978 .758 r
.59921 .46413 .60264 .4605 .60558 .45567 .60216 .45929 Mtetra
.926 .97 .761 r
.60216 .45929 .60558 .45567 .60852 .45067 .6051 .45429 Mtetra
.877 .99 .738 r
.6051 .45429 .60852 .45067 .61147 .44627 .60805 .44988 Mtetra
.557 .847 .519 r
.60805 .44988 .61147 .44627 .61445 .44303 .61103 .44664 Mtetra
.096 0 0 r
.61103 .44664 .61445 .44303 .61746 .44122 .61404 .44483 Mtetra
.427 .076 .266 r
.61404 .44483 .61746 .44122 .6205 .44087 .61709 .44449 Mtetra
.548 .223 .37 r
.61709 .44449 .6205 .44087 .62358 .44174 .62017 .44536 Mtetra
.596 .284 .412 r
.62017 .44536 .62358 .44174 .62669 .44343 .62328 .44705 Mtetra
.61 .303 .424 r
.62328 .44705 .62669 .44343 .62981 .44542 .6264 .44906 Mtetra
.601 .29 .416 r
.6264 .44906 .62981 .44542 .63294 .44722 .62953 .45086 Mtetra
.563 .243 .383 r
.62953 .45086 .63294 .44722 .63606 .44833 .63264 .45197 Mtetra
.475 .133 .307 r
.63264 .45197 .63606 .44833 .63915 .44836 .63574 .45201 Mtetra
.254 0 .123 r
.63574 .45201 .63915 .44836 .64222 .44706 .63881 .45071 Mtetra
0 0 0 r
.63881 .45071 .64222 .44706 .64526 .4443 .64185 .44795 Mtetra
.828 .983 .701 r
.64185 .44795 .64526 .4443 .64826 .44009 .64486 .44374 Mtetra
.939 .951 .759 r
.64486 .44374 .64826 .44009 .65123 .43459 .64783 .43823 Mtetra
.944 .892 .748 r
.64783 .43823 .65123 .43459 .65417 .42804 .65077 .43167 Mtetra
.937 .857 .737 r
.65077 .43167 .65417 .42804 .65709 .42077 .6537 .42438 Mtetra
.933 .842 .731 r
.6537 .42438 .65709 .42077 .65999 .41315 .65661 .41675 Mtetra
.933 .844 .732 r
.65661 .41675 .65999 .41315 .6629 .40558 .65952 .40917 Mtetra
.938 .862 .738 r
.65952 .40917 .6629 .40558 .66582 .39842 .66244 .402 Mtetra
.944 .899 .751 r
.66244 .402 .66582 .39842 .66876 .39201 .66539 .39558 Mtetra
.936 .957 .76 r
.66539 .39558 .66876 .39201 .67173 .38665 .66836 .39021 Mtetra
.814 .98 .695 r
.66836 .39021 .67173 .38665 .67474 .38252 .67138 .38608 Mtetra
0 0 0 r
.67138 .38608 .67474 .38252 .6778 .37978 .67444 .38334 Mtetra
.248 0 .111 r
.67444 .38334 .6778 .37978 .68091 .37847 .67755 .38203 Mtetra
.479 .135 .305 r
.67755 .38203 .68091 .37847 .68407 .37857 .68071 .38213 Mtetra
.58 .259 .391 r
.68071 .38213 .68407 .37857 .68728 .37998 .68393 .38355 Mtetra
.63 .325 .435 r
.68393 .38355 .68728 .37998 .69054 .38253 .68719 .38611 Mtetra
.657 .362 .459 r
.68719 .38611 .69054 .38253 .69385 .38601 .69049 .3896 Mtetra
.673 .382 .473 r
.69049 .3896 .69385 .38601 .69718 .39015 .69383 .39375 Mtetra
.68 .392 .479 r
.69383 .39375 .69718 .39015 .70055 .39465 .69719 .39826 Mtetra
.68 .393 .48 r
.69719 .39826 .70055 .39465 .70392 .39922 .70056 .40284 Mtetra
.675 .386 .475 r
.70056 .40284 .70392 .39922 .7073 .40354 .70394 .40718 Mtetra
.663 .37 .464 r
.70394 .40718 .7073 .40354 .71067 .40732 .70731 .41097 Mtetra
.641 .34 .445 r
.70731 .41097 .71067 .40732 .71402 .41028 .71066 .41395 Mtetra
.603 .29 .412 r
.71066 .41395 .71402 .41028 .71734 .41221 .71398 .41588 Mtetra
.531 .2 .351 r
.71398 .41588 .71734 .41221 .72063 .41289 .71727 .41657 Mtetra
.382 .024 .227 r
.71727 .41657 .72063 .41289 .72386 .41221 .7205 .41589 Mtetra
.03 0 0 r
.7205 .41589 .72386 .41221 .72704 .41008 .72368 .41376 Mtetra
.591 .862 .527 r
.72368 .41376 .72704 .41008 .73016 .40648 .72681 .41015 Mtetra
.906 .983 .735 r
.72681 .41015 .73016 .40648 .73323 .40144 .72988 .40511 Mtetra
.949 .92 .746 r
.72988 .40511 .73323 .40144 .73624 .39505 .7329 .39871 Mtetra
.943 .861 .73 r
.7329 .39871 .73624 .39505 .7392 .38746 .73586 .39111 Mtetra
.932 .823 .715 r
.73586 .39111 .7392 .38746 .74211 .37884 .73878 .38247 Mtetra
.923 .798 .705 r
.73878 .38247 .74211 .37884 .74498 .3694 .74166 .37301 Mtetra
.917 .783 .698 r
.74166 .37301 .74498 .3694 .74783 .35938 .74451 .36298 Mtetra
.914 .776 .694 r
.74451 .36298 .74783 .35938 .75065 .34904 .74734 .35262 Mtetra
.913 .774 .694 r
.74734 .35262 .75065 .34904 .75347 .33863 .75016 .34219 Mtetra
.915 .777 .695 r
.75016 .34219 .75347 .33863 .75629 .32841 .75299 .33195 Mtetra
.919 .787 .7 r
.75299 .33195 .75629 .32841 .75912 .31862 .75583 .32214 Mtetra
.925 .805 .708 r
.75583 .32214 .75912 .31862 .76198 .30949 .7587 .313 Mtetra
.934 .832 .719 r
.7587 .313 .76198 .30949 .76488 .30123 .7616 .30472 Mtetra
.945 .874 .735 r
.7616 .30472 .76488 .30123 .76783 .29401 .76456 .2975 Mtetra
.947 .934 .751 r
.76456 .2975 .76783 .29401 .77084 .28799 .76757 .29146 Mtetra
.882 .988 .729 r
.76757 .29146 .77084 .28799 .77391 .28326 .77064 .28673 Mtetra
.519 .82 .489 r
.77064 .28673 .77391 .28326 .77706 .27992 .77379 .28338 Mtetra
.076 0 0 r
.77379 .28338 .77706 .27992 .78028 .27798 .77702 .28145 Mtetra
.4 .036 .228 r
.77702 .28145 .78028 .27798 .78358 .27747 .78032 .28093 Mtetra
.542 .206 .348 r
.78032 .28093 .78358 .27747 .78696 .27834 .7837 .28181 Mtetra
.613 .296 .409 r
.7837 .28181 .78696 .27834 .79042 .28053 .78716 .28401 Mtetra
.654 .349 .444 r
.78716 .28401 .79042 .28053 .79395 .28393 .79069 .28742 Mtetra
.679 .383 .466 r
.79069 .28742 .79395 .28393 .79755 .28842 .79429 .29193 Mtetra
.695 .405 .48 r
.79429 .29193 .79755 .28842 .80122 .29385 .79796 .29737 Mtetra
.705 .42 .489 r
.79796 .29737 .80122 .29385 .80495 .30003 .80168 .30357 Mtetra
.712 .429 .495 r
.80168 .30357 .80495 .30003 .80872 .30677 .80545 .31033 Mtetra
.715 .434 .498 r
.80545 .31033 .80872 .30677 .81253 .31386 .80926 .31744 Mtetra
.716 .436 .499 r
.80926 .31744 .81253 .31386 .81636 .32109 .81309 .32469 Mtetra
.715 .434 .498 r
.81309 .32469 .81636 .32109 .8202 .32823 .81693 .33184 Mtetra
.717 .465 .543 r
.36899 .607 .37256 .60333 .37506 .61037 .37149 .61407 Mtetra
.718 .466 .544 r
.37149 .61407 .37506 .61037 .37757 .61757 .37399 .62128 Mtetra
.717 .465 .543 r
.37399 .62128 .37757 .61757 .3801 .6247 .37651 .62843 Mtetra
.714 .461 .541 r
.37651 .62843 .3801 .6247 .38264 .63155 .37905 .6353 Mtetra
.709 .454 .536 r
.37905 .6353 .38264 .63155 .3852 .63792 .38161 .64168 Mtetra
.701 .442 .528 r
.38161 .64168 .3852 .63792 .38778 .64359 .38419 .64737 Mtetra
.688 .424 .517 r
.38419 .64737 .38778 .64359 .3904 .64839 .3868 .65218 Mtetra
.669 .396 .499 r
.3868 .65218 .3904 .64839 .39303 .65214 .38943 .65595 Mtetra
.637 .352 .47 r
.38943 .65595 .39303 .65214 .3957 .6547 .3921 .65852 Mtetra
.58 .277 .419 r
.3921 .65852 .3957 .6547 .3984 .65596 .3948 .65978 Mtetra
.462 .129 .316 r
.3948 .65978 .3984 .65596 .40112 .65584 .39752 .65967 Mtetra
.16 0 .06 r
.39752 .65967 .40112 .65584 .40387 .6543 .40027 .65812 Mtetra
.524 .822 .491 r
.40027 .65812 .40387 .6543 .40665 .65133 .40305 .65515 Mtetra
.904 .985 .762 r
.40305 .65515 .40665 .65133 .40945 .64698 .40586 .6508 Mtetra
.936 .904 .767 r
.40586 .6508 .40945 .64698 .41227 .64132 .40868 .64513 Mtetra
.923 .84 .745 r
.40868 .64513 .41227 .64132 .4151 .63448 .41152 .63828 Mtetra
.908 .8 .728 r
.41152 .63828 .4151 .63448 .41795 .62661 .41437 .63039 Mtetra
.898 .774 .717 r
.41437 .63039 .41795 .62661 .42081 .61789 .41723 .62166 Mtetra
.891 .759 .709 r
.41723 .62166 .42081 .61789 .42367 .60854 .4201 .61229 Mtetra
.887 .75 .705 r
.4201 .61229 .42367 .60854 .42653 .59879 .42297 .60253 Mtetra
.886 .747 .703 r
.42297 .60253 .42653 .59879 .42939 .58888 .42584 .5926 Mtetra
.886 .748 .704 r
.42584 .5926 .42939 .58888 .43225 .57907 .4287 .58277 Mtetra
.889 .755 .707 r
.4287 .58277 .43225 .57907 .4351 .5696 .43156 .57329 Mtetra
.895 .768 .714 r
.43156 .57329 .4351 .5696 .43794 .56072 .4344 .56439 Mtetra
.904 .79 .724 r
.4344 .56439 .43794 .56072 .44077 .55263 .43724 .55629 Mtetra
.917 .826 .74 r
.43724 .55629 .44077 .55263 .44358 .54554 .44006 .54919 Mtetra
.932 .883 .762 r
.44006 .54919 .44358 .54554 .44639 .5396 .44287 .54324 Mtetra
.924 .965 .776 r
.44287 .54324 .44639 .5396 .44919 .53494 .44567 .53858 Mtetra
.696 .936 .632 r
.44567 .53858 .44919 .53494 .45197 .53165 .44846 .53528 Mtetra
0 0 0 r
.44846 .53528 .45197 .53165 .45475 .52974 .45124 .53337 Mtetra
.397 .047 .249 r
.45124 .53337 .45475 .52974 .45753 .52921 .45402 .53285 Mtetra
.547 .229 .38 r
.45402 .53285 .45753 .52921 .4603 .52999 .45679 .53362 Mtetra
.614 .317 .441 r
.45679 .53362 .4603 .52999 .46307 .53194 .45956 .53559 Mtetra
.65 .364 .473 r
.45956 .53559 .46307 .53194 .46585 .53492 .46233 .53858 Mtetra
.67 .392 .491 r
.46233 .53858 .46585 .53492 .46863 .5387 .46511 .54237 Mtetra
.681 .407 .501 r
.46511 .54237 .46863 .5387 .47141 .54303 .46789 .54671 Mtetra
.685 .413 .505 r
.46789 .54671 .47141 .54303 .47421 .54763 .47068 .55132 Mtetra
.684 .412 .505 r
.47068 .55132 .47421 .54763 .47701 .5522 .47349 .55591 Mtetra
.678 .404 .499 r
.47349 .55591 .47701 .5522 .47983 .55644 .4763 .56016 Mtetra
.665 .385 .487 r
.4763 .56016 .47983 .55644 .48265 .56006 .47913 .56379 Mtetra
.64 .351 .465 r
.47913 .56379 .48265 .56006 .48549 .56278 .48196 .56652 Mtetra
.595 .292 .425 r
.48196 .56652 .48549 .56278 .48834 .56438 .48481 .56812 Mtetra
.505 .177 .346 r
.48481 .56812 .48834 .56438 .49119 .56467 .48766 .56842 Mtetra
.289 0 .161 r
.48766 .56842 .49119 .56467 .49405 .56355 .49053 .5673 Mtetra
0 0 0 r
.49053 .5673 .49405 .56355 .49692 .56099 .4934 .56474 Mtetra
.827 .985 .709 r
.4934 .56474 .49692 .56099 .49979 .55704 .49627 .56079 Mtetra
.936 .948 .768 r
.49627 .56079 .49979 .55704 .50266 .55185 .49914 .55559 Mtetra
.937 .885 .756 r
.49914 .55559 .50266 .55185 .50552 .54561 .50201 .54934 Mtetra
.928 .847 .743 r
.50201 .54934 .50552 .54561 .50839 .53863 .50488 .54235 Mtetra
.923 .83 .736 r
.50488 .54235 .50839 .53863 .51125 .53124 .50775 .53495 Mtetra
.922 .828 .735 r
.50775 .53495 .51125 .53124 .51411 .52382 .51061 .52751 Mtetra
.927 .842 .741 r
.51061 .52751 .51411 .52382 .51697 .51674 .51348 .52043 Mtetra
.935 .877 .753 r
.51348 .52043 .51697 .51674 .51983 .51038 .51635 .51405 Mtetra
.938 .938 .768 r
.51635 .51405 .51983 .51038 .5227 .50505 .51922 .50871 Mtetra
.85 .99 .727 r
.51922 .50871 .5227 .50505 .52558 .50098 .5221 .50465 Mtetra
0 0 0 r
.5221 .50465 .52558 .50098 .52846 .49833 .52498 .50199 Mtetra
.258 0 .13 r
.52498 .50199 .52846 .49833 .53136 .49711 .52788 .50077 Mtetra
.482 .146 .32 r
.52788 .50077 .53136 .49711 .53427 .49719 .53079 .50086 Mtetra
.569 .255 .396 r
.53079 .50086 .53427 .49719 .53719 .49834 .53371 .50201 Mtetra
.605 .301 .428 r
.53371 .50201 .53719 .49834 .54013 .50016 .53665 .50384 Mtetra
.614 .313 .436 r
.53665 .50384 .54013 .50016 .54307 .5022 .5396 .50589 Mtetra
.601 .295 .424 r
.5396 .50589 .54307 .5022 .54602 .50394 .54255 .50764 Mtetra
.555 .236 .383 r
.54255 .50764 .54602 .50394 .54898 .50487 .5455 .50858 Mtetra
.438 .093 .283 r
.5455 .50858 .54898 .50487 .55192 .50459 .54845 .50829 Mtetra
.115 0 .013 r
.54845 .50829 .55192 .50459 .55486 .50285 .55139 .50655 Mtetra
.549 .839 .508 r
.55139 .50655 .55486 .50285 .55779 .49966 .55431 .50336 Mtetra
.878 .99 .738 r
.55431 .50336 .55779 .49966 .5607 .4953 .55723 .499 Mtetra
.926 .969 .762 r
.55723 .499 .5607 .4953 .56361 .49034 .56015 .49403 Mtetra
.917 .978 .759 r
.56015 .49403 .56361 .49034 .56652 .48555 .56306 .48924 Mtetra
.779 .969 .675 r
.56306 .48924 .56652 .48555 .56945 .48171 .56599 .48539 Mtetra
0 0 0 r
.56599 .48539 .56945 .48171 .5724 .47937 .56894 .48304 Mtetra
.335 0 .194 r
.56894 .48304 .5724 .47937 .57537 .47846 .57192 .48214 Mtetra
.416 .067 .262 r
.57192 .48214 .57537 .47846 .57836 .47802 .5749 .4817 Mtetra
.141 0 .033 r
.5749 .4817 .57836 .47802 .58133 .47635 .57788 .48003 Mtetra
0 0 0 r
.57788 .48003 .58133 .47635 .58429 .47341 .58084 .47709 Mtetra
.141 0 .033 r
.58084 .47709 .58429 .47341 .58727 .47174 .58382 .47542 Mtetra
.415 .065 .261 r
.58382 .47542 .58727 .47174 .59027 .47129 .58682 .47498 Mtetra
.334 0 .193 r
.58682 .47498 .59027 .47129 .59327 .47037 .58983 .47406 Mtetra
0 0 0 r
.58983 .47406 .59327 .47037 .59626 .468 .59281 .47169 Mtetra
.771 .965 .666 r
.59281 .47169 .59626 .468 .59921 .46413 .59578 .46781 Mtetra
.915 .979 .754 r
.59578 .46781 .59921 .46413 .60216 .45929 .59872 .46297 Mtetra
.925 .972 .759 r
.59872 .46297 .60216 .45929 .6051 .45429 .60167 .45796 Mtetra
.873 .99 .732 r
.60167 .45796 .6051 .45429 .60805 .44988 .60462 .45354 Mtetra
.545 .836 .505 r
.60462 .45354 .60805 .44988 .61103 .44664 .60761 .45029 Mtetra
.103 0 0 r
.60761 .45029 .61103 .44664 .61404 .44483 .61062 .44849 Mtetra
.428 .079 .269 r
.61062 .44849 .61404 .44483 .61709 .44449 .61367 .44815 Mtetra
.548 .224 .372 r
.61367 .44815 .61709 .44449 .62017 .44536 .61675 .44903 Mtetra
.595 .285 .413 r
.61675 .44903 .62017 .44536 .62328 .44705 .61986 .45072 Mtetra
.61 .303 .425 r
.61986 .45072 .62328 .44705 .6264 .44906 .62298 .45274 Mtetra
.6 .291 .417 r
.62298 .45274 .6264 .44906 .62953 .45086 .6261 .45455 Mtetra
.563 .244 .385 r
.6261 .45455 .62953 .45086 .63264 .45197 .62922 .45567 Mtetra
.475 .136 .31 r
.62922 .45567 .63264 .45197 .63574 .45201 .63232 .45572 Mtetra
.258 0 .129 r
.63232 .45572 .63574 .45201 .63881 .45071 .6354 .45442 Mtetra
0 0 0 r
.6354 .45442 .63881 .45071 .64185 .44795 .63844 .45165 Mtetra
.822 .98 .693 r
.63844 .45165 .64185 .44795 .64486 .44374 .64145 .44743 Mtetra
.939 .953 .757 r
.64145 .44743 .64486 .44374 .64783 .43823 .64442 .44191 Mtetra
.945 .894 .747 r
.64442 .44191 .64783 .43823 .65077 .43167 .64737 .43534 Mtetra
.938 .859 .736 r
.64737 .43534 .65077 .43167 .6537 .42438 .6503 .42805 Mtetra
.934 .844 .731 r
.6503 .42805 .6537 .42438 .65661 .41675 .65322 .42041 Mtetra
.935 .846 .731 r
.65322 .42041 .65661 .41675 .65952 .40917 .65613 .41281 Mtetra
.939 .864 .738 r
.65613 .41281 .65952 .40917 .66244 .402 .65906 .40563 Mtetra
.945 .901 .75 r
.65906 .40563 .66244 .402 .66539 .39558 .66201 .3992 Mtetra
.936 .959 .757 r
.66201 .3992 .66539 .39558 .66836 .39021 .66499 .39382 Mtetra
.807 .977 .687 r
.66499 .39382 .66836 .39021 .67138 .38608 .66801 .38969 Mtetra
0 0 0 r
.66801 .38969 .67138 .38608 .67444 .38334 .67107 .38694 Mtetra
.252 0 .118 r
.67107 .38694 .67444 .38334 .67755 .38203 .67418 .38563 Mtetra
.48 .137 .308 r
.67418 .38563 .67755 .38203 .68071 .38213 .67735 .38574 Mtetra
.579 .26 .393 r
.67735 .38574 .68071 .38213 .68393 .38355 .68056 .38716 Mtetra
.629 .325 .436 r
.68056 .38716 .68393 .38355 .68719 .38611 .68382 .38973 Mtetra
.657 .362 .46 r
.68382 .38973 .68719 .38611 .69049 .3896 .68712 .39323 Mtetra
.672 .382 .473 r
.68712 .39323 .69049 .3896 .69383 .39375 .69046 .39739 Mtetra
.679 .392 .479 r
.69046 .39739 .69383 .39375 .69719 .39826 .69382 .40193 Mtetra
.68 .393 .48 r
.69382 .40193 .69719 .39826 .70056 .40284 .69719 .40652 Mtetra
.675 .386 .476 r
.69719 .40652 .70056 .40284 .70394 .40718 .70057 .41087 Mtetra
.663 .37 .465 r
.70057 .41087 .70394 .40718 .70731 .41097 .70394 .41467 Mtetra
.641 .34 .446 r
.70394 .41467 .70731 .41097 .71066 .41395 .70729 .41766 Mtetra
.602 .29 .413 r
.70729 .41766 .71066 .41395 .71398 .41588 .71061 .4196 Mtetra
.531 .201 .353 r
.71061 .4196 .71398 .41588 .71727 .41657 .7139 .4203 Mtetra
.384 .028 .232 r
.7139 .4203 .71727 .41657 .7205 .41589 .71713 .41962 Mtetra
.038 0 0 r
.71713 .41962 .7205 .41589 .72368 .41376 .72032 .41749 Mtetra
.579 .852 .513 r
.72032 .41749 .72368 .41376 .72681 .41015 .72345 .41388 Mtetra
.904 .984 .73 r
.72345 .41388 .72681 .41015 .72988 .40511 .72652 .40882 Mtetra
.95 .922 .745 r
.72652 .40882 .72988 .40511 .7329 .39871 .72954 .40242 Mtetra
.944 .863 .729 r
.72954 .40242 .7329 .39871 .73586 .39111 .73251 .3948 Mtetra
.933 .825 .715 r
.73251 .3948 .73586 .39111 .73878 .38247 .73544 .38615 Mtetra
.924 .8 .704 r
.73544 .38615 .73878 .38247 .74166 .37301 .73832 .37668 Mtetra
.918 .785 .698 r
.73832 .37668 .74166 .37301 .74451 .36298 .74118 .36663 Mtetra
.915 .777 .694 r
.74118 .36663 .74451 .36298 .74734 .35262 .74402 .35625 Mtetra
.914 .775 .693 r
.74402 .35625 .74734 .35262 .75016 .34219 .74684 .3458 Mtetra
.916 .779 .695 r
.74684 .3458 .75016 .34219 .75299 .33195 .74968 .33554 Mtetra
.92 .789 .7 r
.74968 .33554 .75299 .33195 .75583 .32214 .75253 .32571 Mtetra
.926 .806 .707 r
.75253 .32571 .75583 .32214 .7587 .313 .7554 .31656 Mtetra
.936 .834 .719 r
.7554 .31656 .7587 .313 .7616 .30472 .75831 .30827 Mtetra
.946 .876 .735 r
.75831 .30827 .7616 .30472 .76456 .2975 .76127 .30103 Mtetra
.947 .936 .75 r
.76127 .30103 .76456 .2975 .76757 .29146 .76429 .29498 Mtetra
.879 .988 .724 r
.76429 .29498 .76757 .29146 .77064 .28673 .76737 .29025 Mtetra
0 0 0 r
.76737 .29025 .77064 .28673 .77379 .28338 .77052 .28689 Mtetra
.083 0 0 r
.77052 .28689 .77379 .28338 .77702 .28145 .77375 .28496 Mtetra
.402 .04 .232 r
.77375 .28496 .77702 .28145 .78032 .28093 .77705 .28445 Mtetra
.542 .207 .35 r
.77705 .28445 .78032 .28093 .7837 .28181 .78043 .28533 Mtetra
.613 .297 .41 r
.78043 .28533 .7837 .28181 .78716 .28401 .78389 .28753 Mtetra
.653 .35 .445 r
.78389 .28753 .78716 .28401 .79069 .28742 .78742 .29096 Mtetra
.678 .383 .467 r
.78742 .29096 .79069 .28742 .79429 .29193 .79103 .29548 Mtetra
.694 .405 .481 r
.79103 .29548 .79429 .29193 .79796 .29737 .79469 .30094 Mtetra
.705 .42 .49 r
.79469 .30094 .79796 .29737 .80168 .30357 .79841 .30715 Mtetra
.711 .429 .496 r
.79841 .30715 .80168 .30357 .80545 .31033 .80218 .31393 Mtetra
.715 .434 .499 r
.80218 .31393 .80545 .31033 .80926 .31744 .80599 .32107 Mtetra
.716 .435 .5 r
.80599 .32107 .80926 .31744 .81309 .32469 .80981 .32833 Mtetra
.714 .433 .499 r
.80981 .32833 .81309 .32469 .81693 .33184 .81365 .33551 Mtetra
.722 .467 .541 r
.36542 .61035 .36899 .607 .37149 .61407 .36791 .61743 Mtetra
.723 .469 .542 r
.36791 .61743 .37149 .61407 .37399 .62128 .37041 .62466 Mtetra
.722 .467 .541 r
.37041 .62466 .37399 .62128 .37651 .62843 .37293 .63183 Mtetra
.719 .463 .538 r
.37293 .63183 .37651 .62843 .37905 .6353 .37546 .63871 Mtetra
.714 .456 .533 r
.37546 .63871 .37905 .6353 .38161 .64168 .37801 .64511 Mtetra
.706 .444 .525 r
.37801 .64511 .38161 .64168 .38419 .64737 .38059 .65082 Mtetra
.694 .425 .513 r
.38059 .65082 .38419 .64737 .3868 .65218 .3832 .65564 Mtetra
.674 .397 .494 r
.3832 .65564 .3868 .65218 .38943 .65595 .38583 .65942 Mtetra
.642 .351 .463 r
.38583 .65942 .38943 .65595 .3921 .65852 .3885 .66199 Mtetra
.582 .271 .406 r
.3885 .66199 .3921 .65852 .3948 .65978 .39119 .66327 Mtetra
.454 .107 .287 r
.39119 .66327 .3948 .65978 .39752 .65967 .39392 .66315 Mtetra
.102 0 0 r
.39392 .66315 .39752 .65967 .40027 .65812 .39667 .66161 Mtetra
.632 .91 .614 r
.39667 .66161 .40027 .65812 .40305 .65515 .39945 .65864 Mtetra
.914 .971 .791 r
.39945 .65864 .40305 .65515 .40586 .6508 .40226 .65428 Mtetra
.925 .882 .772 r
.40226 .65428 .40586 .6508 .40868 .64513 .40508 .6486 Mtetra
.911 .822 .747 r
.40508 .6486 .40868 .64513 .41152 .63828 .40793 .64174 Mtetra
.897 .785 .729 r
.40793 .64174 .41152 .63828 .41437 .63039 .41079 .63384 Mtetra
.888 .762 .717 r
.41079 .63384 .41437 .63039 .41723 .62166 .41366 .6251 Mtetra
.882 .748 .709 r
.41366 .6251 .41723 .62166 .4201 .61229 .41653 .61571 Mtetra
.878 .74 .705 r
.41653 .61571 .4201 .61229 .42297 .60253 .41941 .60593 Mtetra
.877 .737 .703 r
.41941 .60593 .42297 .60253 .42584 .5926 .42228 .59599 Mtetra
.878 .738 .704 r
.42228 .59599 .42584 .5926 .4287 .58277 .42515 .58615 Mtetra
.88 .744 .707 r
.42515 .58615 .4287 .58277 .43156 .57329 .42801 .57665 Mtetra
.886 .756 .714 r
.42801 .57665 .43156 .57329 .4344 .56439 .43086 .56773 Mtetra
.894 .776 .725 r
.43086 .56773 .4344 .56439 .43724 .55629 .4337 .55962 Mtetra
.906 .809 .741 r
.4337 .55962 .43724 .55629 .44006 .54919 .43653 .55251 Mtetra
.921 .861 .765 r
.43653 .55251 .44006 .54919 .44287 .54324 .43934 .54655 Mtetra
.923 .945 .793 r
.43934 .54655 .44287 .54324 .44567 .53858 .44215 .54188 Mtetra
.772 .981 .723 r
.44215 .54188 .44567 .53858 .44846 .53528 .44494 .53858 Mtetra
0 0 0 r
.44494 .53858 .44846 .53528 .45124 .53337 .44772 .53668 Mtetra
.38 .012 .208 r
.44772 .53668 .45124 .53337 .45402 .53285 .4505 .53615 Mtetra
.547 .218 .363 r
.4505 .53615 .45402 .53285 .45679 .53362 .45327 .53693 Mtetra
.619 .313 .431 r
.45327 .53693 .45679 .53362 .45956 .53559 .45604 .53891 Mtetra
.655 .364 .466 r
.45604 .53891 .45956 .53559 .46233 .53858 .45881 .5419 Mtetra
.675 .393 .486 r
.45881 .5419 .46233 .53858 .46511 .54237 .46158 .5457 Mtetra
.686 .408 .496 r
.46158 .5457 .46511 .54237 .46789 .54671 .46437 .55006 Mtetra
.69 .415 .501 r
.46437 .55006 .46789 .54671 .47068 .55132 .46716 .55468 Mtetra
.69 .414 .5 r
.46716 .55468 .47068 .55132 .47349 .55591 .46996 .55928 Mtetra
.683 .405 .494 r
.46996 .55928 .47349 .55591 .4763 .56016 .47277 .56355 Mtetra
.67 .385 .481 r
.47277 .56355 .4763 .56016 .47913 .56379 .47559 .56719 Mtetra
.645 .35 .457 r
.47559 .56719 .47913 .56379 .48196 .56652 .47843 .56993 Mtetra
.598 .287 .413 r
.47843 .56993 .48196 .56652 .48481 .56812 .48127 .57153 Mtetra
.501 .161 .322 r
.48127 .57153 .48481 .56812 .48766 .56842 .48413 .57183 Mtetra
.254 0 .102 r
.48413 .57183 .48766 .56842 .49053 .5673 .48699 .57072 Mtetra
0 0 0 r
.48699 .57072 .49053 .5673 .4934 .56474 .48986 .56816 Mtetra
.867 .995 .767 r
.48986 .56816 .4934 .56474 .49627 .56079 .49274 .5642 Mtetra
.931 .926 .781 r
.49274 .5642 .49627 .56079 .49914 .55559 .49561 .55899 Mtetra
.925 .864 .76 r
.49561 .55899 .49914 .55559 .50201 .54934 .49849 .55274 Mtetra
.916 .829 .745 r
.49849 .55274 .50201 .54934 .50488 .54235 .50136 .54573 Mtetra
.911 .813 .737 r
.50136 .54573 .50488 .54235 .50775 .53495 .50423 .53832 Mtetra
.911 .811 .736 r
.50423 .53832 .50775 .53495 .51061 .52751 .50711 .53087 Mtetra
.915 .824 .743 r
.50711 .53087 .51061 .52751 .51348 .52043 .50998 .52378 Mtetra
.924 .856 .757 r
.50998 .52378 .51348 .52043 .51635 .51405 .51285 .5174 Mtetra
.931 .916 .779 r
.51285 .5174 .51635 .51405 .51922 .50871 .51572 .51205 Mtetra
.882 .992 .777 r
.51572 .51205 .51922 .50871 .5221 .50465 .5186 .50798 Mtetra
0 0 0 r
.5186 .50798 .5221 .50465 .52498 .50199 .52149 .50532 Mtetra
.218 0 .063 r
.52149 .50532 .52498 .50199 .52788 .50077 .52439 .5041 Mtetra
.476 .126 .293 r
.52439 .5041 .52788 .50077 .53079 .50086 .5273 .50419 Mtetra
.571 .246 .38 r
.5273 .50419 .53079 .50086 .53371 .50201 .53023 .50535 Mtetra
.609 .297 .416 r
.53023 .50535 .53371 .50201 .53665 .50384 .53316 .50719 Mtetra
.618 .31 .425 r
.53316 .50719 .53665 .50384 .5396 .50589 .53611 .50924 Mtetra
.604 .291 .412 r
.53611 .50924 .5396 .50589 .54255 .50764 .53906 .511 Mtetra
.555 .226 .366 r
.53906 .511 .54255 .50764 .5455 .50858 .54201 .51194 Mtetra
.426 .066 .248 r
.54201 .51194 .5455 .50858 .54845 .50829 .54496 .51166 Mtetra
.047 0 0 r
.54496 .51166 .54845 .50829 .55139 .50655 .5479 .50992 Mtetra
.654 .922 .628 r
.5479 .50992 .55139 .50655 .55431 .50336 .55083 .50672 Mtetra
.9 .985 .779 r
.55083 .50672 .55431 .50336 .55723 .499 .55375 .50236 Mtetra
.928 .951 .783 r
.55375 .50236 .55723 .499 .56015 .49403 .55667 .49739 Mtetra
.923 .961 .784 r
.55667 .49739 .56015 .49403 .56306 .48924 .55959 .49258 Mtetra
.835 .994 .747 r
.55959 .49258 .56306 .48924 .56599 .48539 .56252 .48873 Mtetra
0 0 0 r
.56252 .48873 .56599 .48539 .56894 .48304 .56547 .48639 Mtetra
.308 0 .142 r
.56547 .48639 .56894 .48304 .57192 .48214 .56845 .48548 Mtetra
.402 .035 .224 r
.56845 .48548 .57192 .48214 .5749 .4817 .57144 .48505 Mtetra
.079 0 0 r
.57144 .48505 .5749 .4817 .57788 .48003 .57441 .48338 Mtetra
.531 .844 .539 r
.57441 .48338 .57788 .48003 .58084 .47709 .57737 .48044 Mtetra
.078 0 0 r
.57737 .48044 .58084 .47709 .58382 .47542 .58036 .47876 Mtetra
.4 .034 .223 r
.58036 .47876 .58382 .47542 .58682 .47498 .58336 .47832 Mtetra
.307 0 .14 r
.58336 .47832 .58682 .47498 .58983 .47406 .58637 .4774 Mtetra
0 0 0 r
.58637 .4774 .58983 .47406 .59281 .47169 .58935 .47503 Mtetra
.829 .992 .74 r
.58935 .47503 .59281 .47169 .59578 .46781 .59232 .47115 Mtetra
.923 .964 .781 r
.59232 .47115 .59578 .46781 .59872 .46297 .59527 .4663 Mtetra
.928 .954 .781 r
.59527 .4663 .59872 .46297 .60167 .45796 .59822 .46128 Mtetra
.898 .987 .775 r
.59822 .46128 .60167 .45796 .60462 .45354 .60118 .45687 Mtetra
.651 .92 .625 r
.60118 .45687 .60462 .45354 .60761 .45029 .60416 .45361 Mtetra
.033 0 0 r
.60416 .45361 .60761 .45029 .61062 .44849 .60718 .45181 Mtetra
.415 .05 .233 r
.60718 .45181 .61062 .44849 .61367 .44815 .61023 .45147 Mtetra
.548 .213 .353 r
.61023 .45147 .61367 .44815 .61675 .44903 .61331 .45235 Mtetra
.599 .279 .4 r
.61331 .45235 .61675 .44903 .61986 .45072 .61642 .45406 Mtetra
.613 .299 .413 r
.61642 .45406 .61986 .45072 .62298 .45274 .61954 .45608 Mtetra
.604 .286 .404 r
.61954 .45608 .62298 .45274 .6261 .45455 .62266 .4579 Mtetra
.564 .235 .368 r
.62266 .4579 .6261 .45455 .62922 .45567 .62578 .45903 Mtetra
.468 .114 .281 r
.62578 .45903 .62922 .45567 .63232 .45572 .62888 .45907 Mtetra
.217 0 .063 r
.62888 .45907 .63232 .45572 .6354 .45442 .63196 .45778 Mtetra
0 0 0 r
.63196 .45778 .6354 .45442 .63844 .45165 .635 .45501 Mtetra
.865 .994 .754 r
.635 .45501 .63844 .45165 .64145 .44743 .63801 .45079 Mtetra
.936 .932 .773 r
.63801 .45079 .64145 .44743 .64442 .44191 .64099 .44526 Mtetra
.934 .873 .754 r
.64099 .44526 .64442 .44191 .64737 .43534 .64395 .43868 Mtetra
.926 .84 .74 r
.64395 .43868 .64737 .43534 .6503 .42805 .64688 .43137 Mtetra
.922 .827 .734 r
.64688 .43137 .6503 .42805 .65322 .42041 .6498 .42372 Mtetra
.923 .828 .734 r
.6498 .42372 .65322 .42041 .65613 .41281 .65273 .41611 Mtetra
.927 .845 .742 r
.65273 .41611 .65613 .41281 .65906 .40563 .65566 .40891 Mtetra
.935 .88 .757 r
.65566 .40891 .65906 .40563 .66201 .3992 .65861 .40248 Mtetra
.934 .939 .775 r
.65861 .40248 .66201 .3992 .66499 .39382 .66159 .39709 Mtetra
.855 .994 .752 r
.66159 .39709 .66499 .39382 .66801 .38969 .66462 .39295 Mtetra
0 0 0 r
.66462 .39295 .66801 .38969 .67107 .38694 .66768 .3902 Mtetra
.21 0 .049 r
.66768 .3902 .67107 .38694 .67418 .38563 .6708 .3889 Mtetra
.473 .116 .278 r
.6708 .3889 .67418 .38563 .67735 .38574 .67396 .38901 Mtetra
.582 .253 .377 r
.67396 .38901 .67735 .38574 .68056 .38716 .67718 .39044 Mtetra
.634 .322 .426 r
.67718 .39044 .68056 .38716 .68382 .38973 .68044 .39302 Mtetra
.662 .361 .452 r
.68044 .39302 .68382 .38973 .68712 .39323 .68374 .39653 Mtetra
.677 .382 .467 r
.68374 .39653 .68712 .39323 .69046 .39739 .68707 .4007 Mtetra
.684 .393 .473 r
.68707 .4007 .69046 .39739 .69382 .40193 .69043 .40525 Mtetra
.685 .394 .474 r
.69043 .40525 .69382 .40193 .69719 .40652 .6938 .40986 Mtetra
.68 .386 .469 r
.6938 .40986 .69719 .40652 .70057 .41087 .69718 .41422 Mtetra
.668 .369 .458 r
.69718 .41422 .70057 .41087 .70394 .41467 .70055 .41803 Mtetra
.646 .339 .437 r
.70055 .41803 .70394 .41467 .70729 .41766 .7039 .42103 Mtetra
.606 .285 .4 r
.7039 .42103 .70729 .41766 .71061 .4196 .70722 .42297 Mtetra
.53 .187 .332 r
.70722 .42297 .71061 .4196 .7139 .4203 .7105 .42368 Mtetra
.365 0 .188 r
.7105 .42368 .7139 .4203 .71713 .41962 .71374 .423 Mtetra
0 0 0 r
.71374 .423 .71713 .41962 .72032 .41749 .71693 .42087 Mtetra
.682 .931 .629 r
.71693 .42087 .72032 .41749 .72345 .41388 .72006 .41725 Mtetra
.919 .975 .766 r
.72006 .41725 .72345 .41388 .72652 .40882 .72314 .41219 Mtetra
.942 .901 .756 r
.72314 .41219 .72652 .40882 .72954 .40242 .72617 .40578 Mtetra
.932 .845 .734 r
.72617 .40578 .72954 .40242 .73251 .3948 .72914 .39815 Mtetra
.921 .808 .718 r
.72914 .39815 .73251 .3948 .73544 .38615 .73207 .38948 Mtetra
.913 .786 .707 r
.73207 .38948 .73544 .38615 .73832 .37668 .73496 .38 Mtetra
.908 .772 .7 r
.73496 .38 .73832 .37668 .74118 .36663 .73782 .36993 Mtetra
.905 .765 .696 r
.73782 .36993 .74118 .36663 .74402 .35625 .74067 .35953 Mtetra
.904 .763 .695 r
.74067 .35953 .74402 .35625 .74684 .3458 .7435 .34906 Mtetra
.906 .766 .697 r
.7435 .34906 .74684 .3458 .74968 .33554 .74634 .33879 Mtetra
.909 .776 .702 r
.74634 .33879 .74968 .33554 .75253 .32571 .7492 .32895 Mtetra
.915 .792 .71 r
.7492 .32895 .75253 .32571 .7554 .31656 .75208 .31977 Mtetra
.924 .817 .722 r
.75208 .31977 .7554 .31656 .75831 .30827 .755 .31147 Mtetra
.934 .856 .74 r
.755 .31147 .75831 .30827 .76127 .30103 .75796 .30422 Mtetra
.941 .915 .763 r
.75796 .30422 .76127 .30103 .76429 .29498 .76098 .29817 Mtetra
.903 .985 .767 r
.76098 .29817 .76429 .29498 .76737 .29025 .76407 .29342 Mtetra
.618 .9 .6 r
.76407 .29342 .76737 .29025 .77052 .28689 .76722 .29006 Mtetra
.01 0 0 r
.76722 .29006 .77052 .28689 .77375 .28496 .77045 .28813 Mtetra
.385 .004 .189 r
.77045 .28813 .77375 .28496 .77705 .28445 .77375 .28762 Mtetra
.542 .194 .328 r
.77375 .28762 .77705 .28445 .78043 .28533 .77713 .28851 Mtetra
.617 .292 .397 r
.77713 .28851 .78043 .28533 .78389 .28753 .78059 .29072 Mtetra
.658 .348 .436 r
.78059 .29072 .78389 .28753 .78742 .29096 .78413 .29416 Mtetra
.684 .383 .46 r
.78413 .29416 .78742 .29096 .79103 .29548 .78773 .29869 Mtetra
.7 .406 .475 r
.78773 .29869 .79103 .29548 .79469 .30094 .79139 .30416 Mtetra
.71 .421 .485 r
.79139 .30416 .79469 .30094 .79841 .30715 .79511 .3104 Mtetra
.716 .43 .491 r
.79511 .3104 .79841 .30715 .80218 .31393 .79888 .3172 Mtetra
.72 .436 .494 r
.79888 .3172 .80218 .31393 .80599 .32107 .80268 .32435 Mtetra
.721 .437 .495 r
.80268 .32435 .80599 .32107 .80981 .32833 .80651 .33163 Mtetra
.72 .435 .494 r
.80651 .33163 .80981 .32833 .81365 .33551 .81034 .33883 Mtetra
.731 .472 .536 r
.36185 .61301 .36542 .61035 .36791 .61743 .36434 .6201 Mtetra
.732 .474 .537 r
.36434 .6201 .36791 .61743 .37041 .62466 .36684 .62735 Mtetra
.732 .472 .536 r
.36684 .62735 .37041 .62466 .37293 .63183 .36935 .63453 Mtetra
.729 .468 .533 r
.36935 .63453 .37293 .63183 .37546 .63871 .37187 .64143 Mtetra
.724 .461 .527 r
.37187 .64143 .37546 .63871 .37801 .64511 .37442 .64784 Mtetra
.717 .448 .518 r
.37442 .64784 .37801 .64511 .38059 .65082 .377 .65356 Mtetra
.705 .429 .504 r
.377 .65356 .38059 .65082 .3832 .65564 .3796 .65839 Mtetra
.686 .399 .482 r
.3796 .65839 .3832 .65564 .38583 .65942 .38223 .66218 Mtetra
.653 .349 .445 r
.38223 .66218 .38583 .65942 .3885 .66199 .38489 .66476 Mtetra
.588 .255 .373 r
.38489 .66476 .3885 .66199 .39119 .66327 .38759 .66604 Mtetra
.43 .046 .208 r
.38759 .66604 .39119 .66327 .39392 .66315 .39031 .66593 Mtetra
0 0 0 r
.39031 .66593 .39392 .66315 .39667 .66161 .39307 .66438 Mtetra
.79 .998 .802 r
.39307 .66438 .39667 .66161 .39945 .65864 .39585 .66141 Mtetra
.906 .921 .817 r
.39585 .66141 .39945 .65864 .40226 .65428 .39866 .65704 Mtetra
.899 .837 .775 r
.39866 .65704 .40226 .65428 .40508 .6486 .40149 .65136 Mtetra
.886 .787 .747 r
.40149 .65136 .40508 .6486 .40793 .64174 .40434 .64449 Mtetra
.875 .757 .728 r
.40434 .64449 .40793 .64174 .41079 .63384 .4072 .63658 Mtetra
.868 .738 .716 r
.4072 .63658 .41079 .63384 .41366 .6251 .41008 .62782 Mtetra
.864 .726 .709 r
.41008 .62782 .41366 .6251 .41653 .61571 .41296 .61843 Mtetra
.861 .719 .704 r
.41296 .61843 .41653 .61571 .41941 .60593 .41584 .60863 Mtetra
.86 .717 .703 r
.41584 .60863 .41941 .60593 .42228 .59599 .41872 .59868 Mtetra
.86 .718 .704 r
.41872 .59868 .42228 .59599 .42515 .58615 .42159 .58882 Mtetra
.863 .723 .707 r
.42159 .58882 .42515 .58615 .42801 .57665 .42446 .57931 Mtetra
.866 .733 .713 r
.42446 .57931 .42801 .57665 .43086 .56773 .42732 .57038 Mtetra
.873 .75 .724 r
.42732 .57038 .43086 .56773 .4337 .55962 .43016 .56225 Mtetra
.882 .776 .741 r
.43016 .56225 .4337 .55962 .43653 .55251 .43299 .55513 Mtetra
.894 .819 .767 r
.43299 .55513 .43653 .55251 .43934 .54655 .43581 .54917 Mtetra
.905 .892 .807 r
.43581 .54917 .43934 .54655 .44215 .54188 .43862 .5445 Mtetra
.854 .993 .836 r
.43862 .5445 .44215 .54188 .44494 .53858 .44141 .54119 Mtetra
0 0 0 r
.44141 .54119 .44494 .53858 .44772 .53668 .4442 .53928 Mtetra
.329 0 .092 r
.4442 .53928 .44772 .53668 .4505 .53615 .44697 .53876 Mtetra
.547 .191 .316 r
.44697 .53876 .4505 .53615 .45327 .53693 .44974 .53955 Mtetra
.628 .306 .405 r
.44974 .53955 .45327 .53693 .45604 .53891 .45251 .54153 Mtetra
.667 .363 .449 r
.45251 .54153 .45604 .53891 .45881 .5419 .45528 .54453 Mtetra
.687 .394 .473 r
.45528 .54453 .45881 .5419 .46158 .5457 .45806 .54834 Mtetra
.698 .411 .485 r
.45806 .54834 .46158 .5457 .46437 .55006 .46083 .5527 Mtetra
.702 .418 .49 r
.46083 .5527 .46437 .55006 .46716 .55468 .46362 .55734 Mtetra
.701 .417 .49 r
.46362 .55734 .46716 .55468 .46996 .55928 .46642 .56195 Mtetra
.695 .407 .482 r
.46642 .56195 .46996 .55928 .47277 .56355 .46923 .56623 Mtetra
.682 .386 .467 r
.46923 .56623 .47277 .56355 .47559 .56719 .47205 .56987 Mtetra
.656 .348 .438 r
.47205 .56987 .47559 .56719 .47843 .56993 .47488 .57262 Mtetra
.606 .274 .382 r
.47488 .57262 .47843 .56993 .48127 .57153 .47773 .57423 Mtetra
.49 .118 .259 r
.47773 .57423 .48127 .57153 .48413 .57183 .48058 .57454 Mtetra
.148 0 0 r
.48058 .57454 .48413 .57183 .48699 .57072 .48345 .57342 Mtetra
.62 .933 .7 r
.48345 .57342 .48699 .57072 .48986 .56816 .48632 .57086 Mtetra
.894 .964 .829 r
.48632 .57086 .48986 .56816 .49274 .5642 .4892 .5669 Mtetra
.908 .875 .792 r
.4892 .5669 .49274 .5642 .49561 .55899 .49207 .56168 Mtetra
.899 .822 .763 r
.49207 .56168 .49561 .55899 .49849 .55274 .49495 .55542 Mtetra
.891 .793 .745 r
.49495 .55542 .49849 .55274 .50136 .54573 .49783 .54841 Mtetra
.887 .779 .737 r
.49783 .54841 .50136 .54573 .50423 .53832 .50071 .54098 Mtetra
.886 .778 .737 r
.50071 .54098 .50423 .53832 .50711 .53087 .50359 .53353 Mtetra
.89 .789 .743 r
.50359 .53353 .50711 .53087 .50998 .52378 .50646 .52642 Mtetra
.897 .815 .759 r
.50646 .52642 .50998 .52378 .51285 .5174 .50934 .52003 Mtetra
.907 .866 .788 r
.50934 .52003 .51285 .5174 .51572 .51205 .51221 .51468 Mtetra
.898 .954 .828 r
.51221 .51468 .51572 .51205 .5186 .50798 .5151 .5106 Mtetra
.665 .957 .735 r
.5151 .5106 .5186 .50798 .52149 .50532 .51799 .50794 Mtetra
.094 0 0 r
.51799 .50794 .52149 .50532 .52439 .5041 .52089 .50672 Mtetra
.457 .071 .218 r
.52089 .50672 .52439 .5041 .5273 .50419 .5238 .50682 Mtetra
.574 .226 .34 r
.5238 .50682 .5273 .50419 .53023 .50535 .52672 .50798 Mtetra
.617 .286 .387 r
.52672 .50798 .53023 .50535 .53316 .50719 .52966 .50982 Mtetra
.628 .301 .399 r
.52966 .50982 .53316 .50719 .53611 .50924 .5326 .51189 Mtetra
.612 .279 .381 r
.5326 .51189 .53611 .50924 .53906 .511 .53555 .51364 Mtetra
.556 .201 .321 r
.53555 .51364 .53906 .511 .54201 .51194 .5385 .51459 Mtetra
.392 0 .153 r
.5385 .51459 .54201 .51194 .54496 .51166 .54145 .51432 Mtetra
0 0 0 r
.54145 .51432 .54496 .51166 .5479 .50992 .54439 .51258 Mtetra
.802 .999 .806 r
.54439 .51258 .5479 .50992 .55083 .50672 .54733 .50937 Mtetra
.906 .942 .82 r
.54733 .50937 .55083 .50672 .55375 .50236 .55025 .505 Mtetra
.911 .9 .802 r
.55025 .505 .55375 .50236 .55667 .49739 .55317 .50003 Mtetra
.911 .911 .807 r
.55317 .50003 .55667 .49739 .55959 .49258 .5561 .49522 Mtetra
.884 .978 .829 r
.5561 .49522 .55959 .49258 .56252 .48873 .55903 .49137 Mtetra
.491 .855 .613 r
.55903 .49137 .56252 .48873 .56547 .48639 .56198 .48901 Mtetra
.226 0 0 r
.56198 .48901 .56547 .48639 .56845 .48548 .56496 .48811 Mtetra
.358 0 .116 r
.56496 .48811 .56845 .48548 .57144 .48505 .56795 .48768 Mtetra
0 0 0 r
.56795 .48768 .57144 .48505 .57441 .48338 .57092 .48601 Mtetra
.73 .983 .769 r
.57092 .48601 .57441 .48338 .57737 .48044 .57389 .48307 Mtetra
0 0 0 r
.57389 .48307 .57737 .48044 .58036 .47876 .57687 .48139 Mtetra
.356 0 .114 r
.57687 .48139 .58036 .47876 .58336 .47832 .57988 .48095 Mtetra
.224 0 0 r
.57988 .48095 .58336 .47832 .58637 .4774 .58289 .48004 Mtetra
.485 .85 .607 r
.58289 .48004 .58637 .4774 .58935 .47503 .58588 .47766 Mtetra
.882 .981 .828 r
.58588 .47766 .58935 .47503 .59232 .47115 .58884 .47378 Mtetra
.912 .914 .807 r
.58884 .47378 .59232 .47115 .59527 .4663 .5918 .46892 Mtetra
.913 .903 .802 r
.5918 .46892 .59527 .4663 .59822 .46128 .59475 .4639 Mtetra
.906 .945 .819 r
.59475 .4639 .59822 .46128 .60118 .45687 .59771 .45948 Mtetra
.801 .999 .805 r
.59771 .45948 .60118 .45687 .60416 .45361 .6007 .45622 Mtetra
0 0 0 r
.6007 .45622 .60416 .45361 .60718 .45181 .60372 .45442 Mtetra
.376 0 .13 r
.60372 .45442 .60718 .45181 .61023 .45147 .60677 .45408 Mtetra
.547 .184 .303 r
.60677 .45408 .61023 .45147 .61331 .45235 .60985 .45497 Mtetra
.606 .265 .366 r
.60985 .45497 .61331 .45235 .61642 .45406 .61295 .45668 Mtetra
.622 .288 .384 r
.61295 .45668 .61642 .45406 .61954 .45608 .61607 .45871 Mtetra
.612 .273 .372 r
.61607 .45871 .61954 .45608 .62266 .4579 .6192 .46053 Mtetra
.567 .211 .324 r
.6192 .46053 .62266 .4579 .62578 .45903 .62232 .46166 Mtetra
.447 .055 .202 r
.62232 .46166 .62578 .45903 .62888 .45907 .62542 .46171 Mtetra
.093 0 0 r
.62542 .46171 .62888 .45907 .63196 .45778 .62849 .46042 Mtetra
.634 .939 .706 r
.62849 .46042 .63196 .45778 .635 .45501 .63154 .45765 Mtetra
.897 .967 .822 r
.63154 .45765 .635 .45501 .63801 .45079 .63455 .45342 Mtetra
.915 .882 .787 r
.63455 .45342 .63801 .45079 .64099 .44526 .63754 .44788 Mtetra
.907 .83 .759 r
.63754 .44788 .64099 .44526 .64395 .43868 .6405 .44129 Mtetra
.9 .803 .743 r
.6405 .44129 .64395 .43868 .64688 .43137 .64343 .43398 Mtetra
.897 .791 .736 r
.64343 .43398 .64688 .43137 .6498 .42372 .64636 .42631 Mtetra
.897 .792 .736 r
.64636 .42631 .6498 .42372 .65273 .41611 .64929 .41869 Mtetra
.901 .806 .745 r
.64929 .41869 .65273 .41611 .65566 .40891 .65223 .41149 Mtetra
.908 .836 .762 r
.65223 .41149 .65566 .40891 .65861 .40248 .65518 .40505 Mtetra
.915 .889 .792 r
.65518 .40505 .65861 .40248 .66159 .39709 .65817 .39965 Mtetra
.893 .971 .825 r
.65817 .39965 .66159 .39709 .66462 .39295 .66119 .39551 Mtetra
.632 .94 .711 r
.66119 .39551 .66462 .39295 .66768 .3902 .66426 .39276 Mtetra
.082 0 0 r
.66426 .39276 .66768 .3902 .6708 .3889 .66738 .39145 Mtetra
.453 .058 .198 r
.66738 .39145 .6708 .3889 .67396 .38901 .67054 .39157 Mtetra
.586 .233 .336 r
.67054 .39157 .67396 .38901 .67718 .39044 .67376 .393 Mtetra
.645 .316 .4 r
.67376 .393 .67718 .39044 .68044 .39302 .67702 .39559 Mtetra
.674 .359 .433 r
.67702 .39559 .68044 .39302 .68374 .39653 .68032 .39911 Mtetra
.69 .383 .451 r
.68032 .39911 .68374 .39653 .68707 .4007 .68365 .40329 Mtetra
.697 .394 .459 r
.68365 .40329 .68707 .4007 .69043 .40525 .687 .40785 Mtetra
.698 .395 .46 r
.687 .40785 .69043 .40525 .6938 .40986 .69038 .41247 Mtetra
.693 .387 .454 r
.69038 .41247 .6938 .40986 .69718 .41422 .69375 .41684 Mtetra
.68 .369 .44 r
.69375 .41684 .69718 .41422 .70055 .41803 .69712 .42066 Mtetra
.657 .334 .414 r
.69712 .42066 .70055 .41803 .7039 .42103 .70047 .42367 Mtetra
.614 .272 .367 r
.70047 .42367 .7039 .42103 .70722 .42297 .70379 .42562 Mtetra
.525 .151 .275 r
.70379 .42562 .70722 .42297 .7105 .42368 .70707 .42633 Mtetra
.306 0 .061 r
.70707 .42633 .7105 .42368 .71374 .423 .71031 .42565 Mtetra
0 0 0 r
.71031 .42565 .71374 .423 .71693 .42087 .7135 .42352 Mtetra
.821 1 .8 r
.7135 .42352 .71693 .42087 .72006 .41725 .71664 .4199 Mtetra
.917 .929 .803 r
.71664 .4199 .72006 .41725 .72314 .41219 .71972 .41483 Mtetra
.917 .854 .766 r
.71972 .41483 .72314 .41219 .72617 .40578 .72275 .40841 Mtetra
.906 .807 .738 r
.72275 .40841 .72617 .40578 .72914 .39815 .72573 .40077 Mtetra
.897 .777 .72 r
.72573 .40077 .72914 .39815 .73207 .38948 .72866 .39209 Mtetra
.891 .758 .709 r
.72866 .39209 .73207 .38948 .73496 .38 .73156 .38259 Mtetra
.887 .747 .701 r
.73156 .38259 .73496 .38 .73782 .36993 .73443 .37251 Mtetra
.885 .741 .698 r
.73443 .37251 .73782 .36993 .74067 .35953 .73728 .36209 Mtetra
.884 .739 .697 r
.73728 .36209 .74067 .35953 .7435 .34906 .74012 .35161 Mtetra
.885 .742 .699 r
.74012 .35161 .7435 .34906 .74634 .33879 .74297 .34132 Mtetra
.888 .75 .703 r
.74297 .34132 .74634 .33879 .7492 .32895 .74583 .33146 Mtetra
.892 .763 .712 r
.74583 .33146 .7492 .32895 .75208 .31977 .74871 .32227 Mtetra
.899 .784 .725 r
.74871 .32227 .75208 .31977 .755 .31147 .75164 .31396 Mtetra
.908 .816 .745 r
.75164 .31396 .755 .31147 .75796 .30422 .75461 .3067 Mtetra
.917 .867 .775 r
.75461 .3067 .75796 .30422 .76098 .29817 .75763 .30064 Mtetra
.911 .944 .813 r
.75763 .30064 .76098 .29817 .76407 .29342 .76072 .29589 Mtetra
.783 .996 .795 r
.76072 .29589 .76407 .29342 .76722 .29006 .76388 .29253 Mtetra
0 0 0 r
.76388 .29253 .76722 .29006 .77045 .28813 .7671 .29059 Mtetra
.332 0 .065 r
.7671 .29059 .77045 .28813 .77375 .28762 .77041 .29009 Mtetra
.539 .16 .271 r
.77041 .29009 .77375 .28762 .77713 .28851 .77379 .29098 Mtetra
.626 .28 .364 r
.77379 .29098 .77713 .28851 .78059 .29072 .77725 .2932 Mtetra
.671 .345 .414 r
.77725 .2932 .78059 .29072 .78413 .29416 .78078 .29664 Mtetra
.696 .384 .443 r
.78078 .29664 .78413 .29416 .78773 .29869 .78438 .30119 Mtetra
.712 .408 .461 r
.78438 .30119 .78773 .29869 .79139 .30416 .78805 .30667 Mtetra
.722 .424 .473 r
.78805 .30667 .79139 .30416 .79511 .3104 .79176 .31292 Mtetra
.728 .434 .48 r
.79176 .31292 .79511 .3104 .79888 .3172 .79553 .31973 Mtetra
.732 .439 .484 r
.79553 .31973 .79888 .3172 .80268 .32435 .79933 .3269 Mtetra
.733 .441 .485 r
.79933 .3269 .80268 .32435 .80651 .33163 .80315 .3342 Mtetra
.732 .439 .484 r
.80315 .3342 .80651 .33163 .81034 .33883 .80698 .34141 Mtetra
.747 .48 .527 r
.3583 .61465 .36185 .61301 .36434 .6201 .36078 .62176 Mtetra
.748 .482 .528 r
.36078 .62176 .36434 .6201 .36684 .62735 .36327 .62902 Mtetra
.748 .481 .527 r
.36327 .62902 .36684 .62735 .36935 .63453 .36578 .63621 Mtetra
.745 .476 .524 r
.36578 .63621 .36935 .63453 .37187 .64143 .3683 .64312 Mtetra
.741 .468 .517 r
.3683 .64312 .37187 .64143 .37442 .64784 .37085 .64954 Mtetra
.735 .456 .506 r
.37085 .64954 .37442 .64784 .377 .65356 .37342 .65527 Mtetra
.724 .435 .489 r
.37342 .65527 .377 .65356 .3796 .65839 .37601 .66011 Mtetra
.706 .402 .46 r
.37601 .66011 .3796 .65839 .38223 .66218 .37864 .6639 Mtetra
.672 .343 .409 r
.37864 .6639 .38223 .66218 .38489 .66476 .3813 .66649 Mtetra
.597 .222 .302 r
.3813 .66649 .38489 .66476 .38759 .66604 .384 .66778 Mtetra
.358 0 .007 r
.384 .66778 .38759 .66604 .39031 .66593 .38672 .66766 Mtetra
.449 .869 .741 r
.38672 .66766 .39031 .66593 .39307 .66438 .38948 .66612 Mtetra
.843 .943 .887 r
.38948 .66612 .39307 .66438 .39585 .66141 .39226 .66314 Mtetra
.866 .837 .815 r
.39226 .66314 .39585 .66141 .39866 .65704 .39507 .65877 Mtetra
.859 .777 .769 r
.39507 .65877 .39866 .65704 .40149 .65136 .39791 .65309 Mtetra
.851 .742 .742 r
.39791 .65309 .40149 .65136 .40434 .64449 .40076 .64621 Mtetra
.846 .72 .725 r
.40076 .64621 .40434 .64449 .4072 .63658 .40363 .63829 Mtetra
.842 .706 .713 r
.40363 .63829 .4072 .63658 .41008 .62782 .4065 .62952 Mtetra
.839 .698 .707 r
.4065 .62952 .41008 .62782 .41296 .61843 .40939 .62011 Mtetra
.838 .693 .703 r
.40939 .62011 .41296 .61843 .41584 .60863 .41228 .6103 Mtetra
.837 .691 .701 r
.41228 .6103 .41584 .60863 .41872 .59868 .41516 .60034 Mtetra
.837 .692 .702 r
.41516 .60034 .41872 .59868 .42159 .58882 .41804 .59047 Mtetra
.839 .696 .705 r
.41804 .59047 .42159 .58882 .42446 .57931 .42092 .58094 Mtetra
.841 .703 .711 r
.42092 .58094 .42446 .57931 .42732 .57038 .42378 .572 Mtetra
.844 .715 .721 r
.42378 .572 .42732 .57038 .43016 .56225 .42663 .56387 Mtetra
.849 .734 .736 r
.42663 .56387 .43016 .56225 .43299 .55513 .42946 .55674 Mtetra
.856 .764 .761 r
.42946 .55674 .43299 .55513 .43581 .54917 .43228 .55077 Mtetra
.863 .816 .802 r
.43228 .55077 .43581 .54917 .43862 .5445 .43509 .54609 Mtetra
.855 .907 .869 r
.43509 .54609 .43862 .5445 .44141 .54119 .43789 .54279 Mtetra
.653 .97 .876 r
.43789 .54279 .44141 .54119 .4442 .53928 .44067 .54088 Mtetra
.174 0 0 r
.44067 .54088 .4442 .53928 .44697 .53876 .44345 .54035 Mtetra
.54 .128 .208 r
.44345 .54035 .44697 .53876 .44974 .53955 .44622 .54115 Mtetra
.645 .289 .353 r
.44622 .54115 .44974 .53955 .45251 .54153 .44899 .54313 Mtetra
.687 .36 .416 r
.44899 .54313 .45251 .54153 .45528 .54453 .45175 .54614 Mtetra
.708 .396 .448 r
.45175 .54614 .45528 .54453 .45806 .54834 .45452 .54995 Mtetra
.718 .415 .465 r
.45452 .54995 .45806 .54834 .46083 .5527 .4573 .55433 Mtetra
.722 .423 .471 r
.4573 .55433 .46083 .5527 .46362 .55734 .46008 .55897 Mtetra
.721 .422 .47 r
.46008 .55897 .46362 .55734 .46642 .56195 .46288 .56359 Mtetra
.716 .411 .461 r
.46288 .56359 .46642 .56195 .46923 .56623 .46568 .56787 Mtetra
.703 .387 .44 r
.46568 .56787 .46923 .56623 .47205 .56987 .4685 .57153 Mtetra
.676 .342 .4 r
.4685 .57153 .47205 .56987 .47488 .57262 .47133 .57428 Mtetra
.618 .247 .317 r
.47133 .57428 .47488 .57262 .47773 .57423 .47418 .5759 Mtetra
.456 .013 .107 r
.47418 .5759 .47773 .57423 .48058 .57454 .47703 .5762 Mtetra
0 0 0 r
.47703 .5762 .48058 .57454 .48345 .57342 .4799 .57509 Mtetra
.793 .979 .904 r
.4799 .57509 .48345 .57342 .48632 .57086 .48277 .57252 Mtetra
.867 .874 .84 r
.48277 .57252 .48632 .57086 .4892 .5669 .48565 .56856 Mtetra
.866 .804 .787 r
.48565 .56856 .4892 .5669 .49207 .56168 .48853 .56333 Mtetra
.86 .766 .758 r
.48853 .56333 .49207 .56168 .49495 .55542 .49141 .55707 Mtetra
.856 .746 .741 r
.49141 .55707 .49495 .55542 .49783 .54841 .4943 .55005 Mtetra
.853 .737 .734 r
.4943 .55005 .49783 .54841 .50071 .54098 .49718 .54261 Mtetra
.853 .736 .733 r
.49718 .54261 .50071 .54098 .50359 .53353 .50006 .53515 Mtetra
.855 .743 .739 r
.50006 .53515 .50359 .53353 .50646 .52642 .50294 .52803 Mtetra
.859 .762 .754 r
.50294 .52803 .50646 .52642 .50934 .52003 .50582 .52164 Mtetra
.865 .798 .783 r
.50582 .52164 .50934 .52003 .51221 .51468 .5087 .51628 Mtetra
.867 .865 .835 r
.5087 .51628 .51221 .51468 .5151 .5106 .51158 .5122 Mtetra
.805 .972 .905 r
.51158 .5122 .5151 .5106 .51799 .50794 .51447 .50954 Mtetra
0 0 0 r
.51447 .50954 .51799 .50794 .52089 .50672 .51737 .50831 Mtetra
.401 0 .03 r
.51737 .50831 .52089 .50672 .5238 .50682 .52028 .50841 Mtetra
.577 .179 .251 r
.52028 .50841 .5238 .50682 .52672 .50798 .52321 .50957 Mtetra
.632 .263 .326 r
.52321 .50957 .52672 .50798 .52966 .50982 .52614 .51143 Mtetra
.644 .283 .344 r
.52614 .51143 .52966 .50982 .5326 .51189 .52908 .51349 Mtetra
.626 .253 .317 r
.52908 .51349 .5326 .51189 .53555 .51364 .53203 .51526 Mtetra
.552 .143 .218 r
.53203 .51526 .53555 .51364 .5385 .51459 .53498 .51621 Mtetra
.288 0 0 r
.53498 .51621 .5385 .51459 .54145 .51432 .53793 .51593 Mtetra
.523 .915 .802 r
.53793 .51593 .54145 .51432 .54439 .51258 .54087 .51419 Mtetra
.847 .939 .884 r
.54087 .51419 .54439 .51258 .54733 .50937 .54381 .51099 Mtetra
.87 .855 .824 r
.54381 .51099 .54733 .50937 .55025 .505 .54673 .50661 Mtetra
.869 .822 .799 r
.54673 .50661 .55025 .505 .55317 .50003 .54966 .50163 Mtetra
.87 .83 .806 r
.54966 .50163 .55317 .50003 .5561 .49522 .55258 .49681 Mtetra
.866 .889 .85 r
.55258 .49681 .5561 .49522 .55903 .49137 .55552 .49296 Mtetra
.742 .986 .9 r
.55552 .49296 .55903 .49137 .56198 .48901 .55848 .49061 Mtetra
0 0 0 r
.55848 .49061 .56198 .48901 .56496 .48811 .56145 .4897 Mtetra
.226 0 0 r
.56145 .4897 .56496 .48811 .56795 .48768 .56444 .48927 Mtetra
.481 .892 .778 r
.56444 .48927 .56795 .48768 .57092 .48601 .56742 .4876 Mtetra
.827 .961 .897 r
.56742 .4876 .57092 .48601 .57389 .48307 .57038 .48466 Mtetra
.482 .892 .779 r
.57038 .48466 .57389 .48307 .57687 .48139 .57337 .48298 Mtetra
.223 0 0 r
.57337 .48298 .57687 .48139 .57988 .48095 .57637 .48254 Mtetra
0 0 0 r
.57637 .48254 .57988 .48095 .58289 .48004 .57938 .48163 Mtetra
.74 .986 .899 r
.57938 .48163 .58289 .48004 .58588 .47766 .58237 .47925 Mtetra
.867 .892 .851 r
.58237 .47925 .58588 .47766 .58884 .47378 .58534 .47536 Mtetra
.871 .833 .806 r
.58534 .47536 .58884 .47378 .5918 .46892 .5883 .4705 Mtetra
.871 .825 .8 r
.5883 .4705 .5918 .46892 .59475 .4639 .59125 .46548 Mtetra
.871 .857 .825 r
.59125 .46548 .59475 .4639 .59771 .45948 .59422 .46105 Mtetra
.847 .939 .884 r
.59422 .46105 .59771 .45948 .6007 .45622 .59721 .45779 Mtetra
.539 .923 .815 r
.59721 .45779 .6007 .45622 .60372 .45442 .60022 .45599 Mtetra
.258 0 0 r
.60022 .45599 .60372 .45442 .60677 .45408 .60327 .45565 Mtetra
.539 .118 .19 r
.60327 .45565 .60677 .45408 .60985 .45497 .60635 .45654 Mtetra
.618 .234 .294 r
.60635 .45654 .60985 .45497 .61295 .45668 .60946 .45825 Mtetra
.638 .266 .323 r
.60946 .45825 .61295 .45668 .61607 .45871 .61258 .46029 Mtetra
.624 .245 .304 r
.61258 .46029 .61607 .45871 .6192 .46053 .6157 .46211 Mtetra
.566 .157 .226 r
.6157 .46211 .6192 .46053 .62232 .46166 .61882 .46325 Mtetra
.383 0 .001 r
.61882 .46325 .62232 .46166 .62542 .46171 .62192 .4633 Mtetra
0 0 0 r
.62192 .4633 .62542 .46171 .62849 .46042 .625 .462 Mtetra
.799 .978 .902 r
.625 .462 .62849 .46042 .63154 .45765 .62804 .45923 Mtetra
.872 .878 .838 r
.62804 .45923 .63154 .45765 .63455 .45342 .63106 .455 Mtetra
.872 .81 .785 r
.63106 .455 .63455 .45342 .63754 .44788 .63405 .44946 Mtetra
.867 .773 .755 r
.63405 .44946 .63754 .44788 .6405 .44129 .63701 .44286 Mtetra
.864 .754 .74 r
.63701 .44286 .6405 .44129 .64343 .43398 .63995 .43554 Mtetra
.862 .745 .733 r
.63995 .43554 .64343 .43398 .64636 .42631 .64288 .42786 Mtetra
.862 .746 .734 r
.64288 .42786 .64636 .42631 .64929 .41869 .64581 .42023 Mtetra
.864 .756 .742 r
.64581 .42023 .64929 .41869 .65223 .41149 .64876 .41302 Mtetra
.868 .777 .759 r
.64876 .41302 .65223 .41149 .65518 .40505 .65172 .40657 Mtetra
.872 .815 .789 r
.65172 .40657 .65518 .40505 .65817 .39965 .65471 .40117 Mtetra
.87 .882 .842 r
.65471 .40117 .65817 .39965 .66119 .39551 .65773 .39702 Mtetra
.796 .977 .905 r
.65773 .39702 .66119 .39551 .66426 .39276 .6608 .39427 Mtetra
0 0 0 r
.6608 .39427 .66426 .39276 .66738 .39145 .66392 .39296 Mtetra
.391 0 0 r
.66392 .39296 .66738 .39145 .67054 .39157 .66708 .39308 Mtetra
.592 .189 .248 r
.66708 .39308 .67054 .39157 .67376 .393 .6703 .39452 Mtetra
.663 .301 .348 r
.6703 .39452 .67376 .393 .67702 .39559 .67355 .39711 Mtetra
.695 .355 .396 r
.67355 .39711 .67702 .39559 .68032 .39911 .67685 .40064 Mtetra
.711 .383 .42 r
.67685 .40064 .68032 .39911 .68365 .40329 .68018 .40483 Mtetra
.718 .395 .431 r
.68018 .40483 .68365 .40329 .687 .40785 .68354 .40939 Mtetra
.719 .397 .433 r
.68354 .40939 .687 .40785 .69038 .41247 .6869 .41402 Mtetra
.714 .388 .425 r
.6869 .41402 .69038 .41247 .69375 .41684 .69028 .4184 Mtetra
.701 .366 .406 r
.69028 .4184 .69375 .41684 .69712 .42066 .69364 .42223 Mtetra
.677 .324 .369 r
.69364 .42223 .69712 .42066 .70047 .42367 .69699 .42524 Mtetra
.627 .243 .297 r
.69699 .42524 .70047 .42367 .70379 .42562 .70031 .4272 Mtetra
.506 .067 .14 r
.70031 .4272 .70379 .42562 .70707 .42633 .70359 .42791 Mtetra
.131 0 0 r
.70359 .42791 .70707 .42633 .71031 .42565 .70683 .42724 Mtetra
.62 .959 .851 r
.70683 .42724 .71031 .42565 .7135 .42352 .71002 .4251 Mtetra
.857 .936 .874 r
.71002 .4251 .7135 .42352 .71664 .4199 .71316 .42148 Mtetra
.879 .846 .808 r
.71316 .42148 .71664 .4199 .71972 .41483 .71625 .41641 Mtetra
.875 .791 .764 r
.71625 .41641 .71972 .41483 .72275 .40841 .71928 .40998 Mtetra
.869 .757 .737 r
.71928 .40998 .72275 .40841 .72573 .40077 .72226 .40233 Mtetra
.864 .735 .719 r
.72226 .40233 .72573 .40077 .72866 .39209 .7252 .39364 Mtetra
.861 .722 .708 r
.7252 .39364 .72866 .39209 .73156 .38259 .72811 .38412 Mtetra
.858 .714 .701 r
.72811 .38412 .73156 .38259 .73443 .37251 .73098 .37403 Mtetra
.857 .709 .698 r
.73098 .37403 .73443 .37251 .73728 .36209 .73384 .3636 Mtetra
.857 .708 .697 r
.73384 .3636 .73728 .36209 .74012 .35161 .73668 .3531 Mtetra
.857 .71 .698 r
.73668 .3531 .74012 .35161 .74297 .34132 .73954 .3428 Mtetra
.859 .716 .703 r
.73954 .3428 .74297 .34132 .74583 .33146 .7424 .33293 Mtetra
.861 .725 .711 r
.7424 .33293 .74583 .33146 .74871 .32227 .74529 .32373 Mtetra
.865 .74 .724 r
.74529 .32373 .74871 .32227 .75164 .31396 .74822 .3154 Mtetra
.869 .763 .743 r
.74822 .3154 .75164 .31396 .75461 .3067 .75119 .30813 Mtetra
.874 .799 .773 r
.75119 .30813 .75461 .3067 .75763 .30064 .75422 .30207 Mtetra
.876 .857 .82 r
.75422 .30207 .75763 .30064 .76072 .29589 .75731 .29731 Mtetra
.843 .946 .888 r
.75731 .29731 .76072 .29589 .76388 .29253 .76047 .29395 Mtetra
.562 .936 .84 r
.76047 .29395 .76388 .29253 .7671 .29059 .7637 .29201 Mtetra
.174 0 0 r
.7637 .29201 .7671 .29059 .77041 .29009 .76701 .29151 Mtetra
.523 .08 .138 r
.76701 .29151 .77041 .29009 .77379 .29098 .77039 .2924 Mtetra
.641 .254 .295 r
.77039 .2924 .77379 .29098 .77725 .2932 .77385 .29463 Mtetra
.691 .337 .37 r
.77385 .29463 .77725 .2932 .78078 .29664 .77738 .29808 Mtetra
.718 .383 .412 r
.77738 .29808 .78078 .29664 .78438 .30119 .78098 .30263 Mtetra
.733 .411 .436 r
.78098 .30263 .78438 .30119 .78805 .30667 .78464 .30812 Mtetra
.743 .429 .452 r
.78464 .30812 .78805 .30667 .79176 .31292 .78835 .31438 Mtetra
.748 .44 .461 r
.78835 .31438 .79176 .31292 .79553 .31973 .79211 .32121 Mtetra
.751 .445 .466 r
.79211 .32121 .79553 .31973 .79933 .3269 .79591 .32839 Mtetra
.752 .447 .468 r
.79591 .32839 .79933 .3269 .80315 .3342 .79972 .3357 Mtetra
.751 .445 .466 r
.79972 .3357 .80315 .3342 .80698 .34141 .80356 .34293 Mtetra
.77 .492 .513 r
.35477 .61505 .3583 .61465 .36078 .62176 .35725 .62216 Mtetra
.771 .493 .515 r
.35725 .62216 .36078 .62176 .36327 .62902 .35973 .62942 Mtetra
.77 .492 .513 r
.35973 .62942 .36327 .62902 .36578 .63621 .36223 .63662 Mtetra
.769 .488 .509 r
.36223 .63662 .36578 .63621 .3683 .64312 .36475 .64354 Mtetra
.766 .48 .5 r
.36475 .64354 .3683 .64312 .37085 .64954 .36729 .64997 Mtetra
.761 .466 .485 r
.36729 .64997 .37085 .64954 .37342 .65527 .36985 .6557 Mtetra
.753 .444 .461 r
.36985 .6557 .37342 .65527 .37601 .66011 .37245 .66055 Mtetra
.738 .406 .42 r
.37245 .66055 .37601 .66011 .37864 .6639 .37507 .66435 Mtetra
.703 .33 .338 r
.37507 .66435 .37864 .6639 .3813 .66649 .37773 .66694 Mtetra
.599 .14 .133 r
.37773 .66694 .3813 .66649 .384 .66778 .38042 .66822 Mtetra
.084 0 0 r
.38042 .66822 .384 .66778 .38672 .66766 .38315 .66811 Mtetra
.69 .91 .972 r
.38315 .66811 .38672 .66766 .38948 .66612 .3859 .66657 Mtetra
.799 .812 .862 r
.3859 .66657 .38948 .66612 .39226 .66314 .38869 .66359 Mtetra
.813 .751 .794 r
.38869 .66359 .39226 .66314 .39507 .65877 .3915 .65921 Mtetra
.815 .716 .756 r
.3915 .65921 .39507 .65877 .39791 .65309 .39433 .65352 Mtetra
.814 .695 .733 r
.39433 .65352 .39791 .65309 .40076 .64621 .39719 .64664 Mtetra
.814 .682 .718 r
.39719 .64664 .40076 .64621 .40363 .63829 .40006 .63871 Mtetra
.813 .673 .709 r
.40006 .63871 .40363 .63829 .4065 .62952 .40294 .62993 Mtetra
.812 .667 .702 r
.40294 .62993 .4065 .62952 .40939 .62011 .40583 .62052 Mtetra
.812 .664 .699 r
.40583 .62052 .40939 .62011 .41228 .6103 .40873 .6107 Mtetra
.812 .663 .698 r
.40873 .6107 .41228 .6103 .41516 .60034 .41162 .60073 Mtetra
.41162 .60073 .41516 .60034 .41804 .59047 .4145 .59085 Mtetra
.812 .666 .701 r
.4145 .59085 .41804 .59047 .42092 .58094 .41738 .58131 Mtetra
.813 .671 .706 r
.41738 .58131 .42092 .58094 .42378 .572 .42025 .57237 Mtetra
.813 .678 .715 r
.42025 .57237 .42378 .572 .42663 .56387 .4231 .56423 Mtetra
.814 .69 .728 r
.4231 .56423 .42663 .56387 .42946 .55674 .42594 .55709 Mtetra
.814 .709 .749 r
.42594 .55709 .42946 .55674 .43228 .55077 .42876 .55112 Mtetra
.813 .738 .782 r
.42876 .55112 .43228 .55077 .43509 .54609 .43157 .54643 Mtetra
.803 .79 .841 r
.43157 .54643 .43509 .54609 .43789 .54279 .43437 .54312 Mtetra
.741 .878 .943 r
.43437 .54312 .43789 .54279 .44067 .54088 .43716 .54121 Mtetra
.258 .767 .847 r
.43716 .54121 .44067 .54088 .44345 .54035 .43993 .54069 Mtetra
.489 0 0 r
.43993 .54069 .44345 .54035 .44622 .54115 .4427 .54148 Mtetra
.668 .25 .241 r
.4427 .54148 .44622 .54115 .44899 .54313 .44546 .54347 Mtetra
.719 .352 .353 r
.44546 .54347 .44899 .54313 .45175 .54614 .44823 .54648 Mtetra
.74 .398 .404 r
.44823 .54648 .45175 .54614 .45452 .54995 .45099 .5503 Mtetra
.749 .421 .428 r
.45099 .5503 .45452 .54995 .4573 .55433 .45377 .55468 Mtetra
.752 .43 .438 r
.45377 .55468 .4573 .55433 .46008 .55897 .45655 .55932 Mtetra
.752 .428 .437 r
.45655 .55932 .46008 .55897 .46288 .56359 .45934 .56395 Mtetra
.747 .416 .423 r
.45934 .56395 .46288 .56359 .46568 .56787 .46214 .56824 Mtetra
.735 .387 .392 r
.46214 .56824 .46568 .56787 .4685 .57153 .46495 .57189 Mtetra
.707 .327 .326 r
.46495 .57189 .4685 .57153 .47133 .57428 .46778 .57465 Mtetra
.631 .183 .17 r
.46778 .57465 .47133 .57428 .47418 .5759 .47062 .57627 Mtetra
.306 0 0 r
.47062 .57627 .47418 .5759 .47703 .5762 .47348 .57658 Mtetra
.558 .903 .976 r
.47348 .57658 .47703 .5762 .4799 .57509 .47634 .57546 Mtetra
.783 .844 .897 r
.47634 .57546 .4799 .57509 .48277 .57252 .47922 .57289 Mtetra
.812 .771 .815 r
.47922 .57289 .48277 .57252 .48565 .56856 .48209 .56893 Mtetra
.817 .732 .771 r
.48209 .56893 .48565 .56856 .48853 .56333 .48498 .5637 Mtetra
.818 .71 .746 r
.48498 .5637 .48853 .56333 .49141 .55707 .48786 .55742 Mtetra
.818 .698 .733 r
.48786 .55742 .49141 .55707 .4943 .55005 .49075 .5504 Mtetra
.817 .692 .726 r
.49075 .5504 .4943 .55005 .49718 .54261 .49364 .54296 Mtetra
.49364 .54296 .49718 .54261 .50006 .53515 .49652 .53548 Mtetra
.818 .696 .731 r
.49652 .53548 .50006 .53515 .50294 .52803 .4994 .52836 Mtetra
.818 .708 .744 r
.4994 .52836 .50294 .52803 .50582 .52164 .50228 .52196 Mtetra
.817 .728 .767 r
.50228 .52196 .50582 .52164 .5087 .51628 .50517 .5166 Mtetra
.812 .766 .81 r
.50517 .5166 .5087 .51628 .51158 .5122 .50805 .51251 Mtetra
.785 .836 .89 r
.50805 .51251 .51158 .5122 .51447 .50954 .51095 .50985 Mtetra
.597 .906 .983 r
.51095 .50985 .51447 .50954 .51737 .50831 .51385 .50863 Mtetra
.174 0 0 r
.51385 .50863 .51737 .50831 .52028 .50841 .51676 .50872 Mtetra
.56 .062 .031 r
.51676 .50872 .52028 .50841 .52321 .50957 .51968 .50989 Mtetra
.649 .209 .191 r
.51968 .50989 .52321 .50957 .52614 .51143 .52261 .51174 Mtetra
.667 .24 .225 r
.52261 .51174 .52614 .51143 .52908 .51349 .52555 .51381 Mtetra
.64 .192 .173 r
.52555 .51381 .52908 .51349 .53203 .51526 .52849 .51558 Mtetra
.513 0 0 r
.52849 .51558 .53203 .51526 .53498 .51621 .53144 .51653 Mtetra
.068 .631 .708 r
.53144 .51653 .53498 .51621 .53793 .51593 .53439 .51625 Mtetra
.707 .898 .965 r
.53439 .51625 .53793 .51593 .54087 .51419 .53733 .51451 Mtetra
.801 .81 .858 r
.53733 .51451 .54087 .51419 .54381 .51099 .54027 .51131 Mtetra
.815 .761 .802 r
.54027 .51131 .54381 .51099 .54673 .50661 .5432 .50693 Mtetra
.818 .742 .781 r
.5432 .50693 .54673 .50661 .54966 .50163 .54612 .50194 Mtetra
.817 .747 .786 r
.54612 .50194 .54966 .50163 .55258 .49681 .54905 .49712 Mtetra
.811 .78 .824 r
.54905 .49712 .55258 .49681 .55552 .49296 .55199 .49326 Mtetra
.768 .86 .918 r
.55199 .49326 .55552 .49296 .55848 .49061 .55494 .49091 Mtetra
.462 .871 .954 r
.55494 .49091 .55848 .49061 .56145 .4897 .55792 .49 Mtetra
.178 .713 .796 r
.55792 .49 .56145 .4897 .56444 .48927 .56091 .48958 Mtetra
.693 .901 .971 r
.56091 .48958 .56444 .48927 .56742 .4876 .56388 .4879 Mtetra
.794 .825 .876 r
.56388 .4879 .56742 .4876 .57038 .48466 .56685 .48495 Mtetra
.693 .901 .971 r
.56685 .48495 .57038 .48466 .57337 .48298 .56984 .48327 Mtetra
.183 .716 .801 r
.56984 .48327 .57337 .48298 .57637 .48254 .57284 .48284 Mtetra
.463 .871 .954 r
.57284 .48284 .57637 .48254 .57938 .48163 .57585 .48192 Mtetra
.767 .861 .919 r
.57585 .48192 .57938 .48163 .58237 .47925 .57884 .47955 Mtetra
.812 .782 .825 r
.57884 .47955 .58237 .47925 .58534 .47536 .58181 .47565 Mtetra
.818 .749 .787 r
.58181 .47565 .58534 .47536 .5883 .4705 .58477 .47079 Mtetra
.819 .744 .782 r
.58477 .47079 .5883 .4705 .59125 .46548 .58772 .46576 Mtetra
.816 .762 .802 r
.58772 .46576 .59125 .46548 .59422 .46105 .59069 .46132 Mtetra
.801 .81 .859 r
.59069 .46132 .59422 .46105 .59721 .45779 .59368 .45806 Mtetra
.71 .895 .964 r
.59368 .45806 .59721 .45779 .60022 .45599 .5967 .45626 Mtetra
.123 .673 .76 r
.5967 .45626 .60022 .45599 .60327 .45565 .59975 .45592 Mtetra
.482 0 0 r
.59975 .45592 .60327 .45565 .60635 .45654 .60283 .45681 Mtetra
.625 .161 .13 r
.60283 .45681 .60635 .45654 .60946 .45825 .60593 .45853 Mtetra
.656 .213 .187 r
.60593 .45853 .60946 .45825 .61258 .46029 .60905 .46057 Mtetra
.636 .179 .15 r
.60905 .46057 .61258 .46029 .6157 .46211 .61217 .46239 Mtetra
.536 .022 0 r
.61217 .46239 .6157 .46211 .61882 .46325 .61529 .46353 Mtetra
.131 0 0 r
.61529 .46353 .61882 .46325 .62192 .4633 .61839 .46358 Mtetra
.598 .906 .983 r
.61839 .46358 .62192 .4633 .625 .462 .62146 .46228 Mtetra
.786 .842 .894 r
.62146 .46228 .625 .462 .62804 .45923 .62451 .45951 Mtetra
.816 .774 .814 r
.62451 .45951 .62804 .45923 .63106 .455 .62753 .45528 Mtetra
.822 .736 .769 r
.62753 .45528 .63106 .455 .63405 .44946 .63052 .44973 Mtetra
.823 .714 .745 r
.63052 .44973 .63405 .44946 .63701 .44286 .63348 .44313 Mtetra
.823 .703 .732 r
.63348 .44313 .63701 .44286 .63995 .43554 .63643 .43579 Mtetra
.823 .698 .726 r
.63643 .43579 .63995 .43554 .64288 .42786 .63936 .42811 Mtetra
.823 .699 .727 r
.63936 .42811 .64288 .42786 .64581 .42023 .6423 .42047 Mtetra
.823 .704 .733 r
.6423 .42047 .64581 .42023 .64876 .41302 .64524 .41326 Mtetra
.823 .717 .748 r
.64524 .41326 .64876 .41302 .65172 .40657 .64821 .4068 Mtetra
.821 .739 .773 r
.64821 .4068 .65172 .40657 .65471 .40117 .6512 .40139 Mtetra
.814 .776 .817 r
.6512 .40139 .65471 .40117 .65773 .39702 .65423 .39724 Mtetra
.783 .841 .896 r
.65423 .39724 .65773 .39702 .6608 .39427 .6573 .39449 Mtetra
.601 .902 .985 r
.6573 .39449 .6608 .39427 .66392 .39296 .66041 .39318 Mtetra
.146 0 0 r
.66041 .39318 .66392 .39296 .66708 .39308 .66358 .3933 Mtetra
.579 .081 .034 r
.66358 .3933 .66708 .39308 .6703 .39452 .66679 .39474 Mtetra
.689 .267 .239 r
.66679 .39474 .6703 .39452 .67355 .39711 .67004 .39733 Mtetra
.727 .344 .324 r
.67004 .39733 .67355 .39711 .67685 .40064 .67334 .40086 Mtetra
.743 .38 .365 r
.67334 .40086 .67685 .40064 .68018 .40483 .67667 .40506 Mtetra
.75 .396 .382 r
.67667 .40506 .68018 .40483 .68354 .40939 .68002 .40963 Mtetra
.751 .398 .384 r
.68002 .40963 .68354 .40939 .6869 .41402 .68338 .41426 Mtetra
.746 .387 .372 r
.68338 .41426 .6869 .41402 .69028 .4184 .68675 .41864 Mtetra
.734 .359 .341 r
.68675 .41864 .69028 .4184 .69364 .42223 .69011 .42248 Mtetra
.706 .301 .277 r
.69011 .42248 .69364 .42223 .69699 .42524 .69346 .42549 Mtetra
.638 .176 .139 r
.69346 .42549 .69699 .42524 .70031 .4272 .69677 .42745 Mtetra
.408 0 0 r
.69677 .42745 .70031 .4272 .70359 .42791 .70006 .42816 Mtetra
.313 .798 .888 r
.70006 .42816 .70359 .42791 .70683 .42724 .70329 .42749 Mtetra
.737 .888 .949 r
.70329 .42749 .70683 .42724 .71002 .4251 .70649 .42535 Mtetra
.809 .809 .851 r
.70649 .42535 .71002 .4251 .71316 .42148 .70963 .42173 Mtetra
.823 .757 .789 r
.70963 .42173 .71316 .42148 .71625 .41641 .71271 .41665 Mtetra
.827 .725 .752 r
.71271 .41665 .71625 .41641 .71928 .40998 .71575 .41022 Mtetra
.828 .705 .729 r
.71575 .41022 .71928 .40998 .72226 .40233 .71874 .40256 Mtetra
.828 .692 .714 r
.71874 .40256 .72226 .40233 .7252 .39364 .72168 .39386 Mtetra
.827 .684 .704 r
.72168 .39386 .7252 .39364 .72811 .38412 .72459 .38434 Mtetra
.827 .678 .698 r
.72459 .38434 .72811 .38412 .73098 .37403 .72747 .37423 Mtetra
.827 .676 .695 r
.72747 .37423 .73098 .37403 .73384 .3636 .73033 .36379 Mtetra
.827 .675 .694 r
.73033 .36379 .73384 .3636 .73668 .3531 .73318 .35329 Mtetra
.827 .676 .696 r
.73318 .35329 .73668 .3531 .73954 .3428 .73604 .34297 Mtetra
.827 .68 .7 r
.73604 .34297 .73954 .3428 .7424 .33293 .73891 .33309 Mtetra
.827 .686 .707 r
.73891 .33309 .7424 .33293 .74529 .32373 .74181 .32389 Mtetra
.827 .695 .718 r
.74181 .32389 .74529 .32373 .74822 .3154 .74474 .31555 Mtetra
.827 .709 .735 r
.74474 .31555 .74822 .3154 .75119 .30813 .74772 .30828 Mtetra
.825 .73 .76 r
.74772 .30828 .75119 .30813 .75422 .30207 .75075 .3022 Mtetra
.82 .763 .799 r
.75075 .3022 .75422 .30207 .75731 .29731 .75384 .29744 Mtetra
.8 .815 .863 r
.75384 .29744 .75731 .29731 .76047 .29395 .757 .29408 Mtetra
.711 .888 .961 r
.757 .29408 .76047 .29395 .7637 .29201 .76023 .29214 Mtetra
.251 .759 .868 r
.76023 .29214 .7637 .29201 .76701 .29151 .76354 .29164 Mtetra
.437 0 0 r
.76354 .29164 .76701 .29151 .77039 .2924 .76692 .29253 Mtetra
.655 .192 .143 r
.76692 .29253 .77039 .2924 .77385 .29463 .77037 .29476 Mtetra
.722 .319 .284 r
.77037 .29476 .77385 .29463 .77738 .29808 .7739 .29821 Mtetra
.75 .38 .353 r
.7739 .29821 .77738 .29808 .78098 .30263 .77749 .30277 Mtetra
.764 .415 .392 r
.77749 .30277 .78098 .30263 .78464 .30812 .78115 .30827 Mtetra
.772 .435 .415 r
.78115 .30827 .78464 .30812 .78835 .31438 .78486 .31453 Mtetra
.777 .447 .429 r
.78486 .31453 .78835 .31438 .79211 .32121 .78862 .32136 Mtetra
.779 .453 .436 r
.78862 .32136 .79211 .32121 .79591 .32839 .79241 .32855 Mtetra
.78 .455 .438 r
.79241 .32855 .79591 .32839 .79972 .3357 .79622 .33587 Mtetra
.779 .453 .436 r
.79622 .33587 .79972 .3357 .80356 .34293 .80005 .3431 Mtetra
.801 .507 .492 r
.35126 .61404 .35477 .61505 .35725 .62216 .35374 .62116 Mtetra
.801 .508 .494 r
.35374 .62116 .35725 .62216 .35973 .62942 .35622 .62842 Mtetra
.801 .507 .492 r
.35622 .62842 .35973 .62942 .36223 .63662 .35871 .63562 Mtetra
.8 .503 .486 r
.35871 .63562 .36223 .63662 .36475 .64354 .36122 .64255 Mtetra
.8 .495 .473 r
.36122 .64255 .36475 .64354 .36729 .64997 .36376 .64898 Mtetra
.798 .48 .452 r
.36376 .64898 .36729 .64997 .36985 .6557 .36632 .65471 Mtetra
.794 .455 .415 r
.36632 .65471 .36985 .6557 .37245 .66055 .36891 .65956 Mtetra
.782 .407 .344 r
.36891 .65956 .37245 .66055 .37507 .66435 .37153 .66336 Mtetra
.741 .292 .183 r
.37153 .66336 .37507 .66435 .37773 .66694 .37418 .66595 Mtetra
.496 0 0 r
.37418 .66595 .37773 .66694 .38042 .66822 .37687 .66723 Mtetra
.38 .736 .991 r
.37687 .66723 .38042 .66822 .38315 .66811 .37959 .66712 Mtetra
.682 .747 .9 r
.37959 .66712 .38315 .66811 .3859 .66657 .38235 .66558 Mtetra
.744 .706 .815 r
.38235 .66558 .3859 .66657 .38869 .66359 .38513 .66259 Mtetra
.765 .68 .768 r
.38513 .66259 .38869 .66359 .3915 .65921 .38794 .65822 Mtetra
.775 .664 .74 r
.38794 .65822 .3915 .65921 .39433 .65352 .39078 .65252 Mtetra
.78 .653 .722 r
.39078 .65252 .39433 .65352 .39719 .64664 .39364 .64563 Mtetra
.784 .646 .71 r
.39364 .64563 .39719 .64664 .40006 .63871 .39652 .6377 Mtetra
.786 .642 .703 r
.39652 .6377 .40006 .63871 .40294 .62993 .3994 .62892 Mtetra
.787 .639 .697 r
.3994 .62892 .40294 .62993 .40583 .62052 .4023 .6195 Mtetra
.787 .637 .694 r
.4023 .6195 .40583 .62052 .40873 .6107 .40519 .60968 Mtetra
.788 .636 .693 r
.40519 .60968 .40873 .6107 .41162 .60073 .40809 .59969 Mtetra
.788 .636 .694 r
.40809 .59969 .41162 .60073 .4145 .59085 .41098 .58981 Mtetra
.787 .638 .696 r
.41098 .58981 .4145 .59085 .41738 .58131 .41386 .58027 Mtetra
.786 .641 .701 r
.41386 .58027 .41738 .58131 .42025 .57237 .41673 .57132 Mtetra
.784 .645 .708 r
.41673 .57132 .42025 .57237 .4231 .56423 .41959 .56317 Mtetra
.781 .651 .718 r
.41959 .56317 .4231 .56423 .42594 .55709 .42243 .55603 Mtetra
.776 .66 .735 r
.42243 .55603 .42594 .55709 .42876 .55112 .42525 .55006 Mtetra
.767 .674 .76 r
.42525 .55006 .42876 .55112 .43157 .54643 .42806 .54537 Mtetra
.749 .696 .801 r
.42806 .54537 .43157 .54643 .43437 .54312 .43086 .54206 Mtetra
.703 .731 .872 r
.43086 .54206 .43437 .54312 .43716 .54121 .43365 .54015 Mtetra
.53 .758 .98 r
.43365 .54015 .43716 .54121 .43993 .54069 .43642 .53962 Mtetra
0 .413 .708 r
.43642 .53962 .43993 .54069 .4427 .54148 .43919 .54041 Mtetra
.667 .141 0 r
.43919 .54041 .4427 .54148 .44546 .54347 .44195 .5424 Mtetra
.76 .326 .22 r
.44195 .5424 .44546 .54347 .44823 .54648 .44471 .54541 Mtetra
.784 .395 .319 r
.44471 .54541 .44823 .54648 .45099 .5503 .44747 .54923 Mtetra
.792 .425 .363 r
.44747 .54923 .45099 .5503 .45377 .55468 .45024 .55361 Mtetra
.795 .437 .379 r
.45024 .55361 .45377 .55468 .45655 .55932 .45301 .55826 Mtetra
.794 .435 .377 r
.45301 .55826 .45655 .55932 .45934 .56395 .4558 .56288 Mtetra
.79 .419 .353 r
.4558 .56288 .45934 .56395 .46214 .56824 .4586 .56717 Mtetra
.779 .38 .296 r
.4586 .56717 .46214 .56824 .46495 .57189 .46141 .57083 Mtetra
.743 .285 .164 r
.46141 .57083 .46495 .57189 .46778 .57465 .46423 .57359 Mtetra
.574 .003 0 r
.46423 .57359 .46778 .57465 .47062 .57627 .46707 .5752 Mtetra
.17 .641 .931 r
.46707 .5752 .47062 .57627 .47348 .57658 .46992 .57551 Mtetra
.632 .758 .938 r
.46992 .57551 .47348 .57658 .47634 .57546 .47279 .57439 Mtetra
.73 .718 .839 r
.47279 .57439 .47634 .57546 .47922 .57289 .47566 .57182 Mtetra
.76 .689 .783 r
.47566 .57182 .47922 .57289 .48209 .56893 .47854 .56785 Mtetra
.773 .672 .752 r
.47854 .56785 .48209 .56893 .48498 .5637 .48143 .56262 Mtetra
.779 .661 .733 r
.48143 .56262 .48498 .5637 .48786 .55742 .48431 .55634 Mtetra
.783 .655 .722 r
.48431 .55634 .48786 .55742 .49075 .5504 .4872 .54931 Mtetra
.784 .652 .717 r
.4872 .54931 .49075 .5504 .49364 .54296 .49009 .54187 Mtetra
.784 .652 .716 r
.49009 .54187 .49364 .54296 .49652 .53548 .49298 .53439 Mtetra
.783 .654 .721 r
.49298 .53439 .49652 .53548 .4994 .52836 .49586 .52727 Mtetra
.78 .66 .731 r
.49586 .52727 .4994 .52836 .50228 .52196 .49875 .52086 Mtetra
.774 .67 .749 r
.49875 .52086 .50228 .52196 .50517 .5166 .50163 .51549 Mtetra
.761 .687 .78 r
.50163 .51549 .50517 .5166 .50805 .51251 .50452 .51141 Mtetra
.732 .714 .834 r
.50452 .51141 .50805 .51251 .51095 .50985 .50741 .50874 Mtetra
.644 .752 .928 r
.50741 .50874 .51095 .50985 .51385 .50863 .51031 .50752 Mtetra
.301 .698 .976 r
.51031 .50752 .51385 .50863 .51676 .50872 .51322 .50761 Mtetra
.359 0 0 r
.51322 .50761 .51676 .50872 .51968 .50989 .51613 .50878 Mtetra
.615 .058 0 r
.51613 .50878 .51968 .50989 .52261 .51174 .51906 .51063 Mtetra
.658 .122 0 r
.51906 .51063 .52261 .51174 .52555 .51381 .522 .5127 Mtetra
.59 .023 0 r
.522 .5127 .52555 .51381 .52849 .51558 .52494 .51446 Mtetra
.228 0 0 r
.52494 .51446 .52849 .51558 .53144 .51653 .52789 .51541 Mtetra
.452 .745 .991 r
.52789 .51541 .53144 .51653 .53439 .51625 .53084 .51514 Mtetra
.687 .74 .891 r
.53084 .51514 .53439 .51625 .53733 .51451 .53378 .51339 Mtetra
.746 .705 .813 r
.53378 .51339 .53733 .51451 .54027 .51131 .53671 .51018 Mtetra
.765 .685 .774 r
.53671 .51018 .54027 .51131 .5432 .50693 .53964 .5058 Mtetra
.771 .677 .759 r
.53964 .5058 .5432 .50693 .54612 .50194 .54257 .50081 Mtetra
.77 .679 .763 r
.54257 .50081 .54612 .50194 .54905 .49712 .5455 .49599 Mtetra
.758 .693 .789 r
.5455 .49599 .54905 .49712 .55199 .49326 .54844 .49213 Mtetra
.719 .724 .854 r
.54844 .49213 .55199 .49326 .55494 .49091 .55139 .48977 Mtetra
.598 .758 .955 r
.55139 .48977 .55494 .49091 .55792 .49 .55437 .48887 Mtetra
.497 .752 .986 r
.55437 .48887 .55792 .49 .56091 .48958 .55735 .48844 Mtetra
.681 .742 .897 r
.55735 .48844 .56091 .48958 .56388 .4879 .56033 .48676 Mtetra
.739 .711 .825 r
.56033 .48676 .56388 .4879 .56685 .48495 .5633 .48381 Mtetra
.681 .742 .897 r
.5633 .48381 .56685 .48495 .56984 .48327 .56628 .48213 Mtetra
.499 .752 .986 r
.56628 .48213 .56984 .48327 .57284 .48284 .56929 .48169 Mtetra
.598 .757 .955 r
.56929 .48169 .57284 .48284 .57585 .48192 .57229 .48077 Mtetra
.719 .724 .854 r
.57229 .48077 .57585 .48192 .57884 .47955 .57528 .4784 Mtetra
.758 .693 .79 r
.57528 .4784 .57884 .47955 .58181 .47565 .57825 .4745 Mtetra
.77 .68 .763 r
.57825 .4745 .58181 .47565 .58477 .47079 .58121 .46963 Mtetra
.772 .677 .759 r
.58121 .46963 .58477 .47079 .58772 .46576 .58417 .4646 Mtetra
.765 .685 .774 r
.58417 .4646 .58772 .46576 .59069 .46132 .58714 .46016 Mtetra
.746 .705 .813 r
.58714 .46016 .59069 .46132 .59368 .45806 .59013 .4569 Mtetra
.688 .738 .889 r
.59013 .4569 .59368 .45806 .5967 .45626 .59315 .45509 Mtetra
.472 .746 .989 r
.59315 .45509 .5967 .45626 .59975 .45592 .59619 .45475 Mtetra
0 .428 .736 r
.59619 .45475 .59975 .45592 .60283 .45681 .59927 .45564 Mtetra
.541 0 0 r
.59927 .45564 .60283 .45681 .60593 .45853 .60237 .45736 Mtetra
.623 .067 0 r
.60237 .45736 .60593 .45853 .60905 .46057 .60548 .45939 Mtetra
.571 0 0 r
.60548 .45939 .60905 .46057 .61217 .46239 .6086 .46122 Mtetra
.286 0 0 r
.6086 .46122 .61217 .46239 .61529 .46353 .61172 .46236 Mtetra
.331 .706 .982 r
.61172 .46236 .61529 .46353 .61839 .46358 .61481 .46241 Mtetra
.644 .752 .928 r
.61481 .46241 .61839 .46358 .62146 .46228 .61789 .46111 Mtetra
.732 .717 .837 r
.61789 .46111 .62146 .46228 .62451 .45951 .62094 .45833 Mtetra
.763 .691 .782 r
.62094 .45833 .62451 .45951 .62753 .45528 .62396 .45409 Mtetra
.776 .674 .75 r
.62396 .45409 .62753 .45528 .63052 .44973 .62695 .44854 Mtetra
.783 .664 .732 r
.62695 .44854 .63052 .44973 .63348 .44313 .62992 .44194 Mtetra
.787 .658 .721 r
.62992 .44194 .63348 .44313 .63643 .43579 .63286 .4346 Mtetra
.788 .656 .717 r
.63286 .4346 .63643 .43579 .63936 .42811 .6358 .42691 Mtetra
.6358 .42691 .63936 .42811 .6423 .42047 .63874 .41927 Mtetra
.786 .659 .723 r
.63874 .41927 .6423 .42047 .64524 .41326 .64169 .41205 Mtetra
.782 .665 .734 r
.64169 .41205 .64524 .41326 .64821 .4068 .64465 .40559 Mtetra
.775 .675 .753 r
.64465 .40559 .64821 .4068 .6512 .40139 .64765 .40018 Mtetra
.761 .691 .785 r
.64765 .40018 .6512 .40139 .65423 .39724 .65068 .39603 Mtetra
.73 .717 .838 r
.65068 .39603 .65423 .39724 .6573 .39449 .65375 .39327 Mtetra
.642 .749 .926 r
.65375 .39327 .6573 .39449 .66041 .39318 .65686 .39196 Mtetra
.313 .695 .979 r
.65686 .39196 .66041 .39318 .66358 .3933 .66002 .39207 Mtetra
.401 0 0 r
.66002 .39207 .66358 .3933 .66679 .39474 .66323 .39351 Mtetra
.694 .175 0 r
.66323 .39351 .66679 .39474 .67004 .39733 .66648 .39611 Mtetra
.764 .311 .176 r
.66648 .39611 .67004 .39733 .67334 .40086 .66977 .39964 Mtetra
.785 .367 .256 r
.66977 .39964 .67334 .40086 .67667 .40506 .6731 .40383 Mtetra
.792 .39 .289 r
.6731 .40383 .67667 .40506 .68002 .40963 .67644 .4084 Mtetra
.793 .392 .293 r
.67644 .4084 .68002 .40963 .68338 .41426 .6798 .41304 Mtetra
.788 .376 .27 r
.6798 .41304 .68338 .41426 .68675 .41864 .68317 .41742 Mtetra
.773 .335 .209 r
.68317 .41742 .68675 .41864 .69011 .42248 .68652 .42126 Mtetra
.729 .238 .074 r
.68652 .42126 .69011 .42248 .69346 .42549 .68987 .42427 Mtetra
.567 0 0 r
.68987 .42427 .69346 .42549 .69677 .42745 .69318 .42623 Mtetra
.006 .536 .85 r
.69318 .42623 .69677 .42745 .70006 .42816 .69646 .42694 Mtetra
.545 .755 .974 r
.69646 .42694 .70006 .42816 .70329 .42749 .6997 .42627 Mtetra
.702 .735 .877 r
.6997 .42627 .70329 .42749 .70649 .42535 .70289 .42413 Mtetra
.752 .705 .807 r
.70289 .42413 .70649 .42535 .70963 .42173 .70603 .4205 Mtetra
.773 .684 .765 r
.70603 .4205 .70963 .42173 .71271 .41665 .70912 .41542 Mtetra
.784 .669 .737 r
.70912 .41542 .71271 .41665 .71575 .41022 .71216 .40898 Mtetra
.79 .66 .719 r
.71216 .40898 .71575 .41022 .71874 .40256 .71515 .40131 Mtetra
.794 .653 .707 r
.71515 .40131 .71874 .40256 .72168 .39386 .7181 .39261 Mtetra
.796 .649 .699 r
.7181 .39261 .72168 .39386 .72459 .38434 .72101 .38308 Mtetra
.797 .646 .694 r
.72101 .38308 .72459 .38434 .72747 .37423 .72389 .37297 Mtetra
.798 .644 .691 r
.72389 .37297 .72747 .37423 .73033 .36379 .72676 .36253 Mtetra
.798 .644 .69 r
.72676 .36253 .73033 .36379 .73318 .35329 .72962 .35202 Mtetra
.798 .645 .692 r
.72962 .35202 .73318 .35329 .73604 .34297 .73248 .34169 Mtetra
.797 .646 .695 r
.73248 .34169 .73604 .34297 .73891 .33309 .73535 .33181 Mtetra
.795 .65 .701 r
.73535 .33181 .73891 .33309 .74181 .32389 .73825 .3226 Mtetra
.793 .655 .71 r
.73825 .3226 .74181 .32389 .74474 .31555 .74119 .31426 Mtetra
.788 .662 .723 r
.74119 .31426 .74474 .31555 .74772 .30828 .74417 .30698 Mtetra
.781 .672 .743 r
.74417 .30698 .74772 .30828 .75075 .3022 .7472 .3009 Mtetra
.769 .686 .772 r
.7472 .3009 .75075 .3022 .75384 .29744 .75029 .29614 Mtetra
.744 .707 .816 r
.75029 .29614 .75384 .29744 .757 .29408 .75345 .29277 Mtetra
.687 .735 .887 r
.75345 .29277 .757 .29408 .76023 .29214 .75668 .29083 Mtetra
.512 .743 .978 r
.75668 .29083 .76023 .29214 .76354 .29164 .75999 .29032 Mtetra
0 .491 .82 r
.75999 .29032 .76354 .29164 .76692 .29253 .76337 .29122 Mtetra
.597 .027 0 r
.76337 .29122 .76692 .29253 .77037 .29476 .76682 .29344 Mtetra
.748 .268 .101 r
.76682 .29344 .77037 .29476 .7739 .29821 .77034 .2969 Mtetra
.79 .366 .242 r
.77034 .2969 .7739 .29821 .77749 .30277 .77393 .30145 Mtetra
.805 .414 .313 r
.77393 .30145 .77749 .30277 .78115 .30827 .77758 .30695 Mtetra
.812 .44 .352 r
.77758 .30695 .78115 .30827 .78486 .31453 .78129 .31322 Mtetra
.815 .455 .375 r
.78129 .31322 .78486 .31453 .78862 .32136 .78504 .32005 Mtetra
.816 .462 .386 r
.78504 .32005 .78862 .32136 .79241 .32855 .78882 .32724 Mtetra
.817 .464 .39 r
.78882 .32724 .79241 .32855 .79622 .33587 .79263 .33456 Mtetra
.816 .462 .386 r
.79263 .33456 .79622 .33587 .80005 .3431 .79645 .3418 Mtetra
.837 .524 .459 r
.34779 .61162 .35126 .61404 .35374 .62116 .35026 .61874 Mtetra
.837 .526 .463 r
.35026 .61874 .35374 .62116 .35622 .62842 .35273 .626 Mtetra
.837 .525 .46 r
.35273 .626 .35622 .62842 .35871 .63562 .35522 .6332 Mtetra
.838 .52 .45 r
.35522 .6332 .35871 .63562 .36122 .64255 .35773 .64012 Mtetra
.84 .511 .431 r
.35773 .64012 .36122 .64255 .36376 .64898 .36025 .64654 Mtetra
.842 .495 .397 r
.36025 .64654 .36376 .64898 .36632 .65471 .36281 .65228 Mtetra
.842 .463 .333 r
.36281 .65228 .36632 .65471 .36891 .65956 .36539 .65712 Mtetra
.828 .391 .196 r
.36539 .65712 .36891 .65956 .37153 .66336 .36801 .66092 Mtetra
.704 .166 0 r
.36801 .66092 .37153 .66336 .37418 .66595 .37066 .66351 Mtetra
0 .406 .844 r
.37066 .66351 .37418 .66595 .37687 .66723 .37334 .66479 Mtetra
.499 .627 .908 r
.37334 .66479 .37687 .66723 .37959 .66712 .37606 .66467 Mtetra
.648 .641 .829 r
.37606 .66467 .37959 .66712 .38235 .66558 .37882 .66313 Mtetra
.703 .635 .778 r
.37882 .66313 .38235 .66558 .38513 .66259 .3816 .66014 Mtetra
.729 .628 .746 r
.3816 .66014 .38513 .66259 .38794 .65822 .38441 .65576 Mtetra
.743 .623 .726 r
.38441 .65576 .38794 .65822 .39078 .65252 .38725 .65007 Mtetra
.752 .62 .712 r
.38725 .65007 .39078 .65252 .39364 .64563 .39011 .64317 Mtetra
.758 .617 .703 r
.39011 .64317 .39364 .64563 .39652 .6377 .39299 .63524 Mtetra
.762 .615 .696 r
.39299 .63524 .39652 .6377 .3994 .62892 .39588 .62646 Mtetra
.765 .614 .692 r
.39588 .62646 .3994 .62892 .4023 .6195 .39878 .61703 Mtetra
.766 .613 .69 r
.39878 .61703 .4023 .6195 .40519 .60968 .40168 .60721 Mtetra
.767 .613 .689 r
.40168 .60721 .40519 .60968 .40809 .59969 .40458 .59723 Mtetra
.766 .613 .689 r
.40458 .59723 .40809 .59969 .41098 .58981 .40747 .58734 Mtetra
.765 .614 .691 r
.40747 .58734 .41098 .58981 .41386 .58027 .41035 .5778 Mtetra
.763 .615 .695 r
.41035 .5778 .41386 .58027 .41673 .57132 .41323 .56884 Mtetra
.759 .617 .701 r
.41323 .56884 .41673 .57132 .41959 .56317 .41609 .5607 Mtetra
.754 .619 .709 r
.41609 .5607 .41959 .56317 .42243 .55603 .41893 .55355 Mtetra
.746 .622 .722 r
.41893 .55355 .42243 .55603 .42525 .55006 .42176 .54758 Mtetra
.732 .627 .741 r
.42176 .54758 .42525 .55006 .42806 .54537 .42457 .54289 Mtetra
.71 .632 .769 r
.42457 .54289 .42806 .54537 .43086 .54206 .42736 .53957 Mtetra
.665 .638 .813 r
.42736 .53957 .43086 .54206 .43365 .54015 .43015 .53766 Mtetra
.561 .634 .881 r
.43015 .53766 .43365 .54015 .43642 .53962 .43292 .53713 Mtetra
.251 .545 .926 r
.43292 .53713 .43642 .53962 .43919 .54041 .43568 .53792 Mtetra
.421 0 0 r
.43568 .53792 .43919 .54041 .44195 .5424 .43844 .5399 Mtetra
.755 .239 0 r
.43844 .5399 .44195 .5424 .44471 .54541 .4412 .54291 Mtetra
.823 .37 .151 r
.4412 .54291 .44471 .54541 .44747 .54923 .44395 .54673 Mtetra
.838 .419 .24 r
.44395 .54673 .44747 .54923 .45024 .55361 .44672 .5511 Mtetra
.842 .436 .273 r
.44672 .5511 .45024 .55361 .45301 .55826 .44949 .55575 Mtetra
.842 .434 .268 r
.44949 .55575 .45301 .55826 .4558 .56288 .45227 .56037 Mtetra
.836 .409 .222 r
.45227 .56037 .4558 .56288 .4586 .56717 .45506 .56466 Mtetra
.812 .342 .103 r
.45506 .56466 .4586 .56717 .46141 .57083 .45787 .56831 Mtetra
.695 .154 0 r
.45787 .56831 .46141 .57083 .46423 .57359 .46069 .57107 Mtetra
0 .312 .764 r
.46069 .57107 .46423 .57359 .46707 .5752 .46352 .57268 Mtetra
.413 .603 .925 r
.46352 .57268 .46707 .5752 .46992 .57551 .46637 .57299 Mtetra
.616 .64 .851 r
.46637 .57299 .46992 .57551 .47279 .57439 .46923 .57187 Mtetra
.688 .637 .793 r
.46923 .57187 .47279 .57439 .47566 .57182 .47211 .5693 Mtetra
.721 .631 .757 r
.47211 .5693 .47566 .57182 .47854 .56785 .47499 .56532 Mtetra
.738 .626 .734 r
.47499 .56532 .47854 .56785 .48143 .56262 .47787 .56009 Mtetra
.748 .623 .72 r
.47787 .56009 .48143 .56262 .48431 .55634 .48076 .55381 Mtetra
.754 .621 .712 r
.48076 .55381 .48431 .55634 .4872 .54931 .48365 .54678 Mtetra
.756 .62 .708 r
.48365 .54678 .4872 .54931 .49009 .54187 .48654 .53933 Mtetra
.48654 .53933 .49009 .54187 .49298 .53439 .48943 .53185 Mtetra
.754 .62 .711 r
.48943 .53185 .49298 .53439 .49586 .52727 .49232 .52472 Mtetra
.749 .622 .719 r
.49232 .52472 .49586 .52727 .49875 .52086 .4952 .51831 Mtetra
.74 .626 .732 r
.4952 .51831 .49875 .52086 .50163 .51549 .49809 .51294 Mtetra
.723 .63 .754 r
.49809 .51294 .50163 .51549 .50452 .51141 .50098 .50885 Mtetra
.69 .636 .79 r
.50098 .50885 .50452 .51141 .50741 .50874 .50387 .50619 Mtetra
.622 .639 .846 r
.50387 .50619 .50741 .50874 .51031 .50752 .50676 .50496 Mtetra
.462 .614 .914 r
.50676 .50496 .51031 .50752 .51322 .50761 .50967 .50505 Mtetra
.111 .478 .897 r
.50967 .50505 .51322 .50761 .51613 .50878 .51258 .50622 Mtetra
0 .242 .697 r
.51258 .50622 .51613 .50878 .51906 .51063 .51551 .50807 Mtetra
0 .152 .598 r
.51551 .50807 .51906 .51063 .522 .5127 .51844 .51013 Mtetra
0 .284 .739 r
.51844 .51013 .522 .5127 .52494 .51446 .52138 .51189 Mtetra
.212 .526 .92 r
.52138 .51189 .52494 .51446 .52789 .51541 .52433 .51284 Mtetra
.525 .628 .896 r
.52433 .51284 .52789 .51541 .53084 .51514 .52727 .51256 Mtetra
.653 .639 .824 r
.52727 .51256 .53084 .51514 .53378 .51339 .53021 .51082 Mtetra
.704 .635 .776 r
.53021 .51082 .53378 .51339 .53671 .51018 .53315 .5076 Mtetra
.727 .63 .75 r
.53315 .5076 .53671 .51018 .53964 .5058 .53608 .50322 Mtetra
.735 .628 .74 r
.53608 .50322 .53964 .5058 .54257 .50081 .539 .49823 Mtetra
.733 .628 .742 r
.539 .49823 .54257 .50081 .5455 .49599 .54193 .4934 Mtetra
.718 .632 .761 r
.54193 .4934 .5455 .49599 .54844 .49213 .54487 .48954 Mtetra
.678 .638 .802 r
.54487 .48954 .54844 .49213 .55139 .48977 .54783 .48718 Mtetra
.595 .637 .862 r
.54783 .48718 .55139 .48977 .55437 .48887 .5508 .48627 Mtetra
.545 .631 .887 r
.5508 .48627 .55437 .48887 .55735 .48844 .55378 .48584 Mtetra
.648 .639 .828 r
.55378 .48584 .55735 .48844 .56033 .48676 .55676 .48416 Mtetra
.697 .636 .784 r
.55676 .48416 .56033 .48676 .5633 .48381 .55972 .48121 Mtetra
.648 .639 .827 r
.55972 .48121 .5633 .48381 .56628 .48213 .5627 .47952 Mtetra
.545 .631 .887 r
.5627 .47952 .56628 .48213 .56929 .48169 .56571 .47908 Mtetra
.595 .637 .862 r
.56571 .47908 .56929 .48169 .57229 .48077 .56871 .47816 Mtetra
.678 .638 .802 r
.56871 .47816 .57229 .48077 .57528 .4784 .5717 .47578 Mtetra
.718 .632 .761 r
.5717 .47578 .57528 .4784 .57825 .4745 .57467 .47188 Mtetra
.733 .629 .743 r
.57467 .47188 .57825 .4745 .58121 .46963 .57763 .46701 Mtetra
.735 .628 .74 r
.57763 .46701 .58121 .46963 .58417 .4646 .58059 .46198 Mtetra
.727 .63 .75 r
.58059 .46198 .58417 .4646 .58714 .46016 .58356 .45754 Mtetra
.704 .635 .776 r
.58356 .45754 .58714 .46016 .59013 .4569 .58655 .45427 Mtetra
.653 .639 .823 r
.58655 .45427 .59013 .4569 .59315 .45509 .58956 .45246 Mtetra
.532 .628 .891 r
.58956 .45246 .59315 .45509 .59619 .45475 .59261 .45212 Mtetra
.255 .542 .924 r
.59261 .45212 .59619 .45475 .59927 .45564 .59568 .45301 Mtetra
0 .341 .796 r
.59568 .45301 .59927 .45564 .60237 .45736 .59878 .45472 Mtetra
0 .224 .682 r
.59878 .45472 .60237 .45736 .60548 .45939 .60189 .45675 Mtetra
0 .305 .762 r
.60189 .45675 .60548 .45939 .6086 .46122 .605 .45858 Mtetra
.165 .502 .909 r
.605 .45858 .6086 .46122 .61172 .46236 .60811 .45971 Mtetra
.472 .615 .911 r
.60811 .45971 .61172 .46236 .61481 .46241 .61121 .45976 Mtetra
.623 .639 .845 r
.61121 .45976 .61481 .46241 .61789 .46111 .61428 .45846 Mtetra
.69 .637 .791 r
.61428 .45846 .61789 .46111 .62094 .45833 .61733 .45568 Mtetra
.723 .632 .756 r
.61733 .45568 .62094 .45833 .62396 .45409 .62035 .45144 Mtetra
.741 .627 .733 r
.62035 .45144 .62396 .45409 .62695 .44854 .62334 .44589 Mtetra
.751 .624 .719 r
.62334 .44589 .62695 .44854 .62992 .44194 .62631 .43927 Mtetra
.756 .622 .711 r
.62631 .43927 .62992 .44194 .63286 .4346 .62926 .43194 Mtetra
.759 .621 .708 r
.62926 .43194 .63286 .4346 .6358 .42691 .6322 .42425 Mtetra
.758 .622 .708 r
.6322 .42425 .6358 .42691 .63874 .41927 .63514 .4166 Mtetra
.756 .623 .712 r
.63514 .4166 .63874 .41927 .64169 .41205 .63809 .40938 Mtetra
.75 .625 .721 r
.63809 .40938 .64169 .41205 .64465 .40559 .64106 .40292 Mtetra
.739 .628 .735 r
.64106 .40292 .64465 .40559 .64765 .40018 .64405 .3975 Mtetra
.721 .632 .758 r
.64405 .3975 .64765 .40018 .65068 .39603 .64708 .39335 Mtetra
.688 .637 .792 r
.64708 .39335 .65068 .39603 .65375 .39327 .65015 .39059 Mtetra
.622 .637 .845 r
.65015 .39059 .65375 .39327 .65686 .39196 .65326 .38928 Mtetra
.462 .611 .911 r
.65326 .38928 .65686 .39196 .66002 .39207 .65642 .38939 Mtetra
.057 .444 .877 r
.65642 .38939 .66002 .39207 .66323 .39351 .65963 .39082 Mtetra
.494 0 0 r
.65963 .39082 .66323 .39351 .66648 .39611 .66288 .39341 Mtetra
.735 .209 0 r
.66288 .39341 .66648 .39611 .66977 .39964 .66616 .39694 Mtetra
.803 .317 .043 r
.66616 .39694 .66977 .39964 .6731 .40383 .66948 .40113 Mtetra
.822 .357 .111 r
.66948 .40113 .6731 .40383 .67644 .4084 .67282 .4057 Mtetra
.824 .362 .119 r
.67282 .4057 .67644 .4084 .6798 .41304 .67617 .41033 Mtetra
.811 .334 .071 r
.67617 .41033 .6798 .41304 .68317 .41742 .67953 .41471 Mtetra
.766 .255 0 r
.67953 .41471 .68317 .41742 .68652 .42126 .68288 .41854 Mtetra
.614 .063 0 r
.68288 .41854 .68652 .42126 .68987 .42427 .68622 .42156 Mtetra
0 .305 .765 r
.68622 .42156 .68987 .42427 .69318 .42623 .68953 .42351 Mtetra
.331 .57 .927 r
.68953 .42351 .69318 .42623 .69646 .42694 .69281 .42422 Mtetra
.567 .633 .876 r
.69281 .42422 .69646 .42694 .6997 .42627 .69605 .42354 Mtetra
.664 .639 .815 r
.69605 .42354 .6997 .42627 .70289 .42413 .69923 .4214 Mtetra
.709 .635 .772 r
.69923 .4214 .70289 .42413 .70603 .4205 .70237 .41777 Mtetra
.734 .631 .743 r
.70237 .41777 .70603 .4205 .70912 .41542 .70546 .41268 Mtetra
.749 .626 .723 r
.70546 .41268 .70912 .41542 .71216 .40898 .7085 .40624 Mtetra
.759 .623 .709 r
.7085 .40624 .71216 .40898 .71515 .40131 .7115 .39858 Mtetra
.765 .621 .7 r
.7115 .39858 .71515 .40131 .7181 .39261 .71445 .38987 Mtetra
.769 .619 .693 r
.71445 .38987 .7181 .39261 .72101 .38308 .71736 .38034 Mtetra
.772 .618 .689 r
.71736 .38034 .72101 .38308 .72389 .37297 .72025 .37023 Mtetra
.773 .618 .686 r
.72025 .37023 .72389 .37297 .72676 .36253 .72312 .35978 Mtetra
.774 .617 .686 r
.72312 .35978 .72676 .36253 .72962 .35202 .72598 .34927 Mtetra
.773 .618 .687 r
.72598 .34927 .72962 .35202 .73248 .34169 .72885 .33894 Mtetra
.771 .618 .69 r
.72885 .33894 .73248 .34169 .73535 .33181 .73173 .32906 Mtetra
.768 .62 .695 r
.73173 .32906 .73535 .33181 .73825 .3226 .73463 .31984 Mtetra
.764 .621 .702 r
.73463 .31984 .73825 .3226 .74119 .31426 .73757 .3115 Mtetra
.757 .624 .713 r
.73757 .3115 .74119 .31426 .74417 .30698 .74055 .30422 Mtetra
.746 .627 .728 r
.74055 .30422 .74417 .30698 .7472 .3009 .74358 .29814 Mtetra
.73 .631 .748 r
.74358 .29814 .7472 .3009 .75029 .29614 .74668 .29337 Mtetra
.702 .635 .778 r
.74668 .29337 .75029 .29614 .75345 .29277 .74984 .29 Mtetra
.653 .637 .822 r
.74984 .29 .75345 .29277 .75668 .29083 .75306 .28806 Mtetra
.549 .627 .882 r
.75306 .28806 .75668 .29083 .75999 .29032 .75637 .28755 Mtetra
.294 .551 .923 r
.75637 .28755 .75999 .29032 .76337 .29122 .75974 .28844 Mtetra
0 .254 .72 r
.75974 .28844 .76337 .29122 .76682 .29344 .76319 .29066 Mtetra
.667 .125 0 r
.76319 .29066 .76682 .29344 .77034 .2969 .76671 .29411 Mtetra
.802 .314 .028 r
.76671 .29411 .77034 .2969 .77393 .30145 .77029 .29866 Mtetra
.839 .396 .171 r
.77029 .29866 .77393 .30145 .77758 .30695 .77394 .30416 Mtetra
.851 .436 .245 r
.77394 .30416 .77758 .30695 .78129 .31322 .77764 .31042 Mtetra
.855 .457 .286 r
.77764 .31042 .78129 .31322 .78504 .32005 .78138 .31725 Mtetra
.856 .467 .306 r
.78138 .31725 .78504 .32005 .78882 .32724 .78516 .32444 Mtetra
.857 .47 .312 r
.78516 .32444 .78882 .32724 .79263 .33456 .78896 .33176 Mtetra
.856 .466 .304 r
.78896 .33176 .79263 .33456 .79645 .3418 .79277 .33899 Mtetra
.875 .541 .415 r
.34435 .60791 .34779 .61162 .35026 .61874 .34681 .61501 Mtetra
.874 .543 .42 r
.34681 .61501 .35026 .61874 .35273 .626 .34928 .62227 Mtetra
.875 .542 .416 r
.34928 .62227 .35273 .626 .35522 .6332 .35176 .62946 Mtetra
.878 .537 .401 r
.35176 .62946 .35522 .6332 .35773 .64012 .35426 .63637 Mtetra
.881 .526 .37 r
.35426 .63637 .35773 .64012 .36025 .64654 .35678 .64279 Mtetra
.885 .505 .313 r
.35678 .64279 .36025 .64654 .36281 .65228 .35933 .64852 Mtetra
.878 .456 .197 r
.35933 .64852 .36281 .65228 .36539 .65712 .3619 .65336 Mtetra
.803 .318 0 r
.3619 .65336 .36539 .65712 .36801 .66092 .36452 .65715 Mtetra
0 .074 .599 r
.36452 .65715 .36801 .66092 .37066 .66351 .36716 .65973 Mtetra
.248 .45 .862 r
.36716 .65973 .37066 .66351 .37334 .66479 .36984 .66101 Mtetra
.52 .555 .832 r
.36984 .66101 .37334 .66479 .37606 .66467 .37256 .66089 Mtetra
.625 .581 .785 r
.37256 .66089 .37606 .66467 .37882 .66313 .37531 .65934 Mtetra
.675 .59 .752 r
.37531 .65934 .37882 .66313 .3816 .66014 .37809 .65635 Mtetra
.703 .593 .73 r
.37809 .65635 .3816 .66014 .38441 .65576 .38091 .65197 Mtetra
.72 .594 .715 r
.38091 .65197 .38441 .65576 .38725 .65007 .38375 .64627 Mtetra
.731 .595 .704 r
.38375 .64627 .38725 .65007 .39011 .64317 .38661 .63938 Mtetra
.738 .595 .696 r
.38661 .63938 .39011 .64317 .39299 .63524 .38949 .63145 Mtetra
.743 .595 .691 r
.38949 .63145 .39299 .63524 .39588 .62646 .39238 .62267 Mtetra
.747 .595 .687 r
.39238 .62267 .39588 .62646 .39878 .61703 .39528 .61324 Mtetra
.749 .595 .685 r
.39528 .61324 .39878 .61703 .40168 .60721 .39818 .60342 Mtetra
.75 .595 .684 r
.39818 .60342 .40168 .60721 .40458 .59723 .40108 .59344 Mtetra
.749 .595 .685 r
.40108 .59344 .40458 .59723 .40747 .58734 .40398 .58355 Mtetra
.748 .595 .687 r
.40398 .58355 .40747 .58734 .41035 .5778 .40687 .57401 Mtetra
.745 .595 .69 r
.40687 .57401 .41035 .5778 .41323 .56884 .40974 .56506 Mtetra
.74 .595 .695 r
.40974 .56506 .41323 .56884 .41609 .5607 .4126 .55691 Mtetra
.733 .595 .702 r
.4126 .55691 .41609 .5607 .41893 .55355 .41545 .54977 Mtetra
.723 .594 .712 r
.41545 .54977 .41893 .55355 .42176 .54758 .41827 .54379 Mtetra
.707 .593 .726 r
.41827 .54379 .42176 .54758 .42457 .54289 .42109 .5391 Mtetra
.683 .591 .746 r
.42109 .5391 .42457 .54289 .42736 .53957 .42388 .53578 Mtetra
.64 .584 .776 r
.42388 .53578 .42736 .53957 .43015 .53766 .42666 .53386 Mtetra
.559 .565 .816 r
.42666 .53386 .43015 .53766 .43292 .53713 .42943 .53333 Mtetra
.384 .507 .859 r
.42943 .53333 .43292 .53713 .43568 .53792 .43219 .53412 Mtetra
0 .317 .806 r
.43219 .53412 .43568 .53792 .43844 .5399 .43495 .5361 Mtetra
.525 .038 0 r
.43495 .5361 .43844 .5399 .4412 .54291 .4377 .5391 Mtetra
.771 .278 0 r
.4377 .5391 .4412 .54291 .44395 .54673 .44045 .54291 Mtetra
.841 .375 .031 r
.44045 .54291 .44395 .54673 .44672 .5511 .4432 .54728 Mtetra
.859 .407 .093 r
.4432 .54728 .44672 .5511 .44949 .55575 .44597 .55192 Mtetra
.857 .402 .083 r
.44597 .55192 .44949 .55575 .45227 .56037 .44874 .55654 Mtetra
.829 .356 0 r
.44874 .55654 .45227 .56037 .45506 .56466 .45153 .56082 Mtetra
.723 .223 0 r
.45153 .56082 .45506 .56466 .45787 .56831 .45433 .56447 Mtetra
0 .081 .608 r
.45433 .56447 .45787 .56831 .46069 .57107 .45715 .56722 Mtetra
.164 .408 .85 r
.45715 .56722 .46069 .57107 .46352 .57268 .45998 .56883 Mtetra
.469 .538 .845 r
.45998 .56883 .46352 .57268 .46637 .57299 .46282 .56913 Mtetra
.599 .576 .799 r
.46282 .56913 .46637 .57299 .46923 .57187 .46568 .56801 Mtetra
.661 .588 .762 r
.46568 .56801 .46923 .57187 .47211 .5693 .46855 .56543 Mtetra
.694 .592 .738 r
.46855 .56543 .47211 .5693 .47499 .56532 .47143 .56146 Mtetra
.713 .594 .721 r
.47143 .56146 .47499 .56532 .47787 .56009 .47432 .55622 Mtetra
.725 .595 .71 r
.47432 .55622 .47787 .56009 .48076 .55381 .47721 .54994 Mtetra
.732 .595 .704 r
.47721 .54994 .48076 .55381 .48365 .54678 .4801 .5429 Mtetra
.735 .595 .7 r
.4801 .5429 .48365 .54678 .48654 .53933 .48299 .53546 Mtetra
.48299 .53546 .48654 .53933 .48943 .53185 .48588 .52798 Mtetra
.733 .595 .703 r
.48588 .52798 .48943 .53185 .49232 .52472 .48877 .52085 Mtetra
.726 .595 .709 r
.48877 .52085 .49232 .52472 .4952 .51831 .49166 .51444 Mtetra
.715 .594 .72 r
.49166 .51444 .4952 .51831 .49809 .51294 .49454 .50907 Mtetra
.696 .592 .736 r
.49454 .50907 .49809 .51294 .50098 .50885 .49743 .50498 Mtetra
.663 .588 .761 r
.49743 .50498 .50098 .50885 .50387 .50619 .50032 .50231 Mtetra
.604 .577 .796 r
.50032 .50231 .50387 .50619 .50676 .50496 .50322 .50108 Mtetra
.496 .546 .838 r
.50322 .50108 .50676 .50496 .50967 .50505 .50612 .50117 Mtetra
.312 .477 .862 r
.50612 .50117 .50967 .50505 .51258 .50622 .50903 .50233 Mtetra
.099 .374 .837 r
.50903 .50233 .51258 .50622 .51551 .50807 .51195 .50417 Mtetra
.014 .328 .813 r
.51195 .50417 .51551 .50807 .51844 .51013 .51488 .50623 Mtetra
.136 .394 .845 r
.51488 .50623 .51844 .51013 .52138 .51189 .51781 .50799 Mtetra
.363 .498 .86 r
.51781 .50799 .52138 .51189 .52433 .51284 .52075 .50893 Mtetra
.535 .558 .825 r
.52075 .50893 .52433 .51284 .52727 .51256 .52369 .50865 Mtetra
.629 .582 .782 r
.52369 .50865 .52727 .51256 .53021 .51082 .52663 .5069 Mtetra
.677 .59 .751 r
.52663 .5069 .53021 .51082 .53315 .5076 .52957 .50369 Mtetra
.7 .593 .733 r
.52957 .50369 .53315 .5076 .53608 .50322 .5325 .4993 Mtetra
.709 .594 .725 r
.5325 .4993 .53608 .50322 .539 .49823 .53542 .49431 Mtetra
.707 .594 .727 r
.53542 .49431 .539 .49823 .54193 .4934 .53835 .48948 Mtetra
.691 .592 .741 r
.53835 .48948 .54193 .4934 .54487 .48954 .54129 .48561 Mtetra
.652 .586 .768 r
.54129 .48561 .54487 .48954 .54783 .48718 .54424 .48325 Mtetra
.584 .572 .806 r
.54424 .48325 .54783 .48718 .5508 .48627 .54721 .48234 Mtetra
.548 .562 .82 r
.54721 .48234 .5508 .48627 .55378 .48584 .55019 .4819 Mtetra
.625 .581 .785 r
.55019 .4819 .55378 .48584 .55676 .48416 .55316 .48022 Mtetra
.669 .589 .757 r
.55316 .48022 .55676 .48416 .55972 .48121 .55613 .47727 Mtetra
.625 .581 .785 r
.55613 .47727 .55972 .48121 .5627 .47952 .55911 .47558 Mtetra
.549 .562 .82 r
.55911 .47558 .5627 .47952 .56571 .47908 .56211 .47514 Mtetra
.584 .572 .806 r
.56211 .47514 .56571 .47908 .56871 .47816 .56511 .47421 Mtetra
.652 .586 .768 r
.56511 .47421 .56871 .47816 .5717 .47578 .5681 .47183 Mtetra
.691 .592 .741 r
.5681 .47183 .5717 .47578 .57467 .47188 .57107 .46793 Mtetra
.707 .594 .727 r
.57107 .46793 .57467 .47188 .57763 .46701 .57403 .46305 Mtetra
.709 .594 .725 r
.57403 .46305 .57763 .46701 .58059 .46198 .57699 .45801 Mtetra
.7 .593 .733 r
.57699 .45801 .58059 .46198 .58356 .45754 .57995 .45358 Mtetra
.677 .59 .751 r
.57995 .45358 .58356 .45754 .58655 .45427 .58294 .45031 Mtetra
.63 .582 .782 r
.58294 .45031 .58655 .45427 .58956 .45246 .58596 .44849 Mtetra
.54 .559 .823 r
.58596 .44849 .58956 .45246 .59261 .45212 .589 .44815 Mtetra
.383 .505 .858 r
.589 .44815 .59261 .45212 .59568 .45301 .59207 .44903 Mtetra
.185 .417 .852 r
.59207 .44903 .59568 .45301 .59878 .45472 .59516 .45074 Mtetra
.079 .363 .831 r
.59516 .45074 .59878 .45472 .60189 .45675 .59827 .45277 Mtetra
.153 .401 .847 r
.59827 .45277 .60189 .45675 .605 .45858 .60138 .45459 Mtetra
.337 .486 .861 r
.60138 .45459 .605 .45858 .60811 .45971 .60448 .45572 Mtetra
.502 .548 .836 r
.60448 .45572 .60811 .45971 .61121 .45976 .60757 .45576 Mtetra
.604 .577 .796 r
.60757 .45576 .61121 .45976 .61428 .45846 .61064 .45445 Mtetra
.662 .588 .761 r
.61064 .45445 .61428 .45846 .61733 .45568 .61369 .45167 Mtetra
.696 .593 .737 r
.61369 .45167 .61733 .45568 .62035 .45144 .61671 .44743 Mtetra
.715 .595 .72 r
.61671 .44743 .62035 .45144 .62334 .44589 .6197 .44187 Mtetra
.727 .596 .709 r
.6197 .44187 .62334 .44589 .62631 .43927 .62267 .43526 Mtetra
.734 .596 .703 r
.62267 .43526 .62631 .43927 .62926 .43194 .62562 .42792 Mtetra
.737 .596 .7 r
.62562 .42792 .62926 .43194 .6322 .42425 .62856 .42024 Mtetra
.736 .596 .7 r
.62856 .42024 .6322 .42425 .63514 .4166 .63151 .41259 Mtetra
.733 .596 .704 r
.63151 .41259 .63514 .4166 .63809 .40938 .63446 .40537 Mtetra
.726 .595 .71 r
.63446 .40537 .63809 .40938 .64106 .40292 .63742 .3989 Mtetra
.714 .595 .722 r
.63742 .3989 .64106 .40292 .64405 .3975 .64042 .39349 Mtetra
.694 .593 .738 r
.64042 .39349 .64405 .3975 .64708 .39335 .64345 .38933 Mtetra
.661 .588 .762 r
.64345 .38933 .64708 .39335 .65015 .39059 .64651 .38657 Mtetra
.604 .576 .796 r
.64651 .38657 .65015 .39059 .65326 .38928 .64963 .38525 Mtetra
.496 .545 .837 r
.64963 .38525 .65326 .38928 .65642 .38939 .65278 .38536 Mtetra
.279 .46 .86 r
.65278 .38536 .65642 .38939 .65963 .39082 .65598 .38679 Mtetra
0 .259 .768 r
.65598 .38679 .65963 .39082 .66288 .39341 .65922 .38938 Mtetra
0 0 .514 r
.65922 .38938 .66288 .39341 .66616 .39694 .6625 .3929 Mtetra
.682 .184 0 r
.6625 .3929 .66616 .39694 .66948 .40113 .66582 .39708 Mtetra
.753 .258 0 r
.66582 .39708 .66948 .40113 .67282 .4057 .66915 .40164 Mtetra
.76 .267 0 r
.66915 .40164 .67282 .4057 .67617 .41033 .6725 .40626 Mtetra
.713 .215 0 r
.6725 .40626 .67617 .41033 .67953 .41471 .67585 .41064 Mtetra
.567 .077 0 r
.67585 .41064 .67953 .41471 .68288 .41854 .6792 .41446 Mtetra
0 .164 .69 r
.6792 .41446 .68288 .41854 .68622 .42156 .68253 .41747 Mtetra
.15 .399 .846 r
.68253 .41747 .68622 .42156 .68953 .42351 .68583 .41942 Mtetra
.422 .52 .853 r
.68583 .41942 .68953 .42351 .69281 .42422 .68911 .42012 Mtetra
.564 .566 .814 r
.68911 .42012 .69281 .42422 .69605 .42354 .69234 .41944 Mtetra
.638 .584 .777 r
.69234 .41944 .69605 .42354 .69923 .4214 .69553 .4173 Mtetra
.681 .591 .748 r
.69553 .4173 .69923 .4214 .70237 .41777 .69867 .41366 Mtetra
.707 .594 .727 r
.69867 .41366 .70237 .41777 .70546 .41268 .70176 .40858 Mtetra
.724 .596 .712 r
.70176 .40858 .70546 .41268 .7085 .40624 .7048 .40213 Mtetra
.736 .596 .701 r
.7048 .40213 .7085 .40624 .7115 .39858 .70779 .39447 Mtetra
.744 .597 .693 r
.70779 .39447 .7115 .39858 .71445 .38987 .71074 .38576 Mtetra
.749 .597 .688 r
.71074 .38576 .71445 .38987 .71736 .38034 .71366 .37623 Mtetra
.752 .597 .684 r
.71366 .37623 .71736 .38034 .72025 .37023 .71655 .36612 Mtetra
.754 .597 .682 r
.71655 .36612 .72025 .37023 .72312 .35978 .71942 .35568 Mtetra
.71942 .35568 .72312 .35978 .72598 .34927 .72229 .34516 Mtetra
.753 .597 .683 r
.72229 .34516 .72598 .34927 .72885 .33894 .72516 .33484 Mtetra
.751 .597 .685 r
.72516 .33484 .72885 .33894 .73173 .32906 .72804 .32496 Mtetra
.747 .597 .689 r
.72804 .32496 .73173 .32906 .73463 .31984 .73095 .31574 Mtetra
.741 .597 .695 r
.73095 .31574 .73463 .31984 .73757 .3115 .73389 .3074 Mtetra
.733 .596 .704 r
.73389 .3074 .73757 .3115 .74055 .30422 .73687 .30012 Mtetra
.721 .595 .716 r
.73687 .30012 .74055 .30422 .74358 .29814 .7399 .29403 Mtetra
.703 .594 .731 r
.7399 .29403 .74358 .29814 .74668 .29337 .743 .28927 Mtetra
.675 .59 .753 r
.743 .28927 .74668 .29337 .74984 .29 .74615 .28589 Mtetra
.63 .582 .782 r
.74615 .28589 .74984 .29 .75306 .28806 .74938 .28395 Mtetra
.551 .562 .819 r
.74938 .28395 .75306 .28806 .75637 .28755 .75268 .28343 Mtetra
.399 .509 .855 r
.75268 .28343 .75637 .28755 .75974 .28844 .75605 .28432 Mtetra
.098 .37 .834 r
.75605 .28432 .75974 .28844 .76319 .29066 .75949 .28653 Mtetra
0 .091 .622 r
.75949 .28653 .76319 .29066 .76671 .29411 .76301 .28998 Mtetra
.68 .183 0 r
.76301 .28998 .76671 .29411 .77029 .29866 .76658 .29453 Mtetra
.813 .334 0 r
.76658 .29453 .77029 .29866 .77394 .30416 .77022 .30002 Mtetra
.859 .406 .079 r
.77022 .30002 .77394 .30416 .77764 .31042 .77391 .30627 Mtetra
.875 .441 .15 r
.77391 .30627 .77764 .31042 .78138 .31725 .77765 .31309 Mtetra
.881 .458 .185 r
.77765 .31309 .78138 .31725 .78516 .32444 .78142 .32027 Mtetra
.883 .462 .195 r
.78142 .32027 .78516 .32444 .78896 .33176 .78521 .32758 Mtetra
.881 .456 .183 r
.78521 .32758 .78896 .33176 .79277 .33899 .78901 .3348 Mtetra
.906 .553 .362 r
.34094 .60314 .34435 .60791 .34681 .61501 .34339 .61024 Mtetra
.905 .555 .37 r
.34339 .61024 .34681 .61501 .34928 .62227 .34585 .61748 Mtetra
.906 .554 .363 r
.34585 .61748 .34928 .62227 .35176 .62946 .34832 .62466 Mtetra
.908 .547 .341 r
.34832 .62466 .35176 .62946 .35426 .63637 .35081 .63157 Mtetra
.91 .533 .295 r
.35081 .63157 .35426 .63637 .35678 .64279 .35333 .63798 Mtetra
.905 .499 .204 r
.35333 .63798 .35678 .64279 .35933 .64852 .35587 .64369 Mtetra
.859 .414 .018 r
.35587 .64369 .35933 .64852 .3619 .65336 .35844 .64853 Mtetra
.628 .178 0 r
.35844 .64853 .3619 .65336 .36452 .65715 .36105 .65231 Mtetra
0 .216 .739 r
.36105 .65231 .36452 .65715 .36716 .65973 .36369 .65489 Mtetra
.341 .44 .817 r
.36369 .65489 .36716 .65973 .36984 .66101 .36636 .65616 Mtetra
.525 .518 .791 r
.36636 .65616 .36984 .66101 .37256 .66089 .36908 .65603 Mtetra
.611 .549 .76 r
.36908 .65603 .37256 .66089 .37531 .65934 .37183 .65448 Mtetra
.658 .563 .736 r
.37183 .65448 .37531 .65934 .37809 .65635 .37461 .65149 Mtetra
.686 .57 .719 r
.37461 .65149 .37809 .65635 .38091 .65197 .37742 .64711 Mtetra
.704 .575 .707 r
.37742 .64711 .38091 .65197 .38375 .64627 .38026 .64141 Mtetra
.716 .578 .698 r
.38026 .64141 .38375 .64627 .38661 .63938 .38312 .63452 Mtetra
.725 .579 .692 r
.38312 .63452 .38661 .63938 .38949 .63145 .386 .62659 Mtetra
.73 .581 .687 r
.386 .62659 .38949 .63145 .39238 .62267 .38889 .61781 Mtetra
.734 .581 .684 r
.38889 .61781 .39238 .62267 .39528 .61324 .39179 .60839 Mtetra
.736 .582 .682 r
.39179 .60839 .39528 .61324 .39818 .60342 .3947 .59857 Mtetra
.737 .582 .681 r
.3947 .59857 .39818 .60342 .40108 .59344 .3976 .58859 Mtetra
.737 .582 .682 r
.3976 .58859 .40108 .59344 .40398 .58355 .4005 .57871 Mtetra
.735 .581 .683 r
.4005 .57871 .40398 .58355 .40687 .57401 .40339 .56917 Mtetra
.732 .581 .686 r
.40339 .56917 .40687 .57401 .40974 .56506 .40627 .56022 Mtetra
.727 .58 .69 r
.40627 .56022 .40974 .56506 .4126 .55691 .40913 .55208 Mtetra
.719 .578 .696 r
.40913 .55208 .4126 .55691 .41545 .54977 .41198 .54493 Mtetra
.708 .576 .705 r
.41198 .54493 .41545 .54977 .41827 .54379 .41481 .53895 Mtetra
.691 .572 .716 r
.41481 .53895 .41827 .54379 .42109 .5391 .41762 .53426 Mtetra
.665 .565 .732 r
.41762 .53426 .42109 .5391 .42388 .53578 .42041 .53094 Mtetra
.625 .553 .754 r
.42041 .53094 .42388 .53578 .42666 .53386 .42319 .52902 Mtetra
.555 .53 .781 r
.42319 .52902 .42666 .53386 .42943 .53333 .42596 .52849 Mtetra
.427 .478 .81 r
.42596 .52849 .42943 .53333 .43219 .53412 .42871 .52927 Mtetra
.181 .36 .807 r
.42871 .52927 .43219 .53412 .43495 .5361 .43146 .53124 Mtetra
0 .13 .677 r
.43146 .53124 .43495 .5361 .4377 .5391 .43421 .53424 Mtetra
0 0 .421 r
.43421 .53424 .4377 .5391 .44045 .54291 .43695 .53804 Mtetra
.735 .274 0 r
.43695 .53804 .44045 .54291 .4432 .54728 .4397 .5424 Mtetra
.789 .33 0 r
.4397 .5424 .4432 .54728 .44597 .55192 .44246 .54703 Mtetra
.781 .321 0 r
.44246 .54703 .44597 .55192 .44874 .55654 .44523 .55164 Mtetra
.701 .242 0 r
.44523 .55164 .44874 .55654 .45153 .56082 .44801 .55591 Mtetra
0 0 .503 r
.44801 .55591 .45153 .56082 .45433 .56447 .4508 .55955 Mtetra
0 .218 .74 r
.4508 .55955 .45433 .56447 .45715 .56722 .45361 .56229 Mtetra
.287 .414 .817 r
.45361 .56229 .45715 .56722 .45998 .56883 .45644 .5639 Mtetra
.486 .503 .8 r
.45644 .5639 .45998 .56883 .46282 .56913 .45928 .56419 Mtetra
.589 .541 .769 r
.45928 .56419 .46282 .56913 .46568 .56801 .46214 .56307 Mtetra
.644 .559 .744 r
.46214 .56307 .46568 .56801 .46855 .56543 .46501 .56049 Mtetra
.677 .568 .725 r
.46501 .56049 .46855 .56543 .47143 .56146 .46789 .55651 Mtetra
.697 .573 .712 r
.46789 .55651 .47143 .56146 .47432 .55622 .47077 .55128 Mtetra
.709 .576 .703 r
.47077 .55128 .47432 .55622 .47721 .54994 .47366 .545 Mtetra
.717 .578 .698 r
.47366 .545 .47721 .54994 .4801 .5429 .47655 .53796 Mtetra
.72 .578 .695 r
.47655 .53796 .4801 .5429 .48299 .53546 .47945 .53052 Mtetra
.721 .579 .695 r
.47945 .53052 .48299 .53546 .48588 .52798 .48234 .52304 Mtetra
.718 .578 .697 r
.48234 .52304 .48588 .52798 .48877 .52085 .48523 .51591 Mtetra
.711 .576 .702 r
.48523 .51591 .48877 .52085 .49166 .51444 .48811 .5095 Mtetra
.699 .574 .711 r
.48811 .5095 .49166 .51444 .49454 .50907 .491 .50413 Mtetra
.679 .569 .724 r
.491 .50413 .49454 .50907 .49743 .50498 .49388 .50004 Mtetra
.646 .56 .743 r
.49388 .50004 .49743 .50498 .50032 .50231 .49677 .49737 Mtetra
.593 .543 .768 r
.49677 .49737 .50032 .50231 .50322 .50108 .49966 .49613 Mtetra
.507 .511 .796 r
.49966 .49613 .50322 .50108 .50612 .50117 .50256 .49622 Mtetra
.379 .458 .815 r
.50256 .49622 .50612 .50117 .50903 .50233 .50547 .49737 Mtetra
.245 .394 .814 r
.50547 .49737 .50903 .50233 .51195 .50417 .50838 .49921 Mtetra
.192 .366 .809 r
.50838 .49921 .51195 .50417 .51488 .50623 .51131 .50126 Mtetra
.268 .405 .816 r
.51131 .50126 .51488 .50623 .51781 .50799 .51424 .50301 Mtetra
.413 .472 .812 r
.51424 .50301 .51781 .50799 .52075 .50893 .51717 .50395 Mtetra
.536 .523 .787 r
.51717 .50395 .52075 .50893 .52369 .50865 .52011 .50366 Mtetra
.615 .55 .758 r
.52011 .50366 .52369 .50865 .52663 .5069 .52305 .50191 Mtetra
.659 .563 .736 r
.52305 .50191 .52663 .5069 .52957 .50369 .52598 .49869 Mtetra
.683 .57 .721 r
.52598 .49869 .52957 .50369 .5325 .4993 .52891 .4943 Mtetra
.692 .572 .715 r
.52891 .4943 .5325 .4993 .53542 .49431 .53183 .48931 Mtetra
.69 .571 .717 r
.53183 .48931 .53542 .49431 .53835 .48948 .53476 .48448 Mtetra
.673 .567 .727 r
.53476 .48448 .53835 .48948 .54129 .48561 .5377 .48061 Mtetra
.636 .556 .748 r
.5377 .48061 .54129 .48561 .54424 .48325 .54065 .47825 Mtetra
.576 .537 .774 r
.54065 .47825 .54424 .48325 .54721 .48234 .54362 .47733 Mtetra
.547 .526 .784 r
.54362 .47733 .54721 .48234 .55019 .4819 .54659 .47689 Mtetra
.611 .549 .76 r
.54659 .47689 .55019 .4819 .55316 .48022 .54956 .47521 Mtetra
.652 .561 .739 r
.54956 .47521 .55316 .48022 .55613 .47727 .55252 .47225 Mtetra
.611 .549 .76 r
.55252 .47225 .55613 .47727 .55911 .47558 .5555 .47056 Mtetra
.547 .527 .784 r
.5555 .47056 .55911 .47558 .56211 .47514 .5585 .47011 Mtetra
.576 .537 .774 r
.5585 .47011 .56211 .47514 .56511 .47421 .5615 .46918 Mtetra
.636 .556 .748 r
.5615 .46918 .56511 .47421 .5681 .47183 .56448 .46679 Mtetra
.673 .567 .727 r
.56448 .46679 .5681 .47183 .57107 .46793 .56745 .46289 Mtetra
.69 .571 .717 r
.56745 .46289 .57107 .46793 .57403 .46305 .57041 .45802 Mtetra
.692 .572 .715 r
.57041 .45802 .57403 .46305 .57699 .45801 .57337 .45298 Mtetra
.683 .57 .721 r
.57337 .45298 .57699 .45801 .57995 .45358 .57633 .44854 Mtetra
.659 .563 .736 r
.57633 .44854 .57995 .45358 .58294 .45031 .57932 .44526 Mtetra
.615 .55 .758 r
.57932 .44526 .58294 .45031 .58596 .44849 .58233 .44345 Mtetra
.54 .524 .786 r
.58233 .44345 .58596 .44849 .589 .44815 .58537 .4431 Mtetra
.425 .478 .811 r
.58537 .4431 .589 .44815 .59207 .44903 .58843 .44398 Mtetra
.297 .419 .817 r
.58843 .44398 .59207 .44903 .59516 .45074 .59152 .44568 Mtetra
.23 .386 .813 r
.59152 .44568 .59516 .45074 .59827 .45277 .59462 .4477 Mtetra
.276 .409 .816 r
.59462 .4477 .59827 .45277 .60138 .45459 .59773 .44951 Mtetra
.395 .464 .814 r
.59773 .44951 .60138 .45459 .60448 .45572 .60083 .45063 Mtetra
.511 .513 .795 r
.60083 .45063 .60448 .45572 .60757 .45576 .60392 .45067 Mtetra
.593 .543 .767 r
.60392 .45067 .60757 .45576 .61064 .45445 .60698 .44936 Mtetra
.646 .559 .743 r
.60698 .44936 .61064 .45445 .61369 .45167 .61003 .44657 Mtetra
.678 .568 .724 r
.61003 .44657 .61369 .45167 .61671 .44743 .61305 .44233 Mtetra
.698 .573 .711 r
.61305 .44233 .61671 .44743 .6197 .44187 .61604 .43678 Mtetra
.711 .576 .702 r
.61604 .43678 .6197 .44187 .62267 .43526 .61901 .43017 Mtetra
.718 .578 .697 r
.61901 .43017 .62267 .43526 .62562 .42792 .62196 .42283 Mtetra
.721 .579 .694 r
.62196 .42283 .62562 .42792 .62856 .42024 .6249 .41514 Mtetra
.721 .578 .694 r
.6249 .41514 .62856 .42024 .63151 .41259 .62784 .4075 Mtetra
.717 .578 .697 r
.62784 .4075 .63151 .41259 .63446 .40537 .6308 .40027 Mtetra
.709 .576 .703 r
.6308 .40027 .63446 .40537 .63742 .3989 .63376 .39381 Mtetra
.697 .573 .712 r
.63376 .39381 .63742 .3989 .64042 .39349 .63676 .3884 Mtetra
.676 .568 .725 r
.63676 .3884 .64042 .39349 .64345 .38933 .63978 .38424 Mtetra
.645 .559 .744 r
.63978 .38424 .64345 .38933 .64651 .38657 .64285 .38147 Mtetra
.593 .543 .768 r
.64285 .38147 .64651 .38657 .64963 .38525 .64596 .38015 Mtetra
.506 .511 .796 r
.64596 .38015 .64963 .38525 .65278 .38536 .64911 .38025 Mtetra
.355 .447 .817 r
.64911 .38025 .65278 .38536 .65598 .38679 .65231 .38168 Mtetra
.112 .324 .795 r
.65231 .38168 .65598 .38679 .65922 .38938 .65554 .38426 Mtetra
0 .144 .688 r
.65554 .38426 .65922 .38938 .6625 .3929 .65882 .38777 Mtetra
0 0 .537 r
.65882 .38777 .6625 .3929 .66582 .39708 .66212 .39194 Mtetra
0 0 .436 r
.66212 .39194 .66582 .39708 .66915 .40164 .66545 .39649 Mtetra
0 0 .423 r
.66545 .39649 .66915 .40164 .6725 .40626 .66879 .40111 Mtetra
0 0 .499 r
.66879 .40111 .6725 .40626 .67585 .41064 .67213 .40547 Mtetra
0 .085 .64 r
.67213 .40547 .67585 .41064 .6792 .41446 .67547 .40929 Mtetra
.008 .265 .768 r
.67547 .40929 .6792 .41446 .68253 .41747 .6788 .41228 Mtetra
.273 .408 .816 r
.6788 .41228 .68253 .41747 .68583 .41942 .6821 .41423 Mtetra
.452 .489 .807 r
.6821 .41423 .68583 .41942 .68911 .42012 .68537 .41492 Mtetra
.559 .531 .78 r
.68537 .41492 .68911 .42012 .69234 .41944 .6886 .41424 Mtetra
.623 .553 .754 r
.6886 .41424 .69234 .41944 .69553 .4173 .69178 .41209 Mtetra
.663 .564 .733 r
.69178 .41209 .69553 .4173 .69867 .41366 .69492 .40845 Mtetra
.69 .571 .717 r
.69492 .40845 .69867 .41366 .70176 .40858 .69801 .40337 Mtetra
.708 .576 .704 r
.69801 .40337 .70176 .40858 .7048 .40213 .70105 .39692 Mtetra
.72 .578 .695 r
.70105 .39692 .7048 .40213 .70779 .39447 .70404 .38926 Mtetra
.728 .58 .688 r
.70404 .38926 .70779 .39447 .71074 .38576 .707 .38056 Mtetra
.734 .581 .684 r
.707 .38056 .71074 .38576 .71366 .37623 .70992 .37103 Mtetra
.738 .582 .68 r
.70992 .37103 .71366 .37623 .71655 .36612 .71281 .36092 Mtetra
.74 .582 .679 r
.71281 .36092 .71655 .36612 .71942 .35568 .71569 .35048 Mtetra
.741 .582 .678 r
.71569 .35048 .71942 .35568 .72229 .34516 .71855 .33997 Mtetra
.74 .582 .679 r
.71855 .33997 .72229 .34516 .72516 .33484 .72142 .32965 Mtetra
.737 .582 .681 r
.72142 .32965 .72516 .33484 .72804 .32496 .72431 .31977 Mtetra
.733 .581 .685 r
.72431 .31977 .72804 .32496 .73095 .31574 .72722 .31056 Mtetra
.726 .58 .69 r
.72722 .31056 .73095 .31574 .73389 .3074 .73016 .30222 Mtetra
.717 .578 .697 r
.73016 .30222 .73389 .3074 .73687 .30012 .73314 .29494 Mtetra
.704 .575 .707 r
.73314 .29494 .73687 .30012 .7399 .29403 .73618 .28886 Mtetra
.685 .57 .72 r
.73618 .28886 .7399 .29403 .743 .28927 .73927 .28409 Mtetra
.657 .563 .737 r
.73927 .28409 .743 .28927 .74615 .28589 .74242 .28071 Mtetra
.616 .55 .758 r
.74242 .28071 .74615 .28589 .74938 .28395 .74565 .27876 Mtetra
.549 .527 .784 r
.74565 .27876 .74938 .28395 .75268 .28343 .74894 .27824 Mtetra
.435 .482 .81 r
.74894 .27824 .75268 .28343 .75605 .28432 .75231 .27912 Mtetra
.236 .389 .814 r
.75231 .27912 .75605 .28432 .75949 .28653 .75575 .28133 Mtetra
0 .213 .737 r
.75575 .28133 .75949 .28653 .76301 .28998 .75925 .28477 Mtetra
0 0 .531 r
.75925 .28477 .76301 .28998 .76658 .29453 .76282 .2893 Mtetra
.683 .225 0 r
.76282 .2893 .76658 .29453 .77022 .30002 .76645 .29478 Mtetra
.798 .339 0 r
.76645 .29478 .77022 .30002 .77391 .30627 .77013 .30102 Mtetra
.847 .397 0 r
.77013 .30102 .77391 .30627 .77765 .31309 .77386 .30783 Mtetra
.867 .424 .04 r
.77386 .30783 .77765 .31309 .78142 .32027 .77762 .31499 Mtetra
.871 .432 .055 r
.77762 .31499 .78142 .32027 .78521 .32758 .7814 .32229 Mtetra
.865 .423 .036 r
.7814 .32229 .78521 .32758 .78901 .3348 .7852 .3295 Mtetra
.922 .558 .316 r
.33754 .59771 .34094 .60314 .34339 .61024 .33999 .6048 Mtetra
.922 .561 .326 r
.33999 .6048 .34339 .61024 .34585 .61748 .34244 .61203 Mtetra
.922 .559 .318 r
.34244 .61203 .34585 .61748 .34832 .62466 .3449 .6192 Mtetra
.923 .55 .289 r
.3449 .6192 .34832 .62466 .35081 .63157 .34739 .62609 Mtetra
.92 .53 .228 r
.34739 .62609 .35081 .63157 .35333 .63798 .34989 .63248 Mtetra
.898 .481 .108 r
.34989 .63248 .35333 .63798 .35587 .64369 .35243 .63819 Mtetra
.794 .356 0 r
.35243 .63819 .35587 .64369 .35844 .64853 .35499 .64301 Mtetra
0 0 .507 r
.35499 .64301 .35844 .64853 .36105 .65231 .35759 .64678 Mtetra
.061 .264 .756 r
.35759 .64678 .36105 .65231 .36369 .65489 .36023 .64935 Mtetra
.375 .432 .792 r
.36023 .64935 .36369 .65489 .36636 .65616 .3629 .65062 Mtetra
.526 .501 .771 r
.3629 .65062 .36636 .65616 .36908 .65603 .36561 .65049 Mtetra
.604 .532 .747 r
.36561 .65049 .36908 .65603 .37183 .65448 .36836 .64893 Mtetra
.648 .548 .728 r
.36836 .64893 .37183 .65448 .37461 .65149 .37114 .64594 Mtetra
.676 .558 .713 r
.37114 .64594 .37461 .65149 .37742 .64711 .37395 .64156 Mtetra
.695 .564 .703 r
.37395 .64156 .37742 .64711 .38026 .64141 .37678 .63586 Mtetra
.708 .568 .695 r
.37678 .63586 .38026 .64141 .38312 .63452 .37965 .62897 Mtetra
.717 .57 .689 r
.37965 .62897 .38312 .63452 .386 .62659 .38253 .62104 Mtetra
.723 .572 .685 r
.38253 .62104 .386 .62659 .38889 .61781 .38542 .61227 Mtetra
.727 .573 .682 r
.38542 .61227 .38889 .61781 .39179 .60839 .38833 .60285 Mtetra
.729 .574 .68 r
.38833 .60285 .39179 .60839 .3947 .59857 .39123 .59304 Mtetra
.73 .574 .679 r
.39123 .59304 .3947 .59857 .3976 .58859 .39414 .58306 Mtetra
.73 .574 .68 r
.39414 .58306 .3976 .58859 .4005 .57871 .39704 .57319 Mtetra
.728 .574 .681 r
.39704 .57319 .4005 .57871 .40339 .56917 .39993 .56365 Mtetra
.724 .573 .684 r
.39993 .56365 .40339 .56917 .40627 .56022 .40281 .55471 Mtetra
.719 .571 .687 r
.40281 .55471 .40627 .56022 .40913 .55208 .40567 .54657 Mtetra
.711 .569 .693 r
.40567 .54657 .40913 .55208 .41198 .54493 .40852 .53943 Mtetra
.699 .565 .7 r
.40852 .53943 .41198 .54493 .41481 .53895 .41135 .53345 Mtetra
.682 .56 .711 r
.41135 .53345 .41481 .53895 .41762 .53426 .41416 .52876 Mtetra
.656 .551 .724 r
.41416 .52876 .41762 .53426 .42041 .53094 .41695 .52544 Mtetra
.617 .537 .742 r
.41695 .52544 .42041 .53094 .42319 .52902 .41972 .52351 Mtetra
.553 .512 .764 r
.41972 .52351 .42319 .52902 .42596 .52849 .42249 .52297 Mtetra
.443 .465 .787 r
.42249 .52297 .42596 .52849 .42871 .52927 .42524 .52375 Mtetra
.251 .37 .79 r
.42524 .52375 .42871 .52927 .43146 .53124 .42798 .52571 Mtetra
0 .198 .722 r
.42798 .52571 .43146 .53124 .43421 .53424 .43072 .5287 Mtetra
0 0 .554 r
.43072 .5287 .43421 .53424 .43695 .53804 .43346 .53249 Mtetra
0 0 .381 r
.43346 .53249 .43695 .53804 .4397 .5424 .43621 .53684 Mtetra
.675 .245 0 r
.43621 .53684 .4397 .5424 .44246 .54703 .43896 .54146 Mtetra
.663 .234 0 r
.43896 .54146 .44246 .54703 .44523 .55164 .44172 .54606 Mtetra
0 0 .426 r
.44172 .54606 .44523 .55164 .44801 .55591 .44449 .55032 Mtetra
0 .047 .613 r
.44449 .55032 .44801 .55591 .4508 .55955 .44728 .55395 Mtetra
.059 .264 .756 r
.44728 .55395 .4508 .55955 .45361 .56229 .45009 .55668 Mtetra
.332 .411 .793 r
.45009 .55668 .45361 .56229 .45644 .5639 .45291 .55828 Mtetra
.493 .487 .779 r
.45291 .55828 .45644 .5639 .45928 .56419 .45575 .55857 Mtetra
.583 .524 .755 r
.45575 .55857 .45928 .56419 .46214 .56307 .4586 .55744 Mtetra
.635 .544 .734 r
.4586 .55744 .46214 .56307 .46501 .56049 .46147 .55486 Mtetra
.667 .555 .718 r
.46147 .55486 .46501 .56049 .46789 .55651 .46434 .55088 Mtetra
.688 .561 .707 r
.46434 .55088 .46789 .55651 .47077 .55128 .46723 .54564 Mtetra
.7 .565 .699 r
.46723 .54564 .47077 .55128 .47366 .545 .47012 .53937 Mtetra
.708 .568 .694 r
.47012 .53937 .47366 .545 .47655 .53796 .47301 .53233 Mtetra
.712 .569 .692 r
.47301 .53233 .47655 .53796 .47945 .53052 .4759 .52489 Mtetra
.712 .569 .691 r
.4759 .52489 .47945 .53052 .48234 .52304 .47879 .51742 Mtetra
.709 .568 .694 r
.47879 .51742 .48234 .52304 .48523 .51591 .48168 .51029 Mtetra
.702 .566 .698 r
.48168 .51029 .48523 .51591 .48811 .5095 .48457 .50389 Mtetra
.689 .562 .706 r
.48457 .50389 .48811 .5095 .491 .50413 .48745 .49851 Mtetra
.669 .556 .717 r
.48745 .49851 .491 .50413 .49388 .50004 .49034 .49442 Mtetra
.638 .545 .733 r
.49034 .49442 .49388 .50004 .49677 .49737 .49322 .49174 Mtetra
.587 .526 .753 r
.49322 .49174 .49677 .49737 .49966 .49613 .49611 .49051 Mtetra
.51 .494 .775 r
.49611 .49051 .49966 .49613 .50256 .49622 .49901 .49058 Mtetra
.404 .447 .791 r
.49901 .49058 .50256 .49622 .50547 .49737 .50191 .49173 Mtetra
.299 .395 .793 r
.50191 .49173 .50547 .49737 .50838 .49921 .50482 .49356 Mtetra
.258 .374 .791 r
.50482 .49356 .50838 .49921 .51131 .50126 .50774 .49561 Mtetra
.317 .404 .794 r
.50774 .49561 .51131 .50126 .51424 .50301 .51066 .49735 Mtetra
.431 .459 .788 r
.51066 .49735 .51424 .50301 .51717 .50395 .51359 .49828 Mtetra
.536 .505 .769 r
.51359 .49828 .51717 .50395 .52011 .50366 .51653 .49799 Mtetra
.607 .534 .746 r
.51653 .49799 .52011 .50366 .52305 .50191 .51946 .49623 Mtetra
.65 .549 .727 r
.51946 .49623 .52305 .50191 .52598 .49869 .52239 .49301 Mtetra
.673 .557 .715 r
.52239 .49301 .52598 .49869 .52891 .4943 .52532 .48862 Mtetra
.683 .56 .709 r
.52532 .48862 .52891 .4943 .53183 .48931 .52824 .48363 Mtetra
.68 .559 .711 r
.52824 .48363 .53183 .48931 .53476 .48448 .53117 .4788 Mtetra
.664 .554 .72 r
.53117 .4788 .53476 .48448 .5377 .48061 .5341 .47493 Mtetra
.627 .541 .738 r
.5341 .47493 .5377 .48061 .54065 .47825 .53705 .47256 Mtetra
.571 .52 .759 r
.53705 .47256 .54065 .47825 .54362 .47733 .54001 .47164 Mtetra
.545 .509 .767 r
.54001 .47164 .54362 .47733 .54659 .47689 .54299 .47119 Mtetra
.604 .532 .747 r
.54299 .47119 .54659 .47689 .54956 .47521 .54595 .4695 Mtetra
.643 .547 .73 r
.54595 .4695 .54956 .47521 .55252 .47225 .54891 .46654 Mtetra
.604 .532 .747 r
.54891 .46654 .55252 .47225 .5555 .47056 .55189 .46485 Mtetra
.545 .509 .766 r
.55189 .46485 .5555 .47056 .5585 .47011 .55488 .46439 Mtetra
.571 .52 .759 r
.55488 .46439 .5585 .47011 .5615 .46918 .55787 .46346 Mtetra
.627 .541 .738 r
.55787 .46346 .5615 .46918 .56448 .46679 .56086 .46107 Mtetra
.664 .554 .72 r
.56086 .46107 .56448 .46679 .56745 .46289 .56382 .45716 Mtetra
.68 .559 .711 r
.56382 .45716 .56745 .46289 .57041 .45802 .56678 .45229 Mtetra
.683 .56 .709 r
.56678 .45229 .57041 .45802 .57337 .45298 .56974 .44725 Mtetra
.673 .557 .715 r
.56974 .44725 .57337 .45298 .57633 .44854 .5727 .44281 Mtetra
.65 .549 .727 r
.5727 .44281 .57633 .44854 .57932 .44526 .57569 .43953 Mtetra
.608 .534 .746 r
.57569 .43953 .57932 .44526 .58233 .44345 .5787 .43772 Mtetra
.539 .507 .768 r
.5787 .43772 .58233 .44345 .58537 .4431 .58173 .43736 Mtetra
.442 .464 .787 r
.58173 .43736 .58537 .4431 .58843 .44398 .58479 .43823 Mtetra
.339 .415 .794 r
.58479 .43823 .58843 .44398 .59152 .44568 .58787 .43992 Mtetra
.287 .389 .793 r
.58787 .43992 .59152 .44568 .59462 .4477 .59097 .44193 Mtetra
.323 .407 .794 r
.59097 .44193 .59462 .4477 .59773 .44951 .59407 .44374 Mtetra
.417 .453 .79 r
.59407 .44374 .59773 .44951 .60083 .45063 .59716 .44485 Mtetra
.514 .496 .775 r
.59716 .44485 .60083 .45063 .60392 .45067 .60025 .44489 Mtetra
.587 .526 .753 r
.60025 .44489 .60392 .45067 .60698 .44936 .60331 .44357 Mtetra
.637 .544 .733 r
.60331 .44357 .60698 .44936 .61003 .44657 .60635 .44078 Mtetra
.669 .555 .717 r
.60635 .44078 .61003 .44657 .61305 .44233 .60937 .43654 Mtetra
.689 .562 .706 r
.60937 .43654 .61305 .44233 .61604 .43678 .61236 .43098 Mtetra
.702 .565 .698 r
.61236 .43098 .61604 .43678 .61901 .43017 .61533 .42437 Mtetra
.709 .568 .693 r
.61533 .42437 .61901 .43017 .62196 .42283 .61828 .41704 Mtetra
.712 .569 .691 r
.61828 .41704 .62196 .42283 .6249 .41514 .62123 .40935 Mtetra
.62123 .40935 .6249 .41514 .62784 .4075 .62417 .40171 Mtetra
.708 .567 .694 r
.62417 .40171 .62784 .4075 .6308 .40027 .62712 .39449 Mtetra
.7 .565 .699 r
.62712 .39449 .6308 .40027 .63376 .39381 .63009 .38803 Mtetra
.687 .561 .707 r
.63009 .38803 .63376 .39381 .63676 .3884 .63308 .38262 Mtetra
.667 .555 .718 r
.63308 .38262 .63676 .3884 .63978 .38424 .63611 .37845 Mtetra
.636 .544 .734 r
.63611 .37845 .63978 .38424 .64285 .38147 .63917 .37569 Mtetra
.587 .526 .753 r
.63917 .37569 .64285 .38147 .64596 .38015 .64227 .37436 Mtetra
.509 .494 .776 r
.64227 .37436 .64596 .38015 .64911 .38025 .64542 .37446 Mtetra
.384 .438 .793 r
.64542 .37446 .64911 .38025 .65231 .38168 .64861 .37587 Mtetra
.195 .342 .785 r
.64861 .37587 .65231 .38168 .65554 .38426 .65184 .37844 Mtetra
0 .205 .727 r
.65184 .37844 .65554 .38426 .65882 .38777 .65511 .38194 Mtetra
0 .069 .632 r
.65511 .38194 .65882 .38777 .66212 .39194 .6584 .38611 Mtetra
0 0 .558 r
.6584 .38611 .66212 .39194 .66545 .39649 .66172 .39065 Mtetra
0 0 .548 r
.66172 .39065 .66545 .39649 .66879 .40111 .66506 .39525 Mtetra
0 .038 .605 r
.66506 .39525 .66879 .40111 .67213 .40547 .6684 .3996 Mtetra
0 .159 .698 r
.6684 .3996 .67213 .40547 .67547 .40929 .67173 .40341 Mtetra
.114 .297 .771 r
.67173 .40341 .67547 .40929 .6788 .41228 .67505 .40639 Mtetra
.32 .406 .795 r
.67505 .40639 .6788 .41228 .6821 .41423 .67834 .40833 Mtetra
.464 .475 .784 r
.67834 .40833 .6821 .41423 .68537 .41492 .68161 .40902 Mtetra
.556 .514 .763 r
.68161 .40902 .68537 .41492 .6886 .41424 .68483 .40832 Mtetra
.615 .536 .742 r
.68483 .40832 .6886 .41424 .69178 .41209 .68801 .40617 Mtetra
.654 .55 .725 r
.68801 .40617 .69178 .41209 .69492 .40845 .69115 .40253 Mtetra
.68 .559 .711 r
.69115 .40253 .69492 .40845 .69801 .40337 .69423 .39745 Mtetra
.698 .564 .7 r
.69423 .39745 .69801 .40337 .70105 .39692 .69727 .391 Mtetra
.711 .568 .692 r
.69727 .391 .70105 .39692 .70404 .38926 .70027 .38334 Mtetra
.72 .57 .686 r
.70027 .38334 .70404 .38926 .707 .38056 .70322 .37464 Mtetra
.726 .572 .681 r
.70322 .37464 .707 .38056 .70992 .37103 .70615 .36512 Mtetra
.73 .573 .678 r
.70615 .36512 .70992 .37103 .71281 .36092 .70904 .35502 Mtetra
.732 .574 .677 r
.70904 .35502 .71281 .36092 .71569 .35048 .71192 .34458 Mtetra
.732 .574 .676 r
.71192 .34458 .71569 .35048 .71855 .33997 .71479 .33408 Mtetra
.731 .574 .677 r
.71479 .33408 .71855 .33997 .72142 .32965 .71766 .32377 Mtetra
.729 .573 .679 r
.71766 .32377 .72142 .32965 .72431 .31977 .72055 .31389 Mtetra
.724 .572 .682 r
.72055 .31389 .72431 .31977 .72722 .31056 .72346 .30469 Mtetra
.717 .57 .687 r
.72346 .30469 .72722 .31056 .73016 .30222 .7264 .29635 Mtetra
.708 .567 .694 r
.7264 .29635 .73016 .30222 .73314 .29494 .72938 .28907 Mtetra
.694 .563 .702 r
.72938 .28907 .73314 .29494 .73618 .28886 .73242 .28299 Mtetra
.675 .557 .714 r
.73242 .28299 .73618 .28886 .73927 .28409 .73551 .27822 Mtetra
.648 .548 .728 r
.73551 .27822 .73927 .28409 .74242 .28071 .73866 .27484 Mtetra
.608 .534 .746 r
.73866 .27484 .74242 .28071 .74565 .27876 .74188 .27289 Mtetra
.547 .51 .767 r
.74188 .27289 .74565 .27876 .74894 .27824 .74517 .27236 Mtetra
.449 .469 .787 r
.74517 .27236 .74894 .27824 .75231 .27912 .74854 .27323 Mtetra
.289 .392 .795 r
.74854 .27323 .75231 .27912 .75575 .28133 .75197 .27543 Mtetra
.041 .257 .754 r
.75197 .27543 .75575 .28133 .75925 .28477 .75547 .27886 Mtetra
0 .061 .624 r
.75547 .27886 .75925 .28477 .76282 .2893 .75903 .28338 Mtetra
0 0 .429 r
.75903 .28338 .76282 .2893 .76645 .29478 .76265 .28885 Mtetra
.708 .27 0 r
.76265 .28885 .76645 .29478 .77013 .30102 .76632 .29507 Mtetra
.789 .346 0 r
.76632 .29507 .77013 .30102 .77386 .30783 .77004 .30187 Mtetra
.823 .383 0 r
.77004 .30187 .77386 .30783 .77762 .31499 .77379 .30901 Mtetra
.833 .393 0 r
.77379 .30901 .77762 .31499 .7814 .32229 .77756 .3163 Mtetra
.821 .381 0 r
.77756 .3163 .7814 .32229 .7852 .3295 .78134 .32349 Mtetra
.926 .559 .299 r
.33416 .59208 .33754 .59771 .33999 .6048 .33659 .59915 Mtetra
.926 .562 .31 r
.33659 .59915 .33999 .6048 .34244 .61203 .33903 .60637 Mtetra
.926 .559 .302 r
.33903 .60637 .34244 .61203 .3449 .6192 .34149 .61352 Mtetra
.926 .55 .27 r
.34149 .61352 .3449 .6192 .34739 .62609 .34397 .6204 Mtetra
.92 .527 .204 r
.34397 .6204 .34739 .62609 .34989 .63248 .34646 .62679 Mtetra
.89 .472 .074 r
.34646 .62679 .34989 .63248 .35243 .63819 .34899 .63248 Mtetra
.763 .333 0 r
.34899 .63248 .35243 .63819 .35499 .64301 .35155 .63729 Mtetra
0 0 .542 r
.35155 .63729 .35499 .64301 .35759 .64678 .35414 .64105 Mtetra
.093 .274 .756 r
.35414 .64105 .35759 .64678 .36023 .64935 .35677 .64361 Mtetra
.383 .429 .785 r
.35677 .64361 .36023 .64935 .3629 .65062 .35944 .64487 Mtetra
.526 .496 .766 r
.35944 .64487 .3629 .65062 .36561 .65049 .36215 .64473 Mtetra
.602 .527 .743 r
.36215 .64473 .36561 .65049 .36836 .64893 .36489 .64317 Mtetra
.646 .544 .725 r
.36489 .64317 .36836 .64893 .37114 .64594 .36767 .64018 Mtetra
.674 .554 .712 r
.36767 .64018 .37114 .64594 .37395 .64156 .37048 .63579 Mtetra
.692 .561 .701 r
.37048 .63579 .37395 .64156 .37678 .63586 .37332 .6301 Mtetra
.705 .565 .694 r
.37332 .6301 .37678 .63586 .37965 .62897 .37618 .62321 Mtetra
.714 .568 .688 r
.37618 .62321 .37965 .62897 .38253 .62104 .37906 .61529 Mtetra
.72 .57 .684 r
.37906 .61529 .38253 .62104 .38542 .61227 .38196 .60652 Mtetra
.725 .571 .681 r
.38196 .60652 .38542 .61227 .38833 .60285 .38486 .59711 Mtetra
.727 .572 .679 r
.38486 .59711 .38833 .60285 .39123 .59304 .38777 .5873 Mtetra
.728 .572 .679 r
.38777 .5873 .39123 .59304 .39414 .58306 .39068 .57733 Mtetra
.39068 .57733 .39414 .58306 .39704 .57319 .39358 .56746 Mtetra
.726 .571 .68 r
.39358 .56746 .39704 .57319 .39993 .56365 .39647 .55793 Mtetra
.722 .57 .683 r
.39647 .55793 .39993 .56365 .40281 .55471 .39935 .54899 Mtetra
.716 .568 .687 r
.39935 .54899 .40281 .55471 .40567 .54657 .40222 .54085 Mtetra
.708 .566 .692 r
.40222 .54085 .40567 .54657 .40852 .53943 .40506 .53372 Mtetra
.696 .562 .699 r
.40506 .53372 .40852 .53943 .41135 .53345 .40789 .52774 Mtetra
.679 .556 .709 r
.40789 .52774 .41135 .53345 .41416 .52876 .4107 .52305 Mtetra
.654 .547 .722 r
.4107 .52305 .41416 .52876 .41695 .52544 .41349 .51972 Mtetra
.615 .533 .739 r
.41349 .51972 .41695 .52544 .41972 .52351 .41626 .5178 Mtetra
.552 .508 .759 r
.41626 .5178 .41972 .52351 .42249 .52297 .41902 .51725 Mtetra
.447 .461 .78 r
.41902 .51725 .42249 .52297 .42524 .52375 .42177 .51802 Mtetra
.267 .371 .784 r
.42177 .51802 .42524 .52375 .42798 .52571 .42451 .51997 Mtetra
0 .213 .728 r
.42451 .51997 .42798 .52571 .43072 .5287 .42724 .52295 Mtetra
0 .011 .583 r
.42724 .52295 .43072 .5287 .43346 .53249 .42998 .52674 Mtetra
0 0 .424 r
.42998 .52674 .43346 .53249 .43621 .53684 .43271 .53107 Mtetra
.631 .216 0 r
.43271 .53107 .43621 .53684 .43896 .54146 .43546 .53569 Mtetra
.617 .204 0 r
.43546 .53569 .43896 .54146 .44172 .54606 .43821 .54027 Mtetra
0 0 .466 r
.43821 .54027 .44172 .54606 .44449 .55032 .44098 .54452 Mtetra
0 .073 .635 r
.44098 .54452 .44449 .55032 .44728 .55395 .44376 .54814 Mtetra
.09 .274 .757 r
.44376 .54814 .44728 .55395 .45009 .55668 .44656 .55087 Mtetra
.343 .41 .787 r
.44656 .55087 .45009 .55668 .45291 .55828 .44938 .55246 Mtetra
.494 .482 .773 r
.44938 .55246 .45291 .55828 .45575 .55857 .45221 .55274 Mtetra
.581 .519 .751 r
.45221 .55274 .45575 .55857 .4586 .55744 .45506 .5516 Mtetra
.633 .54 .731 r
.45506 .5516 .4586 .55744 .46147 .55486 .45793 .54902 Mtetra
.665 .551 .716 r
.45793 .54902 .46147 .55486 .46434 .55088 .4608 .54504 Mtetra
.685 .558 .705 r
.4608 .54504 .46434 .55088 .46723 .54564 .46369 .5398 Mtetra
.698 .562 .698 r
.46369 .5398 .46723 .54564 .47012 .53937 .46658 .53353 Mtetra
.706 .565 .693 r
.46658 .53353 .47012 .53937 .47301 .53233 .46947 .5265 Mtetra
.709 .566 .691 r
.46947 .5265 .47301 .53233 .4759 .52489 .47236 .51906 Mtetra
.71 .566 .691 r
.47236 .51906 .4759 .52489 .47879 .51742 .47525 .51159 Mtetra
.707 .565 .693 r
.47525 .51159 .47879 .51742 .48168 .51029 .47814 .50446 Mtetra
.699 .563 .697 r
.47814 .50446 .48168 .51029 .48457 .50389 .48103 .49806 Mtetra
.687 .559 .704 r
.48103 .49806 .48457 .50389 .48745 .49851 .48391 .49269 Mtetra
.667 .552 .715 r
.48391 .49269 .48745 .49851 .49034 .49442 .48679 .48859 Mtetra
.635 .54 .73 r
.48679 .48859 .49034 .49442 .49322 .49174 .48968 .48591 Mtetra
.586 .521 .749 r
.48968 .48591 .49322 .49174 .49611 .49051 .49256 .48467 Mtetra
.511 .49 .77 r
.49256 .48467 .49611 .49051 .49901 .49058 .49545 .48474 Mtetra
.41 .444 .784 r
.49545 .48474 .49901 .49058 .50191 .49173 .49835 .48588 Mtetra
.312 .395 .787 r
.49835 .48588 .50191 .49173 .50482 .49356 .50125 .4877 Mtetra
.274 .375 .785 r
.50125 .4877 .50482 .49356 .50774 .49561 .50417 .48974 Mtetra
.329 .403 .787 r
.50417 .48974 .50774 .49561 .51066 .49735 .50709 .49148 Mtetra
.436 .456 .782 r
.50709 .49148 .51066 .49735 .51359 .49828 .51001 .4924 Mtetra
.536 .501 .764 r
.51001 .4924 .51359 .49828 .51653 .49799 .51294 .4921 Mtetra
.605 .529 .742 r
.51294 .4921 .51653 .49799 .51946 .49623 .51587 .49034 Mtetra
.647 .545 .725 r
.51587 .49034 .51946 .49623 .52239 .49301 .5188 .48712 Mtetra
.671 .553 .713 r
.5188 .48712 .52239 .49301 .52532 .48862 .52173 .48273 Mtetra
.68 .556 .708 r
.52173 .48273 .52532 .48862 .52824 .48363 .52465 .47773 Mtetra
.678 .556 .709 r
.52465 .47773 .52824 .48363 .53117 .4788 .52758 .47291 Mtetra
.661 .55 .718 r
.52758 .47291 .53117 .4788 .5341 .47493 .53051 .46903 Mtetra
.625 .537 .735 r
.53051 .46903 .5341 .47493 .53705 .47256 .53345 .46666 Mtetra
.57 .515 .754 r
.53345 .46666 .53705 .47256 .54001 .47164 .53641 .46573 Mtetra
.545 .505 .762 r
.53641 .46573 .54001 .47164 .54299 .47119 .53938 .46528 Mtetra
.602 .528 .743 r
.53938 .46528 .54299 .47119 .54595 .4695 .54234 .46359 Mtetra
.641 .542 .728 r
.54234 .46359 .54595 .4695 .54891 .46654 .5453 .46063 Mtetra
.602 .528 .743 r
.5453 .46063 .54891 .46654 .55189 .46485 .54827 .45893 Mtetra
.545 .505 .762 r
.54827 .45893 .55189 .46485 .55488 .46439 .55126 .45847 Mtetra
.57 .515 .754 r
.55126 .45847 .55488 .46439 .55787 .46346 .55425 .45753 Mtetra
.625 .537 .735 r
.55425 .45753 .55787 .46346 .56086 .46107 .55723 .45514 Mtetra
.661 .55 .718 r
.55723 .45514 .56086 .46107 .56382 .45716 .5602 .45123 Mtetra
.678 .555 .709 r
.5602 .45123 .56382 .45716 .56678 .45229 .56315 .44636 Mtetra
.68 .556 .708 r
.56315 .44636 .56678 .45229 .56974 .44725 .56611 .44132 Mtetra
.671 .553 .713 r
.56611 .44132 .56974 .44725 .5727 .44281 .56907 .43687 Mtetra
.647 .545 .725 r
.56907 .43687 .5727 .44281 .57569 .43953 .57205 .4336 Mtetra
.606 .529 .742 r
.57205 .4336 .57569 .43953 .5787 .43772 .57506 .43177 Mtetra
.539 .502 .763 r
.57506 .43177 .5787 .43772 .58173 .43736 .57809 .43141 Mtetra
.446 .461 .781 r
.57809 .43141 .58173 .43736 .58479 .43823 .58115 .43227 Mtetra
.349 .414 .788 r
.58115 .43227 .58479 .43823 .58787 .43992 .58422 .43396 Mtetra
.3 .39 .787 r
.58422 .43396 .58787 .43992 .59097 .44193 .58731 .43596 Mtetra
.334 .407 .788 r
.58731 .43596 .59097 .44193 .59407 .44374 .5904 .43776 Mtetra
.422 .45 .784 r
.5904 .43776 .59407 .44374 .59716 .44485 .59349 .43886 Mtetra
.514 .492 .769 r
.59349 .43886 .59716 .44485 .60025 .44489 .59657 .43889 Mtetra
.586 .521 .749 r
.59657 .43889 .60025 .44489 .60331 .44357 .59964 .43757 Mtetra
.634 .54 .73 r
.59964 .43757 .60331 .44357 .60635 .44078 .60267 .43478 Mtetra
.666 .551 .715 r
.60267 .43478 .60635 .44078 .60937 .43654 .60569 .43053 Mtetra
.686 .558 .704 r
.60569 .43053 .60937 .43654 .61236 .43098 .60868 .42498 Mtetra
.699 .562 .697 r
.60868 .42498 .61236 .43098 .61533 .42437 .61165 .41837 Mtetra
.707 .565 .692 r
.61165 .41837 .61533 .42437 .61828 .41704 .6146 .41104 Mtetra
.71 .566 .69 r
.6146 .41104 .61828 .41704 .62123 .40935 .61754 .40336 Mtetra
.61754 .40336 .62123 .40935 .62417 .40171 .62049 .39572 Mtetra
.706 .564 .693 r
.62049 .39572 .62417 .40171 .62712 .39449 .62344 .3885 Mtetra
.698 .562 .698 r
.62344 .3885 .62712 .39449 .63009 .38803 .62641 .38204 Mtetra
.684 .558 .705 r
.62641 .38204 .63009 .38803 .63308 .38262 .6294 .37663 Mtetra
.664 .551 .716 r
.6294 .37663 .63308 .38262 .63611 .37845 .63242 .37246 Mtetra
.633 .54 .731 r
.63242 .37246 .63611 .37845 .63917 .37569 .63548 .36969 Mtetra
.585 .521 .75 r
.63548 .36969 .63917 .37569 .64227 .37436 .63858 .36836 Mtetra
.51 .49 .77 r
.63858 .36836 .64227 .37436 .64542 .37446 .64173 .36845 Mtetra
.391 .436 .787 r
.64173 .36845 .64542 .37446 .64861 .37587 .64491 .36986 Mtetra
.214 .345 .781 r
.64491 .36986 .64861 .37587 .65184 .37844 .64813 .37242 Mtetra
0 .219 .732 r
.64813 .37242 .65184 .37844 .65511 .38194 .65139 .37591 Mtetra
0 .093 .651 r
.65139 .37591 .65511 .38194 .6584 .38611 .65468 .38006 Mtetra
0 .014 .585 r
.65468 .38006 .6584 .38611 .66172 .39065 .658 .38459 Mtetra
0 .003 .576 r
.658 .38459 .66172 .39065 .66506 .39525 .66132 .38918 Mtetra
0 .063 .627 r
.66132 .38918 .66506 .39525 .6684 .3996 .66465 .39352 Mtetra
0 .176 .708 r
.66465 .39352 .6684 .3996 .67173 .40341 .66798 .39731 Mtetra
.14 .304 .77 r
.66798 .39731 .67173 .40341 .67505 .40639 .67129 .40029 Mtetra
.331 .406 .788 r
.67129 .40029 .67505 .40639 .67834 .40833 .67458 .40221 Mtetra
.467 .471 .778 r
.67458 .40221 .67834 .40833 .68161 .40902 .67784 .40289 Mtetra
.555 .509 .759 r
.67784 .40289 .68161 .40902 .68483 .40832 .68106 .4022 Mtetra
.613 .532 .739 r
.68106 .4022 .68483 .40832 .68801 .40617 .68424 .40004 Mtetra
.651 .546 .722 r
.68424 .40004 .68801 .40617 .69115 .40253 .68737 .3964 Mtetra
.677 .555 .709 r
.68737 .3964 .69115 .40253 .69423 .39745 .69045 .39131 Mtetra
.695 .561 .699 r
.69045 .39131 .69423 .39745 .69727 .391 .69349 .38487 Mtetra
.708 .565 .691 r
.69349 .38487 .69727 .391 .70027 .38334 .69649 .37721 Mtetra
.717 .568 .685 r
.69649 .37721 .70027 .38334 .70322 .37464 .69945 .36852 Mtetra
.723 .569 .68 r
.69945 .36852 .70322 .37464 .70615 .36512 .70237 .359 Mtetra
.727 .571 .678 r
.70237 .359 .70615 .36512 .70904 .35502 .70527 .3489 Mtetra
.73 .571 .676 r
.70527 .3489 .70904 .35502 .71192 .34458 .70815 .33848 Mtetra
.70815 .33848 .71192 .34458 .71479 .33408 .71102 .32798 Mtetra
.729 .571 .676 r
.71102 .32798 .71479 .33408 .71766 .32377 .7139 .31767 Mtetra
.726 .57 .678 r
.7139 .31767 .71766 .32377 .72055 .31389 .71678 .3078 Mtetra
.722 .569 .682 r
.71678 .3078 .72055 .31389 .72346 .30469 .71969 .2986 Mtetra
.715 .567 .686 r
.71969 .2986 .72346 .30469 .7264 .29635 .72264 .29027 Mtetra
.705 .564 .693 r
.72264 .29027 .7264 .29635 .72938 .28907 .72562 .28299 Mtetra
.692 .56 .701 r
.72562 .28299 .72938 .28907 .73242 .28299 .72865 .27691 Mtetra
.673 .554 .712 r
.72865 .27691 .73242 .28299 .73551 .27822 .73174 .27214 Mtetra
.646 .544 .725 r
.73174 .27214 .73551 .27822 .73866 .27484 .7349 .26876 Mtetra
.606 .53 .742 r
.7349 .26876 .73866 .27484 .74188 .27289 .73811 .2668 Mtetra
.546 .506 .762 r
.73811 .2668 .74188 .27289 .74517 .27236 .7414 .26627 Mtetra
.453 .465 .781 r
.7414 .26627 .74517 .27236 .74854 .27323 .74475 .26713 Mtetra
.302 .392 .789 r
.74475 .26713 .74854 .27323 .75197 .27543 .74818 .26932 Mtetra
.071 .266 .756 r
.74818 .26932 .75197 .27543 .75547 .27886 .75167 .27274 Mtetra
0 .084 .644 r
.75167 .27274 .75547 .27886 .75903 .28338 .75522 .27725 Mtetra
0 0 .466 r
.75522 .27725 .75903 .28338 .76265 .28885 .75884 .2827 Mtetra
.673 .246 0 r
.75884 .2827 .76265 .28885 .76632 .29507 .7625 .28891 Mtetra
.763 .327 0 r
.7625 .28891 .76632 .29507 .77004 .30187 .76621 .29569 Mtetra
.803 .367 0 r
.76621 .29569 .77004 .30187 .77379 .30901 .76995 .30282 Mtetra
.814 .378 0 r
.76995 .30282 .77379 .30901 .77756 .3163 .77371 .31009 Mtetra
.801 .364 0 r
.77371 .31009 .77756 .3163 .78134 .32349 .77748 .31726 Mtetra
.92 .557 .323 r
.33076 .58675 .33416 .59208 .33659 .59915 .33319 .59381 Mtetra
.92 .56 .333 r
.33319 .59381 .33659 .59915 .33903 .60637 .33562 .60101 Mtetra
.92 .558 .325 r
.33562 .60101 .33903 .60637 .34149 .61352 .33807 .60816 Mtetra
.921 .55 .297 r
.33807 .60816 .34149 .61352 .34397 .6204 .34054 .61502 Mtetra
.919 .531 .238 r
.34054 .61502 .34397 .6204 .34646 .62679 .34303 .62139 Mtetra
.9 .485 .123 r
.34303 .62139 .34646 .62679 .34899 .63248 .34555 .62708 Mtetra
.807 .366 0 r
.34555 .62708 .34899 .63248 .35155 .63729 .3481 .63188 Mtetra
0 0 .488 r
.3481 .63188 .35155 .63729 .35414 .64105 .35069 .63563 Mtetra
.044 .258 .755 r
.35069 .63563 .35414 .64105 .35677 .64361 .35332 .63818 Mtetra
.371 .433 .795 r
.35332 .63818 .35677 .64361 .35944 .64487 .35598 .63943 Mtetra
.526 .503 .774 r
.35598 .63943 .35944 .64487 .36215 .64473 .35868 .63929 Mtetra
.605 .534 .749 r
.35868 .63929 .36215 .64473 .36489 .64317 .36142 .63773 Mtetra
.65 .55 .729 r
.36142 .63773 .36489 .64317 .36767 .64018 .3642 .63473 Mtetra
.678 .56 .714 r
.3642 .63473 .36767 .64018 .37048 .63579 .367 .63035 Mtetra
.696 .565 .703 r
.367 .63035 .37048 .63579 .37332 .6301 .36984 .62465 Mtetra
.709 .569 .695 r
.36984 .62465 .37332 .6301 .37618 .62321 .3727 .61777 Mtetra
.718 .572 .689 r
.3727 .61777 .37618 .62321 .37906 .61529 .37559 .60985 Mtetra
.724 .573 .685 r
.37559 .60985 .37906 .61529 .38196 .60652 .37848 .60108 Mtetra
.728 .574 .682 r
.37848 .60108 .38196 .60652 .38486 .59711 .38139 .59167 Mtetra
.73 .575 .68 r
.38139 .59167 .38486 .59711 .38777 .5873 .3843 .58187 Mtetra
.731 .575 .68 r
.3843 .58187 .38777 .5873 .39068 .57733 .38721 .57191 Mtetra
.38721 .57191 .39068 .57733 .39358 .56746 .39012 .56204 Mtetra
.729 .575 .681 r
.39012 .56204 .39358 .56746 .39647 .55793 .39301 .55252 Mtetra
.725 .574 .684 r
.39301 .55252 .39647 .55793 .39935 .54899 .39589 .54358 Mtetra
.72 .572 .688 r
.39589 .54358 .39935 .54899 .40222 .54085 .39876 .53545 Mtetra
.712 .57 .693 r
.39876 .53545 .40222 .54085 .40506 .53372 .40161 .52831 Mtetra
.7 .567 .701 r
.40161 .52831 .40506 .53372 .40789 .52774 .40443 .52233 Mtetra
.683 .561 .711 r
.40443 .52233 .40789 .52774 .4107 .52305 .40724 .51764 Mtetra
.657 .553 .725 r
.40724 .51764 .4107 .52305 .41349 .51972 .41003 .51432 Mtetra
.618 .539 .744 r
.41003 .51432 .41349 .51972 .41626 .5178 .4128 .51239 Mtetra
.553 .515 .766 r
.4128 .51239 .41626 .5178 .41902 .51725 .41556 .51184 Mtetra
.441 .467 .79 r
.41556 .51184 .41902 .51725 .42177 .51802 .4183 .5126 Mtetra
.242 .369 .793 r
.4183 .5126 .42177 .51802 .42451 .51997 .42103 .51455 Mtetra
0 .19 .718 r
.42103 .51455 .42451 .51997 .42724 .52295 .42376 .51751 Mtetra
0 0 .538 r
.42376 .51751 .42724 .52295 .42998 .52674 .42649 .52129 Mtetra
.617 .192 0 r
.42649 .52129 .42998 .52674 .43271 .53107 .42922 .52562 Mtetra
.695 .259 0 r
.42922 .52562 .43271 .53107 .43546 .53569 .43196 .53022 Mtetra
.683 .248 0 r
.43196 .53022 .43546 .53569 .43821 .54027 .4347 .53479 Mtetra
0 0 .405 r
.4347 .53479 .43821 .54027 .44098 .54452 .43747 .53903 Mtetra
0 .034 .601 r
.43747 .53903 .44098 .54452 .44376 .54814 .44024 .54265 Mtetra
.043 .259 .756 r
.44024 .54265 .44376 .54814 .44656 .55087 .44304 .54536 Mtetra
.327 .412 .797 r
.44304 .54536 .44656 .55087 .44938 .55246 .44585 .54694 Mtetra
.492 .489 .781 r
.44585 .54694 .44938 .55246 .45221 .55274 .44868 .54722 Mtetra
.584 .526 .757 r
.44868 .54722 .45221 .55274 .45506 .5516 .45152 .54608 Mtetra
.637 .546 .735 r
.45152 .54608 .45506 .5516 .45793 .54902 .45439 .54349 Mtetra
.669 .557 .719 r
.45439 .54349 .45793 .54902 .4608 .54504 .45726 .53951 Mtetra
.689 .563 .708 r
.45726 .53951 .4608 .54504 .46369 .5398 .46014 .53428 Mtetra
.702 .567 .7 r
.46014 .53428 .46369 .5398 .46658 .53353 .46303 .528 Mtetra
.709 .569 .695 r
.46303 .528 .46658 .53353 .46947 .5265 .46592 .52097 Mtetra
.713 .57 .692 r
.46592 .52097 .46947 .5265 .47236 .51906 .46882 .51354 Mtetra
.46882 .51354 .47236 .51906 .47525 .51159 .47171 .50607 Mtetra
.71 .569 .694 r
.47171 .50607 .47525 .51159 .47814 .50446 .4746 .49895 Mtetra
.703 .567 .699 r
.4746 .49895 .47814 .50446 .48103 .49806 .47749 .49254 Mtetra
.691 .564 .707 r
.47749 .49254 .48103 .49806 .48391 .49269 .48037 .48717 Mtetra
.671 .557 .718 r
.48037 .48717 .48391 .49269 .48679 .48859 .48325 .48308 Mtetra
.639 .547 .734 r
.48325 .48308 .48679 .48859 .48968 .48591 .48613 .48039 Mtetra
.588 .528 .755 r
.48613 .48039 .48968 .48591 .49256 .48467 .48901 .47915 Mtetra
.51 .497 .778 r
.48901 .47915 .49256 .48467 .49545 .48474 .4919 .47921 Mtetra
.401 .448 .794 r
.4919 .47921 .49545 .48474 .49835 .48588 .49479 .48034 Mtetra
.293 .395 .796 r
.49479 .48034 .49835 .48588 .50125 .4877 .49769 .48216 Mtetra
.25 .373 .794 r
.49769 .48216 .50125 .4877 .50417 .48974 .5006 .48419 Mtetra
.311 .404 .797 r
.5006 .48419 .50417 .48974 .50709 .49148 .50351 .48591 Mtetra
.429 .461 .792 r
.50351 .48591 .50709 .49148 .51001 .4924 .50643 .48683 Mtetra
.536 .508 .771 r
.50643 .48683 .51001 .4924 .51294 .4921 .50936 .48653 Mtetra
.608 .536 .747 r
.50936 .48653 .51294 .4921 .51587 .49034 .51229 .48476 Mtetra
.651 .551 .728 r
.51229 .48476 .51587 .49034 .5188 .48712 .51521 .48154 Mtetra
.675 .559 .716 r
.51521 .48154 .5188 .48712 .52173 .48273 .51814 .47715 Mtetra
.684 .562 .71 r
.51814 .47715 .52173 .48273 .52465 .47773 .52106 .47215 Mtetra
.682 .561 .712 r
.52106 .47215 .52465 .47773 .52758 .47291 .52398 .46732 Mtetra
.665 .555 .721 r
.52398 .46732 .52758 .47291 .53051 .46903 .52692 .46345 Mtetra
.628 .543 .739 r
.52692 .46345 .53051 .46903 .53345 .46666 .52986 .46108 Mtetra
.572 .522 .761 r
.52986 .46108 .53345 .46666 .53641 .46573 .53281 .46014 Mtetra
.545 .511 .769 r
.53281 .46014 .53641 .46573 .53938 .46528 .53578 .45969 Mtetra
.605 .535 .749 r
.53578 .45969 .53938 .46528 .54234 .46359 .53874 .45799 Mtetra
.644 .549 .732 r
.53874 .45799 .54234 .46359 .5453 .46063 .54169 .45502 Mtetra
.605 .535 .749 r
.54169 .45502 .5453 .46063 .54827 .45893 .54466 .45332 Mtetra
.546 .512 .769 r
.54466 .45332 .54827 .45893 .55126 .45847 .54765 .45286 Mtetra
.572 .522 .761 r
.54765 .45286 .55126 .45847 .55425 .45753 .55063 .45191 Mtetra
.628 .543 .739 r
.55063 .45191 .55425 .45753 .55723 .45514 .55361 .44952 Mtetra
.665 .555 .721 r
.55361 .44952 .55723 .45514 .5602 .45123 .55657 .44561 Mtetra
.682 .561 .712 r
.55657 .44561 .5602 .45123 .56315 .44636 .55953 .44073 Mtetra
.684 .562 .71 r
.55953 .44073 .56315 .44636 .56611 .44132 .56248 .43569 Mtetra
.675 .559 .716 r
.56248 .43569 .56611 .44132 .56907 .43687 .56545 .43125 Mtetra
.651 .551 .728 r
.56545 .43125 .56907 .43687 .57205 .4336 .56843 .42797 Mtetra
.609 .536 .747 r
.56843 .42797 .57205 .4336 .57506 .43177 .57143 .42614 Mtetra
.54 .509 .771 r
.57143 .42614 .57506 .43177 .57809 .43141 .57445 .42577 Mtetra
.44 .466 .791 r
.57445 .42577 .57809 .43141 .58115 .43227 .57751 .42663 Mtetra
.333 .416 .797 r
.57751 .42663 .58115 .43227 .58422 .43396 .58058 .42831 Mtetra
.28 .389 .796 r
.58058 .42831 .58422 .43396 .58731 .43596 .58366 .4303 Mtetra
.317 .408 .797 r
.58366 .4303 .58731 .43596 .5904 .43776 .58675 .43209 Mtetra
.414 .454 .793 r
.58675 .43209 .5904 .43776 .59349 .43886 .58983 .43319 Mtetra
.513 .498 .777 r
.58983 .43319 .59349 .43886 .59657 .43889 .59291 .43321 Mtetra
.588 .528 .755 r
.59291 .43321 .59657 .43889 .59964 .43757 .59597 .43189 Mtetra
.638 .546 .735 r
.59597 .43189 .59964 .43757 .60267 .43478 .599 .42909 Mtetra
.67 .557 .718 r
.599 .42909 .60267 .43478 .60569 .43053 .60201 .42484 Mtetra
.69 .563 .706 r
.60201 .42484 .60569 .43053 .60868 .42498 .605 .41929 Mtetra
.703 .567 .698 r
.605 .41929 .60868 .42498 .61165 .41837 .60797 .41268 Mtetra
.71 .569 .694 r
.60797 .41268 .61165 .41837 .6146 .41104 .61093 .40535 Mtetra
.714 .57 .691 r
.61093 .40535 .6146 .41104 .61754 .40336 .61387 .39768 Mtetra
.713 .57 .692 r
.61387 .39768 .61754 .40336 .62049 .39572 .61682 .39004 Mtetra
.709 .569 .694 r
.61682 .39004 .62049 .39572 .62344 .3885 .61977 .38282 Mtetra
.702 .567 .699 r
.61977 .38282 .62344 .3885 .62641 .38204 .62273 .37637 Mtetra
.688 .563 .708 r
.62273 .37637 .62641 .38204 .6294 .37663 .62573 .37095 Mtetra
.668 .556 .719 r
.62573 .37095 .6294 .37663 .63242 .37246 .62875 .36679 Mtetra
.637 .546 .735 r
.62875 .36679 .63242 .37246 .63548 .36969 .63181 .36401 Mtetra
.588 .528 .755 r
.63181 .36401 .63548 .36969 .63858 .36836 .6349 .36268 Mtetra
.509 .497 .779 r
.6349 .36268 .63858 .36836 .64173 .36845 .63804 .36276 Mtetra
.381 .439 .796 r
.63804 .36276 .64173 .36845 .64491 .36986 .64122 .36416 Mtetra
.184 .34 .787 r
.64122 .36416 .64491 .36986 .64813 .37242 .64444 .36671 Mtetra
0 .198 .724 r
.64444 .36671 .64813 .37242 .65139 .37591 .64769 .37019 Mtetra
0 .058 .621 r
.64769 .37019 .65139 .37591 .65468 .38006 .65097 .37433 Mtetra
0 0 .544 r
.65097 .37433 .65468 .38006 .658 .38459 .65428 .37885 Mtetra
0 0 .533 r
.65428 .37885 .658 .38459 .66132 .38918 .6576 .38342 Mtetra
0 .025 .593 r
.6576 .38342 .66132 .38918 .66465 .39352 .66092 .38775 Mtetra
0 .15 .693 r
.66092 .38775 .66465 .39352 .66798 .39731 .66424 .39154 Mtetra
.101 .294 .772 r
.66424 .39154 .66798 .39731 .67129 .40029 .66754 .3945 Mtetra
.314 .407 .798 r
.66754 .3945 .67129 .40029 .67458 .40221 .67083 .39642 Mtetra
.462 .477 .787 r
.67083 .39642 .67458 .40221 .67784 .40289 .67408 .39709 Mtetra
.557 .516 .766 r
.67408 .39709 .67784 .40289 .68106 .4022 .6773 .39639 Mtetra
.616 .539 .744 r
.6773 .39639 .68106 .4022 .68424 .40004 .68047 .39423 Mtetra
.655 .552 .726 r
.68047 .39423 .68424 .40004 .68737 .3964 .6836 .39059 Mtetra
.681 .56 .712 r
.6836 .39059 .68737 .3964 .69045 .39131 .68669 .3855 Mtetra
.699 .566 .701 r
.68669 .3855 .69045 .39131 .69349 .38487 .68973 .37906 Mtetra
.712 .569 .692 r
.68973 .37906 .69349 .38487 .69649 .37721 .69272 .3714 Mtetra
.721 .572 .686 r
.69272 .3714 .69649 .37721 .69945 .36852 .69568 .36271 Mtetra
.727 .573 .682 r
.69568 .36271 .69945 .36852 .70237 .359 .6986 .3532 Mtetra
.731 .574 .679 r
.6986 .3532 .70237 .359 .70527 .3489 .7015 .34311 Mtetra
.733 .575 .677 r
.7015 .34311 .70527 .3489 .70815 .33848 .70439 .33269 Mtetra
.734 .575 .677 r
.70439 .33269 .70815 .33848 .71102 .32798 .70726 .3222 Mtetra
.733 .575 .677 r
.70726 .3222 .71102 .32798 .7139 .31767 .71014 .3119 Mtetra
.73 .574 .679 r
.71014 .3119 .7139 .31767 .71678 .3078 .71303 .30203 Mtetra
.725 .573 .683 r
.71303 .30203 .71678 .3078 .71969 .2986 .71594 .29283 Mtetra
.719 .571 .688 r
.71594 .29283 .71969 .2986 .72264 .29027 .71889 .28451 Mtetra
.709 .569 .694 r
.71889 .28451 .72264 .29027 .72562 .28299 .72187 .27723 Mtetra
.696 .565 .703 r
.72187 .27723 .72562 .28299 .72865 .27691 .7249 .27115 Mtetra
.677 .559 .714 r
.7249 .27115 .72865 .27691 .73174 .27214 .72799 .26638 Mtetra
.649 .55 .729 r
.72799 .26638 .73174 .27214 .7349 .26876 .73114 .26299 Mtetra
.609 .536 .747 r
.73114 .26299 .7349 .26876 .73811 .2668 .73436 .26103 Mtetra
.547 .513 .769 r
.73436 .26103 .73811 .2668 .7414 .26627 .73764 .2605 Mtetra
.447 .47 .79 r
.73764 .2605 .7414 .26627 .74475 .26713 .74099 .26135 Mtetra
.283 .392 .797 r
.74099 .26135 .74475 .26713 .74818 .26932 .74441 .26353 Mtetra
.025 .251 .753 r
.74441 .26353 .74818 .26932 .75167 .27274 .74789 .26694 Mtetra
0 .049 .614 r
.74789 .26694 .75167 .27274 .75522 .27725 .75144 .27143 Mtetra
0 0 .411 r
.75144 .27143 .75522 .27725 .75884 .2827 .75504 .27687 Mtetra
.724 .281 0 r
.75504 .27687 .75884 .2827 .7625 .28891 .7587 .28307 Mtetra
.8 .355 0 r
.7587 .28307 .7625 .28891 .76621 .29569 .76239 .28983 Mtetra
.832 .39 0 r
.76239 .28983 .76621 .29569 .76995 .30282 .76612 .29695 Mtetra
.84 .4 0 r
.76612 .29695 .76995 .30282 .77371 .31009 .76987 .3042 Mtetra
.83 .388 0 r
.76987 .3042 .77371 .31009 .77748 .31726 .77364 .31136 Mtetra
.9 .551 .374 r
.32734 .58221 .33076 .58675 .33319 .59381 .32976 .58926 Mtetra
.899 .553 .382 r
.32976 .58926 .33319 .59381 .33562 .60101 .33219 .59646 Mtetra
.9 .551 .376 r
.33219 .59646 .33562 .60101 .33807 .60816 .33463 .60359 Mtetra
.902 .545 .355 r
.33463 .60359 .33807 .60816 .34054 .61502 .33709 .61044 Mtetra
.905 .532 .313 r
.33709 .61044 .34054 .61502 .34303 .62139 .33957 .61681 Mtetra
.903 .502 .231 r
.33957 .61681 .34303 .62139 .34555 .62708 .34209 .62248 Mtetra
.87 .427 .061 r
.34209 .62248 .34555 .62708 .3481 .63188 .34463 .62727 Mtetra
.678 .212 0 r
.34463 .62727 .3481 .63188 .35069 .63563 .34722 .63102 Mtetra
0 .195 .726 r
.34722 .63102 .35069 .63563 .35332 .63818 .34984 .63356 Mtetra
.327 .443 .826 r
.34984 .63356 .35332 .63818 .35598 .63943 .3525 .63481 Mtetra
.524 .525 .798 r
.3525 .63481 .35598 .63943 .35868 .63929 .3552 .63467 Mtetra
.614 .555 .765 r
.3552 .63467 .35868 .63929 .36142 .63773 .35793 .6331 Mtetra
.661 .568 .74 r
.35793 .6331 .36142 .63773 .3642 .63473 .36071 .6301 Mtetra
.689 .575 .722 r
.36071 .6301 .3642 .63473 .367 .63035 .36351 .62571 Mtetra
.707 .579 .709 r
.36351 .62571 .367 .63035 .36984 .62465 .36635 .62002 Mtetra
.719 .581 .699 r
.36635 .62002 .36984 .62465 .3727 .61777 .36921 .61313 Mtetra
.727 .583 .693 r
.36921 .61313 .3727 .61777 .37559 .60985 .3721 .60521 Mtetra
.733 .583 .688 r
.3721 .60521 .37559 .60985 .37848 .60108 .375 .59645 Mtetra
.737 .584 .685 r
.375 .59645 .37848 .60108 .38139 .59167 .37791 .58705 Mtetra
.739 .584 .683 r
.37791 .58705 .38139 .59167 .3843 .58187 .38082 .57724 Mtetra
.74 .585 .682 r
.38082 .57724 .3843 .58187 .38721 .57191 .38373 .56728 Mtetra
.739 .584 .682 r
.38373 .56728 .38721 .57191 .39012 .56204 .38664 .55742 Mtetra
.738 .584 .684 r
.38664 .55742 .39012 .56204 .39301 .55252 .38954 .5479 Mtetra
.734 .584 .687 r
.38954 .5479 .39301 .55252 .39589 .54358 .39242 .53897 Mtetra
.729 .583 .691 r
.39242 .53897 .39589 .54358 .39876 .53545 .39529 .53084 Mtetra
.722 .582 .697 r
.39529 .53084 .39876 .53545 .40161 .52831 .39814 .5237 Mtetra
.711 .579 .706 r
.39814 .5237 .40161 .52831 .40443 .52233 .40096 .51772 Mtetra
.694 .576 .718 r
.40096 .51772 .40443 .52233 .40724 .51764 .40377 .51303 Mtetra
.669 .57 .735 r
.40377 .51303 .40724 .51764 .41003 .51432 .40656 .5097 Mtetra
.628 .559 .758 r
.40656 .5097 .41003 .51432 .4128 .51239 .40933 .50777 Mtetra
.556 .536 .788 r
.40933 .50777 .4128 .51239 .41556 .51184 .41208 .50722 Mtetra
.421 .484 .819 r
.41208 .50722 .41556 .51184 .4183 .5126 .41482 .50797 Mtetra
.152 .356 .811 r
.41482 .50797 .4183 .5126 .42103 .51455 .41755 .50991 Mtetra
0 .101 .651 r
.41755 .50991 .42103 .51455 .42376 .51751 .42027 .51288 Mtetra
.62 .16 0 r
.42027 .51288 .42376 .51751 .42649 .52129 .42299 .51664 Mtetra
.769 .301 0 r
.42299 .51664 .42649 .52129 .42922 .52562 .42572 .52096 Mtetra
.814 .351 0 r
.42572 .52096 .42922 .52562 .43196 .53022 .42845 .52556 Mtetra
.807 .343 0 r
.42845 .52556 .43196 .53022 .4347 .53479 .43119 .53012 Mtetra
.74 .271 0 r
.43119 .53012 .4347 .53479 .43747 .53903 .43394 .53435 Mtetra
0 0 .454 r
.43394 .53435 .43747 .53903 .44024 .54265 .43671 .53796 Mtetra
0 .197 .727 r
.43671 .53796 .44024 .54265 .44304 .54536 .4395 .54067 Mtetra
.268 .415 .825 r
.4395 .54067 .44304 .54536 .44585 .54694 .44231 .54224 Mtetra
.484 .51 .808 r
.44231 .54224 .44585 .54694 .44868 .54722 .44514 .54251 Mtetra
.591 .548 .775 r
.44514 .54251 .44868 .54722 .45152 .54608 .44798 .54137 Mtetra
.648 .564 .747 r
.44798 .54137 .45152 .54608 .45439 .54349 .45084 .53878 Mtetra
.68 .573 .728 r
.45084 .53878 .45439 .54349 .45726 .53951 .45371 .5348 Mtetra
.7 .577 .714 r
.45371 .5348 .45726 .53951 .46014 .53428 .45659 .52956 Mtetra
.712 .58 .705 r
.45659 .52956 .46014 .53428 .46303 .528 .45948 .52329 Mtetra
.72 .581 .699 r
.45948 .52329 .46303 .528 .46592 .52097 .46238 .51626 Mtetra
.723 .582 .696 r
.46238 .51626 .46592 .52097 .46882 .51354 .46527 .50883 Mtetra
.724 .582 .696 r
.46527 .50883 .46882 .51354 .47171 .50607 .46817 .50136 Mtetra
.721 .581 .698 r
.46817 .50136 .47171 .50607 .4746 .49895 .47106 .49424 Mtetra
.714 .58 .704 r
.47106 .49424 .4746 .49895 .47749 .49254 .47394 .48783 Mtetra
.702 .578 .713 r
.47394 .48783 .47749 .49254 .48037 .48717 .47683 .48246 Mtetra
.682 .573 .726 r
.47683 .48246 .48037 .48717 .48325 .48308 .47971 .47836 Mtetra
.65 .565 .746 r
.47971 .47836 .48325 .48308 .48613 .48039 .48258 .47568 Mtetra
.596 .549 .773 r
.48258 .47568 .48613 .48039 .48901 .47915 .48546 .47443 Mtetra
.505 .518 .803 r
.48546 .47443 .48901 .47915 .4919 .47921 .48835 .47449 Mtetra
.369 .462 .824 r
.48835 .47449 .4919 .47921 .49479 .48034 .49123 .47562 Mtetra
.223 .392 .821 r
.49123 .47562 .49479 .48034 .49769 .48216 .49413 .47742 Mtetra
.165 .362 .814 r
.49413 .47742 .49769 .48216 .5006 .48419 .49703 .47945 Mtetra
.248 .405 .823 r
.49703 .47945 .5006 .48419 .50351 .48591 .49994 .48117 Mtetra
.405 .477 .821 r
.49994 .48117 .50351 .48591 .50643 .48683 .50286 .48208 Mtetra
.537 .529 .794 r
.50286 .48208 .50643 .48683 .50936 .48653 .50578 .48177 Mtetra
.618 .556 .763 r
.50578 .48177 .50936 .48653 .51229 .48476 .5087 .48 Mtetra
.663 .568 .739 r
.5087 .48 .51229 .48476 .51521 .48154 .51163 .47677 Mtetra
.686 .574 .724 r
.51163 .47677 .51521 .48154 .51814 .47715 .51455 .47238 Mtetra
.696 .576 .717 r
.51455 .47238 .51814 .47715 .52106 .47215 .51747 .46739 Mtetra
.693 .576 .719 r
.51747 .46739 .52106 .47215 .52398 .46732 .5204 .46256 Mtetra
.677 .572 .73 r
.5204 .46256 .52398 .46732 .52692 .46345 .52333 .45868 Mtetra
.639 .562 .752 r
.52333 .45868 .52692 .46345 .52986 .46108 .52627 .45631 Mtetra
.577 .543 .78 r
.52627 .45631 .52986 .46108 .53281 .46014 .52922 .45537 Mtetra
.547 .533 .791 r
.52922 .45537 .53281 .46014 .53578 .45969 .53218 .45491 Mtetra
.614 .555 .765 r
.53218 .45491 .53578 .45969 .53874 .45799 .53514 .45321 Mtetra
.656 .567 .743 r
.53514 .45321 .53874 .45799 .54169 .45502 .53809 .45024 Mtetra
.614 .555 .764 r
.53809 .45024 .54169 .45502 .54466 .45332 .54106 .44853 Mtetra
.548 .533 .791 r
.54106 .44853 .54466 .45332 .54765 .45286 .54404 .44806 Mtetra
.577 .543 .78 r
.54404 .44806 .54765 .45286 .55063 .45191 .54702 .44711 Mtetra
.639 .562 .752 r
.54702 .44711 .55063 .45191 .55361 .44952 .55 .44471 Mtetra
.677 .572 .73 r
.55 .44471 .55361 .44952 .55657 .44561 .55296 .4408 Mtetra
.693 .576 .719 r
.55296 .4408 .55657 .44561 .55953 .44073 .55592 .43593 Mtetra
.696 .576 .717 r
.55592 .43593 .55953 .44073 .56248 .43569 .55887 .43089 Mtetra
.686 .574 .724 r
.55887 .43089 .56248 .43569 .56545 .43125 .56183 .42644 Mtetra
.663 .568 .739 r
.56183 .42644 .56545 .43125 .56843 .42797 .56481 .42316 Mtetra
.618 .556 .762 r
.56481 .42316 .56843 .42797 .57143 .42614 .56781 .42133 Mtetra
.54 .531 .793 r
.56781 .42133 .57143 .42614 .57445 .42577 .57083 .42096 Mtetra
.419 .483 .82 r
.57083 .42096 .57445 .42577 .57751 .42663 .57388 .42181 Mtetra
.28 .42 .825 r
.57388 .42181 .57751 .42663 .58058 .42831 .57694 .42348 Mtetra
.207 .384 .819 r
.57694 .42348 .58058 .42831 .58366 .4303 .58002 .42547 Mtetra
.258 .409 .824 r
.58002 .42547 .58366 .4303 .58675 .43209 .58311 .42725 Mtetra
.386 .469 .823 r
.58311 .42725 .58675 .43209 .58983 .43319 .58619 .42834 Mtetra
.51 .519 .802 r
.58619 .42834 .58983 .43319 .59291 .43321 .58926 .42836 Mtetra
.596 .549 .773 r
.58926 .42836 .59291 .43321 .59597 .43189 .59231 .42703 Mtetra
.649 .565 .747 r
.59231 .42703 .59597 .43189 .599 .42909 .59535 .42423 Mtetra
.682 .573 .727 r
.59535 .42423 .599 .42909 .60201 .42484 .59836 .41998 Mtetra
.702 .578 .713 r
.59836 .41998 .60201 .42484 .605 .41929 .60135 .41443 Mtetra
.714 .58 .703 r
.60135 .41443 .605 .41929 .60797 .41268 .60432 .40782 Mtetra
.721 .582 .698 r
.60432 .40782 .60797 .41268 .61093 .40535 .60727 .40049 Mtetra
.724 .582 .695 r
.60727 .40049 .61093 .40535 .61387 .39768 .61022 .39281 Mtetra
.724 .582 .696 r
.61022 .39281 .61387 .39768 .61682 .39004 .61316 .38518 Mtetra
.72 .581 .699 r
.61316 .38518 .61682 .39004 .61977 .38282 .61611 .37796 Mtetra
.713 .58 .705 r
.61611 .37796 .61977 .38282 .62273 .37637 .61908 .37151 Mtetra
.7 .577 .714 r
.61908 .37151 .62273 .37637 .62573 .37095 .62207 .36609 Mtetra
.68 .573 .728 r
.62207 .36609 .62573 .37095 .62875 .36679 .62509 .36192 Mtetra
.648 .565 .747 r
.62509 .36192 .62875 .36679 .63181 .36401 .62815 .35915 Mtetra
.595 .549 .773 r
.62815 .35915 .63181 .36401 .6349 .36268 .63124 .35781 Mtetra
.504 .517 .803 r
.63124 .35781 .6349 .36268 .63804 .36276 .63438 .35789 Mtetra
.344 .45 .825 r
.63438 .35789 .63804 .36276 .64122 .36416 .63755 .35928 Mtetra
.078 .316 .796 r
.63755 .35928 .64122 .36416 .64444 .36671 .64076 .36182 Mtetra
0 .118 .666 r
.64076 .36182 .64444 .36671 .64769 .37019 .64401 .36529 Mtetra
0 0 .495 r
.64401 .36529 .64769 .37019 .65097 .37433 .64729 .36943 Mtetra
.602 .145 0 r
.64729 .36943 .65097 .37433 .65428 .37885 .65058 .37393 Mtetra
.614 .155 0 r
.65058 .37393 .65428 .37885 .6576 .38342 .6539 .3785 Mtetra
0 0 .454 r
.6539 .3785 .6576 .38342 .66092 .38775 .65721 .38282 Mtetra
0 .056 .61 r
.65721 .38282 .66092 .38775 .66424 .39154 .66052 .3866 Mtetra
0 .251 .762 r
.66052 .3866 .66424 .39154 .66754 .3945 .66382 .38955 Mtetra
.255 .408 .824 r
.66382 .38955 .66754 .3945 .67083 .39642 .6671 .39146 Mtetra
.448 .495 .815 r
.6671 .39146 .67083 .39642 .67408 .39709 .67035 .39213 Mtetra
.56 .537 .787 r
.67035 .39213 .67408 .39709 .6773 .39639 .67356 .39142 Mtetra
.626 .559 .759 r
.67356 .39142 .6773 .39639 .68047 .39423 .67674 .38926 Mtetra
.667 .57 .736 r
.67674 .38926 .68047 .39423 .6836 .39059 .67986 .38561 Mtetra
.693 .576 .719 r
.67986 .38561 .6836 .39059 .68669 .3855 .68295 .38053 Mtetra
.711 .58 .706 r
.68295 .38053 .68669 .3855 .68973 .37906 .68599 .37409 Mtetra
.723 .582 .696 r
.68599 .37409 .68973 .37906 .69272 .3714 .68898 .36643 Mtetra
.731 .583 .689 r
.68898 .36643 .69272 .3714 .69568 .36271 .69194 .35774 Mtetra
.737 .584 .684 r
.69194 .35774 .69568 .36271 .6986 .3532 .69487 .34823 Mtetra
.741 .585 .681 r
.69487 .34823 .6986 .3532 .7015 .34311 .69777 .33814 Mtetra
.743 .585 .679 r
.69777 .33814 .7015 .34311 .70439 .33269 .70066 .32773 Mtetra
.70066 .32773 .70439 .33269 .70726 .3222 .70354 .31724 Mtetra
.742 .585 .68 r
.70354 .31724 .70726 .3222 .71014 .3119 .70642 .30694 Mtetra
.74 .585 .682 r
.70642 .30694 .71014 .3119 .71303 .30203 .70931 .29708 Mtetra
.736 .584 .686 r
.70931 .29708 .71303 .30203 .71594 .29283 .71223 .28788 Mtetra
.729 .583 .691 r
.71223 .28788 .71594 .29283 .71889 .28451 .71517 .27956 Mtetra
.72 .581 .699 r
.71517 .27956 .71889 .28451 .72187 .27723 .71816 .27228 Mtetra
.707 .579 .709 r
.71816 .27228 .72187 .27723 .7249 .27115 .72119 .2662 Mtetra
.688 .575 .722 r
.72119 .2662 .7249 .27115 .72799 .26638 .72428 .26143 Mtetra
.661 .568 .74 r
.72428 .26143 .72799 .26638 .73114 .26299 .72742 .25804 Mtetra
.618 .556 .762 r
.72742 .25804 .73114 .26299 .73436 .26103 .73063 .25608 Mtetra
.549 .534 .79 r
.73063 .25608 .73436 .26103 .73764 .2605 .73391 .25554 Mtetra
.429 .487 .818 r
.73391 .25554 .73764 .2605 .74099 .26135 .73726 .25639 Mtetra
.215 .388 .82 r
.73726 .25639 .74099 .26135 .74441 .26353 .74067 .25856 Mtetra
0 .194 .725 r
.74067 .25856 .74441 .26353 .74789 .26694 .74415 .26195 Mtetra
0 0 .49 r
.74415 .26195 .74789 .26694 .75144 .27143 .74769 .26644 Mtetra
.72 .252 0 r
.74769 .26644 .75144 .27143 .75504 .27687 .75128 .27187 Mtetra
.818 .357 0 r
.75128 .27187 .75504 .27687 .7587 .28307 .75493 .27806 Mtetra
.858 .41 .025 r
.75493 .27806 .7587 .28307 .76239 .28983 .75862 .28481 Mtetra
.874 .434 .074 r
.75862 .28481 .76239 .28983 .76612 .29695 .76234 .29191 Mtetra
.878 .44 .088 r
.76234 .29191 .76612 .29695 .76987 .3042 .76608 .29915 Mtetra
.873 .432 .07 r
.76608 .29915 .76987 .3042 .77364 .31136 .76984 .3063 Mtetra
.864 .536 .429 r
.32389 .57886 .32734 .58221 .32976 .58926 .3263 .5859 Mtetra
.864 .538 .433 r
.3263 .5859 .32976 .58926 .33219 .59646 .32872 .59309 Mtetra
.864 .537 .43 r
.32872 .59309 .33219 .59646 .33463 .60359 .33116 .60022 Mtetra
.866 .532 .416 r
.33116 .60022 .33463 .60359 .33709 .61044 .33361 .60707 Mtetra
.87 .522 .39 r
.33361 .60707 .33709 .61044 .33957 .61681 .33609 .61343 Mtetra
.873 .502 .34 r
.33609 .61343 .33957 .61681 .34209 .62248 .33859 .61909 Mtetra
.871 .46 .242 r
.33859 .61909 .34209 .62248 .34463 .62727 .34113 .62388 Mtetra
.824 .346 .018 r
.34113 .62388 .34463 .62727 .34722 .63102 .34371 .62762 Mtetra
.497 0 0 r
.34371 .62762 .34722 .63102 .34984 .63356 .34633 .63016 Mtetra
.198 .452 .875 r
.34633 .63016 .34984 .63356 .3525 .63481 .34898 .6314 Mtetra
.518 .572 .849 r
.34898 .6314 .3525 .63481 .3552 .63467 .35168 .63126 Mtetra
.631 .596 .796 r
.35168 .63126 .3552 .63467 .35793 .6331 .35442 .62969 Mtetra
.682 .601 .759 r
.35442 .62969 .35793 .6331 .36071 .6301 .35719 .62669 Mtetra
.71 .602 .735 r
.35719 .62669 .36071 .6301 .36351 .62571 .36 .6223 Mtetra
.726 .602 .718 r
.36 .6223 .36351 .62571 .36635 .62002 .36283 .6166 Mtetra
.737 .601 .706 r
.36283 .6166 .36635 .62002 .36921 .61313 .3657 .60972 Mtetra
.744 .601 .698 r
.3657 .60972 .36921 .61313 .3721 .60521 .36858 .6018 Mtetra
.748 .6 .693 r
.36858 .6018 .3721 .60521 .375 .59645 .37148 .59303 Mtetra
.752 .6 .689 r
.37148 .59303 .375 .59645 .37791 .58705 .3744 .58363 Mtetra
.753 .6 .687 r
.3744 .58363 .37791 .58705 .38082 .57724 .37731 .57383 Mtetra
.754 .6 .686 r
.37731 .57383 .38082 .57724 .38373 .56728 .38023 .56387 Mtetra
.38023 .56387 .38373 .56728 .38664 .55742 .38314 .554 Mtetra
.752 .6 .688 r
.38314 .554 .38664 .55742 .38954 .5479 .38604 .54449 Mtetra
.75 .6 .691 r
.38604 .54449 .38954 .5479 .39242 .53897 .38893 .53555 Mtetra
.745 .601 .696 r
.38893 .53555 .39242 .53897 .39529 .53084 .39179 .52742 Mtetra
.739 .601 .704 r
.39179 .52742 .39529 .53084 .39814 .5237 .39464 .52028 Mtetra
.729 .602 .715 r
.39464 .52028 .39814 .5237 .40096 .51772 .39747 .51431 Mtetra
.714 .602 .73 r
.39747 .51431 .40096 .51772 .40377 .51303 .40028 .50961 Mtetra
.69 .601 .752 r
.40028 .50961 .40377 .51303 .40656 .5097 .40306 .50628 Mtetra
.647 .597 .785 r
.40306 .50628 .40656 .5097 .40933 .50777 .40583 .50435 Mtetra
.561 .582 .832 r
.40583 .50435 .40933 .50777 .41208 .50722 .40858 .50379 Mtetra
.362 .519 .879 r
.40858 .50379 .41208 .50722 .41482 .50797 .41132 .50454 Mtetra
0 .287 .783 r
.41132 .50454 .41482 .50797 .41755 .50991 .41404 .50648 Mtetra
.616 .1 0 r
.41404 .50648 .41755 .50991 .42027 .51288 .41676 .50943 Mtetra
.803 .312 0 r
.41676 .50943 .42027 .51288 .42299 .51664 .41948 .5132 Mtetra
.849 .393 .1 r
.41948 .5132 .42299 .51664 .42572 .52096 .4222 .51751 Mtetra
.86 .419 .152 r
.4222 .51751 .42572 .52096 .42845 .52556 .42492 .5221 Mtetra
.859 .415 .143 r
.42492 .5221 .42845 .52556 .43119 .53012 .42766 .52666 Mtetra
.841 .377 .069 r
.42766 .52666 .43119 .53012 .43394 .53435 .43041 .53089 Mtetra
.769 .266 0 r
.43041 .53089 .43394 .53435 .43671 .53796 .43317 .53449 Mtetra
0 .019 .517 r
.43317 .53449 .43671 .53796 .4395 .54067 .43596 .53719 Mtetra
.099 .4 .854 r
.43596 .53719 .4395 .54067 .44231 .54224 .43876 .53876 Mtetra
.46 .554 .865 r
.43876 .53876 .44231 .54224 .44514 .54251 .44158 .53903 Mtetra
.604 .591 .811 r
.44158 .53903 .44514 .54251 .44798 .54137 .44442 .53788 Mtetra
.668 .6 .77 r
.44442 .53788 .44798 .54137 .45084 .53878 .44728 .53529 Mtetra
.701 .602 .743 r
.44728 .53529 .45084 .53878 .45371 .5348 .45015 .53131 Mtetra
.72 .602 .725 r
.45015 .53131 .45371 .5348 .45659 .52956 .45304 .52607 Mtetra
.731 .602 .713 r
.45304 .52607 .45659 .52956 .45948 .52329 .45593 .51979 Mtetra
.738 .602 .706 r
.45593 .51979 .45948 .52329 .46238 .51626 .45882 .51277 Mtetra
.741 .602 .703 r
.45882 .51277 .46238 .51626 .46527 .50883 .46172 .50533 Mtetra
.741 .602 .702 r
.46172 .50533 .46527 .50883 .46817 .50136 .46462 .49786 Mtetra
.738 .602 .705 r
.46462 .49786 .46817 .50136 .47106 .49424 .46751 .49074 Mtetra
.732 .602 .712 r
.46751 .49074 .47106 .49424 .47394 .48783 .47039 .48433 Mtetra
.722 .602 .723 r
.47039 .48433 .47394 .48783 .47683 .48246 .47328 .47896 Mtetra
.703 .602 .741 r
.47328 .47896 .47683 .48246 .47971 .47836 .47616 .47486 Mtetra
.67 .6 .768 r
.47616 .47486 .47971 .47836 .48258 .47568 .47903 .47218 Mtetra
.61 .591 .808 r
.47903 .47218 .48258 .47568 .48546 .47443 .48191 .47092 Mtetra
.492 .563 .856 r
.48191 .47092 .48546 .47443 .48835 .47449 .48479 .47098 Mtetra
.278 .484 .88 r
.48479 .47098 .48835 .47449 .49123 .47562 .48767 .4721 Mtetra
.024 .359 .832 r
.48767 .4721 .49123 .47562 .49413 .47742 .49057 .4739 Mtetra
0 .302 .794 r
.49057 .4739 .49413 .47742 .49703 .47945 .49346 .47592 Mtetra
.068 .383 .845 r
.49346 .47592 .49703 .47945 .49994 .48117 .49637 .47764 Mtetra
.337 .509 .88 r
.49637 .47764 .49994 .48117 .50286 .48208 .49928 .47855 Mtetra
.535 .575 .842 r
.49928 .47855 .50286 .48208 .50578 .48177 .5022 .47823 Mtetra
.635 .596 .793 r
.5022 .47823 .50578 .48177 .5087 .48 .50512 .47646 Mtetra
.684 .601 .758 r
.50512 .47646 .5087 .48 .51163 .47677 .50805 .47323 Mtetra
.707 .603 .737 r
.50805 .47323 .51163 .47677 .51455 .47238 .51097 .46884 Mtetra
.716 .603 .729 r
.51097 .46884 .51455 .47238 .51747 .46739 .51389 .46384 Mtetra
.714 .603 .731 r
.51389 .46384 .51747 .46739 .5204 .46256 .51682 .45901 Mtetra
.698 .602 .746 r
.51682 .45901 .5204 .46256 .52333 .45868 .51975 .45513 Mtetra
.659 .599 .777 r
.51975 .45513 .52333 .45868 .52627 .45631 .52269 .45275 Mtetra
.587 .587 .819 r
.52269 .45275 .52627 .45631 .52922 .45537 .52564 .45181 Mtetra
.549 .578 .836 r
.52564 .45181 .52922 .45537 .53218 .45491 .52859 .45135 Mtetra
.631 .595 .795 r
.52859 .45135 .53218 .45491 .53514 .45321 .53155 .44964 Mtetra
.676 .601 .763 r
.53155 .44964 .53514 .45321 .53809 .45024 .5345 .44667 Mtetra
.631 .595 .795 r
.5345 .44667 .53809 .45024 .54106 .44853 .53747 .44496 Mtetra
.55 .578 .836 r
.53747 .44496 .54106 .44853 .54404 .44806 .54044 .44449 Mtetra
.588 .587 .819 r
.54044 .44449 .54404 .44806 .54702 .44711 .54342 .44354 Mtetra
.659 .599 .777 r
.54342 .44354 .54702 .44711 .55 .44471 .5464 .44113 Mtetra
.698 .602 .746 r
.5464 .44113 .55 .44471 .55296 .4408 .54936 .43722 Mtetra
.714 .603 .731 r
.54936 .43722 .55296 .4408 .55592 .43593 .55231 .43235 Mtetra
.716 .603 .729 r
.55231 .43235 .55592 .43593 .55887 .43089 .55527 .4273 Mtetra
.707 .603 .737 r
.55527 .4273 .55887 .43089 .56183 .42644 .55823 .42286 Mtetra
.684 .601 .758 r
.55823 .42286 .56183 .42644 .56481 .42316 .56121 .41957 Mtetra
.636 .596 .792 r
.56121 .41957 .56481 .42316 .56781 .42133 .5642 .41774 Mtetra
.54 .576 .839 r
.5642 .41774 .56781 .42133 .57083 .42096 .56722 .41736 Mtetra
.361 .517 .877 r
.56722 .41736 .57083 .42096 .57388 .42181 .57027 .41821 Mtetra
.127 .412 .859 r
.57027 .41821 .57388 .42181 .57694 .42348 .57333 .41987 Mtetra
.002 .345 .823 r
.57333 .41987 .57694 .42348 .58002 .42547 .5764 .42186 Mtetra
.088 .392 .85 r
.5764 .42186 .58002 .42547 .58311 .42725 .57948 .42363 Mtetra
.307 .496 .879 r
.57948 .42363 .58311 .42725 .58619 .42834 .58256 .42472 Mtetra
.498 .564 .854 r
.58256 .42472 .58619 .42834 .58926 .42836 .58563 .42473 Mtetra
.61 .591 .808 r
.58563 .42473 .58926 .42836 .59231 .42703 .58868 .4234 Mtetra
.67 .6 .769 r
.58868 .4234 .59231 .42703 .59535 .42423 .59171 .4206 Mtetra
.703 .603 .742 r
.59171 .4206 .59535 .42423 .59836 .41998 .59472 .41635 Mtetra
.722 .603 .724 r
.59472 .41635 .59836 .41998 .60135 .41443 .59771 .4108 Mtetra
.733 .603 .712 r
.59771 .4108 .60135 .41443 .60432 .40782 .60068 .40419 Mtetra
.74 .603 .705 r
.60068 .40419 .60432 .40782 .60727 .40049 .60364 .39686 Mtetra
.742 .603 .702 r
.60364 .39686 .60727 .40049 .61022 .39281 .60658 .38918 Mtetra
.60658 .38918 .61022 .39281 .61316 .38518 .60953 .38154 Mtetra
.739 .603 .706 r
.60953 .38154 .61316 .38518 .61611 .37796 .61249 .37433 Mtetra
.732 .603 .713 r
.61249 .37433 .61611 .37796 .61908 .37151 .61545 .36787 Mtetra
.72 .603 .725 r
.61545 .36787 .61908 .37151 .62207 .36609 .61845 .36245 Mtetra
.701 .603 .743 r
.61845 .36245 .62207 .36609 .62509 .36192 .62147 .35828 Mtetra
.668 .6 .77 r
.62147 .35828 .62509 .36192 .62815 .35915 .62452 .3555 Mtetra
.609 .591 .807 r
.62452 .3555 .62815 .35915 .63124 .35781 .62761 .35416 Mtetra
.491 .561 .855 r
.62761 .35416 .63124 .35781 .63438 .35789 .63074 .35424 Mtetra
.239 .464 .875 r
.63074 .35424 .63438 .35789 .63755 .35928 .63391 .35562 Mtetra
0 .221 .73 r
.63391 .35562 .63755 .35928 .64076 .36182 .63712 .35816 Mtetra
.576 .067 0 r
.63712 .35816 .64076 .36182 .64401 .36529 .64036 .36163 Mtetra
.737 .229 0 r
.64036 .36163 .64401 .36529 .64729 .36943 .64363 .36575 Mtetra
.788 .294 0 r
.64363 .36575 .64729 .36943 .65058 .37393 .64692 .37025 Mtetra
.794 .301 0 r
.64692 .37025 .65058 .37393 .6539 .3785 .65023 .37482 Mtetra
.759 .256 0 r
.65023 .37482 .6539 .3785 .65721 .38282 .65354 .37913 Mtetra
.646 .133 0 r
.65354 .37913 .65721 .38282 .66052 .3866 .65685 .3829 Mtetra
0 .112 .626 r
.65685 .3829 .66052 .3866 .66382 .38955 .66014 .38585 Mtetra
.087 .39 .849 r
.66014 .38585 .66382 .38955 .6671 .39146 .66341 .38776 Mtetra
.407 .534 .872 r
.66341 .38776 .6671 .39146 .67035 .39213 .66666 .38842 Mtetra
.566 .582 .829 r
.66666 .38842 .67035 .39213 .67356 .39142 .66987 .38771 Mtetra
.645 .597 .786 r
.66987 .38771 .67356 .39142 .67674 .38926 .67304 .38554 Mtetra
.688 .602 .754 r
.67304 .38554 .67674 .38926 .67986 .38561 .67617 .38189 Mtetra
.714 .604 .732 r
.67617 .38189 .67986 .38561 .68295 .38053 .67925 .3768 Mtetra
.731 .604 .715 r
.67925 .3768 .68295 .38053 .68599 .37409 .68229 .37036 Mtetra
.742 .604 .703 r
.68229 .37036 .68599 .37409 .68898 .36643 .68529 .36271 Mtetra
.749 .603 .695 r
.68529 .36271 .68898 .36643 .69194 .35774 .68825 .35402 Mtetra
.754 .603 .689 r
.68825 .35402 .69194 .35774 .69487 .34823 .69118 .34451 Mtetra
.757 .603 .685 r
.69118 .34451 .69487 .34823 .69777 .33814 .69409 .33442 Mtetra
.759 .602 .683 r
.69409 .33442 .69777 .33814 .70066 .32773 .69698 .324 Mtetra
.69698 .324 .70066 .32773 .70354 .31724 .69986 .31352 Mtetra
.759 .602 .684 r
.69986 .31352 .70354 .31724 .70642 .30694 .70274 .30322 Mtetra
.757 .603 .686 r
.70274 .30322 .70642 .30694 .70931 .29708 .70564 .29336 Mtetra
.753 .603 .691 r
.70564 .29336 .70931 .29708 .71223 .28788 .70855 .28416 Mtetra
.747 .603 .697 r
.70855 .28416 .71223 .28788 .71517 .27956 .7115 .27584 Mtetra
.739 .604 .706 r
.7115 .27584 .71517 .27956 .71816 .27228 .71449 .26856 Mtetra
.727 .604 .719 r
.71449 .26856 .71816 .27228 .72119 .2662 .71752 .26248 Mtetra
.71 .603 .736 r
.71752 .26248 .72119 .2662 .72428 .26143 .72061 .2577 Mtetra
.682 .601 .759 r
.72061 .2577 .72428 .26143 .72742 .25804 .72376 .25431 Mtetra
.636 .595 .791 r
.72376 .25431 .72742 .25804 .73063 .25608 .72696 .25234 Mtetra
.552 .577 .833 r
.72696 .25234 .73063 .25608 .73391 .25554 .73024 .2518 Mtetra
.381 .522 .873 r
.73024 .2518 .73391 .25554 .73726 .25639 .73358 .25264 Mtetra
.029 .356 .83 r
.73358 .25264 .73726 .25639 .74067 .25856 .73699 .25481 Mtetra
0 .036 .546 r
.73699 .25481 .74067 .25856 .74415 .26195 .74046 .2582 Mtetra
.733 .227 0 r
.74046 .2582 .74415 .26195 .74769 .26644 .74399 .26268 Mtetra
.831 .357 .017 r
.74399 .26268 .74769 .26644 .75128 .27187 .74758 .2681 Mtetra
.862 .418 .132 r
.74758 .2681 .75128 .27187 .75493 .27806 .75122 .27428 Mtetra
.873 .448 .193 r
.75122 .27428 .75493 .27806 .75862 .28481 .7549 .28103 Mtetra
.877 .462 .223 r
.7549 .28103 .75862 .28481 .76234 .29191 .75861 .28812 Mtetra
.878 .466 .232 r
.75861 .28812 .76234 .29191 .76608 .29915 .76235 .29535 Mtetra
.877 .461 .221 r
.76235 .29535 .76608 .29915 .76984 .3063 .7661 .3025 Mtetra
.824 .517 .471 r
.32039 .57692 .32389 .57886 .3263 .5859 .3228 .58396 Mtetra
.824 .519 .474 r
.3228 .58396 .3263 .5859 .32872 .59309 .32521 .59115 Mtetra
.824 .518 .472 r
.32521 .59115 .32872 .59309 .33116 .60022 .32764 .59828 Mtetra
.825 .513 .463 r
.32764 .59828 .33116 .60022 .33361 .60707 .33009 .60512 Mtetra
.825 .505 .447 r
.33009 .60512 .33361 .60707 .33609 .61343 .33256 .61148 Mtetra
.826 .489 .417 r
.33256 .61148 .33609 .61343 .33859 .61909 .33506 .61715 Mtetra
.825 .46 .364 r
.33506 .61715 .33859 .61909 .34113 .62388 .33759 .62194 Mtetra
.814 .397 .255 r
.33759 .62194 .34113 .62388 .34371 .62762 .34017 .62567 Mtetra
.736 .22 0 r
.34017 .62567 .34371 .62762 .34633 .63016 .34278 .62822 Mtetra
0 .342 .745 r
.34278 .62822 .34633 .63016 .34898 .6314 .34543 .62945 Mtetra
.484 .665 .943 r
.34543 .62945 .34898 .6314 .35168 .63126 .34813 .62931 Mtetra
.66 .671 .85 r
.34813 .62931 .35168 .63126 .35442 .62969 .35086 .62773 Mtetra
.716 .656 .789 r
.35086 .62773 .35442 .62969 .35719 .62669 .35363 .62473 Mtetra
.74 .644 .753 r
.35363 .62473 .35719 .62669 .36 .6223 .35644 .62034 Mtetra
.753 .636 .731 r
.35644 .62034 .36 .6223 .36283 .6166 .35928 .61464 Mtetra
.761 .631 .716 r
.35928 .61464 .36283 .6166 .3657 .60972 .36215 .60775 Mtetra
.766 .627 .706 r
.36215 .60775 .3657 .60972 .36858 .6018 .36503 .59983 Mtetra
.77 .624 .699 r
.36503 .59983 .36858 .6018 .37148 .59303 .36794 .59106 Mtetra
.772 .622 .694 r
.36794 .59106 .37148 .59303 .3744 .58363 .37085 .58165 Mtetra
.773 .621 .691 r
.37085 .58165 .3744 .58363 .37731 .57383 .37378 .57185 Mtetra
.773 .621 .69 r
.37378 .57185 .37731 .57383 .38023 .56387 .3767 .56189 Mtetra
.773 .621 .691 r
.3767 .56189 .38023 .56387 .38314 .554 .37961 .55202 Mtetra
.772 .622 .693 r
.37961 .55202 .38314 .554 .38604 .54449 .38251 .5425 Mtetra
.77 .623 .697 r
.38251 .5425 .38604 .54449 .38893 .53555 .3854 .53356 Mtetra
.767 .626 .703 r
.3854 .53356 .38893 .53555 .39179 .52742 .38827 .52542 Mtetra
.763 .629 .712 r
.38827 .52542 .39179 .52742 .39464 .52028 .39113 .51828 Mtetra
.756 .634 .726 r
.39113 .51828 .39464 .52028 .39747 .51431 .39395 .51231 Mtetra
.744 .641 .747 r
.39395 .51231 .39747 .51431 .40028 .50961 .39676 .50761 Mtetra
.722 .651 .779 r
.39676 .50761 .40028 .50961 .40306 .50628 .39955 .50428 Mtetra
.677 .665 .83 r
.39955 .50428 .40306 .50628 .40583 .50435 .40231 .50234 Mtetra
.56 .67 .912 r
.40231 .50234 .40583 .50435 .40858 .50379 .40506 .50178 Mtetra
.159 .548 .927 r
.40506 .50178 .40858 .50379 .41132 .50454 .40779 .50253 Mtetra
.545 0 0 r
.40779 .50253 .41132 .50454 .41404 .50648 .41052 .50446 Mtetra
.769 .276 .049 r
.41052 .50446 .41404 .50648 .41676 .50943 .41323 .50742 Mtetra
.813 .381 .218 r
.41323 .50742 .41676 .50943 .41948 .5132 .41594 .51118 Mtetra
.823 .422 .288 r
.41594 .51118 .41948 .5132 .4222 .51751 .41866 .51549 Mtetra
.826 .436 .314 r
.41866 .51549 .4222 .51751 .42492 .5221 .42138 .52008 Mtetra
.826 .434 .31 r
.42138 .52008 .42492 .5221 .42766 .52666 .42411 .52464 Mtetra
.821 .413 .273 r
.42411 .52464 .42766 .52666 .43041 .53089 .42685 .52886 Mtetra
.805 .358 .181 r
.42685 .52886 .43041 .53089 .43317 .53449 .42961 .53246 Mtetra
.732 .209 0 r
.42961 .53246 .43317 .53449 .43596 .53719 .43239 .53516 Mtetra
0 .227 .626 r
.43239 .53516 .43596 .53719 .43876 .53876 .43519 .53674 Mtetra
.372 .634 .956 r
.43519 .53674 .43876 .53876 .44158 .53903 .43801 .537 Mtetra
.624 .673 .876 r
.43801 .537 .44158 .53903 .44442 .53788 .44085 .53585 Mtetra
.701 .661 .807 r
.44085 .53585 .44442 .53788 .44728 .53529 .44371 .53326 Mtetra
.733 .649 .765 r
.44371 .53326 .44728 .53529 .45015 .53131 .44658 .52927 Mtetra
.749 .64 .74 r
.44658 .52927 .45015 .53131 .45304 .52607 .44947 .52403 Mtetra
.758 .635 .724 r
.44947 .52403 .45304 .52607 .45593 .51979 .45236 .51775 Mtetra
.763 .632 .715 r
.45236 .51775 .45593 .51979 .45882 .51277 .45526 .51072 Mtetra
.765 .63 .711 r
.45526 .51072 .45882 .51277 .46172 .50533 .45816 .50328 Mtetra
.45816 .50328 .46172 .50533 .46462 .49786 .46105 .49581 Mtetra
.764 .631 .714 r
.46105 .49581 .46462 .49786 .46751 .49074 .46395 .48869 Mtetra
.759 .634 .723 r
.46395 .48869 .46751 .49074 .47039 .48433 .46684 .48228 Mtetra
.751 .64 .738 r
.46684 .48228 .47039 .48433 .47328 .47896 .46972 .4769 Mtetra
.735 .648 .762 r
.46972 .4769 .47328 .47896 .47616 .47486 .4726 .4728 Mtetra
.703 .659 .803 r
.4726 .4728 .47616 .47486 .47903 .47218 .47548 .47011 Mtetra
.632 .671 .869 r
.47548 .47011 .47903 .47218 .48191 .47092 .47835 .46885 Mtetra
.437 .649 .948 r
.47835 .46885 .48191 .47092 .48479 .47098 .48123 .46891 Mtetra
0 .451 .857 r
.48123 .46891 .48479 .47098 .48767 .4721 .48411 .47003 Mtetra
.422 0 0 r
.48411 .47003 .48767 .4721 .49057 .4739 .487 .47183 Mtetra
.519 0 0 r
.487 .47183 .49057 .4739 .49346 .47592 .48989 .47385 Mtetra
.37 0 0 r
.48989 .47385 .49346 .47592 .49637 .47764 .4928 .47556 Mtetra
.109 .521 .911 r
.4928 .47556 .49637 .47764 .49928 .47855 .49571 .47647 Mtetra
.517 .665 .929 r
.49571 .47647 .49928 .47855 .5022 .47823 .49862 .47615 Mtetra
.664 .668 .844 r
.49862 .47615 .5022 .47823 .50512 .47646 .50154 .47438 Mtetra
.717 .656 .787 r
.50154 .47438 .50512 .47646 .50805 .47323 .50447 .47115 Mtetra
.739 .647 .758 r
.50447 .47115 .50805 .47323 .51097 .46884 .50739 .46675 Mtetra
.746 .643 .746 r
.50739 .46675 .51097 .46884 .51389 .46384 .51031 .46175 Mtetra
.744 .644 .749 r
.51031 .46175 .51389 .46384 .51682 .45901 .51324 .45692 Mtetra
.73 .65 .77 r
.51324 .45692 .51682 .45901 .51975 .45513 .51617 .45304 Mtetra
.691 .663 .817 r
.51617 .45304 .51975 .45513 .52269 .45275 .51911 .45065 Mtetra
.601 .671 .89 r
.51911 .45065 .52269 .45275 .52564 .45181 .52205 .44971 Mtetra
.541 .667 .919 r
.52205 .44971 .52564 .45181 .52859 .45135 .52501 .44924 Mtetra
.659 .668 .848 r
.52501 .44924 .52859 .45135 .53155 .44964 .52797 .44754 Mtetra
.71 .658 .796 r
.52797 .44754 .53155 .44964 .5345 .44667 .53092 .44456 Mtetra
.659 .668 .848 r
.53092 .44456 .5345 .44667 .53747 .44496 .53388 .44285 Mtetra
.542 .667 .919 r
.53388 .44285 .53747 .44496 .54044 .44449 .53686 .44238 Mtetra
.601 .671 .889 r
.53686 .44238 .54044 .44449 .54342 .44354 .53983 .44142 Mtetra
.691 .663 .817 r
.53983 .44142 .54342 .44354 .5464 .44113 .54281 .43902 Mtetra
.731 .651 .77 r
.54281 .43902 .5464 .44113 .54936 .43722 .54577 .4351 Mtetra
.745 .645 .749 r
.54577 .4351 .54936 .43722 .55231 .43235 .54872 .43022 Mtetra
.747 .644 .746 r
.54872 .43022 .55231 .43235 .55527 .4273 .55168 .42518 Mtetra
.739 .647 .758 r
.55168 .42518 .55527 .4273 .55823 .42286 .55464 .42073 Mtetra
.717 .656 .787 r
.55464 .42073 .55823 .42286 .56121 .41957 .55762 .41744 Mtetra
.665 .667 .842 r
.55762 .41744 .56121 .41957 .5642 .41774 .56061 .4156 Mtetra
.526 .664 .924 r
.56061 .4156 .5642 .41774 .56722 .41736 .56363 .41522 Mtetra
.168 .547 .928 r
.56363 .41522 .56722 .41736 .57027 .41821 .56667 .41607 Mtetra
0 .269 .683 r
.56667 .41607 .57027 .41821 .57333 .41987 .56973 .41773 Mtetra
.437 0 0 r
.56973 .41773 .57333 .41987 .5764 .42186 .5728 .41971 Mtetra
0 .225 .635 r
.5728 .41971 .5764 .42186 .57948 .42363 .57588 .42149 Mtetra
.052 .488 .889 r
.57588 .42149 .57948 .42363 .58256 .42472 .57895 .42258 Mtetra
.451 .65 .944 r
.57895 .42258 .58256 .42472 .58563 .42473 .58202 .42258 Mtetra
.632 .671 .869 r
.58202 .42258 .58563 .42473 .58868 .4234 .58507 .42125 Mtetra
.703 .661 .805 r
.58507 .42125 .58868 .4234 .59171 .4206 .5881 .41845 Mtetra
.736 .65 .764 r
.5881 .41845 .59171 .4206 .59472 .41635 .59111 .41419 Mtetra
.752 .642 .739 r
.59111 .41419 .59472 .41635 .59771 .4108 .5941 .40863 Mtetra
.761 .637 .723 r
.5941 .40863 .59771 .4108 .60068 .40419 .59707 .40202 Mtetra
.766 .634 .714 r
.59707 .40202 .60068 .40419 .60364 .39686 .60003 .39469 Mtetra
.768 .632 .711 r
.60003 .39469 .60364 .39686 .60658 .38918 .60298 .38701 Mtetra
.768 .633 .711 r
.60298 .38701 .60658 .38918 .60953 .38154 .60593 .37937 Mtetra
.765 .634 .716 r
.60593 .37937 .60953 .38154 .61249 .37433 .60889 .37215 Mtetra
.76 .637 .725 r
.60889 .37215 .61249 .37433 .61545 .36787 .61186 .36569 Mtetra
.751 .643 .741 r
.61186 .36569 .61545 .36787 .61845 .36245 .61485 .36027 Mtetra
.734 .65 .766 r
.61485 .36027 .61845 .36245 .62147 .35828 .61787 .3561 Mtetra
.701 .66 .806 r
.61787 .3561 .62147 .35828 .62452 .3555 .62092 .35331 Mtetra
.631 .669 .868 r
.62092 .35331 .62452 .3555 .62761 .35416 .62401 .35197 Mtetra
.439 .644 .944 r
.62401 .35197 .62761 .35416 .63074 .35424 .62714 .35204 Mtetra
0 .408 .825 r
.62714 .35204 .63074 .35424 .63391 .35562 .63031 .35343 Mtetra
.597 .03 0 r
.63031 .35343 .63391 .35562 .63712 .35816 .63351 .35596 Mtetra
.76 .252 0 r
.63351 .35596 .63712 .35816 .64036 .36163 .63675 .35943 Mtetra
.803 .338 .127 r
.63675 .35943 .64036 .36163 .64363 .36575 .64001 .36355 Mtetra
.816 .371 .181 r
.64001 .36355 .64363 .36575 .64692 .37025 .6433 .36805 Mtetra
.817 .374 .187 r
.6433 .36805 .64692 .37025 .65023 .37482 .6466 .37261 Mtetra
.809 .352 .149 r
.6466 .37261 .65023 .37482 .65354 .37913 .6499 .37692 Mtetra
.78 .288 .048 r
.6499 .37692 .65354 .37913 .65685 .3829 .65321 .38069 Mtetra
.681 .133 0 r
.65321 .38069 .65685 .3829 .66014 .38585 .6565 .38364 Mtetra
0 .228 .642 r
.6565 .38364 .66014 .38585 .66341 .38776 .65977 .38554 Mtetra
.269 .589 .947 r
.65977 .38554 .66341 .38776 .66666 .38842 .66301 .38621 Mtetra
.568 .669 .906 r
.66301 .38621 .66666 .38842 .66987 .38771 .66622 .38549 Mtetra
.676 .667 .833 r
.66622 .38549 .66987 .38771 .67304 .38554 .66939 .38332 Mtetra
.723 .656 .783 r
.66939 .38332 .67304 .38554 .67617 .38189 .67251 .37967 Mtetra
.747 .647 .75 r
.67251 .37967 .67617 .38189 .67925 .3768 .6756 .37458 Mtetra
.76 .64 .728 r
.6756 .37458 .67925 .3768 .68229 .37036 .67864 .36813 Mtetra
.769 .635 .713 r
.67864 .36813 .68229 .37036 .68529 .36271 .68164 .36047 Mtetra
.774 .631 .702 r
.68164 .36047 .68529 .36271 .68825 .35402 .68461 .35178 Mtetra
.778 .629 .695 r
.68461 .35178 .68825 .35402 .69118 .34451 .68754 .34227 Mtetra
.78 .627 .691 r
.68754 .34227 .69118 .34451 .69409 .33442 .69045 .33218 Mtetra
.781 .626 .688 r
.69045 .33218 .69409 .33442 .69698 .324 .69334 .32175 Mtetra
.782 .626 .687 r
.69334 .32175 .69698 .324 .69986 .31352 .69623 .31126 Mtetra
.781 .626 .689 r
.69623 .31126 .69986 .31352 .70274 .30322 .69912 .30096 Mtetra
.78 .628 .692 r
.69912 .30096 .70274 .30322 .70564 .29336 .70202 .2911 Mtetra
.777 .629 .697 r
.70202 .2911 .70564 .29336 .70855 .28416 .70494 .2819 Mtetra
.773 .632 .705 r
.70494 .2819 .70855 .28416 .7115 .27584 .70789 .27357 Mtetra
.767 .636 .716 r
.70789 .27357 .7115 .27584 .71449 .26856 .71088 .26629 Mtetra
.757 .641 .733 r
.71088 .26629 .71449 .26856 .71752 .26248 .71391 .26021 Mtetra
.742 .648 .756 r
.71391 .26021 .71752 .26248 .72061 .2577 .717 .25543 Mtetra
.716 .656 .79 r
.717 .25543 .72061 .2577 .72376 .25431 .72014 .25204 Mtetra
.664 .665 .841 r
.72014 .25204 .72376 .25431 .72696 .25234 .72335 .25006 Mtetra
.546 .661 .912 r
.72335 .25006 .72696 .25234 .73024 .2518 .72663 .24952 Mtetra
.224 .563 .937 r
.72663 .24952 .73024 .2518 .73358 .25264 .72996 .25036 Mtetra
.384 0 0 r
.72996 .25036 .73358 .25264 .73699 .25481 .73337 .25252 Mtetra
.716 .182 0 r
.73337 .25252 .73699 .25481 .74046 .2582 .73684 .25591 Mtetra
.805 .335 .111 r
.73684 .25591 .74046 .2582 .74399 .26268 .74036 .26039 Mtetra
.83 .403 .225 r
.74036 .26039 .74399 .26268 .74758 .2681 .74395 .26581 Mtetra
.838 .438 .286 r
.74395 .26581 .74758 .2681 .75122 .27428 .74758 .27199 Mtetra
.842 .456 .319 r
.74758 .27199 .75122 .27428 .7549 .28103 .75125 .27873 Mtetra
.843 .465 .336 r
.75125 .27873 .7549 .28103 .75861 .28812 .75496 .28582 Mtetra
.843 .468 .341 r
.75496 .28582 .75861 .28812 .76235 .29535 .75869 .29305 Mtetra
.843 .465 .335 r
.75869 .29305 .76235 .29535 .7661 .3025 .76243 .30019 Mtetra
.79 .5 .498 r
.31685 .57639 .32039 .57692 .3228 .58396 .31925 .58344 Mtetra
.79 .502 .501 r
.31925 .58344 .3228 .58396 .32521 .59115 .32166 .59063 Mtetra
.79 .501 .499 r
.32166 .59063 .32521 .59115 .32764 .59828 .32408 .59776 Mtetra
.789 .496 .493 r
.32408 .59776 .32764 .59828 .33009 .60512 .32652 .60461 Mtetra
.787 .488 .482 r
.32652 .60461 .33009 .60512 .33256 .61148 .32898 .61097 Mtetra
.784 .474 .463 r
.32898 .61097 .33256 .61148 .33506 .61715 .33148 .61664 Mtetra
.778 .449 .431 r
.33148 .61664 .33506 .61715 .33759 .62194 .33401 .62143 Mtetra
.765 .404 .372 r
.33401 .62143 .33759 .62194 .34017 .62567 .33658 .62517 Mtetra
.727 .304 .243 r
.33658 .62517 .34017 .62567 .34278 .62822 .33919 .62771 Mtetra
.551 0 0 r
.33919 .62771 .34278 .62822 .34543 .62945 .34184 .62895 Mtetra
.283 .742 .953 r
.34184 .62895 .34543 .62945 .34813 .62931 .34453 .6288 Mtetra
.695 .796 .928 r
.34453 .6288 .34813 .62931 .35086 .62773 .34727 .62723 Mtetra
.762 .737 .83 r
.34727 .62723 .35086 .62773 .35363 .62473 .35004 .62422 Mtetra
.78 .701 .776 r
.35004 .62422 .35363 .62473 .35644 .62034 .35285 .61983 Mtetra
.788 .68 .745 r
.35285 .61983 .35644 .62034 .35928 .61464 .35569 .61412 Mtetra
.791 .667 .726 r
.35569 .61412 .35928 .61464 .36215 .60775 .35856 .60723 Mtetra
.793 .658 .713 r
.35856 .60723 .36215 .60775 .36503 .59983 .36145 .5993 Mtetra
.794 .652 .705 r
.36145 .5993 .36503 .59983 .36794 .59106 .36436 .59053 Mtetra
.795 .648 .699 r
.36436 .59053 .36794 .59106 .37085 .58165 .36728 .58112 Mtetra
.795 .646 .696 r
.36728 .58112 .37085 .58165 .37378 .57185 .3702 .5713 Mtetra
.796 .645 .695 r
.3702 .5713 .37378 .57185 .3767 .56189 .37313 .56134 Mtetra
.37313 .56134 .3767 .56189 .37961 .55202 .37605 .55146 Mtetra
.795 .647 .698 r
.37605 .55146 .37961 .55202 .38251 .5425 .37895 .54193 Mtetra
.795 .65 .703 r
.37895 .54193 .38251 .5425 .3854 .53356 .38185 .53299 Mtetra
.794 .656 .71 r
.38185 .53299 .3854 .53356 .38827 .52542 .38472 .52485 Mtetra
.792 .663 .722 r
.38472 .52485 .38827 .52542 .39113 .51828 .38758 .5177 Mtetra
.788 .675 .739 r
.38758 .5177 .39113 .51828 .39395 .51231 .39041 .51172 Mtetra
.782 .694 .767 r
.39041 .51172 .39395 .51231 .39676 .50761 .39322 .50702 Mtetra
.766 .724 .813 r
.39322 .50702 .39676 .50761 .39955 .50428 .396 .50369 Mtetra
.719 .773 .895 r
.396 .50369 .39955 .50428 .40231 .50234 .39877 .50175 Mtetra
.497 .806 1 r
.39877 .50175 .40231 .50234 .40506 .50178 .40152 .50119 Mtetra
.31 0 0 r
.40152 .50119 .40506 .50178 .40779 .50253 .40425 .50193 Mtetra
.672 .182 .076 r
.40425 .50193 .40779 .50253 .41052 .50446 .40697 .50387 Mtetra
.745 .334 .27 r
.40697 .50387 .41052 .50446 .41323 .50742 .40968 .50683 Mtetra
.767 .394 .35 r
.40968 .50683 .41323 .50742 .41594 .51118 .41238 .51059 Mtetra
.776 .422 .386 r
.41238 .51059 .41594 .51118 .41866 .51549 .41509 .51491 Mtetra
.779 .432 .4 r
.41509 .51491 .41866 .51549 .42138 .52008 .41781 .51949 Mtetra
.778 .431 .398 r
.41781 .51949 .42138 .52008 .42411 .52464 .42054 .52406 Mtetra
.774 .416 .378 r
.42054 .52406 .42411 .52464 .42685 .52886 .42328 .52828 Mtetra
.762 .38 .331 r
.42328 .52828 .42685 .52886 .42961 .53246 .42603 .53188 Mtetra
.73 .299 .226 r
.42603 .53188 .42961 .53246 .43239 .53516 .42881 .53459 Mtetra
.606 .072 0 r
.42881 .53459 .43239 .53516 .43519 .53674 .43161 .53616 Mtetra
.022 .582 .808 r
.43161 .53616 .43519 .53674 .43801 .537 .43443 .53642 Mtetra
.634 .812 .968 r
.43443 .53642 .43801 .537 .44085 .53585 .43727 .53527 Mtetra
.748 .754 .857 r
.43727 .53527 .44085 .53585 .44371 .53326 .44012 .53268 Mtetra
.776 .714 .793 r
.44012 .53268 .44371 .53326 .44658 .52927 .443 .52869 Mtetra
.787 .69 .758 r
.443 .52869 .44658 .52927 .44947 .52403 .44588 .52344 Mtetra
.791 .677 .737 r
.44588 .52344 .44947 .52403 .45236 .51775 .44878 .51716 Mtetra
.794 .669 .726 r
.44878 .51716 .45236 .51775 .45526 .51072 .45168 .51012 Mtetra
.795 .665 .72 r
.45168 .51012 .45526 .51072 .45816 .50328 .45458 .50268 Mtetra
.45458 .50268 .45816 .50328 .46105 .49581 .45748 .4952 Mtetra
.794 .668 .724 r
.45748 .4952 .46105 .49581 .46395 .48869 .46038 .48807 Mtetra
.792 .675 .735 r
.46038 .48807 .46395 .48869 .46684 .48228 .46327 .48166 Mtetra
.787 .688 .755 r
.46327 .48166 .46684 .48228 .46972 .4769 .46615 .47628 Mtetra
.777 .711 .789 r
.46615 .47628 .46972 .4769 .4726 .4728 .46903 .47217 Mtetra
.75 .749 .852 r
.46903 .47217 .4726 .4728 .47548 .47011 .47191 .46948 Mtetra
.649 .805 .958 r
.47191 .46948 .47548 .47011 .47835 .46885 .47479 .46822 Mtetra
.186 .684 .915 r
.47479 .46822 .47835 .46885 .48123 .46891 .47766 .46828 Mtetra
.456 0 0 r
.47766 .46828 .48123 .46891 .48411 .47003 .48054 .4694 Mtetra
.636 .116 0 r
.48054 .4694 .48411 .47003 .487 .47183 .48342 .4712 Mtetra
.666 .167 .051 r
.48342 .4712 .487 .47183 .48989 .47385 .48632 .47322 Mtetra
.619 .088 0 r
.48632 .47322 .48989 .47385 .4928 .47556 .48922 .47493 Mtetra
.356 0 0 r
.48922 .47493 .4928 .47556 .49571 .47647 .49213 .47584 Mtetra
.388 .776 .989 r
.49213 .47584 .49571 .47647 .49862 .47615 .49504 .47552 Mtetra
.702 .787 .917 r
.49504 .47552 .49862 .47615 .50154 .47438 .49796 .47375 Mtetra
.763 .735 .827 r
.49796 .47375 .50154 .47438 .50447 .47115 .50088 .47051 Mtetra
.781 .707 .783 r
.50088 .47051 .50447 .47115 .50739 .46675 .50381 .46611 Mtetra
.786 .697 .766 r
.50381 .46611 .50739 .46675 .51031 .46175 .50673 .46111 Mtetra
.784 .699 .77 r
.50673 .46111 .51031 .46175 .51324 .45692 .50966 .45627 Mtetra
.774 .719 .8 r
.50966 .45627 .51324 .45692 .51617 .45304 .51259 .45239 Mtetra
.737 .763 .874 r
.51259 .45239 .51617 .45304 .51911 .45065 .51553 .45 Mtetra
.589 .811 .984 r
.51553 .45 .51911 .45065 .52205 .44971 .51848 .44906 Mtetra
.452 .794 .998 r
.51848 .44906 .52205 .44971 .52501 .44924 .52143 .44859 Mtetra
.694 .79 .924 r
.52143 .44859 .52501 .44924 .52797 .44754 .52438 .44688 Mtetra
.757 .744 .841 r
.52438 .44688 .52797 .44754 .53092 .44456 .52734 .44391 Mtetra
.694 .79 .924 r
.52734 .44391 .53092 .44456 .53388 .44285 .5303 .44219 Mtetra
.455 .794 .999 r
.5303 .44219 .53388 .44285 .53686 .44238 .53327 .44172 Mtetra
.59 .811 .984 r
.53327 .44172 .53686 .44238 .53983 .44142 .53625 .44076 Mtetra
.737 .764 .875 r
.53625 .44076 .53983 .44142 .54281 .43902 .53922 .43835 Mtetra
.775 .72 .801 r
.53922 .43835 .54281 .43902 .54577 .4351 .54219 .43444 Mtetra
.785 .701 .771 r
.54219 .43444 .54577 .4351 .54872 .43022 .54514 .42955 Mtetra
.786 .698 .766 r
.54514 .42955 .54872 .43022 .55168 .42518 .5481 .4245 Mtetra
.781 .708 .783 r
.5481 .4245 .55168 .42518 .55464 .42073 .55106 .42005 Mtetra
.764 .736 .827 r
.55106 .42005 .55464 .42073 .55762 .41744 .55404 .41676 Mtetra
.702 .785 .915 r
.55404 .41676 .55762 .41744 .56061 .4156 .55704 .41492 Mtetra
.418 .782 .995 r
.55704 .41492 .56061 .4156 .56363 .41522 .56005 .41454 Mtetra
.289 0 0 r
.56005 .41454 .56363 .41522 .56667 .41607 .56309 .41538 Mtetra
.586 .035 0 r
.56309 .41538 .56667 .41607 .56973 .41773 .56615 .41705 Mtetra
.643 .122 0 r
.56615 .41705 .56973 .41773 .5728 .41971 .56921 .41903 Mtetra
.607 .066 0 r
.56921 .41903 .5728 .41971 .57588 .42149 .57229 .42081 Mtetra
.401 0 0 r
.57229 .42081 .57588 .42149 .57895 .42258 .57536 .42189 Mtetra
.227 .703 .937 r
.57536 .42189 .57895 .42258 .58202 .42258 .57842 .4219 Mtetra
.649 .804 .958 r
.57842 .4219 .58202 .42258 .58507 .42125 .58147 .42056 Mtetra
.75 .753 .855 r
.58147 .42056 .58507 .42125 .5881 .41845 .5845 .41776 Mtetra
.779 .715 .792 r
.5845 .41776 .5881 .41845 .59111 .41419 .58752 .4135 Mtetra
.791 .693 .757 r
.58752 .4135 .59111 .41419 .5941 .40863 .59051 .40794 Mtetra
.796 .68 .736 r
.59051 .40794 .5941 .40863 .59707 .40202 .59348 .40132 Mtetra
.798 .672 .725 r
.59348 .40132 .59707 .40202 .60003 .39469 .59645 .39399 Mtetra
.799 .669 .72 r
.59645 .39399 .60003 .39469 .60298 .38701 .5994 .3863 Mtetra
.799 .669 .721 r
.5994 .3863 .60298 .38701 .60593 .37937 .60235 .37865 Mtetra
.798 .673 .726 r
.60235 .37865 .60593 .37937 .60889 .37215 .60531 .37143 Mtetra
.795 .681 .739 r
.60531 .37143 .60889 .37215 .61186 .36569 .60828 .36496 Mtetra
.79 .695 .76 r
.60828 .36496 .61186 .36569 .61485 .36027 .61128 .35954 Mtetra
.778 .717 .795 r
.61128 .35954 .61485 .36027 .61787 .3561 .6143 .35536 Mtetra
.748 .752 .856 r
.6143 .35536 .61787 .3561 .62092 .35331 .61735 .35258 Mtetra
.648 .8 .956 r
.61735 .35258 .62092 .35331 .62401 .35197 .62044 .35123 Mtetra
.207 .689 .932 r
.62044 .35123 .62401 .35197 .62714 .35204 .62357 .3513 Mtetra
.488 0 0 r
.62357 .3513 .62714 .35204 .63031 .35343 .62673 .35269 Mtetra
.696 .209 .086 r
.62673 .35269 .63031 .35343 .63351 .35596 .62993 .35523 Mtetra
.75 .322 .232 r
.62993 .35523 .63351 .35596 .63675 .35943 .63317 .35869 Mtetra
.77 .37 .296 r
.63317 .35869 .63675 .35943 .64001 .36355 .63643 .36282 Mtetra
.777 .39 .323 r
.63643 .36282 .64001 .36355 .6433 .36805 .63971 .36732 Mtetra
.777 .392 .326 r
.63971 .36732 .6433 .36805 .6466 .37261 .64301 .37188 Mtetra
.772 .378 .307 r
.64301 .37188 .6466 .37261 .6499 .37692 .64631 .37619 Mtetra
.759 .341 .259 r
.64631 .37619 .6499 .37692 .65321 .38069 .6496 .37996 Mtetra
.722 .26 .153 r
.6496 .37996 .65321 .38069 .6565 .38364 .65289 .38292 Mtetra
.606 .06 0 r
.65289 .38292 .6565 .38364 .65977 .38554 .65616 .38482 Mtetra
.145 0 0 r
.65616 .38482 .65977 .38554 .66301 .38621 .6594 .38548 Mtetra
.519 .804 .998 r
.6594 .38548 .66301 .38621 .66622 .38549 .66261 .38476 Mtetra
.718 .78 .901 r
.66261 .38476 .66622 .38549 .66939 .38332 .66577 .38259 Mtetra
.77 .735 .821 r
.66577 .38259 .66939 .38332 .67251 .37967 .6689 .37894 Mtetra
.789 .706 .773 r
.6689 .37894 .67251 .37967 .6756 .37458 .67199 .37384 Mtetra
.797 .687 .742 r
.67199 .37384 .6756 .37458 .67864 .36813 .67503 .36739 Mtetra
.802 .674 .723 r
.67503 .36739 .67864 .36813 .68164 .36047 .67804 .35973 Mtetra
.804 .666 .71 r
.67804 .35973 .68164 .36047 .68461 .35178 .68101 .35103 Mtetra
.806 .66 .701 r
.68101 .35103 .68461 .35178 .68754 .34227 .68395 .34151 Mtetra
.807 .656 .696 r
.68395 .34151 .68754 .34227 .69045 .33218 .68686 .33141 Mtetra
.807 .654 .693 r
.68686 .33141 .69045 .33218 .69334 .32175 .68976 .32098 Mtetra
.808 .654 .692 r
.68976 .32098 .69334 .32175 .69623 .31126 .69265 .31048 Mtetra
.807 .655 .693 r
.69265 .31048 .69623 .31126 .69912 .30096 .69554 .30017 Mtetra
.807 .657 .697 r
.69554 .30017 .69912 .30096 .70202 .2911 .69845 .2903 Mtetra
.806 .661 .703 r
.69845 .2903 .70202 .2911 .70494 .2819 .70137 .2811 Mtetra
.804 .668 .713 r
.70137 .2811 .70494 .2819 .70789 .27357 .70432 .27276 Mtetra
.8 .677 .727 r
.70432 .27276 .70789 .27357 .71088 .26629 .70732 .26548 Mtetra
.795 .69 .748 r
.70732 .26548 .71088 .26629 .71391 .26021 .71035 .25939 Mtetra
.785 .709 .78 r
.71035 .25939 .71391 .26021 .717 .25543 .71344 .25461 Mtetra
.762 .738 .831 r
.71344 .25461 .717 .25543 .72014 .25204 .71659 .25121 Mtetra
.702 .78 .912 r
.71659 .25121 .72014 .25204 .72335 .25006 .7198 .24923 Mtetra
.479 .787 .998 r
.7198 .24923 .72335 .25006 .72663 .24952 .72307 .24868 Mtetra
.195 0 0 r
.72307 .24868 .72663 .24952 .72996 .25036 .7264 .24953 Mtetra
.629 .089 0 r
.7264 .24953 .72996 .25036 .73337 .25252 .72981 .25169 Mtetra
.74 .285 .171 r
.72981 .25169 .73337 .25252 .73684 .25591 .73327 .25508 Mtetra
.775 .369 .283 r
.73327 .25508 .73684 .25591 .74036 .26039 .73679 .25956 Mtetra
.79 .412 .341 r
.73679 .25956 .74036 .26039 .74395 .26581 .74037 .26498 Mtetra
.797 .437 .374 r
.74037 .26498 .74395 .26581 .74758 .27199 .744 .27117 Mtetra
.801 .451 .394 r
.744 .27117 .74758 .27199 .75125 .27873 .74767 .27791 Mtetra
.803 .458 .403 r
.74767 .27791 .75125 .27873 .75496 .28582 .75137 .28501 Mtetra
.803 .46 .406 r
.75137 .28501 .75496 .28582 .75869 .29305 .75509 .29224 Mtetra
.803 .457 .403 r
.75509 .29224 .75869 .29305 .76243 .30019 .75883 .29938 Mtetra
.766 .489 .514 r
.31326 .57699 .31685 .57639 .31925 .58344 .31566 .58405 Mtetra
.767 .49 .516 r
.31566 .58405 .31925 .58344 .32166 .59063 .31806 .59125 Mtetra
.766 .489 .514 r
.31806 .59125 .32166 .59063 .32408 .59776 .32048 .59838 Mtetra
.764 .484 .51 r
.32048 .59838 .32408 .59776 .32652 .60461 .32291 .60524 Mtetra
.761 .476 .501 r
.32291 .60524 .32652 .60461 .32898 .61097 .32537 .61161 Mtetra
.756 .463 .487 r
.32537 .61161 .32898 .61097 .33148 .61664 .32786 .61729 Mtetra
.747 .44 .464 r
.32786 .61729 .33148 .61664 .33401 .62143 .33039 .62208 Mtetra
.731 .402 .424 r
.33039 .62208 .33401 .62143 .33658 .62517 .33296 .62582 Mtetra
.695 .327 .347 r
.33296 .62582 .33658 .62517 .33919 .62771 .33556 .62837 Mtetra
.593 .146 .157 r
.33556 .62837 .33919 .62771 .34184 .62895 .33821 .62961 Mtetra
.122 0 0 r
.33821 .62961 .34184 .62895 .34453 .6288 .3409 .62946 Mtetra
.686 .93 .969 r
.3409 .62946 .34453 .6288 .34727 .62723 .34364 .62789 Mtetra
.809 .83 .867 r
.34364 .62789 .34727 .62723 .35004 .62422 .34641 .62488 Mtetra
.821 .762 .797 r
.34641 .62488 .35004 .62422 .35285 .61983 .34922 .62048 Mtetra
.821 .725 .758 r
.34922 .62048 .35285 .61983 .35569 .61412 .35206 .61477 Mtetra
.82 .702 .735 r
.35206 .61477 .35569 .61412 .35856 .60723 .35494 .60787 Mtetra
.818 .687 .719 r
.35494 .60787 .35856 .60723 .36145 .5993 .35783 .59994 Mtetra
.817 .678 .71 r
.35783 .59994 .36145 .5993 .36436 .59053 .36075 .59115 Mtetra
.817 .672 .703 r
.36075 .59115 .36436 .59053 .36728 .58112 .36367 .58173 Mtetra
.816 .669 .7 r
.36367 .58173 .36728 .58112 .3702 .5713 .3666 .57191 Mtetra
.816 .667 .698 r
.3666 .57191 .3702 .5713 .37313 .56134 .36953 .56193 Mtetra
.816 .668 .699 r
.36953 .56193 .37313 .56134 .37605 .55146 .37245 .55205 Mtetra
.816 .671 .702 r
.37245 .55205 .37605 .55146 .37895 .54193 .37537 .54252 Mtetra
.817 .676 .707 r
.37537 .54252 .37895 .54193 .38185 .53299 .37826 .53356 Mtetra
.818 .684 .716 r
.37826 .53356 .38185 .53299 .38472 .52485 .38114 .52541 Mtetra
.819 .697 .73 r
.38114 .52541 .38472 .52485 .38758 .5177 .384 .51826 Mtetra
.82 .717 .751 r
.384 .51826 .38758 .5177 .39041 .51172 .38684 .51227 Mtetra
.82 .749 .785 r
.38684 .51227 .39041 .51172 .39322 .50702 .38965 .50757 Mtetra
.812 .806 .845 r
.38965 .50757 .39322 .50702 .396 .50369 .39243 .50423 Mtetra
.745 .9 .947 r
.39243 .50423 .396 .50369 .39877 .50175 .3952 .50229 Mtetra
.212 .737 .782 r
.3952 .50229 .39877 .50175 .40152 .50119 .39795 .50173 Mtetra
.492 0 0 r
.39795 .50173 .40152 .50119 .40425 .50193 .40067 .50248 Mtetra
.66 .25 .255 r
.40067 .50248 .40425 .50193 .40697 .50387 .40339 .50442 Mtetra
.711 .349 .36 r
.40339 .50442 .40697 .50387 .40968 .50683 .4061 .50738 Mtetra
.732 .395 .408 r
.4061 .50738 .40968 .50683 .41238 .51059 .4088 .51115 Mtetra
.742 .417 .432 r
.4088 .51115 .41238 .51059 .41509 .51491 .41151 .51547 Mtetra
.746 .426 .442 r
.41151 .51547 .41509 .51491 .41781 .51949 .41422 .52006 Mtetra
.745 .425 .44 r
.41422 .52006 .41781 .51949 .42054 .52406 .41694 .52463 Mtetra
.74 .412 .427 r
.41694 .52463 .42054 .52406 .42328 .52828 .41968 .52886 Mtetra
.727 .384 .397 r
.41968 .52886 .42328 .52828 .42603 .53188 .42243 .53246 Mtetra
.699 .325 .335 r
.42243 .53246 .42603 .53188 .42881 .53459 .42521 .53517 Mtetra
.624 .187 .19 r
.42521 .53517 .42881 .53459 .43161 .53616 .428 .53674 Mtetra
.325 0 0 r
.428 .53674 .43161 .53616 .43443 .53642 .43082 .53701 Mtetra
.536 .909 .953 r
.43082 .53701 .43443 .53642 .43727 .53527 .43366 .53586 Mtetra
.792 .864 .903 r
.43366 .53586 .43727 .53527 .44012 .53268 .43652 .53326 Mtetra
.821 .785 .819 r
.43652 .53326 .44012 .53268 .443 .52869 .43939 .52927 Mtetra
.824 .742 .774 r
.43939 .52927 .443 .52869 .44588 .52344 .44228 .52402 Mtetra
.824 .718 .748 r
.44228 .52402 .44588 .52344 .44878 .51716 .44518 .51773 Mtetra
.823 .705 .734 r
.44518 .51773 .44878 .51716 .45168 .51012 .44808 .51068 Mtetra
.823 .699 .728 r
.44808 .51068 .45168 .51012 .45458 .50268 .45099 .50323 Mtetra
.823 .698 .727 r
.45099 .50323 .45458 .50268 .45748 .4952 .45389 .49575 Mtetra
.823 .703 .733 r
.45389 .49575 .45748 .4952 .46038 .48807 .45679 .48861 Mtetra
.824 .715 .745 r
.45679 .48861 .46038 .48807 .46327 .48166 .45969 .48219 Mtetra
.824 .738 .77 r
.45969 .48219 .46327 .48166 .46615 .47628 .46257 .47681 Mtetra
.82 .779 .814 r
.46257 .47681 .46615 .47628 .46903 .47217 .46546 .4727 Mtetra
.794 .855 .896 r
.46546 .4727 .46903 .47217 .47191 .46948 .46833 .47001 Mtetra
.581 .918 .969 r
.46833 .47001 .47191 .46948 .47479 .46822 .47121 .46875 Mtetra
.205 0 0 r
.47121 .46875 .47479 .46822 .47766 .46828 .47408 .4688 Mtetra
.557 .073 .064 r
.47408 .4688 .47766 .46828 .48054 .4694 .47696 .46992 Mtetra
.642 .211 .209 r
.47696 .46992 .48054 .4694 .48342 .4712 .47984 .47173 Mtetra
.659 .241 .241 r
.47984 .47173 .48342 .4712 .48632 .47322 .48273 .47375 Mtetra
.633 .195 .192 r
.48273 .47375 .48632 .47322 .48922 .47493 .48563 .47547 Mtetra
.513 .01 0 r
.48563 .47547 .48922 .47493 .49213 .47584 .48854 .47637 Mtetra
0 0 0 r
.48854 .47637 .49213 .47584 .49504 .47552 .49145 .47606 Mtetra
.707 .92 .966 r
.49145 .47606 .49504 .47552 .49796 .47375 .49437 .47428 Mtetra
.81 .827 .863 r
.49437 .47428 .49796 .47375 .50088 .47051 .4973 .47104 Mtetra
.823 .773 .805 r
.4973 .47104 .50088 .47051 .50381 .46611 .50022 .46664 Mtetra
.825 .753 .784 r
.50022 .46664 .50381 .46611 .50673 .46111 .50315 .46163 Mtetra
.825 .758 .789 r
.50315 .46163 .50673 .46111 .50966 .45627 .50608 .45679 Mtetra
.82 .795 .828 r
.50608 .45679 .50966 .45627 .51259 .45239 .50901 .4529 Mtetra
.775 .882 .924 r
.50901 .4529 .51259 .45239 .51553 .45 .51195 .45052 Mtetra
.429 .865 .917 r
.51195 .45052 .51553 .45 .51848 .44906 .5149 .44957 Mtetra
.13 .677 .725 r
.5149 .44957 .51848 .44906 .52143 .44859 .51785 .4491 Mtetra
.691 .922 .97 r
.51785 .4491 .52143 .44859 .52438 .44688 .5208 .44739 Mtetra
.803 .844 .882 r
.5208 .44739 .52438 .44688 .52734 .44391 .52376 .44441 Mtetra
.691 .922 .97 r
.52376 .44441 .52734 .44391 .5303 .44219 .52672 .4427 Mtetra
.135 .681 .729 r
.52672 .4427 .5303 .44219 .53327 .44172 .52969 .44222 Mtetra
.431 .866 .918 r
.52969 .44222 .53327 .44172 .53625 .44076 .53267 .44127 Mtetra
.774 .883 .924 r
.53267 .44127 .53625 .44076 .53922 .43835 .53564 .43886 Mtetra
.821 .796 .829 r
.53564 .43886 .53922 .43835 .54219 .43444 .53861 .43494 Mtetra
.826 .76 .79 r
.53861 .43494 .54219 .43444 .54514 .42955 .54157 .43005 Mtetra
.826 .755 .784 r
.54157 .43005 .54514 .42955 .5481 .4245 .54453 .42499 Mtetra
.824 .775 .806 r
.54453 .42499 .5481 .4245 .55106 .42005 .54749 .42054 Mtetra
.811 .828 .864 r
.54749 .42054 .55106 .42005 .55404 .41676 .55047 .41724 Mtetra
.71 .917 .965 r
.55047 .41724 .55404 .41676 .55704 .41492 .55346 .4154 Mtetra
0 0 0 r
.55346 .4154 .55704 .41492 .56005 .41454 .55648 .41502 Mtetra
.486 0 0 r
.55648 .41502 .56005 .41454 .56309 .41538 .55952 .41587 Mtetra
.619 .166 .153 r
.55952 .41587 .56309 .41538 .56615 .41705 .56257 .41754 Mtetra
.648 .215 .206 r
.56257 .41754 .56615 .41705 .56921 .41903 .56564 .41952 Mtetra
.629 .183 .171 r
.56564 .41952 .56921 .41903 .57229 .42081 .56871 .4213 Mtetra
.535 .036 .016 r
.56871 .4213 .57229 .42081 .57536 .42189 .57178 .42239 Mtetra
.166 0 0 r
.57178 .42239 .57536 .42189 .57842 .4219 .57484 .4224 Mtetra
.582 .918 .969 r
.57484 .4224 .57842 .4219 .58147 .42056 .57789 .42106 Mtetra
.794 .863 .9 r
.57789 .42106 .58147 .42056 .5845 .41776 .58092 .41825 Mtetra
.824 .788 .818 r
.58092 .41825 .5845 .41776 .58752 .4135 .58394 .41399 Mtetra
.829 .746 .772 r
.58394 .41399 .58752 .4135 .59051 .40794 .58693 .40842 Mtetra
.83 .723 .747 r
.58693 .40842 .59051 .40794 .59348 .40132 .58991 .4018 Mtetra
.829 .71 .733 r
.58991 .4018 .59348 .40132 .59645 .39399 .59288 .39445 Mtetra
.829 .705 .727 r
.59288 .39445 .59645 .39399 .5994 .3863 .59583 .38676 Mtetra
.829 .706 .728 r
.59583 .38676 .5994 .3863 .60235 .37865 .59879 .37911 Mtetra
.829 .712 .735 r
.59879 .37911 .60235 .37865 .60531 .37143 .60175 .37188 Mtetra
.83 .725 .75 r
.60175 .37188 .60531 .37143 .60828 .36496 .60473 .3654 Mtetra
.829 .749 .776 r
.60473 .3654 .60828 .36496 .61128 .35954 .60772 .35997 Mtetra
.823 .79 .822 r
.60772 .35997 .61128 .35954 .6143 .35536 .61075 .3558 Mtetra
.792 .861 .901 r
.61075 .3558 .6143 .35536 .61735 .35258 .6138 .35301 Mtetra
.586 .915 .973 r
.6138 .35301 .61735 .35258 .62044 .35123 .61689 .35166 Mtetra
.179 0 0 r
.61689 .35166 .62044 .35123 .62357 .3513 .62002 .35173 Mtetra
.576 .091 .065 r
.62002 .35173 .62357 .3513 .62673 .35269 .62318 .35312 Mtetra
.681 .267 .253 r
.62318 .35312 .62673 .35269 .62993 .35523 .62638 .35566 Mtetra
.719 .342 .333 r
.62638 .35566 .62993 .35523 .63317 .35869 .62961 .35913 Mtetra
.736 .377 .371 r
.62961 .35913 .63317 .35869 .63643 .36282 .63287 .36326 Mtetra
.743 .392 .388 r
.63287 .36326 .63643 .36282 .63971 .36732 .63614 .36777 Mtetra
.744 .394 .389 r
.63614 .36777 .63971 .36732 .64301 .37188 .63944 .37233 Mtetra
.739 .383 .378 r
.63944 .37233 .64301 .37188 .64631 .37619 .64273 .37665 Mtetra
.726 .356 .348 r
.64273 .37665 .64631 .37619 .6496 .37996 .64603 .38043 Mtetra
.698 .3 .289 r
.64603 .38043 .6496 .37996 .65289 .38292 .64931 .38338 Mtetra
.631 .18 .161 r
.64931 .38338 .65289 .38292 .65616 .38482 .65258 .38529 Mtetra
.418 0 0 r
.65258 .38529 .65616 .38482 .6594 .38548 .65582 .38595 Mtetra
.27 .776 .831 r
.65582 .38595 .6594 .38548 .66261 .38476 .65902 .38523 Mtetra
.74 .91 .952 r
.65902 .38523 .66261 .38476 .66577 .38259 .66219 .38306 Mtetra
.818 .826 .855 r
.66219 .38306 .66577 .38259 .6689 .37894 .66532 .3794 Mtetra
.832 .769 .792 r
.66532 .3794 .6689 .37894 .67199 .37384 .66841 .3743 Mtetra
.834 .734 .755 r
.66841 .3743 .67199 .37384 .67503 .36739 .67146 .36784 Mtetra
.834 .713 .731 r
.67146 .36784 .67503 .36739 .67804 .35973 .67447 .36017 Mtetra
.833 .699 .715 r
.67447 .36017 .67804 .35973 .68101 .35103 .67744 .35146 Mtetra
.832 .69 .705 r
.67744 .35146 .68101 .35103 .68395 .34151 .68038 .34194 Mtetra
.832 .684 .699 r
.68038 .34194 .68395 .34151 .68686 .33141 .6833 .33182 Mtetra
.831 .681 .696 r
.6833 .33182 .68686 .33141 .68976 .32098 .68621 .32139 Mtetra
.831 .68 .695 r
.68621 .32139 .68976 .32098 .69265 .31048 .6891 .31088 Mtetra
.832 .682 .697 r
.6891 .31088 .69265 .31048 .69554 .30017 .692 .30056 Mtetra
.832 .685 .701 r
.692 .30056 .69554 .30017 .69845 .2903 .69491 .29068 Mtetra
.832 .692 .708 r
.69491 .29068 .69845 .2903 .70137 .2811 .69784 .28146 Mtetra
.833 .702 .719 r
.69784 .28146 .70137 .2811 .70432 .27276 .7008 .27312 Mtetra
.833 .717 .736 r
.7008 .27312 .70432 .27276 .70732 .26548 .7038 .26583 Mtetra
.833 .74 .762 r
.7038 .26583 .70732 .26548 .71035 .25939 .70684 .25973 Mtetra
.828 .775 .802 r
.70684 .25973 .71035 .25939 .71344 .25461 .70993 .25495 Mtetra
.809 .833 .869 r
.70993 .25495 .71344 .25461 .71659 .25121 .71307 .25155 Mtetra
.713 .91 .964 r
.71307 .25155 .71659 .25121 .7198 .24923 .71628 .24957 Mtetra
.207 .734 .809 r
.71628 .24957 .7198 .24923 .72307 .24868 .71955 .24902 Mtetra
.446 0 0 r
.71955 .24902 .72307 .24868 .7264 .24953 .72289 .24986 Mtetra
.648 .196 .164 r
.72289 .24986 .7264 .24953 .72981 .25169 .72629 .25203 Mtetra
.714 .317 .295 r
.72629 .25203 .72981 .25169 .73327 .25508 .72975 .25542 Mtetra
.743 .377 .36 r
.72975 .25542 .73327 .25508 .73679 .25956 .73327 .25991 Mtetra
.758 .411 .397 r
.73327 .25991 .73679 .25956 .74037 .26498 .73684 .26534 Mtetra
.766 .432 .419 r
.73684 .26534 .74037 .26498 .744 .27117 .74047 .27153 Mtetra
.771 .444 .432 r
.74047 .27153 .744 .27117 .74767 .27791 .74413 .27828 Mtetra
.774 .45 .439 r
.74413 .27828 .74767 .27791 .75137 .28501 .74783 .28539 Mtetra
.774 .452 .441 r
.74783 .28539 .75137 .28501 .75509 .29224 .75154 .29263 Mtetra
.774 .45 .439 r
.75154 .29263 .75509 .29224 .75883 .29938 .75527 .29978 Mtetra
.755 .483 .521 r
.30966 .57818 .31326 .57699 .31566 .58405 .31205 .58524 Mtetra
.756 .485 .522 r
.31205 .58524 .31566 .58405 .31806 .59125 .31444 .59245 Mtetra
.755 .483 .521 r
.31444 .59245 .31806 .59125 .32048 .59838 .31685 .5996 Mtetra
.753 .479 .517 r
.31685 .5996 .32048 .59838 .32291 .60524 .31928 .60647 Mtetra
.75 .471 .509 r
.31928 .60647 .32291 .60524 .32537 .61161 .32174 .61284 Mtetra
.743 .457 .497 r
.32174 .61284 .32537 .61161 .32786 .61729 .32422 .61853 Mtetra
.733 .436 .477 r
.32422 .61853 .32786 .61729 .33039 .62208 .32675 .62333 Mtetra
.715 .4 .443 r
.32675 .62333 .33039 .62208 .33296 .62582 .32931 .62708 Mtetra
.68 .334 .381 r
.32931 .62708 .33296 .62582 .33556 .62837 .33191 .62963 Mtetra
.593 .187 .241 r
.33191 .62963 .33556 .62837 .33821 .62961 .33456 .63087 Mtetra
.266 0 0 r
.33456 .63087 .33821 .62961 .3409 .62946 .33725 .63073 Mtetra
.611 .953 .909 r
.33725 .63073 .3409 .62946 .34364 .62789 .33998 .62915 Mtetra
.832 .889 .883 r
.33998 .62915 .34364 .62789 .34641 .62488 .34276 .62614 Mtetra
.845 .8 .807 r
.34276 .62614 .34641 .62488 .34922 .62048 .34557 .62174 Mtetra
.841 .751 .764 r
.34557 .62174 .34922 .62048 .35206 .61477 .34842 .61602 Mtetra
.836 .723 .739 r
.34842 .61602 .35206 .61477 .35494 .60787 .35129 .60912 Mtetra
.833 .705 .722 r
.35129 .60912 .35494 .60787 .35783 .59994 .35419 .60117 Mtetra
.83 .693 .712 r
.35419 .60117 .35783 .59994 .36075 .59115 .35711 .59238 Mtetra
.829 .686 .705 r
.35711 .59238 .36075 .59115 .36367 .58173 .36004 .58295 Mtetra
.828 .682 .702 r
.36004 .58295 .36367 .58173 .3666 .57191 .36298 .57311 Mtetra
.827 .68 .7 r
.36298 .57311 .3666 .57191 .36953 .56193 .36591 .56313 Mtetra
.827 .681 .701 r
.36591 .56313 .36953 .56193 .37245 .55205 .36884 .55323 Mtetra
.828 .684 .704 r
.36884 .55323 .37245 .55205 .37537 .54252 .37176 .54369 Mtetra
.83 .69 .71 r
.37176 .54369 .37537 .54252 .37826 .53356 .37466 .53472 Mtetra
.832 .7 .719 r
.37466 .53472 .37826 .53356 .38114 .52541 .37755 .52656 Mtetra
.835 .716 .733 r
.37755 .52656 .38114 .52541 .384 .51826 .38041 .51941 Mtetra
.839 .741 .756 r
.38041 .51941 .384 .51826 .38684 .51227 .38325 .51341 Mtetra
.843 .783 .794 r
.38325 .51341 .38684 .51227 .38965 .50757 .38606 .5087 Mtetra
.837 .857 .86 r
.38606 .5087 .38965 .50757 .39243 .50423 .38885 .50536 Mtetra
.729 .961 .942 r
.38885 .50536 .39243 .50423 .3952 .50229 .39161 .50342 Mtetra
.004 0 0 r
.39161 .50342 .3952 .50229 .39795 .50173 .39436 .50286 Mtetra
.519 .065 .113 r
.39436 .50286 .39795 .50173 .40067 .50248 .39709 .50361 Mtetra
.649 .269 .311 r
.39709 .50361 .40067 .50248 .40339 .50442 .3998 .50555 Mtetra
.696 .353 .391 r
.3998 .50555 .40339 .50442 .4061 .50738 .40251 .50852 Mtetra
.717 .394 .43 r
.40251 .50852 .4061 .50738 .4088 .51115 .40521 .51229 Mtetra
.727 .414 .449 r
.40521 .51229 .4088 .51115 .41151 .51547 .40791 .51662 Mtetra
.732 .423 .457 r
.40791 .51662 .41151 .51547 .41422 .52006 .41062 .52122 Mtetra
.731 .421 .456 r
.41062 .52122 .41422 .52006 .41694 .52463 .41334 .52579 Mtetra
.725 .41 .445 r
.41334 .52579 .41694 .52463 .41968 .52886 .41607 .53003 Mtetra
.712 .384 .42 r
.41607 .53003 .41968 .52886 .42243 .53246 .41882 .53364 Mtetra
.684 .332 .371 r
.41882 .53364 .42243 .53246 .42521 .53517 .42159 .53635 Mtetra
.619 .219 .263 r
.42159 .53635 .42521 .53517 .428 .53674 .42439 .53793 Mtetra
.405 0 0 r
.42439 .53793 .428 .53674 .43082 .53701 .4272 .5382 Mtetra
.368 .833 .781 r
.4272 .5382 .43082 .53701 .43366 .53586 .43004 .53705 Mtetra
.806 .93 .916 r
.43004 .53705 .43366 .53586 .43652 .53326 .4329 .53445 Mtetra
.846 .83 .832 r
.4329 .53445 .43652 .53326 .43939 .52927 .43578 .53045 Mtetra
.846 .774 .781 r
.43578 .53045 .43939 .52927 .44228 .52402 .43867 .52519 Mtetra
.843 .743 .754 r
.43867 .52519 .44228 .52402 .44518 .51773 .44157 .5189 Mtetra
.84 .726 .738 r
.44157 .5189 .44518 .51773 .44808 .51068 .44447 .51185 Mtetra
.839 .719 .731 r
.44447 .51185 .44808 .51068 .45099 .50323 .44738 .50439 Mtetra
.839 .718 .731 r
.44738 .50439 .45099 .50323 .45389 .49575 .45029 .49689 Mtetra
.84 .724 .737 r
.45029 .49689 .45389 .49575 .45679 .48861 .4532 .48975 Mtetra
.842 .74 .751 r
.4532 .48975 .45679 .48861 .45969 .48219 .45609 .48333 Mtetra
.845 .769 .777 r
.45609 .48333 .45969 .48219 .46257 .47681 .45899 .47794 Mtetra
.846 .823 .826 r
.45899 .47794 .46257 .47681 .46546 .4727 .46187 .47382 Mtetra
.811 .92 .91 r
.46187 .47382 .46546 .4727 .46833 .47001 .46475 .47113 Mtetra
.442 .879 .838 r
.46475 .47113 .46833 .47001 .47121 .46875 .46762 .46987 Mtetra
.325 0 0 r
.46762 .46987 .47121 .46875 .47408 .4688 .4705 .46992 Mtetra
.567 .132 .174 r
.4705 .46992 .47408 .4688 .47696 .46992 .47337 .47105 Mtetra
.634 .238 .276 r
.47337 .47105 .47696 .46992 .47984 .47173 .47625 .47286 Mtetra
.648 .262 .299 r
.47625 .47286 .47984 .47173 .48273 .47375 .47914 .47488 Mtetra
.627 .226 .264 r
.47914 .47488 .48273 .47375 .48563 .47547 .48204 .4766 Mtetra
.535 .085 .128 r
.48204 .4766 .48563 .47547 .48854 .47637 .48494 .47751 Mtetra
.162 0 0 r
.48494 .47751 .48854 .47637 .49145 .47606 .48786 .47719 Mtetra
.655 .961 .93 r
.48786 .47719 .49145 .47606 .49437 .47428 .49078 .47542 Mtetra
.834 .885 .879 r
.49078 .47542 .49437 .47428 .4973 .47104 .4937 .47218 Mtetra
.848 .814 .816 r
.4937 .47218 .4973 .47104 .50022 .46664 .49663 .46777 Mtetra
.849 .788 .793 r
.49663 .46777 .50022 .46664 .50315 .46163 .49956 .46275 Mtetra
.849 .795 .799 r
.49956 .46275 .50315 .46163 .50608 .45679 .50249 .45791 Mtetra
.845 .843 .841 r
.50249 .45791 .50608 .45679 .50901 .4529 .50542 .45402 Mtetra
.778 .948 .931 r
.50542 .45402 .50901 .4529 .51195 .45052 .50836 .45163 Mtetra
.229 .737 .69 r
.50836 .45163 .51195 .45052 .5149 .44957 .51131 .45068 Mtetra
.075 0 0 r
.51131 .45068 .5149 .44957 .51785 .4491 .51426 .45022 Mtetra
.628 .955 .924 r
.51426 .45022 .51785 .4491 .5208 .44739 .51722 .44851 Mtetra
.823 .906 .897 r
.51722 .44851 .5208 .44739 .52376 .44441 .52017 .44552 Mtetra
.629 .955 .924 r
.52017 .44552 .52376 .44441 .52672 .4427 .52314 .44381 Mtetra
.071 0 0 r
.52314 .44381 .52672 .4427 .52969 .44222 .52611 .44333 Mtetra
.231 .739 .693 r
.52611 .44333 .52969 .44222 .53267 .44127 .52909 .44238 Mtetra
.777 .949 .931 r
.52909 .44238 .53267 .44127 .53564 .43886 .53206 .43997 Mtetra
.846 .845 .842 r
.53206 .43997 .53564 .43886 .53861 .43494 .53503 .43604 Mtetra
.85 .797 .799 r
.53503 .43604 .53861 .43494 .54157 .43005 .53799 .43115 Mtetra
.85 .791 .793 r
.53799 .43115 .54157 .43005 .54453 .42499 .54095 .42609 Mtetra
.849 .817 .817 r
.54095 .42609 .54453 .42499 .54749 .42054 .54392 .42163 Mtetra
.834 .886 .879 r
.54392 .42163 .54749 .42054 .55047 .41724 .5469 .41833 Mtetra
.664 .961 .934 r
.5469 .41833 .55047 .41724 .55346 .4154 .54989 .41649 Mtetra
.12 0 0 r
.54989 .41649 .55346 .4154 .55648 .41502 .55291 .41611 Mtetra
.517 .052 .089 r
.55291 .41611 .55648 .41502 .55952 .41587 .55594 .41696 Mtetra
.616 .202 .235 r
.55594 .41696 .55952 .41587 .56257 .41754 .55899 .41863 Mtetra
.64 .241 .272 r
.55899 .41863 .56257 .41754 .56564 .41952 .56206 .42062 Mtetra
.625 .216 .248 r
.56206 .42062 .56564 .41952 .56871 .4213 .56513 .4224 Mtetra
.552 .104 .14 r
.56513 .4224 .56871 .4213 .57178 .42239 .5682 .42349 Mtetra
.299 0 0 r
.5682 .42349 .57178 .42239 .57484 .4224 .57126 .4235 Mtetra
.443 .879 .838 r
.57126 .4235 .57484 .4224 .57789 .42106 .57431 .42216 Mtetra
.809 .928 .913 r
.57431 .42216 .57789 .42106 .58092 .41825 .57734 .41935 Mtetra
.85 .834 .83 r
.57734 .41935 .58092 .41825 .58394 .41399 .58036 .41509 Mtetra
.852 .779 .78 r
.58036 .41509 .58394 .41399 .58693 .40842 .58336 .40951 Mtetra
.849 .749 .752 r
.58336 .40951 .58693 .40842 .58991 .4018 .58634 .40288 Mtetra
.847 .733 .737 r
.58634 .40288 .58991 .4018 .59288 .39445 .58931 .39553 Mtetra
.846 .726 .731 r
.58931 .39553 .59288 .39445 .59583 .38676 .59227 .38783 Mtetra
.846 .727 .732 r
.59227 .38783 .59583 .38676 .59879 .37911 .59523 .38017 Mtetra
.847 .735 .739 r
.59523 .38017 .59879 .37911 .60175 .37188 .5982 .37293 Mtetra
.85 .752 .755 r
.5982 .37293 .60175 .37188 .60473 .3654 .60118 .36645 Mtetra
.852 .783 .784 r
.60118 .36645 .60473 .3654 .60772 .35997 .60418 .36101 Mtetra
.849 .837 .834 r
.60418 .36101 .60772 .35997 .61075 .3558 .6072 .35683 Mtetra
.806 .927 .915 r
.6072 .35683 .61075 .3558 .6138 .35301 .61026 .35404 Mtetra
.455 .886 .854 r
.61026 .35404 .6138 .35301 .61689 .35166 .61335 .35269 Mtetra
.309 0 0 r
.61335 .35269 .61689 .35166 .62002 .35173 .61647 .35276 Mtetra
.584 .145 .172 r
.61647 .35276 .62002 .35173 .62318 .35312 .61963 .35415 Mtetra
.669 .284 .307 r
.61963 .35415 .62318 .35312 .62638 .35566 .62283 .3567 Mtetra
.704 .347 .368 r
.62283 .3567 .62638 .35566 .62961 .35913 .62606 .36017 Mtetra
.721 .378 .398 r
.62606 .36017 .62961 .35913 .63287 .36326 .62931 .36431 Mtetra
.728 .392 .411 r
.62931 .36431 .63287 .36326 .63614 .36777 .63259 .36882 Mtetra
.729 .394 .413 r
.63259 .36882 .63614 .36777 .63944 .37233 .63588 .3734 Mtetra
.724 .384 .403 r
.63588 .3734 .63944 .37233 .64273 .37665 .63917 .37772 Mtetra
.711 .359 .38 r
.63917 .37772 .64273 .37665 .64603 .38043 .64246 .3815 Mtetra
.684 .311 .333 r
.64246 .3815 .64603 .38043 .64931 .38338 .64574 .38446 Mtetra
.627 .213 .24 r
.64574 .38446 .64931 .38338 .65258 .38529 .64901 .38637 Mtetra
.471 0 .018 r
.64901 .38637 .65258 .38529 .65582 .38595 .65225 .38704 Mtetra
0 0 0 r
.65225 .38704 .65582 .38595 .65902 .38523 .65545 .38632 Mtetra
.714 .966 .937 r
.65545 .38632 .65902 .38523 .66219 .38306 .65862 .38414 Mtetra
.843 .883 .869 r
.65862 .38414 .66219 .38306 .66532 .3794 .66175 .38048 Mtetra
.857 .808 .802 r
.66175 .38048 .66532 .3794 .66841 .3743 .66485 .37538 Mtetra
.855 .763 .76 r
.66485 .37538 .66841 .3743 .67146 .36784 .6679 .36891 Mtetra
.852 .736 .734 r
.6679 .36891 .67146 .36784 .67447 .36017 .67091 .36123 Mtetra
.849 .718 .718 r
.67091 .36123 .67447 .36017 .67744 .35146 .67389 .35252 Mtetra
.847 .707 .707 r
.67389 .35252 .67744 .35146 .68038 .34194 .67684 .34298 Mtetra
.846 .7 .701 r
.67684 .34298 .68038 .34194 .6833 .33182 .67976 .33285 Mtetra
.845 .696 .697 r
.67976 .33285 .6833 .33182 .68621 .32139 .68267 .3224 Mtetra
.845 .695 .696 r
.68267 .3224 .68621 .32139 .6891 .31088 .68557 .31188 Mtetra
.845 .697 .698 r
.68557 .31188 .6891 .31088 .692 .30056 .68848 .30155 Mtetra
.846 .702 .703 r
.68848 .30155 .692 .30056 .69491 .29068 .69139 .29166 Mtetra
.848 .71 .71 r
.69139 .29166 .69491 .29068 .69784 .28146 .69433 .28243 Mtetra
.85 .722 .722 r
.69433 .28243 .69784 .28146 .7008 .27312 .69729 .27408 Mtetra
.852 .741 .74 r
.69729 .27408 .7008 .27312 .7038 .26583 .70029 .26678 Mtetra
.854 .77 .768 r
.70029 .26678 .7038 .26583 .70684 .25973 .70333 .26068 Mtetra
.854 .817 .813 r
.70333 .26068 .70684 .25973 .70993 .25495 .70643 .25589 Mtetra
.832 .892 .884 r
.70643 .25589 .70993 .25495 .71307 .25155 .70958 .25248 Mtetra
.674 .96 .942 r
.70958 .25248 .71307 .25155 .71628 .24957 .71278 .25051 Mtetra
.002 0 0 r
.71278 .25051 .71628 .24957 .71955 .24902 .71606 .24996 Mtetra
.492 .002 .02 r
.71606 .24996 .71955 .24902 .72289 .24986 .71939 .2508 Mtetra
.642 .226 .239 r
.71939 .2508 .72289 .24986 .72629 .25203 .72279 .25297 Mtetra
.7 .326 .337 r
.72279 .25297 .72629 .25203 .72975 .25542 .72625 .25637 Mtetra
.727 .379 .388 r
.72625 .25637 .72975 .25542 .73327 .25991 .72976 .26087 Mtetra
.743 .41 .418 r
.72976 .26087 .73327 .25991 .73684 .26534 .73334 .2663 Mtetra
.752 .429 .436 r
.73334 .2663 .73684 .26534 .74047 .27153 .73695 .2725 Mtetra
.758 .44 .448 r
.73695 .2725 .74047 .27153 .74413 .27828 .74061 .27926 Mtetra
.76 .446 .453 r
.74061 .27926 .74413 .27828 .74783 .28539 .7443 .28638 Mtetra
.761 .448 .455 r
.7443 .28638 .74783 .28539 .75154 .29263 .74802 .29363 Mtetra
.76 .446 .453 r
.74802 .29363 .75154 .29263 .75527 .29978 .75174 .30079 Mtetra
.758 .484 .519 r
.30605 .57921 .30966 .57818 .31205 .58524 .30843 .58628 Mtetra
.759 .486 .52 r
.30843 .58628 .31205 .58524 .31444 .59245 .31082 .5935 Mtetra
.758 .485 .519 r
.31082 .5935 .31444 .59245 .31685 .5996 .31322 .60065 Mtetra
.756 .48 .515 r
.31322 .60065 .31685 .5996 .31928 .60647 .31565 .60753 Mtetra
.753 .472 .507 r
.31565 .60753 .31928 .60647 .32174 .61284 .3181 .61392 Mtetra
.747 .459 .494 r
.3181 .61392 .32174 .61284 .32422 .61853 .32058 .61961 Mtetra
.737 .437 .473 r
.32058 .61961 .32422 .61853 .32675 .62333 .3231 .62441 Mtetra
.719 .401 .438 r
.3231 .62441 .32675 .62333 .32931 .62708 .32566 .62817 Mtetra
.684 .332 .372 r
.32566 .62817 .32931 .62708 .33191 .62963 .32826 .63072 Mtetra
.594 .177 .221 r
.32826 .63072 .33191 .62963 .33456 .63087 .33091 .63197 Mtetra
.234 0 0 r
.33091 .63197 .33456 .63087 .33725 .63073 .3336 .63182 Mtetra
.64 .955 .936 r
.3336 .63182 .33725 .63073 .33998 .62915 .33633 .63025 Mtetra
.826 .872 .879 r
.33633 .63025 .33998 .62915 .34276 .62614 .3391 .62723 Mtetra
.838 .789 .805 r
.3391 .62723 .34276 .62614 .34557 .62174 .34192 .62283 Mtetra
.835 .744 .763 r
.34192 .62283 .34557 .62174 .34842 .61602 .34477 .61711 Mtetra
.832 .717 .738 r
.34477 .61711 .34842 .61602 .35129 .60912 .34765 .61019 Mtetra
.829 .7 .722 r
.34765 .61019 .35129 .60912 .35419 .60117 .35055 .60224 Mtetra
.827 .689 .711 r
.35055 .60224 .35419 .60117 .35711 .59238 .35347 .59344 Mtetra
.825 .682 .705 r
.35347 .59344 .35711 .59238 .36004 .58295 .35641 .584 Mtetra
.824 .678 .701 r
.35641 .584 .36004 .58295 .36298 .57311 .35935 .57415 Mtetra
.824 .676 .7 r
.35935 .57415 .36298 .57311 .36591 .56313 .36229 .56416 Mtetra
.824 .677 .7 r
.36229 .56416 .36591 .56313 .36884 .55323 .36523 .55425 Mtetra
.825 .68 .703 r
.36523 .55425 .36884 .55323 .37176 .54369 .36815 .54469 Mtetra
.826 .686 .709 r
.36815 .54469 .37176 .54369 .37466 .53472 .37106 .53572 Mtetra
.828 .696 .718 r
.37106 .53572 .37466 .53472 .37755 .52656 .37395 .52756 Mtetra
.83 .711 .732 r
.37395 .52756 .37755 .52656 .38041 .51941 .37681 .52039 Mtetra
.834 .734 .755 r
.37681 .52039 .38041 .51941 .38325 .51341 .37965 .51439 Mtetra
.836 .773 .792 r
.37965 .51439 .38325 .51341 .38606 .5087 .38247 .50968 Mtetra
.83 .842 .857 r
.38247 .50968 .38606 .5087 .38885 .50536 .38526 .50633 Mtetra
.738 .947 .949 r
.38526 .50633 .38885 .50536 .39161 .50342 .38802 .50439 Mtetra
0 0 0 r
.38802 .50439 .39161 .50342 .39436 .50286 .39077 .50383 Mtetra
.514 .045 .08 r
.39077 .50383 .39436 .50286 .39709 .50361 .39349 .50458 Mtetra
.652 .264 .297 r
.39349 .50458 .39709 .50361 .3998 .50555 .39621 .50653 Mtetra
.7 .352 .383 r
.39621 .50653 .3998 .50555 .40251 .50852 .39891 .5095 Mtetra
.721 .394 .424 r
.39891 .5095 .40251 .50852 .40521 .51229 .40161 .51328 Mtetra
.731 .415 .445 r
.40161 .51328 .40521 .51229 .40791 .51662 .4043 .51761 Mtetra
.735 .424 .453 r
.4043 .51761 .40791 .51662 .41062 .52122 .40701 .52222 Mtetra
.735 .422 .452 r
.40701 .52222 .41062 .52122 .41334 .52579 .40972 .5268 Mtetra
.729 .41 .44 r
.40972 .5268 .41334 .52579 .41607 .53003 .41245 .53104 Mtetra
.716 .384 .414 r
.41245 .53104 .41607 .53003 .41882 .53364 .4152 .53466 Mtetra
.688 .33 .362 r
.4152 .53466 .41882 .53364 .42159 .53635 .41797 .53737 Mtetra
.62 .211 .246 r
.41797 .53737 .42159 .53635 .42439 .53793 .42076 .53895 Mtetra
.388 0 0 r
.42076 .53895 .42439 .53793 .4272 .5382 .42358 .53922 Mtetra
.423 .869 .844 r
.42358 .53922 .4272 .5382 .43004 .53705 .42642 .53807 Mtetra
.803 .912 .914 r
.42642 .53807 .43004 .53705 .4329 .53445 .42928 .53547 Mtetra
.839 .817 .828 r
.42928 .53547 .4329 .53445 .43578 .53045 .43215 .53147 Mtetra
.84 .765 .779 r
.43215 .53147 .43578 .53045 .43867 .52519 .43505 .5262 Mtetra
.837 .736 .752 r
.43505 .5262 .43867 .52519 .44157 .5189 .43795 .5199 Mtetra
.835 .72 .737 r
.43795 .5199 .44157 .5189 .44447 .51185 .44086 .51284 Mtetra
.834 .713 .73 r
.44086 .51284 .44447 .51185 .44738 .50439 .44378 .50538 Mtetra
.834 .712 .73 r
.44378 .50538 .44738 .50439 .45029 .49689 .44669 .49788 Mtetra
.835 .718 .735 r
.44669 .49788 .45029 .49689 .4532 .48975 .4496 .49073 Mtetra
.837 .733 .749 r
.4496 .49073 .4532 .48975 .45609 .48333 .4525 .48429 Mtetra
.839 .76 .775 r
.4525 .48429 .45609 .48333 .45899 .47794 .45539 .4789 Mtetra
.838 .81 .823 r
.45539 .4789 .45899 .47794 .46187 .47382 .45828 .47478 Mtetra
.807 .902 .908 r
.45828 .47478 .46187 .47382 .46475 .47113 .46115 .47208 Mtetra
.491 .903 .889 r
.46115 .47208 .46475 .47113 .46762 .46987 .46403 .47082 Mtetra
.299 0 0 r
.46403 .47082 .46762 .46987 .4705 .46992 .4669 .47088 Mtetra
.566 .118 .147 r
.4669 .47088 .4705 .46992 .47337 .47105 .46978 .47201 Mtetra
.636 .232 .26 r
.46978 .47201 .47337 .47105 .47625 .47286 .47265 .47382 Mtetra
.651 .257 .285 r
.47265 .47382 .47625 .47286 .47914 .47488 .47554 .47585 Mtetra
.629 .218 .246 r
.47554 .47585 .47914 .47488 .48204 .4766 .47843 .47757 Mtetra
.531 .067 .097 r
.47843 .47757 .48204 .4766 .48494 .47751 .48134 .47848 Mtetra
.118 0 0 r
.48134 .47848 .48494 .47751 .48786 .47719 .48425 .47817 Mtetra
.677 .956 .949 r
.48425 .47817 .48786 .47719 .49078 .47542 .48717 .47639 Mtetra
.828 .868 .875 r
.48717 .47639 .49078 .47542 .4937 .47218 .4901 .47315 Mtetra
.841 .803 .813 r
.4901 .47315 .4937 .47218 .49663 .46777 .49303 .46873 Mtetra
.842 .778 .79 r
.49303 .46873 .49663 .46777 .49956 .46275 .49596 .46371 Mtetra
.842 .784 .796 r
.49596 .46371 .49956 .46275 .50249 .45791 .4989 .45886 Mtetra
.838 .829 .838 r
.4989 .45886 .50249 .45791 .50542 .45402 .50183 .45497 Mtetra
.78 .931 .932 r
.50183 .45497 .50542 .45402 .50836 .45163 .50477 .45258 Mtetra
.29 .786 .766 r
.50477 .45258 .50836 .45163 .51131 .45068 .50772 .45163 Mtetra
.023 0 0 r
.50772 .45163 .51131 .45068 .51426 .45022 .51067 .45117 Mtetra
.653 .953 .946 r
.51067 .45117 .51426 .45022 .51722 .44851 .51363 .44946 Mtetra
.819 .889 .894 r
.51363 .44946 .51722 .44851 .52017 .44552 .51658 .44647 Mtetra
.654 .953 .946 r
.51658 .44647 .52017 .44552 .52314 .44381 .51954 .44475 Mtetra
.019 0 0 r
.51954 .44475 .52314 .44381 .52611 .44333 .52252 .44428 Mtetra
.292 .788 .769 r
.52252 .44428 .52611 .44333 .52909 .44238 .5255 .44332 Mtetra
.779 .932 .932 r
.5255 .44332 .52909 .44238 .53206 .43997 .52847 .44091 Mtetra
.839 .831 .839 r
.52847 .44091 .53206 .43997 .53503 .43604 .53144 .43698 Mtetra
.843 .787 .797 r
.53144 .43698 .53503 .43604 .53799 .43115 .5344 .43208 Mtetra
.843 .78 .791 r
.5344 .43208 .53799 .43115 .54095 .42609 .53736 .42702 Mtetra
.842 .805 .814 r
.53736 .42702 .54095 .42609 .54392 .42163 .54033 .42255 Mtetra
.828 .869 .875 r
.54033 .42255 .54392 .42163 .5469 .41833 .54331 .41925 Mtetra
.683 .955 .951 r
.54331 .41925 .5469 .41833 .54989 .41649 .54631 .41741 Mtetra
.071 0 0 r
.54631 .41741 .54989 .41649 .55291 .41611 .54933 .41703 Mtetra
.511 .031 .054 r
.54933 .41703 .55291 .41611 .55594 .41696 .55236 .41788 Mtetra
.618 .193 .215 r
.55236 .41788 .55594 .41696 .55899 .41863 .55541 .41956 Mtetra
.643 .235 .256 r
.55541 .41956 .55899 .41863 .56206 .42062 .55847 .42155 Mtetra
.626 .208 .229 r
.55847 .42155 .56206 .42062 .56513 .4224 .56154 .42333 Mtetra
.549 .088 .11 r
.56154 .42333 .56513 .4224 .5682 .42349 .56461 .42443 Mtetra
.269 0 0 r
.56461 .42443 .5682 .42349 .57126 .4235 .56767 .42444 Mtetra
.491 .903 .889 r
.56767 .42444 .57126 .4235 .57431 .42216 .57072 .4231 Mtetra
.807 .91 .911 r
.57072 .4231 .57431 .42216 .57734 .41935 .57376 .42028 Mtetra
.843 .82 .827 r
.57376 .42028 .57734 .41935 .58036 .41509 .57677 .41601 Mtetra
.845 .769 .778 r
.57677 .41601 .58036 .41509 .58336 .40951 .57977 .41044 Mtetra
.844 .741 .751 r
.57977 .41044 .58336 .40951 .58634 .40288 .58276 .4038 Mtetra
.842 .726 .736 r
.58276 .4038 .58634 .40288 .58931 .39553 .58573 .39644 Mtetra
.841 .72 .73 r
.58573 .39644 .58931 .39553 .59227 .38783 .5887 .38873 Mtetra
.841 .721 .731 r
.5887 .38873 .59227 .38783 .59523 .38017 .59166 .38106 Mtetra
.842 .728 .738 r
.59166 .38106 .59523 .38017 .5982 .37293 .59463 .37381 Mtetra
.844 .744 .754 r
.59463 .37381 .5982 .37293 .60118 .36645 .59761 .36732 Mtetra
.845 .773 .782 r
.59761 .36732 .60118 .36645 .60418 .36101 .60062 .36188 Mtetra
.841 .823 .831 r
.60062 .36188 .60418 .36101 .6072 .35683 .60364 .3577 Mtetra
.804 .909 .913 r
.60364 .3577 .6072 .35683 .61026 .35404 .6067 .3549 Mtetra
.501 .906 .901 r
.6067 .3549 .61026 .35404 .61335 .35269 .60979 .35356 Mtetra
.28 0 0 r
.60979 .35356 .61335 .35269 .61647 .35276 .61291 .35363 Mtetra
.583 .132 .146 r
.61291 .35363 .61647 .35276 .61963 .35415 .61607 .35502 Mtetra
.672 .28 .293 r
.61607 .35502 .61963 .35415 .62283 .3567 .61927 .35757 Mtetra
.708 .346 .359 r
.61927 .35757 .62283 .3567 .62606 .36017 .62249 .36105 Mtetra
.725 .378 .391 r
.62249 .36105 .62606 .36017 .62931 .36431 .62575 .3652 Mtetra
.732 .392 .405 r
.62575 .3652 .62931 .36431 .63259 .36882 .62902 .36971 Mtetra
.733 .394 .407 r
.62902 .36971 .63259 .36882 .63588 .3734 .6323 .37429 Mtetra
.728 .384 .397 r
.6323 .37429 .63588 .3734 .63917 .37772 .63559 .37863 Mtetra
.715 .358 .372 r
.63559 .37863 .63917 .37772 .64246 .3815 .63888 .38241 Mtetra
.688 .308 .322 r
.63888 .38241 .64246 .3815 .64574 .38446 .64216 .38538 Mtetra
.628 .205 .221 r
.64216 .38538 .64574 .38446 .64901 .38637 .64542 .38729 Mtetra
.46 0 0 r
.64542 .38729 .64901 .38637 .65225 .38704 .64866 .38796 Mtetra
0 0 0 r
.64866 .38796 .65225 .38704 .65545 .38632 .65187 .38724 Mtetra
.726 .955 .948 r
.65187 .38724 .65545 .38632 .65862 .38414 .65504 .38506 Mtetra
.836 .867 .866 r
.65504 .38506 .65862 .38414 .66175 .38048 .65817 .3814 Mtetra
.85 .797 .799 r
.65817 .3814 .66175 .38048 .66485 .37538 .66127 .37629 Mtetra
.849 .755 .759 r
.66127 .37629 .66485 .37538 .6679 .36891 .66432 .36982 Mtetra
.847 .729 .734 r
.66432 .36982 .6679 .36891 .67091 .36123 .66734 .36213 Mtetra
.845 .712 .717 r
.66734 .36213 .67091 .36123 .67389 .35252 .67032 .3534 Mtetra
.843 .702 .707 r
.67032 .3534 .67389 .35252 .67684 .34298 .67327 .34385 Mtetra
.842 .695 .7 r
.67327 .34385 .67684 .34298 .67976 .33285 .67621 .33371 Mtetra
.841 .692 .697 r
.67621 .33371 .67976 .33285 .68267 .3224 .67912 .32325 Mtetra
.841 .691 .696 r
.67912 .32325 .68267 .3224 .68557 .31188 .68203 .31272 Mtetra
.841 .693 .698 r
.68203 .31272 .68557 .31188 .68848 .30155 .68494 .30238 Mtetra
.842 .697 .702 r
.68494 .30238 .68848 .30155 .69139 .29166 .68786 .29247 Mtetra
.843 .705 .71 r
.68786 .29247 .69139 .29166 .69433 .28243 .6908 .28324 Mtetra
.845 .716 .721 r
.6908 .28324 .69433 .28243 .69729 .27408 .69377 .27488 Mtetra
.847 .734 .739 r
.69377 .27488 .69729 .27408 .70029 .26678 .69677 .26757 Mtetra
.848 .762 .767 r
.69677 .26757 .70029 .26678 .70333 .26068 .69982 .26146 Mtetra
.846 .805 .81 r
.69982 .26146 .70333 .26068 .70643 .25589 .70291 .25666 Mtetra
.826 .875 .88 r
.70291 .25666 .70643 .25589 .70958 .25248 .70606 .25326 Mtetra
.691 .95 .955 r
.70606 .25326 .70958 .25248 .71278 .25051 .70927 .25128 Mtetra
0 0 0 r
.70927 .25128 .71278 .25051 .71606 .24996 .71254 .25073 Mtetra
.483 0 0 r
.71254 .25073 .71606 .24996 .71939 .2508 .71588 .25158 Mtetra
.644 .219 .221 r
.71588 .25158 .71939 .2508 .72279 .25297 .71927 .25375 Mtetra
.703 .324 .326 r
.71927 .25375 .72279 .25297 .72625 .25637 .72273 .25715 Mtetra
.732 .378 .381 r
.72273 .25715 .72625 .25637 .72976 .26087 .72624 .26166 Mtetra
.747 .41 .413 r
.72624 .26166 .72976 .26087 .73334 .2663 .72981 .2671 Mtetra
.756 .429 .432 r
.72981 .2671 .73334 .2663 .73695 .2725 .73343 .2733 Mtetra
.761 .441 .444 r
.73343 .2733 .73695 .2725 .74061 .27926 .73708 .28007 Mtetra
.764 .447 .45 r
.73708 .28007 .74061 .27926 .7443 .28638 .74077 .2872 Mtetra
.765 .449 .451 r
.74077 .2872 .7443 .28638 .74802 .29363 .74447 .29446 Mtetra
.764 .447 .449 r
.74447 .29446 .74802 .29363 .75174 .30079 .7482 .30163 Mtetra
.776 .494 .508 r
.30246 .5793 .30605 .57921 .30843 .58628 .30484 .58637 Mtetra
.777 .495 .51 r
.30484 .58637 .30843 .58628 .31082 .5935 .30722 .5936 Mtetra
.776 .494 .508 r
.30722 .5936 .31082 .5935 .31322 .60065 .30962 .60076 Mtetra
.775 .49 .503 r
.30962 .60076 .31322 .60065 .31565 .60753 .31204 .60765 Mtetra
.772 .481 .493 r
.31204 .60765 .31565 .60753 .3181 .61392 .31448 .61404 Mtetra
.768 .468 .477 r
.31448 .61404 .3181 .61392 .32058 .61961 .31696 .61973 Mtetra
.76 .445 .451 r
.31696 .61973 .32058 .61961 .3231 .62441 .31948 .62455 Mtetra
.745 .403 .404 r
.31948 .62455 .3231 .62441 .32566 .62817 .32203 .6283 Mtetra
.71 .32 .308 r
.32203 .6283 .32566 .62817 .32826 .63072 .32463 .63086 Mtetra
.586 .094 .053 r
.32463 .63086 .32826 .63072 .33091 .63197 .32727 .63211 Mtetra
.06 .626 .735 r
.32727 .63211 .33091 .63197 .3336 .63182 .32996 .63196 Mtetra
.701 .871 .962 r
.32996 .63196 .3336 .63182 .33633 .63025 .33269 .63038 Mtetra
.787 .784 .85 r
.33269 .63038 .33633 .63025 .3391 .62723 .33547 .62737 Mtetra
.802 .733 .788 r
.33547 .62737 .3391 .62723 .34192 .62283 .33828 .62296 Mtetra
.805 .703 .752 r
.33828 .62296 .34192 .62283 .34477 .61711 .34114 .61723 Mtetra
.806 .685 .731 r
.34114 .61723 .34477 .61711 .34765 .61019 .34402 .61031 Mtetra
.807 .673 .717 r
.34402 .61031 .34765 .61019 .35055 .60224 .34693 .60235 Mtetra
.807 .666 .708 r
.34693 .60235 .35055 .60224 .35347 .59344 .34985 .59354 Mtetra
.807 .661 .702 r
.34985 .59354 .35347 .59344 .35641 .584 .35279 .5841 Mtetra
.807 .658 .698 r
.35279 .5841 .35641 .584 .35935 .57415 .35574 .57424 Mtetra
.806 .657 .697 r
.35574 .57424 .35935 .57415 .36229 .56416 .35869 .56424 Mtetra
.806 .657 .698 r
.35869 .56424 .36229 .56416 .36523 .55425 .36163 .55433 Mtetra
.807 .66 .7 r
.36163 .55433 .36523 .55425 .36815 .54469 .36455 .54476 Mtetra
.807 .664 .705 r
.36455 .54476 .36815 .54469 .37106 .53572 .36747 .53578 Mtetra
.807 .671 .713 r
.36747 .53578 .37106 .53572 .37395 .52756 .37036 .52761 Mtetra
.806 .681 .726 r
.37036 .52761 .37395 .52756 .37681 .52039 .37323 .52044 Mtetra
.805 .697 .746 r
.37323 .52044 .37681 .52039 .37965 .51439 .37607 .51443 Mtetra
.802 .723 .777 r
.37607 .51443 .37965 .51439 .38247 .50968 .37888 .50971 Mtetra
.79 .766 .831 r
.37888 .50971 .38247 .50968 .38526 .50633 .38168 .50636 Mtetra
.738 .84 .927 r
.38168 .50636 .38526 .50633 .38802 .50439 .38444 .50442 Mtetra
.379 .821 .95 r
.38444 .50442 .38802 .50439 .39077 .50383 .38719 .50386 Mtetra
.441 0 0 r
.38719 .50386 .39077 .50383 .39349 .50458 .38991 .50461 Mtetra
.669 .226 .19 r
.38991 .50461 .39349 .50458 .39621 .50653 .39262 .50656 Mtetra
.726 .344 .326 r
.39262 .50656 .39621 .50653 .39891 .5095 .39532 .50954 Mtetra
.747 .395 .386 r
.39532 .50954 .39891 .5095 .40161 .51328 .39801 .51332 Mtetra
.757 .42 .414 r
.39801 .51332 .40161 .51328 .4043 .51761 .40071 .51765 Mtetra
.76 .429 .425 r
.40071 .51765 .4043 .51761 .40701 .52222 .40341 .52226 Mtetra
.759 .428 .423 r
.40341 .52226 .40701 .52222 .40972 .5268 .40612 .52685 Mtetra
.755 .414 .408 r
.40612 .52685 .40972 .5268 .41245 .53104 .40884 .5311 Mtetra
.742 .383 .372 r
.40884 .5311 .41245 .53104 .4152 .53466 .41159 .53471 Mtetra
.713 .316 .294 r
.41159 .53471 .4152 .53466 .41797 .53737 .41435 .53743 Mtetra
.624 .147 .101 r
.41435 .53743 .41797 .53737 .42076 .53895 .41714 .53901 Mtetra
.201 0 0 r
.41714 .53901 .42076 .53895 .42358 .53922 .41996 .53928 Mtetra
.606 .883 .991 r
.41996 .53928 .42358 .53922 .42642 .53807 .4228 .53813 Mtetra
.772 .81 .883 r
.4228 .53813 .42642 .53807 .42928 .53547 .42566 .53552 Mtetra
.8 .75 .807 r
.42566 .53552 .42928 .53547 .43215 .53147 .42854 .53152 Mtetra
.806 .717 .767 r
.42854 .53152 .43215 .53147 .43505 .5262 .43143 .52626 Mtetra
.809 .698 .743 r
.43143 .52626 .43505 .5262 .43795 .5199 .43434 .51995 Mtetra
.809 .688 .73 r
.43434 .51995 .43795 .5199 .44086 .51284 .43725 .51288 Mtetra
.81 .683 .724 r
.43725 .51288 .44086 .51284 .44378 .50538 .44017 .50541 Mtetra
.81 .682 .724 r
.44017 .50541 .44378 .50538 .44669 .49788 .44308 .4979 Mtetra
.809 .686 .729 r
.44308 .4979 .44669 .49788 .4496 .49073 .44599 .49075 Mtetra
.809 .696 .741 r
.44599 .49075 .4496 .49073 .4525 .48429 .4489 .48431 Mtetra
.807 .714 .763 r
.4489 .48431 .4525 .48429 .45539 .4789 .45179 .47891 Mtetra
.8 .746 .803 r
.45179 .47891 .45539 .4789 .45828 .47478 .45468 .47479 Mtetra
.774 .803 .877 r
.45468 .47479 .45828 .47478 .46115 .47208 .45756 .47209 Mtetra
.633 .878 .987 r
.45756 .47209 .46115 .47208 .46403 .47082 .46043 .47083 Mtetra
.042 0 0 r
.46043 .47083 .46403 .47082 .4669 .47088 .46331 .47089 Mtetra
.532 0 0 r
.46331 .47089 .4669 .47088 .46978 .47201 .46618 .47201 Mtetra
.646 .178 .129 r
.46618 .47201 .46978 .47201 .47265 .47382 .46905 .47383 Mtetra
.666 .215 .172 r
.46905 .47383 .47265 .47382 .47554 .47585 .47194 .47586 Mtetra
.634 .158 .106 r
.47194 .47586 .47554 .47585 .47843 .47757 .47483 .47758 Mtetra
.471 0 0 r
.47483 .47758 .47843 .47757 .48134 .47848 .47773 .47849 Mtetra
.212 .731 .863 r
.47773 .47849 .48134 .47848 .48425 .47817 .48064 .47818 Mtetra
.713 .859 .952 r
.48064 .47818 .48425 .47817 .48717 .47639 .48357 .4764 Mtetra
.788 .782 .847 r
.48357 .4764 .48717 .47639 .4901 .47315 .48649 .47315 Mtetra
.803 .741 .795 r
.48649 .47315 .4901 .47315 .49303 .46873 .48943 .46873 Mtetra
.807 .726 .776 r
.48943 .46873 .49303 .46873 .49596 .46371 .49236 .46371 Mtetra
.806 .73 .781 r
.49236 .46371 .49596 .46371 .4989 .45886 .49529 .45886 Mtetra
.798 .758 .816 r
.49529 .45886 .4989 .45886 .50183 .45497 .49823 .45496 Mtetra
.759 .824 .903 r
.49823 .45496 .50183 .45497 .50477 .45258 .50117 .45257 Mtetra
.535 .87 .992 r
.50117 .45257 .50477 .45258 .50772 .45163 .50412 .45162 Mtetra
.31 .786 .921 r
.50412 .45162 .50772 .45163 .51067 .45117 .50707 .45115 Mtetra
.702 .863 .958 r
.50707 .45115 .51067 .45117 .51363 .44946 .51002 .44944 Mtetra
.782 .795 .864 r
.51002 .44944 .51363 .44946 .51658 .44647 .51298 .44645 Mtetra
.702 .863 .958 r
.51298 .44645 .51658 .44647 .51954 .44475 .51594 .44474 Mtetra
.314 .788 .924 r
.51594 .44474 .51954 .44475 .52252 .44428 .51891 .44426 Mtetra
.536 .871 .992 r
.51891 .44426 .52252 .44428 .5255 .44332 .52189 .4433 Mtetra
.759 .825 .904 r
.52189 .4433 .5255 .44332 .52847 .44091 .52487 .44089 Mtetra
.799 .759 .816 r
.52487 .44089 .52847 .44091 .53144 .43698 .52783 .43696 Mtetra
.807 .732 .781 r
.52783 .43696 .53144 .43698 .5344 .43208 .5308 .43206 Mtetra
.808 .728 .776 r
.5308 .43206 .5344 .43208 .53736 .42702 .53377 .42699 Mtetra
.804 .743 .796 r
.53377 .42699 .53736 .42702 .54033 .42255 .53674 .42252 Mtetra
.789 .783 .847 r
.53674 .42252 .54033 .42255 .54331 .41925 .53972 .41921 Mtetra
.714 .856 .949 r
.53972 .41921 .54331 .41925 .54631 .41741 .54271 .41737 Mtetra
.26 .758 .898 r
.54271 .41737 .54631 .41741 .54933 .41703 .54573 .41699 Mtetra
.429 0 0 r
.54573 .41699 .54933 .41703 .55236 .41788 .54876 .41784 Mtetra
.615 .12 .054 r
.54876 .41784 .55236 .41788 .55541 .41956 .55181 .41952 Mtetra
.652 .183 .126 r
.55181 .41952 .55541 .41956 .55847 .42155 .55487 .42151 Mtetra
.628 .142 .079 r
.55487 .42151 .55847 .42155 .56154 .42333 .55793 .42329 Mtetra
.5 0 0 r
.55793 .42329 .56154 .42333 .56461 .42443 .561 .42439 Mtetra
.006 .582 .718 r
.561 .42439 .56461 .42443 .56767 .42444 .56406 .4244 Mtetra
.633 .878 .987 r
.56406 .4244 .56767 .42444 .57072 .4231 .56711 .42306 Mtetra
.775 .809 .88 r
.56711 .42306 .57072 .4231 .57376 .42028 .57015 .42024 Mtetra
.803 .753 .806 r
.57015 .42024 .57376 .42028 .57677 .41601 .57317 .41597 Mtetra
.811 .721 .765 r
.57317 .41597 .57677 .41601 .57977 .41044 .57617 .41039 Mtetra
.814 .702 .742 r
.57617 .41039 .57977 .41044 .58276 .4038 .57916 .40375 Mtetra
.815 .692 .729 r
.57916 .40375 .58276 .4038 .58573 .39644 .58213 .39638 Mtetra
.815 .688 .724 r
.58213 .39638 .58573 .39644 .5887 .38873 .5851 .38866 Mtetra
.815 .689 .725 r
.5851 .38866 .5887 .38873 .59166 .38106 .58807 .38098 Mtetra
.815 .694 .731 r
.58807 .38098 .59166 .38106 .59463 .37381 .59104 .37373 Mtetra
.813 .704 .745 r
.59104 .37373 .59463 .37381 .59761 .36732 .59403 .36724 Mtetra
.81 .723 .769 r
.59403 .36724 .59761 .36732 .60062 .36188 .59703 .36179 Mtetra
.801 .755 .81 r
.59703 .36179 .60062 .36188 .60364 .3577 .60006 .3576 Mtetra
.772 .808 .882 r
.60006 .3576 .60364 .3577 .6067 .3549 .60312 .35481 Mtetra
.634 .873 .986 r
.60312 .35481 .6067 .3549 .60979 .35356 .60621 .35346 Mtetra
0 .568 .713 r
.60621 .35346 .60979 .35356 .61291 .35363 .60933 .35353 Mtetra
.555 .023 0 r
.60933 .35353 .61291 .35363 .61607 .35502 .61249 .35493 Mtetra
.691 .247 .191 r
.61249 .35493 .61607 .35502 .61927 .35757 .61568 .35748 Mtetra
.734 .335 .295 r
.61568 .35748 .61927 .35757 .62249 .36105 .6189 .36096 Mtetra
.751 .375 .342 r
.6189 .36096 .62249 .36105 .62575 .3652 .62215 .36511 Mtetra
.758 .392 .362 r
.62215 .36511 .62575 .3652 .62902 .36971 .62542 .36963 Mtetra
.759 .394 .365 r
.62542 .36963 .62902 .36971 .6323 .37429 .6287 .37421 Mtetra
.754 .382 .35 r
.6287 .37421 .6323 .37429 .63559 .37863 .63199 .37855 Mtetra
.741 .351 .314 r
.63199 .37855 .63559 .37863 .63888 .38241 .63527 .38234 Mtetra
.711 .286 .238 r
.63527 .38234 .63888 .38241 .64216 .38538 .63855 .38531 Mtetra
.629 .138 .067 r
.63855 .38531 .64216 .38538 .64542 .38729 .64181 .38722 Mtetra
.331 0 0 r
.64181 .38722 .64542 .38729 .64866 .38796 .64504 .38789 Mtetra
.421 .835 .969 r
.64504 .38789 .64866 .38796 .65187 .38724 .64825 .38717 Mtetra
.735 .849 .934 r
.64825 .38717 .65187 .38724 .65504 .38506 .65142 .38499 Mtetra
.796 .782 .84 r
.65142 .38499 .65504 .38506 .65817 .3814 .65456 .38132 Mtetra
.811 .738 .783 r
.65456 .38132 .65817 .3814 .66127 .37629 .65765 .37621 Mtetra
.817 .712 .749 r
.65765 .37621 .66127 .37629 .66432 .36982 .66071 .36973 Mtetra
.819 .694 .727 r
.66071 .36973 .66432 .36982 .66734 .36213 .66373 .36203 Mtetra
.82 .683 .713 r
.66373 .36203 .66734 .36213 .67032 .3534 .66672 .3533 Mtetra
.82 .676 .704 r
.66672 .3533 .67032 .3534 .67327 .34385 .66967 .34374 Mtetra
.82 .671 .698 r
.66967 .34374 .67327 .34385 .67621 .33371 .67261 .3336 Mtetra
.82 .668 .695 r
.67261 .3336 .67621 .33371 .67912 .32325 .67553 .32312 Mtetra
.82 .668 .694 r
.67553 .32312 .67912 .32325 .68203 .31272 .67845 .31258 Mtetra
.82 .669 .695 r
.67845 .31258 .68203 .31272 .68494 .30238 .68136 .30223 Mtetra
.82 .672 .699 r
.68136 .30223 .68494 .30238 .68786 .29247 .68429 .29232 Mtetra
.82 .678 .706 r
.68429 .29232 .68786 .29247 .6908 .28324 .68723 .28308 Mtetra
.819 .686 .717 r
.68723 .28308 .6908 .28324 .69377 .27488 .6902 .27471 Mtetra
.818 .698 .732 r
.6902 .27471 .69377 .27488 .69677 .26757 .69321 .26739 Mtetra
.815 .716 .756 r
.69321 .26739 .69677 .26757 .69982 .26146 .69626 .26128 Mtetra
.808 .743 .792 r
.69626 .26128 .69982 .26146 .70291 .25666 .69935 .25648 Mtetra
.787 .787 .852 r
.69935 .25648 .70291 .25666 .70606 .25326 .70251 .25307 Mtetra
.714 .849 .946 r
.70251 .25307 .70606 .25326 .70927 .25128 .70572 .25109 Mtetra
.365 .805 .959 r
.70572 .25109 .70927 .25128 .71254 .25073 .70899 .25054 Mtetra
.367 0 0 r
.70899 .25054 .71254 .25073 .71588 .25158 .71232 .25139 Mtetra
.648 .158 .074 r
.71232 .25139 .71588 .25158 .71927 .25375 .71571 .25356 Mtetra
.727 .306 .248 r
.71571 .25356 .71927 .25375 .72273 .25715 .71917 .25697 Mtetra
.757 .375 .33 r
.71917 .25697 .72273 .25715 .72624 .26166 .72268 .26147 Mtetra
.772 .412 .375 r
.72268 .26147 .72624 .26166 .72981 .2671 .72624 .26692 Mtetra
.78 .434 .401 r
.72624 .26692 .72981 .2671 .73343 .2733 .72985 .27313 Mtetra
.784 .447 .417 r
.72985 .27313 .73343 .2733 .73708 .28007 .7335 .27991 Mtetra
.786 .454 .425 r
.7335 .27991 .73708 .28007 .74077 .2872 .73718 .28704 Mtetra
.787 .456 .427 r
.73718 .28704 .74077 .2872 .74447 .29446 .74088 .29431 Mtetra
.786 .453 .424 r
.74088 .29431 .74447 .29446 .7482 .30163 .7446 .30148 Mtetra
.809 .511 .484 r
.29892 .57792 .30246 .5793 .30484 .58637 .30129 .585 Mtetra
.809 .512 .487 r
.30129 .585 .30484 .58637 .30722 .5936 .30367 .59223 Mtetra
.809 .511 .485 r
.30367 .59223 .30722 .5936 .30962 .60076 .30606 .59939 Mtetra
.809 .506 .477 r
.30606 .59939 .30962 .60076 .31204 .60765 .30847 .60627 Mtetra
.809 .498 .463 r
.30847 .60627 .31204 .60765 .31448 .61404 .31091 .61267 Mtetra
.808 .483 .439 r
.31091 .61267 .31448 .61404 .31696 .61973 .31338 .61836 Mtetra
.805 .457 .397 r
.31338 .61836 .31696 .61973 .31948 .62455 .31589 .62318 Mtetra
.794 .403 .314 r
.31589 .62318 .31948 .62455 .32203 .6283 .31844 .62693 Mtetra
.745 .269 .114 r
.31844 .62693 .32203 .6283 .32463 .63086 .32103 .62949 Mtetra
.401 0 0 r
.32103 .62949 .32463 .63086 .32727 .63211 .32367 .63074 Mtetra
.438 .714 .982 r
.32367 .63074 .32727 .63211 .32996 .63196 .32636 .63059 Mtetra
.674 .715 .879 r
.32636 .63059 .32996 .63196 .33269 .63038 .32909 .62901 Mtetra
.733 .685 .805 r
.32909 .62901 .33269 .63038 .33547 .62737 .33187 .62599 Mtetra
.755 .665 .762 r
.33187 .62599 .33547 .62737 .33828 .62296 .33469 .62158 Mtetra
.767 .653 .737 r
.33469 .62158 .33828 .62296 .34114 .61723 .33754 .61585 Mtetra
.773 .644 .72 r
.33754 .61585 .34114 .61723 .34402 .61031 .34042 .60893 Mtetra
.777 .639 .709 r
.34042 .60893 .34402 .61031 .34693 .60235 .34333 .60097 Mtetra
.779 .635 .701 r
.34333 .60097 .34693 .60235 .34985 .59354 .34627 .59215 Mtetra
.781 .632 .696 r
.34627 .59215 .34985 .59354 .35279 .5841 .34921 .5827 Mtetra
.782 .631 .693 r
.34921 .5827 .35279 .5841 .35574 .57424 .35216 .57284 Mtetra
.782 .63 .692 r
.35216 .57284 .35574 .57424 .35869 .56424 .35511 .56283 Mtetra
.782 .63 .693 r
.35511 .56283 .35869 .56424 .36163 .55433 .35805 .55291 Mtetra
.781 .632 .695 r
.35805 .55291 .36163 .55433 .36455 .54476 .36099 .54334 Mtetra
.78 .634 .699 r
.36099 .54334 .36455 .54476 .36747 .53578 .3639 .53436 Mtetra
.778 .637 .706 r
.3639 .53436 .36747 .53578 .37036 .52761 .3668 .52618 Mtetra
.774 .642 .716 r
.3668 .52618 .37036 .52761 .37323 .52044 .36967 .51901 Mtetra
.768 .65 .731 r
.36967 .51901 .37323 .52044 .37607 .51443 .37251 .513 Mtetra
.758 .661 .755 r
.37251 .513 .37607 .51443 .37888 .50971 .37533 .50828 Mtetra
.738 .678 .792 r
.37533 .50828 .37888 .50971 .38168 .50636 .37812 .50493 Mtetra
.693 .703 .855 r
.37812 .50493 .38168 .50636 .38444 .50442 .38088 .50298 Mtetra
.549 .723 .954 r
.38088 .50298 .38444 .50442 .38719 .50386 .38363 .50242 Mtetra
0 .497 .842 r
.38363 .50242 .38719 .50386 .38991 .50461 .38635 .50317 Mtetra
.639 .083 0 r
.38635 .50317 .38991 .50461 .39262 .50656 .38906 .50512 Mtetra
.767 .31 .163 r
.38906 .50512 .39262 .50656 .39532 .50954 .39175 .50809 Mtetra
.795 .39 .285 r
.39175 .50809 .39532 .50954 .39801 .51332 .39444 .51187 Mtetra
.804 .424 .337 r
.39444 .51187 .39801 .51332 .40071 .51765 .39713 .51621 Mtetra
.806 .437 .357 r
.39713 .51621 .40071 .51765 .40341 .52226 .39983 .52082 Mtetra
.806 .435 .353 r
.39983 .52082 .40341 .52226 .40612 .52685 .40253 .5254 Mtetra
.802 .417 .326 r
.40253 .5254 .40612 .52685 .40884 .5311 .40525 .52965 Mtetra
.79 .373 .257 r
.40525 .52965 .40884 .5311 .41159 .53471 .40799 .53327 Mtetra
.745 .261 .092 r
.40799 .53327 .41159 .53471 .41435 .53743 .41075 .53599 Mtetra
.507 0 0 r
.41075 .53599 .41435 .53743 .41714 .53901 .41354 .53757 Mtetra
.274 .656 .968 r
.41354 .53757 .41714 .53901 .41996 .53928 .41635 .53783 Mtetra
.631 .722 .912 r
.41635 .53783 .41996 .53928 .4228 .53813 .41919 .53668 Mtetra
.718 .694 .826 r
.41919 .53668 .4228 .53813 .42566 .53552 .42205 .53407 Mtetra
.749 .673 .776 r
.42205 .53407 .42566 .53552 .42854 .53152 .42493 .53007 Mtetra
.763 .659 .747 r
.42493 .53007 .42854 .53152 .43143 .52626 .42783 .5248 Mtetra
.771 .651 .73 r
.42783 .5248 .43143 .52626 .43434 .51995 .43073 .51849 Mtetra
.775 .646 .72 r
.43073 .51849 .43434 .51995 .43725 .51288 .43365 .51142 Mtetra
.777 .643 .715 r
.43365 .51142 .43725 .51288 .44017 .50541 .43657 .50394 Mtetra
.777 .643 .714 r
.43657 .50394 .44017 .50541 .44308 .4979 .43949 .49643 Mtetra
.775 .645 .718 r
.43949 .49643 .44308 .4979 .44599 .49075 .4424 .48927 Mtetra
.772 .65 .728 r
.4424 .48927 .44599 .49075 .4489 .48431 .44531 .48283 Mtetra
.764 .658 .744 r
.44531 .48283 .4489 .48431 .45179 .47891 .4482 .47743 Mtetra
.751 .671 .773 r
.4482 .47743 .45179 .47891 .45468 .47479 .45109 .4733 Mtetra
.72 .691 .822 r
.45109 .4733 .45468 .47479 .45756 .47209 .45397 .4706 Mtetra
.64 .718 .904 r
.45397 .4706 .45756 .47209 .46043 .47083 .45684 .46934 Mtetra
.374 .688 .98 r
.45684 .46934 .46043 .47083 .46331 .47089 .45971 .46939 Mtetra
0 .346 .692 r
.45971 .46939 .46331 .47089 .46618 .47201 .46258 .47052 Mtetra
.563 0 0 r
.46258 .47052 .46618 .47201 .46905 .47383 .46546 .47233 Mtetra
.624 .061 0 r
.46546 .47233 .46905 .47383 .47194 .47586 .46834 .47436 Mtetra
.528 0 0 r
.46834 .47436 .47194 .47586 .47483 .47758 .47122 .47608 Mtetra
0 .455 .805 r
.47122 .47608 .47483 .47758 .47773 .47849 .47412 .47699 Mtetra
.489 .715 .971 r
.47412 .47699 .47773 .47849 .48064 .47818 .47703 .47668 Mtetra
.679 .71 .871 r
.47703 .47668 .48064 .47818 .48357 .4764 .47995 .47489 Mtetra
.734 .684 .802 r
.47995 .47489 .48357 .4764 .48649 .47315 .48288 .47165 Mtetra
.754 .669 .767 r
.48288 .47165 .48649 .47315 .48943 .46873 .48582 .46723 Mtetra
.761 .663 .754 r
.48582 .46723 .48943 .46873 .49236 .46371 .48875 .4622 Mtetra
.76 .665 .757 r
.48875 .4622 .49236 .46371 .49529 .45886 .49169 .45734 Mtetra
.747 .675 .781 r
.49169 .45734 .49529 .45886 .49823 .45496 .49462 .45344 Mtetra
.708 .698 .839 r
.49462 .45344 .49823 .45496 .50117 .45257 .49756 .45105 Mtetra
.602 .721 .928 r
.49756 .45105 .50117 .45257 .50412 .45162 .50051 .4501 Mtetra
.523 .719 .962 r
.50051 .4501 .50412 .45162 .50707 .45115 .50346 .44963 Mtetra
.673 .711 .877 r
.50346 .44963 .50707 .45115 .51002 .44944 .50641 .44792 Mtetra
.727 .689 .813 r
.50641 .44792 .51002 .44944 .51298 .44645 .50937 .44493 Mtetra
.673 .711 .876 r
.50937 .44493 .51298 .44645 .51594 .44474 .51233 .44321 Mtetra
.524 .718 .961 r
.51233 .44321 .51594 .44474 .51891 .44426 .5153 .44273 Mtetra
.603 .721 .928 r
.5153 .44273 .51891 .44426 .52189 .4433 .51827 .44177 Mtetra
.708 .699 .839 r
.51827 .44177 .52189 .4433 .52487 .44089 .52125 .43935 Mtetra
.747 .676 .782 r
.52125 .43935 .52487 .44089 .52783 .43696 .52422 .43542 Mtetra
.76 .665 .758 r
.52422 .43542 .52783 .43696 .5308 .43206 .52718 .43051 Mtetra
.762 .664 .754 r
.52718 .43051 .5308 .43206 .53377 .42699 .53015 .42544 Mtetra
.755 .67 .768 r
.53015 .42544 .53377 .42699 .53674 .42252 .53312 .42097 Mtetra
.734 .685 .803 r
.53312 .42097 .53674 .42252 .53972 .41921 .5361 .41766 Mtetra
.679 .708 .87 r
.5361 .41766 .53972 .41921 .54271 .41737 .5391 .41582 Mtetra
.503 .714 .966 r
.5391 .41582 .54271 .41737 .54573 .41699 .54211 .41543 Mtetra
0 .503 .856 r
.54211 .41543 .54573 .41699 .54876 .41784 .54514 .41628 Mtetra
.46 0 0 r
.54514 .41628 .54876 .41784 .55181 .41952 .54819 .41796 Mtetra
.573 0 0 r
.54819 .41796 .55181 .41952 .55487 .42151 .55124 .41995 Mtetra
.501 0 0 r
.55124 .41995 .55487 .42151 .55793 .42329 .5543 .42173 Mtetra
0 .406 .761 r
.5543 .42173 .55793 .42329 .561 .42439 .55737 .42283 Mtetra
.395 .691 .979 r
.55737 .42283 .561 .42439 .56406 .4244 .56043 .42284 Mtetra
.641 .717 .904 r
.56043 .42284 .56406 .4244 .56711 .42306 .56348 .42149 Mtetra
.72 .694 .824 r
.56348 .42149 .56711 .42306 .57015 .42024 .56651 .41868 Mtetra
.752 .674 .775 r
.56651 .41868 .57015 .42024 .57317 .41597 .56953 .4144 Mtetra
.767 .661 .746 r
.56953 .4144 .57317 .41597 .57617 .41039 .57254 .40881 Mtetra
.774 .653 .728 r
.57254 .40881 .57617 .41039 .57916 .40375 .57553 .40217 Mtetra
.778 .648 .719 r
.57553 .40217 .57916 .40375 .58213 .39638 .5785 .39479 Mtetra
.78 .646 .714 r
.5785 .39479 .58213 .39638 .5851 .38866 .58148 .38707 Mtetra
.78 .647 .715 r
.58148 .38707 .5851 .38866 .58807 .38098 .58445 .37939 Mtetra
.778 .649 .72 r
.58445 .37939 .58807 .38098 .59104 .37373 .58742 .37214 Mtetra
.774 .654 .73 r
.58742 .37214 .59104 .37373 .59403 .36724 .59041 .36564 Mtetra
.765 .662 .748 r
.59041 .36564 .59403 .36724 .59703 .36179 .59342 .36019 Mtetra
.75 .674 .777 r
.59342 .36019 .59703 .36179 .60006 .3576 .59644 .356 Mtetra
.718 .693 .825 r
.59644 .356 .60006 .3576 .60312 .35481 .5995 .3532 Mtetra
.639 .715 .902 r
.5995 .3532 .60312 .35481 .60621 .35346 .60259 .35185 Mtetra
.38 .683 .978 r
.60259 .35185 .60621 .35346 .60933 .35353 .60571 .35192 Mtetra
0 .298 .652 r
.60571 .35192 .60933 .35353 .61249 .35493 .60887 .35331 Mtetra
.672 .126 0 r
.60887 .35331 .61249 .35493 .61568 .35748 .61205 .35586 Mtetra
.767 .292 .114 r
.61205 .35586 .61568 .35748 .6189 .36096 .61527 .35934 Mtetra
.794 .358 .213 r
.61527 .35934 .6189 .36096 .62215 .36511 .61851 .36349 Mtetra
.802 .383 .252 r
.61851 .36349 .62215 .36511 .62542 .36963 .62178 .36801 Mtetra
.803 .386 .257 r
.62178 .36801 .62542 .36963 .6287 .37421 .62505 .3726 Mtetra
.797 .368 .229 r
.62505 .3726 .6287 .37421 .63199 .37855 .62834 .37693 Mtetra
.779 .32 .155 r
.62834 .37693 .63199 .37855 .63527 .38234 .63162 .38072 Mtetra
.72 .204 0 r
.63162 .38072 .63527 .38234 .63855 .38531 .63489 .38369 Mtetra
.496 0 0 r
.63489 .38369 .63855 .38531 .64181 .38722 .63815 .3856 Mtetra
.133 .581 .925 r
.63815 .3856 .64181 .38722 .64504 .38789 .64138 .38627 Mtetra
.56 .72 .948 r
.64138 .38627 .64504 .38789 .64825 .38717 .64458 .38555 Mtetra
.692 .706 .859 r
.64458 .38555 .64825 .38717 .65142 .38499 .64776 .38336 Mtetra
.74 .685 .798 r
.64776 .38336 .65142 .38499 .65456 .38132 .65089 .37969 Mtetra
.762 .669 .759 r
.65089 .37969 .65456 .38132 .65765 .37621 .65399 .37457 Mtetra
.774 .658 .734 r
.65399 .37457 .65765 .37621 .66071 .36973 .65705 .36809 Mtetra
.782 .65 .717 r
.65705 .36809 .66071 .36973 .66373 .36203 .66007 .36039 Mtetra
.786 .644 .705 r
.66007 .36039 .66373 .36203 .66672 .3533 .66306 .35165 Mtetra
.789 .641 .698 r
.66306 .35165 .66672 .3533 .66967 .34374 .66602 .34209 Mtetra
.791 .638 .693 r
.66602 .34209 .66967 .34374 .67261 .3336 .66896 .33194 Mtetra
.792 .637 .69 r
.66896 .33194 .67261 .3336 .67553 .32312 .67189 .32147 Mtetra
.792 .637 .689 r
.67189 .32147 .67553 .32312 .67845 .31258 .67481 .31092 Mtetra
.791 .637 .691 r
.67481 .31092 .67845 .31258 .68136 .30223 .67773 .30056 Mtetra
.79 .639 .694 r
.67773 .30056 .68136 .30223 .68429 .29232 .68066 .29065 Mtetra
.788 .642 .7 r
.68066 .29065 .68429 .29232 .68723 .28308 .6836 .2814 Mtetra
.785 .646 .708 r
.6836 .2814 .68723 .28308 .6902 .27471 .68658 .27302 Mtetra
.78 .651 .721 r
.68658 .27302 .6902 .27471 .69321 .26739 .68959 .2657 Mtetra
.771 .659 .739 r
.68959 .2657 .69321 .26739 .69626 .26128 .69264 .25959 Mtetra
.758 .67 .765 r
.69264 .25959 .69626 .26128 .69935 .25648 .69574 .25478 Mtetra
.733 .686 .805 r
.69574 .25478 .69935 .25648 .70251 .25307 .69889 .25137 Mtetra
.679 .705 .868 r
.69889 .25137 .70251 .25307 .70572 .25109 .7021 .24939 Mtetra
.533 .71 .953 r
.7021 .24939 .70572 .25109 .70899 .25054 .70537 .24884 Mtetra
.079 .543 .902 r
.70537 .24884 .70899 .25054 .71232 .25139 .70869 .24968 Mtetra
.535 0 0 r
.70869 .24968 .71232 .25139 .71571 .25356 .71208 .25186 Mtetra
.744 .24 .024 r
.71208 .25186 .71571 .25356 .71917 .25697 .71553 .25526 Mtetra
.797 .356 .197 r
.71553 .25526 .71917 .25697 .72268 .26147 .71904 .25977 Mtetra
.815 .41 .283 r
.71904 .25977 .72268 .26147 .72624 .26692 .7226 .26521 Mtetra
.822 .439 .329 r
.7226 .26521 .72624 .26692 .72985 .27313 .7262 .27142 Mtetra
.825 .455 .355 r
.7262 .27142 .72985 .27313 .7335 .27991 .72984 .2782 Mtetra
.826 .463 .368 r
.72984 .2782 .7335 .27991 .73718 .28704 .73352 .28533 Mtetra
.827 .466 .372 r
.73352 .28533 .73718 .28704 .74088 .29431 .73721 .2926 Mtetra
.826 .463 .368 r
.73721 .2926 .74088 .29431 .7446 .30148 .74092 .29978 Mtetra
.847 .529 .45 r
.29542 .57514 .29892 .57792 .30129 .585 .29778 .58221 Mtetra
.846 .53 .454 r
.29778 .58221 .30129 .585 .30367 .59223 .30015 .58943 Mtetra
.847 .529 .451 r
.30015 .58943 .30367 .59223 .30606 .59939 .30254 .59659 Mtetra
.848 .525 .44 r
.30254 .59659 .30606 .59939 .30847 .60627 .30494 .60347 Mtetra
.851 .516 .419 r
.30494 .60347 .30847 .60627 .31091 .61267 .30738 .60986 Mtetra
.854 .499 .38 r
.30738 .60986 .31091 .61267 .31338 .61836 .30984 .61556 Mtetra
.854 .464 .306 r
.30984 .61556 .31338 .61836 .31589 .62318 .31234 .62037 Mtetra
.834 .381 .144 r
.31234 .62037 .31589 .62318 .31844 .62693 .31489 .62412 Mtetra
.656 .114 0 r
.31489 .62412 .31844 .62693 .32103 .62949 .31748 .62667 Mtetra
.063 .431 .872 r
.31748 .62667 .32103 .62949 .32367 .63074 .32012 .62792 Mtetra
.507 .604 .885 r
.32012 .62792 .32367 .63074 .32636 .63059 .3228 .62777 Mtetra
.641 .623 .816 r
.3228 .62777 .32636 .63059 .32909 .62901 .32553 .62618 Mtetra
.695 .622 .771 r
.32553 .62618 .32909 .62901 .33187 .62599 .32831 .62316 Mtetra
.721 .618 .742 r
.32831 .62316 .33187 .62599 .33469 .62158 .33112 .61875 Mtetra
.737 .615 .723 r
.33112 .61875 .33469 .62158 .33754 .61585 .33398 .61302 Mtetra
.746 .613 .71 r
.33398 .61302 .33754 .61585 .34042 .60893 .33686 .60609 Mtetra
.753 .611 .701 r
.33686 .60609 .34042 .60893 .34333 .60097 .33978 .59813 Mtetra
.757 .61 .695 r
.33978 .59813 .34333 .60097 .34627 .59215 .34271 .58931 Mtetra
.76 .609 .691 r
.34271 .58931 .34627 .59215 .34921 .5827 .34566 .57986 Mtetra
.761 .608 .688 r
.34566 .57986 .34921 .5827 .35216 .57284 .34861 .57 Mtetra
.762 .608 .687 r
.34861 .57 .35216 .57284 .35511 .56283 .35156 .55999 Mtetra
.762 .608 .688 r
.35156 .55999 .35511 .56283 .35805 .55291 .35451 .55007 Mtetra
.76 .609 .69 r
.35451 .55007 .35805 .55291 .36099 .54334 .35745 .5405 Mtetra
.758 .609 .693 r
.35745 .5405 .36099 .54334 .3639 .53436 .36037 .53151 Mtetra
.754 .611 .699 r
.36037 .53151 .3639 .53436 .3668 .52618 .36326 .52333 Mtetra
.748 .612 .707 r
.36326 .52333 .3668 .52618 .36967 .51901 .36614 .51616 Mtetra
.739 .614 .719 r
.36614 .51616 .36967 .51901 .37251 .513 .36898 .51015 Mtetra
.725 .617 .737 r
.36898 .51015 .37251 .513 .37533 .50828 .3718 .50542 Mtetra
.702 .62 .762 r
.3718 .50542 .37533 .50828 .37812 .50493 .37459 .50207 Mtetra
.658 .622 .802 r
.37459 .50207 .37812 .50493 .38088 .50298 .37735 .50012 Mtetra
.561 .612 .861 r
.37735 .50012 .38088 .50298 .38363 .50242 .38009 .49956 Mtetra
.299 .536 .912 r
.38009 .49956 .38363 .50242 .38635 .50317 .38281 .50031 Mtetra
0 .192 .668 r
.38281 .50031 .38635 .50317 .38906 .50512 .38551 .50225 Mtetra
.727 .2 0 r
.38551 .50225 .38906 .50512 .39175 .50809 .38821 .50522 Mtetra
.825 .357 .093 r
.38821 .50522 .39175 .50809 .39444 .51187 .39089 .509 Mtetra
.847 .414 .199 r
.39089 .509 .39444 .51187 .39713 .51621 .39357 .51333 Mtetra
.852 .434 .237 r
.39357 .51333 .39713 .51621 .39983 .52082 .39626 .51794 Mtetra
.851 .431 .231 r
.39626 .51794 .39983 .52082 .40253 .5254 .39896 .52252 Mtetra
.843 .402 .177 r
.39896 .52252 .40253 .5254 .40525 .52965 .40168 .52676 Mtetra
.808 .324 .036 r
.40168 .52676 .40525 .52965 .40799 .53327 .40441 .53038 Mtetra
.643 .101 0 r
.40441 .53038 .40799 .53327 .41075 .53599 .40717 .53309 Mtetra
0 .354 .819 r
.40717 .53309 .41075 .53599 .41354 .53757 .40996 .53467 Mtetra
.433 .583 .902 r
.40996 .53467 .41354 .53757 .41635 .53783 .41276 .53493 Mtetra
.611 .62 .835 r
.41276 .53493 .41635 .53783 .41919 .53668 .4156 .53378 Mtetra
.68 .622 .784 r
.4156 .53378 .41919 .53668 .42205 .53407 .41846 .53117 Mtetra
.713 .62 .751 r
.41846 .53117 .42205 .53407 .42493 .53007 .42134 .52716 Mtetra
.731 .617 .731 r
.42134 .52716 .42493 .53007 .42783 .5248 .42423 .52189 Mtetra
.742 .615 .718 r
.42423 .52189 .42783 .5248 .43073 .51849 .42714 .51557 Mtetra
.748 .614 .71 r
.42714 .51557 .43073 .51849 .43365 .51142 .43006 .5085 Mtetra
.75 .613 .706 r
.43006 .5085 .43365 .51142 .43657 .50394 .43298 .50102 Mtetra
.751 .613 .706 r
.43298 .50102 .43657 .50394 .43949 .49643 .4359 .49351 Mtetra
.748 .613 .709 r
.4359 .49351 .43949 .49643 .4424 .48927 .43882 .48635 Mtetra
.743 .615 .716 r
.43882 .48635 .4424 .48927 .44531 .48283 .44173 .47991 Mtetra
.733 .617 .729 r
.44173 .47991 .44531 .48283 .4482 .47743 .44462 .4745 Mtetra
.715 .619 .749 r
.44462 .4745 .4482 .47743 .45109 .4733 .44751 .47038 Mtetra
.682 .622 .782 r
.44751 .47038 .45109 .4733 .45397 .4706 .45039 .46767 Mtetra
.617 .62 .831 r
.45039 .46767 .45397 .4706 .45684 .46934 .45326 .4664 Mtetra
.474 .593 .892 r
.45326 .4664 .45684 .46934 .45971 .46939 .45613 .46646 Mtetra
.182 .484 .899 r
.45613 .46646 .45971 .46939 .46258 .47052 .45899 .46758 Mtetra
0 .294 .77 r
.45899 .46758 .46258 .47052 .46546 .47233 .46186 .46939 Mtetra
0 .214 .693 r
.46186 .46939 .46546 .47233 .46834 .47436 .46474 .47142 Mtetra
0 .33 .8 r
.46474 .47142 .46834 .47436 .47122 .47608 .46762 .47313 Mtetra
.266 .521 .909 r
.46762 .47313 .47122 .47608 .47412 .47699 .47052 .47404 Mtetra
.529 .606 .875 r
.47052 .47404 .47412 .47699 .47703 .47668 .47343 .47372 Mtetra
.645 .622 .812 r
.47343 .47372 .47703 .47668 .47995 .47489 .47634 .47194 Mtetra
.696 .622 .769 r
.47634 .47194 .47995 .47489 .48288 .47165 .47927 .46869 Mtetra
.719 .619 .745 r
.47927 .46869 .48288 .47165 .48582 .46723 .4822 .46426 Mtetra
.728 .618 .735 r
.4822 .46426 .48582 .46723 .48875 .4622 .48514 .45924 Mtetra
.726 .618 .738 r
.48514 .45924 .48875 .4622 .49169 .45734 .48808 .45438 Mtetra
.71 .62 .755 r
.48808 .45438 .49169 .45734 .49462 .45344 .49101 .45047 Mtetra
.67 .622 .792 r
.49101 .45047 .49462 .45344 .49756 .45105 .49395 .44808 Mtetra
.592 .617 .845 r
.49395 .44808 .49756 .45105 .50051 .4501 .49689 .44713 Mtetra
.546 .609 .867 r
.49689 .44713 .50051 .4501 .50346 .44963 .49984 .44665 Mtetra
.641 .621 .815 r
.49984 .44665 .50346 .44963 .50641 .44792 .50279 .44494 Mtetra
.689 .622 .776 r
.50279 .44494 .50641 .44792 .50937 .44493 .50575 .44194 Mtetra
.641 .621 .815 r
.50575 .44194 .50937 .44493 .51233 .44321 .50871 .44022 Mtetra
.547 .609 .867 r
.50871 .44022 .51233 .44321 .5153 .44273 .51168 .43974 Mtetra
.592 .617 .845 r
.51168 .43974 .5153 .44273 .51827 .44177 .51465 .43878 Mtetra
.67 .622 .792 r
.51465 .43878 .51827 .44177 .52125 .43935 .51762 .43636 Mtetra
.71 .621 .755 r
.51762 .43636 .52125 .43935 .52422 .43542 .52059 .43242 Mtetra
.726 .619 .738 r
.52059 .43242 .52422 .43542 .52718 .43051 .52356 .42751 Mtetra
.728 .618 .736 r
.52356 .42751 .52718 .43051 .53015 .42544 .52652 .42244 Mtetra
.719 .62 .746 r
.52652 .42244 .53015 .42544 .53312 .42097 .5295 .41796 Mtetra
.696 .622 .769 r
.5295 .41796 .53312 .42097 .5361 .41766 .53248 .41466 Mtetra
.646 .622 .811 r
.53248 .41466 .5361 .41766 .5391 .41582 .53547 .41281 Mtetra
.535 .606 .871 r
.53547 .41281 .5391 .41582 .54211 .41543 .53848 .41242 Mtetra
.301 .534 .91 r
.53848 .41242 .54211 .41543 .54514 .41628 .54151 .41327 Mtetra
0 .376 .837 r
.54151 .41327 .54514 .41628 .54819 .41796 .54455 .41494 Mtetra
0 .277 .756 r
.54455 .41494 .54819 .41796 .55124 .41995 .5476 .41693 Mtetra
0 .346 .814 r
.5476 .41693 .55124 .41995 .5543 .42173 .55066 .41871 Mtetra
.226 .502 .904 r
.55066 .41871 .5543 .42173 .55737 .42283 .55372 .4198 Mtetra
.483 .594 .889 r
.55372 .4198 .55737 .42283 .56043 .42284 .55677 .4198 Mtetra
.617 .62 .831 r
.55677 .4198 .56043 .42284 .56348 .42149 .55982 .41846 Mtetra
.682 .623 .783 r
.55982 .41846 .56348 .42149 .56651 .41868 .56285 .41564 Mtetra
.715 .621 .75 r
.56285 .41564 .56651 .41868 .56953 .4144 .56587 .41136 Mtetra
.734 .618 .73 r
.56587 .41136 .56953 .4144 .57254 .40881 .56888 .40577 Mtetra
.744 .616 .716 r
.56888 .40577 .57254 .40881 .57553 .40217 .57187 .39912 Mtetra
.75 .615 .709 r
.57187 .39912 .57553 .40217 .5785 .39479 .57485 .39175 Mtetra
.753 .614 .705 r
.57485 .39175 .5785 .39479 .58148 .38707 .57782 .38402 Mtetra
.752 .614 .706 r
.57782 .38402 .58148 .38707 .58445 .37939 .5808 .37634 Mtetra
.749 .615 .71 r
.5808 .37634 .58445 .37939 .58742 .37214 .58378 .36908 Mtetra
.743 .616 .718 r
.58378 .36908 .58742 .37214 .59041 .36564 .58676 .36258 Mtetra
.732 .618 .731 r
.58676 .36258 .59041 .36564 .59342 .36019 .58977 .35713 Mtetra
.713 .621 .752 r
.58977 .35713 .59342 .36019 .59644 .356 .5928 .35294 Mtetra
.68 .622 .784 r
.5928 .35294 .59644 .356 .5995 .3532 .59585 .35014 Mtetra
.616 .619 .83 r
.59585 .35014 .5995 .3532 .60259 .35185 .59894 .34878 Mtetra
.474 .59 .89 r
.59894 .34878 .60259 .35185 .60571 .35192 .60206 .34885 Mtetra
.134 .457 .886 r
.60206 .34885 .60571 .35192 .60887 .35331 .60521 .35024 Mtetra
0 .118 .596 r
.60521 .35024 .60887 .35331 .61205 .35586 .60839 .35278 Mtetra
.698 .168 0 r
.60839 .35278 .61205 .35586 .61527 .35934 .61161 .35626 Mtetra
.792 .294 0 r
.61161 .35626 .61527 .35934 .61851 .36349 .61484 .36041 Mtetra
.819 .342 .051 r
.61484 .36041 .61851 .36349 .62178 .36801 .6181 .36492 Mtetra
.822 .347 .06 r
.6181 .36492 .62178 .36801 .62505 .3726 .62137 .3695 Mtetra
.804 .314 .004 r
.62137 .3695 .62505 .3726 .62834 .37693 .62465 .37383 Mtetra
.741 .221 0 r
.62465 .37383 .62834 .37693 .63162 .38072 .62792 .37762 Mtetra
.539 .004 0 r
.62792 .37762 .63162 .38072 .63489 .38369 .63119 .38058 Mtetra
0 .345 .814 r
.63119 .38058 .63489 .38369 .63815 .3856 .63444 .38249 Mtetra
.363 .556 .907 r
.63444 .38249 .63815 .3856 .64138 .38627 .63767 .38315 Mtetra
.566 .612 .858 r
.63767 .38315 .64138 .38627 .64458 .38555 .64088 .38243 Mtetra
.656 .623 .804 r
.64088 .38243 .64458 .38555 .64776 .38336 .64404 .38024 Mtetra
.701 .623 .766 r
.64404 .38024 .64776 .38336 .65089 .37969 .64718 .37657 Mtetra
.727 .62 .739 r
.64718 .37657 .65089 .37969 .65399 .37457 .65028 .37145 Mtetra
.742 .618 .72 r
.65028 .37145 .65399 .37457 .65705 .36809 .65334 .36497 Mtetra
.753 .616 .707 r
.65334 .36497 .65705 .36809 .66007 .36039 .65636 .35727 Mtetra
.759 .614 .698 r
.65636 .35727 .66007 .36039 .66306 .35165 .65935 .34852 Mtetra
.764 .613 .692 r
.65935 .34852 .66306 .35165 .66602 .34209 .66232 .33896 Mtetra
.767 .612 .687 r
.66232 .33896 .66602 .34209 .66896 .33194 .66526 .32881 Mtetra
.768 .612 .685 r
.66526 .32881 .66896 .33194 .67189 .32147 .66819 .31833 Mtetra
.66819 .31833 .67189 .32147 .67481 .31092 .67112 .30778 Mtetra
.768 .612 .686 r
.67112 .30778 .67481 .31092 .67773 .30056 .67404 .29743 Mtetra
.766 .612 .689 r
.67404 .29743 .67773 .30056 .68066 .29065 .67697 .28751 Mtetra
.762 .613 .693 r
.67697 .28751 .68066 .29065 .6836 .2814 .67992 .27826 Mtetra
.757 .615 .7 r
.67992 .27826 .6836 .2814 .68658 .27302 .6829 .26988 Mtetra
.75 .616 .71 r
.6829 .26988 .68658 .27302 .68959 .2657 .68591 .26256 Mtetra
.739 .618 .724 r
.68591 .26256 .68959 .2657 .69264 .25959 .68896 .25644 Mtetra
.722 .62 .744 r
.68896 .25644 .69264 .25959 .69574 .25478 .69206 .25163 Mtetra
.694 .622 .771 r
.69206 .25163 .69574 .25478 .69889 .25137 .69521 .24822 Mtetra
.646 .621 .81 r
.69521 .24822 .69889 .25137 .7021 .24939 .69842 .24623 Mtetra
.55 .607 .863 r
.69842 .24623 .7021 .24939 .70537 .24884 .70169 .24568 Mtetra
.33 .54 .906 r
.70169 .24568 .70537 .24884 .70869 .24968 .70501 .24652 Mtetra
0 .299 .779 r
.70501 .24652 .70869 .24968 .71208 .25186 .7084 .24869 Mtetra
.608 .073 0 r
.7084 .24869 .71208 .25186 .71553 .25526 .71184 .25209 Mtetra
.79 .291 0 r
.71184 .25209 .71553 .25526 .71904 .25977 .71534 .25659 Mtetra
.842 .387 .124 r
.71534 .25659 .71904 .25977 .7226 .26521 .71889 .26203 Mtetra
.858 .433 .211 r
.71889 .26203 .7226 .26521 .7262 .27142 .72249 .26824 Mtetra
.863 .456 .258 r
.72249 .26824 .7262 .27142 .72984 .2782 .72612 .27501 Mtetra
.865 .467 .281 r
.72612 .27501 .72984 .2782 .73352 .28533 .72979 .28214 Mtetra
.865 .47 .287 r
.72979 .28214 .73352 .28533 .73721 .2926 .73348 .2894 Mtetra
.865 .466 .279 r
.73348 .2894 .73721 .2926 .74092 .29978 .73718 .29657 Mtetra
.86 .535 .435 r
.29193 .57188 .29542 .57514 .29778 .58221 .29429 .57895 Mtetra
.86 .537 .44 r
.29429 .57895 .29778 .58221 .30015 .58943 .29665 .58617 Mtetra
.86 .536 .436 r
.29665 .58617 .30015 .58943 .30254 .59659 .29903 .59332 Mtetra
.862 .531 .424 r
.29903 .59332 .30254 .59659 .30494 .60347 .30143 .6002 Mtetra
.865 .521 .399 r
.30143 .6002 .30494 .60347 .30738 .60986 .30386 .60658 Mtetra
.869 .503 .352 r
.30386 .60658 .30738 .60986 .30984 .61556 .30632 .61227 Mtetra
.868 .464 .262 r
.30632 .61227 .30984 .61556 .31234 .62037 .30881 .61707 Mtetra
.831 .36 .057 r
.30881 .61707 .31234 .62037 .31489 .62412 .31135 .62082 Mtetra
.549 .029 0 r
.31135 .62082 .31489 .62412 .31748 .62667 .31394 .62338 Mtetra
.165 .445 .876 r
.31394 .62338 .31748 .62667 .32012 .62792 .31657 .62461 Mtetra
.514 .578 .857 r
.31657 .62461 .32012 .62792 .3228 .62777 .31925 .62446 Mtetra
.632 .601 .8 r
.31925 .62446 .3228 .62777 .32553 .62618 .32198 .62287 Mtetra
.684 .605 .761 r
.32198 .62287 .32553 .62618 .32831 .62316 .32476 .61985 Mtetra
.712 .605 .736 r
.32476 .61985 .32831 .62316 .33112 .61875 .32757 .61544 Mtetra
.728 .605 .719 r
.32757 .61544 .33112 .61875 .33398 .61302 .33043 .6097 Mtetra
.739 .604 .707 r
.33043 .6097 .33398 .61302 .33686 .60609 .33332 .60278 Mtetra
.746 .603 .699 r
.33332 .60278 .33686 .60609 .33978 .59813 .33623 .59481 Mtetra
.75 .602 .693 r
.33623 .59481 .33978 .59813 .34271 .58931 .33917 .586 Mtetra
.753 .602 .689 r
.33917 .586 .34271 .58931 .34566 .57986 .34212 .57654 Mtetra
.755 .602 .687 r
.34212 .57654 .34566 .57986 .34861 .57 .34507 .56668 Mtetra
.756 .602 .686 r
.34507 .56668 .34861 .57 .35156 .55999 .34803 .55667 Mtetra
.755 .602 .686 r
.34803 .55667 .35156 .55999 .35451 .55007 .35098 .54675 Mtetra
.754 .602 .688 r
.35098 .54675 .35451 .55007 .35745 .5405 .35392 .53718 Mtetra
.751 .602 .692 r
.35392 .53718 .35745 .5405 .36037 .53151 .35684 .5282 Mtetra
.747 .603 .697 r
.35684 .5282 .36037 .53151 .36326 .52333 .35974 .52002 Mtetra
.741 .603 .705 r
.35974 .52002 .36326 .52333 .36614 .51616 .36261 .51284 Mtetra
.731 .604 .716 r
.36261 .51284 .36614 .51616 .36898 .51015 .36546 .50683 Mtetra
.716 .605 .731 r
.36546 .50683 .36898 .51015 .3718 .50542 .36828 .5021 Mtetra
.692 .605 .754 r
.36828 .5021 .3718 .50542 .37459 .50207 .37107 .49875 Mtetra
.648 .602 .789 r
.37107 .49875 .37459 .50207 .37735 .50012 .37383 .4968 Mtetra
.56 .587 .838 r
.37383 .4968 .37735 .50012 .38009 .49956 .37657 .49623 Mtetra
.345 .521 .886 r
.37657 .49623 .38009 .49956 .38281 .50031 .37928 .49697 Mtetra
0 .262 .759 r
.37928 .49697 .38281 .50031 .38551 .50225 .38198 .49891 Mtetra
.655 .133 0 r
.38198 .49891 .38551 .50225 .38821 .50522 .38467 .50188 Mtetra
.814 .329 0 r
.38467 .50188 .38821 .50522 .39089 .509 .38735 .50565 Mtetra
.852 .402 .13 r
.38735 .50565 .39089 .509 .39357 .51333 .39003 .50998 Mtetra
.861 .426 .178 r
.39003 .50998 .39357 .51333 .39626 .51794 .39271 .51458 Mtetra
.859 .422 .17 r
.39271 .51458 .39626 .51794 .39896 .52252 .3954 .51916 Mtetra
.845 .387 .102 r
.3954 .51916 .39896 .52252 .40168 .52676 .39811 .5234 Mtetra
.786 .287 0 r
.39811 .5234 .40168 .52676 .40441 .53038 .40084 .52701 Mtetra
.534 .018 0 r
.40084 .52701 .40441 .53038 .40717 .53309 .4036 .52971 Mtetra
.058 .388 .849 r
.4036 .52971 .40717 .53309 .40996 .53467 .40637 .53129 Mtetra
.452 .559 .873 r
.40637 .53129 .40996 .53467 .41276 .53493 .40918 .53155 Mtetra
.604 .596 .816 r
.40918 .53155 .41276 .53493 .4156 .53378 .41201 .53039 Mtetra
.67 .604 .773 r
.41201 .53039 .4156 .53378 .41846 .53117 .41487 .52778 Mtetra
.703 .606 .745 r
.41487 .52778 .41846 .53117 .42134 .52716 .41775 .52377 Mtetra
.722 .605 .726 r
.41775 .52377 .42134 .52716 .42423 .52189 .42065 .51849 Mtetra
.733 .605 .714 r
.42065 .51849 .42423 .52189 .42714 .51557 .42356 .51218 Mtetra
.74 .604 .707 r
.42356 .51218 .42714 .51557 .43006 .5085 .42648 .50511 Mtetra
.743 .604 .703 r
.42648 .50511 .43006 .5085 .43298 .50102 .4294 .49763 Mtetra
.4294 .49763 .43298 .50102 .4359 .49351 .43232 .49011 Mtetra
.74 .604 .706 r
.43232 .49011 .4359 .49351 .43882 .48635 .43524 .48295 Mtetra
.735 .605 .713 r
.43524 .48295 .43882 .48635 .44173 .47991 .43815 .47651 Mtetra
.724 .605 .724 r
.43815 .47651 .44173 .47991 .44462 .4745 .44104 .4711 Mtetra
.705 .606 .743 r
.44104 .4711 .44462 .4745 .44751 .47038 .44393 .46697 Mtetra
.672 .604 .771 r
.44393 .46697 .44751 .47038 .45039 .46767 .44681 .46427 Mtetra
.61 .597 .813 r
.44681 .46427 .45039 .46767 .45326 .4664 .44968 .463 Mtetra
.486 .568 .864 r
.44968 .463 .45326 .4664 .45613 .46646 .45254 .46305 Mtetra
.254 .482 .885 r
.45254 .46305 .45613 .46646 .45899 .46758 .4554 .46416 Mtetra
0 .342 .82 r
.4554 .46416 .45899 .46758 .46186 .46939 .45827 .46597 Mtetra
0 .279 .774 r
.45827 .46597 .46186 .46939 .46474 .47142 .46114 .46799 Mtetra
.025 .369 .838 r
.46114 .46799 .46474 .47142 .46762 .47313 .46402 .46971 Mtetra
.319 .51 .887 r
.46402 .46971 .46762 .47313 .47052 .47404 .46691 .47061 Mtetra
.532 .58 .849 r
.46691 .47061 .47052 .47404 .47343 .47372 .46982 .47029 Mtetra
.637 .601 .797 r
.46982 .47029 .47343 .47372 .47634 .47194 .47273 .4685 Mtetra
.686 .605 .76 r
.47273 .4685 .47634 .47194 .47927 .46869 .47566 .46524 Mtetra
.709 .606 .739 r
.47566 .46524 .47927 .46869 .4822 .46426 .47859 .46082 Mtetra
.718 .606 .73 r
.47859 .46082 .4822 .46426 .48514 .45924 .48153 .45579 Mtetra
.716 .606 .733 r
.48153 .45579 .48514 .45924 .48808 .45438 .48446 .45093 Mtetra
.7 .606 .748 r
.48446 .45093 .48808 .45438 .49101 .45047 .4874 .44702 Mtetra
.661 .604 .78 r
.4874 .44702 .49101 .45047 .49395 .44808 .49034 .44462 Mtetra
.587 .593 .825 r
.49034 .44462 .49395 .44808 .49689 .44713 .49328 .44367 Mtetra
.547 .584 .843 r
.49328 .44367 .49689 .44713 .49984 .44665 .49622 .44319 Mtetra
.632 .6 .799 r
.49622 .44319 .49984 .44665 .50279 .44494 .49917 .44147 Mtetra
.679 .605 .766 r
.49917 .44147 .50279 .44494 .50575 .44194 .50212 .43848 Mtetra
.632 .6 .799 r
.50212 .43848 .50575 .44194 .50871 .44022 .50508 .43675 Mtetra
.547 .584 .843 r
.50508 .43675 .50871 .44022 .51168 .43974 .50805 .43627 Mtetra
.587 .593 .825 r
.50805 .43627 .51168 .43974 .51465 .43878 .51102 .4353 Mtetra
.661 .604 .78 r
.51102 .4353 .51465 .43878 .51762 .43636 .51399 .43288 Mtetra
.7 .606 .748 r
.51399 .43288 .51762 .43636 .52059 .43242 .51696 .42894 Mtetra
.716 .606 .733 r
.51696 .42894 .52059 .43242 .52356 .42751 .51993 .42403 Mtetra
.718 .606 .73 r
.51993 .42403 .52356 .42751 .52652 .42244 .52289 .41895 Mtetra
.709 .606 .739 r
.52289 .41895 .52652 .42244 .5295 .41796 .52586 .41448 Mtetra
.686 .605 .76 r
.52586 .41448 .5295 .41796 .53248 .41466 .52884 .41117 Mtetra
.637 .601 .796 r
.52884 .41117 .53248 .41466 .53547 .41281 .53184 .40931 Mtetra
.537 .581 .846 r
.53184 .40931 .53547 .41281 .53848 .41242 .53484 .40893 Mtetra
.345 .519 .885 r
.53484 .40893 .53848 .41242 .54151 .41327 .53787 .40977 Mtetra
.09 .402 .856 r
.53787 .40977 .54151 .41327 .54455 .41494 .5409 .41143 Mtetra
0 .327 .811 r
.5409 .41143 .54455 .41494 .5476 .41693 .54395 .41342 Mtetra
.048 .379 .844 r
.54395 .41342 .5476 .41693 .55066 .41871 .547 .4152 Mtetra
.287 .495 .885 r
.547 .4152 .55066 .41871 .55372 .4198 .55006 .41628 Mtetra
.493 .569 .861 r
.55006 .41628 .55372 .4198 .55677 .4198 .55311 .41628 Mtetra
.61 .597 .813 r
.55311 .41628 .55677 .4198 .55982 .41846 .55616 .41493 Mtetra
.672 .605 .772 r
.55616 .41493 .55982 .41846 .56285 .41564 .55919 .41211 Mtetra
.705 .606 .744 r
.55919 .41211 .56285 .41564 .56587 .41136 .56221 .40783 Mtetra
.724 .606 .725 r
.56221 .40783 .56587 .41136 .56888 .40577 .56521 .40224 Mtetra
.736 .606 .713 r
.56521 .40224 .56888 .40577 .57187 .39912 .56821 .39559 Mtetra
.742 .605 .706 r
.56821 .39559 .57187 .39912 .57485 .39175 .57119 .38821 Mtetra
.745 .605 .703 r
.57119 .38821 .57485 .39175 .57782 .38402 .57416 .38049 Mtetra
.744 .605 .703 r
.57416 .38049 .57782 .38402 .5808 .37634 .57714 .37281 Mtetra
.741 .605 .707 r
.57714 .37281 .5808 .37634 .58378 .36908 .58012 .36555 Mtetra
.734 .606 .714 r
.58012 .36555 .58378 .36908 .58676 .36258 .58311 .35905 Mtetra
.723 .606 .726 r
.58311 .35905 .58676 .36258 .58977 .35713 .58611 .35359 Mtetra
.703 .606 .745 r
.58611 .35359 .58977 .35713 .5928 .35294 .58914 .34939 Mtetra
.67 .604 .773 r
.58914 .34939 .5928 .35294 .59585 .35014 .5922 .34659 Mtetra
.61 .596 .812 r
.5922 .34659 .59585 .35014 .59894 .34878 .59528 .34523 Mtetra
.485 .566 .862 r
.59528 .34523 .59894 .34878 .60206 .34885 .5984 .3453 Mtetra
.213 .461 .878 r
.5984 .3453 .60206 .34885 .60521 .35024 .60154 .34668 Mtetra
0 .193 .701 r
.60154 .34668 .60521 .35024 .60839 .35278 .60472 .34922 Mtetra
.617 .099 0 r
.60472 .34922 .60839 .35278 .61161 .35626 .60793 .3527 Mtetra
.758 .252 0 r
.60793 .3527 .61161 .35626 .61484 .36041 .61116 .35683 Mtetra
.802 .311 0 r
.61116 .35683 .61484 .36041 .6181 .36492 .61441 .36135 Mtetra
.806 .318 0 r
.61441 .36135 .6181 .36492 .62137 .3695 .61768 .36592 Mtetra
.777 .277 0 r
.61768 .36592 .62137 .3695 .62465 .37383 .62095 .37025 Mtetra
.68 .162 0 r
.62095 .37025 .62465 .37383 .62792 .37762 .62422 .37402 Mtetra
0 .079 .584 r
.62422 .37402 .62792 .37762 .63119 .38058 .62748 .37698 Mtetra
.047 .378 .843 r
.62748 .37698 .63119 .38058 .63444 .38249 .63073 .37889 Mtetra
.395 .537 .88 r
.63073 .37889 .63444 .38249 .63767 .38315 .63395 .37954 Mtetra
.565 .588 .835 r
.63395 .37954 .63767 .38315 .64088 .38243 .63715 .37882 Mtetra
.647 .602 .79 r
.63715 .37882 .64088 .38243 .64404 .38024 .64032 .37663 Mtetra
.691 .606 .757 r
.64032 .37663 .64404 .38024 .64718 .37657 .64345 .37295 Mtetra
.717 .607 .733 r
.64345 .37295 .64718 .37657 .65028 .37145 .64655 .36783 Mtetra
.733 .607 .716 r
.64655 .36783 .65028 .37145 .65334 .36497 .64961 .36135 Mtetra
.744 .606 .704 r
.64961 .36135 .65334 .36497 .65636 .35727 .65264 .35364 Mtetra
.751 .605 .696 r
.65264 .35364 .65636 .35727 .65935 .34852 .65563 .3449 Mtetra
.756 .605 .69 r
.65563 .3449 .65935 .34852 .66232 .33896 .6586 .33533 Mtetra
.759 .605 .686 r
.6586 .33533 .66232 .33896 .66526 .32881 .66155 .32519 Mtetra
.761 .604 .684 r
.66155 .32519 .66526 .32881 .66819 .31833 .66448 .31471 Mtetra
.761 .604 .683 r
.66448 .31471 .66819 .31833 .67112 .30778 .66741 .30416 Mtetra
.761 .604 .684 r
.66741 .30416 .67112 .30778 .67404 .29743 .67033 .2938 Mtetra
.759 .605 .687 r
.67033 .2938 .67404 .29743 .67697 .28751 .67327 .28388 Mtetra
.755 .605 .691 r
.67327 .28388 .67697 .28751 .67992 .27826 .67622 .27463 Mtetra
.749 .606 .698 r
.67622 .27463 .67992 .27826 .6829 .26988 .6792 .26625 Mtetra
.741 .606 .707 r
.6792 .26625 .6829 .26988 .68591 .26256 .68222 .25893 Mtetra
.73 .607 .72 r
.68222 .25893 .68591 .26256 .68896 .25644 .68527 .25281 Mtetra
.712 .607 .737 r
.68527 .25281 .68896 .25644 .69206 .25163 .68837 .248 Mtetra
.684 .605 .762 r
.68837 .248 .69206 .25163 .69521 .24822 .69152 .24459 Mtetra
.637 .6 .795 r
.69152 .24459 .69521 .24822 .69842 .24623 .69472 .2426 Mtetra
.55 .583 .84 r
.69472 .2426 .69842 .24623 .70169 .24568 .69799 .24204 Mtetra
.367 .524 .881 r
.69799 .24204 .70169 .24568 .70501 .24652 .70131 .24287 Mtetra
0 .34 .82 r
.70131 .24287 .70501 .24652 .7084 .24869 .70469 .24504 Mtetra
.5 0 0 r
.70469 .24504 .7084 .24869 .71184 .25209 .70813 .24844 Mtetra
.755 .249 0 r
.70813 .24844 .71184 .25209 .71534 .25659 .71162 .25293 Mtetra
.837 .368 .049 r
.71162 .25293 .71534 .25659 .71889 .26203 .71516 .25836 Mtetra
.863 .424 .156 r
.71516 .25836 .71889 .26203 .72249 .26824 .71875 .26456 Mtetra
.872 .452 .213 r
.71875 .26456 .72249 .26824 .72612 .27501 .72238 .27133 Mtetra
.875 .465 .241 r
.72238 .27133 .72612 .27501 .72979 .28214 .72604 .27845 Mtetra
.876 .469 .249 r
.72604 .27845 .72979 .28214 .73348 .2894 .72972 .2857 Mtetra
.875 .464 .239 r
.72972 .2857 .73348 .2894 .73718 .29657 .73341 .29287 Mtetra
.826 .519 .47 r
.2884 .56984 .29193 .57188 .29429 .57895 .29075 .5769 Mtetra
.826 .521 .473 r
.29075 .5769 .29429 .57895 .29665 .58617 .29311 .58412 Mtetra
.826 .519 .47 r
.29311 .58412 .29665 .58617 .29903 .59332 .29548 .59127 Mtetra
.827 .515 .461 r
.29548 .59127 .29903 .59332 .30143 .6002 .29787 .59815 Mtetra
.828 .506 .445 r
.29787 .59815 .30143 .6002 .30386 .60658 .30029 .60453 Mtetra
.829 .491 .415 r
.30029 .60453 .30386 .60658 .30632 .61227 .30275 .61022 Mtetra
.828 .461 .36 r
.30275 .61022 .30632 .61227 .30881 .61707 .30524 .61502 Mtetra
.817 .398 .248 r
.30524 .61502 .30881 .61707 .31135 .62082 .30777 .61877 Mtetra
.735 .214 0 r
.30777 .61877 .31135 .62082 .31394 .62338 .31036 .62131 Mtetra
0 .352 .764 r
.31036 .62131 .31394 .62338 .31657 .62461 .31299 .62255 Mtetra
.486 .658 .937 r
.31299 .62255 .31657 .62461 .31925 .62446 .31567 .6224 Mtetra
.657 .665 .846 r
.31567 .6224 .31925 .62446 .32198 .62287 .31839 .62081 Mtetra
.713 .652 .787 r
.31839 .62081 .32198 .62287 .32476 .61985 .32117 .61778 Mtetra
.738 .641 .752 r
.32117 .61778 .32476 .61985 .32757 .61544 .32398 .61336 Mtetra
.752 .634 .73 r
.32398 .61336 .32757 .61544 .33043 .6097 .32684 .60763 Mtetra
.76 .629 .715 r
.32684 .60763 .33043 .6097 .33332 .60278 .32973 .6007 Mtetra
.765 .625 .705 r
.32973 .6007 .33332 .60278 .33623 .59481 .33265 .59273 Mtetra
.768 .622 .698 r
.33265 .59273 .33623 .59481 .33917 .586 .33559 .58391 Mtetra
.77 .621 .694 r
.33559 .58391 .33917 .586 .34212 .57654 .33854 .57446 Mtetra
.772 .62 .691 r
.33854 .57446 .34212 .57654 .34507 .56668 .3415 .56459 Mtetra
.772 .619 .69 r
.3415 .56459 .34507 .56668 .34803 .55667 .34446 .55458 Mtetra
.34446 .55458 .34803 .55667 .35098 .54675 .34742 .54466 Mtetra
.771 .62 .693 r
.34742 .54466 .35098 .54675 .35392 .53718 .35036 .53508 Mtetra
.769 .622 .696 r
.35036 .53508 .35392 .53718 .35684 .5282 .35328 .52609 Mtetra
.766 .624 .703 r
.35328 .52609 .35684 .5282 .35974 .52002 .35618 .51791 Mtetra
.761 .627 .712 r
.35618 .51791 .35974 .52002 .36261 .51284 .35906 .51073 Mtetra
.754 .632 .725 r
.35906 .51073 .36261 .51284 .36546 .50683 .36191 .50472 Mtetra
.741 .639 .746 r
.36191 .50472 .36546 .50683 .36828 .5021 .36473 .49999 Mtetra
.72 .648 .777 r
.36473 .49999 .36828 .5021 .37107 .49875 .36752 .49663 Mtetra
.675 .66 .827 r
.36752 .49663 .37107 .49875 .37383 .4968 .37028 .49468 Mtetra
.56 .663 .906 r
.37028 .49468 .37383 .4968 .37657 .49623 .37301 .49411 Mtetra
.173 .547 .928 r
.37301 .49411 .37657 .49623 .37928 .49697 .37572 .49485 Mtetra
.531 0 0 r
.37572 .49485 .37928 .49697 .38198 .49891 .37842 .49679 Mtetra
.77 .273 .034 r
.37842 .49679 .38198 .49891 .38467 .50188 .3811 .49975 Mtetra
.815 .38 .209 r
.3811 .49975 .38467 .50188 .38735 .50565 .38378 .50352 Mtetra
.826 .422 .282 r
.38378 .50352 .38735 .50565 .39003 .50998 .38645 .50785 Mtetra
.829 .437 .309 r
.38645 .50785 .39003 .50998 .39271 .51458 .38913 .51245 Mtetra
.829 .435 .304 r
.38913 .51245 .39271 .51458 .3954 .51916 .39182 .51702 Mtetra
.824 .414 .267 r
.39182 .51702 .3954 .51916 .39811 .5234 .39452 .52126 Mtetra
.807 .357 .171 r
.39452 .52126 .39811 .5234 .40084 .52701 .39725 .52487 Mtetra
.729 .204 0 r
.39725 .52487 .40084 .52701 .4036 .52971 .4 .52758 Mtetra
0 .239 .65 r
.4 .52758 .4036 .52971 .40637 .53129 .40277 .52915 Mtetra
.378 .628 .951 r
.40277 .52915 .40637 .53129 .40918 .53155 .40558 .52941 Mtetra
.622 .666 .872 r
.40558 .52941 .40918 .53155 .41201 .53039 .40841 .52824 Mtetra
.699 .656 .804 r
.40841 .52824 .41201 .53039 .41487 .52778 .41126 .52563 Mtetra
.731 .645 .764 r
.41126 .52563 .41487 .52778 .41775 .52377 .41414 .52162 Mtetra
.747 .638 .739 r
.41414 .52162 .41775 .52377 .42065 .51849 .41704 .51634 Mtetra
.756 .633 .724 r
.41704 .51634 .42065 .51849 .42356 .51218 .41995 .51002 Mtetra
.761 .63 .715 r
.41995 .51002 .42356 .51218 .42648 .50511 .42287 .50295 Mtetra
.764 .628 .71 r
.42287 .50295 .42648 .50511 .4294 .49763 .4258 .49547 Mtetra
.4258 .49547 .4294 .49763 .43232 .49011 .42872 .48795 Mtetra
.762 .629 .714 r
.42872 .48795 .43232 .49011 .43524 .48295 .43164 .48079 Mtetra
.757 .632 .722 r
.43164 .48079 .43524 .48295 .43815 .47651 .43455 .47434 Mtetra
.749 .637 .737 r
.43455 .47434 .43815 .47651 .44104 .4711 .43745 .46893 Mtetra
.732 .644 .761 r
.43745 .46893 .44104 .4711 .44393 .46697 .44034 .4648 Mtetra
.701 .655 .801 r
.44034 .4648 .44393 .46697 .44681 .46427 .44321 .46209 Mtetra
.629 .665 .865 r
.44321 .46209 .44681 .46427 .44968 .463 .44608 .46082 Mtetra
.441 .642 .942 r
.44608 .46082 .44968 .463 .45254 .46305 .44894 .46086 Mtetra
.002 .455 .866 r
.44894 .46086 .45254 .46305 .4554 .46416 .4518 .46198 Mtetra
.403 0 0 r
.4518 .46198 .4554 .46416 .45827 .46597 .45466 .46378 Mtetra
.504 0 0 r
.45466 .46378 .45827 .46597 .46114 .46799 .45753 .4658 Mtetra
0 .209 .622 r
.45753 .4658 .46114 .46799 .46402 .46971 .46041 .46752 Mtetra
.125 .521 .914 r
.46041 .46752 .46402 .46971 .46691 .47061 .4633 .46842 Mtetra
.517 .658 .923 r
.4633 .46842 .46691 .47061 .46982 .47029 .4662 .46809 Mtetra
.662 .663 .84 r
.4662 .46809 .46982 .47029 .47273 .4685 .46912 .4663 Mtetra
.715 .652 .785 r
.46912 .4663 .47273 .4685 .47566 .46524 .47204 .46305 Mtetra
.736 .644 .756 r
.47204 .46305 .47566 .46524 .47859 .46082 .47497 .45862 Mtetra
.744 .64 .745 r
.47497 .45862 .47859 .46082 .48153 .45579 .47791 .45359 Mtetra
.742 .641 .748 r
.47791 .45359 .48153 .45579 .48446 .45093 .48085 .44872 Mtetra
.728 .647 .768 r
.48085 .44872 .48446 .45093 .4874 .44702 .48378 .44481 Mtetra
.689 .658 .814 r
.48378 .44481 .4874 .44702 .49034 .44462 .48672 .44241 Mtetra
.599 .665 .885 r
.48672 .44241 .49034 .44462 .49328 .44367 .48966 .44145 Mtetra
.541 .66 .914 r
.48966 .44145 .49328 .44367 .49622 .44319 .4926 .44098 Mtetra
.657 .663 .844 r
.4926 .44098 .49622 .44319 .49917 .44147 .49555 .43925 Mtetra
.707 .654 .794 r
.49555 .43925 .49917 .44147 .50212 .43848 .4985 .43625 Mtetra
.657 .663 .844 r
.4985 .43625 .50212 .43848 .50508 .43675 .50146 .43453 Mtetra
.542 .66 .913 r
.50146 .43453 .50508 .43675 .50805 .43627 .50442 .43404 Mtetra
.599 .664 .885 r
.50442 .43404 .50805 .43627 .51102 .4353 .50739 .43307 Mtetra
.689 .658 .815 r
.50739 .43307 .51102 .4353 .51399 .43288 .51036 .43065 Mtetra
.728 .647 .769 r
.51036 .43065 .51399 .43288 .51696 .42894 .51333 .4267 Mtetra
.743 .642 .748 r
.51333 .4267 .51696 .42894 .51993 .42403 .5163 .42179 Mtetra
.745 .641 .745 r
.5163 .42179 .51993 .42403 .52289 .41895 .51926 .41671 Mtetra
.737 .644 .757 r
.51926 .41671 .52289 .41895 .52586 .41448 .52224 .41223 Mtetra
.715 .652 .785 r
.52224 .41223 .52586 .41448 .52884 .41117 .52522 .40892 Mtetra
.662 .662 .839 r
.52522 .40892 .52884 .41117 .53184 .40931 .52821 .40707 Mtetra
.526 .657 .918 r
.52821 .40707 .53184 .40931 .53484 .40893 .53121 .40668 Mtetra
.182 .545 .928 r
.53121 .40668 .53484 .40893 .53787 .40977 .53423 .40751 Mtetra
0 .279 .704 r
.53423 .40751 .53787 .40977 .5409 .41143 .53726 .40918 Mtetra
.419 0 0 r
.53726 .40918 .5409 .41143 .54395 .41342 .54031 .41116 Mtetra
0 .236 .657 r
.54031 .41116 .54395 .41342 .547 .4152 .54336 .41293 Mtetra
.07 .489 .894 r
.54336 .41293 .547 .4152 .55006 .41628 .54641 .41402 Mtetra
.454 .643 .939 r
.54641 .41402 .55006 .41628 .55311 .41628 .54946 .41402 Mtetra
.629 .664 .865 r
.54946 .41402 .55311 .41628 .55616 .41493 .5525 .41267 Mtetra
.7 .656 .803 r
.5525 .41267 .55616 .41493 .55919 .41211 .55554 .40984 Mtetra
.733 .646 .763 r
.55554 .40984 .55919 .41211 .56221 .40783 .55856 .40556 Mtetra
.75 .639 .738 r
.55856 .40556 .56221 .40783 .56521 .40224 .56156 .39996 Mtetra
.759 .634 .723 r
.56156 .39996 .56521 .40224 .56821 .39559 .56456 .39331 Mtetra
.764 .632 .714 r
.56456 .39331 .56821 .39559 .57119 .38821 .56754 .38593 Mtetra
.766 .63 .71 r
.56754 .38593 .57119 .38821 .57416 .38049 .57052 .3782 Mtetra
.766 .631 .71 r
.57052 .3782 .57416 .38049 .57714 .37281 .5735 .37052 Mtetra
.764 .632 .715 r
.5735 .37052 .57714 .37281 .58012 .36555 .57648 .36325 Mtetra
.758 .635 .724 r
.57648 .36325 .58012 .36555 .58311 .35905 .57947 .35675 Mtetra
.749 .64 .74 r
.57947 .35675 .58311 .35905 .58611 .35359 .58248 .35129 Mtetra
.731 .647 .765 r
.58248 .35129 .58611 .35359 .58914 .34939 .5855 .34709 Mtetra
.699 .656 .804 r
.5855 .34709 .58914 .34939 .5922 .34659 .58856 .34429 Mtetra
.628 .663 .864 r
.58856 .34429 .5922 .34659 .59528 .34523 .59164 .34293 Mtetra
.442 .637 .939 r
.59164 .34293 .59528 .34523 .5984 .3453 .59475 .34299 Mtetra
0 .413 .836 r
.59475 .34299 .5984 .3453 .60154 .34668 .5979 .34437 Mtetra
.586 .02 0 r
.5979 .34437 .60154 .34668 .60472 .34922 .60107 .34691 Mtetra
.759 .248 0 r
.60107 .34691 .60472 .34922 .60793 .3527 .60427 .35038 Mtetra
.805 .337 .116 r
.60427 .35038 .60793 .3527 .61116 .35683 .6075 .35452 Mtetra
.818 .37 .172 r
.6075 .35452 .61116 .35683 .61441 .36135 .61075 .35903 Mtetra
.819 .374 .178 r
.61075 .35903 .61441 .36135 .61768 .36592 .614 .3636 Mtetra
.81 .351 .139 r
.614 .3636 .61768 .36592 .62095 .37025 .61727 .36792 Mtetra
.78 .286 .034 r
.61727 .36792 .62095 .37025 .62422 .37402 .62053 .3717 Mtetra
.674 .125 0 r
.62053 .3717 .62422 .37402 .62748 .37698 .62379 .37465 Mtetra
0 .239 .664 r
.62379 .37465 .62748 .37698 .63073 .37889 .62704 .37656 Mtetra
.278 .585 .944 r
.62704 .37656 .63073 .37889 .63395 .37954 .63026 .37721 Mtetra
.567 .662 .901 r
.63026 .37721 .63395 .37954 .63715 .37882 .63346 .37648 Mtetra
.674 .662 .83 r
.63346 .37648 .63715 .37882 .64032 .37663 .63662 .37429 Mtetra
.72 .652 .781 r
.63662 .37429 .64032 .37663 .64345 .37295 .63976 .37061 Mtetra
.744 .644 .749 r
.63976 .37061 .64345 .37295 .64655 .36783 .64285 .36548 Mtetra
.758 .637 .727 r
.64285 .36548 .64655 .36783 .64961 .36135 .64592 .359 Mtetra
.767 .633 .712 r
.64592 .359 .64961 .36135 .65264 .35364 .64895 .35129 Mtetra
.773 .629 .702 r
.64895 .35129 .65264 .35364 .65563 .3449 .65195 .34255 Mtetra
.776 .627 .695 r
.65195 .34255 .65563 .3449 .6586 .33533 .65492 .33298 Mtetra
.779 .625 .69 r
.65492 .33298 .6586 .33533 .66155 .32519 .65787 .32282 Mtetra
.78 .625 .688 r
.65787 .32282 .66155 .32519 .66448 .31471 .66081 .31234 Mtetra
.78 .624 .687 r
.66081 .31234 .66448 .31471 .66741 .30416 .66374 .30179 Mtetra
.78 .625 .688 r
.66374 .30179 .66741 .30416 .67033 .2938 .66667 .29143 Mtetra
.778 .626 .691 r
.66667 .29143 .67033 .2938 .67327 .28388 .66961 .28151 Mtetra
.775 .628 .697 r
.66961 .28151 .67327 .28388 .67622 .27463 .67256 .27225 Mtetra
.771 .63 .704 r
.67256 .27225 .67622 .27463 .6792 .26625 .67555 .26387 Mtetra
.765 .634 .716 r
.67555 .26387 .6792 .26625 .68222 .25893 .67856 .25655 Mtetra
.755 .638 .732 r
.67856 .25655 .68222 .25893 .68527 .25281 .68161 .25042 Mtetra
.74 .645 .754 r
.68161 .25042 .68527 .25281 .68837 .248 .68471 .24561 Mtetra
.713 .652 .788 r
.68471 .24561 .68837 .248 .69152 .24459 .68786 .24219 Mtetra
.662 .66 .837 r
.68786 .24219 .69152 .24459 .69472 .2426 .69107 .2402 Mtetra
.546 .655 .907 r
.69107 .2402 .69472 .2426 .69799 .24204 .69433 .23964 Mtetra
.234 .56 .935 r
.69433 .23964 .69799 .24204 .70131 .24287 .69765 .24047 Mtetra
0 .185 .613 r
.69765 .24047 .70131 .24287 .70469 .24504 .70102 .24264 Mtetra
.712 .176 0 r
.70102 .24264 .70469 .24504 .70813 .24844 .70446 .24603 Mtetra
.806 .334 .1 r
.70446 .24603 .70813 .24844 .71162 .25293 .70795 .25052 Mtetra
.832 .403 .218 r
.70795 .25052 .71162 .25293 .71516 .25836 .71148 .25595 Mtetra
.841 .438 .281 r
.71148 .25595 .71516 .25836 .71875 .26456 .71507 .26215 Mtetra
.844 .457 .315 r
.71507 .26215 .71875 .26456 .72238 .27133 .71869 .26891 Mtetra
.845 .466 .332 r
.71869 .26891 .72238 .27133 .72604 .27845 .72234 .27603 Mtetra
.846 .469 .337 r
.72234 .27603 .72604 .27845 .72972 .2857 .72601 .28328 Mtetra
.845 .466 .331 r
.72601 .28328 .72972 .2857 .73341 .29287 .7297 .29045 Mtetra
.796 .504 .494 r
.28483 .56902 .2884 .56984 .29075 .5769 .28717 .57609 Mtetra
.796 .505 .496 r
.28717 .57609 .29075 .5769 .29311 .58412 .28952 .58331 Mtetra
.796 .504 .494 r
.28952 .58331 .29311 .58412 .29548 .59127 .29189 .59047 Mtetra
.795 .5 .488 r
.29189 .59047 .29548 .59127 .29787 .59815 .29427 .59734 Mtetra
.794 .491 .476 r
.29427 .59734 .29787 .59815 .30029 .60453 .29669 .60373 Mtetra
.792 .477 .456 r
.29669 .60373 .30029 .60453 .30275 .61022 .29913 .60942 Mtetra
.787 .452 .421 r
.29913 .60942 .30275 .61022 .30524 .61502 .30162 .61422 Mtetra
.774 .404 .355 r
.30162 .61422 .30524 .61502 .30777 .61877 .30415 .61797 Mtetra
.734 .294 .206 r
.30415 .61797 .30777 .61877 .31036 .62131 .30673 .62052 Mtetra
.517 0 0 r
.30673 .62052 .31036 .62131 .31299 .62255 .30936 .62176 Mtetra
.353 .747 .985 r
.30936 .62176 .31299 .62255 .31567 .6224 .31204 .6216 Mtetra
.688 .767 .911 r
.31204 .6216 .31567 .6224 .31839 .62081 .31476 .62001 Mtetra
.752 .718 .821 r
.31476 .62001 .31839 .62081 .32117 .61778 .31754 .61698 Mtetra
.772 .689 .772 r
.31754 .61698 .32117 .61778 .32398 .61336 .32035 .61256 Mtetra
.78 .671 .742 r
.32035 .61256 .32398 .61336 .32684 .60763 .32321 .60682 Mtetra
.785 .659 .724 r
.32321 .60682 .32684 .60763 .32973 .6007 .3261 .59989 Mtetra
.788 .651 .712 r
.3261 .59989 .32973 .6007 .33265 .59273 .32902 .59192 Mtetra
.789 .646 .704 r
.32902 .59192 .33265 .59273 .33559 .58391 .33197 .58309 Mtetra
.79 .643 .698 r
.33197 .58309 .33559 .58391 .33854 .57446 .33492 .57363 Mtetra
.791 .641 .695 r
.33492 .57363 .33854 .57446 .3415 .56459 .33789 .56376 Mtetra
.791 .64 .694 r
.33789 .56376 .3415 .56459 .34446 .55458 .34086 .55374 Mtetra
.791 .64 .695 r
.34086 .55374 .34446 .55458 .34742 .54466 .34381 .54381 Mtetra
.791 .642 .697 r
.34381 .54381 .34742 .54466 .35036 .53508 .34676 .53423 Mtetra
.79 .645 .702 r
.34676 .53423 .35036 .53508 .35328 .52609 .34969 .52524 Mtetra
.788 .649 .709 r
.34969 .52524 .35328 .52609 .35618 .51791 .35259 .51705 Mtetra
.786 .656 .72 r
.35259 .51705 .35618 .51791 .35906 .51073 .35547 .50986 Mtetra
.781 .667 .737 r
.35547 .50986 .35906 .51073 .36191 .50472 .35832 .50384 Mtetra
.773 .682 .763 r
.35832 .50384 .36191 .50472 .36473 .49999 .36114 .49911 Mtetra
.757 .707 .806 r
.36114 .49911 .36473 .49999 .36752 .49663 .36393 .49576 Mtetra
.711 .748 .881 r
.36393 .49576 .36752 .49663 .37028 .49468 .36669 .4938 Mtetra
.523 .78 .991 r
.36669 .4938 .37028 .49468 .37301 .49411 .36943 .49323 Mtetra
.222 0 0 r
.36943 .49323 .37301 .49411 .37572 .49485 .37214 .49397 Mtetra
.668 .155 .01 r
.37214 .49397 .37572 .49485 .37842 .49679 .37483 .49591 Mtetra
.753 .327 .239 r
.37483 .49591 .37842 .49679 .3811 .49975 .37751 .49887 Mtetra
.776 .393 .33 r
.37751 .49887 .3811 .49975 .38378 .50352 .38018 .50265 Mtetra
.785 .423 .371 r
.38018 .50265 .38378 .50352 .38645 .50785 .38285 .50697 Mtetra
.787 .434 .387 r
.38285 .50697 .38645 .50785 .38913 .51245 .38552 .51157 Mtetra
.787 .432 .384 r
.38552 .51157 .38913 .51245 .39182 .51702 .38821 .51615 Mtetra
.783 .416 .362 r
.38821 .51615 .39182 .51702 .39452 .52126 .39091 .52039 Mtetra
.771 .378 .31 r
.39091 .52039 .39452 .52126 .39725 .52487 .39363 .524 Mtetra
.737 .289 .188 r
.39363 .524 .39725 .52487 .4 .52758 .39637 .52671 Mtetra
.586 .027 0 r
.39637 .52671 .4 .52758 .40277 .52915 .39915 .52828 Mtetra
.122 .631 .898 r
.39915 .52828 .40277 .52915 .40558 .52941 .40195 .52853 Mtetra
.636 .78 .95 r
.40195 .52853 .40558 .52941 .40841 .52824 .40478 .52737 Mtetra
.738 .732 .846 r
.40478 .52737 .40841 .52824 .41126 .52563 .40763 .52475 Mtetra
.767 .699 .787 r
.40763 .52475 .41126 .52563 .41414 .52162 .41051 .52074 Mtetra
.779 .679 .754 r
.41051 .52074 .41414 .52162 .41704 .51634 .41341 .51546 Mtetra
.784 .668 .735 r
.41341 .51546 .41704 .51634 .41995 .51002 .41633 .50914 Mtetra
.787 .661 .724 r
.41633 .50914 .41995 .51002 .42287 .50295 .41925 .50206 Mtetra
.788 .658 .718 r
.41925 .50206 .42287 .50295 .4258 .49547 .42218 .49457 Mtetra
.789 .657 .718 r
.42218 .49457 .4258 .49547 .42872 .48795 .42511 .48705 Mtetra
.788 .66 .722 r
.42511 .48705 .42872 .48795 .43164 .48079 .42803 .47988 Mtetra
.785 .666 .733 r
.42803 .47988 .43164 .48079 .43455 .47434 .43094 .47343 Mtetra
.779 .677 .751 r
.43094 .47343 .43455 .47434 .43745 .46893 .43384 .46801 Mtetra
.768 .696 .784 r
.43384 .46801 .43745 .46893 .44034 .4648 .43673 .46388 Mtetra
.739 .728 .841 r
.43673 .46388 .44034 .4648 .44321 .46209 .43961 .46117 Mtetra
.648 .773 .94 r
.43961 .46117 .44321 .46209 .44608 .46082 .44247 .45989 Mtetra
.267 .702 .964 r
.44247 .45989 .44608 .46082 .44894 .46086 .44533 .45994 Mtetra
.396 0 0 r
.44533 .45994 .44894 .46086 .4518 .46198 .44819 .46106 Mtetra
.622 .078 0 r
.44819 .46106 .4518 .46198 .45466 .46378 .45105 .46286 Mtetra
.66 .137 0 r
.45105 .46286 .45466 .46378 .45753 .4658 .45391 .46488 Mtetra
.6 .046 0 r
.45391 .46488 .45753 .4658 .46041 .46752 .45678 .46659 Mtetra
.276 0 0 r
.45678 .46659 .46041 .46752 .4633 .46842 .45967 .46749 Mtetra
.435 .763 .996 r
.45967 .46749 .4633 .46842 .4662 .46809 .46257 .46717 Mtetra
.694 .759 .902 r
.46257 .46717 .4662 .46809 .46912 .4663 .46549 .46537 Mtetra
.753 .717 .818 r
.46549 .46537 .46912 .4663 .47204 .46305 .46841 .46212 Mtetra
.772 .694 .777 r
.46841 .46212 .47204 .46305 .47497 .45862 .47135 .45768 Mtetra
.777 .685 .762 r
.47135 .45768 .47497 .45862 .47791 .45359 .47429 .45265 Mtetra
.776 .687 .766 r
.47429 .45265 .47791 .45359 .48085 .44872 .47722 .44778 Mtetra
.765 .703 .794 r
.47722 .44778 .48085 .44872 .48378 .44481 .48016 .44387 Mtetra
.727 .74 .862 r
.48016 .44387 .48378 .44481 .48672 .44241 .4831 .44146 Mtetra
.598 .78 .967 r
.4831 .44146 .48672 .44241 .48966 .44145 .48603 .44051 Mtetra
.487 .772 .995 r
.48603 .44051 .48966 .44145 .4926 .44098 .48897 .44003 Mtetra
.688 .761 .908 r
.48897 .44003 .4926 .44098 .49555 .43925 .49192 .4383 Mtetra
.746 .724 .831 r
.49192 .4383 .49555 .43925 .4985 .43625 .49487 .4353 Mtetra
.688 .761 .907 r
.49487 .4353 .4985 .43625 .50146 .43453 .49783 .43357 Mtetra
.488 .772 .994 r
.49783 .43357 .50146 .43453 .50442 .43404 .50079 .43308 Mtetra
.599 .78 .967 r
.50079 .43308 .50442 .43404 .50739 .43307 .50376 .43212 Mtetra
.727 .74 .862 r
.50376 .43212 .50739 .43307 .51036 .43065 .50673 .42969 Mtetra
.765 .704 .794 r
.50673 .42969 .51036 .43065 .51333 .4267 .5097 .42574 Mtetra
.776 .688 .766 r
.5097 .42574 .51333 .4267 .5163 .42179 .51267 .42083 Mtetra
.778 .686 .762 r
.51267 .42083 .5163 .42179 .51926 .41671 .51564 .41574 Mtetra
.772 .695 .778 r
.51564 .41574 .51926 .41671 .52224 .41223 .51861 .41126 Mtetra
.753 .717 .819 r
.51861 .41126 .52224 .41223 .52522 .40892 .52159 .40794 Mtetra
.695 .757 .899 r
.52159 .40794 .52522 .40892 .52821 .40707 .52458 .40609 Mtetra
.459 .765 .996 r
.52458 .40609 .52821 .40707 .53121 .40668 .52758 .4057 Mtetra
.199 0 0 r
.52758 .4057 .53121 .40668 .53423 .40751 .5306 .40654 Mtetra
.559 0 0 r
.5306 .40654 .53423 .40751 .53726 .40918 .53363 .4082 Mtetra
.63 .086 0 r
.53363 .4082 .53726 .40918 .54031 .41116 .53667 .41018 Mtetra
.585 .021 0 r
.53667 .41018 .54031 .41116 .54336 .41293 .53972 .41195 Mtetra
.33 0 0 r
.53972 .41195 .54336 .41293 .54641 .41402 .54277 .41304 Mtetra
.3 .714 .975 r
.54277 .41304 .54641 .41402 .54946 .41402 .54582 .41303 Mtetra
.648 .773 .94 r
.54582 .41303 .54946 .41402 .5525 .41267 .54886 .41168 Mtetra
.74 .732 .844 r
.54886 .41168 .5525 .41267 .55554 .40984 .55189 .40885 Mtetra
.77 .701 .786 r
.55189 .40885 .55554 .40984 .55856 .40556 .55491 .40457 Mtetra
.782 .682 .753 r
.55491 .40457 .55856 .40556 .56156 .39996 .55792 .39897 Mtetra
.788 .67 .734 r
.55792 .39897 .56156 .39996 .56456 .39331 .56092 .39231 Mtetra
.791 .664 .723 r
.56092 .39231 .56456 .39331 .56754 .38593 .5639 .38493 Mtetra
.793 .661 .718 r
.5639 .38493 .56754 .38593 .57052 .3782 .56689 .37719 Mtetra
.793 .662 .719 r
.56689 .37719 .57052 .3782 .5735 .37052 .56987 .3695 Mtetra
.791 .665 .724 r
.56987 .3695 .5735 .37052 .57648 .36325 .57285 .36224 Mtetra
.788 .672 .736 r
.57285 .36224 .57648 .36325 .57947 .35675 .57584 .35573 Mtetra
.781 .683 .756 r
.57584 .35573 .57947 .35675 .58248 .35129 .57885 .35027 Mtetra
.768 .702 .789 r
.57885 .35027 .58248 .35129 .5855 .34709 .58188 .34606 Mtetra
.738 .731 .845 r
.58188 .34606 .5855 .34709 .58856 .34429 .58494 .34326 Mtetra
.647 .77 .938 r
.58494 .34326 .58856 .34429 .59164 .34293 .58802 .34189 Mtetra
.282 .702 .97 r
.58802 .34189 .59164 .34293 .59475 .34299 .59113 .34195 Mtetra
.434 0 0 r
.59113 .34195 .59475 .34299 .5979 .34437 .59427 .34334 Mtetra
.694 .186 .026 r
.59427 .34334 .5979 .34437 .60107 .34691 .59744 .34587 Mtetra
.757 .314 .198 r
.59744 .34587 .60107 .34691 .60427 .35038 .60064 .34934 Mtetra
.778 .367 .272 r
.60064 .34934 .60427 .35038 .6075 .35452 .60386 .35348 Mtetra
.785 .388 .302 r
.60386 .35348 .6075 .35452 .61075 .35903 .6071 .35799 Mtetra
.786 .391 .305 r
.6071 .35799 .61075 .35903 .614 .3636 .61036 .36257 Mtetra
.781 .376 .284 r
.61036 .36257 .614 .3636 .61727 .36792 .61362 .36689 Mtetra
.766 .335 .228 r
.61362 .36689 .61727 .36792 .62053 .3717 .61688 .37067 Mtetra
.725 .245 .105 r
.61688 .37067 .62053 .3717 .62379 .37465 .62013 .37363 Mtetra
.582 .015 0 r
.62013 .37363 .62379 .37465 .62704 .37656 .62337 .37553 Mtetra
0 .513 .8 r
.62337 .37553 .62704 .37656 .63026 .37721 .62659 .37618 Mtetra
.54 .777 .985 r
.62659 .37618 .63026 .37721 .63346 .37648 .62979 .37545 Mtetra
.709 .753 .886 r
.62979 .37545 .63346 .37648 .63662 .37429 .63296 .37326 Mtetra
.76 .717 .813 r
.63296 .37326 .63662 .37429 .63976 .37061 .63609 .36957 Mtetra
.78 .693 .768 r
.63609 .36957 .63976 .37061 .64285 .36548 .63919 .36444 Mtetra
.789 .677 .74 r
.63919 .36444 .64285 .36548 .64592 .359 .64225 .35795 Mtetra
.795 .666 .721 r
.64225 .35795 .64592 .359 .64895 .35129 .64529 .35024 Mtetra
.798 .658 .708 r
.64529 .35024 .64895 .35129 .65195 .34255 .64829 .34149 Mtetra
.8 .653 .7 r
.64829 .34149 .65195 .34255 .65492 .33298 .65127 .33191 Mtetra
.801 .65 .695 r
.65127 .33191 .65492 .33298 .65787 .32282 .65422 .32175 Mtetra
.802 .649 .692 r
.65422 .32175 .65787 .32282 .66081 .31234 .65716 .31126 Mtetra
.802 .648 .691 r
.65716 .31126 .66081 .31234 .66374 .30179 .6601 .30071 Mtetra
.802 .649 .693 r
.6601 .30071 .66374 .30179 .66667 .29143 .66303 .29034 Mtetra
.801 .651 .696 r
.66303 .29034 .66667 .29143 .66961 .28151 .66598 .28041 Mtetra
.8 .655 .702 r
.66598 .28041 .66961 .28151 .67256 .27225 .66894 .27115 Mtetra
.797 .66 .712 r
.66894 .27115 .67256 .27225 .67555 .26387 .67193 .26277 Mtetra
.793 .668 .725 r
.67193 .26277 .67555 .26387 .67856 .25655 .67494 .25544 Mtetra
.787 .679 .745 r
.67494 .25544 .67856 .25655 .68161 .25042 .678 .24931 Mtetra
.775 .695 .775 r
.678 .24931 .68161 .25042 .68471 .24561 .6811 .24449 Mtetra
.752 .719 .822 r
.6811 .24449 .68471 .24561 .68786 .24219 .68425 .24107 Mtetra
.694 .753 .897 r
.68425 .24107 .68786 .24219 .69107 .2402 .68745 .23907 Mtetra
.505 .763 .989 r
.68745 .23907 .69107 .2402 .69433 .23964 .69071 .23851 Mtetra
0 .467 .768 r
.69071 .23851 .69433 .23964 .69765 .24047 .69403 .23934 Mtetra
.609 .049 0 r
.69403 .23934 .69765 .24047 .70102 .24264 .6974 .24151 Mtetra
.744 .273 .128 r
.6974 .24151 .70102 .24264 .70446 .24603 .70083 .2449 Mtetra
.783 .366 .257 r
.70083 .2449 .70446 .24603 .70795 .25052 .70432 .24939 Mtetra
.798 .412 .324 r
.70432 .24939 .70795 .25052 .71148 .25595 .70785 .25483 Mtetra
.805 .438 .361 r
.70785 .25483 .71148 .25595 .71507 .26215 .71143 .26103 Mtetra
.809 .452 .382 r
.71143 .26103 .71507 .26215 .71869 .26891 .71504 .26779 Mtetra
.81 .459 .393 r
.71504 .26779 .71869 .26891 .72234 .27603 .71868 .27491 Mtetra
.811 .462 .396 r
.71868 .27491 .72234 .27603 .72601 .28328 .72235 .28217 Mtetra
.81 .459 .392 r
.72235 .28217 .72601 .28328 .7297 .29045 .72603 .28933 Mtetra
.826 .519 .47 r
.28129 .56697 .28483 .56902 .28717 .57609 .28363 .57404 Mtetra
.826 .521 .473 r
.28363 .57404 .28717 .57609 .28952 .58331 .28597 .58126 Mtetra
.826 .519 .47 r
.28597 .58126 .28952 .58331 .29189 .59047 .28833 .58841 Mtetra
.827 .515 .462 r
.28833 .58841 .29189 .59047 .29427 .59734 .29071 .59529 Mtetra
.828 .506 .445 r
.29071 .59529 .29427 .59734 .29669 .60373 .29312 .60167 Mtetra
.829 .491 .415 r
.29312 .60167 .29669 .60373 .29913 .60942 .29556 .60736 Mtetra
.828 .461 .36 r
.29556 .60736 .29913 .60942 .30162 .61422 .29804 .61216 Mtetra
.817 .398 .248 r
.29804 .61216 .30162 .61422 .30415 .61797 .30057 .61591 Mtetra
.735 .215 0 r
.30057 .61591 .30415 .61797 .30673 .62052 .30314 .61846 Mtetra
0 .351 .763 r
.30314 .61846 .30673 .62052 .30936 .62176 .30577 .61969 Mtetra
.485 .658 .937 r
.30577 .61969 .30936 .62176 .31204 .6216 .30844 .61953 Mtetra
.657 .665 .846 r
.30844 .61953 .31204 .6216 .31476 .62001 .31117 .61794 Mtetra
.713 .652 .787 r
.31117 .61794 .31476 .62001 .31754 .61698 .31394 .61491 Mtetra
.738 .641 .752 r
.31394 .61491 .31754 .61698 .32035 .61256 .31676 .61049 Mtetra
.752 .634 .73 r
.31676 .61049 .32035 .61256 .32321 .60682 .31962 .60475 Mtetra
.76 .629 .715 r
.31962 .60475 .32321 .60682 .3261 .59989 .32251 .59781 Mtetra
.765 .625 .705 r
.32251 .59781 .3261 .59989 .32902 .59192 .32543 .58983 Mtetra
.768 .622 .698 r
.32543 .58983 .32902 .59192 .33197 .58309 .32838 .581 Mtetra
.77 .621 .694 r
.32838 .581 .33197 .58309 .33492 .57363 .33134 .57154 Mtetra
.772 .62 .691 r
.33134 .57154 .33492 .57363 .33789 .56376 .33431 .56167 Mtetra
.772 .619 .69 r
.33431 .56167 .33789 .56376 .34086 .55374 .33728 .55164 Mtetra
.33728 .55164 .34086 .55374 .34381 .54381 .34024 .54171 Mtetra
.771 .62 .693 r
.34024 .54171 .34381 .54381 .34676 .53423 .34319 .53213 Mtetra
.769 .622 .696 r
.34319 .53213 .34676 .53423 .34969 .52524 .34612 .52313 Mtetra
.766 .624 .703 r
.34612 .52313 .34969 .52524 .35259 .51705 .34903 .51494 Mtetra
.761 .627 .712 r
.34903 .51494 .35259 .51705 .35547 .50986 .35191 .50775 Mtetra
.754 .632 .725 r
.35191 .50775 .35547 .50986 .35832 .50384 .35476 .50173 Mtetra
.741 .639 .746 r
.35476 .50173 .35832 .50384 .36114 .49911 .35758 .497 Mtetra
.72 .648 .777 r
.35758 .497 .36114 .49911 .36393 .49576 .36037 .49364 Mtetra
.675 .66 .827 r
.36037 .49364 .36393 .49576 .36669 .4938 .36313 .49168 Mtetra
.559 .663 .906 r
.36313 .49168 .36669 .4938 .36943 .49323 .36587 .49111 Mtetra
.172 .546 .928 r
.36587 .49111 .36943 .49323 .37214 .49397 .36857 .49185 Mtetra
.532 0 0 r
.36857 .49185 .37214 .49397 .37483 .49591 .37126 .49378 Mtetra
.77 .273 .035 r
.37126 .49378 .37483 .49591 .37751 .49887 .37394 .49674 Mtetra
.815 .381 .21 r
.37394 .49674 .37751 .49887 .38018 .50265 .3766 .50051 Mtetra
.826 .423 .282 r
.3766 .50051 .38018 .50265 .38285 .50697 .37927 .50484 Mtetra
.829 .438 .309 r
.37927 .50484 .38285 .50697 .38552 .51157 .38193 .50944 Mtetra
.829 .435 .305 r
.38193 .50944 .38552 .51157 .38821 .51615 .38461 .51401 Mtetra
.824 .414 .267 r
.38461 .51401 .38821 .51615 .39091 .52039 .38731 .51825 Mtetra
.808 .358 .171 r
.38731 .51825 .39091 .52039 .39363 .524 .39002 .52186 Mtetra
.73 .205 0 r
.39002 .52186 .39363 .524 .39637 .52671 .39277 .52456 Mtetra
0 .238 .649 r
.39277 .52456 .39637 .52671 .39915 .52828 .39554 .52613 Mtetra
.378 .627 .951 r
.39554 .52613 .39915 .52828 .40195 .52853 .39833 .52639 Mtetra
.622 .667 .872 r
.39833 .52639 .40195 .52853 .40478 .52737 .40116 .52522 Mtetra
.699 .656 .804 r
.40116 .52522 .40478 .52737 .40763 .52475 .40402 .5226 Mtetra
.731 .645 .764 r
.40402 .5226 .40763 .52475 .41051 .52074 .4069 .51858 Mtetra
.747 .638 .739 r
.4069 .51858 .41051 .52074 .41341 .51546 .4098 .5133 Mtetra
.756 .633 .724 r
.4098 .5133 .41341 .51546 .41633 .50914 .41271 .50698 Mtetra
.761 .63 .715 r
.41271 .50698 .41633 .50914 .41925 .50206 .41564 .4999 Mtetra
.764 .628 .71 r
.41564 .4999 .41925 .50206 .42218 .49457 .41857 .49241 Mtetra
.41857 .49241 .42218 .49457 .42511 .48705 .4215 .48488 Mtetra
.762 .629 .714 r
.4215 .48488 .42511 .48705 .42803 .47988 .42442 .47771 Mtetra
.757 .632 .722 r
.42442 .47771 .42803 .47988 .43094 .47343 .42734 .47125 Mtetra
.749 .637 .737 r
.42734 .47125 .43094 .47343 .43384 .46801 .43024 .46584 Mtetra
.732 .644 .761 r
.43024 .46584 .43384 .46801 .43673 .46388 .43313 .4617 Mtetra
.701 .655 .801 r
.43313 .4617 .43673 .46388 .43961 .46117 .436 .45899 Mtetra
.629 .665 .865 r
.436 .45899 .43961 .46117 .44247 .45989 .43887 .45771 Mtetra
.44 .642 .942 r
.43887 .45771 .44247 .45989 .44533 .45994 .44173 .45776 Mtetra
.001 .454 .865 r
.44173 .45776 .44533 .45994 .44819 .46106 .44458 .45887 Mtetra
.404 0 0 r
.44458 .45887 .44819 .46106 .45105 .46286 .44743 .46067 Mtetra
.505 0 0 r
.44743 .46067 .45105 .46286 .45391 .46488 .45029 .46269 Mtetra
0 .208 .62 r
.45029 .46269 .45391 .46488 .45678 .46659 .45317 .4644 Mtetra
.124 .521 .914 r
.45317 .4644 .45678 .46659 .45967 .46749 .45605 .4653 Mtetra
.517 .658 .923 r
.45605 .4653 .45967 .46749 .46257 .46717 .45895 .46497 Mtetra
.662 .663 .84 r
.45895 .46497 .46257 .46717 .46549 .46537 .46186 .46317 Mtetra
.715 .652 .785 r
.46186 .46317 .46549 .46537 .46841 .46212 .46479 .45991 Mtetra
.737 .644 .756 r
.46479 .45991 .46841 .46212 .47135 .45768 .46772 .45548 Mtetra
.744 .64 .745 r
.46772 .45548 .47135 .45768 .47429 .45265 .47066 .45044 Mtetra
.742 .641 .748 r
.47066 .45044 .47429 .45265 .47722 .44778 .4736 .44557 Mtetra
.728 .647 .768 r
.4736 .44557 .47722 .44778 .48016 .44387 .47654 .44166 Mtetra
.689 .658 .814 r
.47654 .44166 .48016 .44387 .4831 .44146 .47947 .43925 Mtetra
.599 .665 .885 r
.47947 .43925 .4831 .44146 .48603 .44051 .48241 .43829 Mtetra
.541 .66 .914 r
.48241 .43829 .48603 .44051 .48897 .44003 .48534 .43781 Mtetra
.657 .663 .844 r
.48534 .43781 .48897 .44003 .49192 .4383 .48829 .43608 Mtetra
.707 .654 .794 r
.48829 .43608 .49192 .4383 .49487 .4353 .49124 .43308 Mtetra
.657 .663 .844 r
.49124 .43308 .49487 .4353 .49783 .43357 .4942 .43134 Mtetra
.541 .66 .913 r
.4942 .43134 .49783 .43357 .50079 .43308 .49716 .43085 Mtetra
.599 .665 .885 r
.49716 .43085 .50079 .43308 .50376 .43212 .50012 .42988 Mtetra
.689 .658 .815 r
.50012 .42988 .50376 .43212 .50673 .42969 .50309 .42745 Mtetra
.728 .647 .769 r
.50309 .42745 .50673 .42969 .5097 .42574 .50606 .4235 Mtetra
.743 .642 .748 r
.50606 .4235 .5097 .42574 .51267 .42083 .50903 .41858 Mtetra
.745 .641 .745 r
.50903 .41858 .51267 .42083 .51564 .41574 .512 .4135 Mtetra
.737 .644 .757 r
.512 .4135 .51564 .41574 .51861 .41126 .51497 .40901 Mtetra
.715 .652 .786 r
.51497 .40901 .51861 .41126 .52159 .40794 .51795 .40569 Mtetra
.662 .662 .839 r
.51795 .40569 .52159 .40794 .52458 .40609 .52094 .40383 Mtetra
.526 .657 .918 r
.52094 .40383 .52458 .40609 .52758 .4057 .52394 .40344 Mtetra
.181 .545 .928 r
.52394 .40344 .52758 .4057 .5306 .40654 .52696 .40428 Mtetra
0 .279 .703 r
.52696 .40428 .5306 .40654 .53363 .4082 .52999 .40594 Mtetra
.42 0 0 r
.52999 .40594 .53363 .4082 .53667 .41018 .53302 .40792 Mtetra
0 .235 .656 r
.53302 .40792 .53667 .41018 .53972 .41195 .53607 .40969 Mtetra
.069 .489 .894 r
.53607 .40969 .53972 .41195 .54277 .41304 .53911 .41077 Mtetra
.453 .643 .939 r
.53911 .41077 .54277 .41304 .54582 .41303 .54216 .41077 Mtetra
.629 .665 .865 r
.54216 .41077 .54582 .41303 .54886 .41168 .5452 .40941 Mtetra
.7 .656 .803 r
.5452 .40941 .54886 .41168 .55189 .40885 .54823 .40658 Mtetra
.733 .646 .763 r
.54823 .40658 .55189 .40885 .55491 .40457 .55125 .40229 Mtetra
.75 .639 .738 r
.55125 .40229 .55491 .40457 .55792 .39897 .55426 .39669 Mtetra
.759 .634 .723 r
.55426 .39669 .55792 .39897 .56092 .39231 .55726 .39003 Mtetra
.764 .632 .714 r
.55726 .39003 .56092 .39231 .5639 .38493 .56025 .38264 Mtetra
.766 .63 .71 r
.56025 .38264 .5639 .38493 .56689 .37719 .56323 .3749 Mtetra
.766 .631 .71 r
.56323 .3749 .56689 .37719 .56987 .3695 .56622 .36721 Mtetra
.764 .632 .715 r
.56622 .36721 .56987 .3695 .57285 .36224 .5692 .35994 Mtetra
.758 .635 .724 r
.5692 .35994 .57285 .36224 .57584 .35573 .5722 .35343 Mtetra
.749 .64 .74 r
.5722 .35343 .57584 .35573 .57885 .35027 .57521 .34797 Mtetra
.731 .647 .765 r
.57521 .34797 .57885 .35027 .58188 .34606 .57824 .34376 Mtetra
.699 .656 .804 r
.57824 .34376 .58188 .34606 .58494 .34326 .58129 .34095 Mtetra
.628 .663 .864 r
.58129 .34095 .58494 .34326 .58802 .34189 .58437 .33958 Mtetra
.442 .637 .939 r
.58437 .33958 .58802 .34189 .59113 .34195 .58748 .33964 Mtetra
0 .412 .835 r
.58748 .33964 .59113 .34195 .59427 .34334 .59062 .34102 Mtetra
.587 .021 0 r
.59062 .34102 .59427 .34334 .59744 .34587 .59378 .34356 Mtetra
.759 .248 0 r
.59378 .34356 .59744 .34587 .60064 .34934 .59698 .34702 Mtetra
.805 .337 .117 r
.59698 .34702 .60064 .34934 .60386 .35348 .60019 .35116 Mtetra
.818 .37 .172 r
.60019 .35116 .60386 .35348 .6071 .35799 .60343 .35567 Mtetra
.819 .374 .178 r
.60343 .35567 .6071 .35799 .61036 .36257 .60668 .36024 Mtetra
.811 .351 .14 r
.60668 .36024 .61036 .36257 .61362 .36689 .60993 .36456 Mtetra
.78 .286 .034 r
.60993 .36456 .61362 .36689 .61688 .37067 .61319 .36834 Mtetra
.675 .126 0 r
.61319 .36834 .61688 .37067 .62013 .37363 .61644 .37129 Mtetra
0 .238 .663 r
.61644 .37129 .62013 .37363 .62337 .37553 .61968 .37319 Mtetra
.278 .584 .944 r
.61968 .37319 .62337 .37553 .62659 .37618 .62289 .37384 Mtetra
.567 .662 .901 r
.62289 .37384 .62659 .37618 .62979 .37545 .62609 .37311 Mtetra
.673 .662 .83 r
.62609 .37311 .62979 .37545 .63296 .37326 .62925 .37091 Mtetra
.72 .652 .781 r
.62925 .37091 .63296 .37326 .63609 .36957 .63239 .36723 Mtetra
.744 .644 .749 r
.63239 .36723 .63609 .36957 .63919 .36444 .63549 .36209 Mtetra
.758 .637 .727 r
.63549 .36209 .63919 .36444 .64225 .35795 .63855 .3556 Mtetra
.767 .633 .712 r
.63855 .3556 .64225 .35795 .64529 .35024 .64159 .34788 Mtetra
.773 .629 .702 r
.64159 .34788 .64529 .35024 .64829 .34149 .64459 .33913 Mtetra
.776 .627 .695 r
.64459 .33913 .64829 .34149 .65127 .33191 .64757 .32955 Mtetra
.779 .625 .69 r
.64757 .32955 .65127 .33191 .65422 .32175 .65053 .31939 Mtetra
.78 .625 .688 r
.65053 .31939 .65422 .32175 .65716 .31126 .65348 .3089 Mtetra
.78 .624 .687 r
.65348 .3089 .65716 .31126 .6601 .30071 .65642 .29833 Mtetra
.78 .625 .688 r
.65642 .29833 .6601 .30071 .66303 .29034 .65936 .28796 Mtetra
.778 .626 .691 r
.65936 .28796 .66303 .29034 .66598 .28041 .66231 .27803 Mtetra
.775 .628 .697 r
.66231 .27803 .66598 .28041 .66894 .27115 .66527 .26877 Mtetra
.771 .63 .704 r
.66527 .26877 .66894 .27115 .67193 .26277 .66826 .26038 Mtetra
.765 .634 .716 r
.66826 .26038 .67193 .26277 .67494 .25544 .67128 .25305 Mtetra
.755 .638 .732 r
.67128 .25305 .67494 .25544 .678 .24931 .67434 .24691 Mtetra
.74 .645 .754 r
.67434 .24691 .678 .24931 .6811 .24449 .67744 .2421 Mtetra
.713 .652 .788 r
.67744 .2421 .6811 .24449 .68425 .24107 .68059 .23867 Mtetra
.662 .66 .838 r
.68059 .23867 .68425 .24107 .68745 .23907 .68379 .23667 Mtetra
.546 .655 .907 r
.68379 .23667 .68745 .23907 .69071 .23851 .68705 .23611 Mtetra
.234 .56 .935 r
.68705 .23611 .69071 .23851 .69403 .23934 .69036 .23694 Mtetra
0 .184 .612 r
.69036 .23694 .69403 .23934 .6974 .24151 .69373 .2391 Mtetra
.713 .177 0 r
.69373 .2391 .6974 .24151 .70083 .2449 .69716 .24249 Mtetra
.806 .334 .101 r
.69716 .24249 .70083 .2449 .70432 .24939 .70063 .24698 Mtetra
.832 .404 .219 r
.70063 .24698 .70432 .24939 .70785 .25483 .70416 .25241 Mtetra
.841 .439 .281 r
.70416 .25241 .70785 .25483 .71143 .26103 .70773 .25861 Mtetra
.844 .457 .315 r
.70773 .25861 .71143 .26103 .71504 .26779 .71134 .26537 Mtetra
.845 .466 .332 r
.71134 .26537 .71504 .26779 .71868 .27491 .71498 .27249 Mtetra
.846 .469 .337 r
.71498 .27249 .71868 .27491 .72235 .28217 .71863 .27974 Mtetra
.845 .466 .331 r
.71863 .27974 .72235 .28217 .72603 .28933 .72231 .2869 Mtetra
.86 .535 .436 r
.27779 .56371 .28129 .56697 .28363 .57404 .28013 .57077 Mtetra
.859 .537 .44 r
.28013 .57077 .28363 .57404 .28597 .58126 .28246 .57798 Mtetra
.86 .536 .437 r
.28246 .57798 .28597 .58126 .28833 .58841 .28481 .58513 Mtetra
.862 .531 .424 r
.28481 .58513 .28833 .58841 .29071 .59529 .28718 .592 Mtetra
.865 .522 .399 r
.28718 .592 .29071 .59529 .29312 .60167 .28959 .59838 Mtetra
.869 .503 .353 r
.28959 .59838 .29312 .60167 .29556 .60736 .29202 .60406 Mtetra
.868 .464 .263 r
.29202 .60406 .29556 .60736 .29804 .61216 .2945 .60886 Mtetra
.832 .361 .059 r
.2945 .60886 .29804 .61216 .30057 .61591 .29702 .6126 Mtetra
.553 .033 0 r
.29702 .6126 .30057 .61591 .30314 .61846 .29959 .61515 Mtetra
.162 .444 .876 r
.29959 .61515 .30314 .61846 .30577 .61969 .30221 .61638 Mtetra
.513 .578 .857 r
.30221 .61638 .30577 .61969 .30844 .61953 .30488 .61622 Mtetra
.632 .601 .8 r
.30488 .61622 .30844 .61953 .31117 .61794 .30761 .61462 Mtetra
.684 .605 .762 r
.30761 .61462 .31117 .61794 .31394 .61491 .31038 .61159 Mtetra
.712 .605 .736 r
.31038 .61159 .31394 .61491 .31676 .61049 .3132 .60717 Mtetra
.728 .605 .719 r
.3132 .60717 .31676 .61049 .31962 .60475 .31606 .60142 Mtetra
.739 .604 .707 r
.31606 .60142 .31962 .60475 .32251 .59781 .31895 .59449 Mtetra
.746 .603 .699 r
.31895 .59449 .32251 .59781 .32543 .58983 .32188 .58651 Mtetra
.75 .602 .693 r
.32188 .58651 .32543 .58983 .32838 .581 .32483 .57768 Mtetra
.753 .602 .689 r
.32483 .57768 .32838 .581 .33134 .57154 .32779 .56821 Mtetra
.755 .602 .687 r
.32779 .56821 .33134 .57154 .33431 .56167 .33076 .55834 Mtetra
.756 .602 .686 r
.33076 .55834 .33431 .56167 .33728 .55164 .33373 .54832 Mtetra
.755 .602 .686 r
.33373 .54832 .33728 .55164 .34024 .54171 .3367 .53839 Mtetra
.754 .602 .688 r
.3367 .53839 .34024 .54171 .34319 .53213 .33965 .5288 Mtetra
.751 .602 .692 r
.33965 .5288 .34319 .53213 .34612 .52313 .34259 .51981 Mtetra
.747 .603 .697 r
.34259 .51981 .34612 .52313 .34903 .51494 .3455 .51161 Mtetra
.741 .603 .705 r
.3455 .51161 .34903 .51494 .35191 .50775 .34838 .50443 Mtetra
.731 .604 .716 r
.34838 .50443 .35191 .50775 .35476 .50173 .35123 .4984 Mtetra
.716 .605 .731 r
.35123 .4984 .35476 .50173 .35758 .497 .35405 .49367 Mtetra
.692 .605 .754 r
.35405 .49367 .35758 .497 .36037 .49364 .35684 .4903 Mtetra
.648 .602 .789 r
.35684 .4903 .36037 .49364 .36313 .49168 .3596 .48834 Mtetra
.559 .587 .838 r
.3596 .48834 .36313 .49168 .36587 .49111 .36233 .48777 Mtetra
.344 .52 .887 r
.36233 .48777 .36587 .49111 .36857 .49185 .36503 .4885 Mtetra
0 .259 .757 r
.36503 .4885 .36857 .49185 .37126 .49378 .36772 .49044 Mtetra
.658 .136 0 r
.36772 .49044 .37126 .49378 .37394 .49674 .37039 .49339 Mtetra
.815 .331 0 r
.37039 .49339 .37394 .49674 .3766 .50051 .37305 .49716 Mtetra
.852 .403 .132 r
.37305 .49716 .3766 .50051 .37927 .50484 .37571 .50148 Mtetra
.861 .427 .179 r
.37571 .50148 .37927 .50484 .38193 .50944 .37837 .50607 Mtetra
.86 .423 .172 r
.37837 .50607 .38193 .50944 .38461 .51401 .38104 .51064 Mtetra
.846 .388 .104 r
.38104 .51064 .38461 .51401 .38731 .51825 .38373 .51488 Mtetra
.787 .289 0 r
.38373 .51488 .38731 .51825 .39002 .52186 .38644 .51848 Mtetra
.538 .021 0 r
.38644 .51848 .39002 .52186 .39277 .52456 .38918 .52118 Mtetra
.054 .386 .848 r
.38918 .52118 .39277 .52456 .39554 .52613 .39194 .52274 Mtetra
.451 .558 .873 r
.39194 .52274 .39554 .52613 .39833 .52639 .39474 .523 Mtetra
.604 .596 .817 r
.39474 .523 .39833 .52639 .40116 .52522 .39757 .52183 Mtetra
.67 .605 .773 r
.39757 .52183 .40116 .52522 .40402 .5226 .40042 .51921 Mtetra
.703 .606 .745 r
.40042 .51921 .40402 .5226 .4069 .51858 .4033 .51518 Mtetra
.722 .605 .726 r
.4033 .51518 .4069 .51858 .4098 .5133 .4062 .5099 Mtetra
.733 .605 .714 r
.4062 .5099 .4098 .5133 .41271 .50698 .40912 .50357 Mtetra
.74 .604 .707 r
.40912 .50357 .41271 .50698 .41564 .4999 .41205 .49649 Mtetra
.743 .604 .703 r
.41205 .49649 .41564 .4999 .41857 .49241 .41498 .489 Mtetra
.41498 .489 .41857 .49241 .4215 .48488 .41791 .48148 Mtetra
.741 .604 .706 r
.41791 .48148 .4215 .48488 .42442 .47771 .42083 .4743 Mtetra
.735 .605 .713 r
.42083 .4743 .42442 .47771 .42734 .47125 .42375 .46785 Mtetra
.724 .605 .724 r
.42375 .46785 .42734 .47125 .43024 .46584 .42665 .46243 Mtetra
.705 .606 .743 r
.42665 .46243 .43024 .46584 .43313 .4617 .42954 .45829 Mtetra
.672 .604 .771 r
.42954 .45829 .43313 .4617 .436 .45899 .43241 .45557 Mtetra
.61 .597 .813 r
.43241 .45557 .436 .45899 .43887 .45771 .43528 .45429 Mtetra
.485 .568 .864 r
.43528 .45429 .43887 .45771 .44173 .45776 .43813 .45434 Mtetra
.252 .481 .884 r
.43813 .45434 .44173 .45776 .44458 .45887 .44098 .45544 Mtetra
0 .34 .819 r
.44098 .45544 .44458 .45887 .44743 .46067 .44383 .45724 Mtetra
0 .276 .772 r
.44383 .45724 .44743 .46067 .45029 .46269 .44669 .45925 Mtetra
.021 .367 .836 r
.44669 .45925 .45029 .46269 .45317 .4644 .44955 .46096 Mtetra
.317 .509 .887 r
.44955 .46096 .45317 .4644 .45605 .4653 .45243 .46185 Mtetra
.531 .58 .849 r
.45243 .46185 .45605 .4653 .45895 .46497 .45533 .46152 Mtetra
.636 .601 .797 r
.45533 .46152 .45895 .46497 .46186 .46317 .45824 .45972 Mtetra
.686 .605 .76 r
.45824 .45972 .46186 .46317 .46479 .45991 .46117 .45646 Mtetra
.709 .606 .739 r
.46117 .45646 .46479 .45991 .46772 .45548 .4641 .45203 Mtetra
.718 .606 .73 r
.4641 .45203 .46772 .45548 .47066 .45044 .46704 .44699 Mtetra
.716 .606 .733 r
.46704 .44699 .47066 .45044 .4736 .44557 .46998 .44211 Mtetra
.7 .606 .748 r
.46998 .44211 .4736 .44557 .47654 .44166 .47291 .4382 Mtetra
.661 .604 .78 r
.47291 .4382 .47654 .44166 .47947 .43925 .47585 .43579 Mtetra
.587 .593 .825 r
.47585 .43579 .47947 .43925 .48241 .43829 .47878 .43482 Mtetra
.546 .584 .843 r
.47878 .43482 .48241 .43829 .48534 .43781 .48172 .43434 Mtetra
.632 .6 .8 r
.48172 .43434 .48534 .43781 .48829 .43608 .48466 .43261 Mtetra
.679 .605 .766 r
.48466 .43261 .48829 .43608 .49124 .43308 .48761 .4296 Mtetra
.632 .6 .8 r
.48761 .4296 .49124 .43308 .4942 .43134 .49056 .42786 Mtetra
.547 .584 .843 r
.49056 .42786 .4942 .43134 .49716 .43085 .49352 .42737 Mtetra
.587 .593 .825 r
.49352 .42737 .49716 .43085 .50012 .42988 .49648 .4264 Mtetra
.66 .604 .78 r
.49648 .4264 .50012 .42988 .50309 .42745 .49945 .42396 Mtetra
.7 .606 .748 r
.49945 .42396 .50309 .42745 .50606 .4235 .50242 .42001 Mtetra
.716 .606 .733 r
.50242 .42001 .50606 .4235 .50903 .41858 .50539 .41509 Mtetra
.719 .606 .73 r
.50539 .41509 .50903 .41858 .512 .4135 .50836 .41 Mtetra
.709 .606 .739 r
.50836 .41 .512 .4135 .51497 .40901 .51133 .40552 Mtetra
.686 .605 .76 r
.51133 .40552 .51497 .40901 .51795 .40569 .51431 .4022 Mtetra
.637 .601 .796 r
.51431 .4022 .51795 .40569 .52094 .40383 .5173 .40033 Mtetra
.537 .581 .847 r
.5173 .40033 .52094 .40383 .52394 .40344 .5203 .39994 Mtetra
.344 .518 .885 r
.5203 .39994 .52394 .40344 .52696 .40428 .52331 .40077 Mtetra
.087 .4 .855 r
.52331 .40077 .52696 .40428 .52999 .40594 .52633 .40242 Mtetra
0 .325 .809 r
.52633 .40242 .52999 .40594 .53302 .40792 .52936 .4044 Mtetra
.045 .378 .843 r
.52936 .4044 .53302 .40792 .53607 .40969 .5324 .40617 Mtetra
.285 .494 .885 r
.5324 .40617 .53607 .40969 .53911 .41077 .53544 .40724 Mtetra
.492 .569 .861 r
.53544 .40724 .53911 .41077 .54216 .41077 .53849 .40724 Mtetra
.61 .597 .813 r
.53849 .40724 .54216 .41077 .5452 .40941 .54152 .40588 Mtetra
.672 .605 .772 r
.54152 .40588 .5452 .40941 .54823 .40658 .54456 .40304 Mtetra
.705 .606 .744 r
.54456 .40304 .54823 .40658 .55125 .40229 .54758 .39875 Mtetra
.724 .606 .725 r
.54758 .39875 .55125 .40229 .55426 .39669 .55059 .39315 Mtetra
.736 .606 .713 r
.55059 .39315 .55426 .39669 .55726 .39003 .55359 .38649 Mtetra
.742 .605 .706 r
.55359 .38649 .55726 .39003 .56025 .38264 .55658 .3791 Mtetra
.745 .605 .703 r
.55658 .3791 .56025 .38264 .56323 .3749 .55956 .37136 Mtetra
.744 .605 .703 r
.55956 .37136 .56323 .3749 .56622 .36721 .56255 .36367 Mtetra
.741 .605 .707 r
.56255 .36367 .56622 .36721 .5692 .35994 .56553 .35639 Mtetra
.734 .606 .714 r
.56553 .35639 .5692 .35994 .5722 .35343 .56853 .34988 Mtetra
.723 .606 .726 r
.56853 .34988 .5722 .35343 .57521 .34797 .57154 .34442 Mtetra
.703 .606 .745 r
.57154 .34442 .57521 .34797 .57824 .34376 .57457 .34021 Mtetra
.67 .604 .773 r
.57457 .34021 .57824 .34376 .58129 .34095 .57762 .33739 Mtetra
.609 .596 .813 r
.57762 .33739 .58129 .34095 .58437 .33958 .5807 .33603 Mtetra
.484 .566 .863 r
.5807 .33603 .58437 .33958 .58748 .33964 .5838 .33608 Mtetra
.21 .46 .878 r
.5838 .33608 .58748 .33964 .59062 .34102 .58694 .33746 Mtetra
0 .19 .698 r
.58694 .33746 .59062 .34102 .59378 .34356 .5901 .33999 Mtetra
.62 .102 0 r
.5901 .33999 .59378 .34356 .59698 .34702 .59329 .34345 Mtetra
.76 .254 0 r
.59329 .34345 .59698 .34702 .60019 .35116 .5965 .34758 Mtetra
.803 .313 0 r
.5965 .34758 .60019 .35116 .60343 .35567 .59973 .35208 Mtetra
.807 .319 0 r
.59973 .35208 .60343 .35567 .60668 .36024 .60297 .35665 Mtetra
.779 .279 0 r
.60297 .35665 .60668 .36024 .60993 .36456 .60622 .36096 Mtetra
.682 .164 0 r
.60622 .36096 .60993 .36456 .61319 .36834 .60947 .36473 Mtetra
0 .076 .58 r
.60947 .36473 .61319 .36834 .61644 .37129 .61271 .36768 Mtetra
.044 .376 .842 r
.61271 .36768 .61644 .37129 .61968 .37319 .61595 .36958 Mtetra
.394 .536 .88 r
.61595 .36958 .61968 .37319 .62289 .37384 .61916 .37022 Mtetra
.564 .588 .835 r
.61916 .37022 .62289 .37384 .62609 .37311 .62235 .36949 Mtetra
.647 .602 .79 r
.62235 .36949 .62609 .37311 .62925 .37091 .62552 .36729 Mtetra
.691 .606 .757 r
.62552 .36729 .62925 .37091 .63239 .36723 .62865 .3636 Mtetra
.717 .607 .733 r
.62865 .3636 .63239 .36723 .63549 .36209 .63175 .35846 Mtetra
.733 .607 .716 r
.63175 .35846 .63549 .36209 .63855 .3556 .63482 .35197 Mtetra
.744 .606 .704 r
.63482 .35197 .63855 .3556 .64159 .34788 .63785 .34425 Mtetra
.751 .605 .696 r
.63785 .34425 .64159 .34788 .64459 .33913 .64086 .3355 Mtetra
.756 .605 .69 r
.64086 .3355 .64459 .33913 .64757 .32955 .64384 .32592 Mtetra
.759 .605 .686 r
.64384 .32592 .64757 .32955 .65053 .31939 .64681 .31575 Mtetra
.761 .604 .684 r
.64681 .31575 .65053 .31939 .65348 .3089 .64976 .30526 Mtetra
.761 .604 .683 r
.64976 .30526 .65348 .3089 .65642 .29833 .6527 .2947 Mtetra
.761 .604 .684 r
.6527 .2947 .65642 .29833 .65936 .28796 .65564 .28433 Mtetra
.759 .605 .687 r
.65564 .28433 .65936 .28796 .66231 .27803 .6586 .2744 Mtetra
.755 .605 .691 r
.6586 .2744 .66231 .27803 .66527 .26877 .66156 .26513 Mtetra
.75 .606 .698 r
.66156 .26513 .66527 .26877 .66826 .26038 .66455 .25674 Mtetra
.741 .606 .707 r
.66455 .25674 .66826 .26038 .67128 .25305 .66757 .24941 Mtetra
.73 .607 .72 r
.66757 .24941 .67128 .25305 .67434 .24691 .67063 .24328 Mtetra
.712 .607 .737 r
.67063 .24328 .67434 .24691 .67744 .2421 .67373 .23846 Mtetra
.684 .605 .762 r
.67373 .23846 .67744 .2421 .68059 .23867 .67688 .23503 Mtetra
.637 .6 .796 r
.67688 .23503 .68059 .23867 .68379 .23667 .68008 .23303 Mtetra
.549 .583 .84 r
.68008 .23303 .68379 .23667 .68705 .23611 .68334 .23246 Mtetra
.366 .524 .881 r
.68334 .23246 .68705 .23611 .69036 .23694 .68665 .23328 Mtetra
0 .339 .819 r
.68665 .23328 .69036 .23694 .69373 .2391 .69001 .23544 Mtetra
.503 0 0 r
.69001 .23544 .69373 .2391 .69716 .24249 .69343 .23882 Mtetra
.756 .251 0 r
.69343 .23882 .69716 .24249 .70063 .24698 .6969 .24331 Mtetra
.838 .369 .051 r
.6969 .24331 .70063 .24698 .70416 .25241 .70042 .24873 Mtetra
.864 .425 .157 r
.70042 .24873 .70416 .25241 .70773 .25861 .70398 .25492 Mtetra
.872 .453 .214 r
.70398 .25492 .70773 .25861 .71134 .26537 .70758 .26168 Mtetra
.875 .466 .242 r
.70758 .26168 .71134 .26537 .71498 .27249 .71121 .26879 Mtetra
.876 .469 .25 r
.71121 .26879 .71498 .27249 .71863 .27974 .71486 .27603 Mtetra
.875 .465 .24 r
.71486 .27603 .71863 .27974 .72231 .2869 .71853 .28319 Mtetra
.847 .529 .45 r
.27428 .56091 .27779 .56371 .28013 .57077 .2766 .56797 Mtetra
.846 .531 .454 r
.2766 .56797 .28013 .57077 .28246 .57798 .27893 .57518 Mtetra
.847 .529 .451 r
.27893 .57518 .28246 .57798 .28481 .58513 .28128 .58233 Mtetra
.848 .525 .44 r
.28128 .58233 .28481 .58513 .28718 .592 .28364 .58919 Mtetra
.851 .516 .419 r
.28364 .58919 .28718 .592 .28959 .59838 .28604 .59557 Mtetra
.854 .499 .38 r
.28604 .59557 .28959 .59838 .29202 .60406 .28847 .60124 Mtetra
.854 .465 .307 r
.28847 .60124 .29202 .60406 .2945 .60886 .29094 .60604 Mtetra
.834 .381 .145 r
.29094 .60604 .2945 .60886 .29702 .6126 .29345 .60978 Mtetra
.657 .115 0 r
.29345 .60978 .29702 .6126 .29959 .61515 .29602 .61232 Mtetra
.061 .43 .871 r
.29602 .61232 .29959 .61515 .30221 .61638 .29864 .61355 Mtetra
.507 .604 .885 r
.29864 .61355 .30221 .61638 .30488 .61622 .30131 .61338 Mtetra
.641 .623 .816 r
.30131 .61338 .30488 .61622 .30761 .61462 .30403 .61178 Mtetra
.694 .622 .771 r
.30403 .61178 .30761 .61462 .31038 .61159 .3068 .60875 Mtetra
.721 .618 .742 r
.3068 .60875 .31038 .61159 .3132 .60717 .30962 .60432 Mtetra
.737 .615 .723 r
.30962 .60432 .3132 .60717 .31606 .60142 .31248 .59858 Mtetra
.746 .613 .71 r
.31248 .59858 .31606 .60142 .31895 .59449 .31538 .59164 Mtetra
.753 .611 .701 r
.31538 .59164 .31895 .59449 .32188 .58651 .3183 .58366 Mtetra
.757 .61 .695 r
.3183 .58366 .32188 .58651 .32483 .57768 .32126 .57483 Mtetra
.76 .609 .691 r
.32126 .57483 .32483 .57768 .32779 .56821 .32422 .56536 Mtetra
.761 .608 .688 r
.32422 .56536 .32779 .56821 .33076 .55834 .3272 .55549 Mtetra
.762 .608 .687 r
.3272 .55549 .33076 .55834 .33373 .54832 .33017 .54546 Mtetra
.762 .608 .688 r
.33017 .54546 .33373 .54832 .3367 .53839 .33314 .53553 Mtetra
.76 .609 .69 r
.33314 .53553 .3367 .53839 .33965 .5288 .3361 .52595 Mtetra
.758 .609 .693 r
.3361 .52595 .33965 .5288 .34259 .51981 .33904 .51695 Mtetra
.754 .611 .699 r
.33904 .51695 .34259 .51981 .3455 .51161 .34195 .50876 Mtetra
.748 .612 .707 r
.34195 .50876 .3455 .51161 .34838 .50443 .34483 .50157 Mtetra
.739 .614 .719 r
.34483 .50157 .34838 .50443 .35123 .4984 .34769 .49554 Mtetra
.725 .617 .737 r
.34769 .49554 .35123 .4984 .35405 .49367 .35051 .4908 Mtetra
.702 .62 .763 r
.35051 .4908 .35405 .49367 .35684 .4903 .3533 .48744 Mtetra
.658 .622 .802 r
.3533 .48744 .35684 .4903 .3596 .48834 .35605 .48547 Mtetra
.56 .612 .862 r
.35605 .48547 .3596 .48834 .36233 .48777 .35878 .48489 Mtetra
.298 .536 .912 r
.35878 .48489 .36233 .48777 .36503 .4885 .36148 .48563 Mtetra
0 .19 .666 r
.36148 .48563 .36503 .4885 .36772 .49044 .36416 .48756 Mtetra
.728 .202 0 r
.36416 .48756 .36772 .49044 .37039 .49339 .36683 .49051 Mtetra
.825 .357 .094 r
.36683 .49051 .37039 .49339 .37305 .49716 .36948 .49427 Mtetra
.847 .414 .2 r
.36948 .49427 .37305 .49716 .37571 .50148 .37213 .49859 Mtetra
.852 .434 .238 r
.37213 .49859 .37571 .50148 .37837 .50607 .37479 .50318 Mtetra
.851 .431 .232 r
.37479 .50318 .37837 .50607 .38104 .51064 .37746 .50775 Mtetra
.843 .403 .178 r
.37746 .50775 .38104 .51064 .38373 .51488 .38014 .51198 Mtetra
.809 .325 .037 r
.38014 .51198 .38373 .51488 .38644 .51848 .38285 .51558 Mtetra
.644 .103 0 r
.38285 .51558 .38644 .51848 .38918 .52118 .38558 .51827 Mtetra
0 .353 .818 r
.38558 .51827 .38918 .52118 .39194 .52274 .38834 .51983 Mtetra
.432 .583 .902 r
.38834 .51983 .39194 .52274 .39474 .523 .39114 .52008 Mtetra
.611 .62 .836 r
.39114 .52008 .39474 .523 .39757 .52183 .39396 .51891 Mtetra
.68 .622 .784 r
.39396 .51891 .39757 .52183 .40042 .51921 .39681 .51629 Mtetra
.713 .62 .751 r
.39681 .51629 .40042 .51921 .4033 .51518 .39969 .51226 Mtetra
.731 .617 .731 r
.39969 .51226 .4033 .51518 .4062 .5099 .40259 .50698 Mtetra
.742 .615 .718 r
.40259 .50698 .4062 .5099 .40912 .50357 .40551 .50065 Mtetra
.748 .614 .71 r
.40551 .50065 .40912 .50357 .41205 .49649 .40844 .49357 Mtetra
.75 .613 .706 r
.40844 .49357 .41205 .49649 .41498 .489 .41137 .48607 Mtetra
.751 .613 .706 r
.41137 .48607 .41498 .489 .41791 .48148 .41431 .47855 Mtetra
.748 .613 .709 r
.41431 .47855 .41791 .48148 .42083 .4743 .41723 .47137 Mtetra
.743 .615 .716 r
.41723 .47137 .42083 .4743 .42375 .46785 .42015 .46491 Mtetra
.733 .617 .729 r
.42015 .46491 .42375 .46785 .42665 .46243 .42305 .45949 Mtetra
.715 .619 .749 r
.42305 .45949 .42665 .46243 .42954 .45829 .42594 .45535 Mtetra
.682 .622 .782 r
.42594 .45535 .42954 .45829 .43241 .45557 .42881 .45263 Mtetra
.617 .62 .831 r
.42881 .45263 .43241 .45557 .43528 .45429 .43167 .45135 Mtetra
.474 .593 .892 r
.43167 .45135 .43528 .45429 .43813 .45434 .43453 .45139 Mtetra
.181 .484 .899 r
.43453 .45139 .43813 .45434 .44098 .45544 .43737 .45249 Mtetra
0 .293 .768 r
.43737 .45249 .44098 .45544 .44383 .45724 .44022 .45429 Mtetra
0 .212 .691 r
.44022 .45429 .44383 .45724 .44669 .45925 .44307 .4563 Mtetra
0 .328 .799 r
.44307 .4563 .44669 .45925 .44955 .46096 .44593 .458 Mtetra
.265 .521 .909 r
.44593 .458 .44955 .46096 .45243 .46185 .44881 .45889 Mtetra
.528 .606 .875 r
.44881 .45889 .45243 .46185 .45533 .46152 .45171 .45856 Mtetra
.645 .622 .812 r
.45171 .45856 .45533 .46152 .45824 .45972 .45461 .45675 Mtetra
.696 .622 .769 r
.45461 .45675 .45824 .45972 .46117 .45646 .45754 .45349 Mtetra
.719 .619 .745 r
.45754 .45349 .46117 .45646 .4641 .45203 .46047 .44905 Mtetra
.728 .618 .735 r
.46047 .44905 .4641 .45203 .46704 .44699 .46341 .44401 Mtetra
.726 .619 .738 r
.46341 .44401 .46704 .44699 .46998 .44211 .46635 .43913 Mtetra
.71 .62 .755 r
.46635 .43913 .46998 .44211 .47291 .4382 .46929 .43521 Mtetra
.67 .622 .792 r
.46929 .43521 .47291 .4382 .47585 .43579 .47222 .4328 Mtetra
.592 .617 .846 r
.47222 .4328 .47585 .43579 .47878 .43482 .47515 .43184 Mtetra
.546 .609 .867 r
.47515 .43184 .47878 .43482 .48172 .43434 .47808 .43135 Mtetra
.641 .621 .815 r
.47808 .43135 .48172 .43434 .48466 .43261 .48103 .42961 Mtetra
.689 .622 .776 r
.48103 .42961 .48466 .43261 .48761 .4296 .48398 .42661 Mtetra
.641 .621 .815 r
.48398 .42661 .48761 .4296 .49056 .42786 .48693 .42487 Mtetra
.547 .609 .867 r
.48693 .42487 .49056 .42786 .49352 .42737 .48988 .42437 Mtetra
.592 .617 .845 r
.48988 .42437 .49352 .42737 .49648 .4264 .49284 .42339 Mtetra
.67 .622 .792 r
.49284 .42339 .49648 .4264 .49945 .42396 .49581 .42096 Mtetra
.71 .621 .755 r
.49581 .42096 .49945 .42396 .50242 .42001 .49878 .417 Mtetra
.726 .619 .738 r
.49878 .417 .50242 .42001 .50539 .41509 .50175 .41208 Mtetra
.728 .618 .736 r
.50175 .41208 .50539 .41509 .50836 .41 .50472 .40699 Mtetra
.719 .62 .746 r
.50472 .40699 .50836 .41 .51133 .40552 .50769 .4025 Mtetra
.696 .622 .769 r
.50769 .4025 .51133 .40552 .51431 .4022 .51067 .39918 Mtetra
.646 .622 .811 r
.51067 .39918 .51431 .4022 .5173 .40033 .51365 .39731 Mtetra
.535 .606 .871 r
.51365 .39731 .5173 .40033 .5203 .39994 .51665 .39691 Mtetra
.3 .533 .91 r
.51665 .39691 .5203 .39994 .52331 .40077 .51965 .39774 Mtetra
0 .375 .836 r
.51965 .39774 .52331 .40077 .52633 .40242 .52267 .39939 Mtetra
0 .276 .755 r
.52267 .39939 .52633 .40242 .52936 .4044 .5257 .40136 Mtetra
0 .345 .813 r
.5257 .40136 .52936 .4044 .5324 .40617 .52874 .40313 Mtetra
.224 .502 .904 r
.52874 .40313 .5324 .40617 .53544 .40724 .53178 .4042 Mtetra
.482 .594 .889 r
.53178 .4042 .53544 .40724 .53849 .40724 .53482 .40419 Mtetra
.617 .62 .831 r
.53482 .40419 .53849 .40724 .54152 .40588 .53785 .40283 Mtetra
.682 .623 .783 r
.53785 .40283 .54152 .40588 .54456 .40304 .54088 .39999 Mtetra
.715 .621 .751 r
.54088 .39999 .54456 .40304 .54758 .39875 .5439 .3957 Mtetra
.734 .618 .73 r
.5439 .3957 .54758 .39875 .55059 .39315 .54691 .39009 Mtetra
.744 .616 .716 r
.54691 .39009 .55059 .39315 .55359 .38649 .54991 .38343 Mtetra
.75 .615 .709 r
.54991 .38343 .55359 .38649 .55658 .3791 .55291 .37604 Mtetra
.753 .614 .705 r
.55291 .37604 .55658 .3791 .55956 .37136 .55589 .3683 Mtetra
.752 .614 .706 r
.55589 .3683 .55956 .37136 .56255 .36367 .55888 .3606 Mtetra
.749 .615 .71 r
.55888 .3606 .56255 .36367 .56553 .35639 .56187 .35333 Mtetra
.743 .616 .718 r
.56187 .35333 .56553 .35639 .56853 .34988 .56487 .34681 Mtetra
.732 .618 .731 r
.56487 .34681 .56853 .34988 .57154 .34442 .56788 .34135 Mtetra
.713 .621 .752 r
.56788 .34135 .57154 .34442 .57457 .34021 .57091 .33713 Mtetra
.68 .622 .784 r
.57091 .33713 .57457 .34021 .57762 .33739 .57396 .33432 Mtetra
.616 .619 .83 r
.57396 .33432 .57762 .33739 .5807 .33603 .57703 .33295 Mtetra
.474 .59 .89 r
.57703 .33295 .5807 .33603 .5838 .33608 .58014 .333 Mtetra
.132 .456 .886 r
.58014 .333 .5838 .33608 .58694 .33746 .58327 .33437 Mtetra
0 .116 .594 r
.58327 .33437 .58694 .33746 .5901 .33999 .58642 .3369 Mtetra
.699 .169 0 r
.58642 .3369 .5901 .33999 .59329 .34345 .58961 .34035 Mtetra
.793 .295 0 r
.58961 .34035 .59329 .34345 .5965 .34758 .59281 .34448 Mtetra
.82 .342 .052 r
.59281 .34448 .5965 .34758 .59973 .35208 .59603 .34898 Mtetra
.822 .347 .061 r
.59603 .34898 .59973 .35208 .60297 .35665 .59927 .35354 Mtetra
.805 .315 .005 r
.59927 .35354 .60297 .35665 .60622 .36096 .60251 .35785 Mtetra
.742 .222 0 r
.60251 .35785 .60622 .36096 .60947 .36473 .60576 .36162 Mtetra
.541 .005 0 r
.60576 .36162 .60947 .36473 .61271 .36768 .609 .36456 Mtetra
0 .344 .813 r
.609 .36456 .61271 .36768 .61595 .36958 .61223 .36645 Mtetra
.362 .556 .907 r
.61223 .36645 .61595 .36958 .61916 .37022 .61544 .3671 Mtetra
.566 .612 .858 r
.61544 .3671 .61916 .37022 .62235 .36949 .61863 .36636 Mtetra
.656 .623 .804 r
.61863 .36636 .62235 .36949 .62552 .36729 .62179 .36415 Mtetra
.701 .623 .766 r
.62179 .36415 .62552 .36729 .62865 .3636 .62492 .36046 Mtetra
.727 .62 .739 r
.62492 .36046 .62865 .3636 .63175 .35846 .62802 .35532 Mtetra
.742 .618 .72 r
.62802 .35532 .63175 .35846 .63482 .35197 .63109 .34883 Mtetra
.753 .616 .707 r
.63109 .34883 .63482 .35197 .63785 .34425 .63413 .34111 Mtetra
.759 .614 .698 r
.63413 .34111 .63785 .34425 .64086 .3355 .63714 .33235 Mtetra
.764 .613 .692 r
.63714 .33235 .64086 .3355 .64384 .32592 .64012 .32277 Mtetra
.767 .612 .687 r
.64012 .32277 .64384 .32592 .64681 .31575 .64309 .31261 Mtetra
.768 .612 .685 r
.64309 .31261 .64681 .31575 .64976 .30526 .64605 .30211 Mtetra
.64605 .30211 .64976 .30526 .6527 .2947 .64899 .29155 Mtetra
.768 .612 .686 r
.64899 .29155 .6527 .2947 .65564 .28433 .65194 .28118 Mtetra
.766 .612 .689 r
.65194 .28118 .65564 .28433 .6586 .2744 .65489 .27124 Mtetra
.763 .613 .693 r
.65489 .27124 .6586 .2744 .66156 .26513 .65787 .26198 Mtetra
.757 .615 .7 r
.65787 .26198 .66156 .26513 .66455 .25674 .66086 .25359 Mtetra
.75 .616 .71 r
.66086 .25359 .66455 .25674 .66757 .24941 .66388 .24625 Mtetra
.739 .618 .724 r
.66388 .24625 .66757 .24941 .67063 .24328 .66694 .24012 Mtetra
.722 .62 .744 r
.66694 .24012 .67063 .24328 .67373 .23846 .67004 .23529 Mtetra
.694 .622 .771 r
.67004 .23529 .67373 .23846 .67688 .23503 .67319 .23186 Mtetra
.646 .621 .81 r
.67319 .23186 .67688 .23503 .68008 .23303 .67639 .22986 Mtetra
.549 .607 .863 r
.67639 .22986 .68008 .23303 .68334 .23246 .67964 .22928 Mtetra
.33 .54 .906 r
.67964 .22928 .68334 .23246 .68665 .23328 .68295 .23011 Mtetra
0 .298 .778 r
.68295 .23011 .68665 .23328 .69001 .23544 .68631 .23226 Mtetra
.61 .075 0 r
.68631 .23226 .69001 .23544 .69343 .23882 .68972 .23564 Mtetra
.79 .292 0 r
.68972 .23564 .69343 .23882 .6969 .24331 .69319 .24012 Mtetra
.842 .387 .125 r
.69319 .24012 .6969 .24331 .70042 .24873 .6967 .24554 Mtetra
.858 .433 .212 r
.6967 .24554 .70042 .24873 .70398 .25492 .70025 .25172 Mtetra
.863 .456 .258 r
.70025 .25172 .70398 .25492 .70758 .26168 .70385 .25847 Mtetra
.865 .467 .281 r
.70385 .25847 .70758 .26168 .71121 .26879 .70747 .26558 Mtetra
.865 .47 .288 r
.70747 .26558 .71121 .26879 .71486 .27603 .71111 .27282 Mtetra
.865 .466 .28 r
.71111 .27282 .71486 .27603 .71853 .28319 .71477 .27997 Mtetra
.809 .51 .484 r
.27071 .55952 .27428 .56091 .2766 .56797 .27303 .56658 Mtetra
.809 .512 .486 r
.27303 .56658 .2766 .56797 .27893 .57518 .27535 .57379 Mtetra
.809 .511 .484 r
.27535 .57379 .27893 .57518 .28128 .58233 .27769 .58094 Mtetra
.809 .506 .477 r
.27769 .58094 .28128 .58233 .28364 .58919 .28005 .58781 Mtetra
.809 .498 .463 r
.28005 .58781 .28364 .58919 .28604 .59557 .28243 .59418 Mtetra
.808 .483 .439 r
.28243 .59418 .28604 .59557 .28847 .60124 .28486 .59986 Mtetra
.805 .456 .396 r
.28486 .59986 .28847 .60124 .29094 .60604 .28732 .60466 Mtetra
.794 .403 .312 r
.28732 .60466 .29094 .60604 .29345 .60978 .28984 .60839 Mtetra
.744 .267 .111 r
.28984 .60839 .29345 .60978 .29602 .61232 .2924 .61094 Mtetra
.395 0 0 r
.2924 .61094 .29602 .61232 .29864 .61355 .29501 .61216 Mtetra
.441 .714 .982 r
.29501 .61216 .29864 .61355 .30131 .61338 .29768 .612 Mtetra
.674 .714 .879 r
.29768 .612 .30131 .61338 .30403 .61178 .3004 .6104 Mtetra
.733 .685 .804 r
.3004 .6104 .30403 .61178 .3068 .60875 .30317 .60736 Mtetra
.755 .665 .762 r
.30317 .60736 .3068 .60875 .30962 .60432 .30599 .60293 Mtetra
.766 .653 .736 r
.30599 .60293 .30962 .60432 .31248 .59858 .30885 .59718 Mtetra
.773 .644 .72 r
.30885 .59718 .31248 .59858 .31538 .59164 .31175 .59024 Mtetra
.777 .639 .709 r
.31175 .59024 .31538 .59164 .3183 .58366 .31468 .58226 Mtetra
.779 .635 .701 r
.31468 .58226 .3183 .58366 .32126 .57483 .31764 .57342 Mtetra
.781 .632 .696 r
.31764 .57342 .32126 .57483 .32422 .56536 .32061 .56395 Mtetra
.782 .631 .693 r
.32061 .56395 .32422 .56536 .3272 .55549 .32359 .55407 Mtetra
.782 .63 .692 r
.32359 .55407 .3272 .55549 .33017 .54546 .32657 .54404 Mtetra
.782 .63 .693 r
.32657 .54404 .33017 .54546 .33314 .53553 .32954 .5341 Mtetra
.781 .632 .695 r
.32954 .5341 .33314 .53553 .3361 .52595 .3325 .52452 Mtetra
.78 .634 .699 r
.3325 .52452 .3361 .52595 .33904 .51695 .33544 .51551 Mtetra
.778 .637 .706 r
.33544 .51551 .33904 .51695 .34195 .50876 .33836 .50732 Mtetra
.774 .642 .716 r
.33836 .50732 .34195 .50876 .34483 .50157 .34125 .50012 Mtetra
.768 .65 .731 r
.34125 .50012 .34483 .50157 .34769 .49554 .3441 .49409 Mtetra
.758 .661 .755 r
.3441 .49409 .34769 .49554 .35051 .4908 .34692 .48935 Mtetra
.738 .678 .792 r
.34692 .48935 .35051 .4908 .3533 .48744 .34971 .48598 Mtetra
.693 .702 .854 r
.34971 .48598 .3533 .48744 .35605 .48547 .35247 .48402 Mtetra
.55 .722 .953 r
.35247 .48402 .35605 .48547 .35878 .48489 .35519 .48344 Mtetra
0 .501 .847 r
.35519 .48344 .35878 .48489 .36148 .48563 .35789 .48417 Mtetra
.636 .079 0 r
.35789 .48417 .36148 .48563 .36416 .48756 .36057 .4861 Mtetra
.767 .308 .16 r
.36057 .4861 .36416 .48756 .36683 .49051 .36323 .48905 Mtetra
.795 .39 .283 r
.36323 .48905 .36683 .49051 .36948 .49427 .36588 .49281 Mtetra
.804 .423 .336 r
.36588 .49281 .36948 .49427 .37213 .49859 .36853 .49713 Mtetra
.806 .436 .355 r
.36853 .49713 .37213 .49859 .37479 .50318 .37118 .50172 Mtetra
.806 .434 .352 r
.37118 .50172 .37479 .50318 .37746 .50775 .37384 .50629 Mtetra
.802 .416 .324 r
.37384 .50629 .37746 .50775 .38014 .51198 .37652 .51052 Mtetra
.79 .372 .255 r
.37652 .51052 .38014 .51198 .38285 .51558 .37922 .51411 Mtetra
.744 .259 .089 r
.37922 .51411 .38285 .51558 .38558 .51827 .38195 .51681 Mtetra
.502 0 0 r
.38195 .51681 .38558 .51827 .38834 .51983 .38471 .51837 Mtetra
.279 .658 .969 r
.38471 .51837 .38834 .51983 .39114 .52008 .3875 .51862 Mtetra
.632 .721 .912 r
.3875 .51862 .39114 .52008 .39396 .51891 .39032 .51745 Mtetra
.718 .693 .825 r
.39032 .51745 .39396 .51891 .39681 .51629 .39318 .51482 Mtetra
.749 .672 .776 r
.39318 .51482 .39681 .51629 .39969 .51226 .39606 .51079 Mtetra
.763 .659 .747 r
.39606 .51079 .39969 .51226 .40259 .50698 .39896 .5055 Mtetra
.771 .651 .73 r
.39896 .5055 .40259 .50698 .40551 .50065 .40188 .49917 Mtetra
.775 .646 .719 r
.40188 .49917 .40551 .50065 .40844 .49357 .40481 .49209 Mtetra
.776 .643 .715 r
.40481 .49209 .40844 .49357 .41137 .48607 .40775 .48459 Mtetra
.777 .643 .714 r
.40775 .48459 .41137 .48607 .41431 .47855 .41068 .47706 Mtetra
.775 .645 .718 r
.41068 .47706 .41431 .47855 .41723 .47137 .41361 .46988 Mtetra
.771 .65 .728 r
.41361 .46988 .41723 .47137 .42015 .46491 .41653 .46341 Mtetra
.764 .658 .744 r
.41653 .46341 .42015 .46491 .42305 .45949 .41944 .45799 Mtetra
.75 .671 .773 r
.41944 .45799 .42305 .45949 .42594 .45535 .42232 .45385 Mtetra
.72 .691 .821 r
.42232 .45385 .42594 .45535 .42881 .45263 .4252 .45113 Mtetra
.641 .717 .903 r
.4252 .45113 .42881 .45263 .43167 .45135 .42806 .44984 Mtetra
.377 .688 .98 r
.42806 .44984 .43167 .45135 .43453 .45139 .4309 .44988 Mtetra
0 .352 .698 r
.4309 .44988 .43453 .45139 .43737 .45249 .43375 .45098 Mtetra
.559 0 0 r
.43375 .45098 .43737 .45249 .44022 .45429 .43659 .45278 Mtetra
.621 .057 0 r
.43659 .45278 .44022 .45429 .44307 .4563 .43944 .45478 Mtetra
.523 0 0 r
.43944 .45478 .44307 .4563 .44593 .458 .4423 .45649 Mtetra
0 .459 .81 r
.4423 .45649 .44593 .458 .44881 .45889 .44517 .45738 Mtetra
.491 .715 .971 r
.44517 .45738 .44881 .45889 .45171 .45856 .44807 .45704 Mtetra
.679 .709 .871 r
.44807 .45704 .45171 .45856 .45461 .45675 .45097 .45524 Mtetra
.734 .684 .802 r
.45097 .45524 .45461 .45675 .45754 .45349 .4539 .45197 Mtetra
.754 .669 .767 r
.4539 .45197 .45754 .45349 .46047 .44905 .45683 .44753 Mtetra
.761 .663 .754 r
.45683 .44753 .46047 .44905 .46341 .44401 .45977 .44248 Mtetra
.759 .664 .757 r
.45977 .44248 .46341 .44401 .46635 .43913 .46271 .4376 Mtetra
.747 .675 .781 r
.46271 .4376 .46635 .43913 .46929 .43521 .46565 .43368 Mtetra
.708 .698 .838 r
.46565 .43368 .46929 .43521 .47222 .4328 .46858 .43127 Mtetra
.603 .721 .928 r
.46858 .43127 .47222 .4328 .47515 .43184 .47151 .4303 Mtetra
.525 .718 .961 r
.47151 .4303 .47515 .43184 .47808 .43135 .47444 .42981 Mtetra
.673 .71 .876 r
.47444 .42981 .47808 .43135 .48103 .42961 .47738 .42807 Mtetra
.727 .688 .813 r
.47738 .42807 .48103 .42961 .48398 .42661 .48033 .42506 Mtetra
.673 .71 .876 r
.48033 .42506 .48398 .42661 .48693 .42487 .48328 .42332 Mtetra
.526 .718 .961 r
.48328 .42332 .48693 .42487 .48988 .42437 .48624 .42282 Mtetra
.603 .721 .927 r
.48624 .42282 .48988 .42437 .49284 .42339 .4892 .42184 Mtetra
.708 .698 .839 r
.4892 .42184 .49284 .42339 .49581 .42096 .49216 .4194 Mtetra
.747 .676 .782 r
.49216 .4194 .49581 .42096 .49878 .417 .49513 .41545 Mtetra
.76 .665 .757 r
.49513 .41545 .49878 .417 .50175 .41208 .4981 .41052 Mtetra
.762 .664 .754 r
.4981 .41052 .50175 .41208 .50472 .40699 .50107 .40543 Mtetra
.755 .67 .768 r
.50107 .40543 .50472 .40699 .50769 .4025 .50405 .40093 Mtetra
.734 .684 .802 r
.50405 .40093 .50769 .4025 .51067 .39918 .50702 .39761 Mtetra
.68 .708 .869 r
.50702 .39761 .51067 .39918 .51365 .39731 .51001 .39574 Mtetra
.505 .714 .966 r
.51001 .39574 .51365 .39731 .51665 .39691 .513 .39534 Mtetra
.001 .507 .861 r
.513 .39534 .51665 .39691 .51965 .39774 .51601 .39617 Mtetra
.455 0 0 r
.51601 .39617 .51965 .39774 .52267 .39939 .51902 .39782 Mtetra
.569 0 0 r
.51902 .39782 .52267 .39939 .5257 .40136 .52205 .39979 Mtetra
.496 0 0 r
.52205 .39979 .5257 .40136 .52874 .40313 .52508 .40155 Mtetra
0 .411 .767 r
.52508 .40155 .52874 .40313 .53178 .4042 .52811 .40262 Mtetra
.399 .692 .979 r
.52811 .40262 .53178 .4042 .53482 .40419 .53115 .40261 Mtetra
.641 .717 .903 r
.53115 .40261 .53482 .40419 .53785 .40283 .53419 .40124 Mtetra
.72 .693 .824 r
.53419 .40124 .53785 .40283 .54088 .39999 .53722 .3984 Mtetra
.752 .674 .775 r
.53722 .3984 .54088 .39999 .5439 .3957 .54024 .39411 Mtetra
.767 .661 .746 r
.54024 .39411 .5439 .3957 .54691 .39009 .54325 .3885 Mtetra
.774 .653 .728 r
.54325 .3885 .54691 .39009 .54991 .38343 .54625 .38183 Mtetra
.778 .648 .719 r
.54625 .38183 .54991 .38343 .55291 .37604 .54925 .37444 Mtetra
.78 .646 .714 r
.54925 .37444 .55291 .37604 .55589 .3683 .55224 .36669 Mtetra
.78 .647 .715 r
.55224 .36669 .55589 .3683 .55888 .3606 .55523 .35899 Mtetra
.778 .649 .72 r
.55523 .35899 .55888 .3606 .56187 .35333 .55822 .35171 Mtetra
.773 .654 .73 r
.55822 .35171 .56187 .35333 .56487 .34681 .56122 .3452 Mtetra
.765 .662 .748 r
.56122 .3452 .56487 .34681 .56788 .34135 .56423 .33973 Mtetra
.75 .674 .777 r
.56423 .33973 .56788 .34135 .57091 .33713 .56726 .33551 Mtetra
.719 .693 .824 r
.56726 .33551 .57091 .33713 .57396 .33432 .57031 .33269 Mtetra
.64 .714 .902 r
.57031 .33269 .57396 .33432 .57703 .33295 .57339 .33132 Mtetra
.384 .683 .977 r
.57339 .33132 .57703 .33295 .58014 .333 .57649 .33137 Mtetra
0 .303 .659 r
.57649 .33137 .58014 .333 .58327 .33437 .57961 .33274 Mtetra
.67 .123 0 r
.57961 .33274 .58327 .33437 .58642 .3369 .58277 .33526 Mtetra
.766 .29 .111 r
.58277 .33526 .58642 .3369 .58961 .34035 .58594 .33872 Mtetra
.793 .357 .21 r
.58594 .33872 .58961 .34035 .59281 .34448 .58914 .34285 Mtetra
.802 .382 .25 r
.58914 .34285 .59281 .34448 .59603 .34898 .59236 .34735 Mtetra
.803 .385 .255 r
.59236 .34735 .59603 .34898 .59927 .35354 .59559 .35191 Mtetra
.797 .367 .227 r
.59559 .35191 .59927 .35354 .60251 .35785 .59883 .35622 Mtetra
.778 .318 .152 r
.59883 .35622 .60251 .35785 .60576 .36162 .60207 .35998 Mtetra
.719 .201 0 r
.60207 .35998 .60576 .36162 .609 .36456 .60531 .36293 Mtetra
.49 0 0 r
.60531 .36293 .609 .36456 .61223 .36645 .60853 .36482 Mtetra
.139 .583 .927 r
.60853 .36482 .61223 .36645 .61544 .3671 .61174 .36546 Mtetra
.561 .719 .947 r
.61174 .36546 .61544 .3671 .61863 .36636 .61493 .36472 Mtetra
.692 .706 .858 r
.61493 .36472 .61863 .36636 .62179 .36415 .61809 .36251 Mtetra
.74 .685 .797 r
.61809 .36251 .62179 .36415 .62492 .36046 .62122 .35882 Mtetra
.762 .669 .759 r
.62122 .35882 .62492 .36046 .62802 .35532 .62432 .35367 Mtetra
.774 .657 .734 r
.62432 .35367 .62802 .35532 .63109 .34883 .62739 .34717 Mtetra
.781 .65 .717 r
.62739 .34717 .63109 .34883 .63413 .34111 .63044 .33945 Mtetra
.786 .644 .705 r
.63044 .33945 .63413 .34111 .63714 .33235 .63345 .33069 Mtetra
.789 .641 .698 r
.63345 .33069 .63714 .33235 .64012 .32277 .63644 .3211 Mtetra
.791 .638 .693 r
.63644 .3211 .64012 .32277 .64309 .31261 .63941 .31093 Mtetra
.791 .637 .69 r
.63941 .31093 .64309 .31261 .64605 .30211 .64237 .30043 Mtetra
.792 .637 .689 r
.64237 .30043 .64605 .30211 .64899 .29155 .64532 .28987 Mtetra
.791 .637 .691 r
.64532 .28987 .64899 .29155 .65194 .28118 .64827 .27949 Mtetra
.79 .639 .694 r
.64827 .27949 .65194 .28118 .65489 .27124 .65123 .26955 Mtetra
.788 .642 .7 r
.65123 .26955 .65489 .27124 .65787 .26198 .65421 .26028 Mtetra
.785 .646 .708 r
.65421 .26028 .65787 .26198 .66086 .25359 .6572 .25189 Mtetra
.78 .651 .721 r
.6572 .25189 .66086 .25359 .66388 .24625 .66023 .24454 Mtetra
.771 .659 .739 r
.66023 .24454 .66388 .24625 .66694 .24012 .66329 .23841 Mtetra
.758 .67 .765 r
.66329 .23841 .66694 .24012 .67004 .23529 .66639 .23358 Mtetra
.733 .686 .805 r
.66639 .23358 .67004 .23529 .67319 .23186 .66954 .23014 Mtetra
.679 .705 .867 r
.66954 .23014 .67319 .23186 .67639 .22986 .67274 .22814 Mtetra
.534 .71 .952 r
.67274 .22814 .67639 .22986 .67964 .22928 .67599 .22756 Mtetra
.085 .546 .905 r
.67599 .22756 .67964 .22928 .68295 .23011 .67929 .22838 Mtetra
.53 0 0 r
.67929 .22838 .68295 .23011 .68631 .23226 .68265 .23053 Mtetra
.743 .237 .02 r
.68265 .23053 .68631 .23226 .68972 .23564 .68606 .23391 Mtetra
.797 .355 .195 r
.68606 .23391 .68972 .23564 .69319 .24012 .68952 .23839 Mtetra
.815 .41 .281 r
.68952 .23839 .69319 .24012 .6967 .24554 .69302 .24381 Mtetra
.822 .439 .328 r
.69302 .24381 .6967 .24554 .70025 .25172 .69657 .25 Mtetra
.825 .455 .354 r
.69657 .25 .70025 .25172 .70385 .25847 .70016 .25675 Mtetra
.826 .463 .368 r
.70016 .25675 .70385 .25847 .70747 .26558 .70377 .26385 Mtetra
.827 .465 .371 r
.70377 .26385 .70747 .26558 .71111 .27282 .70741 .27109 Mtetra
.826 .462 .367 r
.70741 .27109 .71111 .27282 .71477 .27997 .71106 .27824 Mtetra
.776 .493 .507 r
.26708 .5596 .27071 .55952 .27303 .56658 .26939 .56667 Mtetra
.777 .495 .509 r
.26939 .56667 .27303 .56658 .27535 .57379 .27171 .57388 Mtetra
.776 .494 .507 r
.27171 .57388 .27535 .57379 .27769 .58094 .27404 .58103 Mtetra
.775 .489 .502 r
.27404 .58103 .27769 .58094 .28005 .58781 .27639 .58791 Mtetra
.773 .481 .492 r
.27639 .58791 .28005 .58781 .28243 .59418 .27877 .59429 Mtetra
.768 .467 .476 r
.27877 .59429 .28243 .59418 .28486 .59986 .28119 .59997 Mtetra
.76 .444 .449 r
.28119 .59997 .28486 .59986 .28732 .60466 .28365 .60477 Mtetra
.745 .402 .401 r
.28365 .60477 .28732 .60466 .28984 .60839 .28616 .60851 Mtetra
.709 .316 .303 r
.28616 .60851 .28984 .60839 .2924 .61094 .28872 .61106 Mtetra
.581 .085 .041 r
.28872 .61106 .2924 .61094 .29501 .61216 .29133 .61228 Mtetra
.083 .643 .756 r
.29133 .61228 .29501 .61216 .29768 .612 .294 .61212 Mtetra
.703 .868 .96 r
.294 .61212 .29768 .612 .3004 .6104 .29672 .61052 Mtetra
.786 .783 .849 r
.29672 .61052 .3004 .6104 .30317 .60736 .29949 .60748 Mtetra
.801 .732 .787 r
.29949 .60748 .30317 .60736 .30599 .60293 .30231 .60304 Mtetra
.805 .703 .752 r
.30231 .60304 .30599 .60293 .30885 .59718 .30517 .59729 Mtetra
.806 .685 .731 r
.30517 .59729 .30885 .59718 .31175 .59024 .30808 .59034 Mtetra
.806 .673 .717 r
.30808 .59034 .31175 .59024 .31468 .58226 .31101 .58235 Mtetra
.806 .665 .708 r
.31101 .58235 .31468 .58226 .31764 .57342 .31397 .57351 Mtetra
.806 .661 .702 r
.31397 .57351 .31764 .57342 .32061 .56395 .31695 .56403 Mtetra
.806 .658 .698 r
.31695 .56403 .32061 .56395 .32359 .55407 .31993 .55415 Mtetra
.806 .657 .697 r
.31993 .55415 .32359 .55407 .32657 .54404 .32292 .54411 Mtetra
.806 .657 .698 r
.32292 .54411 .32657 .54404 .32954 .5341 .3259 .53416 Mtetra
.806 .659 .7 r
.3259 .53416 .32954 .5341 .3325 .52452 .32886 .52456 Mtetra
.806 .664 .705 r
.32886 .52456 .3325 .52452 .33544 .51551 .33181 .51555 Mtetra
.806 .67 .713 r
.33181 .51555 .33544 .51551 .33836 .50732 .33473 .50735 Mtetra
.806 .681 .726 r
.33473 .50735 .33836 .50732 .34125 .50012 .33762 .50015 Mtetra
.805 .696 .745 r
.33762 .50015 .34125 .50012 .3441 .49409 .34047 .49412 Mtetra
.801 .722 .777 r
.34047 .49412 .3441 .49409 .34692 .48935 .3433 .48937 Mtetra
.79 .764 .83 r
.3433 .48937 .34692 .48935 .34971 .48598 .34609 .486 Mtetra
.738 .837 .925 r
.34609 .486 .34971 .48598 .35247 .48402 .34884 .48403 Mtetra
.394 .826 .957 r
.34884 .48403 .35247 .48402 .35519 .48344 .35156 .48345 Mtetra
.43 0 0 r
.35156 .48345 .35519 .48344 .35789 .48417 .35426 .48419 Mtetra
.667 .221 .182 r
.35426 .48419 .35789 .48417 .36057 .4861 .35694 .48612 Mtetra
.725 .341 .322 r
.35694 .48612 .36057 .4861 .36323 .48905 .35959 .48907 Mtetra
.747 .393 .383 r
.35959 .48907 .36323 .48905 .36588 .49281 .36224 .49284 Mtetra
.756 .418 .412 r
.36224 .49284 .36588 .49281 .36853 .49713 .36488 .49716 Mtetra
.76 .428 .423 r
.36488 .49716 .36853 .49713 .37118 .50172 .36753 .50175 Mtetra
.759 .426 .421 r
.36753 .50175 .37118 .50172 .37384 .50629 .37019 .50632 Mtetra
.754 .413 .405 r
.37019 .50632 .37384 .50629 .37652 .51052 .37287 .51055 Mtetra
.742 .381 .368 r
.37287 .51055 .37652 .51052 .37922 .51411 .37556 .51416 Mtetra
.712 .313 .289 r
.37556 .51416 .37922 .51411 .38195 .51681 .37829 .51685 Mtetra
.62 .139 .091 r
.37829 .51685 .38195 .51681 .38471 .51837 .38104 .51842 Mtetra
.182 0 0 r
.38104 .51842 .38471 .51837 .3875 .51862 .38383 .51866 Mtetra
.612 .881 .99 r
.38383 .51866 .3875 .51862 .39032 .51745 .38666 .51749 Mtetra
.772 .808 .882 r
.38666 .51749 .39032 .51745 .39318 .51482 .38951 .51486 Mtetra
.799 .749 .807 r
.38951 .51486 .39318 .51482 .39606 .51079 .39239 .51083 Mtetra
.806 .716 .766 r
.39239 .51083 .39606 .51079 .39896 .5055 .39529 .50554 Mtetra
.808 .698 .743 r
.39529 .50554 .39896 .5055 .40188 .49917 .39822 .4992 Mtetra
.809 .687 .73 r
.39822 .4992 .40188 .49917 .40481 .49209 .40115 .49211 Mtetra
.809 .682 .724 r
.40115 .49211 .40481 .49209 .40775 .48459 .40409 .4846 Mtetra
.40409 .4846 .40775 .48459 .41068 .47706 .40703 .47707 Mtetra
.809 .686 .729 r
.40703 .47707 .41068 .47706 .41361 .46988 .40996 .46988 Mtetra
.808 .696 .741 r
.40996 .46988 .41361 .46988 .41653 .46341 .41289 .46341 Mtetra
.806 .713 .763 r
.41289 .46341 .41653 .46341 .41944 .45799 .41579 .45799 Mtetra
.799 .745 .802 r
.41579 .45799 .41944 .45799 .42232 .45385 .41868 .45384 Mtetra
.774 .801 .875 r
.41868 .45384 .42232 .45385 .4252 .45113 .42155 .45111 Mtetra
.637 .876 .986 r
.42155 .45111 .4252 .45113 .42806 .44984 .42441 .44983 Mtetra
.021 0 0 r
.42441 .44983 .42806 .44984 .4309 .44988 .42726 .44987 Mtetra
.525 0 0 r
.42726 .44987 .4309 .44988 .43375 .45098 .4301 .45097 Mtetra
.642 .171 .119 r
.4301 .45097 .43375 .45098 .43659 .45278 .43294 .45276 Mtetra
.664 .209 .163 r
.43294 .45276 .43659 .45278 .43944 .45478 .43579 .45477 Mtetra
.63 .151 .096 r
.43579 .45477 .43944 .45478 .4423 .45649 .43865 .45648 Mtetra
.461 0 0 r
.43865 .45648 .4423 .45649 .44517 .45738 .44152 .45737 Mtetra
.231 .742 .878 r
.44152 .45737 .44517 .45738 .44807 .45704 .44441 .45703 Mtetra
.714 .856 .95 r
.44441 .45703 .44807 .45704 .45097 .45524 .44732 .45523 Mtetra
.788 .78 .846 r
.44732 .45523 .45097 .45524 .4539 .45197 .45024 .45196 Mtetra
.803 .74 .794 r
.45024 .45196 .4539 .45197 .45683 .44753 .45318 .44751 Mtetra
.806 .725 .775 r
.45318 .44751 .45683 .44753 .45977 .44248 .45612 .44246 Mtetra
.805 .729 .78 r
.45612 .44246 .45977 .44248 .46271 .4376 .45906 .43758 Mtetra
.798 .756 .815 r
.45906 .43758 .46271 .4376 .46565 .43368 .462 .43365 Mtetra
.759 .822 .901 r
.462 .43365 .46565 .43368 .46858 .43127 .46493 .43124 Mtetra
.544 .871 .993 r
.46493 .43124 .46858 .43127 .47151 .4303 .46786 .43027 Mtetra
.327 .794 .931 r
.46786 .43027 .47151 .4303 .47444 .42981 .47079 .42978 Mtetra
.704 .86 .956 r
.47079 .42978 .47444 .42981 .47738 .42807 .47373 .42804 Mtetra
.781 .793 .862 r
.47373 .42804 .47738 .42807 .48033 .42506 .47668 .42503 Mtetra
.704 .86 .956 r
.47668 .42503 .48033 .42506 .48328 .42332 .47963 .42328 Mtetra
.331 .796 .933 r
.47963 .42328 .48328 .42332 .48624 .42282 .48258 .42278 Mtetra
.545 .871 .993 r
.48258 .42278 .48624 .42282 .4892 .42184 .48554 .4218 Mtetra
.759 .823 .902 r
.48554 .4218 .4892 .42184 .49216 .4194 .48851 .41936 Mtetra
.798 .758 .816 r
.48851 .41936 .49216 .4194 .49513 .41545 .49148 .4154 Mtetra
.806 .731 .781 r
.49148 .4154 .49513 .41545 .4981 .41052 .49445 .41047 Mtetra
.807 .727 .776 r
.49445 .41047 .4981 .41052 .50107 .40543 .49742 .40537 Mtetra
.803 .742 .795 r
.49742 .40537 .50107 .40543 .50405 .40093 .5004 .40088 Mtetra
.788 .781 .846 r
.5004 .40088 .50405 .40093 .50702 .39761 .50338 .39755 Mtetra
.716 .853 .947 r
.50338 .39755 .50702 .39761 .51001 .39574 .50636 .39568 Mtetra
.279 .768 .91 r
.50636 .39568 .51001 .39574 .513 .39534 .50936 .39528 Mtetra
.417 0 0 r
.50936 .39528 .513 .39534 .51601 .39617 .51236 .3961 Mtetra
.61 .111 .042 r
.51236 .3961 .51601 .39617 .51902 .39782 .51537 .39776 Mtetra
.649 .176 .116 r
.51537 .39776 .51902 .39782 .52205 .39979 .51839 .39973 Mtetra
.624 .134 .068 r
.51839 .39973 .52205 .39979 .52508 .40155 .52142 .40149 Mtetra
.491 0 0 r
.52142 .40149 .52508 .40155 .52811 .40262 .52446 .40257 Mtetra
.027 .599 .739 r
.52446 .40257 .52811 .40262 .53115 .40261 .52749 .40255 Mtetra
.638 .876 .986 r
.52749 .40255 .53115 .40261 .53419 .40124 .53053 .40119 Mtetra
.774 .807 .879 r
.53053 .40119 .53419 .40124 .53722 .3984 .53356 .39835 Mtetra
.802 .751 .806 r
.53356 .39835 .53722 .3984 .54024 .39411 .53658 .39404 Mtetra
.81 .72 .765 r
.53658 .39404 .54024 .39411 .54325 .3885 .53959 .38843 Mtetra
.813 .702 .742 r
.53959 .38843 .54325 .3885 .54625 .38183 .5426 .38176 Mtetra
.814 .692 .729 r
.5426 .38176 .54625 .38183 .54925 .37444 .5456 .37436 Mtetra
.815 .688 .724 r
.5456 .37436 .54925 .37444 .55224 .36669 .54859 .36661 Mtetra
.815 .688 .725 r
.54859 .36661 .55224 .36669 .55523 .35899 .55159 .3589 Mtetra
.814 .693 .731 r
.55159 .3589 .55523 .35899 .55822 .35171 .55458 .35161 Mtetra
.813 .704 .745 r
.55458 .35161 .55822 .35171 .56122 .3452 .55758 .34509 Mtetra
.81 .722 .768 r
.55758 .34509 .56122 .3452 .56423 .33973 .5606 .33962 Mtetra
.801 .753 .809 r
.5606 .33962 .56423 .33973 .56726 .33551 .56363 .3354 Mtetra
.772 .806 .88 r
.56363 .3354 .56726 .33551 .57031 .33269 .56668 .33258 Mtetra
.638 .871 .985 r
.56668 .33258 .57031 .33269 .57339 .33132 .56975 .3312 Mtetra
.009 .584 .734 r
.56975 .3312 .57339 .33132 .57649 .33137 .57285 .33125 Mtetra
.548 .011 0 r
.57285 .33125 .57649 .33137 .57961 .33274 .57598 .33262 Mtetra
.689 .242 .184 r
.57598 .33262 .57961 .33274 .58277 .33526 .57913 .33515 Mtetra
.733 .332 .29 r
.57913 .33515 .58277 .33526 .58594 .33872 .5823 .33861 Mtetra
.751 .373 .338 r
.5823 .33861 .58594 .33872 .58914 .34285 .5855 .34274 Mtetra
.758 .39 .359 r
.5855 .34274 .58914 .34285 .59236 .34735 .58871 .34724 Mtetra
.758 .392 .362 r
.58871 .34724 .59236 .34735 .59559 .35191 .59194 .3518 Mtetra
.753 .38 .347 r
.59194 .3518 .59559 .35191 .59883 .35622 .59517 .35612 Mtetra
.74 .349 .31 r
.59517 .35612 .59883 .35622 .60207 .35998 .59841 .35989 Mtetra
.709 .282 .232 r
.59841 .35989 .60207 .35998 .60531 .36293 .60164 .36284 Mtetra
.625 .13 .056 r
.60164 .36284 .60531 .36293 .60853 .36482 .60487 .36473 Mtetra
.315 0 0 r
.60487 .36473 .60853 .36482 .61174 .36546 .60807 .36537 Mtetra
.434 .839 .974 r
.60807 .36537 .61174 .36546 .61493 .36472 .61126 .36463 Mtetra
.736 .846 .932 r
.61126 .36463 .61493 .36472 .61809 .36251 .61442 .36242 Mtetra
.795 .78 .839 r
.61442 .36242 .61809 .36251 .62122 .35882 .61755 .35872 Mtetra
.811 .737 .783 r
.61755 .35872 .62122 .35882 .62432 .35367 .62066 .35357 Mtetra
.816 .711 .749 r
.62066 .35357 .62432 .35367 .62739 .34717 .62373 .34707 Mtetra
.818 .694 .727 r
.62373 .34707 .62739 .34717 .63044 .33945 .62678 .33934 Mtetra
.819 .683 .713 r
.62678 .33934 .63044 .33945 .63345 .33069 .62979 .33057 Mtetra
.82 .675 .704 r
.62979 .33057 .63345 .33069 .63644 .3211 .63279 .32097 Mtetra
.82 .671 .698 r
.63279 .32097 .63644 .3211 .63941 .31093 .63577 .3108 Mtetra
.82 .668 .695 r
.63577 .3108 .63941 .31093 .64237 .30043 .63873 .30029 Mtetra
.82 .668 .694 r
.63873 .30029 .64237 .30043 .64532 .28987 .64169 .28971 Mtetra
.82 .669 .695 r
.64169 .28971 .64532 .28987 .64827 .27949 .64464 .27932 Mtetra
.82 .672 .699 r
.64464 .27932 .64827 .27949 .65123 .26955 .64761 .26938 Mtetra
.819 .677 .706 r
.64761 .26938 .65123 .26955 .65421 .26028 .65059 .2601 Mtetra
.819 .685 .717 r
.65059 .2601 .65421 .26028 .6572 .25189 .65359 .2517 Mtetra
.817 .697 .732 r
.65359 .2517 .6572 .25189 .66023 .24454 .65662 .24435 Mtetra
.814 .715 .756 r
.65662 .24435 .66023 .24454 .66329 .23841 .65968 .2382 Mtetra
.807 .742 .792 r
.65968 .2382 .66329 .23841 .66639 .23358 .66278 .23337 Mtetra
.787 .785 .851 r
.66278 .23337 .66639 .23358 .66954 .23014 .66593 .22993 Mtetra
.716 .846 .944 r
.66593 .22993 .66954 .23014 .67274 .22814 .66913 .22793 Mtetra
.38 .81 .965 r
.66913 .22793 .67274 .22814 .67599 .22756 .67238 .22735 Mtetra
.353 0 0 r
.67238 .22735 .67599 .22756 .67929 .22838 .67568 .22817 Mtetra
.644 .151 .064 r
.67568 .22817 .67929 .22838 .68265 .23053 .67904 .23032 Mtetra
.726 .302 .242 r
.67904 .23032 .68265 .23053 .68606 .23391 .68244 .2337 Mtetra
.757 .373 .326 r
.68244 .2337 .68606 .23391 .68952 .23839 .6859 .23819 Mtetra
.772 .411 .372 r
.6859 .23819 .68952 .23839 .69302 .24381 .6894 .24361 Mtetra
.78 .433 .399 r
.6894 .24361 .69302 .24381 .69657 .25 .69295 .2498 Mtetra
.784 .446 .415 r
.69295 .2498 .69657 .25 .70016 .25675 .69653 .25656 Mtetra
.786 .453 .423 r
.69653 .25656 .70016 .25675 .70377 .26385 .70013 .26367 Mtetra
.787 .455 .425 r
.70013 .26367 .70377 .26385 .70741 .27109 .70377 .27092 Mtetra
.786 .452 .422 r
.70377 .27092 .70741 .27109 .71106 .27824 .70741 .27807 Mtetra
.758 .484 .518 r
.2634 .56062 .26708 .5596 .26939 .56667 .26571 .56769 Mtetra
.759 .485 .519 r
.26571 .56769 .26939 .56667 .27171 .57388 .26802 .57491 Mtetra
.758 .484 .518 r
.26802 .57491 .27171 .57388 .27404 .58103 .27034 .58208 Mtetra
.756 .48 .514 r
.27034 .58208 .27404 .58103 .27639 .58791 .27269 .58896 Mtetra
.753 .471 .506 r
.27269 .58896 .27639 .58791 .27877 .59429 .27507 .59535 Mtetra
.747 .458 .493 r
.27507 .59535 .27877 .59429 .28119 .59997 .27748 .60104 Mtetra
.737 .436 .471 r
.27748 .60104 .28119 .59997 .28365 .60477 .27994 .60584 Mtetra
.719 .399 .435 r
.27994 .60584 .28365 .60477 .28616 .60851 .28244 .60959 Mtetra
.683 .329 .367 r
.28244 .60959 .28616 .60851 .28872 .61106 .285 .61214 Mtetra
.589 .168 .21 r
.285 .61214 .28872 .61106 .29133 .61228 .28761 .61337 Mtetra
.211 0 0 r
.28761 .61337 .29133 .61228 .294 .61212 .29027 .61321 Mtetra
.653 .955 .942 r
.29027 .61321 .294 .61212 .29672 .61052 .293 .6116 Mtetra
.825 .868 .877 r
.293 .6116 .29672 .61052 .29949 .60748 .29577 .60856 Mtetra
.837 .787 .804 r
.29577 .60856 .29949 .60748 .30231 .60304 .29859 .60412 Mtetra
.834 .742 .762 r
.29859 .60412 .30231 .60304 .30517 .59729 .30146 .59836 Mtetra
.831 .716 .737 r
.30146 .59836 .30517 .59729 .30808 .59034 .30436 .59141 Mtetra
.828 .699 .722 r
.30436 .59141 .30808 .59034 .31101 .58235 .3073 .58341 Mtetra
.826 .688 .711 r
.3073 .58341 .31101 .58235 .31397 .57351 .31027 .57456 Mtetra
.825 .681 .705 r
.31027 .57456 .31397 .57351 .31695 .56403 .31325 .56507 Mtetra
.824 .677 .701 r
.31325 .56507 .31695 .56403 .31993 .55415 .31624 .55517 Mtetra
.823 .676 .7 r
.31624 .55517 .31993 .55415 .32292 .54411 .31923 .54512 Mtetra
.824 .677 .7 r
.31923 .54512 .32292 .54411 .3259 .53416 .32221 .53517 Mtetra
.824 .68 .703 r
.32221 .53517 .3259 .53416 .32886 .52456 .32518 .52556 Mtetra
.825 .685 .709 r
.32518 .52556 .32886 .52456 .33181 .51555 .32813 .51654 Mtetra
.827 .695 .718 r
.32813 .51654 .33181 .51555 .33473 .50735 .33106 .50833 Mtetra
.83 .71 .732 r
.33106 .50833 .33473 .50735 .33762 .50015 .33395 .50112 Mtetra
.833 .733 .755 r
.33395 .50112 .33762 .50015 .34047 .49412 .33681 .49508 Mtetra
.835 .771 .791 r
.33681 .49508 .34047 .49412 .3433 .48937 .33964 .49033 Mtetra
.829 .839 .855 r
.33964 .49033 .3433 .48937 .34609 .486 .34243 .48696 Mtetra
.742 .943 .949 r
.34243 .48696 .34609 .486 .34884 .48403 .34518 .48499 Mtetra
0 0 0 r
.34518 .48499 .34884 .48403 .35156 .48345 .34791 .48441 Mtetra
.505 .031 .063 r
.34791 .48441 .35156 .48345 .35426 .48419 .3506 .48514 Mtetra
.65 .259 .289 r
.3506 .48514 .35426 .48419 .35694 .48612 .35327 .48708 Mtetra
.699 .349 .378 r
.35327 .48708 .35694 .48612 .35959 .48907 .35593 .49004 Mtetra
.721 .392 .421 r
.35593 .49004 .35959 .48907 .36224 .49284 .35857 .49381 Mtetra
.731 .413 .442 r
.35857 .49381 .36224 .49284 .36488 .49716 .36121 .49813 Mtetra
.735 .422 .451 r
.36121 .49813 .36488 .49716 .36753 .50175 .36386 .50274 Mtetra
.735 .421 .449 r
.36386 .50274 .36753 .50175 .37019 .50632 .36651 .50731 Mtetra
.729 .408 .437 r
.36651 .50731 .37019 .50632 .37287 .51055 .36918 .51155 Mtetra
.716 .381 .411 r
.36918 .51155 .37287 .51055 .37556 .51416 .37188 .51516 Mtetra
.687 .326 .357 r
.37188 .51516 .37556 .51416 .37829 .51685 .3746 .51786 Mtetra
.617 .203 .236 r
.3746 .51786 .37829 .51685 .38104 .51842 .37735 .51942 Mtetra
.373 0 0 r
.37735 .51942 .38104 .51842 .38383 .51866 .38014 .51967 Mtetra
.448 .882 .863 r
.38014 .51967 .38383 .51866 .38666 .51749 .38296 .5185 Mtetra
.804 .907 .912 r
.38296 .5185 .38666 .51749 .38951 .51486 .38582 .51587 Mtetra
.837 .814 .827 r
.38582 .51587 .38951 .51486 .39239 .51083 .3887 .51183 Mtetra
.839 .763 .779 r
.3887 .51183 .39239 .51083 .39529 .50554 .39161 .50654 Mtetra
.836 .735 .752 r
.39161 .50654 .39529 .50554 .39822 .4992 .39453 .50019 Mtetra
.834 .719 .737 r
.39453 .50019 .39822 .4992 .40115 .49211 .39747 .49309 Mtetra
.833 .712 .73 r
.39747 .49309 .40115 .49211 .40409 .4846 .40042 .48558 Mtetra
.833 .711 .73 r
.40042 .48558 .40409 .4846 .40703 .47707 .40336 .47803 Mtetra
.834 .717 .735 r
.40336 .47803 .40703 .47707 .40996 .46988 .4063 .47084 Mtetra
.836 .731 .749 r
.4063 .47084 .40996 .46988 .41289 .46341 .40922 .46437 Mtetra
.838 .758 .775 r
.40922 .46437 .41289 .46341 .41579 .45799 .41213 .45893 Mtetra
.837 .807 .822 r
.41213 .45893 .41579 .45799 .41868 .45384 .41502 .45478 Mtetra
.808 .897 .906 r
.41502 .45478 .41868 .45384 .42155 .45111 .41789 .45206 Mtetra
.511 .911 .903 r
.41789 .45206 .42155 .45111 .42441 .44983 .42075 .45077 Mtetra
.279 0 0 r
.42075 .45077 .42441 .44983 .42726 .44987 .4236 .45081 Mtetra
.56 .107 .134 r
.4236 .45081 .42726 .44987 .4301 .45097 .42644 .45192 Mtetra
.634 .225 .251 r
.42644 .45192 .4301 .45097 .43294 .45276 .42928 .45371 Mtetra
.649 .251 .277 r
.42928 .45371 .43294 .45276 .43579 .45477 .43212 .45573 Mtetra
.625 .211 .237 r
.43212 .45573 .43579 .45477 .43865 .45648 .43498 .45743 Mtetra
.523 .054 .081 r
.43498 .45743 .43865 .45648 .44152 .45737 .43785 .45833 Mtetra
.091 0 0 r
.43785 .45833 .44152 .45737 .44441 .45703 .44074 .45799 Mtetra
.686 .954 .952 r
.44074 .45799 .44441 .45703 .44732 .45523 .44365 .45618 Mtetra
.827 .864 .873 r
.44365 .45618 .44732 .45523 .45024 .45196 .44657 .45291 Mtetra
.84 .8 .812 r
.44657 .45291 .45024 .45196 .45318 .44751 .44951 .44846 Mtetra
.841 .776 .79 r
.44951 .44846 .45318 .44751 .45612 .44246 .45245 .44341 Mtetra
.841 .782 .795 r
.45245 .44341 .45612 .44246 .45906 .43758 .4554 .43852 Mtetra
.837 .825 .837 r
.4554 .43852 .45906 .43758 .462 .43365 .45834 .43459 Mtetra
.782 .926 .931 r
.45834 .43459 .462 .43365 .46493 .43124 .46127 .43217 Mtetra
.319 .806 .792 r
.46127 .43217 .46493 .43124 .46786 .43027 .4642 .4312 Mtetra
0 0 0 r
.4642 .4312 .46786 .43027 .47079 .42978 .46713 .43071 Mtetra
.664 .953 .95 r
.46713 .43071 .47079 .42978 .47373 .42804 .47007 .42897 Mtetra
.818 .884 .892 r
.47007 .42897 .47373 .42804 .47668 .42503 .47302 .42596 Mtetra
.664 .953 .951 r
.47302 .42596 .47668 .42503 .47963 .42328 .47597 .42421 Mtetra
0 0 0 r
.47597 .42421 .47963 .42328 .48258 .42278 .47892 .42371 Mtetra
.321 .808 .794 r
.47892 .42371 .48258 .42278 .48554 .4218 .48188 .42273 Mtetra
.781 .927 .931 r
.48188 .42273 .48554 .4218 .48851 .41936 .48485 .42029 Mtetra
.838 .828 .838 r
.48485 .42029 .48851 .41936 .49148 .4154 .48782 .41633 Mtetra
.842 .784 .796 r
.48782 .41633 .49148 .4154 .49445 .41047 .49079 .41139 Mtetra
.842 .778 .79 r
.49079 .41139 .49445 .41047 .49742 .40537 .49377 .40629 Mtetra
.841 .802 .813 r
.49377 .40629 .49742 .40537 .5004 .40088 .49675 .40179 Mtetra
.827 .865 .874 r
.49675 .40179 .5004 .40088 .50338 .39755 .49973 .39846 Mtetra
.692 .953 .953 r
.49973 .39846 .50338 .39755 .50636 .39568 .50271 .39659 Mtetra
.043 0 0 r
.50271 .39659 .50636 .39568 .50936 .39528 .5057 .39618 Mtetra
.502 .017 .036 r
.5057 .39618 .50936 .39528 .51236 .3961 .5087 .39701 Mtetra
.614 .185 .204 r
.5087 .39701 .51236 .3961 .51537 .39776 .51172 .39867 Mtetra
.64 .228 .247 r
.51172 .39867 .51537 .39776 .51839 .39973 .51474 .40064 Mtetra
.623 .2 .219 r
.51474 .40064 .51839 .39973 .52142 .40149 .51776 .40241 Mtetra
.542 .075 .095 r
.51776 .40241 .52142 .40149 .52446 .40257 .5208 .40349 Mtetra
.248 0 0 r
.5208 .40349 .52446 .40257 .52749 .40255 .52383 .40347 Mtetra
.512 .911 .904 r
.52383 .40347 .52749 .40255 .53053 .40119 .52687 .40211 Mtetra
.807 .905 .909 r
.52687 .40211 .53053 .40119 .53356 .39835 .5299 .39926 Mtetra
.842 .817 .826 r
.5299 .39926 .53356 .39835 .53658 .39404 .53292 .39496 Mtetra
.844 .767 .777 r
.53292 .39496 .53658 .39404 .53959 .38843 .53594 .38934 Mtetra
.843 .74 .75 r
.53594 .38934 .53959 .38843 .5426 .38176 .53895 .38266 Mtetra
.841 .725 .736 r
.53895 .38266 .5426 .38176 .5456 .37436 .54195 .37525 Mtetra
.84 .719 .73 r
.54195 .37525 .5456 .37436 .54859 .36661 .54495 .36749 Mtetra
.84 .72 .731 r
.54495 .36749 .54859 .36661 .55159 .3589 .54795 .35978 Mtetra
.841 .727 .738 r
.54795 .35978 .55159 .3589 .55458 .35161 .55095 .35248 Mtetra
.843 .743 .753 r
.55095 .35248 .55458 .35161 .55758 .34509 .55395 .34595 Mtetra
.844 .771 .781 r
.55395 .34595 .55758 .34509 .5606 .33962 .55697 .34047 Mtetra
.84 .82 .83 r
.55697 .34047 .5606 .33962 .56363 .3354 .56 .33625 Mtetra
.804 .904 .911 r
.56 .33625 .56363 .3354 .56668 .33258 .56305 .33342 Mtetra
.521 .914 .914 r
.56305 .33342 .56668 .33258 .56975 .3312 .56613 .33205 Mtetra
.259 0 0 r
.56613 .33205 .56975 .3312 .57285 .33125 .56923 .3321 Mtetra
.577 .121 .133 r
.56923 .3321 .57285 .33125 .57598 .33262 .57235 .33347 Mtetra
.671 .274 .286 r
.57235 .33347 .57598 .33262 .57913 .33515 .5755 .336 Mtetra
.707 .342 .354 r
.5755 .336 .57913 .33515 .5823 .33861 .57867 .33947 Mtetra
.724 .375 .387 r
.57867 .33947 .5823 .33861 .5855 .34274 .58186 .34361 Mtetra
.732 .39 .402 r
.58186 .34361 .5855 .34274 .58871 .34724 .58507 .34811 Mtetra
.732 .392 .403 r
.58507 .34811 .58871 .34724 .59194 .3518 .5883 .35268 Mtetra
.727 .381 .393 r
.5883 .35268 .59194 .3518 .59517 .35612 .59153 .35701 Mtetra
.714 .355 .367 r
.59153 .35701 .59517 .35612 .59841 .35989 .59476 .36078 Mtetra
.687 .304 .316 r
.59476 .36078 .59841 .35989 .60164 .36284 .59799 .36373 Mtetra
.625 .197 .21 r
.59799 .36373 .60164 .36284 .60487 .36473 .60121 .36563 Mtetra
.448 0 0 r
.60121 .36563 .60487 .36473 .60807 .36537 .60442 .36627 Mtetra
0 0 0 r
.60442 .36627 .60807 .36537 .61126 .36463 .6076 .36553 Mtetra
.732 .951 .948 r
.6076 .36553 .61126 .36463 .61442 .36242 .61076 .36332 Mtetra
.835 .862 .865 r
.61076 .36332 .61442 .36242 .61755 .35872 .6139 .35962 Mtetra
.848 .794 .798 r
.6139 .35962 .61755 .35872 .62066 .35357 .61701 .35447 Mtetra
.848 .753 .758 r
.61701 .35447 .62066 .35357 .62373 .34707 .62008 .34795 Mtetra
.846 .728 .733 r
.62008 .34795 .62373 .34707 .62678 .33934 .62313 .34021 Mtetra
.844 .712 .717 r
.62313 .34021 .62678 .33934 .62979 .33057 .62616 .33143 Mtetra
.842 .701 .707 r
.62616 .33143 .62979 .33057 .63279 .32097 .62916 .32183 Mtetra
.841 .694 .7 r
.62916 .32183 .63279 .32097 .63577 .3108 .63214 .31164 Mtetra
.84 .691 .697 r
.63214 .31164 .63577 .3108 .63873 .30029 .63511 .30112 Mtetra
.84 .69 .696 r
.63511 .30112 .63873 .30029 .64169 .28971 .63807 .29053 Mtetra
.841 .692 .698 r
.63807 .29053 .64169 .28971 .64464 .27932 .64103 .28013 Mtetra
.841 .696 .702 r
.64103 .28013 .64464 .27932 .64761 .26938 .644 .27017 Mtetra
.842 .704 .71 r
.644 .27017 .64761 .26938 .65059 .2601 .64699 .26088 Mtetra
.844 .715 .721 r
.64699 .26088 .65059 .2601 .65359 .2517 .64999 .25247 Mtetra
.846 .733 .739 r
.64999 .25247 .65359 .2517 .65662 .24435 .65303 .24512 Mtetra
.847 .76 .766 r
.65303 .24512 .65662 .24435 .65968 .2382 .65609 .23897 Mtetra
.845 .802 .809 r
.65609 .23897 .65968 .2382 .66278 .23337 .6592 .23413 Mtetra
.826 .871 .879 r
.6592 .23413 .66278 .23337 .66593 .22993 .66235 .23069 Mtetra
.698 .948 .957 r
.66235 .23069 .66593 .22993 .66913 .22793 .66555 .22868 Mtetra
0 0 0 r
.66555 .22868 .66913 .22793 .67238 .22735 .6688 .2281 Mtetra
.472 0 0 r
.6688 .2281 .67238 .22735 .67568 .22817 .6721 .22893 Mtetra
.641 .211 .211 r
.6721 .22893 .67568 .22817 .67904 .23032 .67545 .23108 Mtetra
.702 .32 .32 r
.67545 .23108 .67904 .23032 .68244 .2337 .67885 .23447 Mtetra
.731 .376 .377 r
.67885 .23447 .68244 .2337 .6859 .23819 .68231 .23896 Mtetra
.747 .408 .409 r
.68231 .23896 .6859 .23819 .6894 .24361 .6858 .24439 Mtetra
.756 .428 .429 r
.6858 .24439 .6894 .24361 .69295 .2498 .68934 .25059 Mtetra
.761 .44 .441 r
.68934 .25059 .69295 .2498 .69653 .25656 .69292 .25735 Mtetra
.764 .446 .447 r
.69292 .25735 .69653 .25656 .70013 .26367 .69652 .26447 Mtetra
.765 .448 .449 r
.69652 .26447 .70013 .26367 .70377 .27092 .70015 .27173 Mtetra
.764 .445 .447 r
.70015 .27173 .70377 .27092 .70741 .27807 .70379 .2789 Mtetra
.755 .482 .519 r
.25971 .56179 .2634 .56062 .26571 .56769 .26201 .56888 Mtetra
.756 .484 .521 r
.26201 .56888 .26571 .56769 .26802 .57491 .26432 .57611 Mtetra
.755 .483 .52 r
.26432 .57611 .26802 .57491 .27034 .58208 .26664 .58328 Mtetra
.753 .478 .516 r
.26664 .58328 .27034 .58208 .27269 .58896 .26898 .59018 Mtetra
.75 .47 .508 r
.26898 .59018 .27269 .58896 .27507 .59535 .27135 .59657 Mtetra
.744 .456 .495 r
.27135 .59657 .27507 .59535 .27748 .60104 .27376 .60227 Mtetra
.733 .435 .475 r
.27376 .60227 .27748 .60104 .27994 .60584 .27621 .60709 Mtetra
.715 .398 .44 r
.27621 .60709 .27994 .60584 .28244 .60959 .27871 .61084 Mtetra
.679 .33 .376 r
.27871 .61084 .28244 .60959 .285 .61214 .28127 .61339 Mtetra
.589 .178 .231 r
.28127 .61339 .285 .61214 .28761 .61337 .28387 .61463 Mtetra
.245 0 0 r
.28387 .61463 .28761 .61337 .29027 .61321 .28654 .61446 Mtetra
.627 .956 .919 r
.28654 .61446 .29027 .61321 .293 .6116 .28926 .61286 Mtetra
.831 .884 .881 r
.28926 .61286 .293 .6116 .29577 .60856 .29203 .60982 Mtetra
.844 .798 .807 r
.29203 .60982 .29577 .60856 .29859 .60412 .29486 .60537 Mtetra
.84 .75 .764 r
.29486 .60537 .29859 .60412 .30146 .59836 .29773 .59961 Mtetra
.836 .722 .739 r
.29773 .59961 .30146 .59836 .30436 .59141 .30064 .59264 Mtetra
.832 .704 .722 r
.30064 .59264 .30436 .59141 .3073 .58341 .30358 .58464 Mtetra
.83 .692 .712 r
.30358 .58464 .3073 .58341 .31027 .57456 .30655 .57578 Mtetra
.828 .685 .705 r
.30655 .57578 .31027 .57456 .31325 .56507 .30954 .56628 Mtetra
.827 .681 .702 r
.30954 .56628 .31325 .56507 .31624 .55517 .31253 .55637 Mtetra
.827 .679 .7 r
.31253 .55637 .31624 .55517 .31923 .54512 .31553 .54631 Mtetra
.827 .68 .701 r
.31553 .54631 .31923 .54512 .32221 .53517 .31852 .53634 Mtetra
.827 .683 .704 r
.31852 .53634 .32221 .53517 .32518 .52556 .3215 .52672 Mtetra
.829 .69 .71 r
.3215 .52672 .32518 .52556 .32813 .51654 .32445 .51769 Mtetra
.831 .7 .719 r
.32445 .51769 .32813 .51654 .33106 .50833 .32738 .50947 Mtetra
.834 .715 .733 r
.32738 .50947 .33106 .50833 .33395 .50112 .33028 .50226 Mtetra
.838 .74 .756 r
.33028 .50226 .33395 .50112 .33681 .49508 .33314 .49621 Mtetra
.841 .781 .794 r
.33314 .49621 .33681 .49508 .33964 .49033 .33597 .49146 Mtetra
.835 .853 .859 r
.33597 .49146 .33964 .49033 .34243 .48696 .33876 .48808 Mtetra
.735 .957 .944 r
.33876 .48808 .34243 .48696 .34518 .48499 .34152 .48611 Mtetra
0 0 0 r
.34152 .48611 .34518 .48499 .34791 .48441 .34424 .48553 Mtetra
.511 .051 .097 r
.34424 .48553 .34791 .48441 .3506 .48514 .34693 .48627 Mtetra
.647 .263 .303 r
.34693 .48627 .3506 .48514 .35327 .48708 .3496 .48821 Mtetra
.695 .349 .386 r
.3496 .48821 .35327 .48708 .35593 .49004 .35225 .49117 Mtetra
.717 .391 .426 r
.35225 .49117 .35593 .49004 .35857 .49381 .35489 .49495 Mtetra
.727 .412 .447 r
.35489 .49495 .35857 .49381 .36121 .49813 .35753 .49928 Mtetra
.731 .421 .455 r
.35753 .49928 .36121 .49813 .36386 .50274 .36017 .50389 Mtetra
.731 .42 .453 r
.36017 .50389 .36386 .50274 .36651 .50731 .36282 .50847 Mtetra
.725 .408 .442 r
.36282 .50847 .36651 .50731 .36918 .51155 .36549 .51271 Mtetra
.712 .381 .417 r
.36549 .51271 .36918 .51155 .37188 .51516 .36818 .51633 Mtetra
.683 .328 .366 r
.36818 .51633 .37188 .51516 .3746 .51786 .3709 .51903 Mtetra
.615 .211 .254 r
.3709 .51903 .3746 .51786 .37735 .51942 .37365 .5206 Mtetra
.39 0 0 r
.37365 .5206 .37735 .51942 .38014 .51967 .37644 .52085 Mtetra
.397 .852 .807 r
.37644 .52085 .38014 .51967 .38296 .5185 .37926 .51968 Mtetra
.807 .924 .914 r
.37926 .51968 .38296 .5185 .38582 .51587 .38211 .51705 Mtetra
.844 .827 .83 r
.38211 .51705 .38582 .51587 .3887 .51183 .385 .51301 Mtetra
.845 .772 .781 r
.385 .51301 .3887 .51183 .39161 .50654 .38791 .5077 Mtetra
.842 .742 .753 r
.38791 .5077 .39161 .50654 .39453 .50019 .39084 .50135 Mtetra
.839 .725 .738 r
.39084 .50135 .39453 .50019 .39747 .49309 .39378 .49425 Mtetra
.838 .718 .731 r
.39378 .49425 .39747 .49309 .40042 .48558 .39673 .48673 Mtetra
.838 .717 .731 r
.39673 .48673 .40042 .48558 .40336 .47803 .39968 .47917 Mtetra
.839 .723 .736 r
.39968 .47917 .40336 .47803 .4063 .47084 .40262 .47197 Mtetra
.841 .738 .75 r
.40262 .47197 .4063 .47084 .40922 .46437 .40554 .46549 Mtetra
.844 .767 .777 r
.40554 .46549 .40922 .46437 .41213 .45893 .40845 .46005 Mtetra
.844 .82 .825 r
.40845 .46005 .41213 .45893 .41502 .45478 .41135 .4559 Mtetra
.811 .915 .909 r
.41135 .4559 .41502 .45478 .41789 .45206 .41422 .45317 Mtetra
.468 .892 .858 r
.41422 .45317 .41789 .45206 .42075 .45077 .41708 .45188 Mtetra
.307 0 0 r
.41708 .45188 .42075 .45077 .4236 .45081 .41993 .45192 Mtetra
.561 .121 .16 r
.41993 .45192 .4236 .45081 .42644 .45192 .42276 .45303 Mtetra
.631 .231 .267 r
.42276 .45303 .42644 .45192 .42928 .45371 .4256 .45483 Mtetra
.646 .256 .291 r
.4256 .45483 .42928 .45371 .43212 .45573 .42844 .45685 Mtetra
.623 .218 .255 r
.42844 .45685 .43212 .45573 .43498 .45743 .4313 .45856 Mtetra
.528 .072 .112 r
.4313 .45856 .43498 .45743 .43785 .45833 .43417 .45945 Mtetra
.135 0 0 r
.43417 .45945 .43785 .45833 .44074 .45799 .43706 .45912 Mtetra
.668 .961 .936 r
.43706 .45912 .44074 .45799 .44365 .45618 .43996 .45731 Mtetra
.833 .88 .877 r
.43996 .45731 .44365 .45618 .44657 .45291 .44289 .45403 Mtetra
.847 .811 .815 r
.44289 .45403 .44657 .45291 .44951 .44846 .44583 .44958 Mtetra
.847 .786 .792 r
.44583 .44958 .44951 .44846 .45245 .44341 .44878 .44452 Mtetra
.847 .792 .798 r
.44878 .44452 .45245 .44341 .4554 .43852 .45172 .43963 Mtetra
.844 .839 .84 r
.45172 .43963 .4554 .43852 .45834 .43459 .45467 .4357 Mtetra
.781 .943 .931 r
.45467 .4357 .45834 .43459 .46127 .43217 .4576 .43327 Mtetra
.261 .763 .722 r
.4576 .43327 .46127 .43217 .4642 .4312 .46053 .4323 Mtetra
.045 0 0 r
.46053 .4323 .4642 .4312 .46713 .43071 .46346 .43182 Mtetra
.642 .957 .932 r
.46346 .43182 .46713 .43071 .47007 .42897 .4664 .43008 Mtetra
.823 .901 .895 r
.4664 .43008 .47007 .42897 .47302 .42596 .46935 .42706 Mtetra
.643 .957 .932 r
.46935 .42706 .47302 .42596 .47597 .42421 .4723 .42531 Mtetra
.041 0 0 r
.4723 .42531 .47597 .42421 .47892 .42371 .47525 .42481 Mtetra
.264 .765 .724 r
.47525 .42481 .47892 .42371 .48188 .42273 .47821 .42383 Mtetra
.78 .944 .931 r
.47821 .42383 .48188 .42273 .48485 .42029 .48118 .42139 Mtetra
.845 .841 .841 r
.48118 .42139 .48485 .42029 .48782 .41633 .48415 .41742 Mtetra
.849 .795 .799 r
.48415 .41742 .48782 .41633 .49079 .41139 .48713 .41248 Mtetra
.849 .788 .793 r
.48713 .41248 .49079 .41139 .49377 .40629 .49011 .40737 Mtetra
.848 .814 .816 r
.49011 .40737 .49377 .40629 .49675 .40179 .49309 .40287 Mtetra
.833 .881 .877 r
.49309 .40287 .49675 .40179 .49973 .39846 .49607 .39953 Mtetra
.675 .961 .94 r
.49607 .39953 .49973 .39846 .50271 .39659 .49905 .39766 Mtetra
.091 0 0 r
.49905 .39766 .50271 .39659 .5057 .39618 .50204 .39726 Mtetra
.508 .038 .072 r
.50204 .39726 .5057 .39618 .5087 .39701 .50504 .39809 Mtetra
.613 .194 .224 r
.50504 .39809 .5087 .39701 .51172 .39867 .50805 .39975 Mtetra
.637 .234 .264 r
.50805 .39975 .51172 .39867 .51474 .40064 .51107 .40173 Mtetra
.621 .208 .238 r
.51107 .40173 .51474 .40064 .51776 .40241 .5141 .4035 Mtetra
.546 .092 .125 r
.5141 .4035 .51776 .40241 .5208 .40349 .51713 .40458 Mtetra
.278 0 0 r
.51713 .40458 .5208 .40349 .52383 .40347 .52016 .40457 Mtetra
.469 .893 .859 r
.52016 .40457 .52383 .40347 .52687 .40211 .5232 .4032 Mtetra
.81 .923 .911 r
.5232 .4032 .52687 .40211 .5299 .39926 .52623 .40035 Mtetra
.849 .83 .829 r
.52623 .40035 .5299 .39926 .53292 .39496 .52926 .39604 Mtetra
.85 .777 .779 r
.52926 .39604 .53292 .39496 .53594 .38934 .53228 .39042 Mtetra
.848 .747 .752 r
.53228 .39042 .53594 .38934 .53895 .38266 .53529 .38373 Mtetra
.846 .732 .737 r
.53529 .38373 .53895 .38266 .54195 .37525 .5383 .37631 Mtetra
.845 .725 .731 r
.5383 .37631 .54195 .37525 .54495 .36749 .5413 .36855 Mtetra
.845 .726 .732 r
.5413 .36855 .54495 .36749 .54795 .35978 .5443 .36082 Mtetra
.846 .734 .739 r
.5443 .36082 .54795 .35978 .55095 .35248 .5473 .35352 Mtetra
.848 .75 .755 r
.5473 .35352 .55095 .35248 .55395 .34595 .55031 .34698 Mtetra
.85 .78 .783 r
.55031 .34698 .55395 .34595 .55697 .34047 .55333 .3415 Mtetra
.847 .833 .833 r
.55333 .3415 .55697 .34047 .56 .33625 .55637 .33727 Mtetra
.807 .922 .913 r
.55637 .33727 .56 .33625 .56305 .33342 .55942 .33444 Mtetra
.48 .898 .873 r
.55942 .33444 .56305 .33342 .56613 .33205 .5625 .33307 Mtetra
.289 0 0 r
.5625 .33307 .56613 .33205 .56923 .3321 .56559 .33312 Mtetra
.579 .134 .159 r
.56559 .33312 .56923 .3321 .57235 .33347 .56871 .3345 Mtetra
.667 .278 .299 r
.56871 .3345 .57235 .33347 .5755 .336 .57186 .33703 Mtetra
.703 .343 .363 r
.57186 .33703 .5755 .336 .57867 .33947 .57503 .3405 Mtetra
.72 .375 .394 r
.57503 .3405 .57867 .33947 .58186 .34361 .57822 .34464 Mtetra
.727 .39 .408 r
.57822 .34464 .58186 .34361 .58507 .34811 .58143 .34916 Mtetra
.728 .391 .409 r
.58143 .34916 .58507 .34811 .5883 .35268 .58465 .35374 Mtetra
.723 .381 .399 r
.58465 .35374 .5883 .35268 .59153 .35701 .58787 .35807 Mtetra
.71 .356 .375 r
.58787 .35807 .59153 .35701 .59476 .36078 .5911 .36184 Mtetra
.683 .306 .327 r
.5911 .36184 .59476 .36078 .59799 .36373 .59433 .3648 Mtetra
.623 .206 .23 r
.59433 .3648 .59799 .36373 .60121 .36563 .59755 .3667 Mtetra
.46 0 0 r
.59755 .3667 .60121 .36563 .60442 .36627 .60076 .36735 Mtetra
0 0 0 r
.60076 .36735 .60442 .36627 .6076 .36553 .60394 .3666 Mtetra
.722 .964 .94 r
.60394 .3666 .6076 .36553 .61076 .36332 .6071 .36439 Mtetra
.842 .878 .868 r
.6071 .36439 .61076 .36332 .6139 .35962 .61024 .36069 Mtetra
.855 .805 .801 r
.61024 .36069 .6139 .35962 .61701 .35447 .61335 .35553 Mtetra
.854 .761 .76 r
.61335 .35553 .61701 .35447 .62008 .34795 .61643 .34901 Mtetra
.851 .734 .734 r
.61643 .34901 .62008 .34795 .62313 .34021 .61948 .34126 Mtetra
.848 .717 .718 r
.61948 .34126 .62313 .34021 .62616 .33143 .62251 .33247 Mtetra
.846 .706 .707 r
.62251 .33247 .62616 .33143 .62916 .32183 .62552 .32286 Mtetra
.845 .699 .701 r
.62552 .32286 .62916 .32183 .63214 .31164 .62851 .31265 Mtetra
.844 .695 .697 r
.62851 .31265 .63214 .31164 .63511 .30112 .63148 .30212 Mtetra
.844 .694 .697 r
.63148 .30212 .63511 .30112 .63807 .29053 .63445 .29152 Mtetra
.844 .696 .698 r
.63445 .29152 .63807 .29053 .64103 .28013 .63742 .28111 Mtetra
.845 .701 .703 r
.63742 .28111 .64103 .28013 .644 .27017 .6404 .27114 Mtetra
.847 .709 .71 r
.6404 .27114 .644 .27017 .64699 .26088 .64339 .26184 Mtetra
.849 .721 .722 r
.64339 .26184 .64699 .26088 .64999 .25247 .6464 .25342 Mtetra
.851 .74 .74 r
.6464 .25342 .64999 .25247 .65303 .24512 .64943 .24606 Mtetra
.853 .768 .768 r
.64943 .24606 .65303 .24512 .65609 .23897 .6525 .2399 Mtetra
.852 .814 .812 r
.6525 .2399 .65609 .23897 .6592 .23413 .65561 .23506 Mtetra
.832 .887 .882 r
.65561 .23506 .6592 .23413 .66235 .23069 .65876 .23161 Mtetra
.684 .958 .946 r
.65876 .23161 .66235 .23069 .66555 .22868 .66196 .2296 Mtetra
0 0 0 r
.66196 .2296 .66555 .22868 .6688 .2281 .66521 .22902 Mtetra
.482 0 0 r
.66521 .22902 .6688 .2281 .6721 .22893 .66851 .22985 Mtetra
.639 .219 .23 r
.66851 .22985 .6721 .22893 .67545 .23108 .67186 .23201 Mtetra
.698 .322 .331 r
.67186 .23201 .67545 .23108 .67885 .23447 .67526 .2354 Mtetra
.727 .376 .384 r
.67526 .2354 .67885 .23447 .68231 .23896 .67871 .2399 Mtetra
.743 .408 .415 r
.67871 .2399 .68231 .23896 .6858 .24439 .68221 .24534 Mtetra
.752 .427 .434 r
.68221 .24534 .6858 .24439 .68934 .25059 .68574 .25154 Mtetra
.758 .439 .445 r
.68574 .25154 .68934 .25059 .69292 .25735 .68931 .25832 Mtetra
.761 .445 .451 r
.68931 .25832 .69292 .25735 .69652 .26447 .69291 .26545 Mtetra
.761 .447 .453 r
.69291 .26545 .69652 .26447 .70015 .27173 .69653 .27272 Mtetra
.76 .444 .451 r
.69653 .27272 .70015 .27173 .70379 .2789 .70017 .2799 Mtetra
.766 .488 .513 r
.25604 .56239 .25971 .56179 .26201 .56888 .25833 .56948 Mtetra
.767 .49 .515 r
.25833 .56948 .26201 .56888 .26432 .57611 .26063 .57672 Mtetra
.766 .488 .513 r
.26063 .57672 .26432 .57611 .26664 .58328 .26295 .5839 Mtetra
.765 .484 .509 r
.26295 .5839 .26664 .58328 .26898 .59018 .26528 .5908 Mtetra
.761 .476 .5 r
.26528 .5908 .26898 .59018 .27135 .59657 .26765 .59721 Mtetra
.756 .462 .486 r
.26765 .59721 .27135 .59657 .27376 .60227 .27005 .60291 Mtetra
.747 .439 .462 r
.27005 .60291 .27376 .60227 .27621 .60709 .2725 .60773 Mtetra
.73 .4 .421 r
.2725 .60773 .27621 .60709 .27871 .61084 .275 .61149 Mtetra
.694 .324 .342 r
.275 .61149 .27871 .61084 .28127 .61339 .27755 .61404 Mtetra
.589 .137 .147 r
.27755 .61404 .28127 .61339 .28387 .61463 .28015 .61528 Mtetra
.099 0 0 r
.28015 .61528 .28387 .61463 .28654 .61446 .28282 .61512 Mtetra
.691 .927 .969 r
.28282 .61512 .28654 .61446 .28926 .61286 .28554 .61351 Mtetra
.808 .827 .866 r
.28554 .61351 .28926 .61286 .29203 .60982 .28831 .61047 Mtetra
.82 .761 .797 r
.28831 .61047 .29203 .60982 .29486 .60537 .29114 .60602 Mtetra
.821 .724 .758 r
.29114 .60602 .29486 .60537 .29773 .59961 .29401 .60025 Mtetra
.819 .701 .734 r
.29401 .60025 .29773 .59961 .30064 .59264 .29692 .59328 Mtetra
.818 .687 .719 r
.29692 .59328 .30064 .59264 .30358 .58464 .29987 .58527 Mtetra
.817 .678 .71 r
.29987 .58527 .30358 .58464 .30655 .57578 .30285 .5764 Mtetra
.816 .672 .703 r
.30285 .5764 .30655 .57578 .30954 .56628 .30584 .56689 Mtetra
.816 .668 .7 r
.30584 .56689 .30954 .56628 .31253 .55637 .30884 .55697 Mtetra
.815 .667 .699 r
.30884 .55697 .31253 .55637 .31553 .54631 .31184 .5469 Mtetra
.816 .668 .699 r
.31184 .5469 .31553 .54631 .31852 .53634 .31484 .53692 Mtetra
.816 .67 .702 r
.31484 .53692 .31852 .53634 .3215 .52672 .31782 .5273 Mtetra
.817 .675 .707 r
.31782 .5273 .3215 .52672 .32445 .51769 .32078 .51826 Mtetra
.817 .683 .716 r
.32078 .51826 .32445 .51769 .32738 .50947 .32371 .51003 Mtetra
.819 .696 .729 r
.32371 .51003 .32738 .50947 .33028 .50226 .32661 .50281 Mtetra
.82 .716 .75 r
.32661 .50281 .33028 .50226 .33314 .49621 .32948 .49675 Mtetra
.819 .748 .785 r
.32948 .49675 .33314 .49621 .33597 .49146 .33231 .492 Mtetra
.811 .803 .844 r
.33231 .492 .33597 .49146 .33876 .48808 .3351 .48862 Mtetra
.747 .897 .946 r
.3351 .48862 .33876 .48808 .34152 .48611 .33785 .48665 Mtetra
.236 .754 .803 r
.33785 .48665 .34152 .48611 .34424 .48553 .34058 .48606 Mtetra
.483 0 0 r
.34058 .48606 .34424 .48553 .34693 .48627 .34327 .4868 Mtetra
.658 .244 .248 r
.34327 .4868 .34693 .48627 .3496 .48821 .34594 .48874 Mtetra
.711 .346 .356 r
.34594 .48874 .3496 .48821 .35225 .49117 .34858 .49171 Mtetra
.732 .393 .405 r
.34858 .49171 .35225 .49117 .35489 .49495 .35122 .49549 Mtetra
.742 .416 .43 r
.35122 .49549 .35489 .49495 .35753 .49928 .35385 .49983 Mtetra
.746 .425 .439 r
.35385 .49983 .35753 .49928 .36017 .50389 .35649 .50444 Mtetra
.745 .423 .438 r
.35649 .50444 .36017 .50389 .36282 .50847 .35913 .50903 Mtetra
.74 .41 .424 r
.35913 .50903 .36282 .50847 .36549 .51271 .3618 .51328 Mtetra
.727 .382 .394 r
.3618 .51328 .36549 .51271 .36818 .51633 .36449 .5169 Mtetra
.698 .321 .33 r
.36449 .5169 .36818 .51633 .3709 .51903 .3672 .51961 Mtetra
.621 .18 .181 r
.3672 .51961 .3709 .51903 .37365 .5206 .36995 .52118 Mtetra
.309 0 0 r
.36995 .52118 .37365 .5206 .37644 .52085 .37274 .52143 Mtetra
.549 .911 .959 r
.37274 .52143 .37644 .52085 .37926 .51968 .37556 .52026 Mtetra
.791 .861 .901 r
.37556 .52026 .37926 .51968 .38211 .51705 .37841 .51762 Mtetra
.82 .783 .818 r
.37841 .51762 .38211 .51705 .385 .51301 .3813 .51358 Mtetra
.823 .741 .773 r
.3813 .51358 .385 .51301 .38791 .5077 .38421 .50827 Mtetra
.823 .717 .748 r
.38421 .50827 .38791 .5077 .39084 .50135 .38714 .50191 Mtetra
.823 .704 .734 r
.38714 .50191 .39084 .50135 .39378 .49425 .39009 .4948 Mtetra
.822 .698 .728 r
.39009 .4948 .39378 .49425 .39673 .48673 .39304 .48727 Mtetra
.822 .698 .727 r
.39304 .48727 .39673 .48673 .39968 .47917 .39599 .47971 Mtetra
.822 .703 .732 r
.39599 .47971 .39968 .47917 .40262 .47197 .39894 .4725 Mtetra
.823 .715 .745 r
.39894 .4725 .40262 .47197 .40554 .46549 .40187 .46602 Mtetra
.823 .737 .769 r
.40187 .46602 .40554 .46549 .40845 .46005 .40478 .46057 Mtetra
.82 .778 .813 r
.40478 .46057 .40845 .46005 .41135 .4559 .40768 .45641 Mtetra
.794 .852 .894 r
.40768 .45641 .41135 .4559 .41422 .45317 .41055 .45368 Mtetra
.592 .918 .972 r
.41055 .45368 .41422 .45317 .41708 .45188 .41341 .4524 Mtetra
.185 0 0 r
.41341 .4524 .41708 .45188 .41993 .45192 .41626 .45244 Mtetra
.551 .063 .05 r
.41626 .45244 .41993 .45192 .42276 .45303 .41909 .45355 Mtetra
.639 .205 .201 r
.41909 .45355 .42276 .45303 .4256 .45483 .42193 .45535 Mtetra
.657 .235 .233 r
.42193 .45535 .4256 .45483 .42844 .45685 .42476 .45737 Mtetra
.63 .188 .183 r
.42476 .45737 .42844 .45685 .4313 .45856 .42762 .45908 Mtetra
.505 0 0 r
.42762 .45908 .4313 .45856 .43417 .45945 .43048 .45998 Mtetra
0 0 0 r
.43048 .45998 .43417 .45945 .43706 .45912 .43337 .45964 Mtetra
.711 .917 .965 r
.43337 .45964 .43706 .45912 .43996 .45731 .43628 .45783 Mtetra
.81 .824 .862 r
.43628 .45783 .43996 .45731 .44289 .45403 .43921 .45456 Mtetra
.823 .772 .805 r
.43921 .45456 .44289 .45403 .44583 .44958 .44215 .4501 Mtetra
.824 .752 .783 r
.44215 .4501 .44583 .44958 .44878 .44452 .4451 .44503 Mtetra
.824 .757 .789 r
.4451 .44503 .44878 .44452 .45172 .43963 .44805 .44013 Mtetra
.819 .792 .827 r
.44805 .44013 .45172 .43963 .45467 .4357 .45099 .4362 Mtetra
.775 .878 .922 r
.45099 .4362 .45467 .4357 .4576 .43327 .45392 .43378 Mtetra
.447 .872 .928 r
.45392 .43378 .4576 .43327 .46053 .4323 .45685 .43281 Mtetra
.155 .696 .748 r
.45685 .43281 .46053 .4323 .46346 .43182 .45978 .43232 Mtetra
.696 .919 .969 r
.45978 .43232 .46346 .43182 .4664 .43008 .46272 .43058 Mtetra
.802 .841 .88 r
.46272 .43058 .4664 .43008 .46935 .42706 .46568 .42756 Mtetra
.696 .919 .969 r
.46568 .42756 .46935 .42706 .4723 .42531 .46863 .42581 Mtetra
.16 .7 .753 r
.46863 .42581 .4723 .42531 .47525 .42481 .47158 .42531 Mtetra
.448 .873 .929 r
.47158 .42531 .47525 .42481 .47821 .42383 .47454 .42433 Mtetra
.775 .879 .922 r
.47454 .42433 .47821 .42383 .48118 .42139 .4775 .42188 Mtetra
.82 .794 .828 r
.4775 .42188 .48118 .42139 .48415 .41742 .48048 .41791 Mtetra
.825 .759 .789 r
.48048 .41791 .48415 .41742 .48713 .41248 .48346 .41297 Mtetra
.826 .754 .784 r
.48346 .41297 .48713 .41248 .49011 .40737 .48644 .40785 Mtetra
.823 .773 .805 r
.48644 .40785 .49011 .40737 .49309 .40287 .48942 .40334 Mtetra
.81 .825 .862 r
.48942 .40334 .49309 .40287 .49607 .39953 .4924 .40001 Mtetra
.714 .914 .963 r
.4924 .40001 .49607 .39953 .49905 .39766 .49539 .39813 Mtetra
.101 .655 .71 r
.49539 .39813 .49905 .39766 .50204 .39726 .49838 .39773 Mtetra
.476 0 0 r
.49838 .39773 .50204 .39726 .50504 .39809 .50138 .39857 Mtetra
.615 .158 .143 r
.50138 .39857 .50504 .39809 .50805 .39975 .50438 .40023 Mtetra
.646 .209 .197 r
.50438 .40023 .50805 .39975 .51107 .40173 .5074 .40221 Mtetra
.626 .176 .162 r
.5074 .40221 .51107 .40173 .5141 .4035 .51042 .40398 Mtetra
.528 .024 .001 r
.51042 .40398 .5141 .4035 .51713 .40458 .51345 .40506 Mtetra
.144 0 0 r
.51345 .40506 .51713 .40458 .52016 .40457 .51649 .40505 Mtetra
.592 .918 .972 r
.51649 .40505 .52016 .40457 .5232 .4032 .51952 .40368 Mtetra
.794 .859 .898 r
.51952 .40368 .5232 .4032 .52623 .40035 .52255 .40083 Mtetra
.824 .786 .817 r
.52255 .40083 .52623 .40035 .52926 .39604 .52558 .39652 Mtetra
.828 .745 .772 r
.52558 .39652 .52926 .39604 .53228 .39042 .5286 .39089 Mtetra
.829 .722 .747 r
.5286 .39089 .53228 .39042 .53529 .38373 .53162 .38419 Mtetra
.829 .71 .733 r
.53162 .38419 .53529 .38373 .5383 .37631 .53463 .37677 Mtetra
.828 .704 .727 r
.53463 .37677 .5383 .37631 .5413 .36855 .53764 .369 Mtetra
.828 .705 .728 r
.53764 .369 .5413 .36855 .5443 .36082 .54064 .36126 Mtetra
.829 .711 .735 r
.54064 .36126 .5443 .36082 .5473 .35352 .54365 .35396 Mtetra
.829 .724 .75 r
.54365 .35396 .5473 .35352 .55031 .34698 .54666 .34741 Mtetra
.828 .748 .775 r
.54666 .34741 .55031 .34698 .55333 .3415 .54969 .34192 Mtetra
.822 .788 .821 r
.54969 .34192 .55333 .3415 .55637 .33727 .55272 .33769 Mtetra
.791 .858 .9 r
.55272 .33769 .55637 .33727 .55942 .33444 .55578 .33486 Mtetra
.596 .915 .976 r
.55578 .33486 .55942 .33444 .5625 .33307 .55885 .33348 Mtetra
.158 0 0 r
.55885 .33348 .5625 .33307 .56559 .33312 .56195 .33353 Mtetra
.571 .08 .052 r
.56195 .33353 .56559 .33312 .56871 .3345 .56507 .33491 Mtetra
.679 .262 .246 r
.56507 .33491 .56871 .3345 .57186 .33703 .56821 .33745 Mtetra
.719 .339 .328 r
.56821 .33745 .57186 .33703 .57503 .3405 .57137 .34093 Mtetra
.736 .375 .367 r
.57137 .34093 .57503 .3405 .57822 .34464 .57456 .34507 Mtetra
.743 .391 .384 r
.57456 .34507 .57822 .34464 .58143 .34916 .57776 .34959 Mtetra
.744 .392 .386 r
.57776 .34959 .58143 .34916 .58465 .35374 .58098 .35418 Mtetra
.739 .381 .374 r
.58098 .35418 .58465 .35374 .58787 .35807 .5842 .35851 Mtetra
.726 .353 .344 r
.5842 .35851 .58787 .35807 .5911 .36184 .58743 .36229 Mtetra
.697 .296 .283 r
.58743 .36229 .5911 .36184 .59433 .3648 .59066 .36526 Mtetra
.628 .172 .152 r
.59066 .36526 .59433 .3648 .59755 .3667 .59387 .36715 Mtetra
.406 0 0 r
.59387 .36715 .59755 .3667 .60076 .36735 .59708 .3678 Mtetra
.292 .79 .849 r
.59708 .3678 .60076 .36735 .60394 .3666 .60026 .36706 Mtetra
.742 .907 .95 r
.60026 .36706 .60394 .3666 .6071 .36439 .60342 .36485 Mtetra
.817 .823 .854 r
.60342 .36485 .6071 .36439 .61024 .36069 .60656 .36114 Mtetra
.831 .767 .792 r
.60656 .36114 .61024 .36069 .61335 .35553 .60967 .35598 Mtetra
.833 .733 .754 r
.60967 .35598 .61335 .35553 .61643 .34901 .61276 .34945 Mtetra
.833 .712 .731 r
.61276 .34945 .61643 .34901 .61948 .34126 .61582 .34169 Mtetra
.832 .698 .715 r
.61582 .34169 .61948 .34126 .62251 .33247 .61885 .3329 Mtetra
.832 .689 .706 r
.61885 .3329 .62251 .33247 .62552 .32286 .62186 .32327 Mtetra
.831 .683 .699 r
.62186 .32327 .62552 .32286 .62851 .31265 .62485 .31306 Mtetra
.831 .68 .696 r
.62485 .31306 .62851 .31265 .63148 .30212 .62783 .30251 Mtetra
.831 .68 .695 r
.62783 .30251 .63148 .30212 .63445 .29152 .63081 .2919 Mtetra
.831 .681 .697 r
.63081 .2919 .63445 .29152 .63742 .28111 .63378 .28148 Mtetra
.831 .685 .701 r
.63378 .28148 .63742 .28111 .6404 .27114 .63676 .2715 Mtetra
.832 .691 .708 r
.63676 .2715 .6404 .27114 .64339 .26184 .63976 .26219 Mtetra
.832 .701 .719 r
.63976 .26219 .64339 .26184 .6464 .25342 .64277 .25376 Mtetra
.832 .716 .736 r
.64277 .25376 .6464 .25342 .64943 .24606 .64581 .24639 Mtetra
.832 .739 .762 r
.64581 .24639 .64943 .24606 .6525 .2399 .64889 .24023 Mtetra
.827 .774 .802 r
.64889 .24023 .6525 .2399 .65561 .23506 .652 .23538 Mtetra
.808 .83 .867 r
.652 .23538 .65561 .23506 .65876 .23161 .65515 .23193 Mtetra
.716 .906 .962 r
.65515 .23193 .65876 .23161 .66196 .2296 .65835 .22992 Mtetra
.231 .749 .829 r
.65835 .22992 .66196 .2296 .66521 .22902 .6616 .22934 Mtetra
.434 0 0 r
.6616 .22934 .66521 .22902 .66851 .22985 .6649 .23017 Mtetra
.645 .189 .154 r
.6649 .23017 .66851 .22985 .67186 .23201 .66824 .23233 Mtetra
.713 .313 .289 r
.66824 .23233 .67186 .23201 .67526 .2354 .67164 .23573 Mtetra
.742 .375 .356 r
.67164 .23573 .67526 .2354 .67871 .2399 .67509 .24023 Mtetra
.758 .41 .394 r
.67509 .24023 .67871 .2399 .68221 .24534 .67858 .24568 Mtetra
.766 .43 .417 r
.67858 .24568 .68221 .24534 .68574 .25154 .68211 .25189 Mtetra
.771 .443 .43 r
.68211 .25189 .68574 .25154 .68931 .25832 .68568 .25867 Mtetra
.774 .449 .437 r
.68568 .25867 .68931 .25832 .69291 .26545 .68927 .26581 Mtetra
.775 .451 .439 r
.68927 .26581 .69291 .26545 .69653 .27272 .69289 .27309 Mtetra
.774 .449 .437 r
.69289 .27309 .69653 .27272 .70017 .2799 .69651 .28027 Mtetra
.79 .5 .498 r
.25241 .56184 .25604 .56239 .25833 .56948 .2547 .56894 Mtetra
.79 .502 .5 r
.2547 .56894 .25833 .56948 .26063 .57672 .25699 .57618 Mtetra
.79 .501 .499 r
.25699 .57618 .26063 .57672 .26295 .5839 .2593 .58337 Mtetra
.789 .496 .493 r
.2593 .58337 .26295 .5839 .26528 .5908 .26162 .59027 Mtetra
.787 .488 .482 r
.26162 .59027 .26528 .5908 .26765 .59721 .26398 .59668 Mtetra
.784 .474 .463 r
.26398 .59668 .26765 .59721 .27005 .60291 .26638 .60239 Mtetra
.778 .449 .43 r
.26638 .60239 .27005 .60291 .2725 .60773 .26883 .60721 Mtetra
.765 .404 .371 r
.26883 .60721 .2725 .60773 .275 .61149 .27132 .61097 Mtetra
.727 .303 .241 r
.27132 .61097 .275 .61149 .27755 .61404 .27387 .61353 Mtetra
.549 0 0 r
.27387 .61353 .27755 .61404 .28015 .61528 .27647 .61476 Mtetra
.287 .744 .954 r
.27647 .61476 .28015 .61528 .28282 .61512 .27913 .6146 Mtetra
.695 .796 .927 r
.27913 .6146 .28282 .61512 .28554 .61351 .28185 .61299 Mtetra
.762 .736 .829 r
.28185 .61299 .28554 .61351 .28831 .61047 .28463 .60994 Mtetra
.78 .701 .776 r
.28463 .60994 .28831 .61047 .29114 .60602 .28745 .60549 Mtetra
.788 .68 .745 r
.28745 .60549 .29114 .60602 .29401 .60025 .29033 .59972 Mtetra
.791 .667 .726 r
.29033 .59972 .29401 .60025 .29692 .59328 .29324 .59274 Mtetra
.793 .658 .713 r
.29324 .59274 .29692 .59328 .29987 .58527 .2962 .58472 Mtetra
.794 .652 .705 r
.2962 .58472 .29987 .58527 .30285 .5764 .29917 .57585 Mtetra
.795 .648 .699 r
.29917 .57585 .30285 .5764 .30584 .56689 .30217 .56633 Mtetra
.795 .646 .696 r
.30217 .56633 .30584 .56689 .30884 .55697 .30518 .55641 Mtetra
.796 .645 .695 r
.30518 .55641 .30884 .55697 .31184 .5469 .30818 .54633 Mtetra
.796 .645 .696 r
.30818 .54633 .31184 .5469 .31484 .53692 .31118 .53635 Mtetra
.795 .647 .698 r
.31118 .53635 .31484 .53692 .31782 .5273 .31417 .52671 Mtetra
.795 .65 .703 r
.31417 .52671 .31782 .5273 .32078 .51826 .31713 .51767 Mtetra
.793 .655 .71 r
.31713 .51767 .32078 .51826 .32371 .51003 .32007 .50943 Mtetra
.792 .663 .722 r
.32007 .50943 .32371 .51003 .32661 .50281 .32297 .50221 Mtetra
.788 .675 .739 r
.32297 .50221 .32661 .50281 .32948 .49675 .32584 .49615 Mtetra
.782 .694 .767 r
.32584 .49615 .32948 .49675 .33231 .492 .32867 .49139 Mtetra
.766 .723 .813 r
.32867 .49139 .33231 .492 .3351 .48862 .33146 .48801 Mtetra
.719 .773 .895 r
.33146 .48801 .3351 .48862 .33785 .48665 .33422 .48603 Mtetra
.499 .806 1 r
.33422 .48603 .33785 .48665 .34058 .48606 .33694 .48545 Mtetra
.305 0 0 r
.33694 .48545 .34058 .48606 .34327 .4868 .33963 .48619 Mtetra
.671 .18 .073 r
.33963 .48619 .34327 .4868 .34594 .48874 .3423 .48813 Mtetra
.745 .333 .269 r
.3423 .48813 .34594 .48874 .34858 .49171 .34494 .4911 Mtetra
.767 .394 .349 r
.34494 .4911 .34858 .49171 .35122 .49549 .34757 .49488 Mtetra
.776 .421 .385 r
.34757 .49488 .35122 .49549 .35385 .49983 .3502 .49922 Mtetra
.779 .432 .399 r
.3502 .49922 .35385 .49983 .35649 .50444 .35283 .50384 Mtetra
.778 .43 .397 r
.35283 .50384 .35649 .50444 .35913 .50903 .35547 .50843 Mtetra
.774 .415 .377 r
.35547 .50843 .35913 .50903 .3618 .51328 .35813 .51268 Mtetra
.762 .38 .33 r
.35813 .51268 .3618 .51328 .36449 .5169 .36081 .5163 Mtetra
.73 .298 .225 r
.36081 .5163 .36449 .5169 .3672 .51961 .36353 .51901 Mtetra
.604 .07 0 r
.36353 .51901 .3672 .51961 .36995 .52118 .36627 .52058 Mtetra
.028 .586 .812 r
.36627 .52058 .36995 .52118 .37274 .52143 .36906 .52083 Mtetra
.635 .811 .967 r
.36906 .52083 .37274 .52143 .37556 .52026 .37188 .51966 Mtetra
.748 .753 .857 r
.37188 .51966 .37556 .52026 .37841 .51762 .37473 .51702 Mtetra
.776 .713 .793 r
.37473 .51702 .37841 .51762 .3813 .51358 .37762 .51298 Mtetra
.787 .69 .758 r
.37762 .51298 .3813 .51358 .38421 .50827 .38053 .50766 Mtetra
.791 .676 .737 r
.38053 .50766 .38421 .50827 .38714 .50191 .38347 .5013 Mtetra
.794 .669 .726 r
.38347 .5013 .38714 .50191 .39009 .4948 .38642 .49418 Mtetra
.795 .665 .72 r
.38642 .49418 .39009 .4948 .39304 .48727 .38937 .48665 Mtetra
.38937 .48665 .39304 .48727 .39599 .47971 .39233 .47908 Mtetra
.794 .668 .724 r
.39233 .47908 .39599 .47971 .39894 .4725 .39527 .47187 Mtetra
.792 .675 .735 r
.39527 .47187 .39894 .4725 .40187 .46602 .39821 .46538 Mtetra
.787 .688 .755 r
.39821 .46538 .40187 .46602 .40478 .46057 .40112 .45993 Mtetra
.777 .71 .789 r
.40112 .45993 .40478 .46057 .40768 .45641 .40402 .45577 Mtetra
.75 .749 .851 r
.40402 .45577 .40768 .45641 .41055 .45368 .40689 .45303 Mtetra
.649 .804 .957 r
.40689 .45303 .41055 .45368 .41341 .4524 .40975 .45175 Mtetra
.19 .686 .918 r
.40975 .45175 .41341 .4524 .41626 .45244 .41259 .45179 Mtetra
.453 0 0 r
.41259 .45179 .41626 .45244 .41909 .45355 .41543 .4529 Mtetra
.635 .113 0 r
.41543 .4529 .41909 .45355 .42193 .45535 .41826 .4547 Mtetra
.665 .165 .048 r
.41826 .4547 .42193 .45535 .42476 .45737 .4211 .45672 Mtetra
.617 .085 0 r
.4211 .45672 .42476 .45737 .42762 .45908 .42394 .45843 Mtetra
.352 0 0 r
.42394 .45843 .42762 .45908 .43048 .45998 .42681 .45933 Mtetra
.391 .777 .99 r
.42681 .45933 .43048 .45998 .43337 .45964 .4297 .45899 Mtetra
.702 .787 .917 r
.4297 .45899 .43337 .45964 .43628 .45783 .43261 .45718 Mtetra
.763 .735 .827 r
.43261 .45718 .43628 .45783 .43921 .45456 .43553 .4539 Mtetra
.781 .707 .782 r
.43553 .4539 .43921 .45456 .44215 .4501 .43848 .44944 Mtetra
.786 .696 .766 r
.43848 .44944 .44215 .4501 .4451 .44503 .44143 .44437 Mtetra
.784 .699 .77 r
.44143 .44437 .4451 .44503 .44805 .44013 .44438 .43947 Mtetra
.774 .718 .8 r
.44438 .43947 .44805 .44013 .45099 .4362 .44732 .43553 Mtetra
.737 .763 .874 r
.44732 .43553 .45099 .4362 .45392 .43378 .45025 .4331 Mtetra
.59 .811 .984 r
.45025 .4331 .45392 .43378 .45685 .43281 .45318 .43213 Mtetra
.455 .794 .999 r
.45318 .43213 .45685 .43281 .45978 .43232 .45611 .43164 Mtetra
.694 .789 .923 r
.45611 .43164 .45978 .43232 .46272 .43058 .45905 .4299 Mtetra
.757 .743 .841 r
.45905 .4299 .46272 .43058 .46568 .42756 .462 .42688 Mtetra
.694 .789 .923 r
.462 .42688 .46568 .42756 .46863 .42581 .46495 .42513 Mtetra
.457 .794 .999 r
.46495 .42513 .46863 .42581 .47158 .42531 .4679 .42463 Mtetra
.591 .811 .984 r
.4679 .42463 .47158 .42531 .47454 .42433 .47086 .42365 Mtetra
.737 .763 .874 r
.47086 .42365 .47454 .42433 .4775 .42188 .47383 .4212 Mtetra
.775 .719 .801 r
.47383 .4212 .4775 .42188 .48048 .41791 .4768 .41722 Mtetra
.785 .7 .771 r
.4768 .41722 .48048 .41791 .48346 .41297 .47978 .41228 Mtetra
.786 .698 .766 r
.47978 .41228 .48346 .41297 .48644 .40785 .48276 .40716 Mtetra
.781 .708 .783 r
.48276 .40716 .48644 .40785 .48942 .40334 .48575 .40264 Mtetra
.763 .735 .827 r
.48575 .40264 .48942 .40334 .4924 .40001 .48873 .3993 Mtetra
.703 .784 .915 r
.48873 .3993 .4924 .40001 .49539 .39813 .49171 .39743 Mtetra
.421 .783 .995 r
.49171 .39743 .49539 .39813 .49838 .39773 .4947 .39703 Mtetra
.284 0 0 r
.4947 .39703 .49838 .39773 .50138 .39857 .4977 .39786 Mtetra
.584 .032 0 r
.4977 .39786 .50138 .39857 .50438 .40023 .5007 .39952 Mtetra
.642 .12 0 r
.5007 .39952 .50438 .40023 .5074 .40221 .50372 .4015 Mtetra
.606 .063 0 r
.50372 .4015 .5074 .40221 .51042 .40398 .50674 .40328 Mtetra
.398 0 0 r
.50674 .40328 .51042 .40398 .51345 .40506 .50977 .40436 Mtetra
.231 .705 .939 r
.50977 .40436 .51345 .40506 .51649 .40505 .5128 .40434 Mtetra
.649 .804 .957 r
.5128 .40434 .51649 .40505 .51952 .40368 .51583 .40298 Mtetra
.75 .753 .855 r
.51583 .40298 .51952 .40368 .52255 .40083 .51886 .40012 Mtetra
.779 .715 .792 r
.51886 .40012 .52255 .40083 .52558 .39652 .52189 .39581 Mtetra
.791 .693 .757 r
.52189 .39581 .52558 .39652 .5286 .39089 .52492 .39017 Mtetra
.796 .68 .736 r
.52492 .39017 .5286 .39089 .53162 .38419 .52794 .38347 Mtetra
.798 .672 .725 r
.52794 .38347 .53162 .38419 .53463 .37677 .53095 .37604 Mtetra
.799 .669 .72 r
.53095 .37604 .53463 .37677 .53764 .369 .53396 .36826 Mtetra
.799 .669 .721 r
.53396 .36826 .53764 .369 .54064 .36126 .53697 .36052 Mtetra
.798 .673 .726 r
.53697 .36052 .54064 .36126 .54365 .35396 .53998 .35321 Mtetra
.795 .681 .738 r
.53998 .35321 .54365 .35396 .54666 .34741 .54299 .34666 Mtetra
.79 .694 .76 r
.54299 .34666 .54666 .34741 .54969 .34192 .54602 .34116 Mtetra
.778 .716 .795 r
.54602 .34116 .54969 .34192 .55272 .33769 .54906 .33693 Mtetra
.748 .752 .856 r
.54906 .33693 .55272 .33769 .55578 .33486 .55211 .3341 Mtetra
.648 .8 .955 r
.55211 .3341 .55578 .33486 .55885 .33348 .55518 .33272 Mtetra
.212 .691 .934 r
.55518 .33272 .55885 .33348 .56195 .33353 .55828 .33277 Mtetra
.485 0 0 r
.55828 .33277 .56195 .33353 .56507 .33491 .56139 .33415 Mtetra
.695 .207 .083 r
.56139 .33415 .56507 .33491 .56821 .33745 .56453 .33669 Mtetra
.75 .321 .231 r
.56453 .33669 .56821 .33745 .57137 .34093 .5677 .34017 Mtetra
.769 .369 .295 r
.5677 .34017 .57137 .34093 .57456 .34507 .57088 .34432 Mtetra
.777 .389 .322 r
.57088 .34432 .57456 .34507 .57776 .34959 .57408 .34884 Mtetra
.777 .392 .325 r
.57408 .34884 .57776 .34959 .58098 .35418 .57729 .35342 Mtetra
.772 .378 .306 r
.57729 .35342 .58098 .35418 .5842 .35851 .58051 .35776 Mtetra
.758 .341 .257 r
.58051 .35776 .5842 .35851 .58743 .36229 .58373 .36154 Mtetra
.722 .259 .151 r
.58373 .36154 .58743 .36229 .59066 .36526 .58695 .36451 Mtetra
.604 .058 0 r
.58695 .36451 .59066 .36526 .59387 .36715 .59017 .36641 Mtetra
0 .451 .693 r
.59017 .36641 .59387 .36715 .59708 .3678 .59337 .36705 Mtetra
.521 .804 .997 r
.59337 .36705 .59708 .3678 .60026 .36706 .59655 .36631 Mtetra
.718 .779 .9 r
.59655 .36631 .60026 .36706 .60342 .36485 .59971 .36409 Mtetra
.77 .735 .821 r
.59971 .36409 .60342 .36485 .60656 .36114 .60285 .36038 Mtetra
.789 .705 .772 r
.60285 .36038 .60656 .36114 .60967 .35598 .60597 .35522 Mtetra
.797 .687 .742 r
.60597 .35522 .60967 .35598 .61276 .34945 .60905 .34868 Mtetra
.802 .674 .723 r
.60905 .34868 .61276 .34945 .61582 .34169 .61211 .34092 Mtetra
.804 .665 .71 r
.61211 .34092 .61582 .34169 .61885 .3329 .61515 .33212 Mtetra
.806 .66 .701 r
.61515 .33212 .61885 .3329 .62186 .32327 .61817 .32248 Mtetra
.807 .656 .696 r
.61817 .32248 .62186 .32327 .62485 .31306 .62116 .31226 Mtetra
.807 .654 .693 r
.62116 .31226 .62485 .31306 .62783 .30251 .62415 .30171 Mtetra
.807 .654 .692 r
.62415 .30171 .62783 .30251 .63081 .2919 .62713 .29109 Mtetra
.807 .655 .693 r
.62713 .29109 .63081 .2919 .63378 .28148 .63011 .28067 Mtetra
.807 .657 .697 r
.63011 .28067 .63378 .28148 .63676 .2715 .6331 .27068 Mtetra
.805 .661 .703 r
.6331 .27068 .63676 .2715 .63976 .26219 .6361 .26136 Mtetra
.804 .667 .713 r
.6361 .26136 .63976 .26219 .64277 .25376 .63911 .25293 Mtetra
.8 .676 .727 r
.63911 .25293 .64277 .25376 .64581 .24639 .64216 .24555 Mtetra
.795 .689 .748 r
.64216 .24555 .64581 .24639 .64889 .24023 .64523 .23938 Mtetra
.784 .709 .78 r
.64523 .23938 .64889 .24023 .652 .23538 .64834 .23453 Mtetra
.762 .738 .831 r
.64834 .23453 .652 .23538 .65515 .23193 .6515 .23108 Mtetra
.702 .779 .912 r
.6515 .23108 .65515 .23193 .65835 .22992 .6547 .22906 Mtetra
.481 .788 .998 r
.6547 .22906 .65835 .22992 .6616 .22934 .65794 .22849 Mtetra
.19 0 0 r
.65794 .22849 .6616 .22934 .6649 .23017 .66124 .22931 Mtetra
.628 .087 0 r
.66124 .22931 .6649 .23017 .66824 .23233 .66459 .23148 Mtetra
.74 .284 .169 r
.66459 .23148 .66824 .23233 .67164 .23573 .66798 .23487 Mtetra
.775 .369 .282 r
.66798 .23487 .67164 .23573 .67509 .24023 .67142 .23938 Mtetra
.79 .412 .34 r
.67142 .23938 .67509 .24023 .67858 .24568 .67491 .24482 Mtetra
.797 .436 .374 r
.67491 .24482 .67858 .24568 .68211 .25189 .67843 .25104 Mtetra
.801 .45 .393 r
.67843 .25104 .68211 .25189 .68568 .25867 .68199 .25783 Mtetra
.803 .457 .403 r
.68199 .25783 .68568 .25867 .68927 .26581 .68558 .26497 Mtetra
.803 .46 .406 r
.68558 .26497 .68927 .26581 .69289 .27309 .68919 .27225 Mtetra
.803 .457 .402 r
.68919 .27225 .69289 .27309 .69651 .28027 .69281 .27944 Mtetra
.824 .518 .472 r
.24883 .55987 .25241 .56184 .2547 .56894 .25111 .56696 Mtetra
.823 .52 .475 r
.25111 .56696 .2547 .56894 .25699 .57618 .2534 .57421 Mtetra
.824 .518 .473 r
.2534 .57421 .25699 .57618 .2593 .58337 .2557 .58139 Mtetra
.824 .514 .465 r
.2557 .58139 .2593 .58337 .26162 .59027 .25802 .58829 Mtetra
.825 .505 .448 r
.25802 .58829 .26162 .59027 .26398 .59668 .26037 .5947 Mtetra
.826 .49 .42 r
.26037 .5947 .26398 .59668 .26638 .60239 .26277 .60041 Mtetra
.825 .462 .368 r
.26277 .60041 .26638 .60239 .26883 .60721 .2652 .60523 Mtetra
.814 .4 .261 r
.2652 .60523 .26883 .60721 .27132 .61097 .26769 .60899 Mtetra
.741 .228 0 r
.26769 .60899 .27132 .61097 .27387 .61353 .27024 .61154 Mtetra
0 .326 .727 r
.27024 .61154 .27387 .61353 .27647 .61476 .27284 .61278 Mtetra
.478 .665 .945 r
.27284 .61278 .27647 .61476 .27913 .6146 .2755 .61261 Mtetra
.659 .672 .851 r
.2755 .61261 .27913 .6146 .28185 .61299 .27821 .611 Mtetra
.716 .656 .79 r
.27821 .611 .28185 .61299 .28463 .60994 .28099 .60795 Mtetra
.74 .645 .754 r
.28099 .60795 .28463 .60994 .28745 .60549 .28382 .6035 Mtetra
.754 .636 .731 r
.28382 .6035 .28745 .60549 .29033 .59972 .28669 .59772 Mtetra
.762 .631 .716 r
.28669 .59772 .29033 .59972 .29324 .59274 .28961 .59074 Mtetra
.767 .627 .706 r
.28961 .59074 .29324 .59274 .2962 .58472 .29256 .58272 Mtetra
.77 .624 .699 r
.29256 .58272 .2962 .58472 .29917 .57585 .29555 .57384 Mtetra
.772 .622 .694 r
.29555 .57384 .29917 .57585 .30217 .56633 .29854 .56432 Mtetra
.773 .621 .691 r
.29854 .56432 .30217 .56633 .30518 .55641 .30155 .5544 Mtetra
.774 .621 .69 r
.30155 .5544 .30518 .55641 .30818 .54633 .30457 .54431 Mtetra
.773 .621 .691 r
.30457 .54431 .30818 .54633 .31118 .53635 .30757 .53433 Mtetra
.772 .622 .693 r
.30757 .53433 .31118 .53635 .31417 .52671 .31056 .52469 Mtetra
.771 .623 .697 r
.31056 .52469 .31417 .52671 .31713 .51767 .31353 .51564 Mtetra
.768 .626 .703 r
.31353 .51564 .31713 .51767 .32007 .50943 .31647 .50741 Mtetra
.763 .629 .712 r
.31647 .50741 .32007 .50943 .32297 .50221 .31937 .50018 Mtetra
.756 .634 .726 r
.31937 .50018 .32297 .50221 .32584 .49615 .32224 .49412 Mtetra
.744 .642 .747 r
.32224 .49412 .32584 .49615 .32867 .49139 .32507 .48935 Mtetra
.722 .652 .779 r
.32507 .48935 .32867 .49139 .33146 .48801 .32787 .48597 Mtetra
.677 .665 .831 r
.32787 .48597 .33146 .48801 .33422 .48603 .33062 .48399 Mtetra
.557 .671 .914 r
.33062 .48399 .33422 .48603 .33694 .48545 .33334 .48341 Mtetra
.142 .541 .923 r
.33334 .48341 .33694 .48545 .33963 .48619 .33603 .48415 Mtetra
.56 0 0 r
.33603 .48415 .33963 .48619 .3423 .48813 .33869 .48608 Mtetra
.772 .283 .061 r
.33869 .48608 .3423 .48813 .34494 .4911 .34133 .48905 Mtetra
.813 .384 .225 r
.34133 .48905 .34494 .4911 .34757 .49488 .34396 .49283 Mtetra
.823 .424 .293 r
.34396 .49283 .34757 .49488 .3502 .49922 .34658 .49717 Mtetra
.826 .439 .318 r
.34658 .49717 .3502 .49922 .35283 .50384 .3492 .50178 Mtetra
.826 .436 .314 r
.3492 .50178 .35283 .50384 .35547 .50843 .35184 .50637 Mtetra
.822 .416 .279 r
.35184 .50637 .35547 .50843 .35813 .51268 .35449 .51062 Mtetra
.806 .362 .189 r
.35449 .51062 .35813 .51268 .36081 .5163 .35717 .51424 Mtetra
.737 .218 0 r
.35717 .51424 .36081 .5163 .36353 .51901 .35988 .51695 Mtetra
.358 0 0 r
.35988 .51695 .36353 .51901 .36627 .52058 .36262 .51852 Mtetra
.363 .632 .957 r
.36262 .51852 .36627 .52058 .36906 .52083 .36541 .51877 Mtetra
.623 .674 .878 r
.36541 .51877 .36906 .52083 .37188 .51966 .36822 .51759 Mtetra
.701 .661 .807 r
.36822 .51759 .37188 .51966 .37473 .51702 .37108 .51495 Mtetra
.733 .649 .765 r
.37108 .51495 .37473 .51702 .37762 .51298 .37396 .5109 Mtetra
.75 .641 .74 r
.37396 .5109 .37762 .51298 .38053 .50766 .37688 .50559 Mtetra
.758 .635 .725 r
.37688 .50559 .38053 .50766 .38347 .5013 .37982 .49922 Mtetra
.763 .632 .715 r
.37982 .49922 .38347 .5013 .38642 .49418 .38277 .4921 Mtetra
.765 .63 .711 r
.38277 .4921 .38642 .49418 .38937 .48665 .38573 .48456 Mtetra
.766 .63 .711 r
.38573 .48456 .38937 .48665 .39233 .47908 .38868 .47699 Mtetra
.764 .632 .714 r
.38868 .47699 .39233 .47908 .39527 .47187 .39163 .46978 Mtetra
.759 .635 .723 r
.39163 .46978 .39527 .47187 .39821 .46538 .39457 .46328 Mtetra
.751 .64 .738 r
.39457 .46328 .39821 .46538 .40112 .45993 .39748 .45783 Mtetra
.735 .648 .763 r
.39748 .45783 .40112 .45993 .40402 .45577 .40038 .45367 Mtetra
.703 .66 .804 r
.40038 .45367 .40402 .45577 .40689 .45303 .40325 .45093 Mtetra
.63 .672 .871 r
.40325 .45093 .40689 .45303 .40975 .45175 .40611 .44964 Mtetra
.431 .648 .95 r
.40611 .44964 .40975 .45175 .41259 .45179 .40895 .44968 Mtetra
0 .439 .846 r
.40895 .44968 .41259 .45179 .41543 .4529 .41178 .45079 Mtetra
.441 0 0 r
.41178 .45079 .41543 .4529 .41826 .4547 .41461 .45259 Mtetra
.534 0 0 r
.41461 .45259 .41826 .4547 .4211 .45672 .41744 .45461 Mtetra
.389 0 0 r
.41744 .45461 .4211 .45672 .42394 .45843 .42028 .45632 Mtetra
.092 .513 .905 r
.42028 .45632 .42394 .45843 .42681 .45933 .42315 .45721 Mtetra
.512 .665 .931 r
.42315 .45721 .42681 .45933 .4297 .45899 .42603 .45687 Mtetra
.664 .669 .845 r
.42603 .45687 .4297 .45899 .43261 .45718 .42894 .45506 Mtetra
.717 .656 .788 r
.42894 .45506 .43261 .45718 .43553 .4539 .43187 .45178 Mtetra
.739 .647 .758 r
.43187 .45178 .43553 .4539 .43848 .44944 .43481 .44731 Mtetra
.747 .643 .746 r
.43481 .44731 .43848 .44944 .44143 .44437 .43776 .44224 Mtetra
.745 .644 .749 r
.43776 .44224 .44143 .44437 .44438 .43947 .44071 .43734 Mtetra
.731 .651 .77 r
.44071 .43734 .44438 .43947 .44732 .43553 .44366 .4334 Mtetra
.691 .663 .818 r
.44366 .4334 .44732 .43553 .45025 .4331 .44659 .43097 Mtetra
.599 .672 .891 r
.44659 .43097 .45025 .4331 .45318 .43213 .44951 .42999 Mtetra
.537 .668 .921 r
.44951 .42999 .45318 .43213 .45611 .43164 .45244 .4295 Mtetra
.658 .669 .849 r
.45244 .4295 .45611 .43164 .45905 .4299 .45538 .42776 Mtetra
.71 .659 .797 r
.45538 .42776 .45905 .4299 .462 .42688 .45833 .42473 Mtetra
.659 .669 .849 r
.45833 .42473 .462 .42688 .46495 .42513 .46128 .42298 Mtetra
.538 .668 .921 r
.46128 .42298 .46495 .42513 .4679 .42463 .46423 .42248 Mtetra
.599 .672 .891 r
.46423 .42248 .4679 .42463 .47086 .42365 .46718 .42149 Mtetra
.691 .664 .818 r
.46718 .42149 .47086 .42365 .47383 .4212 .47015 .41904 Mtetra
.731 .651 .771 r
.47015 .41904 .47383 .4212 .4768 .41722 .47312 .41506 Mtetra
.745 .645 .749 r
.47312 .41506 .4768 .41722 .47978 .41228 .47611 .41011 Mtetra
.747 .644 .746 r
.47611 .41011 .47978 .41228 .48276 .40716 .47909 .40499 Mtetra
.739 .648 .758 r
.47909 .40499 .48276 .40716 .48575 .40264 .48207 .40048 Mtetra
.717 .656 .788 r
.48207 .40048 .48575 .40264 .48873 .3993 .48506 .39713 Mtetra
.664 .668 .844 r
.48506 .39713 .48873 .3993 .49171 .39743 .48804 .39525 Mtetra
.522 .665 .926 r
.48804 .39525 .49171 .39743 .4947 .39703 .49103 .39485 Mtetra
.152 .54 .924 r
.49103 .39485 .4947 .39703 .4977 .39786 .49402 .39568 Mtetra
0 .253 .665 r
.49402 .39568 .4977 .39786 .5007 .39952 .49702 .39734 Mtetra
.455 0 0 r
.49702 .39734 .5007 .39952 .50372 .4015 .50003 .39932 Mtetra
0 .209 .616 r
.50003 .39932 .50372 .4015 .50674 .40328 .50305 .40109 Mtetra
.034 .478 .881 r
.50305 .40109 .50674 .40328 .50977 .40436 .50607 .40217 Mtetra
.445 .65 .946 r
.50607 .40217 .50977 .40436 .5128 .40434 .5091 .40215 Mtetra
.63 .672 .871 r
.5091 .40215 .5128 .40434 .51583 .40298 .51213 .40078 Mtetra
.703 .661 .806 r
.51213 .40078 .51583 .40298 .51886 .40012 .51516 .39793 Mtetra
.736 .65 .764 r
.51516 .39793 .51886 .40012 .52189 .39581 .51819 .39361 Mtetra
.752 .642 .739 r
.51819 .39361 .52189 .39581 .52492 .39017 .52122 .38797 Mtetra
.761 .637 .723 r
.52122 .38797 .52492 .39017 .52794 .38347 .52424 .38127 Mtetra
.766 .634 .715 r
.52424 .38127 .52794 .38347 .53095 .37604 .52726 .37383 Mtetra
.768 .633 .711 r
.52726 .37383 .53095 .37604 .53396 .36826 .53027 .36605 Mtetra
.53027 .36605 .53396 .36826 .53697 .36052 .53328 .35831 Mtetra
.766 .634 .716 r
.53328 .35831 .53697 .36052 .53998 .35321 .53629 .35099 Mtetra
.76 .638 .725 r
.53629 .35099 .53998 .35321 .54299 .34666 .53931 .34444 Mtetra
.751 .643 .741 r
.53931 .34444 .54299 .34666 .54602 .34116 .54233 .33894 Mtetra
.734 .651 .766 r
.54233 .33894 .54602 .34116 .54906 .33693 .54537 .3347 Mtetra
.701 .661 .807 r
.54537 .3347 .54906 .33693 .55211 .3341 .54842 .33187 Mtetra
.629 .67 .87 r
.54842 .33187 .55211 .3341 .55518 .33272 .5515 .33049 Mtetra
.433 .644 .946 r
.5515 .33049 .55518 .33272 .55828 .33277 .55459 .33054 Mtetra
0 .395 .814 r
.55459 .33054 .55828 .33277 .56139 .33415 .5577 .33191 Mtetra
.609 .044 0 r
.5577 .33191 .56139 .33415 .56453 .33669 .56084 .33445 Mtetra
.764 .259 .003 r
.56084 .33445 .56453 .33669 .5677 .34017 .56399 .33793 Mtetra
.805 .343 .136 r
.56399 .33793 .5677 .34017 .57088 .34432 .56717 .34207 Mtetra
.817 .375 .188 r
.56717 .34207 .57088 .34432 .57408 .34884 .57036 .34659 Mtetra
.818 .378 .194 r
.57036 .34659 .57408 .34884 .57729 .35342 .57357 .35118 Mtetra
.81 .356 .158 r
.57357 .35118 .57729 .35342 .58051 .35776 .57678 .35551 Mtetra
.783 .295 .059 r
.57678 .35551 .58051 .35776 .58373 .36154 .58 .35929 Mtetra
.689 .144 0 r
.58 .35929 .58373 .36154 .58695 .36451 .58322 .36225 Mtetra
0 .212 .624 r
.58322 .36225 .58695 .36451 .59017 .36641 .58643 .36415 Mtetra
.256 .585 .946 r
.58643 .36415 .59017 .36641 .59337 .36705 .58963 .36479 Mtetra
.565 .669 .908 r
.58963 .36479 .59337 .36705 .59655 .36631 .59281 .36405 Mtetra
.676 .668 .835 r
.59281 .36405 .59655 .36631 .59971 .36409 .59597 .36183 Mtetra
.723 .657 .784 r
.59597 .36183 .59971 .36409 .60285 .36038 .59911 .35812 Mtetra
.747 .647 .75 r
.59911 .35812 .60285 .36038 .60597 .35522 .60222 .35295 Mtetra
.761 .64 .728 r
.60222 .35295 .60597 .35522 .60905 .34868 .60531 .34641 Mtetra
.769 .635 .713 r
.60531 .34641 .60905 .34868 .61211 .34092 .60838 .33865 Mtetra
.775 .631 .702 r
.60838 .33865 .61211 .34092 .61515 .33212 .61142 .32984 Mtetra
.778 .629 .695 r
.61142 .32984 .61515 .33212 .61817 .32248 .61444 .3202 Mtetra
.78 .627 .69 r
.61444 .3202 .61817 .32248 .62116 .31226 .61744 .30998 Mtetra
.782 .626 .688 r
.61744 .30998 .62116 .31226 .62415 .30171 .62043 .29942 Mtetra
.782 .626 .687 r
.62043 .29942 .62415 .30171 .62713 .29109 .62341 .2888 Mtetra
.781 .627 .689 r
.62341 .2888 .62713 .29109 .63011 .28067 .6264 .27837 Mtetra
.78 .628 .692 r
.6264 .27837 .63011 .28067 .6331 .27068 .62939 .26838 Mtetra
.777 .63 .697 r
.62939 .26838 .6331 .27068 .6361 .26136 .63239 .25906 Mtetra
.773 .632 .705 r
.63239 .25906 .6361 .26136 .63911 .25293 .63541 .25062 Mtetra
.767 .636 .716 r
.63541 .25062 .63911 .25293 .64216 .24555 .63846 .24324 Mtetra
.757 .641 .733 r
.63846 .24324 .64216 .24555 .64523 .23938 .64153 .23707 Mtetra
.742 .648 .756 r
.64153 .23707 .64523 .23938 .64834 .23453 .64465 .23221 Mtetra
.716 .657 .79 r
.64465 .23221 .64834 .23453 .6515 .23108 .6478 .22876 Mtetra
.664 .666 .842 r
.6478 .22876 .6515 .23108 .6547 .22906 .651 .22674 Mtetra
.543 .662 .914 r
.651 .22674 .6547 .22906 .65794 .22849 .65424 .22616 Mtetra
.211 .558 .935 r
.65424 .22616 .65794 .22849 .66124 .22931 .65753 .22698 Mtetra
.402 0 0 r
.65753 .22698 .66124 .22931 .66459 .23148 .66088 .22914 Mtetra
.723 .191 0 r
.66088 .22914 .66459 .23148 .66798 .23487 .66426 .23254 Mtetra
.806 .34 .12 r
.66426 .23254 .66798 .23487 .67142 .23938 .6677 .23704 Mtetra
.83 .406 .231 r
.6677 .23704 .67142 .23938 .67491 .24482 .67118 .24249 Mtetra
.838 .44 .29 r
.67118 .24249 .67491 .24482 .67843 .25104 .6747 .2487 Mtetra
.841 .458 .323 r
.6747 .2487 .67843 .25104 .68199 .25783 .67825 .25548 Mtetra
.843 .467 .339 r
.67825 .25548 .68199 .25783 .68558 .26497 .68183 .26263 Mtetra
.843 .469 .344 r
.68183 .26263 .68558 .26497 .68919 .27225 .68543 .2699 Mtetra
.842 .466 .338 r
.68543 .2699 .68919 .27225 .69281 .27944 .68905 .27709 Mtetra
.863 .538 .434 r
.24531 .55647 .24883 .55987 .25111 .56696 .24759 .56355 Mtetra
.862 .539 .438 r
.24759 .56355 .25111 .56696 .2534 .57421 .24987 .57079 Mtetra
.863 .538 .435 r
.24987 .57079 .2534 .57421 .2557 .58139 .25216 .57797 Mtetra
.865 .533 .422 r
.25216 .57797 .2557 .58139 .25802 .58829 .25447 .58487 Mtetra
.869 .524 .396 r
.25447 .58487 .25802 .58829 .26037 .5947 .25682 .59127 Mtetra
.873 .506 .349 r
.25682 .59127 .26037 .5947 .26277 .60041 .25921 .59697 Mtetra
.872 .466 .256 r
.25921 .59697 .26277 .60041 .2652 .60523 .26164 .60179 Mtetra
.833 .361 .046 r
.26164 .60179 .2652 .60523 .26769 .60899 .26412 .60554 Mtetra
.537 .025 0 r
.26412 .60554 .26769 .60899 .27024 .61154 .26666 .60809 Mtetra
.171 .439 .871 r
.26666 .60809 .27024 .61154 .27284 .61278 .26926 .60932 Mtetra
.511 .571 .852 r
.26926 .60932 .27284 .61278 .2755 .61261 .27191 .60915 Mtetra
.629 .596 .797 r
.27191 .60915 .2755 .61261 .27821 .611 .27463 .60754 Mtetra
.682 .602 .76 r
.27463 .60754 .27821 .611 .28099 .60795 .2774 .60449 Mtetra
.71 .602 .735 r
.2774 .60449 .28099 .60795 .28382 .6035 .28023 .60003 Mtetra
.726 .602 .718 r
.28023 .60003 .28382 .6035 .28669 .59772 .28311 .59425 Mtetra
.737 .602 .706 r
.28311 .59425 .28669 .59772 .28961 .59074 .28603 .58727 Mtetra
.744 .601 .698 r
.28603 .58727 .28961 .59074 .29256 .58272 .28898 .57925 Mtetra
.749 .601 .692 r
.28898 .57925 .29256 .58272 .29555 .57384 .29196 .57037 Mtetra
.752 .6 .689 r
.29196 .57037 .29555 .57384 .29854 .56432 .29497 .56085 Mtetra
.754 .6 .686 r
.29497 .56085 .29854 .56432 .30155 .5544 .29798 .55093 Mtetra
.29798 .55093 .30155 .5544 .30457 .54431 .301 .54084 Mtetra
.301 .54084 .30457 .54431 .30757 .53433 .304 .53086 Mtetra
.753 .6 .688 r
.304 .53086 .30757 .53433 .31056 .52469 .307 .52122 Mtetra
.75 .6 .691 r
.307 .52122 .31056 .52469 .31353 .51564 .30997 .51217 Mtetra
.746 .601 .696 r
.30997 .51217 .31353 .51564 .31647 .50741 .31291 .50393 Mtetra
.739 .601 .704 r
.31291 .50393 .31647 .50741 .31937 .50018 .31581 .4967 Mtetra
.729 .602 .715 r
.31581 .4967 .31937 .50018 .32224 .49412 .31869 .49064 Mtetra
.714 .602 .73 r
.31869 .49064 .32224 .49412 .32507 .48935 .32152 .48588 Mtetra
.689 .601 .753 r
.32152 .48588 .32507 .48935 .32787 .48597 .32431 .48249 Mtetra
.645 .597 .786 r
.32431 .48249 .32787 .48597 .33062 .48399 .32706 .48051 Mtetra
.557 .581 .834 r
.32706 .48051 .33062 .48399 .33334 .48341 .32978 .47993 Mtetra
.346 .514 .88 r
.32978 .47993 .33334 .48341 .33603 .48415 .33246 .48066 Mtetra
0 .262 .762 r
.33246 .48066 .33603 .48415 .33869 .48608 .33512 .48259 Mtetra
.647 .129 0 r
.33512 .48259 .33869 .48608 .34133 .48905 .33775 .48556 Mtetra
.814 .329 0 r
.33775 .48556 .34133 .48905 .34396 .49283 .34037 .48933 Mtetra
.854 .403 .121 r
.34037 .48933 .34396 .49283 .34658 .49717 .34299 .49366 Mtetra
.863 .428 .171 r
.34299 .49366 .34658 .49717 .3492 .50178 .34561 .49827 Mtetra
.862 .424 .163 r
.34561 .49827 .3492 .50178 .35184 .50637 .34824 .50285 Mtetra
.847 .388 .093 r
.34824 .50285 .35184 .50637 .35449 .51062 .35089 .5071 Mtetra
.784 .286 0 r
.35089 .5071 .35449 .51062 .35717 .51424 .35356 .51071 Mtetra
.522 .014 0 r
.35356 .51071 .35717 .51424 .35988 .51695 .35627 .51342 Mtetra
.066 .384 .846 r
.35627 .51342 .35988 .51695 .36262 .51852 .35901 .51498 Mtetra
.45 .552 .867 r
.35901 .51498 .36262 .51852 .36541 .51877 .36178 .51523 Mtetra
.601 .591 .813 r
.36178 .51523 .36541 .51877 .36822 .51759 .3646 .51405 Mtetra
.667 .6 .771 r
.3646 .51405 .36822 .51759 .37108 .51495 .36745 .5114 Mtetra
.701 .603 .743 r
.36745 .5114 .37108 .51495 .37396 .5109 .37034 .50735 Mtetra
.72 .603 .725 r
.37034 .50735 .37396 .5109 .37688 .50559 .37325 .50204 Mtetra
.731 .602 .713 r
.37325 .50204 .37688 .50559 .37982 .49922 .37619 .49567 Mtetra
.738 .602 .706 r
.37619 .49567 .37982 .49922 .38277 .4921 .37914 .48855 Mtetra
.741 .602 .702 r
.37914 .48855 .38277 .4921 .38573 .48456 .3821 .48101 Mtetra
.3821 .48101 .38573 .48456 .38868 .47699 .38506 .47344 Mtetra
.739 .602 .705 r
.38506 .47344 .38868 .47699 .39163 .46978 .38801 .46622 Mtetra
.733 .602 .712 r
.38801 .46622 .39163 .46978 .39457 .46328 .39095 .45973 Mtetra
.722 .603 .723 r
.39095 .45973 .39457 .46328 .39748 .45783 .39387 .45428 Mtetra
.703 .602 .741 r
.39387 .45428 .39748 .45783 .40038 .45367 .39676 .45011 Mtetra
.67 .6 .769 r
.39676 .45011 .40038 .